/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/translate/v3beta1/translation_service.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.translate.v3beta1;

/**
 *
 *
 * <pre>
 * State metadata for the batch translation operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.translation.v3beta1.BatchTranslateDocumentMetadata}
 */
public final class BatchTranslateDocumentMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.translation.v3beta1.BatchTranslateDocumentMetadata)
    BatchTranslateDocumentMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchTranslateDocumentMetadata.newBuilder() to construct.
  private BatchTranslateDocumentMetadata(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchTranslateDocumentMetadata() {
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchTranslateDocumentMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.translate.v3beta1.TranslationServiceProto
        .internal_static_google_cloud_translation_v3beta1_BatchTranslateDocumentMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.translate.v3beta1.TranslationServiceProto
        .internal_static_google_cloud_translation_v3beta1_BatchTranslateDocumentMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.class,
            com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * State of the job.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.translation.v3beta1.BatchTranslateDocumentMetadata.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Request is being processed.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    RUNNING(1),
    /**
     *
     *
     * <pre>
     * The batch is processed, and at least one item was successfully processed.
     * </pre>
     *
     * <code>SUCCEEDED = 2;</code>
     */
    SUCCEEDED(2),
    /**
     *
     *
     * <pre>
     * The batch is done and no item was successfully processed.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    FAILED(3),
    /**
     *
     *
     * <pre>
     * Request is in the process of being canceled after caller invoked
     * longrunning.Operations.CancelOperation on the request id.
     * </pre>
     *
     * <code>CANCELLING = 4;</code>
     */
    CANCELLING(4),
    /**
     *
     *
     * <pre>
     * The batch is done after the user has called the
     * longrunning.Operations.CancelOperation. Any records processed before the
     * cancel command are output as specified in the request.
     * </pre>
     *
     * <code>CANCELLED = 5;</code>
     */
    CANCELLED(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Request is being processed.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    public static final int RUNNING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The batch is processed, and at least one item was successfully processed.
     * </pre>
     *
     * <code>SUCCEEDED = 2;</code>
     */
    public static final int SUCCEEDED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The batch is done and no item was successfully processed.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    public static final int FAILED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Request is in the process of being canceled after caller invoked
     * longrunning.Operations.CancelOperation on the request id.
     * </pre>
     *
     * <code>CANCELLING = 4;</code>
     */
    public static final int CANCELLING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The batch is done after the user has called the
     * longrunning.Operations.CancelOperation. Any records processed before the
     * cancel command are output as specified in the request.
     * </pre>
     *
     * <code>CANCELLED = 5;</code>
     */
    public static final int CANCELLED_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return RUNNING;
        case 2:
          return SUCCEEDED;
        case 3:
          return FAILED;
        case 4:
          return CANCELLING;
        case 5:
          return CANCELLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.translation.v3beta1.BatchTranslateDocumentMetadata.State)
  }

  private int bitField0_;
  public static final int STATE_FIELD_NUMBER = 1;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * The state of the operation.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.BatchTranslateDocumentMetadata.State state = 1;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * The state of the operation.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.BatchTranslateDocumentMetadata.State state = 1;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.State getState() {
    com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.State result =
        com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.State.forNumber(state_);
    return result == null
        ? com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.State.UNRECOGNIZED
        : result;
  }

  public static final int TOTAL_PAGES_FIELD_NUMBER = 2;
  private long totalPages_ = 0L;
  /**
   *
   *
   * <pre>
   * Total number of pages to translate in all documents so far. Documents
   * without clear page definition (such as XLSX) are not counted.
   * </pre>
   *
   * <code>int64 total_pages = 2;</code>
   *
   * @return The totalPages.
   */
  @java.lang.Override
  public long getTotalPages() {
    return totalPages_;
  }

  public static final int TRANSLATED_PAGES_FIELD_NUMBER = 3;
  private long translatedPages_ = 0L;
  /**
   *
   *
   * <pre>
   * Number of successfully translated pages in all documents so far. Documents
   * without clear page definition (such as XLSX) are not counted.
   * </pre>
   *
   * <code>int64 translated_pages = 3;</code>
   *
   * @return The translatedPages.
   */
  @java.lang.Override
  public long getTranslatedPages() {
    return translatedPages_;
  }

  public static final int FAILED_PAGES_FIELD_NUMBER = 4;
  private long failedPages_ = 0L;
  /**
   *
   *
   * <pre>
   * Number of pages that failed to process in all documents so far. Documents
   * without clear page definition (such as XLSX) are not counted.
   * </pre>
   *
   * <code>int64 failed_pages = 4;</code>
   *
   * @return The failedPages.
   */
  @java.lang.Override
  public long getFailedPages() {
    return failedPages_;
  }

  public static final int TOTAL_BILLABLE_PAGES_FIELD_NUMBER = 5;
  private long totalBillablePages_ = 0L;
  /**
   *
   *
   * <pre>
   * Number of billable pages in documents with clear page definition (such as
   * PDF, DOCX, PPTX) so far.
   * </pre>
   *
   * <code>int64 total_billable_pages = 5;</code>
   *
   * @return The totalBillablePages.
   */
  @java.lang.Override
  public long getTotalBillablePages() {
    return totalBillablePages_;
  }

  public static final int TOTAL_CHARACTERS_FIELD_NUMBER = 6;
  private long totalCharacters_ = 0L;
  /**
   *
   *
   * <pre>
   * Total number of characters (Unicode codepoints) in all documents so far.
   * </pre>
   *
   * <code>int64 total_characters = 6;</code>
   *
   * @return The totalCharacters.
   */
  @java.lang.Override
  public long getTotalCharacters() {
    return totalCharacters_;
  }

  public static final int TRANSLATED_CHARACTERS_FIELD_NUMBER = 7;
  private long translatedCharacters_ = 0L;
  /**
   *
   *
   * <pre>
   * Number of successfully translated characters (Unicode codepoints) in all
   * documents so far.
   * </pre>
   *
   * <code>int64 translated_characters = 7;</code>
   *
   * @return The translatedCharacters.
   */
  @java.lang.Override
  public long getTranslatedCharacters() {
    return translatedCharacters_;
  }

  public static final int FAILED_CHARACTERS_FIELD_NUMBER = 8;
  private long failedCharacters_ = 0L;
  /**
   *
   *
   * <pre>
   * Number of characters that have failed to process (Unicode codepoints) in
   * all documents so far.
   * </pre>
   *
   * <code>int64 failed_characters = 8;</code>
   *
   * @return The failedCharacters.
   */
  @java.lang.Override
  public long getFailedCharacters() {
    return failedCharacters_;
  }

  public static final int TOTAL_BILLABLE_CHARACTERS_FIELD_NUMBER = 9;
  private long totalBillableCharacters_ = 0L;
  /**
   *
   *
   * <pre>
   * Number of billable characters (Unicode codepoints) in documents without
   * clear page definition (such as XLSX) so far.
   * </pre>
   *
   * <code>int64 total_billable_characters = 9;</code>
   *
   * @return The totalBillableCharacters.
   */
  @java.lang.Override
  public long getTotalBillableCharacters() {
    return totalBillableCharacters_;
  }

  public static final int SUBMIT_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp submitTime_;
  /**
   *
   *
   * <pre>
   * Time when the operation was submitted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp submit_time = 10;</code>
   *
   * @return Whether the submitTime field is set.
   */
  @java.lang.Override
  public boolean hasSubmitTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Time when the operation was submitted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp submit_time = 10;</code>
   *
   * @return The submitTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getSubmitTime() {
    return submitTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : submitTime_;
  }
  /**
   *
   *
   * <pre>
   * Time when the operation was submitted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp submit_time = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getSubmitTimeOrBuilder() {
    return submitTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : submitTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (state_
        != com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, state_);
    }
    if (totalPages_ != 0L) {
      output.writeInt64(2, totalPages_);
    }
    if (translatedPages_ != 0L) {
      output.writeInt64(3, translatedPages_);
    }
    if (failedPages_ != 0L) {
      output.writeInt64(4, failedPages_);
    }
    if (totalBillablePages_ != 0L) {
      output.writeInt64(5, totalBillablePages_);
    }
    if (totalCharacters_ != 0L) {
      output.writeInt64(6, totalCharacters_);
    }
    if (translatedCharacters_ != 0L) {
      output.writeInt64(7, translatedCharacters_);
    }
    if (failedCharacters_ != 0L) {
      output.writeInt64(8, failedCharacters_);
    }
    if (totalBillableCharacters_ != 0L) {
      output.writeInt64(9, totalBillableCharacters_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(10, getSubmitTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (state_
        != com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
    }
    if (totalPages_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, totalPages_);
    }
    if (translatedPages_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, translatedPages_);
    }
    if (failedPages_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, failedPages_);
    }
    if (totalBillablePages_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, totalBillablePages_);
    }
    if (totalCharacters_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, totalCharacters_);
    }
    if (translatedCharacters_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, translatedCharacters_);
    }
    if (failedCharacters_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(8, failedCharacters_);
    }
    if (totalBillableCharacters_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(9, totalBillableCharacters_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getSubmitTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata other =
        (com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata) obj;

    if (state_ != other.state_) return false;
    if (getTotalPages() != other.getTotalPages()) return false;
    if (getTranslatedPages() != other.getTranslatedPages()) return false;
    if (getFailedPages() != other.getFailedPages()) return false;
    if (getTotalBillablePages() != other.getTotalBillablePages()) return false;
    if (getTotalCharacters() != other.getTotalCharacters()) return false;
    if (getTranslatedCharacters() != other.getTranslatedCharacters()) return false;
    if (getFailedCharacters() != other.getFailedCharacters()) return false;
    if (getTotalBillableCharacters() != other.getTotalBillableCharacters()) return false;
    if (hasSubmitTime() != other.hasSubmitTime()) return false;
    if (hasSubmitTime()) {
      if (!getSubmitTime().equals(other.getSubmitTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + TOTAL_PAGES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalPages());
    hash = (37 * hash) + TRANSLATED_PAGES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTranslatedPages());
    hash = (37 * hash) + FAILED_PAGES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getFailedPages());
    hash = (37 * hash) + TOTAL_BILLABLE_PAGES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalBillablePages());
    hash = (37 * hash) + TOTAL_CHARACTERS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalCharacters());
    hash = (37 * hash) + TRANSLATED_CHARACTERS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTranslatedCharacters());
    hash = (37 * hash) + FAILED_CHARACTERS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getFailedCharacters());
    hash = (37 * hash) + TOTAL_BILLABLE_CHARACTERS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalBillableCharacters());
    if (hasSubmitTime()) {
      hash = (37 * hash) + SUBMIT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getSubmitTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * State metadata for the batch translation operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.translation.v3beta1.BatchTranslateDocumentMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3beta1.BatchTranslateDocumentMetadata)
      com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_BatchTranslateDocumentMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_BatchTranslateDocumentMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.class,
              com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.Builder.class);
    }

    // Construct using
    // com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSubmitTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      state_ = 0;
      totalPages_ = 0L;
      translatedPages_ = 0L;
      failedPages_ = 0L;
      totalBillablePages_ = 0L;
      totalCharacters_ = 0L;
      translatedCharacters_ = 0L;
      failedCharacters_ = 0L;
      totalBillableCharacters_ = 0L;
      submitTime_ = null;
      if (submitTimeBuilder_ != null) {
        submitTimeBuilder_.dispose();
        submitTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_BatchTranslateDocumentMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata
        getDefaultInstanceForType() {
      return com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata build() {
      com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata buildPartial() {
      com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata result =
          new com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.totalPages_ = totalPages_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.translatedPages_ = translatedPages_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.failedPages_ = failedPages_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.totalBillablePages_ = totalBillablePages_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.totalCharacters_ = totalCharacters_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.translatedCharacters_ = translatedCharacters_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.failedCharacters_ = failedCharacters_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.totalBillableCharacters_ = totalBillableCharacters_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.submitTime_ = submitTimeBuilder_ == null ? submitTime_ : submitTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata) {
        return mergeFrom((com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata other) {
      if (other
          == com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.getDefaultInstance())
        return this;
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.getTotalPages() != 0L) {
        setTotalPages(other.getTotalPages());
      }
      if (other.getTranslatedPages() != 0L) {
        setTranslatedPages(other.getTranslatedPages());
      }
      if (other.getFailedPages() != 0L) {
        setFailedPages(other.getFailedPages());
      }
      if (other.getTotalBillablePages() != 0L) {
        setTotalBillablePages(other.getTotalBillablePages());
      }
      if (other.getTotalCharacters() != 0L) {
        setTotalCharacters(other.getTotalCharacters());
      }
      if (other.getTranslatedCharacters() != 0L) {
        setTranslatedCharacters(other.getTranslatedCharacters());
      }
      if (other.getFailedCharacters() != 0L) {
        setFailedCharacters(other.getFailedCharacters());
      }
      if (other.getTotalBillableCharacters() != 0L) {
        setTotalBillableCharacters(other.getTotalBillableCharacters());
      }
      if (other.hasSubmitTime()) {
        mergeSubmitTime(other.getSubmitTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                totalPages_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                translatedPages_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                failedPages_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                totalBillablePages_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                totalCharacters_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                translatedCharacters_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                failedCharacters_ = input.readInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 72:
              {
                totalBillableCharacters_ = input.readInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 82:
              {
                input.readMessage(getSubmitTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * The state of the operation.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.BatchTranslateDocumentMetadata.State state = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * The state of the operation.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.BatchTranslateDocumentMetadata.State state = 1;
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the operation.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.BatchTranslateDocumentMetadata.State state = 1;
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.State getState() {
      com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.State result =
          com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.State.forNumber(state_);
      return result == null
          ? com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The state of the operation.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.BatchTranslateDocumentMetadata.State state = 1;
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(
        com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the operation.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.BatchTranslateDocumentMetadata.State state = 1;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000001);
      state_ = 0;
      onChanged();
      return this;
    }

    private long totalPages_;
    /**
     *
     *
     * <pre>
     * Total number of pages to translate in all documents so far. Documents
     * without clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 total_pages = 2;</code>
     *
     * @return The totalPages.
     */
    @java.lang.Override
    public long getTotalPages() {
      return totalPages_;
    }
    /**
     *
     *
     * <pre>
     * Total number of pages to translate in all documents so far. Documents
     * without clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 total_pages = 2;</code>
     *
     * @param value The totalPages to set.
     * @return This builder for chaining.
     */
    public Builder setTotalPages(long value) {

      totalPages_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total number of pages to translate in all documents so far. Documents
     * without clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 total_pages = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalPages() {
      bitField0_ = (bitField0_ & ~0x00000002);
      totalPages_ = 0L;
      onChanged();
      return this;
    }

    private long translatedPages_;
    /**
     *
     *
     * <pre>
     * Number of successfully translated pages in all documents so far. Documents
     * without clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 translated_pages = 3;</code>
     *
     * @return The translatedPages.
     */
    @java.lang.Override
    public long getTranslatedPages() {
      return translatedPages_;
    }
    /**
     *
     *
     * <pre>
     * Number of successfully translated pages in all documents so far. Documents
     * without clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 translated_pages = 3;</code>
     *
     * @param value The translatedPages to set.
     * @return This builder for chaining.
     */
    public Builder setTranslatedPages(long value) {

      translatedPages_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of successfully translated pages in all documents so far. Documents
     * without clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 translated_pages = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTranslatedPages() {
      bitField0_ = (bitField0_ & ~0x00000004);
      translatedPages_ = 0L;
      onChanged();
      return this;
    }

    private long failedPages_;
    /**
     *
     *
     * <pre>
     * Number of pages that failed to process in all documents so far. Documents
     * without clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 failed_pages = 4;</code>
     *
     * @return The failedPages.
     */
    @java.lang.Override
    public long getFailedPages() {
      return failedPages_;
    }
    /**
     *
     *
     * <pre>
     * Number of pages that failed to process in all documents so far. Documents
     * without clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 failed_pages = 4;</code>
     *
     * @param value The failedPages to set.
     * @return This builder for chaining.
     */
    public Builder setFailedPages(long value) {

      failedPages_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of pages that failed to process in all documents so far. Documents
     * without clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 failed_pages = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailedPages() {
      bitField0_ = (bitField0_ & ~0x00000008);
      failedPages_ = 0L;
      onChanged();
      return this;
    }

    private long totalBillablePages_;
    /**
     *
     *
     * <pre>
     * Number of billable pages in documents with clear page definition (such as
     * PDF, DOCX, PPTX) so far.
     * </pre>
     *
     * <code>int64 total_billable_pages = 5;</code>
     *
     * @return The totalBillablePages.
     */
    @java.lang.Override
    public long getTotalBillablePages() {
      return totalBillablePages_;
    }
    /**
     *
     *
     * <pre>
     * Number of billable pages in documents with clear page definition (such as
     * PDF, DOCX, PPTX) so far.
     * </pre>
     *
     * <code>int64 total_billable_pages = 5;</code>
     *
     * @param value The totalBillablePages to set.
     * @return This builder for chaining.
     */
    public Builder setTotalBillablePages(long value) {

      totalBillablePages_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of billable pages in documents with clear page definition (such as
     * PDF, DOCX, PPTX) so far.
     * </pre>
     *
     * <code>int64 total_billable_pages = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalBillablePages() {
      bitField0_ = (bitField0_ & ~0x00000010);
      totalBillablePages_ = 0L;
      onChanged();
      return this;
    }

    private long totalCharacters_;
    /**
     *
     *
     * <pre>
     * Total number of characters (Unicode codepoints) in all documents so far.
     * </pre>
     *
     * <code>int64 total_characters = 6;</code>
     *
     * @return The totalCharacters.
     */
    @java.lang.Override
    public long getTotalCharacters() {
      return totalCharacters_;
    }
    /**
     *
     *
     * <pre>
     * Total number of characters (Unicode codepoints) in all documents so far.
     * </pre>
     *
     * <code>int64 total_characters = 6;</code>
     *
     * @param value The totalCharacters to set.
     * @return This builder for chaining.
     */
    public Builder setTotalCharacters(long value) {

      totalCharacters_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total number of characters (Unicode codepoints) in all documents so far.
     * </pre>
     *
     * <code>int64 total_characters = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalCharacters() {
      bitField0_ = (bitField0_ & ~0x00000020);
      totalCharacters_ = 0L;
      onChanged();
      return this;
    }

    private long translatedCharacters_;
    /**
     *
     *
     * <pre>
     * Number of successfully translated characters (Unicode codepoints) in all
     * documents so far.
     * </pre>
     *
     * <code>int64 translated_characters = 7;</code>
     *
     * @return The translatedCharacters.
     */
    @java.lang.Override
    public long getTranslatedCharacters() {
      return translatedCharacters_;
    }
    /**
     *
     *
     * <pre>
     * Number of successfully translated characters (Unicode codepoints) in all
     * documents so far.
     * </pre>
     *
     * <code>int64 translated_characters = 7;</code>
     *
     * @param value The translatedCharacters to set.
     * @return This builder for chaining.
     */
    public Builder setTranslatedCharacters(long value) {

      translatedCharacters_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of successfully translated characters (Unicode codepoints) in all
     * documents so far.
     * </pre>
     *
     * <code>int64 translated_characters = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTranslatedCharacters() {
      bitField0_ = (bitField0_ & ~0x00000040);
      translatedCharacters_ = 0L;
      onChanged();
      return this;
    }

    private long failedCharacters_;
    /**
     *
     *
     * <pre>
     * Number of characters that have failed to process (Unicode codepoints) in
     * all documents so far.
     * </pre>
     *
     * <code>int64 failed_characters = 8;</code>
     *
     * @return The failedCharacters.
     */
    @java.lang.Override
    public long getFailedCharacters() {
      return failedCharacters_;
    }
    /**
     *
     *
     * <pre>
     * Number of characters that have failed to process (Unicode codepoints) in
     * all documents so far.
     * </pre>
     *
     * <code>int64 failed_characters = 8;</code>
     *
     * @param value The failedCharacters to set.
     * @return This builder for chaining.
     */
    public Builder setFailedCharacters(long value) {

      failedCharacters_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of characters that have failed to process (Unicode codepoints) in
     * all documents so far.
     * </pre>
     *
     * <code>int64 failed_characters = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailedCharacters() {
      bitField0_ = (bitField0_ & ~0x00000080);
      failedCharacters_ = 0L;
      onChanged();
      return this;
    }

    private long totalBillableCharacters_;
    /**
     *
     *
     * <pre>
     * Number of billable characters (Unicode codepoints) in documents without
     * clear page definition (such as XLSX) so far.
     * </pre>
     *
     * <code>int64 total_billable_characters = 9;</code>
     *
     * @return The totalBillableCharacters.
     */
    @java.lang.Override
    public long getTotalBillableCharacters() {
      return totalBillableCharacters_;
    }
    /**
     *
     *
     * <pre>
     * Number of billable characters (Unicode codepoints) in documents without
     * clear page definition (such as XLSX) so far.
     * </pre>
     *
     * <code>int64 total_billable_characters = 9;</code>
     *
     * @param value The totalBillableCharacters to set.
     * @return This builder for chaining.
     */
    public Builder setTotalBillableCharacters(long value) {

      totalBillableCharacters_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of billable characters (Unicode codepoints) in documents without
     * clear page definition (such as XLSX) so far.
     * </pre>
     *
     * <code>int64 total_billable_characters = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalBillableCharacters() {
      bitField0_ = (bitField0_ & ~0x00000100);
      totalBillableCharacters_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp submitTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        submitTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 10;</code>
     *
     * @return Whether the submitTime field is set.
     */
    public boolean hasSubmitTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 10;</code>
     *
     * @return The submitTime.
     */
    public com.google.protobuf.Timestamp getSubmitTime() {
      if (submitTimeBuilder_ == null) {
        return submitTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : submitTime_;
      } else {
        return submitTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 10;</code>
     */
    public Builder setSubmitTime(com.google.protobuf.Timestamp value) {
      if (submitTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        submitTime_ = value;
      } else {
        submitTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 10;</code>
     */
    public Builder setSubmitTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (submitTimeBuilder_ == null) {
        submitTime_ = builderForValue.build();
      } else {
        submitTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 10;</code>
     */
    public Builder mergeSubmitTime(com.google.protobuf.Timestamp value) {
      if (submitTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && submitTime_ != null
            && submitTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getSubmitTimeBuilder().mergeFrom(value);
        } else {
          submitTime_ = value;
        }
      } else {
        submitTimeBuilder_.mergeFrom(value);
      }
      if (submitTime_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 10;</code>
     */
    public Builder clearSubmitTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      submitTime_ = null;
      if (submitTimeBuilder_ != null) {
        submitTimeBuilder_.dispose();
        submitTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 10;</code>
     */
    public com.google.protobuf.Timestamp.Builder getSubmitTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getSubmitTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 10;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getSubmitTimeOrBuilder() {
      if (submitTimeBuilder_ != null) {
        return submitTimeBuilder_.getMessageOrBuilder();
      } else {
        return submitTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : submitTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getSubmitTimeFieldBuilder() {
      if (submitTimeBuilder_ == null) {
        submitTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getSubmitTime(), getParentForChildren(), isClean());
        submitTime_ = null;
      }
      return submitTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3beta1.BatchTranslateDocumentMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.translation.v3beta1.BatchTranslateDocumentMetadata)
  private static final com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata();
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchTranslateDocumentMetadata> PARSER =
      new com.google.protobuf.AbstractParser<BatchTranslateDocumentMetadata>() {
        @java.lang.Override
        public BatchTranslateDocumentMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchTranslateDocumentMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchTranslateDocumentMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
