/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/translate/v3beta1/translation_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.translate.v3beta1;

/**
 *
 *
 * <pre>
 * Represents a glossary built from user provided data.
 * </pre>
 *
 * Protobuf type {@code google.cloud.translation.v3beta1.Glossary}
 */
public final class Glossary extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.translation.v3beta1.Glossary)
    GlossaryOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Glossary.newBuilder() to construct.
  private Glossary(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Glossary() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Glossary();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.translate.v3beta1.TranslationServiceProto
        .internal_static_google_cloud_translation_v3beta1_Glossary_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.translate.v3beta1.TranslationServiceProto
        .internal_static_google_cloud_translation_v3beta1_Glossary_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.translate.v3beta1.Glossary.class,
            com.google.cloud.translate.v3beta1.Glossary.Builder.class);
  }

  public interface LanguageCodePairOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.translation.v3beta1.Glossary.LanguageCodePair)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code of the input text, for example,
     * "en-US". Expected to be an exact match for GlossaryTerm.language_code.
     * </pre>
     *
     * <code>string source_language_code = 1;</code>
     *
     * @return The sourceLanguageCode.
     */
    java.lang.String getSourceLanguageCode();

    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code of the input text, for example,
     * "en-US". Expected to be an exact match for GlossaryTerm.language_code.
     * </pre>
     *
     * <code>string source_language_code = 1;</code>
     *
     * @return The bytes for sourceLanguageCode.
     */
    com.google.protobuf.ByteString getSourceLanguageCodeBytes();

    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code for translation output, for example,
     * "zh-CN". Expected to be an exact match for GlossaryTerm.language_code.
     * </pre>
     *
     * <code>string target_language_code = 2;</code>
     *
     * @return The targetLanguageCode.
     */
    java.lang.String getTargetLanguageCode();

    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code for translation output, for example,
     * "zh-CN". Expected to be an exact match for GlossaryTerm.language_code.
     * </pre>
     *
     * <code>string target_language_code = 2;</code>
     *
     * @return The bytes for targetLanguageCode.
     */
    com.google.protobuf.ByteString getTargetLanguageCodeBytes();
  }

  /**
   *
   *
   * <pre>
   * Used with unidirectional glossaries.
   * </pre>
   *
   * Protobuf type {@code google.cloud.translation.v3beta1.Glossary.LanguageCodePair}
   */
  public static final class LanguageCodePair extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.translation.v3beta1.Glossary.LanguageCodePair)
      LanguageCodePairOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use LanguageCodePair.newBuilder() to construct.
    private LanguageCodePair(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LanguageCodePair() {
      sourceLanguageCode_ = "";
      targetLanguageCode_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LanguageCodePair();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_Glossary_LanguageCodePair_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_Glossary_LanguageCodePair_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.class,
              com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.Builder.class);
    }

    public static final int SOURCE_LANGUAGE_CODE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object sourceLanguageCode_ = "";

    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code of the input text, for example,
     * "en-US". Expected to be an exact match for GlossaryTerm.language_code.
     * </pre>
     *
     * <code>string source_language_code = 1;</code>
     *
     * @return The sourceLanguageCode.
     */
    @java.lang.Override
    public java.lang.String getSourceLanguageCode() {
      java.lang.Object ref = sourceLanguageCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceLanguageCode_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code of the input text, for example,
     * "en-US". Expected to be an exact match for GlossaryTerm.language_code.
     * </pre>
     *
     * <code>string source_language_code = 1;</code>
     *
     * @return The bytes for sourceLanguageCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceLanguageCodeBytes() {
      java.lang.Object ref = sourceLanguageCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceLanguageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TARGET_LANGUAGE_CODE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object targetLanguageCode_ = "";

    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code for translation output, for example,
     * "zh-CN". Expected to be an exact match for GlossaryTerm.language_code.
     * </pre>
     *
     * <code>string target_language_code = 2;</code>
     *
     * @return The targetLanguageCode.
     */
    @java.lang.Override
    public java.lang.String getTargetLanguageCode() {
      java.lang.Object ref = targetLanguageCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetLanguageCode_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code for translation output, for example,
     * "zh-CN". Expected to be an exact match for GlossaryTerm.language_code.
     * </pre>
     *
     * <code>string target_language_code = 2;</code>
     *
     * @return The bytes for targetLanguageCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTargetLanguageCodeBytes() {
      java.lang.Object ref = targetLanguageCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetLanguageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceLanguageCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sourceLanguageCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetLanguageCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, targetLanguageCode_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceLanguageCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sourceLanguageCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetLanguageCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, targetLanguageCode_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair)) {
        return super.equals(obj);
      }
      com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair other =
          (com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair) obj;

      if (!getSourceLanguageCode().equals(other.getSourceLanguageCode())) return false;
      if (!getTargetLanguageCode().equals(other.getTargetLanguageCode())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SOURCE_LANGUAGE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceLanguageCode().hashCode();
      hash = (37 * hash) + TARGET_LANGUAGE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getTargetLanguageCode().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Used with unidirectional glossaries.
     * </pre>
     *
     * Protobuf type {@code google.cloud.translation.v3beta1.Glossary.LanguageCodePair}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3beta1.Glossary.LanguageCodePair)
        com.google.cloud.translate.v3beta1.Glossary.LanguageCodePairOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.translate.v3beta1.TranslationServiceProto
            .internal_static_google_cloud_translation_v3beta1_Glossary_LanguageCodePair_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.translate.v3beta1.TranslationServiceProto
            .internal_static_google_cloud_translation_v3beta1_Glossary_LanguageCodePair_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.class,
                com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.Builder.class);
      }

      // Construct using com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        sourceLanguageCode_ = "";
        targetLanguageCode_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.translate.v3beta1.TranslationServiceProto
            .internal_static_google_cloud_translation_v3beta1_Glossary_LanguageCodePair_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair
          getDefaultInstanceForType() {
        return com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair build() {
        com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair buildPartial() {
        com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair result =
            new com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.sourceLanguageCode_ = sourceLanguageCode_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.targetLanguageCode_ = targetLanguageCode_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair) {
          return mergeFrom((com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair other) {
        if (other
            == com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.getDefaultInstance())
          return this;
        if (!other.getSourceLanguageCode().isEmpty()) {
          sourceLanguageCode_ = other.sourceLanguageCode_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getTargetLanguageCode().isEmpty()) {
          targetLanguageCode_ = other.targetLanguageCode_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  sourceLanguageCode_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  targetLanguageCode_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object sourceLanguageCode_ = "";

      /**
       *
       *
       * <pre>
       * Required. The BCP-47 language code of the input text, for example,
       * "en-US". Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>string source_language_code = 1;</code>
       *
       * @return The sourceLanguageCode.
       */
      public java.lang.String getSourceLanguageCode() {
        java.lang.Object ref = sourceLanguageCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sourceLanguageCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The BCP-47 language code of the input text, for example,
       * "en-US". Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>string source_language_code = 1;</code>
       *
       * @return The bytes for sourceLanguageCode.
       */
      public com.google.protobuf.ByteString getSourceLanguageCodeBytes() {
        java.lang.Object ref = sourceLanguageCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sourceLanguageCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The BCP-47 language code of the input text, for example,
       * "en-US". Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>string source_language_code = 1;</code>
       *
       * @param value The sourceLanguageCode to set.
       * @return This builder for chaining.
       */
      public Builder setSourceLanguageCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceLanguageCode_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The BCP-47 language code of the input text, for example,
       * "en-US". Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>string source_language_code = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSourceLanguageCode() {
        sourceLanguageCode_ = getDefaultInstance().getSourceLanguageCode();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The BCP-47 language code of the input text, for example,
       * "en-US". Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>string source_language_code = 1;</code>
       *
       * @param value The bytes for sourceLanguageCode to set.
       * @return This builder for chaining.
       */
      public Builder setSourceLanguageCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        sourceLanguageCode_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object targetLanguageCode_ = "";

      /**
       *
       *
       * <pre>
       * Required. The BCP-47 language code for translation output, for example,
       * "zh-CN". Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>string target_language_code = 2;</code>
       *
       * @return The targetLanguageCode.
       */
      public java.lang.String getTargetLanguageCode() {
        java.lang.Object ref = targetLanguageCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          targetLanguageCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The BCP-47 language code for translation output, for example,
       * "zh-CN". Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>string target_language_code = 2;</code>
       *
       * @return The bytes for targetLanguageCode.
       */
      public com.google.protobuf.ByteString getTargetLanguageCodeBytes() {
        java.lang.Object ref = targetLanguageCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          targetLanguageCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The BCP-47 language code for translation output, for example,
       * "zh-CN". Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>string target_language_code = 2;</code>
       *
       * @param value The targetLanguageCode to set.
       * @return This builder for chaining.
       */
      public Builder setTargetLanguageCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        targetLanguageCode_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The BCP-47 language code for translation output, for example,
       * "zh-CN". Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>string target_language_code = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTargetLanguageCode() {
        targetLanguageCode_ = getDefaultInstance().getTargetLanguageCode();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The BCP-47 language code for translation output, for example,
       * "zh-CN". Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>string target_language_code = 2;</code>
       *
       * @param value The bytes for targetLanguageCode to set.
       * @return This builder for chaining.
       */
      public Builder setTargetLanguageCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        targetLanguageCode_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3beta1.Glossary.LanguageCodePair)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.translation.v3beta1.Glossary.LanguageCodePair)
    private static final com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair();
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LanguageCodePair> PARSER =
        new com.google.protobuf.AbstractParser<LanguageCodePair>() {
          @java.lang.Override
          public LanguageCodePair parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LanguageCodePair> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LanguageCodePair> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface LanguageCodesSetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.translation.v3beta1.Glossary.LanguageCodesSet)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The BCP-47 language code(s) for terms defined in the glossary.
     * All entries are unique. The list contains at least two entries.
     * Expected to be an exact match for GlossaryTerm.language_code.
     * </pre>
     *
     * <code>repeated string language_codes = 1;</code>
     *
     * @return A list containing the languageCodes.
     */
    java.util.List<java.lang.String> getLanguageCodesList();

    /**
     *
     *
     * <pre>
     * The BCP-47 language code(s) for terms defined in the glossary.
     * All entries are unique. The list contains at least two entries.
     * Expected to be an exact match for GlossaryTerm.language_code.
     * </pre>
     *
     * <code>repeated string language_codes = 1;</code>
     *
     * @return The count of languageCodes.
     */
    int getLanguageCodesCount();

    /**
     *
     *
     * <pre>
     * The BCP-47 language code(s) for terms defined in the glossary.
     * All entries are unique. The list contains at least two entries.
     * Expected to be an exact match for GlossaryTerm.language_code.
     * </pre>
     *
     * <code>repeated string language_codes = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The languageCodes at the given index.
     */
    java.lang.String getLanguageCodes(int index);

    /**
     *
     *
     * <pre>
     * The BCP-47 language code(s) for terms defined in the glossary.
     * All entries are unique. The list contains at least two entries.
     * Expected to be an exact match for GlossaryTerm.language_code.
     * </pre>
     *
     * <code>repeated string language_codes = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the languageCodes at the given index.
     */
    com.google.protobuf.ByteString getLanguageCodesBytes(int index);
  }

  /**
   *
   *
   * <pre>
   * Used with equivalent term set glossaries.
   * </pre>
   *
   * Protobuf type {@code google.cloud.translation.v3beta1.Glossary.LanguageCodesSet}
   */
  public static final class LanguageCodesSet extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.translation.v3beta1.Glossary.LanguageCodesSet)
      LanguageCodesSetOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use LanguageCodesSet.newBuilder() to construct.
    private LanguageCodesSet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LanguageCodesSet() {
      languageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LanguageCodesSet();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_Glossary_LanguageCodesSet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_Glossary_LanguageCodesSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.class,
              com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.Builder.class);
    }

    public static final int LANGUAGE_CODES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList languageCodes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * The BCP-47 language code(s) for terms defined in the glossary.
     * All entries are unique. The list contains at least two entries.
     * Expected to be an exact match for GlossaryTerm.language_code.
     * </pre>
     *
     * <code>repeated string language_codes = 1;</code>
     *
     * @return A list containing the languageCodes.
     */
    public com.google.protobuf.ProtocolStringList getLanguageCodesList() {
      return languageCodes_;
    }

    /**
     *
     *
     * <pre>
     * The BCP-47 language code(s) for terms defined in the glossary.
     * All entries are unique. The list contains at least two entries.
     * Expected to be an exact match for GlossaryTerm.language_code.
     * </pre>
     *
     * <code>repeated string language_codes = 1;</code>
     *
     * @return The count of languageCodes.
     */
    public int getLanguageCodesCount() {
      return languageCodes_.size();
    }

    /**
     *
     *
     * <pre>
     * The BCP-47 language code(s) for terms defined in the glossary.
     * All entries are unique. The list contains at least two entries.
     * Expected to be an exact match for GlossaryTerm.language_code.
     * </pre>
     *
     * <code>repeated string language_codes = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The languageCodes at the given index.
     */
    public java.lang.String getLanguageCodes(int index) {
      return languageCodes_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The BCP-47 language code(s) for terms defined in the glossary.
     * All entries are unique. The list contains at least two entries.
     * Expected to be an exact match for GlossaryTerm.language_code.
     * </pre>
     *
     * <code>repeated string language_codes = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the languageCodes at the given index.
     */
    public com.google.protobuf.ByteString getLanguageCodesBytes(int index) {
      return languageCodes_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < languageCodes_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, languageCodes_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < languageCodes_.size(); i++) {
          dataSize += computeStringSizeNoTag(languageCodes_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getLanguageCodesList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet)) {
        return super.equals(obj);
      }
      com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet other =
          (com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet) obj;

      if (!getLanguageCodesList().equals(other.getLanguageCodesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getLanguageCodesCount() > 0) {
        hash = (37 * hash) + LANGUAGE_CODES_FIELD_NUMBER;
        hash = (53 * hash) + getLanguageCodesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Used with equivalent term set glossaries.
     * </pre>
     *
     * Protobuf type {@code google.cloud.translation.v3beta1.Glossary.LanguageCodesSet}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3beta1.Glossary.LanguageCodesSet)
        com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.translate.v3beta1.TranslationServiceProto
            .internal_static_google_cloud_translation_v3beta1_Glossary_LanguageCodesSet_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.translate.v3beta1.TranslationServiceProto
            .internal_static_google_cloud_translation_v3beta1_Glossary_LanguageCodesSet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.class,
                com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.Builder.class);
      }

      // Construct using com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        languageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.translate.v3beta1.TranslationServiceProto
            .internal_static_google_cloud_translation_v3beta1_Glossary_LanguageCodesSet_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet
          getDefaultInstanceForType() {
        return com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet build() {
        com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet buildPartial() {
        com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet result =
            new com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          languageCodes_.makeImmutable();
          result.languageCodes_ = languageCodes_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet) {
          return mergeFrom((com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet other) {
        if (other
            == com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.getDefaultInstance())
          return this;
        if (!other.languageCodes_.isEmpty()) {
          if (languageCodes_.isEmpty()) {
            languageCodes_ = other.languageCodes_;
            bitField0_ |= 0x00000001;
          } else {
            ensureLanguageCodesIsMutable();
            languageCodes_.addAll(other.languageCodes_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureLanguageCodesIsMutable();
                  languageCodes_.add(s);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList languageCodes_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureLanguageCodesIsMutable() {
        if (!languageCodes_.isModifiable()) {
          languageCodes_ = new com.google.protobuf.LazyStringArrayList(languageCodes_);
        }
        bitField0_ |= 0x00000001;
      }

      /**
       *
       *
       * <pre>
       * The BCP-47 language code(s) for terms defined in the glossary.
       * All entries are unique. The list contains at least two entries.
       * Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>repeated string language_codes = 1;</code>
       *
       * @return A list containing the languageCodes.
       */
      public com.google.protobuf.ProtocolStringList getLanguageCodesList() {
        languageCodes_.makeImmutable();
        return languageCodes_;
      }

      /**
       *
       *
       * <pre>
       * The BCP-47 language code(s) for terms defined in the glossary.
       * All entries are unique. The list contains at least two entries.
       * Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>repeated string language_codes = 1;</code>
       *
       * @return The count of languageCodes.
       */
      public int getLanguageCodesCount() {
        return languageCodes_.size();
      }

      /**
       *
       *
       * <pre>
       * The BCP-47 language code(s) for terms defined in the glossary.
       * All entries are unique. The list contains at least two entries.
       * Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>repeated string language_codes = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The languageCodes at the given index.
       */
      public java.lang.String getLanguageCodes(int index) {
        return languageCodes_.get(index);
      }

      /**
       *
       *
       * <pre>
       * The BCP-47 language code(s) for terms defined in the glossary.
       * All entries are unique. The list contains at least two entries.
       * Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>repeated string language_codes = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the languageCodes at the given index.
       */
      public com.google.protobuf.ByteString getLanguageCodesBytes(int index) {
        return languageCodes_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * The BCP-47 language code(s) for terms defined in the glossary.
       * All entries are unique. The list contains at least two entries.
       * Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>repeated string language_codes = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The languageCodes to set.
       * @return This builder for chaining.
       */
      public Builder setLanguageCodes(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLanguageCodesIsMutable();
        languageCodes_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The BCP-47 language code(s) for terms defined in the glossary.
       * All entries are unique. The list contains at least two entries.
       * Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>repeated string language_codes = 1;</code>
       *
       * @param value The languageCodes to add.
       * @return This builder for chaining.
       */
      public Builder addLanguageCodes(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLanguageCodesIsMutable();
        languageCodes_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The BCP-47 language code(s) for terms defined in the glossary.
       * All entries are unique. The list contains at least two entries.
       * Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>repeated string language_codes = 1;</code>
       *
       * @param values The languageCodes to add.
       * @return This builder for chaining.
       */
      public Builder addAllLanguageCodes(java.lang.Iterable<java.lang.String> values) {
        ensureLanguageCodesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, languageCodes_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The BCP-47 language code(s) for terms defined in the glossary.
       * All entries are unique. The list contains at least two entries.
       * Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>repeated string language_codes = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLanguageCodes() {
        languageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The BCP-47 language code(s) for terms defined in the glossary.
       * All entries are unique. The list contains at least two entries.
       * Expected to be an exact match for GlossaryTerm.language_code.
       * </pre>
       *
       * <code>repeated string language_codes = 1;</code>
       *
       * @param value The bytes of the languageCodes to add.
       * @return This builder for chaining.
       */
      public Builder addLanguageCodesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureLanguageCodesIsMutable();
        languageCodes_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3beta1.Glossary.LanguageCodesSet)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.translation.v3beta1.Glossary.LanguageCodesSet)
    private static final com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet();
    }

    public static com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LanguageCodesSet> PARSER =
        new com.google.protobuf.AbstractParser<LanguageCodesSet>() {
          @java.lang.Override
          public LanguageCodesSet parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LanguageCodesSet> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LanguageCodesSet> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int languagesCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object languages_;

  public enum LanguagesCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    LANGUAGE_PAIR(3),
    LANGUAGE_CODES_SET(4),
    LANGUAGES_NOT_SET(0);
    private final int value;

    private LanguagesCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LanguagesCase valueOf(int value) {
      return forNumber(value);
    }

    public static LanguagesCase forNumber(int value) {
      switch (value) {
        case 3:
          return LANGUAGE_PAIR;
        case 4:
          return LANGUAGE_CODES_SET;
        case 0:
          return LANGUAGES_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public LanguagesCase getLanguagesCase() {
    return LanguagesCase.forNumber(languagesCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource name of the glossary. Glossary names have the form
   * `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource name of the glossary. Glossary names have the form
   * `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_PAIR_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Used with unidirectional glossaries.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodePair language_pair = 3;</code>
   *
   * @return Whether the languagePair field is set.
   */
  @java.lang.Override
  public boolean hasLanguagePair() {
    return languagesCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Used with unidirectional glossaries.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodePair language_pair = 3;</code>
   *
   * @return The languagePair.
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair getLanguagePair() {
    if (languagesCase_ == 3) {
      return (com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair) languages_;
    }
    return com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Used with unidirectional glossaries.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodePair language_pair = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.Glossary.LanguageCodePairOrBuilder
      getLanguagePairOrBuilder() {
    if (languagesCase_ == 3) {
      return (com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair) languages_;
    }
    return com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.getDefaultInstance();
  }

  public static final int LANGUAGE_CODES_SET_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * Used with equivalent term set glossaries.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodesSet language_codes_set = 4;
   * </code>
   *
   * @return Whether the languageCodesSet field is set.
   */
  @java.lang.Override
  public boolean hasLanguageCodesSet() {
    return languagesCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * Used with equivalent term set glossaries.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodesSet language_codes_set = 4;
   * </code>
   *
   * @return The languageCodesSet.
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet getLanguageCodesSet() {
    if (languagesCase_ == 4) {
      return (com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet) languages_;
    }
    return com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Used with equivalent term set glossaries.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodesSet language_codes_set = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSetOrBuilder
      getLanguageCodesSetOrBuilder() {
    if (languagesCase_ == 4) {
      return (com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet) languages_;
    }
    return com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.getDefaultInstance();
  }

  public static final int INPUT_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.translate.v3beta1.GlossaryInputConfig inputConfig_;

  /**
   *
   *
   * <pre>
   * Required. Provides examples to build the glossary from.
   * Total glossary must not exceed 10M Unicode codepoints.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.GlossaryInputConfig input_config = 5;</code>
   *
   * @return Whether the inputConfig field is set.
   */
  @java.lang.Override
  public boolean hasInputConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Provides examples to build the glossary from.
   * Total glossary must not exceed 10M Unicode codepoints.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.GlossaryInputConfig input_config = 5;</code>
   *
   * @return The inputConfig.
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.GlossaryInputConfig getInputConfig() {
    return inputConfig_ == null
        ? com.google.cloud.translate.v3beta1.GlossaryInputConfig.getDefaultInstance()
        : inputConfig_;
  }

  /**
   *
   *
   * <pre>
   * Required. Provides examples to build the glossary from.
   * Total glossary must not exceed 10M Unicode codepoints.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.GlossaryInputConfig input_config = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.GlossaryInputConfigOrBuilder getInputConfigOrBuilder() {
    return inputConfig_ == null
        ? com.google.cloud.translate.v3beta1.GlossaryInputConfig.getDefaultInstance()
        : inputConfig_;
  }

  public static final int ENTRY_COUNT_FIELD_NUMBER = 6;
  private int entryCount_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. The number of entries defined in the glossary.
   * </pre>
   *
   * <code>int32 entry_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The entryCount.
   */
  @java.lang.Override
  public int getEntryCount() {
    return entryCount_;
  }

  public static final int SUBMIT_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp submitTime_;

  /**
   *
   *
   * <pre>
   * Output only. When CreateGlossary was called.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp submit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the submitTime field is set.
   */
  @java.lang.Override
  public boolean hasSubmitTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. When CreateGlossary was called.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp submit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The submitTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getSubmitTime() {
    return submitTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : submitTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. When CreateGlossary was called.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp submit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getSubmitTimeOrBuilder() {
    return submitTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : submitTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp endTime_;

  /**
   *
   *
   * <pre>
   * Output only. When the glossary creation was finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. When the glossary creation was finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. When the glossary creation was finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (languagesCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair) languages_);
    }
    if (languagesCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet) languages_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getInputConfig());
    }
    if (entryCount_ != 0) {
      output.writeInt32(6, entryCount_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getSubmitTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getEndTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (languagesCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair) languages_);
    }
    if (languagesCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet) languages_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getInputConfig());
    }
    if (entryCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, entryCount_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getSubmitTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getEndTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.translate.v3beta1.Glossary)) {
      return super.equals(obj);
    }
    com.google.cloud.translate.v3beta1.Glossary other =
        (com.google.cloud.translate.v3beta1.Glossary) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasInputConfig() != other.hasInputConfig()) return false;
    if (hasInputConfig()) {
      if (!getInputConfig().equals(other.getInputConfig())) return false;
    }
    if (getEntryCount() != other.getEntryCount()) return false;
    if (hasSubmitTime() != other.hasSubmitTime()) return false;
    if (hasSubmitTime()) {
      if (!getSubmitTime().equals(other.getSubmitTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getLanguagesCase().equals(other.getLanguagesCase())) return false;
    switch (languagesCase_) {
      case 3:
        if (!getLanguagePair().equals(other.getLanguagePair())) return false;
        break;
      case 4:
        if (!getLanguageCodesSet().equals(other.getLanguageCodesSet())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasInputConfig()) {
      hash = (37 * hash) + INPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInputConfig().hashCode();
    }
    hash = (37 * hash) + ENTRY_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getEntryCount();
    if (hasSubmitTime()) {
      hash = (37 * hash) + SUBMIT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getSubmitTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    switch (languagesCase_) {
      case 3:
        hash = (37 * hash) + LANGUAGE_PAIR_FIELD_NUMBER;
        hash = (53 * hash) + getLanguagePair().hashCode();
        break;
      case 4:
        hash = (37 * hash) + LANGUAGE_CODES_SET_FIELD_NUMBER;
        hash = (53 * hash) + getLanguageCodesSet().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.translate.v3beta1.Glossary parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3beta1.Glossary parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.Glossary parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3beta1.Glossary parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.Glossary parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3beta1.Glossary parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.Glossary parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3beta1.Glossary parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.Glossary parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3beta1.Glossary parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.Glossary parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3beta1.Glossary parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.translate.v3beta1.Glossary prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a glossary built from user provided data.
   * </pre>
   *
   * Protobuf type {@code google.cloud.translation.v3beta1.Glossary}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3beta1.Glossary)
      com.google.cloud.translate.v3beta1.GlossaryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_Glossary_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_Glossary_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3beta1.Glossary.class,
              com.google.cloud.translate.v3beta1.Glossary.Builder.class);
    }

    // Construct using com.google.cloud.translate.v3beta1.Glossary.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInputConfigFieldBuilder();
        getSubmitTimeFieldBuilder();
        getEndTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (languagePairBuilder_ != null) {
        languagePairBuilder_.clear();
      }
      if (languageCodesSetBuilder_ != null) {
        languageCodesSetBuilder_.clear();
      }
      inputConfig_ = null;
      if (inputConfigBuilder_ != null) {
        inputConfigBuilder_.dispose();
        inputConfigBuilder_ = null;
      }
      entryCount_ = 0;
      submitTime_ = null;
      if (submitTimeBuilder_ != null) {
        submitTimeBuilder_.dispose();
        submitTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      languagesCase_ = 0;
      languages_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_Glossary_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3beta1.Glossary getDefaultInstanceForType() {
      return com.google.cloud.translate.v3beta1.Glossary.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.translate.v3beta1.Glossary build() {
      com.google.cloud.translate.v3beta1.Glossary result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3beta1.Glossary buildPartial() {
      com.google.cloud.translate.v3beta1.Glossary result =
          new com.google.cloud.translate.v3beta1.Glossary(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.translate.v3beta1.Glossary result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.inputConfig_ =
            inputConfigBuilder_ == null ? inputConfig_ : inputConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.entryCount_ = entryCount_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.submitTime_ = submitTimeBuilder_ == null ? submitTime_ : submitTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.translate.v3beta1.Glossary result) {
      result.languagesCase_ = languagesCase_;
      result.languages_ = this.languages_;
      if (languagesCase_ == 3 && languagePairBuilder_ != null) {
        result.languages_ = languagePairBuilder_.build();
      }
      if (languagesCase_ == 4 && languageCodesSetBuilder_ != null) {
        result.languages_ = languageCodesSetBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.translate.v3beta1.Glossary) {
        return mergeFrom((com.google.cloud.translate.v3beta1.Glossary) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.translate.v3beta1.Glossary other) {
      if (other == com.google.cloud.translate.v3beta1.Glossary.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasInputConfig()) {
        mergeInputConfig(other.getInputConfig());
      }
      if (other.getEntryCount() != 0) {
        setEntryCount(other.getEntryCount());
      }
      if (other.hasSubmitTime()) {
        mergeSubmitTime(other.getSubmitTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      switch (other.getLanguagesCase()) {
        case LANGUAGE_PAIR:
          {
            mergeLanguagePair(other.getLanguagePair());
            break;
          }
        case LANGUAGE_CODES_SET:
          {
            mergeLanguageCodesSet(other.getLanguageCodesSet());
            break;
          }
        case LANGUAGES_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getLanguagePairFieldBuilder().getBuilder(), extensionRegistry);
                languagesCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getLanguageCodesSetFieldBuilder().getBuilder(), extensionRegistry);
                languagesCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getInputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 48:
              {
                entryCount_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(getSubmitTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int languagesCase_ = 0;
    private java.lang.Object languages_;

    public LanguagesCase getLanguagesCase() {
      return LanguagesCase.forNumber(languagesCase_);
    }

    public Builder clearLanguages() {
      languagesCase_ = 0;
      languages_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the glossary. Glossary names have the form
     * `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the glossary. Glossary names have the form
     * `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the glossary. Glossary names have the form
     * `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the glossary. Glossary names have the form
     * `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the glossary. Glossary names have the form
     * `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair,
            com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.Builder,
            com.google.cloud.translate.v3beta1.Glossary.LanguageCodePairOrBuilder>
        languagePairBuilder_;

    /**
     *
     *
     * <pre>
     * Used with unidirectional glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodePair language_pair = 3;</code>
     *
     * @return Whether the languagePair field is set.
     */
    @java.lang.Override
    public boolean hasLanguagePair() {
      return languagesCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Used with unidirectional glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodePair language_pair = 3;</code>
     *
     * @return The languagePair.
     */
    @java.lang.Override
    public com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair getLanguagePair() {
      if (languagePairBuilder_ == null) {
        if (languagesCase_ == 3) {
          return (com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair) languages_;
        }
        return com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.getDefaultInstance();
      } else {
        if (languagesCase_ == 3) {
          return languagePairBuilder_.getMessage();
        }
        return com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Used with unidirectional glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodePair language_pair = 3;</code>
     */
    public Builder setLanguagePair(
        com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair value) {
      if (languagePairBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        languages_ = value;
        onChanged();
      } else {
        languagePairBuilder_.setMessage(value);
      }
      languagesCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Used with unidirectional glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodePair language_pair = 3;</code>
     */
    public Builder setLanguagePair(
        com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.Builder builderForValue) {
      if (languagePairBuilder_ == null) {
        languages_ = builderForValue.build();
        onChanged();
      } else {
        languagePairBuilder_.setMessage(builderForValue.build());
      }
      languagesCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Used with unidirectional glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodePair language_pair = 3;</code>
     */
    public Builder mergeLanguagePair(
        com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair value) {
      if (languagePairBuilder_ == null) {
        if (languagesCase_ == 3
            && languages_
                != com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair
                    .getDefaultInstance()) {
          languages_ =
              com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.newBuilder(
                      (com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair) languages_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          languages_ = value;
        }
        onChanged();
      } else {
        if (languagesCase_ == 3) {
          languagePairBuilder_.mergeFrom(value);
        } else {
          languagePairBuilder_.setMessage(value);
        }
      }
      languagesCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Used with unidirectional glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodePair language_pair = 3;</code>
     */
    public Builder clearLanguagePair() {
      if (languagePairBuilder_ == null) {
        if (languagesCase_ == 3) {
          languagesCase_ = 0;
          languages_ = null;
          onChanged();
        }
      } else {
        if (languagesCase_ == 3) {
          languagesCase_ = 0;
          languages_ = null;
        }
        languagePairBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Used with unidirectional glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodePair language_pair = 3;</code>
     */
    public com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.Builder
        getLanguagePairBuilder() {
      return getLanguagePairFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Used with unidirectional glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodePair language_pair = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.translate.v3beta1.Glossary.LanguageCodePairOrBuilder
        getLanguagePairOrBuilder() {
      if ((languagesCase_ == 3) && (languagePairBuilder_ != null)) {
        return languagePairBuilder_.getMessageOrBuilder();
      } else {
        if (languagesCase_ == 3) {
          return (com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair) languages_;
        }
        return com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Used with unidirectional glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodePair language_pair = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair,
            com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.Builder,
            com.google.cloud.translate.v3beta1.Glossary.LanguageCodePairOrBuilder>
        getLanguagePairFieldBuilder() {
      if (languagePairBuilder_ == null) {
        if (!(languagesCase_ == 3)) {
          languages_ =
              com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.getDefaultInstance();
        }
        languagePairBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair,
                com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair.Builder,
                com.google.cloud.translate.v3beta1.Glossary.LanguageCodePairOrBuilder>(
                (com.google.cloud.translate.v3beta1.Glossary.LanguageCodePair) languages_,
                getParentForChildren(),
                isClean());
        languages_ = null;
      }
      languagesCase_ = 3;
      onChanged();
      return languagePairBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet,
            com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.Builder,
            com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSetOrBuilder>
        languageCodesSetBuilder_;

    /**
     *
     *
     * <pre>
     * Used with equivalent term set glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodesSet language_codes_set = 4;
     * </code>
     *
     * @return Whether the languageCodesSet field is set.
     */
    @java.lang.Override
    public boolean hasLanguageCodesSet() {
      return languagesCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Used with equivalent term set glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodesSet language_codes_set = 4;
     * </code>
     *
     * @return The languageCodesSet.
     */
    @java.lang.Override
    public com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet getLanguageCodesSet() {
      if (languageCodesSetBuilder_ == null) {
        if (languagesCase_ == 4) {
          return (com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet) languages_;
        }
        return com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.getDefaultInstance();
      } else {
        if (languagesCase_ == 4) {
          return languageCodesSetBuilder_.getMessage();
        }
        return com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Used with equivalent term set glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodesSet language_codes_set = 4;
     * </code>
     */
    public Builder setLanguageCodesSet(
        com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet value) {
      if (languageCodesSetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        languages_ = value;
        onChanged();
      } else {
        languageCodesSetBuilder_.setMessage(value);
      }
      languagesCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Used with equivalent term set glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodesSet language_codes_set = 4;
     * </code>
     */
    public Builder setLanguageCodesSet(
        com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.Builder builderForValue) {
      if (languageCodesSetBuilder_ == null) {
        languages_ = builderForValue.build();
        onChanged();
      } else {
        languageCodesSetBuilder_.setMessage(builderForValue.build());
      }
      languagesCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Used with equivalent term set glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodesSet language_codes_set = 4;
     * </code>
     */
    public Builder mergeLanguageCodesSet(
        com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet value) {
      if (languageCodesSetBuilder_ == null) {
        if (languagesCase_ == 4
            && languages_
                != com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet
                    .getDefaultInstance()) {
          languages_ =
              com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.newBuilder(
                      (com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet) languages_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          languages_ = value;
        }
        onChanged();
      } else {
        if (languagesCase_ == 4) {
          languageCodesSetBuilder_.mergeFrom(value);
        } else {
          languageCodesSetBuilder_.setMessage(value);
        }
      }
      languagesCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Used with equivalent term set glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodesSet language_codes_set = 4;
     * </code>
     */
    public Builder clearLanguageCodesSet() {
      if (languageCodesSetBuilder_ == null) {
        if (languagesCase_ == 4) {
          languagesCase_ = 0;
          languages_ = null;
          onChanged();
        }
      } else {
        if (languagesCase_ == 4) {
          languagesCase_ = 0;
          languages_ = null;
        }
        languageCodesSetBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Used with equivalent term set glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodesSet language_codes_set = 4;
     * </code>
     */
    public com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.Builder
        getLanguageCodesSetBuilder() {
      return getLanguageCodesSetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Used with equivalent term set glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodesSet language_codes_set = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSetOrBuilder
        getLanguageCodesSetOrBuilder() {
      if ((languagesCase_ == 4) && (languageCodesSetBuilder_ != null)) {
        return languageCodesSetBuilder_.getMessageOrBuilder();
      } else {
        if (languagesCase_ == 4) {
          return (com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet) languages_;
        }
        return com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Used with equivalent term set glossaries.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.Glossary.LanguageCodesSet language_codes_set = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet,
            com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.Builder,
            com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSetOrBuilder>
        getLanguageCodesSetFieldBuilder() {
      if (languageCodesSetBuilder_ == null) {
        if (!(languagesCase_ == 4)) {
          languages_ =
              com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.getDefaultInstance();
        }
        languageCodesSetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet,
                com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet.Builder,
                com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSetOrBuilder>(
                (com.google.cloud.translate.v3beta1.Glossary.LanguageCodesSet) languages_,
                getParentForChildren(),
                isClean());
        languages_ = null;
      }
      languagesCase_ = 4;
      onChanged();
      return languageCodesSetBuilder_;
    }

    private com.google.cloud.translate.v3beta1.GlossaryInputConfig inputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.GlossaryInputConfig,
            com.google.cloud.translate.v3beta1.GlossaryInputConfig.Builder,
            com.google.cloud.translate.v3beta1.GlossaryInputConfigOrBuilder>
        inputConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Provides examples to build the glossary from.
     * Total glossary must not exceed 10M Unicode codepoints.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.GlossaryInputConfig input_config = 5;</code>
     *
     * @return Whether the inputConfig field is set.
     */
    public boolean hasInputConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Provides examples to build the glossary from.
     * Total glossary must not exceed 10M Unicode codepoints.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.GlossaryInputConfig input_config = 5;</code>
     *
     * @return The inputConfig.
     */
    public com.google.cloud.translate.v3beta1.GlossaryInputConfig getInputConfig() {
      if (inputConfigBuilder_ == null) {
        return inputConfig_ == null
            ? com.google.cloud.translate.v3beta1.GlossaryInputConfig.getDefaultInstance()
            : inputConfig_;
      } else {
        return inputConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Provides examples to build the glossary from.
     * Total glossary must not exceed 10M Unicode codepoints.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.GlossaryInputConfig input_config = 5;</code>
     */
    public Builder setInputConfig(com.google.cloud.translate.v3beta1.GlossaryInputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputConfig_ = value;
      } else {
        inputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Provides examples to build the glossary from.
     * Total glossary must not exceed 10M Unicode codepoints.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.GlossaryInputConfig input_config = 5;</code>
     */
    public Builder setInputConfig(
        com.google.cloud.translate.v3beta1.GlossaryInputConfig.Builder builderForValue) {
      if (inputConfigBuilder_ == null) {
        inputConfig_ = builderForValue.build();
      } else {
        inputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Provides examples to build the glossary from.
     * Total glossary must not exceed 10M Unicode codepoints.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.GlossaryInputConfig input_config = 5;</code>
     */
    public Builder mergeInputConfig(com.google.cloud.translate.v3beta1.GlossaryInputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && inputConfig_ != null
            && inputConfig_
                != com.google.cloud.translate.v3beta1.GlossaryInputConfig.getDefaultInstance()) {
          getInputConfigBuilder().mergeFrom(value);
        } else {
          inputConfig_ = value;
        }
      } else {
        inputConfigBuilder_.mergeFrom(value);
      }
      if (inputConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Provides examples to build the glossary from.
     * Total glossary must not exceed 10M Unicode codepoints.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.GlossaryInputConfig input_config = 5;</code>
     */
    public Builder clearInputConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      inputConfig_ = null;
      if (inputConfigBuilder_ != null) {
        inputConfigBuilder_.dispose();
        inputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Provides examples to build the glossary from.
     * Total glossary must not exceed 10M Unicode codepoints.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.GlossaryInputConfig input_config = 5;</code>
     */
    public com.google.cloud.translate.v3beta1.GlossaryInputConfig.Builder getInputConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getInputConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Provides examples to build the glossary from.
     * Total glossary must not exceed 10M Unicode codepoints.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.GlossaryInputConfig input_config = 5;</code>
     */
    public com.google.cloud.translate.v3beta1.GlossaryInputConfigOrBuilder
        getInputConfigOrBuilder() {
      if (inputConfigBuilder_ != null) {
        return inputConfigBuilder_.getMessageOrBuilder();
      } else {
        return inputConfig_ == null
            ? com.google.cloud.translate.v3beta1.GlossaryInputConfig.getDefaultInstance()
            : inputConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Provides examples to build the glossary from.
     * Total glossary must not exceed 10M Unicode codepoints.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.GlossaryInputConfig input_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.GlossaryInputConfig,
            com.google.cloud.translate.v3beta1.GlossaryInputConfig.Builder,
            com.google.cloud.translate.v3beta1.GlossaryInputConfigOrBuilder>
        getInputConfigFieldBuilder() {
      if (inputConfigBuilder_ == null) {
        inputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.translate.v3beta1.GlossaryInputConfig,
                com.google.cloud.translate.v3beta1.GlossaryInputConfig.Builder,
                com.google.cloud.translate.v3beta1.GlossaryInputConfigOrBuilder>(
                getInputConfig(), getParentForChildren(), isClean());
        inputConfig_ = null;
      }
      return inputConfigBuilder_;
    }

    private int entryCount_;

    /**
     *
     *
     * <pre>
     * Output only. The number of entries defined in the glossary.
     * </pre>
     *
     * <code>int32 entry_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The entryCount.
     */
    @java.lang.Override
    public int getEntryCount() {
      return entryCount_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The number of entries defined in the glossary.
     * </pre>
     *
     * <code>int32 entry_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The entryCount to set.
     * @return This builder for chaining.
     */
    public Builder setEntryCount(int value) {

      entryCount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The number of entries defined in the glossary.
     * </pre>
     *
     * <code>int32 entry_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntryCount() {
      bitField0_ = (bitField0_ & ~0x00000010);
      entryCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp submitTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        submitTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. When CreateGlossary was called.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp submit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the submitTime field is set.
     */
    public boolean hasSubmitTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. When CreateGlossary was called.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp submit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The submitTime.
     */
    public com.google.protobuf.Timestamp getSubmitTime() {
      if (submitTimeBuilder_ == null) {
        return submitTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : submitTime_;
      } else {
        return submitTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. When CreateGlossary was called.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp submit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSubmitTime(com.google.protobuf.Timestamp value) {
      if (submitTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        submitTime_ = value;
      } else {
        submitTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. When CreateGlossary was called.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp submit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSubmitTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (submitTimeBuilder_ == null) {
        submitTime_ = builderForValue.build();
      } else {
        submitTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. When CreateGlossary was called.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp submit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSubmitTime(com.google.protobuf.Timestamp value) {
      if (submitTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && submitTime_ != null
            && submitTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getSubmitTimeBuilder().mergeFrom(value);
        } else {
          submitTime_ = value;
        }
      } else {
        submitTimeBuilder_.mergeFrom(value);
      }
      if (submitTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. When CreateGlossary was called.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp submit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSubmitTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      submitTime_ = null;
      if (submitTimeBuilder_ != null) {
        submitTimeBuilder_.dispose();
        submitTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. When CreateGlossary was called.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp submit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getSubmitTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getSubmitTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. When CreateGlossary was called.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp submit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getSubmitTimeOrBuilder() {
      if (submitTimeBuilder_ != null) {
        return submitTimeBuilder_.getMessageOrBuilder();
      } else {
        return submitTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : submitTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. When CreateGlossary was called.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp submit_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getSubmitTimeFieldBuilder() {
      if (submitTimeBuilder_ == null) {
        submitTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getSubmitTime(), getParentForChildren(), isClean());
        submitTime_ = null;
      }
      return submitTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. When the glossary creation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. When the glossary creation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. When the glossary creation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. When the glossary creation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. When the glossary creation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. When the glossary creation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. When the glossary creation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. When the glossary creation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. When the glossary creation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3beta1.Glossary)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.translation.v3beta1.Glossary)
  private static final com.google.cloud.translate.v3beta1.Glossary DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.translate.v3beta1.Glossary();
  }

  public static com.google.cloud.translate.v3beta1.Glossary getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Glossary> PARSER =
      new com.google.protobuf.AbstractParser<Glossary>() {
        @java.lang.Override
        public Glossary parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Glossary> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Glossary> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.translate.v3beta1.Glossary getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
