/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/translate/v3beta1/translation_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.translate.v3beta1;

/**
 *
 *
 * <pre>
 * A translated document response message.
 * </pre>
 *
 * Protobuf type {@code google.cloud.translation.v3beta1.TranslateDocumentResponse}
 */
public final class TranslateDocumentResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.translation.v3beta1.TranslateDocumentResponse)
    TranslateDocumentResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use TranslateDocumentResponse.newBuilder() to construct.
  private TranslateDocumentResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TranslateDocumentResponse() {
    model_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TranslateDocumentResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.translate.v3beta1.TranslationServiceProto
        .internal_static_google_cloud_translation_v3beta1_TranslateDocumentResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.translate.v3beta1.TranslationServiceProto
        .internal_static_google_cloud_translation_v3beta1_TranslateDocumentResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.translate.v3beta1.TranslateDocumentResponse.class,
            com.google.cloud.translate.v3beta1.TranslateDocumentResponse.Builder.class);
  }

  private int bitField0_;
  public static final int DOCUMENT_TRANSLATION_FIELD_NUMBER = 1;
  private com.google.cloud.translate.v3beta1.DocumentTranslation documentTranslation_;

  /**
   *
   *
   * <pre>
   * Translated document.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.DocumentTranslation document_translation = 1;</code>
   *
   * @return Whether the documentTranslation field is set.
   */
  @java.lang.Override
  public boolean hasDocumentTranslation() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Translated document.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.DocumentTranslation document_translation = 1;</code>
   *
   * @return The documentTranslation.
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.DocumentTranslation getDocumentTranslation() {
    return documentTranslation_ == null
        ? com.google.cloud.translate.v3beta1.DocumentTranslation.getDefaultInstance()
        : documentTranslation_;
  }

  /**
   *
   *
   * <pre>
   * Translated document.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.DocumentTranslation document_translation = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.DocumentTranslationOrBuilder
      getDocumentTranslationOrBuilder() {
    return documentTranslation_ == null
        ? com.google.cloud.translate.v3beta1.DocumentTranslation.getDefaultInstance()
        : documentTranslation_;
  }

  public static final int GLOSSARY_DOCUMENT_TRANSLATION_FIELD_NUMBER = 2;
  private com.google.cloud.translate.v3beta1.DocumentTranslation glossaryDocumentTranslation_;

  /**
   *
   *
   * <pre>
   * The document's translation output if a glossary is provided in the request.
   * This can be the same as [TranslateDocumentResponse.document_translation]
   * if no glossary terms apply.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.DocumentTranslation glossary_document_translation = 2;
   * </code>
   *
   * @return Whether the glossaryDocumentTranslation field is set.
   */
  @java.lang.Override
  public boolean hasGlossaryDocumentTranslation() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The document's translation output if a glossary is provided in the request.
   * This can be the same as [TranslateDocumentResponse.document_translation]
   * if no glossary terms apply.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.DocumentTranslation glossary_document_translation = 2;
   * </code>
   *
   * @return The glossaryDocumentTranslation.
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.DocumentTranslation getGlossaryDocumentTranslation() {
    return glossaryDocumentTranslation_ == null
        ? com.google.cloud.translate.v3beta1.DocumentTranslation.getDefaultInstance()
        : glossaryDocumentTranslation_;
  }

  /**
   *
   *
   * <pre>
   * The document's translation output if a glossary is provided in the request.
   * This can be the same as [TranslateDocumentResponse.document_translation]
   * if no glossary terms apply.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.DocumentTranslation glossary_document_translation = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.DocumentTranslationOrBuilder
      getGlossaryDocumentTranslationOrBuilder() {
    return glossaryDocumentTranslation_ == null
        ? com.google.cloud.translate.v3beta1.DocumentTranslation.getDefaultInstance()
        : glossaryDocumentTranslation_;
  }

  public static final int MODEL_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object model_ = "";

  /**
   *
   *
   * <pre>
   * Only present when 'model' is present in the request.
   * 'model' is normalized to have a project number.
   *
   * For example:
   * If the 'model' field in TranslateDocumentRequest is:
   * `projects/{project-id}/locations/{location-id}/models/general/nmt` then
   * `model` here would be normalized to
   * `projects/{project-number}/locations/{location-id}/models/general/nmt`.
   * </pre>
   *
   * <code>string model = 3;</code>
   *
   * @return The model.
   */
  @java.lang.Override
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Only present when 'model' is present in the request.
   * 'model' is normalized to have a project number.
   *
   * For example:
   * If the 'model' field in TranslateDocumentRequest is:
   * `projects/{project-id}/locations/{location-id}/models/general/nmt` then
   * `model` here would be normalized to
   * `projects/{project-number}/locations/{location-id}/models/general/nmt`.
   * </pre>
   *
   * <code>string model = 3;</code>
   *
   * @return The bytes for model.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GLOSSARY_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig glossaryConfig_;

  /**
   *
   *
   * <pre>
   * The `glossary_config` used for this translation.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 4;</code>
   *
   * @return Whether the glossaryConfig field is set.
   */
  @java.lang.Override
  public boolean hasGlossaryConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * The `glossary_config` used for this translation.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 4;</code>
   *
   * @return The glossaryConfig.
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig getGlossaryConfig() {
    return glossaryConfig_ == null
        ? com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.getDefaultInstance()
        : glossaryConfig_;
  }

  /**
   *
   *
   * <pre>
   * The `glossary_config` used for this translation.
   * </pre>
   *
   * <code>.google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfigOrBuilder
      getGlossaryConfigOrBuilder() {
    return glossaryConfig_ == null
        ? com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.getDefaultInstance()
        : glossaryConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getDocumentTranslation());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getGlossaryDocumentTranslation());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, model_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getGlossaryConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDocumentTranslation());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, getGlossaryDocumentTranslation());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, model_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getGlossaryConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.translate.v3beta1.TranslateDocumentResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.translate.v3beta1.TranslateDocumentResponse other =
        (com.google.cloud.translate.v3beta1.TranslateDocumentResponse) obj;

    if (hasDocumentTranslation() != other.hasDocumentTranslation()) return false;
    if (hasDocumentTranslation()) {
      if (!getDocumentTranslation().equals(other.getDocumentTranslation())) return false;
    }
    if (hasGlossaryDocumentTranslation() != other.hasGlossaryDocumentTranslation()) return false;
    if (hasGlossaryDocumentTranslation()) {
      if (!getGlossaryDocumentTranslation().equals(other.getGlossaryDocumentTranslation()))
        return false;
    }
    if (!getModel().equals(other.getModel())) return false;
    if (hasGlossaryConfig() != other.hasGlossaryConfig()) return false;
    if (hasGlossaryConfig()) {
      if (!getGlossaryConfig().equals(other.getGlossaryConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDocumentTranslation()) {
      hash = (37 * hash) + DOCUMENT_TRANSLATION_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentTranslation().hashCode();
    }
    if (hasGlossaryDocumentTranslation()) {
      hash = (37 * hash) + GLOSSARY_DOCUMENT_TRANSLATION_FIELD_NUMBER;
      hash = (53 * hash) + getGlossaryDocumentTranslation().hashCode();
    }
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    if (hasGlossaryConfig()) {
      hash = (37 * hash) + GLOSSARY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getGlossaryConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.translate.v3beta1.TranslateDocumentResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A translated document response message.
   * </pre>
   *
   * Protobuf type {@code google.cloud.translation.v3beta1.TranslateDocumentResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3beta1.TranslateDocumentResponse)
      com.google.cloud.translate.v3beta1.TranslateDocumentResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_TranslateDocumentResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_TranslateDocumentResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3beta1.TranslateDocumentResponse.class,
              com.google.cloud.translate.v3beta1.TranslateDocumentResponse.Builder.class);
    }

    // Construct using com.google.cloud.translate.v3beta1.TranslateDocumentResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDocumentTranslationFieldBuilder();
        getGlossaryDocumentTranslationFieldBuilder();
        getGlossaryConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      documentTranslation_ = null;
      if (documentTranslationBuilder_ != null) {
        documentTranslationBuilder_.dispose();
        documentTranslationBuilder_ = null;
      }
      glossaryDocumentTranslation_ = null;
      if (glossaryDocumentTranslationBuilder_ != null) {
        glossaryDocumentTranslationBuilder_.dispose();
        glossaryDocumentTranslationBuilder_ = null;
      }
      model_ = "";
      glossaryConfig_ = null;
      if (glossaryConfigBuilder_ != null) {
        glossaryConfigBuilder_.dispose();
        glossaryConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_TranslateDocumentResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3beta1.TranslateDocumentResponse
        getDefaultInstanceForType() {
      return com.google.cloud.translate.v3beta1.TranslateDocumentResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.translate.v3beta1.TranslateDocumentResponse build() {
      com.google.cloud.translate.v3beta1.TranslateDocumentResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3beta1.TranslateDocumentResponse buildPartial() {
      com.google.cloud.translate.v3beta1.TranslateDocumentResponse result =
          new com.google.cloud.translate.v3beta1.TranslateDocumentResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.translate.v3beta1.TranslateDocumentResponse result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.documentTranslation_ =
            documentTranslationBuilder_ == null
                ? documentTranslation_
                : documentTranslationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.glossaryDocumentTranslation_ =
            glossaryDocumentTranslationBuilder_ == null
                ? glossaryDocumentTranslation_
                : glossaryDocumentTranslationBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.model_ = model_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.glossaryConfig_ =
            glossaryConfigBuilder_ == null ? glossaryConfig_ : glossaryConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.translate.v3beta1.TranslateDocumentResponse) {
        return mergeFrom((com.google.cloud.translate.v3beta1.TranslateDocumentResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.translate.v3beta1.TranslateDocumentResponse other) {
      if (other
          == com.google.cloud.translate.v3beta1.TranslateDocumentResponse.getDefaultInstance())
        return this;
      if (other.hasDocumentTranslation()) {
        mergeDocumentTranslation(other.getDocumentTranslation());
      }
      if (other.hasGlossaryDocumentTranslation()) {
        mergeGlossaryDocumentTranslation(other.getGlossaryDocumentTranslation());
      }
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasGlossaryConfig()) {
        mergeGlossaryConfig(other.getGlossaryConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getDocumentTranslationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getGlossaryDocumentTranslationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                model_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getGlossaryConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.translate.v3beta1.DocumentTranslation documentTranslation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.DocumentTranslation,
            com.google.cloud.translate.v3beta1.DocumentTranslation.Builder,
            com.google.cloud.translate.v3beta1.DocumentTranslationOrBuilder>
        documentTranslationBuilder_;

    /**
     *
     *
     * <pre>
     * Translated document.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.DocumentTranslation document_translation = 1;</code>
     *
     * @return Whether the documentTranslation field is set.
     */
    public boolean hasDocumentTranslation() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Translated document.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.DocumentTranslation document_translation = 1;</code>
     *
     * @return The documentTranslation.
     */
    public com.google.cloud.translate.v3beta1.DocumentTranslation getDocumentTranslation() {
      if (documentTranslationBuilder_ == null) {
        return documentTranslation_ == null
            ? com.google.cloud.translate.v3beta1.DocumentTranslation.getDefaultInstance()
            : documentTranslation_;
      } else {
        return documentTranslationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Translated document.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.DocumentTranslation document_translation = 1;</code>
     */
    public Builder setDocumentTranslation(
        com.google.cloud.translate.v3beta1.DocumentTranslation value) {
      if (documentTranslationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentTranslation_ = value;
      } else {
        documentTranslationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Translated document.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.DocumentTranslation document_translation = 1;</code>
     */
    public Builder setDocumentTranslation(
        com.google.cloud.translate.v3beta1.DocumentTranslation.Builder builderForValue) {
      if (documentTranslationBuilder_ == null) {
        documentTranslation_ = builderForValue.build();
      } else {
        documentTranslationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Translated document.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.DocumentTranslation document_translation = 1;</code>
     */
    public Builder mergeDocumentTranslation(
        com.google.cloud.translate.v3beta1.DocumentTranslation value) {
      if (documentTranslationBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && documentTranslation_ != null
            && documentTranslation_
                != com.google.cloud.translate.v3beta1.DocumentTranslation.getDefaultInstance()) {
          getDocumentTranslationBuilder().mergeFrom(value);
        } else {
          documentTranslation_ = value;
        }
      } else {
        documentTranslationBuilder_.mergeFrom(value);
      }
      if (documentTranslation_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Translated document.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.DocumentTranslation document_translation = 1;</code>
     */
    public Builder clearDocumentTranslation() {
      bitField0_ = (bitField0_ & ~0x00000001);
      documentTranslation_ = null;
      if (documentTranslationBuilder_ != null) {
        documentTranslationBuilder_.dispose();
        documentTranslationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Translated document.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.DocumentTranslation document_translation = 1;</code>
     */
    public com.google.cloud.translate.v3beta1.DocumentTranslation.Builder
        getDocumentTranslationBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getDocumentTranslationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Translated document.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.DocumentTranslation document_translation = 1;</code>
     */
    public com.google.cloud.translate.v3beta1.DocumentTranslationOrBuilder
        getDocumentTranslationOrBuilder() {
      if (documentTranslationBuilder_ != null) {
        return documentTranslationBuilder_.getMessageOrBuilder();
      } else {
        return documentTranslation_ == null
            ? com.google.cloud.translate.v3beta1.DocumentTranslation.getDefaultInstance()
            : documentTranslation_;
      }
    }

    /**
     *
     *
     * <pre>
     * Translated document.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.DocumentTranslation document_translation = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.DocumentTranslation,
            com.google.cloud.translate.v3beta1.DocumentTranslation.Builder,
            com.google.cloud.translate.v3beta1.DocumentTranslationOrBuilder>
        getDocumentTranslationFieldBuilder() {
      if (documentTranslationBuilder_ == null) {
        documentTranslationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.translate.v3beta1.DocumentTranslation,
                com.google.cloud.translate.v3beta1.DocumentTranslation.Builder,
                com.google.cloud.translate.v3beta1.DocumentTranslationOrBuilder>(
                getDocumentTranslation(), getParentForChildren(), isClean());
        documentTranslation_ = null;
      }
      return documentTranslationBuilder_;
    }

    private com.google.cloud.translate.v3beta1.DocumentTranslation glossaryDocumentTranslation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.DocumentTranslation,
            com.google.cloud.translate.v3beta1.DocumentTranslation.Builder,
            com.google.cloud.translate.v3beta1.DocumentTranslationOrBuilder>
        glossaryDocumentTranslationBuilder_;

    /**
     *
     *
     * <pre>
     * The document's translation output if a glossary is provided in the request.
     * This can be the same as [TranslateDocumentResponse.document_translation]
     * if no glossary terms apply.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentTranslation glossary_document_translation = 2;
     * </code>
     *
     * @return Whether the glossaryDocumentTranslation field is set.
     */
    public boolean hasGlossaryDocumentTranslation() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The document's translation output if a glossary is provided in the request.
     * This can be the same as [TranslateDocumentResponse.document_translation]
     * if no glossary terms apply.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentTranslation glossary_document_translation = 2;
     * </code>
     *
     * @return The glossaryDocumentTranslation.
     */
    public com.google.cloud.translate.v3beta1.DocumentTranslation getGlossaryDocumentTranslation() {
      if (glossaryDocumentTranslationBuilder_ == null) {
        return glossaryDocumentTranslation_ == null
            ? com.google.cloud.translate.v3beta1.DocumentTranslation.getDefaultInstance()
            : glossaryDocumentTranslation_;
      } else {
        return glossaryDocumentTranslationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The document's translation output if a glossary is provided in the request.
     * This can be the same as [TranslateDocumentResponse.document_translation]
     * if no glossary terms apply.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentTranslation glossary_document_translation = 2;
     * </code>
     */
    public Builder setGlossaryDocumentTranslation(
        com.google.cloud.translate.v3beta1.DocumentTranslation value) {
      if (glossaryDocumentTranslationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        glossaryDocumentTranslation_ = value;
      } else {
        glossaryDocumentTranslationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The document's translation output if a glossary is provided in the request.
     * This can be the same as [TranslateDocumentResponse.document_translation]
     * if no glossary terms apply.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentTranslation glossary_document_translation = 2;
     * </code>
     */
    public Builder setGlossaryDocumentTranslation(
        com.google.cloud.translate.v3beta1.DocumentTranslation.Builder builderForValue) {
      if (glossaryDocumentTranslationBuilder_ == null) {
        glossaryDocumentTranslation_ = builderForValue.build();
      } else {
        glossaryDocumentTranslationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The document's translation output if a glossary is provided in the request.
     * This can be the same as [TranslateDocumentResponse.document_translation]
     * if no glossary terms apply.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentTranslation glossary_document_translation = 2;
     * </code>
     */
    public Builder mergeGlossaryDocumentTranslation(
        com.google.cloud.translate.v3beta1.DocumentTranslation value) {
      if (glossaryDocumentTranslationBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && glossaryDocumentTranslation_ != null
            && glossaryDocumentTranslation_
                != com.google.cloud.translate.v3beta1.DocumentTranslation.getDefaultInstance()) {
          getGlossaryDocumentTranslationBuilder().mergeFrom(value);
        } else {
          glossaryDocumentTranslation_ = value;
        }
      } else {
        glossaryDocumentTranslationBuilder_.mergeFrom(value);
      }
      if (glossaryDocumentTranslation_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The document's translation output if a glossary is provided in the request.
     * This can be the same as [TranslateDocumentResponse.document_translation]
     * if no glossary terms apply.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentTranslation glossary_document_translation = 2;
     * </code>
     */
    public Builder clearGlossaryDocumentTranslation() {
      bitField0_ = (bitField0_ & ~0x00000002);
      glossaryDocumentTranslation_ = null;
      if (glossaryDocumentTranslationBuilder_ != null) {
        glossaryDocumentTranslationBuilder_.dispose();
        glossaryDocumentTranslationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The document's translation output if a glossary is provided in the request.
     * This can be the same as [TranslateDocumentResponse.document_translation]
     * if no glossary terms apply.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentTranslation glossary_document_translation = 2;
     * </code>
     */
    public com.google.cloud.translate.v3beta1.DocumentTranslation.Builder
        getGlossaryDocumentTranslationBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getGlossaryDocumentTranslationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The document's translation output if a glossary is provided in the request.
     * This can be the same as [TranslateDocumentResponse.document_translation]
     * if no glossary terms apply.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentTranslation glossary_document_translation = 2;
     * </code>
     */
    public com.google.cloud.translate.v3beta1.DocumentTranslationOrBuilder
        getGlossaryDocumentTranslationOrBuilder() {
      if (glossaryDocumentTranslationBuilder_ != null) {
        return glossaryDocumentTranslationBuilder_.getMessageOrBuilder();
      } else {
        return glossaryDocumentTranslation_ == null
            ? com.google.cloud.translate.v3beta1.DocumentTranslation.getDefaultInstance()
            : glossaryDocumentTranslation_;
      }
    }

    /**
     *
     *
     * <pre>
     * The document's translation output if a glossary is provided in the request.
     * This can be the same as [TranslateDocumentResponse.document_translation]
     * if no glossary terms apply.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentTranslation glossary_document_translation = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.DocumentTranslation,
            com.google.cloud.translate.v3beta1.DocumentTranslation.Builder,
            com.google.cloud.translate.v3beta1.DocumentTranslationOrBuilder>
        getGlossaryDocumentTranslationFieldBuilder() {
      if (glossaryDocumentTranslationBuilder_ == null) {
        glossaryDocumentTranslationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.translate.v3beta1.DocumentTranslation,
                com.google.cloud.translate.v3beta1.DocumentTranslation.Builder,
                com.google.cloud.translate.v3beta1.DocumentTranslationOrBuilder>(
                getGlossaryDocumentTranslation(), getParentForChildren(), isClean());
        glossaryDocumentTranslation_ = null;
      }
      return glossaryDocumentTranslationBuilder_;
    }

    private java.lang.Object model_ = "";

    /**
     *
     *
     * <pre>
     * Only present when 'model' is present in the request.
     * 'model' is normalized to have a project number.
     *
     * For example:
     * If the 'model' field in TranslateDocumentRequest is:
     * `projects/{project-id}/locations/{location-id}/models/general/nmt` then
     * `model` here would be normalized to
     * `projects/{project-number}/locations/{location-id}/models/general/nmt`.
     * </pre>
     *
     * <code>string model = 3;</code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Only present when 'model' is present in the request.
     * 'model' is normalized to have a project number.
     *
     * For example:
     * If the 'model' field in TranslateDocumentRequest is:
     * `projects/{project-id}/locations/{location-id}/models/general/nmt` then
     * `model` here would be normalized to
     * `projects/{project-number}/locations/{location-id}/models/general/nmt`.
     * </pre>
     *
     * <code>string model = 3;</code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Only present when 'model' is present in the request.
     * 'model' is normalized to have a project number.
     *
     * For example:
     * If the 'model' field in TranslateDocumentRequest is:
     * `projects/{project-id}/locations/{location-id}/models/general/nmt` then
     * `model` here would be normalized to
     * `projects/{project-number}/locations/{location-id}/models/general/nmt`.
     * </pre>
     *
     * <code>string model = 3;</code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      model_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Only present when 'model' is present in the request.
     * 'model' is normalized to have a project number.
     *
     * For example:
     * If the 'model' field in TranslateDocumentRequest is:
     * `projects/{project-id}/locations/{location-id}/models/general/nmt` then
     * `model` here would be normalized to
     * `projects/{project-number}/locations/{location-id}/models/general/nmt`.
     * </pre>
     *
     * <code>string model = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {
      model_ = getDefaultInstance().getModel();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Only present when 'model' is present in the request.
     * 'model' is normalized to have a project number.
     *
     * For example:
     * If the 'model' field in TranslateDocumentRequest is:
     * `projects/{project-id}/locations/{location-id}/models/general/nmt` then
     * `model` here would be normalized to
     * `projects/{project-number}/locations/{location-id}/models/general/nmt`.
     * </pre>
     *
     * <code>string model = 3;</code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      model_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig glossaryConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig,
            com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.Builder,
            com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfigOrBuilder>
        glossaryConfigBuilder_;

    /**
     *
     *
     * <pre>
     * The `glossary_config` used for this translation.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 4;
     * </code>
     *
     * @return Whether the glossaryConfig field is set.
     */
    public boolean hasGlossaryConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The `glossary_config` used for this translation.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 4;
     * </code>
     *
     * @return The glossaryConfig.
     */
    public com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig getGlossaryConfig() {
      if (glossaryConfigBuilder_ == null) {
        return glossaryConfig_ == null
            ? com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.getDefaultInstance()
            : glossaryConfig_;
      } else {
        return glossaryConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The `glossary_config` used for this translation.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 4;
     * </code>
     */
    public Builder setGlossaryConfig(
        com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig value) {
      if (glossaryConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        glossaryConfig_ = value;
      } else {
        glossaryConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The `glossary_config` used for this translation.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 4;
     * </code>
     */
    public Builder setGlossaryConfig(
        com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.Builder builderForValue) {
      if (glossaryConfigBuilder_ == null) {
        glossaryConfig_ = builderForValue.build();
      } else {
        glossaryConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The `glossary_config` used for this translation.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 4;
     * </code>
     */
    public Builder mergeGlossaryConfig(
        com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig value) {
      if (glossaryConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && glossaryConfig_ != null
            && glossaryConfig_
                != com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig
                    .getDefaultInstance()) {
          getGlossaryConfigBuilder().mergeFrom(value);
        } else {
          glossaryConfig_ = value;
        }
      } else {
        glossaryConfigBuilder_.mergeFrom(value);
      }
      if (glossaryConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The `glossary_config` used for this translation.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 4;
     * </code>
     */
    public Builder clearGlossaryConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      glossaryConfig_ = null;
      if (glossaryConfigBuilder_ != null) {
        glossaryConfigBuilder_.dispose();
        glossaryConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The `glossary_config` used for this translation.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 4;
     * </code>
     */
    public com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.Builder
        getGlossaryConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getGlossaryConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The `glossary_config` used for this translation.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 4;
     * </code>
     */
    public com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfigOrBuilder
        getGlossaryConfigOrBuilder() {
      if (glossaryConfigBuilder_ != null) {
        return glossaryConfigBuilder_.getMessageOrBuilder();
      } else {
        return glossaryConfig_ == null
            ? com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.getDefaultInstance()
            : glossaryConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * The `glossary_config` used for this translation.
     * </pre>
     *
     * <code>.google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig,
            com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.Builder,
            com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfigOrBuilder>
        getGlossaryConfigFieldBuilder() {
      if (glossaryConfigBuilder_ == null) {
        glossaryConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig,
                com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.Builder,
                com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfigOrBuilder>(
                getGlossaryConfig(), getParentForChildren(), isClean());
        glossaryConfig_ = null;
      }
      return glossaryConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3beta1.TranslateDocumentResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.translation.v3beta1.TranslateDocumentResponse)
  private static final com.google.cloud.translate.v3beta1.TranslateDocumentResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.translate.v3beta1.TranslateDocumentResponse();
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TranslateDocumentResponse> PARSER =
      new com.google.protobuf.AbstractParser<TranslateDocumentResponse>() {
        @java.lang.Override
        public TranslateDocumentResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TranslateDocumentResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TranslateDocumentResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.translate.v3beta1.TranslateDocumentResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
