/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/translate/v3beta1/translation_service.proto

package com.google.cloud.translate.v3beta1;

/**
 *
 *
 * <pre>
 * A document translation request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.translation.v3beta1.TranslateDocumentRequest}
 */
public final class TranslateDocumentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.translation.v3beta1.TranslateDocumentRequest)
    TranslateDocumentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TranslateDocumentRequest.newBuilder() to construct.
  private TranslateDocumentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TranslateDocumentRequest() {
    parent_ = "";
    sourceLanguageCode_ = "";
    targetLanguageCode_ = "";
    model_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TranslateDocumentRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private TranslateDocumentRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              parent_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              sourceLanguageCode_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              targetLanguageCode_ = s;
              break;
            }
          case 34:
            {
              com.google.cloud.translate.v3beta1.DocumentInputConfig.Builder subBuilder = null;
              if (documentInputConfig_ != null) {
                subBuilder = documentInputConfig_.toBuilder();
              }
              documentInputConfig_ =
                  input.readMessage(
                      com.google.cloud.translate.v3beta1.DocumentInputConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(documentInputConfig_);
                documentInputConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.cloud.translate.v3beta1.DocumentOutputConfig.Builder subBuilder = null;
              if (documentOutputConfig_ != null) {
                subBuilder = documentOutputConfig_.toBuilder();
              }
              documentOutputConfig_ =
                  input.readMessage(
                      com.google.cloud.translate.v3beta1.DocumentOutputConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(documentOutputConfig_);
                documentOutputConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              model_ = s;
              break;
            }
          case 58:
            {
              com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.Builder subBuilder =
                  null;
              if (glossaryConfig_ != null) {
                subBuilder = glossaryConfig_.toBuilder();
              }
              glossaryConfig_ =
                  input.readMessage(
                      com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(glossaryConfig_);
                glossaryConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 66:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                labels_ =
                    com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                  input.readMessage(
                      LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.translate.v3beta1.TranslationServiceProto
        .internal_static_google_cloud_translation_v3beta1_TranslateDocumentRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 8:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.translate.v3beta1.TranslationServiceProto
        .internal_static_google_cloud_translation_v3beta1_TranslateDocumentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.translate.v3beta1.TranslateDocumentRequest.class,
            com.google.cloud.translate.v3beta1.TranslateDocumentRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. Location to make a regional call.
   * Format: `projects/{project-number-or-id}/locations/{location-id}`.
   * For global calls, use `projects/{project-number-or-id}/locations/global` or
   * `projects/{project-number-or-id}`.
   * Non-global location is required for requests using AutoML models or custom
   * glossaries.
   * Models and glossaries must be within the same region (have the same
   * location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Location to make a regional call.
   * Format: `projects/{project-number-or-id}/locations/{location-id}`.
   * For global calls, use `projects/{project-number-or-id}/locations/global` or
   * `projects/{project-number-or-id}`.
   * Non-global location is required for requests using AutoML models or custom
   * glossaries.
   * Models and glossaries must be within the same region (have the same
   * location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_LANGUAGE_CODE_FIELD_NUMBER = 2;
  private volatile java.lang.Object sourceLanguageCode_;
  /**
   *
   *
   * <pre>
   * Optional. The BCP-47 language code of the input document if known, for
   * example, "en-US" or "sr-Latn". Supported language codes are listed in
   * Language Support. If the source language isn't specified, the API attempts
   * to identify the source language automatically and returns the source
   * language within the response. Source language must be specified if the
   * request contains a glossary or a custom model.
   * </pre>
   *
   * <code>string source_language_code = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The sourceLanguageCode.
   */
  @java.lang.Override
  public java.lang.String getSourceLanguageCode() {
    java.lang.Object ref = sourceLanguageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceLanguageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The BCP-47 language code of the input document if known, for
   * example, "en-US" or "sr-Latn". Supported language codes are listed in
   * Language Support. If the source language isn't specified, the API attempts
   * to identify the source language automatically and returns the source
   * language within the response. Source language must be specified if the
   * request contains a glossary or a custom model.
   * </pre>
   *
   * <code>string source_language_code = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for sourceLanguageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceLanguageCodeBytes() {
    java.lang.Object ref = sourceLanguageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceLanguageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_LANGUAGE_CODE_FIELD_NUMBER = 3;
  private volatile java.lang.Object targetLanguageCode_;
  /**
   *
   *
   * <pre>
   * Required. The BCP-47 language code to use for translation of the input
   * document, set to one of the language codes listed in Language Support.
   * </pre>
   *
   * <code>string target_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The targetLanguageCode.
   */
  @java.lang.Override
  public java.lang.String getTargetLanguageCode() {
    java.lang.Object ref = targetLanguageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetLanguageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The BCP-47 language code to use for translation of the input
   * document, set to one of the language codes listed in Language Support.
   * </pre>
   *
   * <code>string target_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for targetLanguageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetLanguageCodeBytes() {
    java.lang.Object ref = targetLanguageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetLanguageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCUMENT_INPUT_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.translate.v3beta1.DocumentInputConfig documentInputConfig_;
  /**
   *
   *
   * <pre>
   * Required. Input configurations.
   * </pre>
   *
   * <code>
   * .google.cloud.translation.v3beta1.DocumentInputConfig document_input_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the documentInputConfig field is set.
   */
  @java.lang.Override
  public boolean hasDocumentInputConfig() {
    return documentInputConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Input configurations.
   * </pre>
   *
   * <code>
   * .google.cloud.translation.v3beta1.DocumentInputConfig document_input_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The documentInputConfig.
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.DocumentInputConfig getDocumentInputConfig() {
    return documentInputConfig_ == null
        ? com.google.cloud.translate.v3beta1.DocumentInputConfig.getDefaultInstance()
        : documentInputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Input configurations.
   * </pre>
   *
   * <code>
   * .google.cloud.translation.v3beta1.DocumentInputConfig document_input_config = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.DocumentInputConfigOrBuilder
      getDocumentInputConfigOrBuilder() {
    return getDocumentInputConfig();
  }

  public static final int DOCUMENT_OUTPUT_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.translate.v3beta1.DocumentOutputConfig documentOutputConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Output configurations.
   * Defines if the output file should be stored within Cloud Storage as well
   * as the desired output format. If not provided the translated file will
   * only be returned through a byte-stream and its output mime type will be
   * the same as the input file's mime type.
   * </pre>
   *
   * <code>
   * .google.cloud.translation.v3beta1.DocumentOutputConfig document_output_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the documentOutputConfig field is set.
   */
  @java.lang.Override
  public boolean hasDocumentOutputConfig() {
    return documentOutputConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Output configurations.
   * Defines if the output file should be stored within Cloud Storage as well
   * as the desired output format. If not provided the translated file will
   * only be returned through a byte-stream and its output mime type will be
   * the same as the input file's mime type.
   * </pre>
   *
   * <code>
   * .google.cloud.translation.v3beta1.DocumentOutputConfig document_output_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The documentOutputConfig.
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.DocumentOutputConfig getDocumentOutputConfig() {
    return documentOutputConfig_ == null
        ? com.google.cloud.translate.v3beta1.DocumentOutputConfig.getDefaultInstance()
        : documentOutputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Output configurations.
   * Defines if the output file should be stored within Cloud Storage as well
   * as the desired output format. If not provided the translated file will
   * only be returned through a byte-stream and its output mime type will be
   * the same as the input file's mime type.
   * </pre>
   *
   * <code>
   * .google.cloud.translation.v3beta1.DocumentOutputConfig document_output_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.DocumentOutputConfigOrBuilder
      getDocumentOutputConfigOrBuilder() {
    return getDocumentOutputConfig();
  }

  public static final int MODEL_FIELD_NUMBER = 6;
  private volatile java.lang.Object model_;
  /**
   *
   *
   * <pre>
   * Optional. The `model` type requested for this translation.
   * The format depends on model type:
   * - AutoML Translation models:
   *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
   * - General (built-in) models:
   *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
   *   `projects/{project-number-or-id}/locations/{location-id}/models/general/base`
   * If not provided, the default Google model (NMT) will be used for
   * translation.
   * </pre>
   *
   * <code>string model = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The model.
   */
  @java.lang.Override
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The `model` type requested for this translation.
   * The format depends on model type:
   * - AutoML Translation models:
   *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
   * - General (built-in) models:
   *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
   *   `projects/{project-number-or-id}/locations/{location-id}/models/general/base`
   * If not provided, the default Google model (NMT) will be used for
   * translation.
   * </pre>
   *
   * <code>string model = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for model.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GLOSSARY_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig glossaryConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Glossary to be applied. The glossary must be within the same
   * region (have the same location-id) as the model, otherwise an
   * INVALID_ARGUMENT (400) error is returned.
   * </pre>
   *
   * <code>
   * .google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the glossaryConfig field is set.
   */
  @java.lang.Override
  public boolean hasGlossaryConfig() {
    return glossaryConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Glossary to be applied. The glossary must be within the same
   * region (have the same location-id) as the model, otherwise an
   * INVALID_ARGUMENT (400) error is returned.
   * </pre>
   *
   * <code>
   * .google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The glossaryConfig.
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig getGlossaryConfig() {
    return glossaryConfig_ == null
        ? com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.getDefaultInstance()
        : glossaryConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Glossary to be applied. The glossary must be within the same
   * region (have the same location-id) as the model, otherwise an
   * INVALID_ARGUMENT (400) error is returned.
   * </pre>
   *
   * <code>
   * .google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfigOrBuilder
      getGlossaryConfigOrBuilder() {
    return getGlossaryConfig();
  }

  public static final int LABELS_FIELD_NUMBER = 8;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.translate.v3beta1.TranslationServiceProto
                .internal_static_google_cloud_translation_v3beta1_TranslateDocumentRequest_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata for the request.
   * Label keys and values can be no longer than 63 characters (Unicode
   * codepoints), can only contain lowercase letters, numeric characters,
   * underscores and dashes. International characters are allowed. Label values
   * are optional. Label keys must start with a letter.
   * See https://cloud.google.com/translate/docs/advanced/labels for more
   * information.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata for the request.
   * Label keys and values can be no longer than 63 characters (Unicode
   * codepoints), can only contain lowercase letters, numeric characters,
   * underscores and dashes. International characters are allowed. Label values
   * are optional. Label keys must start with a letter.
   * See https://cloud.google.com/translate/docs/advanced/labels for more
   * information.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata for the request.
   * Label keys and values can be no longer than 63 characters (Unicode
   * codepoints), can only contain lowercase letters, numeric characters,
   * underscores and dashes. International characters are allowed. Label values
   * are optional. Label keys must start with a letter.
   * See https://cloud.google.com/translate/docs/advanced/labels for more
   * information.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata for the request.
   * Label keys and values can be no longer than 63 characters (Unicode
   * codepoints), can only contain lowercase letters, numeric characters,
   * underscores and dashes. International characters are allowed. Label values
   * are optional. Label keys must start with a letter.
   * See https://cloud.google.com/translate/docs/advanced/labels for more
   * information.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getParentBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!getSourceLanguageCodeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sourceLanguageCode_);
    }
    if (!getTargetLanguageCodeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, targetLanguageCode_);
    }
    if (documentInputConfig_ != null) {
      output.writeMessage(4, getDocumentInputConfig());
    }
    if (documentOutputConfig_ != null) {
      output.writeMessage(5, getDocumentOutputConfig());
    }
    if (!getModelBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, model_);
    }
    if (glossaryConfig_ != null) {
      output.writeMessage(7, getGlossaryConfig());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 8);
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getParentBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!getSourceLanguageCodeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sourceLanguageCode_);
    }
    if (!getTargetLanguageCodeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, targetLanguageCode_);
    }
    if (documentInputConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDocumentInputConfig());
    }
    if (documentOutputConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDocumentOutputConfig());
    }
    if (!getModelBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, model_);
    }
    if (glossaryConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getGlossaryConfig());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, labels__);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.translate.v3beta1.TranslateDocumentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.translate.v3beta1.TranslateDocumentRequest other =
        (com.google.cloud.translate.v3beta1.TranslateDocumentRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getSourceLanguageCode().equals(other.getSourceLanguageCode())) return false;
    if (!getTargetLanguageCode().equals(other.getTargetLanguageCode())) return false;
    if (hasDocumentInputConfig() != other.hasDocumentInputConfig()) return false;
    if (hasDocumentInputConfig()) {
      if (!getDocumentInputConfig().equals(other.getDocumentInputConfig())) return false;
    }
    if (hasDocumentOutputConfig() != other.hasDocumentOutputConfig()) return false;
    if (hasDocumentOutputConfig()) {
      if (!getDocumentOutputConfig().equals(other.getDocumentOutputConfig())) return false;
    }
    if (!getModel().equals(other.getModel())) return false;
    if (hasGlossaryConfig() != other.hasGlossaryConfig()) return false;
    if (hasGlossaryConfig()) {
      if (!getGlossaryConfig().equals(other.getGlossaryConfig())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + SOURCE_LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getSourceLanguageCode().hashCode();
    hash = (37 * hash) + TARGET_LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getTargetLanguageCode().hashCode();
    if (hasDocumentInputConfig()) {
      hash = (37 * hash) + DOCUMENT_INPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentInputConfig().hashCode();
    }
    if (hasDocumentOutputConfig()) {
      hash = (37 * hash) + DOCUMENT_OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentOutputConfig().hashCode();
    }
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    if (hasGlossaryConfig()) {
      hash = (37 * hash) + GLOSSARY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getGlossaryConfig().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.translate.v3beta1.TranslateDocumentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A document translation request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.translation.v3beta1.TranslateDocumentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3beta1.TranslateDocumentRequest)
      com.google.cloud.translate.v3beta1.TranslateDocumentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_TranslateDocumentRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 8:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 8:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_TranslateDocumentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3beta1.TranslateDocumentRequest.class,
              com.google.cloud.translate.v3beta1.TranslateDocumentRequest.Builder.class);
    }

    // Construct using com.google.cloud.translate.v3beta1.TranslateDocumentRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      sourceLanguageCode_ = "";

      targetLanguageCode_ = "";

      if (documentInputConfigBuilder_ == null) {
        documentInputConfig_ = null;
      } else {
        documentInputConfig_ = null;
        documentInputConfigBuilder_ = null;
      }
      if (documentOutputConfigBuilder_ == null) {
        documentOutputConfig_ = null;
      } else {
        documentOutputConfig_ = null;
        documentOutputConfigBuilder_ = null;
      }
      model_ = "";

      if (glossaryConfigBuilder_ == null) {
        glossaryConfig_ = null;
      } else {
        glossaryConfig_ = null;
        glossaryConfigBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_TranslateDocumentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3beta1.TranslateDocumentRequest getDefaultInstanceForType() {
      return com.google.cloud.translate.v3beta1.TranslateDocumentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.translate.v3beta1.TranslateDocumentRequest build() {
      com.google.cloud.translate.v3beta1.TranslateDocumentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3beta1.TranslateDocumentRequest buildPartial() {
      com.google.cloud.translate.v3beta1.TranslateDocumentRequest result =
          new com.google.cloud.translate.v3beta1.TranslateDocumentRequest(this);
      int from_bitField0_ = bitField0_;
      result.parent_ = parent_;
      result.sourceLanguageCode_ = sourceLanguageCode_;
      result.targetLanguageCode_ = targetLanguageCode_;
      if (documentInputConfigBuilder_ == null) {
        result.documentInputConfig_ = documentInputConfig_;
      } else {
        result.documentInputConfig_ = documentInputConfigBuilder_.build();
      }
      if (documentOutputConfigBuilder_ == null) {
        result.documentOutputConfig_ = documentOutputConfig_;
      } else {
        result.documentOutputConfig_ = documentOutputConfigBuilder_.build();
      }
      result.model_ = model_;
      if (glossaryConfigBuilder_ == null) {
        result.glossaryConfig_ = glossaryConfig_;
      } else {
        result.glossaryConfig_ = glossaryConfigBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.translate.v3beta1.TranslateDocumentRequest) {
        return mergeFrom((com.google.cloud.translate.v3beta1.TranslateDocumentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.translate.v3beta1.TranslateDocumentRequest other) {
      if (other == com.google.cloud.translate.v3beta1.TranslateDocumentRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (!other.getSourceLanguageCode().isEmpty()) {
        sourceLanguageCode_ = other.sourceLanguageCode_;
        onChanged();
      }
      if (!other.getTargetLanguageCode().isEmpty()) {
        targetLanguageCode_ = other.targetLanguageCode_;
        onChanged();
      }
      if (other.hasDocumentInputConfig()) {
        mergeDocumentInputConfig(other.getDocumentInputConfig());
      }
      if (other.hasDocumentOutputConfig()) {
        mergeDocumentOutputConfig(other.getDocumentOutputConfig());
      }
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        onChanged();
      }
      if (other.hasGlossaryConfig()) {
        mergeGlossaryConfig(other.getGlossaryConfig());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.translate.v3beta1.TranslateDocumentRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.translate.v3beta1.TranslateDocumentRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * For global calls, use `projects/{project-number-or-id}/locations/global` or
     * `projects/{project-number-or-id}`.
     * Non-global location is required for requests using AutoML models or custom
     * glossaries.
     * Models and glossaries must be within the same region (have the same
     * location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * For global calls, use `projects/{project-number-or-id}/locations/global` or
     * `projects/{project-number-or-id}`.
     * Non-global location is required for requests using AutoML models or custom
     * glossaries.
     * Models and glossaries must be within the same region (have the same
     * location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * For global calls, use `projects/{project-number-or-id}/locations/global` or
     * `projects/{project-number-or-id}`.
     * Non-global location is required for requests using AutoML models or custom
     * glossaries.
     * Models and glossaries must be within the same region (have the same
     * location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * For global calls, use `projects/{project-number-or-id}/locations/global` or
     * `projects/{project-number-or-id}`.
     * Non-global location is required for requests using AutoML models or custom
     * glossaries.
     * Models and glossaries must be within the same region (have the same
     * location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * For global calls, use `projects/{project-number-or-id}/locations/global` or
     * `projects/{project-number-or-id}`.
     * Non-global location is required for requests using AutoML models or custom
     * glossaries.
     * Models and glossaries must be within the same region (have the same
     * location-id), otherwise an INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object sourceLanguageCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code of the input document if known, for
     * example, "en-US" or "sr-Latn". Supported language codes are listed in
     * Language Support. If the source language isn't specified, the API attempts
     * to identify the source language automatically and returns the source
     * language within the response. Source language must be specified if the
     * request contains a glossary or a custom model.
     * </pre>
     *
     * <code>string source_language_code = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The sourceLanguageCode.
     */
    public java.lang.String getSourceLanguageCode() {
      java.lang.Object ref = sourceLanguageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceLanguageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code of the input document if known, for
     * example, "en-US" or "sr-Latn". Supported language codes are listed in
     * Language Support. If the source language isn't specified, the API attempts
     * to identify the source language automatically and returns the source
     * language within the response. Source language must be specified if the
     * request contains a glossary or a custom model.
     * </pre>
     *
     * <code>string source_language_code = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for sourceLanguageCode.
     */
    public com.google.protobuf.ByteString getSourceLanguageCodeBytes() {
      java.lang.Object ref = sourceLanguageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceLanguageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code of the input document if known, for
     * example, "en-US" or "sr-Latn". Supported language codes are listed in
     * Language Support. If the source language isn't specified, the API attempts
     * to identify the source language automatically and returns the source
     * language within the response. Source language must be specified if the
     * request contains a glossary or a custom model.
     * </pre>
     *
     * <code>string source_language_code = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The sourceLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setSourceLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      sourceLanguageCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code of the input document if known, for
     * example, "en-US" or "sr-Latn". Supported language codes are listed in
     * Language Support. If the source language isn't specified, the API attempts
     * to identify the source language automatically and returns the source
     * language within the response. Source language must be specified if the
     * request contains a glossary or a custom model.
     * </pre>
     *
     * <code>string source_language_code = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceLanguageCode() {

      sourceLanguageCode_ = getDefaultInstance().getSourceLanguageCode();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code of the input document if known, for
     * example, "en-US" or "sr-Latn". Supported language codes are listed in
     * Language Support. If the source language isn't specified, the API attempts
     * to identify the source language automatically and returns the source
     * language within the response. Source language must be specified if the
     * request contains a glossary or a custom model.
     * </pre>
     *
     * <code>string source_language_code = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for sourceLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setSourceLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      sourceLanguageCode_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object targetLanguageCode_ = "";
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code to use for translation of the input
     * document, set to one of the language codes listed in Language Support.
     * </pre>
     *
     * <code>string target_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The targetLanguageCode.
     */
    public java.lang.String getTargetLanguageCode() {
      java.lang.Object ref = targetLanguageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetLanguageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code to use for translation of the input
     * document, set to one of the language codes listed in Language Support.
     * </pre>
     *
     * <code>string target_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for targetLanguageCode.
     */
    public com.google.protobuf.ByteString getTargetLanguageCodeBytes() {
      java.lang.Object ref = targetLanguageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetLanguageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code to use for translation of the input
     * document, set to one of the language codes listed in Language Support.
     * </pre>
     *
     * <code>string target_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The targetLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setTargetLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      targetLanguageCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code to use for translation of the input
     * document, set to one of the language codes listed in Language Support.
     * </pre>
     *
     * <code>string target_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetLanguageCode() {

      targetLanguageCode_ = getDefaultInstance().getTargetLanguageCode();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code to use for translation of the input
     * document, set to one of the language codes listed in Language Support.
     * </pre>
     *
     * <code>string target_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for targetLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setTargetLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      targetLanguageCode_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.translate.v3beta1.DocumentInputConfig documentInputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.DocumentInputConfig,
            com.google.cloud.translate.v3beta1.DocumentInputConfig.Builder,
            com.google.cloud.translate.v3beta1.DocumentInputConfigOrBuilder>
        documentInputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentInputConfig document_input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the documentInputConfig field is set.
     */
    public boolean hasDocumentInputConfig() {
      return documentInputConfigBuilder_ != null || documentInputConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentInputConfig document_input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The documentInputConfig.
     */
    public com.google.cloud.translate.v3beta1.DocumentInputConfig getDocumentInputConfig() {
      if (documentInputConfigBuilder_ == null) {
        return documentInputConfig_ == null
            ? com.google.cloud.translate.v3beta1.DocumentInputConfig.getDefaultInstance()
            : documentInputConfig_;
      } else {
        return documentInputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentInputConfig document_input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDocumentInputConfig(
        com.google.cloud.translate.v3beta1.DocumentInputConfig value) {
      if (documentInputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentInputConfig_ = value;
        onChanged();
      } else {
        documentInputConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentInputConfig document_input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDocumentInputConfig(
        com.google.cloud.translate.v3beta1.DocumentInputConfig.Builder builderForValue) {
      if (documentInputConfigBuilder_ == null) {
        documentInputConfig_ = builderForValue.build();
        onChanged();
      } else {
        documentInputConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentInputConfig document_input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDocumentInputConfig(
        com.google.cloud.translate.v3beta1.DocumentInputConfig value) {
      if (documentInputConfigBuilder_ == null) {
        if (documentInputConfig_ != null) {
          documentInputConfig_ =
              com.google.cloud.translate.v3beta1.DocumentInputConfig.newBuilder(
                      documentInputConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          documentInputConfig_ = value;
        }
        onChanged();
      } else {
        documentInputConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentInputConfig document_input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDocumentInputConfig() {
      if (documentInputConfigBuilder_ == null) {
        documentInputConfig_ = null;
        onChanged();
      } else {
        documentInputConfig_ = null;
        documentInputConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentInputConfig document_input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.translate.v3beta1.DocumentInputConfig.Builder
        getDocumentInputConfigBuilder() {

      onChanged();
      return getDocumentInputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentInputConfig document_input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.translate.v3beta1.DocumentInputConfigOrBuilder
        getDocumentInputConfigOrBuilder() {
      if (documentInputConfigBuilder_ != null) {
        return documentInputConfigBuilder_.getMessageOrBuilder();
      } else {
        return documentInputConfig_ == null
            ? com.google.cloud.translate.v3beta1.DocumentInputConfig.getDefaultInstance()
            : documentInputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentInputConfig document_input_config = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.DocumentInputConfig,
            com.google.cloud.translate.v3beta1.DocumentInputConfig.Builder,
            com.google.cloud.translate.v3beta1.DocumentInputConfigOrBuilder>
        getDocumentInputConfigFieldBuilder() {
      if (documentInputConfigBuilder_ == null) {
        documentInputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.translate.v3beta1.DocumentInputConfig,
                com.google.cloud.translate.v3beta1.DocumentInputConfig.Builder,
                com.google.cloud.translate.v3beta1.DocumentInputConfigOrBuilder>(
                getDocumentInputConfig(), getParentForChildren(), isClean());
        documentInputConfig_ = null;
      }
      return documentInputConfigBuilder_;
    }

    private com.google.cloud.translate.v3beta1.DocumentOutputConfig documentOutputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.DocumentOutputConfig,
            com.google.cloud.translate.v3beta1.DocumentOutputConfig.Builder,
            com.google.cloud.translate.v3beta1.DocumentOutputConfigOrBuilder>
        documentOutputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Output configurations.
     * Defines if the output file should be stored within Cloud Storage as well
     * as the desired output format. If not provided the translated file will
     * only be returned through a byte-stream and its output mime type will be
     * the same as the input file's mime type.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentOutputConfig document_output_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the documentOutputConfig field is set.
     */
    public boolean hasDocumentOutputConfig() {
      return documentOutputConfigBuilder_ != null || documentOutputConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output configurations.
     * Defines if the output file should be stored within Cloud Storage as well
     * as the desired output format. If not provided the translated file will
     * only be returned through a byte-stream and its output mime type will be
     * the same as the input file's mime type.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentOutputConfig document_output_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The documentOutputConfig.
     */
    public com.google.cloud.translate.v3beta1.DocumentOutputConfig getDocumentOutputConfig() {
      if (documentOutputConfigBuilder_ == null) {
        return documentOutputConfig_ == null
            ? com.google.cloud.translate.v3beta1.DocumentOutputConfig.getDefaultInstance()
            : documentOutputConfig_;
      } else {
        return documentOutputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Output configurations.
     * Defines if the output file should be stored within Cloud Storage as well
     * as the desired output format. If not provided the translated file will
     * only be returned through a byte-stream and its output mime type will be
     * the same as the input file's mime type.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentOutputConfig document_output_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDocumentOutputConfig(
        com.google.cloud.translate.v3beta1.DocumentOutputConfig value) {
      if (documentOutputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentOutputConfig_ = value;
        onChanged();
      } else {
        documentOutputConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output configurations.
     * Defines if the output file should be stored within Cloud Storage as well
     * as the desired output format. If not provided the translated file will
     * only be returned through a byte-stream and its output mime type will be
     * the same as the input file's mime type.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentOutputConfig document_output_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDocumentOutputConfig(
        com.google.cloud.translate.v3beta1.DocumentOutputConfig.Builder builderForValue) {
      if (documentOutputConfigBuilder_ == null) {
        documentOutputConfig_ = builderForValue.build();
        onChanged();
      } else {
        documentOutputConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output configurations.
     * Defines if the output file should be stored within Cloud Storage as well
     * as the desired output format. If not provided the translated file will
     * only be returned through a byte-stream and its output mime type will be
     * the same as the input file's mime type.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentOutputConfig document_output_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDocumentOutputConfig(
        com.google.cloud.translate.v3beta1.DocumentOutputConfig value) {
      if (documentOutputConfigBuilder_ == null) {
        if (documentOutputConfig_ != null) {
          documentOutputConfig_ =
              com.google.cloud.translate.v3beta1.DocumentOutputConfig.newBuilder(
                      documentOutputConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          documentOutputConfig_ = value;
        }
        onChanged();
      } else {
        documentOutputConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output configurations.
     * Defines if the output file should be stored within Cloud Storage as well
     * as the desired output format. If not provided the translated file will
     * only be returned through a byte-stream and its output mime type will be
     * the same as the input file's mime type.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentOutputConfig document_output_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDocumentOutputConfig() {
      if (documentOutputConfigBuilder_ == null) {
        documentOutputConfig_ = null;
        onChanged();
      } else {
        documentOutputConfig_ = null;
        documentOutputConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Output configurations.
     * Defines if the output file should be stored within Cloud Storage as well
     * as the desired output format. If not provided the translated file will
     * only be returned through a byte-stream and its output mime type will be
     * the same as the input file's mime type.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentOutputConfig document_output_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.translate.v3beta1.DocumentOutputConfig.Builder
        getDocumentOutputConfigBuilder() {

      onChanged();
      return getDocumentOutputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Output configurations.
     * Defines if the output file should be stored within Cloud Storage as well
     * as the desired output format. If not provided the translated file will
     * only be returned through a byte-stream and its output mime type will be
     * the same as the input file's mime type.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentOutputConfig document_output_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.translate.v3beta1.DocumentOutputConfigOrBuilder
        getDocumentOutputConfigOrBuilder() {
      if (documentOutputConfigBuilder_ != null) {
        return documentOutputConfigBuilder_.getMessageOrBuilder();
      } else {
        return documentOutputConfig_ == null
            ? com.google.cloud.translate.v3beta1.DocumentOutputConfig.getDefaultInstance()
            : documentOutputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Output configurations.
     * Defines if the output file should be stored within Cloud Storage as well
     * as the desired output format. If not provided the translated file will
     * only be returned through a byte-stream and its output mime type will be
     * the same as the input file's mime type.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.DocumentOutputConfig document_output_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.DocumentOutputConfig,
            com.google.cloud.translate.v3beta1.DocumentOutputConfig.Builder,
            com.google.cloud.translate.v3beta1.DocumentOutputConfigOrBuilder>
        getDocumentOutputConfigFieldBuilder() {
      if (documentOutputConfigBuilder_ == null) {
        documentOutputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.translate.v3beta1.DocumentOutputConfig,
                com.google.cloud.translate.v3beta1.DocumentOutputConfig.Builder,
                com.google.cloud.translate.v3beta1.DocumentOutputConfigOrBuilder>(
                getDocumentOutputConfig(), getParentForChildren(), isClean());
        documentOutputConfig_ = null;
      }
      return documentOutputConfigBuilder_;
    }

    private java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The `model` type requested for this translation.
     * The format depends on model type:
     * - AutoML Translation models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
     * - General (built-in) models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
     *   `projects/{project-number-or-id}/locations/{location-id}/models/general/base`
     * If not provided, the default Google model (NMT) will be used for
     * translation.
     * </pre>
     *
     * <code>string model = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The `model` type requested for this translation.
     * The format depends on model type:
     * - AutoML Translation models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
     * - General (built-in) models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
     *   `projects/{project-number-or-id}/locations/{location-id}/models/general/base`
     * If not provided, the default Google model (NMT) will be used for
     * translation.
     * </pre>
     *
     * <code>string model = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The `model` type requested for this translation.
     * The format depends on model type:
     * - AutoML Translation models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
     * - General (built-in) models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
     *   `projects/{project-number-or-id}/locations/{location-id}/models/general/base`
     * If not provided, the default Google model (NMT) will be used for
     * translation.
     * </pre>
     *
     * <code>string model = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      model_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `model` type requested for this translation.
     * The format depends on model type:
     * - AutoML Translation models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
     * - General (built-in) models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
     *   `projects/{project-number-or-id}/locations/{location-id}/models/general/base`
     * If not provided, the default Google model (NMT) will be used for
     * translation.
     * </pre>
     *
     * <code>string model = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {

      model_ = getDefaultInstance().getModel();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `model` type requested for this translation.
     * The format depends on model type:
     * - AutoML Translation models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
     * - General (built-in) models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
     *   `projects/{project-number-or-id}/locations/{location-id}/models/general/base`
     * If not provided, the default Google model (NMT) will be used for
     * translation.
     * </pre>
     *
     * <code>string model = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      model_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig glossaryConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig,
            com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.Builder,
            com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfigOrBuilder>
        glossaryConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be within the same
     * region (have the same location-id) as the model, otherwise an
     * INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the glossaryConfig field is set.
     */
    public boolean hasGlossaryConfig() {
      return glossaryConfigBuilder_ != null || glossaryConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be within the same
     * region (have the same location-id) as the model, otherwise an
     * INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The glossaryConfig.
     */
    public com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig getGlossaryConfig() {
      if (glossaryConfigBuilder_ == null) {
        return glossaryConfig_ == null
            ? com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.getDefaultInstance()
            : glossaryConfig_;
      } else {
        return glossaryConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be within the same
     * region (have the same location-id) as the model, otherwise an
     * INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGlossaryConfig(
        com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig value) {
      if (glossaryConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        glossaryConfig_ = value;
        onChanged();
      } else {
        glossaryConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be within the same
     * region (have the same location-id) as the model, otherwise an
     * INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGlossaryConfig(
        com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.Builder builderForValue) {
      if (glossaryConfigBuilder_ == null) {
        glossaryConfig_ = builderForValue.build();
        onChanged();
      } else {
        glossaryConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be within the same
     * region (have the same location-id) as the model, otherwise an
     * INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGlossaryConfig(
        com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig value) {
      if (glossaryConfigBuilder_ == null) {
        if (glossaryConfig_ != null) {
          glossaryConfig_ =
              com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.newBuilder(
                      glossaryConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          glossaryConfig_ = value;
        }
        onChanged();
      } else {
        glossaryConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be within the same
     * region (have the same location-id) as the model, otherwise an
     * INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGlossaryConfig() {
      if (glossaryConfigBuilder_ == null) {
        glossaryConfig_ = null;
        onChanged();
      } else {
        glossaryConfig_ = null;
        glossaryConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be within the same
     * region (have the same location-id) as the model, otherwise an
     * INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.Builder
        getGlossaryConfigBuilder() {

      onChanged();
      return getGlossaryConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be within the same
     * region (have the same location-id) as the model, otherwise an
     * INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfigOrBuilder
        getGlossaryConfigOrBuilder() {
      if (glossaryConfigBuilder_ != null) {
        return glossaryConfigBuilder_.getMessageOrBuilder();
      } else {
        return glossaryConfig_ == null
            ? com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.getDefaultInstance()
            : glossaryConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be within the same
     * region (have the same location-id) as the model, otherwise an
     * INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3beta1.TranslateTextGlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig,
            com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.Builder,
            com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfigOrBuilder>
        getGlossaryConfigFieldBuilder() {
      if (glossaryConfigBuilder_ == null) {
        glossaryConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig,
                com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfig.Builder,
                com.google.cloud.translate.v3beta1.TranslateTextGlossaryConfigOrBuilder>(
                getGlossaryConfig(), getParentForChildren(), isClean());
        glossaryConfig_ = null;
      }
      return glossaryConfigBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     * Label keys and values can be no longer than 63 characters (Unicode
     * codepoints), can only contain lowercase letters, numeric characters,
     * underscores and dashes. International characters are allowed. Label values
     * are optional. Label keys must start with a letter.
     * See https://cloud.google.com/translate/docs/advanced/labels for more
     * information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     * Label keys and values can be no longer than 63 characters (Unicode
     * codepoints), can only contain lowercase letters, numeric characters,
     * underscores and dashes. International characters are allowed. Label values
     * are optional. Label keys must start with a letter.
     * See https://cloud.google.com/translate/docs/advanced/labels for more
     * information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     * Label keys and values can be no longer than 63 characters (Unicode
     * codepoints), can only contain lowercase letters, numeric characters,
     * underscores and dashes. International characters are allowed. Label values
     * are optional. Label keys must start with a letter.
     * See https://cloud.google.com/translate/docs/advanced/labels for more
     * information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     * Label keys and values can be no longer than 63 characters (Unicode
     * codepoints), can only contain lowercase letters, numeric characters,
     * underscores and dashes. International characters are allowed. Label values
     * are optional. Label keys must start with a letter.
     * See https://cloud.google.com/translate/docs/advanced/labels for more
     * information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     * Label keys and values can be no longer than 63 characters (Unicode
     * codepoints), can only contain lowercase letters, numeric characters,
     * underscores and dashes. International characters are allowed. Label values
     * are optional. Label keys must start with a letter.
     * See https://cloud.google.com/translate/docs/advanced/labels for more
     * information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     * Label keys and values can be no longer than 63 characters (Unicode
     * codepoints), can only contain lowercase letters, numeric characters,
     * underscores and dashes. International characters are allowed. Label values
     * are optional. Label keys must start with a letter.
     * See https://cloud.google.com/translate/docs/advanced/labels for more
     * information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata for the request.
     * Label keys and values can be no longer than 63 characters (Unicode
     * codepoints), can only contain lowercase letters, numeric characters,
     * underscores and dashes. International characters are allowed. Label values
     * are optional. Label keys must start with a letter.
     * See https://cloud.google.com/translate/docs/advanced/labels for more
     * information.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3beta1.TranslateDocumentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.translation.v3beta1.TranslateDocumentRequest)
  private static final com.google.cloud.translate.v3beta1.TranslateDocumentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.translate.v3beta1.TranslateDocumentRequest();
  }

  public static com.google.cloud.translate.v3beta1.TranslateDocumentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TranslateDocumentRequest> PARSER =
      new com.google.protobuf.AbstractParser<TranslateDocumentRequest>() {
        @java.lang.Override
        public TranslateDocumentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new TranslateDocumentRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<TranslateDocumentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TranslateDocumentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.translate.v3beta1.TranslateDocumentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
