/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/translate/v3beta1/translation_service.proto

package com.google.cloud.translate.v3beta1;

/**
 *
 *
 * <pre>
 * Stored in the
 * [google.longrunning.Operation.response][google.longrunning.Operation.response]
 * field returned by BatchTranslateDocument if at least one document is
 * translated successfully.
 * </pre>
 *
 * Protobuf type {@code google.cloud.translation.v3beta1.BatchTranslateDocumentResponse}
 */
public final class BatchTranslateDocumentResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.translation.v3beta1.BatchTranslateDocumentResponse)
    BatchTranslateDocumentResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchTranslateDocumentResponse.newBuilder() to construct.
  private BatchTranslateDocumentResponse(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchTranslateDocumentResponse() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchTranslateDocumentResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.translate.v3beta1.TranslationServiceProto
        .internal_static_google_cloud_translation_v3beta1_BatchTranslateDocumentResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.translate.v3beta1.TranslationServiceProto
        .internal_static_google_cloud_translation_v3beta1_BatchTranslateDocumentResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse.class,
            com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse.Builder.class);
  }

  public static final int TOTAL_PAGES_FIELD_NUMBER = 1;
  private long totalPages_;
  /**
   *
   *
   * <pre>
   * Total number of pages to translate in all documents. Documents without
   * clear page definition (such as XLSX) are not counted.
   * </pre>
   *
   * <code>int64 total_pages = 1;</code>
   *
   * @return The totalPages.
   */
  @java.lang.Override
  public long getTotalPages() {
    return totalPages_;
  }

  public static final int TRANSLATED_PAGES_FIELD_NUMBER = 2;
  private long translatedPages_;
  /**
   *
   *
   * <pre>
   * Number of successfully translated pages in all documents. Documents without
   * clear page definition (such as XLSX) are not counted.
   * </pre>
   *
   * <code>int64 translated_pages = 2;</code>
   *
   * @return The translatedPages.
   */
  @java.lang.Override
  public long getTranslatedPages() {
    return translatedPages_;
  }

  public static final int FAILED_PAGES_FIELD_NUMBER = 3;
  private long failedPages_;
  /**
   *
   *
   * <pre>
   * Number of pages that failed to process in all documents. Documents without
   * clear page definition (such as XLSX) are not counted.
   * </pre>
   *
   * <code>int64 failed_pages = 3;</code>
   *
   * @return The failedPages.
   */
  @java.lang.Override
  public long getFailedPages() {
    return failedPages_;
  }

  public static final int TOTAL_BILLABLE_PAGES_FIELD_NUMBER = 4;
  private long totalBillablePages_;
  /**
   *
   *
   * <pre>
   * Number of billable pages in documents with clear page definition (such as
   * PDF, DOCX, PPTX)
   * </pre>
   *
   * <code>int64 total_billable_pages = 4;</code>
   *
   * @return The totalBillablePages.
   */
  @java.lang.Override
  public long getTotalBillablePages() {
    return totalBillablePages_;
  }

  public static final int TOTAL_CHARACTERS_FIELD_NUMBER = 5;
  private long totalCharacters_;
  /**
   *
   *
   * <pre>
   * Total number of characters (Unicode codepoints) in all documents.
   * </pre>
   *
   * <code>int64 total_characters = 5;</code>
   *
   * @return The totalCharacters.
   */
  @java.lang.Override
  public long getTotalCharacters() {
    return totalCharacters_;
  }

  public static final int TRANSLATED_CHARACTERS_FIELD_NUMBER = 6;
  private long translatedCharacters_;
  /**
   *
   *
   * <pre>
   * Number of successfully translated characters (Unicode codepoints) in all
   * documents.
   * </pre>
   *
   * <code>int64 translated_characters = 6;</code>
   *
   * @return The translatedCharacters.
   */
  @java.lang.Override
  public long getTranslatedCharacters() {
    return translatedCharacters_;
  }

  public static final int FAILED_CHARACTERS_FIELD_NUMBER = 7;
  private long failedCharacters_;
  /**
   *
   *
   * <pre>
   * Number of characters that have failed to process (Unicode codepoints) in
   * all documents.
   * </pre>
   *
   * <code>int64 failed_characters = 7;</code>
   *
   * @return The failedCharacters.
   */
  @java.lang.Override
  public long getFailedCharacters() {
    return failedCharacters_;
  }

  public static final int TOTAL_BILLABLE_CHARACTERS_FIELD_NUMBER = 8;
  private long totalBillableCharacters_;
  /**
   *
   *
   * <pre>
   * Number of billable characters (Unicode codepoints) in documents without
   * clear page definition, such as XLSX.
   * </pre>
   *
   * <code>int64 total_billable_characters = 8;</code>
   *
   * @return The totalBillableCharacters.
   */
  @java.lang.Override
  public long getTotalBillableCharacters() {
    return totalBillableCharacters_;
  }

  public static final int SUBMIT_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp submitTime_;
  /**
   *
   *
   * <pre>
   * Time when the operation was submitted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp submit_time = 9;</code>
   *
   * @return Whether the submitTime field is set.
   */
  @java.lang.Override
  public boolean hasSubmitTime() {
    return submitTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time when the operation was submitted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp submit_time = 9;</code>
   *
   * @return The submitTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getSubmitTime() {
    return submitTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : submitTime_;
  }
  /**
   *
   *
   * <pre>
   * Time when the operation was submitted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp submit_time = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getSubmitTimeOrBuilder() {
    return getSubmitTime();
  }

  public static final int END_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * The time when the operation is finished and
   * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
   * set to true.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 10;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time when the operation is finished and
   * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
   * set to true.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 10;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the operation is finished and
   * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
   * set to true.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return getEndTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (totalPages_ != 0L) {
      output.writeInt64(1, totalPages_);
    }
    if (translatedPages_ != 0L) {
      output.writeInt64(2, translatedPages_);
    }
    if (failedPages_ != 0L) {
      output.writeInt64(3, failedPages_);
    }
    if (totalBillablePages_ != 0L) {
      output.writeInt64(4, totalBillablePages_);
    }
    if (totalCharacters_ != 0L) {
      output.writeInt64(5, totalCharacters_);
    }
    if (translatedCharacters_ != 0L) {
      output.writeInt64(6, translatedCharacters_);
    }
    if (failedCharacters_ != 0L) {
      output.writeInt64(7, failedCharacters_);
    }
    if (totalBillableCharacters_ != 0L) {
      output.writeInt64(8, totalBillableCharacters_);
    }
    if (submitTime_ != null) {
      output.writeMessage(9, getSubmitTime());
    }
    if (endTime_ != null) {
      output.writeMessage(10, getEndTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (totalPages_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, totalPages_);
    }
    if (translatedPages_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, translatedPages_);
    }
    if (failedPages_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, failedPages_);
    }
    if (totalBillablePages_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, totalBillablePages_);
    }
    if (totalCharacters_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, totalCharacters_);
    }
    if (translatedCharacters_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, translatedCharacters_);
    }
    if (failedCharacters_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, failedCharacters_);
    }
    if (totalBillableCharacters_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(8, totalBillableCharacters_);
    }
    if (submitTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getSubmitTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getEndTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse other =
        (com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse) obj;

    if (getTotalPages() != other.getTotalPages()) return false;
    if (getTranslatedPages() != other.getTranslatedPages()) return false;
    if (getFailedPages() != other.getFailedPages()) return false;
    if (getTotalBillablePages() != other.getTotalBillablePages()) return false;
    if (getTotalCharacters() != other.getTotalCharacters()) return false;
    if (getTranslatedCharacters() != other.getTranslatedCharacters()) return false;
    if (getFailedCharacters() != other.getFailedCharacters()) return false;
    if (getTotalBillableCharacters() != other.getTotalBillableCharacters()) return false;
    if (hasSubmitTime() != other.hasSubmitTime()) return false;
    if (hasSubmitTime()) {
      if (!getSubmitTime().equals(other.getSubmitTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TOTAL_PAGES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalPages());
    hash = (37 * hash) + TRANSLATED_PAGES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTranslatedPages());
    hash = (37 * hash) + FAILED_PAGES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getFailedPages());
    hash = (37 * hash) + TOTAL_BILLABLE_PAGES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalBillablePages());
    hash = (37 * hash) + TOTAL_CHARACTERS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalCharacters());
    hash = (37 * hash) + TRANSLATED_CHARACTERS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTranslatedCharacters());
    hash = (37 * hash) + FAILED_CHARACTERS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getFailedCharacters());
    hash = (37 * hash) + TOTAL_BILLABLE_CHARACTERS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalBillableCharacters());
    if (hasSubmitTime()) {
      hash = (37 * hash) + SUBMIT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getSubmitTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Stored in the
   * [google.longrunning.Operation.response][google.longrunning.Operation.response]
   * field returned by BatchTranslateDocument if at least one document is
   * translated successfully.
   * </pre>
   *
   * Protobuf type {@code google.cloud.translation.v3beta1.BatchTranslateDocumentResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3beta1.BatchTranslateDocumentResponse)
      com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_BatchTranslateDocumentResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_BatchTranslateDocumentResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse.class,
              com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse.Builder.class);
    }

    // Construct using
    // com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      totalPages_ = 0L;

      translatedPages_ = 0L;

      failedPages_ = 0L;

      totalBillablePages_ = 0L;

      totalCharacters_ = 0L;

      translatedCharacters_ = 0L;

      failedCharacters_ = 0L;

      totalBillableCharacters_ = 0L;

      if (submitTimeBuilder_ == null) {
        submitTime_ = null;
      } else {
        submitTime_ = null;
        submitTimeBuilder_ = null;
      }
      if (endTimeBuilder_ == null) {
        endTime_ = null;
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.translate.v3beta1.TranslationServiceProto
          .internal_static_google_cloud_translation_v3beta1_BatchTranslateDocumentResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse
        getDefaultInstanceForType() {
      return com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse build() {
      com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse buildPartial() {
      com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse result =
          new com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse(this);
      result.totalPages_ = totalPages_;
      result.translatedPages_ = translatedPages_;
      result.failedPages_ = failedPages_;
      result.totalBillablePages_ = totalBillablePages_;
      result.totalCharacters_ = totalCharacters_;
      result.translatedCharacters_ = translatedCharacters_;
      result.failedCharacters_ = failedCharacters_;
      result.totalBillableCharacters_ = totalBillableCharacters_;
      if (submitTimeBuilder_ == null) {
        result.submitTime_ = submitTime_;
      } else {
        result.submitTime_ = submitTimeBuilder_.build();
      }
      if (endTimeBuilder_ == null) {
        result.endTime_ = endTime_;
      } else {
        result.endTime_ = endTimeBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse) {
        return mergeFrom((com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse other) {
      if (other
          == com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse.getDefaultInstance())
        return this;
      if (other.getTotalPages() != 0L) {
        setTotalPages(other.getTotalPages());
      }
      if (other.getTranslatedPages() != 0L) {
        setTranslatedPages(other.getTranslatedPages());
      }
      if (other.getFailedPages() != 0L) {
        setFailedPages(other.getFailedPages());
      }
      if (other.getTotalBillablePages() != 0L) {
        setTotalBillablePages(other.getTotalBillablePages());
      }
      if (other.getTotalCharacters() != 0L) {
        setTotalCharacters(other.getTotalCharacters());
      }
      if (other.getTranslatedCharacters() != 0L) {
        setTranslatedCharacters(other.getTranslatedCharacters());
      }
      if (other.getFailedCharacters() != 0L) {
        setFailedCharacters(other.getFailedCharacters());
      }
      if (other.getTotalBillableCharacters() != 0L) {
        setTotalBillableCharacters(other.getTotalBillableCharacters());
      }
      if (other.hasSubmitTime()) {
        mergeSubmitTime(other.getSubmitTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                totalPages_ = input.readInt64();

                break;
              } // case 8
            case 16:
              {
                translatedPages_ = input.readInt64();

                break;
              } // case 16
            case 24:
              {
                failedPages_ = input.readInt64();

                break;
              } // case 24
            case 32:
              {
                totalBillablePages_ = input.readInt64();

                break;
              } // case 32
            case 40:
              {
                totalCharacters_ = input.readInt64();

                break;
              } // case 40
            case 48:
              {
                translatedCharacters_ = input.readInt64();

                break;
              } // case 48
            case 56:
              {
                failedCharacters_ = input.readInt64();

                break;
              } // case 56
            case 64:
              {
                totalBillableCharacters_ = input.readInt64();

                break;
              } // case 64
            case 74:
              {
                input.readMessage(getSubmitTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 74
            case 82:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private long totalPages_;
    /**
     *
     *
     * <pre>
     * Total number of pages to translate in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 total_pages = 1;</code>
     *
     * @return The totalPages.
     */
    @java.lang.Override
    public long getTotalPages() {
      return totalPages_;
    }
    /**
     *
     *
     * <pre>
     * Total number of pages to translate in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 total_pages = 1;</code>
     *
     * @param value The totalPages to set.
     * @return This builder for chaining.
     */
    public Builder setTotalPages(long value) {

      totalPages_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total number of pages to translate in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 total_pages = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalPages() {

      totalPages_ = 0L;
      onChanged();
      return this;
    }

    private long translatedPages_;
    /**
     *
     *
     * <pre>
     * Number of successfully translated pages in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 translated_pages = 2;</code>
     *
     * @return The translatedPages.
     */
    @java.lang.Override
    public long getTranslatedPages() {
      return translatedPages_;
    }
    /**
     *
     *
     * <pre>
     * Number of successfully translated pages in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 translated_pages = 2;</code>
     *
     * @param value The translatedPages to set.
     * @return This builder for chaining.
     */
    public Builder setTranslatedPages(long value) {

      translatedPages_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of successfully translated pages in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 translated_pages = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTranslatedPages() {

      translatedPages_ = 0L;
      onChanged();
      return this;
    }

    private long failedPages_;
    /**
     *
     *
     * <pre>
     * Number of pages that failed to process in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 failed_pages = 3;</code>
     *
     * @return The failedPages.
     */
    @java.lang.Override
    public long getFailedPages() {
      return failedPages_;
    }
    /**
     *
     *
     * <pre>
     * Number of pages that failed to process in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 failed_pages = 3;</code>
     *
     * @param value The failedPages to set.
     * @return This builder for chaining.
     */
    public Builder setFailedPages(long value) {

      failedPages_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of pages that failed to process in all documents. Documents without
     * clear page definition (such as XLSX) are not counted.
     * </pre>
     *
     * <code>int64 failed_pages = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailedPages() {

      failedPages_ = 0L;
      onChanged();
      return this;
    }

    private long totalBillablePages_;
    /**
     *
     *
     * <pre>
     * Number of billable pages in documents with clear page definition (such as
     * PDF, DOCX, PPTX)
     * </pre>
     *
     * <code>int64 total_billable_pages = 4;</code>
     *
     * @return The totalBillablePages.
     */
    @java.lang.Override
    public long getTotalBillablePages() {
      return totalBillablePages_;
    }
    /**
     *
     *
     * <pre>
     * Number of billable pages in documents with clear page definition (such as
     * PDF, DOCX, PPTX)
     * </pre>
     *
     * <code>int64 total_billable_pages = 4;</code>
     *
     * @param value The totalBillablePages to set.
     * @return This builder for chaining.
     */
    public Builder setTotalBillablePages(long value) {

      totalBillablePages_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of billable pages in documents with clear page definition (such as
     * PDF, DOCX, PPTX)
     * </pre>
     *
     * <code>int64 total_billable_pages = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalBillablePages() {

      totalBillablePages_ = 0L;
      onChanged();
      return this;
    }

    private long totalCharacters_;
    /**
     *
     *
     * <pre>
     * Total number of characters (Unicode codepoints) in all documents.
     * </pre>
     *
     * <code>int64 total_characters = 5;</code>
     *
     * @return The totalCharacters.
     */
    @java.lang.Override
    public long getTotalCharacters() {
      return totalCharacters_;
    }
    /**
     *
     *
     * <pre>
     * Total number of characters (Unicode codepoints) in all documents.
     * </pre>
     *
     * <code>int64 total_characters = 5;</code>
     *
     * @param value The totalCharacters to set.
     * @return This builder for chaining.
     */
    public Builder setTotalCharacters(long value) {

      totalCharacters_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total number of characters (Unicode codepoints) in all documents.
     * </pre>
     *
     * <code>int64 total_characters = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalCharacters() {

      totalCharacters_ = 0L;
      onChanged();
      return this;
    }

    private long translatedCharacters_;
    /**
     *
     *
     * <pre>
     * Number of successfully translated characters (Unicode codepoints) in all
     * documents.
     * </pre>
     *
     * <code>int64 translated_characters = 6;</code>
     *
     * @return The translatedCharacters.
     */
    @java.lang.Override
    public long getTranslatedCharacters() {
      return translatedCharacters_;
    }
    /**
     *
     *
     * <pre>
     * Number of successfully translated characters (Unicode codepoints) in all
     * documents.
     * </pre>
     *
     * <code>int64 translated_characters = 6;</code>
     *
     * @param value The translatedCharacters to set.
     * @return This builder for chaining.
     */
    public Builder setTranslatedCharacters(long value) {

      translatedCharacters_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of successfully translated characters (Unicode codepoints) in all
     * documents.
     * </pre>
     *
     * <code>int64 translated_characters = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTranslatedCharacters() {

      translatedCharacters_ = 0L;
      onChanged();
      return this;
    }

    private long failedCharacters_;
    /**
     *
     *
     * <pre>
     * Number of characters that have failed to process (Unicode codepoints) in
     * all documents.
     * </pre>
     *
     * <code>int64 failed_characters = 7;</code>
     *
     * @return The failedCharacters.
     */
    @java.lang.Override
    public long getFailedCharacters() {
      return failedCharacters_;
    }
    /**
     *
     *
     * <pre>
     * Number of characters that have failed to process (Unicode codepoints) in
     * all documents.
     * </pre>
     *
     * <code>int64 failed_characters = 7;</code>
     *
     * @param value The failedCharacters to set.
     * @return This builder for chaining.
     */
    public Builder setFailedCharacters(long value) {

      failedCharacters_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of characters that have failed to process (Unicode codepoints) in
     * all documents.
     * </pre>
     *
     * <code>int64 failed_characters = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailedCharacters() {

      failedCharacters_ = 0L;
      onChanged();
      return this;
    }

    private long totalBillableCharacters_;
    /**
     *
     *
     * <pre>
     * Number of billable characters (Unicode codepoints) in documents without
     * clear page definition, such as XLSX.
     * </pre>
     *
     * <code>int64 total_billable_characters = 8;</code>
     *
     * @return The totalBillableCharacters.
     */
    @java.lang.Override
    public long getTotalBillableCharacters() {
      return totalBillableCharacters_;
    }
    /**
     *
     *
     * <pre>
     * Number of billable characters (Unicode codepoints) in documents without
     * clear page definition, such as XLSX.
     * </pre>
     *
     * <code>int64 total_billable_characters = 8;</code>
     *
     * @param value The totalBillableCharacters to set.
     * @return This builder for chaining.
     */
    public Builder setTotalBillableCharacters(long value) {

      totalBillableCharacters_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of billable characters (Unicode codepoints) in documents without
     * clear page definition, such as XLSX.
     * </pre>
     *
     * <code>int64 total_billable_characters = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalBillableCharacters() {

      totalBillableCharacters_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp submitTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        submitTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 9;</code>
     *
     * @return Whether the submitTime field is set.
     */
    public boolean hasSubmitTime() {
      return submitTimeBuilder_ != null || submitTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 9;</code>
     *
     * @return The submitTime.
     */
    public com.google.protobuf.Timestamp getSubmitTime() {
      if (submitTimeBuilder_ == null) {
        return submitTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : submitTime_;
      } else {
        return submitTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 9;</code>
     */
    public Builder setSubmitTime(com.google.protobuf.Timestamp value) {
      if (submitTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        submitTime_ = value;
        onChanged();
      } else {
        submitTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 9;</code>
     */
    public Builder setSubmitTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (submitTimeBuilder_ == null) {
        submitTime_ = builderForValue.build();
        onChanged();
      } else {
        submitTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 9;</code>
     */
    public Builder mergeSubmitTime(com.google.protobuf.Timestamp value) {
      if (submitTimeBuilder_ == null) {
        if (submitTime_ != null) {
          submitTime_ =
              com.google.protobuf.Timestamp.newBuilder(submitTime_).mergeFrom(value).buildPartial();
        } else {
          submitTime_ = value;
        }
        onChanged();
      } else {
        submitTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 9;</code>
     */
    public Builder clearSubmitTime() {
      if (submitTimeBuilder_ == null) {
        submitTime_ = null;
        onChanged();
      } else {
        submitTime_ = null;
        submitTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 9;</code>
     */
    public com.google.protobuf.Timestamp.Builder getSubmitTimeBuilder() {

      onChanged();
      return getSubmitTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 9;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getSubmitTimeOrBuilder() {
      if (submitTimeBuilder_ != null) {
        return submitTimeBuilder_.getMessageOrBuilder();
      } else {
        return submitTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : submitTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the operation was submitted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp submit_time = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getSubmitTimeFieldBuilder() {
      if (submitTimeBuilder_ == null) {
        submitTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getSubmitTime(), getParentForChildren(), isClean());
        submitTime_ = null;
      }
      return submitTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to true.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return endTimeBuilder_ != null || endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to true.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to true.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
        onChanged();
      } else {
        endTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to true.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
        onChanged();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to true.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (endTime_ != null) {
          endTime_ =
              com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
        } else {
          endTime_ = value;
        }
        onChanged();
      } else {
        endTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to true.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10;</code>
     */
    public Builder clearEndTime() {
      if (endTimeBuilder_ == null) {
        endTime_ = null;
        onChanged();
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to true.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to true.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to true.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3beta1.BatchTranslateDocumentResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.translation.v3beta1.BatchTranslateDocumentResponse)
  private static final com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse();
  }

  public static com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchTranslateDocumentResponse> PARSER =
      new com.google.protobuf.AbstractParser<BatchTranslateDocumentResponse>() {
        @java.lang.Override
        public BatchTranslateDocumentResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchTranslateDocumentResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchTranslateDocumentResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
