/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vertexai/v1/prediction_service.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.vertexai.api;

/**
 *
 *
 * <pre>
 * Request message for [PredictionService.GenerateContent].
 * </pre>
 *
 * Protobuf type {@code google.cloud.vertexai.v1.GenerateContentRequest}
 */
public final class GenerateContentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.GenerateContentRequest)
    GenerateContentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GenerateContentRequest.newBuilder() to construct.
  private GenerateContentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateContentRequest() {
    model_ = "";
    contents_ = java.util.Collections.emptyList();
    tools_ = java.util.Collections.emptyList();
    safetySettings_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateContentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vertexai.api.PredictionServiceProto
        .internal_static_google_cloud_vertexai_v1_GenerateContentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vertexai.api.PredictionServiceProto
        .internal_static_google_cloud_vertexai_v1_GenerateContentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vertexai.api.GenerateContentRequest.class,
            com.google.cloud.vertexai.api.GenerateContentRequest.Builder.class);
  }

  private int bitField0_;
  public static final int MODEL_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object model_ = "";
  /**
   *
   *
   * <pre>
   * Required. The fully qualified name of the publisher model or tuned model
   * endpoint to use.
   *
   * Publisher model format:
   * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
   *
   * Tuned model endpoint format:
   * `projects/{project}/locations/{location}/endpoints/{endpoint}`
   * </pre>
   *
   * <code>string model = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The model.
   */
  @java.lang.Override
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The fully qualified name of the publisher model or tuned model
   * endpoint to use.
   *
   * Publisher model format:
   * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
   *
   * Tuned model endpoint format:
   * `projects/{project}/locations/{location}/endpoints/{endpoint}`
   * </pre>
   *
   * <code>string model = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for model.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTENTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vertexai.api.Content> contents_;
  /**
   *
   *
   * <pre>
   * Required. The content of the current conversation with the model.
   *
   * For single-turn queries, this is a single instance. For multi-turn queries,
   * this is a repeated field that contains conversation history + latest
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vertexai.api.Content> getContentsList() {
    return contents_;
  }
  /**
   *
   *
   * <pre>
   * Required. The content of the current conversation with the model.
   *
   * For single-turn queries, this is a single instance. For multi-turn queries,
   * this is a repeated field that contains conversation history + latest
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vertexai.api.ContentOrBuilder>
      getContentsOrBuilderList() {
    return contents_;
  }
  /**
   *
   *
   * <pre>
   * Required. The content of the current conversation with the model.
   *
   * For single-turn queries, this is a single instance. For multi-turn queries,
   * this is a repeated field that contains conversation history + latest
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getContentsCount() {
    return contents_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The content of the current conversation with the model.
   *
   * For single-turn queries, this is a single instance. For multi-turn queries,
   * this is a repeated field that contains conversation history + latest
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.Content getContents(int index) {
    return contents_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The content of the current conversation with the model.
   *
   * For single-turn queries, this is a single instance. For multi-turn queries,
   * this is a repeated field that contains conversation history + latest
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.ContentOrBuilder getContentsOrBuilder(int index) {
    return contents_.get(index);
  }

  public static final int SYSTEM_INSTRUCTION_FIELD_NUMBER = 8;
  private com.google.cloud.vertexai.api.Content systemInstruction_;
  /**
   *
   *
   * <pre>
   * Optional. The user provided system instructions for the model.
   * Note: only text should be used in parts and content in each part will be in
   * a separate paragraph.
   * </pre>
   *
   * <code>
   * optional .google.cloud.vertexai.v1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the systemInstruction field is set.
   */
  @java.lang.Override
  public boolean hasSystemInstruction() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The user provided system instructions for the model.
   * Note: only text should be used in parts and content in each part will be in
   * a separate paragraph.
   * </pre>
   *
   * <code>
   * optional .google.cloud.vertexai.v1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The systemInstruction.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.Content getSystemInstruction() {
    return systemInstruction_ == null
        ? com.google.cloud.vertexai.api.Content.getDefaultInstance()
        : systemInstruction_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The user provided system instructions for the model.
   * Note: only text should be used in parts and content in each part will be in
   * a separate paragraph.
   * </pre>
   *
   * <code>
   * optional .google.cloud.vertexai.v1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.ContentOrBuilder getSystemInstructionOrBuilder() {
    return systemInstruction_ == null
        ? com.google.cloud.vertexai.api.Content.getDefaultInstance()
        : systemInstruction_;
  }

  public static final int TOOLS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vertexai.api.Tool> tools_;
  /**
   *
   *
   * <pre>
   * Optional. A list of `Tools` the model may use to generate the next
   * response.
   *
   * A `Tool` is a piece of code that enables the system to interact with
   * external systems to perform an action, or set of actions, outside of
   * knowledge and scope of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vertexai.api.Tool> getToolsList() {
    return tools_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of `Tools` the model may use to generate the next
   * response.
   *
   * A `Tool` is a piece of code that enables the system to interact with
   * external systems to perform an action, or set of actions, outside of
   * knowledge and scope of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vertexai.api.ToolOrBuilder>
      getToolsOrBuilderList() {
    return tools_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of `Tools` the model may use to generate the next
   * response.
   *
   * A `Tool` is a piece of code that enables the system to interact with
   * external systems to perform an action, or set of actions, outside of
   * knowledge and scope of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getToolsCount() {
    return tools_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of `Tools` the model may use to generate the next
   * response.
   *
   * A `Tool` is a piece of code that enables the system to interact with
   * external systems to perform an action, or set of actions, outside of
   * knowledge and scope of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.Tool getTools(int index) {
    return tools_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of `Tools` the model may use to generate the next
   * response.
   *
   * A `Tool` is a piece of code that enables the system to interact with
   * external systems to perform an action, or set of actions, outside of
   * knowledge and scope of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.ToolOrBuilder getToolsOrBuilder(int index) {
    return tools_.get(index);
  }

  public static final int TOOL_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.vertexai.api.ToolConfig toolConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Tool config. This config is shared for all tools provided in the
   * request.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the toolConfig field is set.
   */
  @java.lang.Override
  public boolean hasToolConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Tool config. This config is shared for all tools provided in the
   * request.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The toolConfig.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.ToolConfig getToolConfig() {
    return toolConfig_ == null
        ? com.google.cloud.vertexai.api.ToolConfig.getDefaultInstance()
        : toolConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Tool config. This config is shared for all tools provided in the
   * request.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.ToolConfigOrBuilder getToolConfigOrBuilder() {
    return toolConfig_ == null
        ? com.google.cloud.vertexai.api.ToolConfig.getDefaultInstance()
        : toolConfig_;
  }

  public static final int SAFETY_SETTINGS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vertexai.api.SafetySetting> safetySettings_;
  /**
   *
   *
   * <pre>
   * Optional. Per request settings for blocking unsafe content.
   * Enforced on GenerateContentResponse.candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vertexai.api.SafetySetting> getSafetySettingsList() {
    return safetySettings_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Per request settings for blocking unsafe content.
   * Enforced on GenerateContentResponse.candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vertexai.api.SafetySettingOrBuilder>
      getSafetySettingsOrBuilderList() {
    return safetySettings_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Per request settings for blocking unsafe content.
   * Enforced on GenerateContentResponse.candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getSafetySettingsCount() {
    return safetySettings_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Per request settings for blocking unsafe content.
   * Enforced on GenerateContentResponse.candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.SafetySetting getSafetySettings(int index) {
    return safetySettings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Per request settings for blocking unsafe content.
   * Enforced on GenerateContentResponse.candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.SafetySettingOrBuilder getSafetySettingsOrBuilder(
      int index) {
    return safetySettings_.get(index);
  }

  public static final int GENERATION_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.vertexai.api.GenerationConfig generationConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Generation config.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the generationConfig field is set.
   */
  @java.lang.Override
  public boolean hasGenerationConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Generation config.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The generationConfig.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.GenerationConfig getGenerationConfig() {
    return generationConfig_ == null
        ? com.google.cloud.vertexai.api.GenerationConfig.getDefaultInstance()
        : generationConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Generation config.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.GenerationConfigOrBuilder getGenerationConfigOrBuilder() {
    return generationConfig_ == null
        ? com.google.cloud.vertexai.api.GenerationConfig.getDefaultInstance()
        : generationConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < contents_.size(); i++) {
      output.writeMessage(2, contents_.get(i));
    }
    for (int i = 0; i < safetySettings_.size(); i++) {
      output.writeMessage(3, safetySettings_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getGenerationConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, model_);
    }
    for (int i = 0; i < tools_.size(); i++) {
      output.writeMessage(6, tools_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getToolConfig());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(8, getSystemInstruction());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < contents_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, contents_.get(i));
    }
    for (int i = 0; i < safetySettings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, safetySettings_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getGenerationConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, model_);
    }
    for (int i = 0; i < tools_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, tools_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getToolConfig());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSystemInstruction());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vertexai.api.GenerateContentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.vertexai.api.GenerateContentRequest other =
        (com.google.cloud.vertexai.api.GenerateContentRequest) obj;

    if (!getModel().equals(other.getModel())) return false;
    if (!getContentsList().equals(other.getContentsList())) return false;
    if (hasSystemInstruction() != other.hasSystemInstruction()) return false;
    if (hasSystemInstruction()) {
      if (!getSystemInstruction().equals(other.getSystemInstruction())) return false;
    }
    if (!getToolsList().equals(other.getToolsList())) return false;
    if (hasToolConfig() != other.hasToolConfig()) return false;
    if (hasToolConfig()) {
      if (!getToolConfig().equals(other.getToolConfig())) return false;
    }
    if (!getSafetySettingsList().equals(other.getSafetySettingsList())) return false;
    if (hasGenerationConfig() != other.hasGenerationConfig()) return false;
    if (hasGenerationConfig()) {
      if (!getGenerationConfig().equals(other.getGenerationConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    if (getContentsCount() > 0) {
      hash = (37 * hash) + CONTENTS_FIELD_NUMBER;
      hash = (53 * hash) + getContentsList().hashCode();
    }
    if (hasSystemInstruction()) {
      hash = (37 * hash) + SYSTEM_INSTRUCTION_FIELD_NUMBER;
      hash = (53 * hash) + getSystemInstruction().hashCode();
    }
    if (getToolsCount() > 0) {
      hash = (37 * hash) + TOOLS_FIELD_NUMBER;
      hash = (53 * hash) + getToolsList().hashCode();
    }
    if (hasToolConfig()) {
      hash = (37 * hash) + TOOL_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getToolConfig().hashCode();
    }
    if (getSafetySettingsCount() > 0) {
      hash = (37 * hash) + SAFETY_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getSafetySettingsList().hashCode();
    }
    if (hasGenerationConfig()) {
      hash = (37 * hash) + GENERATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getGenerationConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vertexai.api.GenerateContentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.GenerateContentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.GenerateContentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.GenerateContentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.GenerateContentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.GenerateContentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.GenerateContentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.GenerateContentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.GenerateContentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.GenerateContentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.GenerateContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.GenerateContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vertexai.api.GenerateContentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for [PredictionService.GenerateContent].
   * </pre>
   *
   * Protobuf type {@code google.cloud.vertexai.v1.GenerateContentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.GenerateContentRequest)
      com.google.cloud.vertexai.api.GenerateContentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vertexai.api.PredictionServiceProto
          .internal_static_google_cloud_vertexai_v1_GenerateContentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vertexai.api.PredictionServiceProto
          .internal_static_google_cloud_vertexai_v1_GenerateContentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vertexai.api.GenerateContentRequest.class,
              com.google.cloud.vertexai.api.GenerateContentRequest.Builder.class);
    }

    // Construct using com.google.cloud.vertexai.api.GenerateContentRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getContentsFieldBuilder();
        getSystemInstructionFieldBuilder();
        getToolsFieldBuilder();
        getToolConfigFieldBuilder();
        getSafetySettingsFieldBuilder();
        getGenerationConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      model_ = "";
      if (contentsBuilder_ == null) {
        contents_ = java.util.Collections.emptyList();
      } else {
        contents_ = null;
        contentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      systemInstruction_ = null;
      if (systemInstructionBuilder_ != null) {
        systemInstructionBuilder_.dispose();
        systemInstructionBuilder_ = null;
      }
      if (toolsBuilder_ == null) {
        tools_ = java.util.Collections.emptyList();
      } else {
        tools_ = null;
        toolsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      toolConfig_ = null;
      if (toolConfigBuilder_ != null) {
        toolConfigBuilder_.dispose();
        toolConfigBuilder_ = null;
      }
      if (safetySettingsBuilder_ == null) {
        safetySettings_ = java.util.Collections.emptyList();
      } else {
        safetySettings_ = null;
        safetySettingsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      generationConfig_ = null;
      if (generationConfigBuilder_ != null) {
        generationConfigBuilder_.dispose();
        generationConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vertexai.api.PredictionServiceProto
          .internal_static_google_cloud_vertexai_v1_GenerateContentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.GenerateContentRequest getDefaultInstanceForType() {
      return com.google.cloud.vertexai.api.GenerateContentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.GenerateContentRequest build() {
      com.google.cloud.vertexai.api.GenerateContentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.GenerateContentRequest buildPartial() {
      com.google.cloud.vertexai.api.GenerateContentRequest result =
          new com.google.cloud.vertexai.api.GenerateContentRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.vertexai.api.GenerateContentRequest result) {
      if (contentsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          contents_ = java.util.Collections.unmodifiableList(contents_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.contents_ = contents_;
      } else {
        result.contents_ = contentsBuilder_.build();
      }
      if (toolsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          tools_ = java.util.Collections.unmodifiableList(tools_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.tools_ = tools_;
      } else {
        result.tools_ = toolsBuilder_.build();
      }
      if (safetySettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          safetySettings_ = java.util.Collections.unmodifiableList(safetySettings_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.safetySettings_ = safetySettings_;
      } else {
        result.safetySettings_ = safetySettingsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.vertexai.api.GenerateContentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.model_ = model_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.systemInstruction_ =
            systemInstructionBuilder_ == null
                ? systemInstruction_
                : systemInstructionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.toolConfig_ = toolConfigBuilder_ == null ? toolConfig_ : toolConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.generationConfig_ =
            generationConfigBuilder_ == null ? generationConfig_ : generationConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vertexai.api.GenerateContentRequest) {
        return mergeFrom((com.google.cloud.vertexai.api.GenerateContentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vertexai.api.GenerateContentRequest other) {
      if (other == com.google.cloud.vertexai.api.GenerateContentRequest.getDefaultInstance())
        return this;
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (contentsBuilder_ == null) {
        if (!other.contents_.isEmpty()) {
          if (contents_.isEmpty()) {
            contents_ = other.contents_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureContentsIsMutable();
            contents_.addAll(other.contents_);
          }
          onChanged();
        }
      } else {
        if (!other.contents_.isEmpty()) {
          if (contentsBuilder_.isEmpty()) {
            contentsBuilder_.dispose();
            contentsBuilder_ = null;
            contents_ = other.contents_;
            bitField0_ = (bitField0_ & ~0x00000002);
            contentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getContentsFieldBuilder()
                    : null;
          } else {
            contentsBuilder_.addAllMessages(other.contents_);
          }
        }
      }
      if (other.hasSystemInstruction()) {
        mergeSystemInstruction(other.getSystemInstruction());
      }
      if (toolsBuilder_ == null) {
        if (!other.tools_.isEmpty()) {
          if (tools_.isEmpty()) {
            tools_ = other.tools_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureToolsIsMutable();
            tools_.addAll(other.tools_);
          }
          onChanged();
        }
      } else {
        if (!other.tools_.isEmpty()) {
          if (toolsBuilder_.isEmpty()) {
            toolsBuilder_.dispose();
            toolsBuilder_ = null;
            tools_ = other.tools_;
            bitField0_ = (bitField0_ & ~0x00000008);
            toolsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getToolsFieldBuilder()
                    : null;
          } else {
            toolsBuilder_.addAllMessages(other.tools_);
          }
        }
      }
      if (other.hasToolConfig()) {
        mergeToolConfig(other.getToolConfig());
      }
      if (safetySettingsBuilder_ == null) {
        if (!other.safetySettings_.isEmpty()) {
          if (safetySettings_.isEmpty()) {
            safetySettings_ = other.safetySettings_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureSafetySettingsIsMutable();
            safetySettings_.addAll(other.safetySettings_);
          }
          onChanged();
        }
      } else {
        if (!other.safetySettings_.isEmpty()) {
          if (safetySettingsBuilder_.isEmpty()) {
            safetySettingsBuilder_.dispose();
            safetySettingsBuilder_ = null;
            safetySettings_ = other.safetySettings_;
            bitField0_ = (bitField0_ & ~0x00000020);
            safetySettingsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSafetySettingsFieldBuilder()
                    : null;
          } else {
            safetySettingsBuilder_.addAllMessages(other.safetySettings_);
          }
        }
      }
      if (other.hasGenerationConfig()) {
        mergeGenerationConfig(other.getGenerationConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                com.google.cloud.vertexai.api.Content m =
                    input.readMessage(
                        com.google.cloud.vertexai.api.Content.parser(), extensionRegistry);
                if (contentsBuilder_ == null) {
                  ensureContentsIsMutable();
                  contents_.add(m);
                } else {
                  contentsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.vertexai.api.SafetySetting m =
                    input.readMessage(
                        com.google.cloud.vertexai.api.SafetySetting.parser(), extensionRegistry);
                if (safetySettingsBuilder_ == null) {
                  ensureSafetySettingsIsMutable();
                  safetySettings_.add(m);
                } else {
                  safetySettingsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getGenerationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 34
            case 42:
              {
                model_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.vertexai.api.Tool m =
                    input.readMessage(
                        com.google.cloud.vertexai.api.Tool.parser(), extensionRegistry);
                if (toolsBuilder_ == null) {
                  ensureToolsIsMutable();
                  tools_.add(m);
                } else {
                  toolsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getToolConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getSystemInstructionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * Required. The fully qualified name of the publisher model or tuned model
     * endpoint to use.
     *
     * Publisher model format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     *
     * Tuned model endpoint format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>string model = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified name of the publisher model or tuned model
     * endpoint to use.
     *
     * Publisher model format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     *
     * Tuned model endpoint format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>string model = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified name of the publisher model or tuned model
     * endpoint to use.
     *
     * Publisher model format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     *
     * Tuned model endpoint format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>string model = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      model_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified name of the publisher model or tuned model
     * endpoint to use.
     *
     * Publisher model format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     *
     * Tuned model endpoint format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>string model = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {
      model_ = getDefaultInstance().getModel();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified name of the publisher model or tuned model
     * endpoint to use.
     *
     * Publisher model format:
     * `projects/{project}/locations/{location}/publishers/&#42;&#47;models/&#42;`
     *
     * Tuned model endpoint format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>string model = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      model_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.vertexai.api.Content> contents_ =
        java.util.Collections.emptyList();

    private void ensureContentsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        contents_ = new java.util.ArrayList<com.google.cloud.vertexai.api.Content>(contents_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.Content,
            com.google.cloud.vertexai.api.Content.Builder,
            com.google.cloud.vertexai.api.ContentOrBuilder>
        contentsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.Content> getContentsList() {
      if (contentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(contents_);
      } else {
        return contentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getContentsCount() {
      if (contentsBuilder_ == null) {
        return contents_.size();
      } else {
        return contentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.vertexai.api.Content getContents(int index) {
      if (contentsBuilder_ == null) {
        return contents_.get(index);
      } else {
        return contentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setContents(int index, com.google.cloud.vertexai.api.Content value) {
      if (contentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentsIsMutable();
        contents_.set(index, value);
        onChanged();
      } else {
        contentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setContents(
        int index, com.google.cloud.vertexai.api.Content.Builder builderForValue) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.set(index, builderForValue.build());
        onChanged();
      } else {
        contentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addContents(com.google.cloud.vertexai.api.Content value) {
      if (contentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentsIsMutable();
        contents_.add(value);
        onChanged();
      } else {
        contentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addContents(int index, com.google.cloud.vertexai.api.Content value) {
      if (contentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentsIsMutable();
        contents_.add(index, value);
        onChanged();
      } else {
        contentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addContents(com.google.cloud.vertexai.api.Content.Builder builderForValue) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.add(builderForValue.build());
        onChanged();
      } else {
        contentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addContents(
        int index, com.google.cloud.vertexai.api.Content.Builder builderForValue) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.add(index, builderForValue.build());
        onChanged();
      } else {
        contentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllContents(
        java.lang.Iterable<? extends com.google.cloud.vertexai.api.Content> values) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, contents_);
        onChanged();
      } else {
        contentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearContents() {
      if (contentsBuilder_ == null) {
        contents_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        contentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeContents(int index) {
      if (contentsBuilder_ == null) {
        ensureContentsIsMutable();
        contents_.remove(index);
        onChanged();
      } else {
        contentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.vertexai.api.Content.Builder getContentsBuilder(int index) {
      return getContentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.vertexai.api.ContentOrBuilder getContentsOrBuilder(int index) {
      if (contentsBuilder_ == null) {
        return contents_.get(index);
      } else {
        return contentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.vertexai.api.ContentOrBuilder>
        getContentsOrBuilderList() {
      if (contentsBuilder_ != null) {
        return contentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(contents_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.vertexai.api.Content.Builder addContentsBuilder() {
      return getContentsFieldBuilder()
          .addBuilder(com.google.cloud.vertexai.api.Content.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.vertexai.api.Content.Builder addContentsBuilder(int index) {
      return getContentsFieldBuilder()
          .addBuilder(index, com.google.cloud.vertexai.api.Content.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the current conversation with the model.
     *
     * For single-turn queries, this is a single instance. For multi-turn queries,
     * this is a repeated field that contains conversation history + latest
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Content contents = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.Content.Builder> getContentsBuilderList() {
      return getContentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.Content,
            com.google.cloud.vertexai.api.Content.Builder,
            com.google.cloud.vertexai.api.ContentOrBuilder>
        getContentsFieldBuilder() {
      if (contentsBuilder_ == null) {
        contentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vertexai.api.Content,
                com.google.cloud.vertexai.api.Content.Builder,
                com.google.cloud.vertexai.api.ContentOrBuilder>(
                contents_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        contents_ = null;
      }
      return contentsBuilder_;
    }

    private com.google.cloud.vertexai.api.Content systemInstruction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.Content,
            com.google.cloud.vertexai.api.Content.Builder,
            com.google.cloud.vertexai.api.ContentOrBuilder>
        systemInstructionBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.vertexai.v1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the systemInstruction field is set.
     */
    public boolean hasSystemInstruction() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.vertexai.v1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The systemInstruction.
     */
    public com.google.cloud.vertexai.api.Content getSystemInstruction() {
      if (systemInstructionBuilder_ == null) {
        return systemInstruction_ == null
            ? com.google.cloud.vertexai.api.Content.getDefaultInstance()
            : systemInstruction_;
      } else {
        return systemInstructionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.vertexai.v1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSystemInstruction(com.google.cloud.vertexai.api.Content value) {
      if (systemInstructionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        systemInstruction_ = value;
      } else {
        systemInstructionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.vertexai.v1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSystemInstruction(
        com.google.cloud.vertexai.api.Content.Builder builderForValue) {
      if (systemInstructionBuilder_ == null) {
        systemInstruction_ = builderForValue.build();
      } else {
        systemInstructionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.vertexai.v1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSystemInstruction(com.google.cloud.vertexai.api.Content value) {
      if (systemInstructionBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && systemInstruction_ != null
            && systemInstruction_ != com.google.cloud.vertexai.api.Content.getDefaultInstance()) {
          getSystemInstructionBuilder().mergeFrom(value);
        } else {
          systemInstruction_ = value;
        }
      } else {
        systemInstructionBuilder_.mergeFrom(value);
      }
      if (systemInstruction_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.vertexai.v1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSystemInstruction() {
      bitField0_ = (bitField0_ & ~0x00000004);
      systemInstruction_ = null;
      if (systemInstructionBuilder_ != null) {
        systemInstructionBuilder_.dispose();
        systemInstructionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.vertexai.v1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.Content.Builder getSystemInstructionBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getSystemInstructionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.vertexai.v1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.ContentOrBuilder getSystemInstructionOrBuilder() {
      if (systemInstructionBuilder_ != null) {
        return systemInstructionBuilder_.getMessageOrBuilder();
      } else {
        return systemInstruction_ == null
            ? com.google.cloud.vertexai.api.Content.getDefaultInstance()
            : systemInstruction_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The user provided system instructions for the model.
     * Note: only text should be used in parts and content in each part will be in
     * a separate paragraph.
     * </pre>
     *
     * <code>
     * optional .google.cloud.vertexai.v1.Content system_instruction = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.Content,
            com.google.cloud.vertexai.api.Content.Builder,
            com.google.cloud.vertexai.api.ContentOrBuilder>
        getSystemInstructionFieldBuilder() {
      if (systemInstructionBuilder_ == null) {
        systemInstructionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vertexai.api.Content,
                com.google.cloud.vertexai.api.Content.Builder,
                com.google.cloud.vertexai.api.ContentOrBuilder>(
                getSystemInstruction(), getParentForChildren(), isClean());
        systemInstruction_ = null;
      }
      return systemInstructionBuilder_;
    }

    private java.util.List<com.google.cloud.vertexai.api.Tool> tools_ =
        java.util.Collections.emptyList();

    private void ensureToolsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        tools_ = new java.util.ArrayList<com.google.cloud.vertexai.api.Tool>(tools_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.Tool,
            com.google.cloud.vertexai.api.Tool.Builder,
            com.google.cloud.vertexai.api.ToolOrBuilder>
        toolsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.Tool> getToolsList() {
      if (toolsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tools_);
      } else {
        return toolsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getToolsCount() {
      if (toolsBuilder_ == null) {
        return tools_.size();
      } else {
        return toolsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.Tool getTools(int index) {
      if (toolsBuilder_ == null) {
        return tools_.get(index);
      } else {
        return toolsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTools(int index, com.google.cloud.vertexai.api.Tool value) {
      if (toolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolsIsMutable();
        tools_.set(index, value);
        onChanged();
      } else {
        toolsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTools(int index, com.google.cloud.vertexai.api.Tool.Builder builderForValue) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        tools_.set(index, builderForValue.build());
        onChanged();
      } else {
        toolsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTools(com.google.cloud.vertexai.api.Tool value) {
      if (toolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolsIsMutable();
        tools_.add(value);
        onChanged();
      } else {
        toolsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTools(int index, com.google.cloud.vertexai.api.Tool value) {
      if (toolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureToolsIsMutable();
        tools_.add(index, value);
        onChanged();
      } else {
        toolsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTools(com.google.cloud.vertexai.api.Tool.Builder builderForValue) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        tools_.add(builderForValue.build());
        onChanged();
      } else {
        toolsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTools(int index, com.google.cloud.vertexai.api.Tool.Builder builderForValue) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        tools_.add(index, builderForValue.build());
        onChanged();
      } else {
        toolsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllTools(
        java.lang.Iterable<? extends com.google.cloud.vertexai.api.Tool> values) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tools_);
        onChanged();
      } else {
        toolsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTools() {
      if (toolsBuilder_ == null) {
        tools_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        toolsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeTools(int index) {
      if (toolsBuilder_ == null) {
        ensureToolsIsMutable();
        tools_.remove(index);
        onChanged();
      } else {
        toolsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.Tool.Builder getToolsBuilder(int index) {
      return getToolsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.ToolOrBuilder getToolsOrBuilder(int index) {
      if (toolsBuilder_ == null) {
        return tools_.get(index);
      } else {
        return toolsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.vertexai.api.ToolOrBuilder>
        getToolsOrBuilderList() {
      if (toolsBuilder_ != null) {
        return toolsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tools_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.Tool.Builder addToolsBuilder() {
      return getToolsFieldBuilder()
          .addBuilder(com.google.cloud.vertexai.api.Tool.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.Tool.Builder addToolsBuilder(int index) {
      return getToolsFieldBuilder()
          .addBuilder(index, com.google.cloud.vertexai.api.Tool.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of `Tools` the model may use to generate the next
     * response.
     *
     * A `Tool` is a piece of code that enables the system to interact with
     * external systems to perform an action, or set of actions, outside of
     * knowledge and scope of the model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tool tools = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.Tool.Builder> getToolsBuilderList() {
      return getToolsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.Tool,
            com.google.cloud.vertexai.api.Tool.Builder,
            com.google.cloud.vertexai.api.ToolOrBuilder>
        getToolsFieldBuilder() {
      if (toolsBuilder_ == null) {
        toolsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vertexai.api.Tool,
                com.google.cloud.vertexai.api.Tool.Builder,
                com.google.cloud.vertexai.api.ToolOrBuilder>(
                tools_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        tools_ = null;
      }
      return toolsBuilder_;
    }

    private com.google.cloud.vertexai.api.ToolConfig toolConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.ToolConfig,
            com.google.cloud.vertexai.api.ToolConfig.Builder,
            com.google.cloud.vertexai.api.ToolConfigOrBuilder>
        toolConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the toolConfig field is set.
     */
    public boolean hasToolConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The toolConfig.
     */
    public com.google.cloud.vertexai.api.ToolConfig getToolConfig() {
      if (toolConfigBuilder_ == null) {
        return toolConfig_ == null
            ? com.google.cloud.vertexai.api.ToolConfig.getDefaultInstance()
            : toolConfig_;
      } else {
        return toolConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setToolConfig(com.google.cloud.vertexai.api.ToolConfig value) {
      if (toolConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        toolConfig_ = value;
      } else {
        toolConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setToolConfig(com.google.cloud.vertexai.api.ToolConfig.Builder builderForValue) {
      if (toolConfigBuilder_ == null) {
        toolConfig_ = builderForValue.build();
      } else {
        toolConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeToolConfig(com.google.cloud.vertexai.api.ToolConfig value) {
      if (toolConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && toolConfig_ != null
            && toolConfig_ != com.google.cloud.vertexai.api.ToolConfig.getDefaultInstance()) {
          getToolConfigBuilder().mergeFrom(value);
        } else {
          toolConfig_ = value;
        }
      } else {
        toolConfigBuilder_.mergeFrom(value);
      }
      if (toolConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearToolConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      toolConfig_ = null;
      if (toolConfigBuilder_ != null) {
        toolConfigBuilder_.dispose();
        toolConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.ToolConfig.Builder getToolConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getToolConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.ToolConfigOrBuilder getToolConfigOrBuilder() {
      if (toolConfigBuilder_ != null) {
        return toolConfigBuilder_.getMessageOrBuilder();
      } else {
        return toolConfig_ == null
            ? com.google.cloud.vertexai.api.ToolConfig.getDefaultInstance()
            : toolConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Tool config. This config is shared for all tools provided in the
     * request.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ToolConfig tool_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.ToolConfig,
            com.google.cloud.vertexai.api.ToolConfig.Builder,
            com.google.cloud.vertexai.api.ToolConfigOrBuilder>
        getToolConfigFieldBuilder() {
      if (toolConfigBuilder_ == null) {
        toolConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vertexai.api.ToolConfig,
                com.google.cloud.vertexai.api.ToolConfig.Builder,
                com.google.cloud.vertexai.api.ToolConfigOrBuilder>(
                getToolConfig(), getParentForChildren(), isClean());
        toolConfig_ = null;
      }
      return toolConfigBuilder_;
    }

    private java.util.List<com.google.cloud.vertexai.api.SafetySetting> safetySettings_ =
        java.util.Collections.emptyList();

    private void ensureSafetySettingsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        safetySettings_ =
            new java.util.ArrayList<com.google.cloud.vertexai.api.SafetySetting>(safetySettings_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.SafetySetting,
            com.google.cloud.vertexai.api.SafetySetting.Builder,
            com.google.cloud.vertexai.api.SafetySettingOrBuilder>
        safetySettingsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.SafetySetting> getSafetySettingsList() {
      if (safetySettingsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(safetySettings_);
      } else {
        return safetySettingsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getSafetySettingsCount() {
      if (safetySettingsBuilder_ == null) {
        return safetySettings_.size();
      } else {
        return safetySettingsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.SafetySetting getSafetySettings(int index) {
      if (safetySettingsBuilder_ == null) {
        return safetySettings_.get(index);
      } else {
        return safetySettingsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSafetySettings(int index, com.google.cloud.vertexai.api.SafetySetting value) {
      if (safetySettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSafetySettingsIsMutable();
        safetySettings_.set(index, value);
        onChanged();
      } else {
        safetySettingsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSafetySettings(
        int index, com.google.cloud.vertexai.api.SafetySetting.Builder builderForValue) {
      if (safetySettingsBuilder_ == null) {
        ensureSafetySettingsIsMutable();
        safetySettings_.set(index, builderForValue.build());
        onChanged();
      } else {
        safetySettingsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSafetySettings(com.google.cloud.vertexai.api.SafetySetting value) {
      if (safetySettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSafetySettingsIsMutable();
        safetySettings_.add(value);
        onChanged();
      } else {
        safetySettingsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSafetySettings(int index, com.google.cloud.vertexai.api.SafetySetting value) {
      if (safetySettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSafetySettingsIsMutable();
        safetySettings_.add(index, value);
        onChanged();
      } else {
        safetySettingsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSafetySettings(
        com.google.cloud.vertexai.api.SafetySetting.Builder builderForValue) {
      if (safetySettingsBuilder_ == null) {
        ensureSafetySettingsIsMutable();
        safetySettings_.add(builderForValue.build());
        onChanged();
      } else {
        safetySettingsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSafetySettings(
        int index, com.google.cloud.vertexai.api.SafetySetting.Builder builderForValue) {
      if (safetySettingsBuilder_ == null) {
        ensureSafetySettingsIsMutable();
        safetySettings_.add(index, builderForValue.build());
        onChanged();
      } else {
        safetySettingsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllSafetySettings(
        java.lang.Iterable<? extends com.google.cloud.vertexai.api.SafetySetting> values) {
      if (safetySettingsBuilder_ == null) {
        ensureSafetySettingsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, safetySettings_);
        onChanged();
      } else {
        safetySettingsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSafetySettings() {
      if (safetySettingsBuilder_ == null) {
        safetySettings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        safetySettingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeSafetySettings(int index) {
      if (safetySettingsBuilder_ == null) {
        ensureSafetySettingsIsMutable();
        safetySettings_.remove(index);
        onChanged();
      } else {
        safetySettingsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.SafetySetting.Builder getSafetySettingsBuilder(int index) {
      return getSafetySettingsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.SafetySettingOrBuilder getSafetySettingsOrBuilder(
        int index) {
      if (safetySettingsBuilder_ == null) {
        return safetySettings_.get(index);
      } else {
        return safetySettingsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.vertexai.api.SafetySettingOrBuilder>
        getSafetySettingsOrBuilderList() {
      if (safetySettingsBuilder_ != null) {
        return safetySettingsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(safetySettings_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.SafetySetting.Builder addSafetySettingsBuilder() {
      return getSafetySettingsFieldBuilder()
          .addBuilder(com.google.cloud.vertexai.api.SafetySetting.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.SafetySetting.Builder addSafetySettingsBuilder(int index) {
      return getSafetySettingsFieldBuilder()
          .addBuilder(index, com.google.cloud.vertexai.api.SafetySetting.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Per request settings for blocking unsafe content.
     * Enforced on GenerateContentResponse.candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetySetting safety_settings = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.SafetySetting.Builder>
        getSafetySettingsBuilderList() {
      return getSafetySettingsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.SafetySetting,
            com.google.cloud.vertexai.api.SafetySetting.Builder,
            com.google.cloud.vertexai.api.SafetySettingOrBuilder>
        getSafetySettingsFieldBuilder() {
      if (safetySettingsBuilder_ == null) {
        safetySettingsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vertexai.api.SafetySetting,
                com.google.cloud.vertexai.api.SafetySetting.Builder,
                com.google.cloud.vertexai.api.SafetySettingOrBuilder>(
                safetySettings_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        safetySettings_ = null;
      }
      return safetySettingsBuilder_;
    }

    private com.google.cloud.vertexai.api.GenerationConfig generationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.GenerationConfig,
            com.google.cloud.vertexai.api.GenerationConfig.Builder,
            com.google.cloud.vertexai.api.GenerationConfigOrBuilder>
        generationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the generationConfig field is set.
     */
    public boolean hasGenerationConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The generationConfig.
     */
    public com.google.cloud.vertexai.api.GenerationConfig getGenerationConfig() {
      if (generationConfigBuilder_ == null) {
        return generationConfig_ == null
            ? com.google.cloud.vertexai.api.GenerationConfig.getDefaultInstance()
            : generationConfig_;
      } else {
        return generationConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGenerationConfig(com.google.cloud.vertexai.api.GenerationConfig value) {
      if (generationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        generationConfig_ = value;
      } else {
        generationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGenerationConfig(
        com.google.cloud.vertexai.api.GenerationConfig.Builder builderForValue) {
      if (generationConfigBuilder_ == null) {
        generationConfig_ = builderForValue.build();
      } else {
        generationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGenerationConfig(com.google.cloud.vertexai.api.GenerationConfig value) {
      if (generationConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && generationConfig_ != null
            && generationConfig_
                != com.google.cloud.vertexai.api.GenerationConfig.getDefaultInstance()) {
          getGenerationConfigBuilder().mergeFrom(value);
        } else {
          generationConfig_ = value;
        }
      } else {
        generationConfigBuilder_.mergeFrom(value);
      }
      if (generationConfig_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGenerationConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      generationConfig_ = null;
      if (generationConfigBuilder_ != null) {
        generationConfigBuilder_.dispose();
        generationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.GenerationConfig.Builder getGenerationConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getGenerationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.GenerationConfigOrBuilder getGenerationConfigOrBuilder() {
      if (generationConfigBuilder_ != null) {
        return generationConfigBuilder_.getMessageOrBuilder();
      } else {
        return generationConfig_ == null
            ? com.google.cloud.vertexai.api.GenerationConfig.getDefaultInstance()
            : generationConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Generation config.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GenerationConfig generation_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.GenerationConfig,
            com.google.cloud.vertexai.api.GenerationConfig.Builder,
            com.google.cloud.vertexai.api.GenerationConfigOrBuilder>
        getGenerationConfigFieldBuilder() {
      if (generationConfigBuilder_ == null) {
        generationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vertexai.api.GenerationConfig,
                com.google.cloud.vertexai.api.GenerationConfig.Builder,
                com.google.cloud.vertexai.api.GenerationConfigOrBuilder>(
                getGenerationConfig(), getParentForChildren(), isClean());
        generationConfig_ = null;
      }
      return generationConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.GenerateContentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.GenerateContentRequest)
  private static final com.google.cloud.vertexai.api.GenerateContentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vertexai.api.GenerateContentRequest();
  }

  public static com.google.cloud.vertexai.api.GenerateContentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateContentRequest> PARSER =
      new com.google.protobuf.AbstractParser<GenerateContentRequest>() {
        @java.lang.Override
        public GenerateContentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerateContentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateContentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vertexai.api.GenerateContentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
