/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vertexai/v1/content.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.vertexai.api;

/**
 *
 *
 * <pre>
 * Grounding support.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vertexai.v1.GroundingSupport}
 */
public final class GroundingSupport extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.GroundingSupport)
    GroundingSupportOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GroundingSupport.newBuilder() to construct.
  private GroundingSupport(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GroundingSupport() {
    groundingChunkIndices_ = emptyIntList();
    confidenceScores_ = emptyFloatList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GroundingSupport();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vertexai.api.ContentProto
        .internal_static_google_cloud_vertexai_v1_GroundingSupport_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vertexai.api.ContentProto
        .internal_static_google_cloud_vertexai_v1_GroundingSupport_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vertexai.api.GroundingSupport.class,
            com.google.cloud.vertexai.api.GroundingSupport.Builder.class);
  }

  private int bitField0_;
  public static final int SEGMENT_FIELD_NUMBER = 1;
  private com.google.cloud.vertexai.api.Segment segment_;
  /**
   *
   *
   * <pre>
   * Segment of the content this support belongs to.
   * </pre>
   *
   * <code>optional .google.cloud.vertexai.v1.Segment segment = 1;</code>
   *
   * @return Whether the segment field is set.
   */
  @java.lang.Override
  public boolean hasSegment() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Segment of the content this support belongs to.
   * </pre>
   *
   * <code>optional .google.cloud.vertexai.v1.Segment segment = 1;</code>
   *
   * @return The segment.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.Segment getSegment() {
    return segment_ == null ? com.google.cloud.vertexai.api.Segment.getDefaultInstance() : segment_;
  }
  /**
   *
   *
   * <pre>
   * Segment of the content this support belongs to.
   * </pre>
   *
   * <code>optional .google.cloud.vertexai.v1.Segment segment = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.SegmentOrBuilder getSegmentOrBuilder() {
    return segment_ == null ? com.google.cloud.vertexai.api.Segment.getDefaultInstance() : segment_;
  }

  public static final int GROUNDING_CHUNK_INDICES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList groundingChunkIndices_ = emptyIntList();
  /**
   *
   *
   * <pre>
   * A list of indices (into 'grounding_chunk') specifying the
   * citations associated with the claim. For instance [1,3,4] means
   * that grounding_chunk[1], grounding_chunk[3],
   * grounding_chunk[4] are the retrieved content attributed to the claim.
   * </pre>
   *
   * <code>repeated int32 grounding_chunk_indices = 2;</code>
   *
   * @return A list containing the groundingChunkIndices.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getGroundingChunkIndicesList() {
    return groundingChunkIndices_;
  }
  /**
   *
   *
   * <pre>
   * A list of indices (into 'grounding_chunk') specifying the
   * citations associated with the claim. For instance [1,3,4] means
   * that grounding_chunk[1], grounding_chunk[3],
   * grounding_chunk[4] are the retrieved content attributed to the claim.
   * </pre>
   *
   * <code>repeated int32 grounding_chunk_indices = 2;</code>
   *
   * @return The count of groundingChunkIndices.
   */
  public int getGroundingChunkIndicesCount() {
    return groundingChunkIndices_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of indices (into 'grounding_chunk') specifying the
   * citations associated with the claim. For instance [1,3,4] means
   * that grounding_chunk[1], grounding_chunk[3],
   * grounding_chunk[4] are the retrieved content attributed to the claim.
   * </pre>
   *
   * <code>repeated int32 grounding_chunk_indices = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The groundingChunkIndices at the given index.
   */
  public int getGroundingChunkIndices(int index) {
    return groundingChunkIndices_.getInt(index);
  }

  private int groundingChunkIndicesMemoizedSerializedSize = -1;

  public static final int CONFIDENCE_SCORES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.FloatList confidenceScores_ = emptyFloatList();
  /**
   *
   *
   * <pre>
   * Confidence score of the support references. Ranges from 0 to 1. 1 is the
   * most confident. This list must have the same size as the
   * grounding_chunk_indices.
   * </pre>
   *
   * <code>repeated float confidence_scores = 3;</code>
   *
   * @return A list containing the confidenceScores.
   */
  @java.lang.Override
  public java.util.List<java.lang.Float> getConfidenceScoresList() {
    return confidenceScores_;
  }
  /**
   *
   *
   * <pre>
   * Confidence score of the support references. Ranges from 0 to 1. 1 is the
   * most confident. This list must have the same size as the
   * grounding_chunk_indices.
   * </pre>
   *
   * <code>repeated float confidence_scores = 3;</code>
   *
   * @return The count of confidenceScores.
   */
  public int getConfidenceScoresCount() {
    return confidenceScores_.size();
  }
  /**
   *
   *
   * <pre>
   * Confidence score of the support references. Ranges from 0 to 1. 1 is the
   * most confident. This list must have the same size as the
   * grounding_chunk_indices.
   * </pre>
   *
   * <code>repeated float confidence_scores = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The confidenceScores at the given index.
   */
  public float getConfidenceScores(int index) {
    return confidenceScores_.getFloat(index);
  }

  private int confidenceScoresMemoizedSerializedSize = -1;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getSegment());
    }
    if (getGroundingChunkIndicesList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(groundingChunkIndicesMemoizedSerializedSize);
    }
    for (int i = 0; i < groundingChunkIndices_.size(); i++) {
      output.writeInt32NoTag(groundingChunkIndices_.getInt(i));
    }
    if (getConfidenceScoresList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(confidenceScoresMemoizedSerializedSize);
    }
    for (int i = 0; i < confidenceScores_.size(); i++) {
      output.writeFloatNoTag(confidenceScores_.getFloat(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSegment());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < groundingChunkIndices_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(
                groundingChunkIndices_.getInt(i));
      }
      size += dataSize;
      if (!getGroundingChunkIndicesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      groundingChunkIndicesMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      dataSize = 4 * getConfidenceScoresList().size();
      size += dataSize;
      if (!getConfidenceScoresList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      confidenceScoresMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vertexai.api.GroundingSupport)) {
      return super.equals(obj);
    }
    com.google.cloud.vertexai.api.GroundingSupport other =
        (com.google.cloud.vertexai.api.GroundingSupport) obj;

    if (hasSegment() != other.hasSegment()) return false;
    if (hasSegment()) {
      if (!getSegment().equals(other.getSegment())) return false;
    }
    if (!getGroundingChunkIndicesList().equals(other.getGroundingChunkIndicesList())) return false;
    if (!getConfidenceScoresList().equals(other.getConfidenceScoresList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasSegment()) {
      hash = (37 * hash) + SEGMENT_FIELD_NUMBER;
      hash = (53 * hash) + getSegment().hashCode();
    }
    if (getGroundingChunkIndicesCount() > 0) {
      hash = (37 * hash) + GROUNDING_CHUNK_INDICES_FIELD_NUMBER;
      hash = (53 * hash) + getGroundingChunkIndicesList().hashCode();
    }
    if (getConfidenceScoresCount() > 0) {
      hash = (37 * hash) + CONFIDENCE_SCORES_FIELD_NUMBER;
      hash = (53 * hash) + getConfidenceScoresList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vertexai.api.GroundingSupport parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.GroundingSupport parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.GroundingSupport parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.GroundingSupport parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.GroundingSupport parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.GroundingSupport parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.GroundingSupport parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.GroundingSupport parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.GroundingSupport parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.GroundingSupport parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.GroundingSupport parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.GroundingSupport parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vertexai.api.GroundingSupport prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Grounding support.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vertexai.v1.GroundingSupport}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.GroundingSupport)
      com.google.cloud.vertexai.api.GroundingSupportOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vertexai.api.ContentProto
          .internal_static_google_cloud_vertexai_v1_GroundingSupport_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vertexai.api.ContentProto
          .internal_static_google_cloud_vertexai_v1_GroundingSupport_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vertexai.api.GroundingSupport.class,
              com.google.cloud.vertexai.api.GroundingSupport.Builder.class);
    }

    // Construct using com.google.cloud.vertexai.api.GroundingSupport.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSegmentFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      segment_ = null;
      if (segmentBuilder_ != null) {
        segmentBuilder_.dispose();
        segmentBuilder_ = null;
      }
      groundingChunkIndices_ = emptyIntList();
      confidenceScores_ = emptyFloatList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vertexai.api.ContentProto
          .internal_static_google_cloud_vertexai_v1_GroundingSupport_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.GroundingSupport getDefaultInstanceForType() {
      return com.google.cloud.vertexai.api.GroundingSupport.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.GroundingSupport build() {
      com.google.cloud.vertexai.api.GroundingSupport result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.GroundingSupport buildPartial() {
      com.google.cloud.vertexai.api.GroundingSupport result =
          new com.google.cloud.vertexai.api.GroundingSupport(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.vertexai.api.GroundingSupport result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.segment_ = segmentBuilder_ == null ? segment_ : segmentBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        groundingChunkIndices_.makeImmutable();
        result.groundingChunkIndices_ = groundingChunkIndices_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        confidenceScores_.makeImmutable();
        result.confidenceScores_ = confidenceScores_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vertexai.api.GroundingSupport) {
        return mergeFrom((com.google.cloud.vertexai.api.GroundingSupport) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vertexai.api.GroundingSupport other) {
      if (other == com.google.cloud.vertexai.api.GroundingSupport.getDefaultInstance()) return this;
      if (other.hasSegment()) {
        mergeSegment(other.getSegment());
      }
      if (!other.groundingChunkIndices_.isEmpty()) {
        if (groundingChunkIndices_.isEmpty()) {
          groundingChunkIndices_ = other.groundingChunkIndices_;
          groundingChunkIndices_.makeImmutable();
          bitField0_ |= 0x00000002;
        } else {
          ensureGroundingChunkIndicesIsMutable();
          groundingChunkIndices_.addAll(other.groundingChunkIndices_);
        }
        onChanged();
      }
      if (!other.confidenceScores_.isEmpty()) {
        if (confidenceScores_.isEmpty()) {
          confidenceScores_ = other.confidenceScores_;
          confidenceScores_.makeImmutable();
          bitField0_ |= 0x00000004;
        } else {
          ensureConfidenceScoresIsMutable();
          confidenceScores_.addAll(other.confidenceScores_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getSegmentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                int v = input.readInt32();
                ensureGroundingChunkIndicesIsMutable();
                groundingChunkIndices_.addInt(v);
                break;
              } // case 16
            case 18:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureGroundingChunkIndicesIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  groundingChunkIndices_.addInt(input.readInt32());
                }
                input.popLimit(limit);
                break;
              } // case 18
            case 29:
              {
                float v = input.readFloat();
                ensureConfidenceScoresIsMutable();
                confidenceScores_.addFloat(v);
                break;
              } // case 29
            case 26:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                int alloc = length > 4096 ? 4096 : length;
                ensureConfidenceScoresIsMutable(alloc / 4);
                while (input.getBytesUntilLimit() > 0) {
                  confidenceScores_.addFloat(input.readFloat());
                }
                input.popLimit(limit);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.vertexai.api.Segment segment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.Segment,
            com.google.cloud.vertexai.api.Segment.Builder,
            com.google.cloud.vertexai.api.SegmentOrBuilder>
        segmentBuilder_;
    /**
     *
     *
     * <pre>
     * Segment of the content this support belongs to.
     * </pre>
     *
     * <code>optional .google.cloud.vertexai.v1.Segment segment = 1;</code>
     *
     * @return Whether the segment field is set.
     */
    public boolean hasSegment() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Segment of the content this support belongs to.
     * </pre>
     *
     * <code>optional .google.cloud.vertexai.v1.Segment segment = 1;</code>
     *
     * @return The segment.
     */
    public com.google.cloud.vertexai.api.Segment getSegment() {
      if (segmentBuilder_ == null) {
        return segment_ == null
            ? com.google.cloud.vertexai.api.Segment.getDefaultInstance()
            : segment_;
      } else {
        return segmentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Segment of the content this support belongs to.
     * </pre>
     *
     * <code>optional .google.cloud.vertexai.v1.Segment segment = 1;</code>
     */
    public Builder setSegment(com.google.cloud.vertexai.api.Segment value) {
      if (segmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        segment_ = value;
      } else {
        segmentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Segment of the content this support belongs to.
     * </pre>
     *
     * <code>optional .google.cloud.vertexai.v1.Segment segment = 1;</code>
     */
    public Builder setSegment(com.google.cloud.vertexai.api.Segment.Builder builderForValue) {
      if (segmentBuilder_ == null) {
        segment_ = builderForValue.build();
      } else {
        segmentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Segment of the content this support belongs to.
     * </pre>
     *
     * <code>optional .google.cloud.vertexai.v1.Segment segment = 1;</code>
     */
    public Builder mergeSegment(com.google.cloud.vertexai.api.Segment value) {
      if (segmentBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && segment_ != null
            && segment_ != com.google.cloud.vertexai.api.Segment.getDefaultInstance()) {
          getSegmentBuilder().mergeFrom(value);
        } else {
          segment_ = value;
        }
      } else {
        segmentBuilder_.mergeFrom(value);
      }
      if (segment_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Segment of the content this support belongs to.
     * </pre>
     *
     * <code>optional .google.cloud.vertexai.v1.Segment segment = 1;</code>
     */
    public Builder clearSegment() {
      bitField0_ = (bitField0_ & ~0x00000001);
      segment_ = null;
      if (segmentBuilder_ != null) {
        segmentBuilder_.dispose();
        segmentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Segment of the content this support belongs to.
     * </pre>
     *
     * <code>optional .google.cloud.vertexai.v1.Segment segment = 1;</code>
     */
    public com.google.cloud.vertexai.api.Segment.Builder getSegmentBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getSegmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Segment of the content this support belongs to.
     * </pre>
     *
     * <code>optional .google.cloud.vertexai.v1.Segment segment = 1;</code>
     */
    public com.google.cloud.vertexai.api.SegmentOrBuilder getSegmentOrBuilder() {
      if (segmentBuilder_ != null) {
        return segmentBuilder_.getMessageOrBuilder();
      } else {
        return segment_ == null
            ? com.google.cloud.vertexai.api.Segment.getDefaultInstance()
            : segment_;
      }
    }
    /**
     *
     *
     * <pre>
     * Segment of the content this support belongs to.
     * </pre>
     *
     * <code>optional .google.cloud.vertexai.v1.Segment segment = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.Segment,
            com.google.cloud.vertexai.api.Segment.Builder,
            com.google.cloud.vertexai.api.SegmentOrBuilder>
        getSegmentFieldBuilder() {
      if (segmentBuilder_ == null) {
        segmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vertexai.api.Segment,
                com.google.cloud.vertexai.api.Segment.Builder,
                com.google.cloud.vertexai.api.SegmentOrBuilder>(
                getSegment(), getParentForChildren(), isClean());
        segment_ = null;
      }
      return segmentBuilder_;
    }

    private com.google.protobuf.Internal.IntList groundingChunkIndices_ = emptyIntList();

    private void ensureGroundingChunkIndicesIsMutable() {
      if (!groundingChunkIndices_.isModifiable()) {
        groundingChunkIndices_ = makeMutableCopy(groundingChunkIndices_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * A list of indices (into 'grounding_chunk') specifying the
     * citations associated with the claim. For instance [1,3,4] means
     * that grounding_chunk[1], grounding_chunk[3],
     * grounding_chunk[4] are the retrieved content attributed to the claim.
     * </pre>
     *
     * <code>repeated int32 grounding_chunk_indices = 2;</code>
     *
     * @return A list containing the groundingChunkIndices.
     */
    public java.util.List<java.lang.Integer> getGroundingChunkIndicesList() {
      groundingChunkIndices_.makeImmutable();
      return groundingChunkIndices_;
    }
    /**
     *
     *
     * <pre>
     * A list of indices (into 'grounding_chunk') specifying the
     * citations associated with the claim. For instance [1,3,4] means
     * that grounding_chunk[1], grounding_chunk[3],
     * grounding_chunk[4] are the retrieved content attributed to the claim.
     * </pre>
     *
     * <code>repeated int32 grounding_chunk_indices = 2;</code>
     *
     * @return The count of groundingChunkIndices.
     */
    public int getGroundingChunkIndicesCount() {
      return groundingChunkIndices_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of indices (into 'grounding_chunk') specifying the
     * citations associated with the claim. For instance [1,3,4] means
     * that grounding_chunk[1], grounding_chunk[3],
     * grounding_chunk[4] are the retrieved content attributed to the claim.
     * </pre>
     *
     * <code>repeated int32 grounding_chunk_indices = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The groundingChunkIndices at the given index.
     */
    public int getGroundingChunkIndices(int index) {
      return groundingChunkIndices_.getInt(index);
    }
    /**
     *
     *
     * <pre>
     * A list of indices (into 'grounding_chunk') specifying the
     * citations associated with the claim. For instance [1,3,4] means
     * that grounding_chunk[1], grounding_chunk[3],
     * grounding_chunk[4] are the retrieved content attributed to the claim.
     * </pre>
     *
     * <code>repeated int32 grounding_chunk_indices = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The groundingChunkIndices to set.
     * @return This builder for chaining.
     */
    public Builder setGroundingChunkIndices(int index, int value) {

      ensureGroundingChunkIndicesIsMutable();
      groundingChunkIndices_.setInt(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of indices (into 'grounding_chunk') specifying the
     * citations associated with the claim. For instance [1,3,4] means
     * that grounding_chunk[1], grounding_chunk[3],
     * grounding_chunk[4] are the retrieved content attributed to the claim.
     * </pre>
     *
     * <code>repeated int32 grounding_chunk_indices = 2;</code>
     *
     * @param value The groundingChunkIndices to add.
     * @return This builder for chaining.
     */
    public Builder addGroundingChunkIndices(int value) {

      ensureGroundingChunkIndicesIsMutable();
      groundingChunkIndices_.addInt(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of indices (into 'grounding_chunk') specifying the
     * citations associated with the claim. For instance [1,3,4] means
     * that grounding_chunk[1], grounding_chunk[3],
     * grounding_chunk[4] are the retrieved content attributed to the claim.
     * </pre>
     *
     * <code>repeated int32 grounding_chunk_indices = 2;</code>
     *
     * @param values The groundingChunkIndices to add.
     * @return This builder for chaining.
     */
    public Builder addAllGroundingChunkIndices(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureGroundingChunkIndicesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, groundingChunkIndices_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of indices (into 'grounding_chunk') specifying the
     * citations associated with the claim. For instance [1,3,4] means
     * that grounding_chunk[1], grounding_chunk[3],
     * grounding_chunk[4] are the retrieved content attributed to the claim.
     * </pre>
     *
     * <code>repeated int32 grounding_chunk_indices = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGroundingChunkIndices() {
      groundingChunkIndices_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.FloatList confidenceScores_ = emptyFloatList();

    private void ensureConfidenceScoresIsMutable() {
      if (!confidenceScores_.isModifiable()) {
        confidenceScores_ = makeMutableCopy(confidenceScores_);
      }
      bitField0_ |= 0x00000004;
    }

    private void ensureConfidenceScoresIsMutable(int capacity) {
      if (!confidenceScores_.isModifiable()) {
        confidenceScores_ = makeMutableCopy(confidenceScores_, capacity);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Confidence score of the support references. Ranges from 0 to 1. 1 is the
     * most confident. This list must have the same size as the
     * grounding_chunk_indices.
     * </pre>
     *
     * <code>repeated float confidence_scores = 3;</code>
     *
     * @return A list containing the confidenceScores.
     */
    public java.util.List<java.lang.Float> getConfidenceScoresList() {
      confidenceScores_.makeImmutable();
      return confidenceScores_;
    }
    /**
     *
     *
     * <pre>
     * Confidence score of the support references. Ranges from 0 to 1. 1 is the
     * most confident. This list must have the same size as the
     * grounding_chunk_indices.
     * </pre>
     *
     * <code>repeated float confidence_scores = 3;</code>
     *
     * @return The count of confidenceScores.
     */
    public int getConfidenceScoresCount() {
      return confidenceScores_.size();
    }
    /**
     *
     *
     * <pre>
     * Confidence score of the support references. Ranges from 0 to 1. 1 is the
     * most confident. This list must have the same size as the
     * grounding_chunk_indices.
     * </pre>
     *
     * <code>repeated float confidence_scores = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The confidenceScores at the given index.
     */
    public float getConfidenceScores(int index) {
      return confidenceScores_.getFloat(index);
    }
    /**
     *
     *
     * <pre>
     * Confidence score of the support references. Ranges from 0 to 1. 1 is the
     * most confident. This list must have the same size as the
     * grounding_chunk_indices.
     * </pre>
     *
     * <code>repeated float confidence_scores = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The confidenceScores to set.
     * @return This builder for chaining.
     */
    public Builder setConfidenceScores(int index, float value) {

      ensureConfidenceScoresIsMutable();
      confidenceScores_.setFloat(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Confidence score of the support references. Ranges from 0 to 1. 1 is the
     * most confident. This list must have the same size as the
     * grounding_chunk_indices.
     * </pre>
     *
     * <code>repeated float confidence_scores = 3;</code>
     *
     * @param value The confidenceScores to add.
     * @return This builder for chaining.
     */
    public Builder addConfidenceScores(float value) {

      ensureConfidenceScoresIsMutable();
      confidenceScores_.addFloat(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Confidence score of the support references. Ranges from 0 to 1. 1 is the
     * most confident. This list must have the same size as the
     * grounding_chunk_indices.
     * </pre>
     *
     * <code>repeated float confidence_scores = 3;</code>
     *
     * @param values The confidenceScores to add.
     * @return This builder for chaining.
     */
    public Builder addAllConfidenceScores(java.lang.Iterable<? extends java.lang.Float> values) {
      ensureConfidenceScoresIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, confidenceScores_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Confidence score of the support references. Ranges from 0 to 1. 1 is the
     * most confident. This list must have the same size as the
     * grounding_chunk_indices.
     * </pre>
     *
     * <code>repeated float confidence_scores = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfidenceScores() {
      confidenceScores_ = emptyFloatList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.GroundingSupport)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.GroundingSupport)
  private static final com.google.cloud.vertexai.api.GroundingSupport DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vertexai.api.GroundingSupport();
  }

  public static com.google.cloud.vertexai.api.GroundingSupport getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GroundingSupport> PARSER =
      new com.google.protobuf.AbstractParser<GroundingSupport>() {
        @java.lang.Override
        public GroundingSupport parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GroundingSupport> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GroundingSupport> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vertexai.api.GroundingSupport getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
