/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vertexai/v1/openapi.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.vertexai.api;

/**
 *
 *
 * <pre>
 * Schema is used to define the format of input/output data. Represents a select
 * subset of an [OpenAPI 3.0 schema
 * object](https://spec.openapis.org/oas/v3.0.3#schema-object). More fields may
 * be added in the future as needed.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vertexai.v1.Schema}
 */
public final class Schema extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.Schema)
    SchemaOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Schema.newBuilder() to construct.
  private Schema(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Schema() {
    type_ = 0;
    format_ = "";
    title_ = "";
    description_ = "";
    enum_ = com.google.protobuf.LazyStringArrayList.emptyList();
    propertyOrdering_ = com.google.protobuf.LazyStringArrayList.emptyList();
    required_ = com.google.protobuf.LazyStringArrayList.emptyList();
    pattern_ = "";
    anyOf_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Schema();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vertexai.api.OpenApiProto
        .internal_static_google_cloud_vertexai_v1_Schema_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetProperties();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vertexai.api.OpenApiProto
        .internal_static_google_cloud_vertexai_v1_Schema_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vertexai.api.Schema.class,
            com.google.cloud.vertexai.api.Schema.Builder.class);
  }

  private int bitField0_;
  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The type of the data.
   * </pre>
   *
   * <code>.google.cloud.vertexai.v1.Type type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The type of the data.
   * </pre>
   *
   * <code>.google.cloud.vertexai.v1.Type type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.Type getType() {
    com.google.cloud.vertexai.api.Type result = com.google.cloud.vertexai.api.Type.forNumber(type_);
    return result == null ? com.google.cloud.vertexai.api.Type.UNRECOGNIZED : result;
  }

  public static final int FORMAT_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object format_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The format of the data.
   * Supported formats:
   *  for NUMBER type: "float", "double"
   *  for INTEGER type: "int32", "int64"
   *  for STRING type: "email", "byte", etc
   * </pre>
   *
   * <code>string format = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The format.
   */
  @java.lang.Override
  public java.lang.String getFormat() {
    java.lang.Object ref = format_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      format_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The format of the data.
   * Supported formats:
   *  for NUMBER type: "float", "double"
   *  for INTEGER type: "int32", "int64"
   *  for STRING type: "email", "byte", etc
   * </pre>
   *
   * <code>string format = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for format.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFormatBytes() {
    java.lang.Object ref = format_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      format_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TITLE_FIELD_NUMBER = 24;

  @SuppressWarnings("serial")
  private volatile java.lang.Object title_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The title of the Schema.
   * </pre>
   *
   * <code>string title = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The title.
   */
  @java.lang.Override
  public java.lang.String getTitle() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      title_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The title of the Schema.
   * </pre>
   *
   * <code>string title = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for title.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTitleBytes() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      title_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The description of the data.
   * </pre>
   *
   * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The description of the data.
   * </pre>
   *
   * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NULLABLE_FIELD_NUMBER = 6;
  private boolean nullable_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Indicates if the value may be null.
   * </pre>
   *
   * <code>bool nullable = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The nullable.
   */
  @java.lang.Override
  public boolean getNullable() {
    return nullable_;
  }

  public static final int DEFAULT_FIELD_NUMBER = 23;
  private com.google.protobuf.Value default_;
  /**
   *
   *
   * <pre>
   * Optional. Default value of the data.
   * </pre>
   *
   * <code>.google.protobuf.Value default = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the default field is set.
   */
  @java.lang.Override
  public boolean hasDefault() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Default value of the data.
   * </pre>
   *
   * <code>.google.protobuf.Value default = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The default.
   */
  @java.lang.Override
  public com.google.protobuf.Value getDefault() {
    return default_ == null ? com.google.protobuf.Value.getDefaultInstance() : default_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Default value of the data.
   * </pre>
   *
   * <code>.google.protobuf.Value default = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getDefaultOrBuilder() {
    return default_ == null ? com.google.protobuf.Value.getDefaultInstance() : default_;
  }

  public static final int ITEMS_FIELD_NUMBER = 2;
  private com.google.cloud.vertexai.api.Schema items_;
  /**
   *
   *
   * <pre>
   * Optional. SCHEMA FIELDS FOR TYPE ARRAY
   * Schema of the elements of Type.ARRAY.
   * </pre>
   *
   * <code>.google.cloud.vertexai.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the items field is set.
   */
  @java.lang.Override
  public boolean hasItems() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. SCHEMA FIELDS FOR TYPE ARRAY
   * Schema of the elements of Type.ARRAY.
   * </pre>
   *
   * <code>.google.cloud.vertexai.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The items.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.Schema getItems() {
    return items_ == null ? com.google.cloud.vertexai.api.Schema.getDefaultInstance() : items_;
  }
  /**
   *
   *
   * <pre>
   * Optional. SCHEMA FIELDS FOR TYPE ARRAY
   * Schema of the elements of Type.ARRAY.
   * </pre>
   *
   * <code>.google.cloud.vertexai.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.SchemaOrBuilder getItemsOrBuilder() {
    return items_ == null ? com.google.cloud.vertexai.api.Schema.getDefaultInstance() : items_;
  }

  public static final int MIN_ITEMS_FIELD_NUMBER = 21;
  private long minItems_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. Minimum number of the elements for Type.ARRAY.
   * </pre>
   *
   * <code>int64 min_items = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The minItems.
   */
  @java.lang.Override
  public long getMinItems() {
    return minItems_;
  }

  public static final int MAX_ITEMS_FIELD_NUMBER = 22;
  private long maxItems_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. Maximum number of the elements for Type.ARRAY.
   * </pre>
   *
   * <code>int64 max_items = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maxItems.
   */
  @java.lang.Override
  public long getMaxItems() {
    return maxItems_;
  }

  public static final int ENUM_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList enum_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Possible values of the element of primitive type with enum
   * format. Examples:
   * 1. We can define direction as :
   * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
   * 2. We can define apartment number as :
   * {type:INTEGER, format:enum, enum:["101", "201", "301"]}
   * </pre>
   *
   * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the enum.
   */
  public com.google.protobuf.ProtocolStringList getEnumList() {
    return enum_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Possible values of the element of primitive type with enum
   * format. Examples:
   * 1. We can define direction as :
   * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
   * 2. We can define apartment number as :
   * {type:INTEGER, format:enum, enum:["101", "201", "301"]}
   * </pre>
   *
   * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of enum.
   */
  public int getEnumCount() {
    return enum_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Possible values of the element of primitive type with enum
   * format. Examples:
   * 1. We can define direction as :
   * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
   * 2. We can define apartment number as :
   * {type:INTEGER, format:enum, enum:["101", "201", "301"]}
   * </pre>
   *
   * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The enum at the given index.
   */
  public java.lang.String getEnum(int index) {
    return enum_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Possible values of the element of primitive type with enum
   * format. Examples:
   * 1. We can define direction as :
   * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
   * 2. We can define apartment number as :
   * {type:INTEGER, format:enum, enum:["101", "201", "301"]}
   * </pre>
   *
   * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the enum at the given index.
   */
  public com.google.protobuf.ByteString getEnumBytes(int index) {
    return enum_.getByteString(index);
  }

  public static final int PROPERTIES_FIELD_NUMBER = 3;

  private static final class PropertiesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.vertexai.api.Schema>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.vertexai.api.Schema>newDefaultInstance(
                    com.google.cloud.vertexai.api.OpenApiProto
                        .internal_static_google_cloud_vertexai_v1_Schema_PropertiesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.cloud.vertexai.api.Schema.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.vertexai.api.Schema>
      properties_;

  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.vertexai.api.Schema>
      internalGetProperties() {
    if (properties_ == null) {
      return com.google.protobuf.MapField.emptyMapField(PropertiesDefaultEntryHolder.defaultEntry);
    }
    return properties_;
  }

  public int getPropertiesCount() {
    return internalGetProperties().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. SCHEMA FIELDS FOR TYPE OBJECT
   * Properties of Type.OBJECT.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.vertexai.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsProperties(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetProperties().getMap().containsKey(key);
  }
  /** Use {@link #getPropertiesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.vertexai.api.Schema> getProperties() {
    return getPropertiesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. SCHEMA FIELDS FOR TYPE OBJECT
   * Properties of Type.OBJECT.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.vertexai.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.vertexai.api.Schema> getPropertiesMap() {
    return internalGetProperties().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. SCHEMA FIELDS FOR TYPE OBJECT
   * Properties of Type.OBJECT.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.vertexai.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.vertexai.api.Schema getPropertiesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.vertexai.api.Schema defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.vertexai.api.Schema> map =
        internalGetProperties().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. SCHEMA FIELDS FOR TYPE OBJECT
   * Properties of Type.OBJECT.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.vertexai.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.Schema getPropertiesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.vertexai.api.Schema> map =
        internalGetProperties().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int PROPERTY_ORDERING_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList propertyOrdering_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The order of the properties.
   * Not a standard field in open api spec. Only used to support the order of
   * the properties.
   * </pre>
   *
   * <code>repeated string property_ordering = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the propertyOrdering.
   */
  public com.google.protobuf.ProtocolStringList getPropertyOrderingList() {
    return propertyOrdering_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The order of the properties.
   * Not a standard field in open api spec. Only used to support the order of
   * the properties.
   * </pre>
   *
   * <code>repeated string property_ordering = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of propertyOrdering.
   */
  public int getPropertyOrderingCount() {
    return propertyOrdering_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The order of the properties.
   * Not a standard field in open api spec. Only used to support the order of
   * the properties.
   * </pre>
   *
   * <code>repeated string property_ordering = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The propertyOrdering at the given index.
   */
  public java.lang.String getPropertyOrdering(int index) {
    return propertyOrdering_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The order of the properties.
   * Not a standard field in open api spec. Only used to support the order of
   * the properties.
   * </pre>
   *
   * <code>repeated string property_ordering = 25 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the propertyOrdering at the given index.
   */
  public com.google.protobuf.ByteString getPropertyOrderingBytes(int index) {
    return propertyOrdering_.getByteString(index);
  }

  public static final int REQUIRED_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList required_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Required properties of Type.OBJECT.
   * </pre>
   *
   * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the required.
   */
  public com.google.protobuf.ProtocolStringList getRequiredList() {
    return required_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Required properties of Type.OBJECT.
   * </pre>
   *
   * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of required.
   */
  public int getRequiredCount() {
    return required_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Required properties of Type.OBJECT.
   * </pre>
   *
   * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The required at the given index.
   */
  public java.lang.String getRequired(int index) {
    return required_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Required properties of Type.OBJECT.
   * </pre>
   *
   * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the required at the given index.
   */
  public com.google.protobuf.ByteString getRequiredBytes(int index) {
    return required_.getByteString(index);
  }

  public static final int MIN_PROPERTIES_FIELD_NUMBER = 14;
  private long minProperties_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. Minimum number of the properties for Type.OBJECT.
   * </pre>
   *
   * <code>int64 min_properties = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The minProperties.
   */
  @java.lang.Override
  public long getMinProperties() {
    return minProperties_;
  }

  public static final int MAX_PROPERTIES_FIELD_NUMBER = 15;
  private long maxProperties_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. Maximum number of the properties for Type.OBJECT.
   * </pre>
   *
   * <code>int64 max_properties = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maxProperties.
   */
  @java.lang.Override
  public long getMaxProperties() {
    return maxProperties_;
  }

  public static final int MINIMUM_FIELD_NUMBER = 16;
  private double minimum_ = 0D;
  /**
   *
   *
   * <pre>
   * Optional. SCHEMA FIELDS FOR TYPE INTEGER and NUMBER
   * Minimum value of the Type.INTEGER and Type.NUMBER
   * </pre>
   *
   * <code>double minimum = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The minimum.
   */
  @java.lang.Override
  public double getMinimum() {
    return minimum_;
  }

  public static final int MAXIMUM_FIELD_NUMBER = 17;
  private double maximum_ = 0D;
  /**
   *
   *
   * <pre>
   * Optional. Maximum value of the Type.INTEGER and Type.NUMBER
   * </pre>
   *
   * <code>double maximum = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maximum.
   */
  @java.lang.Override
  public double getMaximum() {
    return maximum_;
  }

  public static final int MIN_LENGTH_FIELD_NUMBER = 18;
  private long minLength_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. SCHEMA FIELDS FOR TYPE STRING
   * Minimum length of the Type.STRING
   * </pre>
   *
   * <code>int64 min_length = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The minLength.
   */
  @java.lang.Override
  public long getMinLength() {
    return minLength_;
  }

  public static final int MAX_LENGTH_FIELD_NUMBER = 19;
  private long maxLength_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. Maximum length of the Type.STRING
   * </pre>
   *
   * <code>int64 max_length = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maxLength.
   */
  @java.lang.Override
  public long getMaxLength() {
    return maxLength_;
  }

  public static final int PATTERN_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pattern_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Pattern of the Type.STRING to restrict a string to a regular
   * expression.
   * </pre>
   *
   * <code>string pattern = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pattern.
   */
  @java.lang.Override
  public java.lang.String getPattern() {
    java.lang.Object ref = pattern_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pattern_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Pattern of the Type.STRING to restrict a string to a regular
   * expression.
   * </pre>
   *
   * <code>string pattern = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pattern.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPatternBytes() {
    java.lang.Object ref = pattern_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pattern_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXAMPLE_FIELD_NUMBER = 4;
  private com.google.protobuf.Value example_;
  /**
   *
   *
   * <pre>
   * Optional. Example of the object. Will only populated when the object is the
   * root.
   * </pre>
   *
   * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the example field is set.
   */
  @java.lang.Override
  public boolean hasExample() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Example of the object. Will only populated when the object is the
   * root.
   * </pre>
   *
   * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The example.
   */
  @java.lang.Override
  public com.google.protobuf.Value getExample() {
    return example_ == null ? com.google.protobuf.Value.getDefaultInstance() : example_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Example of the object. Will only populated when the object is the
   * root.
   * </pre>
   *
   * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getExampleOrBuilder() {
    return example_ == null ? com.google.protobuf.Value.getDefaultInstance() : example_;
  }

  public static final int ANY_OF_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vertexai.api.Schema> anyOf_;
  /**
   *
   *
   * <pre>
   * Optional. The value should be validated against any (one or more) of the
   * subschemas in the list.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vertexai.api.Schema> getAnyOfList() {
    return anyOf_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The value should be validated against any (one or more) of the
   * subschemas in the list.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vertexai.api.SchemaOrBuilder>
      getAnyOfOrBuilderList() {
    return anyOf_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The value should be validated against any (one or more) of the
   * subschemas in the list.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getAnyOfCount() {
    return anyOf_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The value should be validated against any (one or more) of the
   * subschemas in the list.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.Schema getAnyOf(int index) {
    return anyOf_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The value should be validated against any (one or more) of the
   * subschemas in the list.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.SchemaOrBuilder getAnyOfOrBuilder(int index) {
    return anyOf_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (type_ != com.google.cloud.vertexai.api.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, type_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getItems());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetProperties(), PropertiesDefaultEntryHolder.defaultEntry, 3);
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getExample());
    }
    for (int i = 0; i < required_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, required_.getRaw(i));
    }
    if (nullable_ != false) {
      output.writeBool(6, nullable_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(format_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, format_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, description_);
    }
    for (int i = 0; i < enum_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, enum_.getRaw(i));
    }
    for (int i = 0; i < anyOf_.size(); i++) {
      output.writeMessage(11, anyOf_.get(i));
    }
    if (minProperties_ != 0L) {
      output.writeInt64(14, minProperties_);
    }
    if (maxProperties_ != 0L) {
      output.writeInt64(15, maxProperties_);
    }
    if (java.lang.Double.doubleToRawLongBits(minimum_) != 0) {
      output.writeDouble(16, minimum_);
    }
    if (java.lang.Double.doubleToRawLongBits(maximum_) != 0) {
      output.writeDouble(17, maximum_);
    }
    if (minLength_ != 0L) {
      output.writeInt64(18, minLength_);
    }
    if (maxLength_ != 0L) {
      output.writeInt64(19, maxLength_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pattern_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 20, pattern_);
    }
    if (minItems_ != 0L) {
      output.writeInt64(21, minItems_);
    }
    if (maxItems_ != 0L) {
      output.writeInt64(22, maxItems_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(23, getDefault());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 24, title_);
    }
    for (int i = 0; i < propertyOrdering_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, propertyOrdering_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_ != com.google.cloud.vertexai.api.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getItems());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.vertexai.api.Schema> entry :
        internalGetProperties().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.vertexai.api.Schema>
          properties__ =
              PropertiesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, properties__);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getExample());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < required_.size(); i++) {
        dataSize += computeStringSizeNoTag(required_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getRequiredList().size();
    }
    if (nullable_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, nullable_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(format_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, format_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, description_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < enum_.size(); i++) {
        dataSize += computeStringSizeNoTag(enum_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getEnumList().size();
    }
    for (int i = 0; i < anyOf_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, anyOf_.get(i));
    }
    if (minProperties_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(14, minProperties_);
    }
    if (maxProperties_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(15, maxProperties_);
    }
    if (java.lang.Double.doubleToRawLongBits(minimum_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(16, minimum_);
    }
    if (java.lang.Double.doubleToRawLongBits(maximum_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(17, maximum_);
    }
    if (minLength_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(18, minLength_);
    }
    if (maxLength_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(19, maxLength_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pattern_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, pattern_);
    }
    if (minItems_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(21, minItems_);
    }
    if (maxItems_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(22, maxItems_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getDefault());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(24, title_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < propertyOrdering_.size(); i++) {
        dataSize += computeStringSizeNoTag(propertyOrdering_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getPropertyOrderingList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vertexai.api.Schema)) {
      return super.equals(obj);
    }
    com.google.cloud.vertexai.api.Schema other = (com.google.cloud.vertexai.api.Schema) obj;

    if (type_ != other.type_) return false;
    if (!getFormat().equals(other.getFormat())) return false;
    if (!getTitle().equals(other.getTitle())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (getNullable() != other.getNullable()) return false;
    if (hasDefault() != other.hasDefault()) return false;
    if (hasDefault()) {
      if (!getDefault().equals(other.getDefault())) return false;
    }
    if (hasItems() != other.hasItems()) return false;
    if (hasItems()) {
      if (!getItems().equals(other.getItems())) return false;
    }
    if (getMinItems() != other.getMinItems()) return false;
    if (getMaxItems() != other.getMaxItems()) return false;
    if (!getEnumList().equals(other.getEnumList())) return false;
    if (!internalGetProperties().equals(other.internalGetProperties())) return false;
    if (!getPropertyOrderingList().equals(other.getPropertyOrderingList())) return false;
    if (!getRequiredList().equals(other.getRequiredList())) return false;
    if (getMinProperties() != other.getMinProperties()) return false;
    if (getMaxProperties() != other.getMaxProperties()) return false;
    if (java.lang.Double.doubleToLongBits(getMinimum())
        != java.lang.Double.doubleToLongBits(other.getMinimum())) return false;
    if (java.lang.Double.doubleToLongBits(getMaximum())
        != java.lang.Double.doubleToLongBits(other.getMaximum())) return false;
    if (getMinLength() != other.getMinLength()) return false;
    if (getMaxLength() != other.getMaxLength()) return false;
    if (!getPattern().equals(other.getPattern())) return false;
    if (hasExample() != other.hasExample()) return false;
    if (hasExample()) {
      if (!getExample().equals(other.getExample())) return false;
    }
    if (!getAnyOfList().equals(other.getAnyOfList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + getFormat().hashCode();
    hash = (37 * hash) + TITLE_FIELD_NUMBER;
    hash = (53 * hash) + getTitle().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + NULLABLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getNullable());
    if (hasDefault()) {
      hash = (37 * hash) + DEFAULT_FIELD_NUMBER;
      hash = (53 * hash) + getDefault().hashCode();
    }
    if (hasItems()) {
      hash = (37 * hash) + ITEMS_FIELD_NUMBER;
      hash = (53 * hash) + getItems().hashCode();
    }
    hash = (37 * hash) + MIN_ITEMS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMinItems());
    hash = (37 * hash) + MAX_ITEMS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxItems());
    if (getEnumCount() > 0) {
      hash = (37 * hash) + ENUM_FIELD_NUMBER;
      hash = (53 * hash) + getEnumList().hashCode();
    }
    if (!internalGetProperties().getMap().isEmpty()) {
      hash = (37 * hash) + PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetProperties().hashCode();
    }
    if (getPropertyOrderingCount() > 0) {
      hash = (37 * hash) + PROPERTY_ORDERING_FIELD_NUMBER;
      hash = (53 * hash) + getPropertyOrderingList().hashCode();
    }
    if (getRequiredCount() > 0) {
      hash = (37 * hash) + REQUIRED_FIELD_NUMBER;
      hash = (53 * hash) + getRequiredList().hashCode();
    }
    hash = (37 * hash) + MIN_PROPERTIES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMinProperties());
    hash = (37 * hash) + MAX_PROPERTIES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxProperties());
    hash = (37 * hash) + MINIMUM_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getMinimum()));
    hash = (37 * hash) + MAXIMUM_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getMaximum()));
    hash = (37 * hash) + MIN_LENGTH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMinLength());
    hash = (37 * hash) + MAX_LENGTH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxLength());
    hash = (37 * hash) + PATTERN_FIELD_NUMBER;
    hash = (53 * hash) + getPattern().hashCode();
    if (hasExample()) {
      hash = (37 * hash) + EXAMPLE_FIELD_NUMBER;
      hash = (53 * hash) + getExample().hashCode();
    }
    if (getAnyOfCount() > 0) {
      hash = (37 * hash) + ANY_OF_FIELD_NUMBER;
      hash = (53 * hash) + getAnyOfList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vertexai.api.Schema parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.Schema parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.Schema parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.Schema parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.Schema parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.Schema parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.Schema parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.Schema parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.Schema parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.Schema parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.Schema parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.Schema parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vertexai.api.Schema prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Schema is used to define the format of input/output data. Represents a select
   * subset of an [OpenAPI 3.0 schema
   * object](https://spec.openapis.org/oas/v3.0.3#schema-object). More fields may
   * be added in the future as needed.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vertexai.v1.Schema}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.Schema)
      com.google.cloud.vertexai.api.SchemaOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vertexai.api.OpenApiProto
          .internal_static_google_cloud_vertexai_v1_Schema_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vertexai.api.OpenApiProto
          .internal_static_google_cloud_vertexai_v1_Schema_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vertexai.api.Schema.class,
              com.google.cloud.vertexai.api.Schema.Builder.class);
    }

    // Construct using com.google.cloud.vertexai.api.Schema.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDefaultFieldBuilder();
        getItemsFieldBuilder();
        getExampleFieldBuilder();
        getAnyOfFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = 0;
      format_ = "";
      title_ = "";
      description_ = "";
      nullable_ = false;
      default_ = null;
      if (defaultBuilder_ != null) {
        defaultBuilder_.dispose();
        defaultBuilder_ = null;
      }
      items_ = null;
      if (itemsBuilder_ != null) {
        itemsBuilder_.dispose();
        itemsBuilder_ = null;
      }
      minItems_ = 0L;
      maxItems_ = 0L;
      enum_ = com.google.protobuf.LazyStringArrayList.emptyList();
      internalGetMutableProperties().clear();
      propertyOrdering_ = com.google.protobuf.LazyStringArrayList.emptyList();
      required_ = com.google.protobuf.LazyStringArrayList.emptyList();
      minProperties_ = 0L;
      maxProperties_ = 0L;
      minimum_ = 0D;
      maximum_ = 0D;
      minLength_ = 0L;
      maxLength_ = 0L;
      pattern_ = "";
      example_ = null;
      if (exampleBuilder_ != null) {
        exampleBuilder_.dispose();
        exampleBuilder_ = null;
      }
      if (anyOfBuilder_ == null) {
        anyOf_ = java.util.Collections.emptyList();
      } else {
        anyOf_ = null;
        anyOfBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00200000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vertexai.api.OpenApiProto
          .internal_static_google_cloud_vertexai_v1_Schema_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.Schema getDefaultInstanceForType() {
      return com.google.cloud.vertexai.api.Schema.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.Schema build() {
      com.google.cloud.vertexai.api.Schema result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.Schema buildPartial() {
      com.google.cloud.vertexai.api.Schema result = new com.google.cloud.vertexai.api.Schema(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.vertexai.api.Schema result) {
      if (anyOfBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)) {
          anyOf_ = java.util.Collections.unmodifiableList(anyOf_);
          bitField0_ = (bitField0_ & ~0x00200000);
        }
        result.anyOf_ = anyOf_;
      } else {
        result.anyOf_ = anyOfBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.vertexai.api.Schema result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.format_ = format_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.title_ = title_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.nullable_ = nullable_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.default_ = defaultBuilder_ == null ? default_ : defaultBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.items_ = itemsBuilder_ == null ? items_ : itemsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.minItems_ = minItems_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.maxItems_ = maxItems_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        enum_.makeImmutable();
        result.enum_ = enum_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.properties_ =
            internalGetProperties().build(PropertiesDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        propertyOrdering_.makeImmutable();
        result.propertyOrdering_ = propertyOrdering_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        required_.makeImmutable();
        result.required_ = required_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.minProperties_ = minProperties_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.maxProperties_ = maxProperties_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.minimum_ = minimum_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.maximum_ = maximum_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.minLength_ = minLength_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.maxLength_ = maxLength_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.pattern_ = pattern_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.example_ = exampleBuilder_ == null ? example_ : exampleBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vertexai.api.Schema) {
        return mergeFrom((com.google.cloud.vertexai.api.Schema) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vertexai.api.Schema other) {
      if (other == com.google.cloud.vertexai.api.Schema.getDefaultInstance()) return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (!other.getFormat().isEmpty()) {
        format_ = other.format_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getTitle().isEmpty()) {
        title_ = other.title_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getNullable() != false) {
        setNullable(other.getNullable());
      }
      if (other.hasDefault()) {
        mergeDefault(other.getDefault());
      }
      if (other.hasItems()) {
        mergeItems(other.getItems());
      }
      if (other.getMinItems() != 0L) {
        setMinItems(other.getMinItems());
      }
      if (other.getMaxItems() != 0L) {
        setMaxItems(other.getMaxItems());
      }
      if (!other.enum_.isEmpty()) {
        if (enum_.isEmpty()) {
          enum_ = other.enum_;
          bitField0_ |= 0x00000200;
        } else {
          ensureEnumIsMutable();
          enum_.addAll(other.enum_);
        }
        onChanged();
      }
      internalGetMutableProperties().mergeFrom(other.internalGetProperties());
      bitField0_ |= 0x00000400;
      if (!other.propertyOrdering_.isEmpty()) {
        if (propertyOrdering_.isEmpty()) {
          propertyOrdering_ = other.propertyOrdering_;
          bitField0_ |= 0x00000800;
        } else {
          ensurePropertyOrderingIsMutable();
          propertyOrdering_.addAll(other.propertyOrdering_);
        }
        onChanged();
      }
      if (!other.required_.isEmpty()) {
        if (required_.isEmpty()) {
          required_ = other.required_;
          bitField0_ |= 0x00001000;
        } else {
          ensureRequiredIsMutable();
          required_.addAll(other.required_);
        }
        onChanged();
      }
      if (other.getMinProperties() != 0L) {
        setMinProperties(other.getMinProperties());
      }
      if (other.getMaxProperties() != 0L) {
        setMaxProperties(other.getMaxProperties());
      }
      if (other.getMinimum() != 0D) {
        setMinimum(other.getMinimum());
      }
      if (other.getMaximum() != 0D) {
        setMaximum(other.getMaximum());
      }
      if (other.getMinLength() != 0L) {
        setMinLength(other.getMinLength());
      }
      if (other.getMaxLength() != 0L) {
        setMaxLength(other.getMaxLength());
      }
      if (!other.getPattern().isEmpty()) {
        pattern_ = other.pattern_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      if (other.hasExample()) {
        mergeExample(other.getExample());
      }
      if (anyOfBuilder_ == null) {
        if (!other.anyOf_.isEmpty()) {
          if (anyOf_.isEmpty()) {
            anyOf_ = other.anyOf_;
            bitField0_ = (bitField0_ & ~0x00200000);
          } else {
            ensureAnyOfIsMutable();
            anyOf_.addAll(other.anyOf_);
          }
          onChanged();
        }
      } else {
        if (!other.anyOf_.isEmpty()) {
          if (anyOfBuilder_.isEmpty()) {
            anyOfBuilder_.dispose();
            anyOfBuilder_ = null;
            anyOf_ = other.anyOf_;
            bitField0_ = (bitField0_ & ~0x00200000);
            anyOfBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAnyOfFieldBuilder()
                    : null;
          } else {
            anyOfBuilder_.addAllMessages(other.anyOf_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(getItemsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.vertexai.api.Schema>
                    properties__ =
                        input.readMessage(
                            PropertiesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableProperties()
                    .ensureBuilderMap()
                    .put(properties__.getKey(), properties__.getValue());
                bitField0_ |= 0x00000400;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getExampleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRequiredIsMutable();
                required_.add(s);
                break;
              } // case 42
            case 48:
              {
                nullable_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 58:
              {
                format_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 58
            case 66:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 66
            case 74:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureEnumIsMutable();
                enum_.add(s);
                break;
              } // case 74
            case 90:
              {
                com.google.cloud.vertexai.api.Schema m =
                    input.readMessage(
                        com.google.cloud.vertexai.api.Schema.parser(), extensionRegistry);
                if (anyOfBuilder_ == null) {
                  ensureAnyOfIsMutable();
                  anyOf_.add(m);
                } else {
                  anyOfBuilder_.addMessage(m);
                }
                break;
              } // case 90
            case 112:
              {
                minProperties_ = input.readInt64();
                bitField0_ |= 0x00002000;
                break;
              } // case 112
            case 120:
              {
                maxProperties_ = input.readInt64();
                bitField0_ |= 0x00004000;
                break;
              } // case 120
            case 129:
              {
                minimum_ = input.readDouble();
                bitField0_ |= 0x00008000;
                break;
              } // case 129
            case 137:
              {
                maximum_ = input.readDouble();
                bitField0_ |= 0x00010000;
                break;
              } // case 137
            case 144:
              {
                minLength_ = input.readInt64();
                bitField0_ |= 0x00020000;
                break;
              } // case 144
            case 152:
              {
                maxLength_ = input.readInt64();
                bitField0_ |= 0x00040000;
                break;
              } // case 152
            case 162:
              {
                pattern_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case 162
            case 168:
              {
                minItems_ = input.readInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 168
            case 176:
              {
                maxItems_ = input.readInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 176
            case 186:
              {
                input.readMessage(getDefaultFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 186
            case 194:
              {
                title_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 194
            case 202:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePropertyOrderingIsMutable();
                propertyOrdering_.add(s);
                break;
              } // case 202
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The type of the data.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Type type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of the data.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Type type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of the data.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Type type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.Type getType() {
      com.google.cloud.vertexai.api.Type result =
          com.google.cloud.vertexai.api.Type.forNumber(type_);
      return result == null ? com.google.cloud.vertexai.api.Type.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of the data.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Type type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.vertexai.api.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of the data.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Type type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      type_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object format_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The format of the data.
     * Supported formats:
     *  for NUMBER type: "float", "double"
     *  for INTEGER type: "int32", "int64"
     *  for STRING type: "email", "byte", etc
     * </pre>
     *
     * <code>string format = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The format.
     */
    public java.lang.String getFormat() {
      java.lang.Object ref = format_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        format_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The format of the data.
     * Supported formats:
     *  for NUMBER type: "float", "double"
     *  for INTEGER type: "int32", "int64"
     *  for STRING type: "email", "byte", etc
     * </pre>
     *
     * <code>string format = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for format.
     */
    public com.google.protobuf.ByteString getFormatBytes() {
      java.lang.Object ref = format_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        format_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The format of the data.
     * Supported formats:
     *  for NUMBER type: "float", "double"
     *  for INTEGER type: "int32", "int64"
     *  for STRING type: "email", "byte", etc
     * </pre>
     *
     * <code>string format = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The format to set.
     * @return This builder for chaining.
     */
    public Builder setFormat(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      format_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The format of the data.
     * Supported formats:
     *  for NUMBER type: "float", "double"
     *  for INTEGER type: "int32", "int64"
     *  for STRING type: "email", "byte", etc
     * </pre>
     *
     * <code>string format = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFormat() {
      format_ = getDefaultInstance().getFormat();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The format of the data.
     * Supported formats:
     *  for NUMBER type: "float", "double"
     *  for INTEGER type: "int32", "int64"
     *  for STRING type: "email", "byte", etc
     * </pre>
     *
     * <code>string format = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for format to set.
     * @return This builder for chaining.
     */
    public Builder setFormatBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      format_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object title_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The title of the Schema.
     * </pre>
     *
     * <code>string title = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The title.
     */
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The title of the Schema.
     * </pre>
     *
     * <code>string title = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for title.
     */
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The title of the Schema.
     * </pre>
     *
     * <code>string title = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The title to set.
     * @return This builder for chaining.
     */
    public Builder setTitle(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      title_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The title of the Schema.
     * </pre>
     *
     * <code>string title = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTitle() {
      title_ = getDefaultInstance().getTitle();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The title of the Schema.
     * </pre>
     *
     * <code>string title = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for title to set.
     * @return This builder for chaining.
     */
    public Builder setTitleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      title_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The description of the data.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the data.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the data.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the data.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of the data.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean nullable_;
    /**
     *
     *
     * <pre>
     * Optional. Indicates if the value may be null.
     * </pre>
     *
     * <code>bool nullable = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The nullable.
     */
    @java.lang.Override
    public boolean getNullable() {
      return nullable_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates if the value may be null.
     * </pre>
     *
     * <code>bool nullable = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The nullable to set.
     * @return This builder for chaining.
     */
    public Builder setNullable(boolean value) {

      nullable_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates if the value may be null.
     * </pre>
     *
     * <code>bool nullable = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNullable() {
      bitField0_ = (bitField0_ & ~0x00000010);
      nullable_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Value default_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        defaultBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Default value of the data.
     * </pre>
     *
     * <code>.google.protobuf.Value default = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the default field is set.
     */
    public boolean hasDefault() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Default value of the data.
     * </pre>
     *
     * <code>.google.protobuf.Value default = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The default.
     */
    public com.google.protobuf.Value getDefault() {
      if (defaultBuilder_ == null) {
        return default_ == null ? com.google.protobuf.Value.getDefaultInstance() : default_;
      } else {
        return defaultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Default value of the data.
     * </pre>
     *
     * <code>.google.protobuf.Value default = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setDefault(com.google.protobuf.Value value) {
      if (defaultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        default_ = value;
      } else {
        defaultBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default value of the data.
     * </pre>
     *
     * <code>.google.protobuf.Value default = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setDefault(com.google.protobuf.Value.Builder builderForValue) {
      if (defaultBuilder_ == null) {
        default_ = builderForValue.build();
      } else {
        defaultBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default value of the data.
     * </pre>
     *
     * <code>.google.protobuf.Value default = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder mergeDefault(com.google.protobuf.Value value) {
      if (defaultBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && default_ != null
            && default_ != com.google.protobuf.Value.getDefaultInstance()) {
          getDefaultBuilder().mergeFrom(value);
        } else {
          default_ = value;
        }
      } else {
        defaultBuilder_.mergeFrom(value);
      }
      if (default_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default value of the data.
     * </pre>
     *
     * <code>.google.protobuf.Value default = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder clearDefault() {
      bitField0_ = (bitField0_ & ~0x00000020);
      default_ = null;
      if (defaultBuilder_ != null) {
        defaultBuilder_.dispose();
        defaultBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default value of the data.
     * </pre>
     *
     * <code>.google.protobuf.Value default = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.protobuf.Value.Builder getDefaultBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getDefaultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Default value of the data.
     * </pre>
     *
     * <code>.google.protobuf.Value default = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.protobuf.ValueOrBuilder getDefaultOrBuilder() {
      if (defaultBuilder_ != null) {
        return defaultBuilder_.getMessageOrBuilder();
      } else {
        return default_ == null ? com.google.protobuf.Value.getDefaultInstance() : default_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Default value of the data.
     * </pre>
     *
     * <code>.google.protobuf.Value default = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getDefaultFieldBuilder() {
      if (defaultBuilder_ == null) {
        defaultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getDefault(), getParentForChildren(), isClean());
        default_ = null;
      }
      return defaultBuilder_;
    }

    private com.google.cloud.vertexai.api.Schema items_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.Schema,
            com.google.cloud.vertexai.api.Schema.Builder,
            com.google.cloud.vertexai.api.SchemaOrBuilder>
        itemsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE ARRAY
     * Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the items field is set.
     */
    public boolean hasItems() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE ARRAY
     * Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The items.
     */
    public com.google.cloud.vertexai.api.Schema getItems() {
      if (itemsBuilder_ == null) {
        return items_ == null ? com.google.cloud.vertexai.api.Schema.getDefaultInstance() : items_;
      } else {
        return itemsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE ARRAY
     * Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setItems(com.google.cloud.vertexai.api.Schema value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        items_ = value;
      } else {
        itemsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE ARRAY
     * Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setItems(com.google.cloud.vertexai.api.Schema.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        items_ = builderForValue.build();
      } else {
        itemsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE ARRAY
     * Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeItems(com.google.cloud.vertexai.api.Schema value) {
      if (itemsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && items_ != null
            && items_ != com.google.cloud.vertexai.api.Schema.getDefaultInstance()) {
          getItemsBuilder().mergeFrom(value);
        } else {
          items_ = value;
        }
      } else {
        itemsBuilder_.mergeFrom(value);
      }
      if (items_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE ARRAY
     * Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearItems() {
      bitField0_ = (bitField0_ & ~0x00000040);
      items_ = null;
      if (itemsBuilder_ != null) {
        itemsBuilder_.dispose();
        itemsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE ARRAY
     * Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.Schema.Builder getItemsBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getItemsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE ARRAY
     * Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.SchemaOrBuilder getItemsOrBuilder() {
      if (itemsBuilder_ != null) {
        return itemsBuilder_.getMessageOrBuilder();
      } else {
        return items_ == null ? com.google.cloud.vertexai.api.Schema.getDefaultInstance() : items_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE ARRAY
     * Schema of the elements of Type.ARRAY.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Schema items = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.Schema,
            com.google.cloud.vertexai.api.Schema.Builder,
            com.google.cloud.vertexai.api.SchemaOrBuilder>
        getItemsFieldBuilder() {
      if (itemsBuilder_ == null) {
        itemsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vertexai.api.Schema,
                com.google.cloud.vertexai.api.Schema.Builder,
                com.google.cloud.vertexai.api.SchemaOrBuilder>(
                getItems(), getParentForChildren(), isClean());
        items_ = null;
      }
      return itemsBuilder_;
    }

    private long minItems_;
    /**
     *
     *
     * <pre>
     * Optional. Minimum number of the elements for Type.ARRAY.
     * </pre>
     *
     * <code>int64 min_items = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minItems.
     */
    @java.lang.Override
    public long getMinItems() {
      return minItems_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Minimum number of the elements for Type.ARRAY.
     * </pre>
     *
     * <code>int64 min_items = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The minItems to set.
     * @return This builder for chaining.
     */
    public Builder setMinItems(long value) {

      minItems_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Minimum number of the elements for Type.ARRAY.
     * </pre>
     *
     * <code>int64 min_items = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinItems() {
      bitField0_ = (bitField0_ & ~0x00000080);
      minItems_ = 0L;
      onChanged();
      return this;
    }

    private long maxItems_;
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of the elements for Type.ARRAY.
     * </pre>
     *
     * <code>int64 max_items = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxItems.
     */
    @java.lang.Override
    public long getMaxItems() {
      return maxItems_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of the elements for Type.ARRAY.
     * </pre>
     *
     * <code>int64 max_items = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The maxItems to set.
     * @return This builder for chaining.
     */
    public Builder setMaxItems(long value) {

      maxItems_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of the elements for Type.ARRAY.
     * </pre>
     *
     * <code>int64 max_items = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxItems() {
      bitField0_ = (bitField0_ & ~0x00000100);
      maxItems_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList enum_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureEnumIsMutable() {
      if (!enum_.isModifiable()) {
        enum_ = new com.google.protobuf.LazyStringArrayList(enum_);
      }
      bitField0_ |= 0x00000200;
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of primitive type with enum
     * format. Examples:
     * 1. We can define direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * 2. We can define apartment number as :
     * {type:INTEGER, format:enum, enum:["101", "201", "301"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the enum.
     */
    public com.google.protobuf.ProtocolStringList getEnumList() {
      enum_.makeImmutable();
      return enum_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of primitive type with enum
     * format. Examples:
     * 1. We can define direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * 2. We can define apartment number as :
     * {type:INTEGER, format:enum, enum:["101", "201", "301"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of enum.
     */
    public int getEnumCount() {
      return enum_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of primitive type with enum
     * format. Examples:
     * 1. We can define direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * 2. We can define apartment number as :
     * {type:INTEGER, format:enum, enum:["101", "201", "301"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The enum at the given index.
     */
    public java.lang.String getEnum(int index) {
      return enum_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of primitive type with enum
     * format. Examples:
     * 1. We can define direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * 2. We can define apartment number as :
     * {type:INTEGER, format:enum, enum:["101", "201", "301"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the enum at the given index.
     */
    public com.google.protobuf.ByteString getEnumBytes(int index) {
      return enum_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of primitive type with enum
     * format. Examples:
     * 1. We can define direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * 2. We can define apartment number as :
     * {type:INTEGER, format:enum, enum:["101", "201", "301"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The enum to set.
     * @return This builder for chaining.
     */
    public Builder setEnum(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEnumIsMutable();
      enum_.set(index, value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of primitive type with enum
     * format. Examples:
     * 1. We can define direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * 2. We can define apartment number as :
     * {type:INTEGER, format:enum, enum:["101", "201", "301"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enum to add.
     * @return This builder for chaining.
     */
    public Builder addEnum(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEnumIsMutable();
      enum_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of primitive type with enum
     * format. Examples:
     * 1. We can define direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * 2. We can define apartment number as :
     * {type:INTEGER, format:enum, enum:["101", "201", "301"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The enum to add.
     * @return This builder for chaining.
     */
    public Builder addAllEnum(java.lang.Iterable<java.lang.String> values) {
      ensureEnumIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, enum_);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of primitive type with enum
     * format. Examples:
     * 1. We can define direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * 2. We can define apartment number as :
     * {type:INTEGER, format:enum, enum:["101", "201", "301"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnum() {
      enum_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000200);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Possible values of the element of primitive type with enum
     * format. Examples:
     * 1. We can define direction as :
     * {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
     * 2. We can define apartment number as :
     * {type:INTEGER, format:enum, enum:["101", "201", "301"]}
     * </pre>
     *
     * <code>repeated string enum = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the enum to add.
     * @return This builder for chaining.
     */
    public Builder addEnumBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureEnumIsMutable();
      enum_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private static final class PropertiesConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.vertexai.api.SchemaOrBuilder,
            com.google.cloud.vertexai.api.Schema> {
      @java.lang.Override
      public com.google.cloud.vertexai.api.Schema build(
          com.google.cloud.vertexai.api.SchemaOrBuilder val) {
        if (val instanceof com.google.cloud.vertexai.api.Schema) {
          return (com.google.cloud.vertexai.api.Schema) val;
        }
        return ((com.google.cloud.vertexai.api.Schema.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.vertexai.api.Schema>
          defaultEntry() {
        return PropertiesDefaultEntryHolder.defaultEntry;
      }
    };

    private static final PropertiesConverter propertiesConverter = new PropertiesConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.vertexai.api.SchemaOrBuilder,
            com.google.cloud.vertexai.api.Schema,
            com.google.cloud.vertexai.api.Schema.Builder>
        properties_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.vertexai.api.SchemaOrBuilder,
            com.google.cloud.vertexai.api.Schema,
            com.google.cloud.vertexai.api.Schema.Builder>
        internalGetProperties() {
      if (properties_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(propertiesConverter);
      }
      return properties_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.vertexai.api.SchemaOrBuilder,
            com.google.cloud.vertexai.api.Schema,
            com.google.cloud.vertexai.api.Schema.Builder>
        internalGetMutableProperties() {
      if (properties_ == null) {
        properties_ = new com.google.protobuf.MapFieldBuilder<>(propertiesConverter);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return properties_;
    }

    public int getPropertiesCount() {
      return internalGetProperties().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE OBJECT
     * Properties of Type.OBJECT.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.vertexai.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetProperties().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getPropertiesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.vertexai.api.Schema> getProperties() {
      return getPropertiesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE OBJECT
     * Properties of Type.OBJECT.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.vertexai.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.vertexai.api.Schema>
        getPropertiesMap() {
      return internalGetProperties().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE OBJECT
     * Properties of Type.OBJECT.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.vertexai.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.vertexai.api.Schema getPropertiesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.vertexai.api.Schema defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.vertexai.api.SchemaOrBuilder> map =
          internalGetMutableProperties().ensureBuilderMap();
      return map.containsKey(key) ? propertiesConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE OBJECT
     * Properties of Type.OBJECT.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.vertexai.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.Schema getPropertiesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.vertexai.api.SchemaOrBuilder> map =
          internalGetMutableProperties().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return propertiesConverter.build(map.get(key));
    }

    public Builder clearProperties() {
      bitField0_ = (bitField0_ & ~0x00000400);
      internalGetMutableProperties().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE OBJECT
     * Properties of Type.OBJECT.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.vertexai.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableProperties().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.vertexai.api.Schema>
        getMutableProperties() {
      bitField0_ |= 0x00000400;
      return internalGetMutableProperties().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE OBJECT
     * Properties of Type.OBJECT.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.vertexai.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putProperties(java.lang.String key, com.google.cloud.vertexai.api.Schema value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableProperties().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000400;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE OBJECT
     * Properties of Type.OBJECT.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.vertexai.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllProperties(
        java.util.Map<java.lang.String, com.google.cloud.vertexai.api.Schema> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.vertexai.api.Schema> e :
          values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableProperties().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000400;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE OBJECT
     * Properties of Type.OBJECT.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.vertexai.v1.Schema&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.Schema.Builder putPropertiesBuilderIfAbsent(
        java.lang.String key) {
      java.util.Map<java.lang.String, com.google.cloud.vertexai.api.SchemaOrBuilder> builderMap =
          internalGetMutableProperties().ensureBuilderMap();
      com.google.cloud.vertexai.api.SchemaOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.vertexai.api.Schema.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.vertexai.api.Schema) {
        entry = ((com.google.cloud.vertexai.api.Schema) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.vertexai.api.Schema.Builder) entry;
    }

    private com.google.protobuf.LazyStringArrayList propertyOrdering_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePropertyOrderingIsMutable() {
      if (!propertyOrdering_.isModifiable()) {
        propertyOrdering_ = new com.google.protobuf.LazyStringArrayList(propertyOrdering_);
      }
      bitField0_ |= 0x00000800;
    }
    /**
     *
     *
     * <pre>
     * Optional. The order of the properties.
     * Not a standard field in open api spec. Only used to support the order of
     * the properties.
     * </pre>
     *
     * <code>repeated string property_ordering = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the propertyOrdering.
     */
    public com.google.protobuf.ProtocolStringList getPropertyOrderingList() {
      propertyOrdering_.makeImmutable();
      return propertyOrdering_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The order of the properties.
     * Not a standard field in open api spec. Only used to support the order of
     * the properties.
     * </pre>
     *
     * <code>repeated string property_ordering = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of propertyOrdering.
     */
    public int getPropertyOrderingCount() {
      return propertyOrdering_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The order of the properties.
     * Not a standard field in open api spec. Only used to support the order of
     * the properties.
     * </pre>
     *
     * <code>repeated string property_ordering = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The propertyOrdering at the given index.
     */
    public java.lang.String getPropertyOrdering(int index) {
      return propertyOrdering_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The order of the properties.
     * Not a standard field in open api spec. Only used to support the order of
     * the properties.
     * </pre>
     *
     * <code>repeated string property_ordering = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the propertyOrdering at the given index.
     */
    public com.google.protobuf.ByteString getPropertyOrderingBytes(int index) {
      return propertyOrdering_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The order of the properties.
     * Not a standard field in open api spec. Only used to support the order of
     * the properties.
     * </pre>
     *
     * <code>repeated string property_ordering = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The propertyOrdering to set.
     * @return This builder for chaining.
     */
    public Builder setPropertyOrdering(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePropertyOrderingIsMutable();
      propertyOrdering_.set(index, value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The order of the properties.
     * Not a standard field in open api spec. Only used to support the order of
     * the properties.
     * </pre>
     *
     * <code>repeated string property_ordering = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The propertyOrdering to add.
     * @return This builder for chaining.
     */
    public Builder addPropertyOrdering(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePropertyOrderingIsMutable();
      propertyOrdering_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The order of the properties.
     * Not a standard field in open api spec. Only used to support the order of
     * the properties.
     * </pre>
     *
     * <code>repeated string property_ordering = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The propertyOrdering to add.
     * @return This builder for chaining.
     */
    public Builder addAllPropertyOrdering(java.lang.Iterable<java.lang.String> values) {
      ensurePropertyOrderingIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, propertyOrdering_);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The order of the properties.
     * Not a standard field in open api spec. Only used to support the order of
     * the properties.
     * </pre>
     *
     * <code>repeated string property_ordering = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPropertyOrdering() {
      propertyOrdering_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000800);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The order of the properties.
     * Not a standard field in open api spec. Only used to support the order of
     * the properties.
     * </pre>
     *
     * <code>repeated string property_ordering = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the propertyOrdering to add.
     * @return This builder for chaining.
     */
    public Builder addPropertyOrderingBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePropertyOrderingIsMutable();
      propertyOrdering_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList required_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureRequiredIsMutable() {
      if (!required_.isModifiable()) {
        required_ = new com.google.protobuf.LazyStringArrayList(required_);
      }
      bitField0_ |= 0x00001000;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the required.
     */
    public com.google.protobuf.ProtocolStringList getRequiredList() {
      required_.makeImmutable();
      return required_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of required.
     */
    public int getRequiredCount() {
      return required_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The required at the given index.
     */
    public java.lang.String getRequired(int index) {
      return required_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the required at the given index.
     */
    public com.google.protobuf.ByteString getRequiredBytes(int index) {
      return required_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The required to set.
     * @return This builder for chaining.
     */
    public Builder setRequired(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequiredIsMutable();
      required_.set(index, value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The required to add.
     * @return This builder for chaining.
     */
    public Builder addRequired(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequiredIsMutable();
      required_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The required to add.
     * @return This builder for chaining.
     */
    public Builder addAllRequired(java.lang.Iterable<java.lang.String> values) {
      ensureRequiredIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, required_);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequired() {
      required_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00001000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required properties of Type.OBJECT.
     * </pre>
     *
     * <code>repeated string required = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the required to add.
     * @return This builder for chaining.
     */
    public Builder addRequiredBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRequiredIsMutable();
      required_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private long minProperties_;
    /**
     *
     *
     * <pre>
     * Optional. Minimum number of the properties for Type.OBJECT.
     * </pre>
     *
     * <code>int64 min_properties = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minProperties.
     */
    @java.lang.Override
    public long getMinProperties() {
      return minProperties_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Minimum number of the properties for Type.OBJECT.
     * </pre>
     *
     * <code>int64 min_properties = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The minProperties to set.
     * @return This builder for chaining.
     */
    public Builder setMinProperties(long value) {

      minProperties_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Minimum number of the properties for Type.OBJECT.
     * </pre>
     *
     * <code>int64 min_properties = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinProperties() {
      bitField0_ = (bitField0_ & ~0x00002000);
      minProperties_ = 0L;
      onChanged();
      return this;
    }

    private long maxProperties_;
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of the properties for Type.OBJECT.
     * </pre>
     *
     * <code>int64 max_properties = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxProperties.
     */
    @java.lang.Override
    public long getMaxProperties() {
      return maxProperties_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of the properties for Type.OBJECT.
     * </pre>
     *
     * <code>int64 max_properties = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The maxProperties to set.
     * @return This builder for chaining.
     */
    public Builder setMaxProperties(long value) {

      maxProperties_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of the properties for Type.OBJECT.
     * </pre>
     *
     * <code>int64 max_properties = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxProperties() {
      bitField0_ = (bitField0_ & ~0x00004000);
      maxProperties_ = 0L;
      onChanged();
      return this;
    }

    private double minimum_;
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE INTEGER and NUMBER
     * Minimum value of the Type.INTEGER and Type.NUMBER
     * </pre>
     *
     * <code>double minimum = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minimum.
     */
    @java.lang.Override
    public double getMinimum() {
      return minimum_;
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE INTEGER and NUMBER
     * Minimum value of the Type.INTEGER and Type.NUMBER
     * </pre>
     *
     * <code>double minimum = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The minimum to set.
     * @return This builder for chaining.
     */
    public Builder setMinimum(double value) {

      minimum_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE INTEGER and NUMBER
     * Minimum value of the Type.INTEGER and Type.NUMBER
     * </pre>
     *
     * <code>double minimum = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinimum() {
      bitField0_ = (bitField0_ & ~0x00008000);
      minimum_ = 0D;
      onChanged();
      return this;
    }

    private double maximum_;
    /**
     *
     *
     * <pre>
     * Optional. Maximum value of the Type.INTEGER and Type.NUMBER
     * </pre>
     *
     * <code>double maximum = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maximum.
     */
    @java.lang.Override
    public double getMaximum() {
      return maximum_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum value of the Type.INTEGER and Type.NUMBER
     * </pre>
     *
     * <code>double maximum = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The maximum to set.
     * @return This builder for chaining.
     */
    public Builder setMaximum(double value) {

      maximum_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum value of the Type.INTEGER and Type.NUMBER
     * </pre>
     *
     * <code>double maximum = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaximum() {
      bitField0_ = (bitField0_ & ~0x00010000);
      maximum_ = 0D;
      onChanged();
      return this;
    }

    private long minLength_;
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE STRING
     * Minimum length of the Type.STRING
     * </pre>
     *
     * <code>int64 min_length = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minLength.
     */
    @java.lang.Override
    public long getMinLength() {
      return minLength_;
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE STRING
     * Minimum length of the Type.STRING
     * </pre>
     *
     * <code>int64 min_length = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The minLength to set.
     * @return This builder for chaining.
     */
    public Builder setMinLength(long value) {

      minLength_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SCHEMA FIELDS FOR TYPE STRING
     * Minimum length of the Type.STRING
     * </pre>
     *
     * <code>int64 min_length = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinLength() {
      bitField0_ = (bitField0_ & ~0x00020000);
      minLength_ = 0L;
      onChanged();
      return this;
    }

    private long maxLength_;
    /**
     *
     *
     * <pre>
     * Optional. Maximum length of the Type.STRING
     * </pre>
     *
     * <code>int64 max_length = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxLength.
     */
    @java.lang.Override
    public long getMaxLength() {
      return maxLength_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum length of the Type.STRING
     * </pre>
     *
     * <code>int64 max_length = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The maxLength to set.
     * @return This builder for chaining.
     */
    public Builder setMaxLength(long value) {

      maxLength_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum length of the Type.STRING
     * </pre>
     *
     * <code>int64 max_length = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxLength() {
      bitField0_ = (bitField0_ & ~0x00040000);
      maxLength_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object pattern_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Pattern of the Type.STRING to restrict a string to a regular
     * expression.
     * </pre>
     *
     * <code>string pattern = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pattern.
     */
    public java.lang.String getPattern() {
      java.lang.Object ref = pattern_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pattern_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Pattern of the Type.STRING to restrict a string to a regular
     * expression.
     * </pre>
     *
     * <code>string pattern = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pattern.
     */
    public com.google.protobuf.ByteString getPatternBytes() {
      java.lang.Object ref = pattern_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pattern_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Pattern of the Type.STRING to restrict a string to a regular
     * expression.
     * </pre>
     *
     * <code>string pattern = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pattern to set.
     * @return This builder for chaining.
     */
    public Builder setPattern(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pattern_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Pattern of the Type.STRING to restrict a string to a regular
     * expression.
     * </pre>
     *
     * <code>string pattern = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPattern() {
      pattern_ = getDefaultInstance().getPattern();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Pattern of the Type.STRING to restrict a string to a regular
     * expression.
     * </pre>
     *
     * <code>string pattern = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for pattern to set.
     * @return This builder for chaining.
     */
    public Builder setPatternBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pattern_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    private com.google.protobuf.Value example_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        exampleBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the example field is set.
     */
    public boolean hasExample() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The example.
     */
    public com.google.protobuf.Value getExample() {
      if (exampleBuilder_ == null) {
        return example_ == null ? com.google.protobuf.Value.getDefaultInstance() : example_;
      } else {
        return exampleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setExample(com.google.protobuf.Value value) {
      if (exampleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        example_ = value;
      } else {
        exampleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setExample(com.google.protobuf.Value.Builder builderForValue) {
      if (exampleBuilder_ == null) {
        example_ = builderForValue.build();
      } else {
        exampleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder mergeExample(com.google.protobuf.Value value) {
      if (exampleBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && example_ != null
            && example_ != com.google.protobuf.Value.getDefaultInstance()) {
          getExampleBuilder().mergeFrom(value);
        } else {
          example_ = value;
        }
      } else {
        exampleBuilder_.mergeFrom(value);
      }
      if (example_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder clearExample() {
      bitField0_ = (bitField0_ & ~0x00100000);
      example_ = null;
      if (exampleBuilder_ != null) {
        exampleBuilder_.dispose();
        exampleBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.protobuf.Value.Builder getExampleBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getExampleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.protobuf.ValueOrBuilder getExampleOrBuilder() {
      if (exampleBuilder_ != null) {
        return exampleBuilder_.getMessageOrBuilder();
      } else {
        return example_ == null ? com.google.protobuf.Value.getDefaultInstance() : example_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Example of the object. Will only populated when the object is the
     * root.
     * </pre>
     *
     * <code>.google.protobuf.Value example = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getExampleFieldBuilder() {
      if (exampleBuilder_ == null) {
        exampleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getExample(), getParentForChildren(), isClean());
        example_ = null;
      }
      return exampleBuilder_;
    }

    private java.util.List<com.google.cloud.vertexai.api.Schema> anyOf_ =
        java.util.Collections.emptyList();

    private void ensureAnyOfIsMutable() {
      if (!((bitField0_ & 0x00200000) != 0)) {
        anyOf_ = new java.util.ArrayList<com.google.cloud.vertexai.api.Schema>(anyOf_);
        bitField0_ |= 0x00200000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.Schema,
            com.google.cloud.vertexai.api.Schema.Builder,
            com.google.cloud.vertexai.api.SchemaOrBuilder>
        anyOfBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.Schema> getAnyOfList() {
      if (anyOfBuilder_ == null) {
        return java.util.Collections.unmodifiableList(anyOf_);
      } else {
        return anyOfBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getAnyOfCount() {
      if (anyOfBuilder_ == null) {
        return anyOf_.size();
      } else {
        return anyOfBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.Schema getAnyOf(int index) {
      if (anyOfBuilder_ == null) {
        return anyOf_.get(index);
      } else {
        return anyOfBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAnyOf(int index, com.google.cloud.vertexai.api.Schema value) {
      if (anyOfBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnyOfIsMutable();
        anyOf_.set(index, value);
        onChanged();
      } else {
        anyOfBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAnyOf(
        int index, com.google.cloud.vertexai.api.Schema.Builder builderForValue) {
      if (anyOfBuilder_ == null) {
        ensureAnyOfIsMutable();
        anyOf_.set(index, builderForValue.build());
        onChanged();
      } else {
        anyOfBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAnyOf(com.google.cloud.vertexai.api.Schema value) {
      if (anyOfBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnyOfIsMutable();
        anyOf_.add(value);
        onChanged();
      } else {
        anyOfBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAnyOf(int index, com.google.cloud.vertexai.api.Schema value) {
      if (anyOfBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnyOfIsMutable();
        anyOf_.add(index, value);
        onChanged();
      } else {
        anyOfBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAnyOf(com.google.cloud.vertexai.api.Schema.Builder builderForValue) {
      if (anyOfBuilder_ == null) {
        ensureAnyOfIsMutable();
        anyOf_.add(builderForValue.build());
        onChanged();
      } else {
        anyOfBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAnyOf(
        int index, com.google.cloud.vertexai.api.Schema.Builder builderForValue) {
      if (anyOfBuilder_ == null) {
        ensureAnyOfIsMutable();
        anyOf_.add(index, builderForValue.build());
        onChanged();
      } else {
        anyOfBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllAnyOf(
        java.lang.Iterable<? extends com.google.cloud.vertexai.api.Schema> values) {
      if (anyOfBuilder_ == null) {
        ensureAnyOfIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, anyOf_);
        onChanged();
      } else {
        anyOfBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAnyOf() {
      if (anyOfBuilder_ == null) {
        anyOf_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00200000);
        onChanged();
      } else {
        anyOfBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAnyOf(int index) {
      if (anyOfBuilder_ == null) {
        ensureAnyOfIsMutable();
        anyOf_.remove(index);
        onChanged();
      } else {
        anyOfBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.Schema.Builder getAnyOfBuilder(int index) {
      return getAnyOfFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.SchemaOrBuilder getAnyOfOrBuilder(int index) {
      if (anyOfBuilder_ == null) {
        return anyOf_.get(index);
      } else {
        return anyOfBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.vertexai.api.SchemaOrBuilder>
        getAnyOfOrBuilderList() {
      if (anyOfBuilder_ != null) {
        return anyOfBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(anyOf_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.Schema.Builder addAnyOfBuilder() {
      return getAnyOfFieldBuilder()
          .addBuilder(com.google.cloud.vertexai.api.Schema.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.Schema.Builder addAnyOfBuilder(int index) {
      return getAnyOfFieldBuilder()
          .addBuilder(index, com.google.cloud.vertexai.api.Schema.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The value should be validated against any (one or more) of the
     * subschemas in the list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Schema any_of = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.Schema.Builder> getAnyOfBuilderList() {
      return getAnyOfFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.Schema,
            com.google.cloud.vertexai.api.Schema.Builder,
            com.google.cloud.vertexai.api.SchemaOrBuilder>
        getAnyOfFieldBuilder() {
      if (anyOfBuilder_ == null) {
        anyOfBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vertexai.api.Schema,
                com.google.cloud.vertexai.api.Schema.Builder,
                com.google.cloud.vertexai.api.SchemaOrBuilder>(
                anyOf_, ((bitField0_ & 0x00200000) != 0), getParentForChildren(), isClean());
        anyOf_ = null;
      }
      return anyOfBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.Schema)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.Schema)
  private static final com.google.cloud.vertexai.api.Schema DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vertexai.api.Schema();
  }

  public static com.google.cloud.vertexai.api.Schema getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Schema> PARSER =
      new com.google.protobuf.AbstractParser<Schema>() {
        @java.lang.Override
        public Schema parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Schema> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Schema> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vertexai.api.Schema getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
