/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vertexai/v1/io.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.vertexai.api;

/**
 *
 *
 * <pre>
 * The Slack source for the ImportRagFilesRequest.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vertexai.v1.SlackSource}
 */
public final class SlackSource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.SlackSource)
    SlackSourceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SlackSource.newBuilder() to construct.
  private SlackSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SlackSource() {
    channels_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SlackSource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vertexai.api.IoProto
        .internal_static_google_cloud_vertexai_v1_SlackSource_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vertexai.api.IoProto
        .internal_static_google_cloud_vertexai_v1_SlackSource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vertexai.api.SlackSource.class,
            com.google.cloud.vertexai.api.SlackSource.Builder.class);
  }

  public interface SlackChannelsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.vertexai.v1.SlackSource.SlackChannels)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The Slack channel IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel>
        getChannelsList();
    /**
     *
     *
     * <pre>
     * Required. The Slack channel IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel getChannels(int index);
    /**
     *
     *
     * <pre>
     * Required. The Slack channel IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getChannelsCount();
    /**
     *
     *
     * <pre>
     * Required. The Slack channel IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannelOrBuilder>
        getChannelsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. The Slack channel IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannelOrBuilder
        getChannelsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Required. The SecretManager secret version resource name (e.g.
     * projects/{project}/secrets/{secret}/versions/{version}) storing the
     * Slack channel access token that has access to the slack channel IDs.
     * See: https://api.slack.com/tutorials/tracks/getting-a-token.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ApiAuth.ApiKeyConfig api_key_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the apiKeyConfig field is set.
     */
    boolean hasApiKeyConfig();
    /**
     *
     *
     * <pre>
     * Required. The SecretManager secret version resource name (e.g.
     * projects/{project}/secrets/{secret}/versions/{version}) storing the
     * Slack channel access token that has access to the slack channel IDs.
     * See: https://api.slack.com/tutorials/tracks/getting-a-token.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ApiAuth.ApiKeyConfig api_key_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The apiKeyConfig.
     */
    com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig getApiKeyConfig();
    /**
     *
     *
     * <pre>
     * Required. The SecretManager secret version resource name (e.g.
     * projects/{project}/secrets/{secret}/versions/{version}) storing the
     * Slack channel access token that has access to the slack channel IDs.
     * See: https://api.slack.com/tutorials/tracks/getting-a-token.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ApiAuth.ApiKeyConfig api_key_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfigOrBuilder getApiKeyConfigOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * SlackChannels contains the Slack channels and corresponding access token.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vertexai.v1.SlackSource.SlackChannels}
   */
  public static final class SlackChannels extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.SlackSource.SlackChannels)
      SlackChannelsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SlackChannels.newBuilder() to construct.
    private SlackChannels(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SlackChannels() {
      channels_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SlackChannels();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vertexai.api.IoProto
          .internal_static_google_cloud_vertexai_v1_SlackSource_SlackChannels_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vertexai.api.IoProto
          .internal_static_google_cloud_vertexai_v1_SlackSource_SlackChannels_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vertexai.api.SlackSource.SlackChannels.class,
              com.google.cloud.vertexai.api.SlackSource.SlackChannels.Builder.class);
    }

    public interface SlackChannelOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The Slack channel ID.
       * </pre>
       *
       * <code>string channel_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The channelId.
       */
      java.lang.String getChannelId();
      /**
       *
       *
       * <pre>
       * Required. The Slack channel ID.
       * </pre>
       *
       * <code>string channel_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for channelId.
       */
      com.google.protobuf.ByteString getChannelIdBytes();

      /**
       *
       *
       * <pre>
       * Optional. The starting timestamp for messages to import.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the startTime field is set.
       */
      boolean hasStartTime();
      /**
       *
       *
       * <pre>
       * Optional. The starting timestamp for messages to import.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The startTime.
       */
      com.google.protobuf.Timestamp getStartTime();
      /**
       *
       *
       * <pre>
       * Optional. The starting timestamp for messages to import.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional. The ending timestamp for messages to import.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the endTime field is set.
       */
      boolean hasEndTime();
      /**
       *
       *
       * <pre>
       * Optional. The ending timestamp for messages to import.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The endTime.
       */
      com.google.protobuf.Timestamp getEndTime();
      /**
       *
       *
       * <pre>
       * Optional. The ending timestamp for messages to import.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * SlackChannel contains the Slack channel ID and the time range to import.
     * </pre>
     *
     * Protobuf type {@code google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel}
     */
    public static final class SlackChannel extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel)
        SlackChannelOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SlackChannel.newBuilder() to construct.
      private SlackChannel(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SlackChannel() {
        channelId_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SlackChannel();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.vertexai.api.IoProto
            .internal_static_google_cloud_vertexai_v1_SlackSource_SlackChannels_SlackChannel_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.vertexai.api.IoProto
            .internal_static_google_cloud_vertexai_v1_SlackSource_SlackChannels_SlackChannel_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel.class,
                com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel.Builder.class);
      }

      private int bitField0_;
      public static final int CHANNEL_ID_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object channelId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The Slack channel ID.
       * </pre>
       *
       * <code>string channel_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The channelId.
       */
      @java.lang.Override
      public java.lang.String getChannelId() {
        java.lang.Object ref = channelId_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          channelId_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel ID.
       * </pre>
       *
       * <code>string channel_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for channelId.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getChannelIdBytes() {
        java.lang.Object ref = channelId_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          channelId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int START_TIME_FIELD_NUMBER = 2;
      private com.google.protobuf.Timestamp startTime_;
      /**
       *
       *
       * <pre>
       * Optional. The starting timestamp for messages to import.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the startTime field is set.
       */
      @java.lang.Override
      public boolean hasStartTime() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The starting timestamp for messages to import.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The startTime.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getStartTime() {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The starting timestamp for messages to import.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }

      public static final int END_TIME_FIELD_NUMBER = 3;
      private com.google.protobuf.Timestamp endTime_;
      /**
       *
       *
       * <pre>
       * Optional. The ending timestamp for messages to import.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the endTime field is set.
       */
      @java.lang.Override
      public boolean hasEndTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The ending timestamp for messages to import.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The endTime.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getEndTime() {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The ending timestamp for messages to import.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(channelId_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, channelId_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getStartTime());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(3, getEndTime());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(channelId_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, channelId_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStartTime());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEndTime());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel)) {
          return super.equals(obj);
        }
        com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel other =
            (com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel) obj;

        if (!getChannelId().equals(other.getChannelId())) return false;
        if (hasStartTime() != other.hasStartTime()) return false;
        if (hasStartTime()) {
          if (!getStartTime().equals(other.getStartTime())) return false;
        }
        if (hasEndTime() != other.hasEndTime()) return false;
        if (hasEndTime()) {
          if (!getEndTime().equals(other.getEndTime())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + CHANNEL_ID_FIELD_NUMBER;
        hash = (53 * hash) + getChannelId().hashCode();
        if (hasStartTime()) {
          hash = (37 * hash) + START_TIME_FIELD_NUMBER;
          hash = (53 * hash) + getStartTime().hashCode();
        }
        if (hasEndTime()) {
          hash = (37 * hash) + END_TIME_FIELD_NUMBER;
          hash = (53 * hash) + getEndTime().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * SlackChannel contains the Slack channel ID and the time range to import.
       * </pre>
       *
       * Protobuf type {@code google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel)
          com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannelOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.vertexai.api.IoProto
              .internal_static_google_cloud_vertexai_v1_SlackSource_SlackChannels_SlackChannel_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.vertexai.api.IoProto
              .internal_static_google_cloud_vertexai_v1_SlackSource_SlackChannels_SlackChannel_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel.class,
                  com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getStartTimeFieldBuilder();
            getEndTimeFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          channelId_ = "";
          startTime_ = null;
          if (startTimeBuilder_ != null) {
            startTimeBuilder_.dispose();
            startTimeBuilder_ = null;
          }
          endTime_ = null;
          if (endTimeBuilder_ != null) {
            endTimeBuilder_.dispose();
            endTimeBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.vertexai.api.IoProto
              .internal_static_google_cloud_vertexai_v1_SlackSource_SlackChannels_SlackChannel_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel
            getDefaultInstanceForType() {
          return com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel build() {
          com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel buildPartial() {
          com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel result =
              new com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.channelId_ = channelId_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel) {
            return mergeFrom(
                (com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel other) {
          if (other
              == com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel
                  .getDefaultInstance()) return this;
          if (!other.getChannelId().isEmpty()) {
            channelId_ = other.channelId_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasStartTime()) {
            mergeStartTime(other.getStartTime());
          }
          if (other.hasEndTime()) {
            mergeEndTime(other.getEndTime());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    channelId_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object channelId_ = "";
        /**
         *
         *
         * <pre>
         * Required. The Slack channel ID.
         * </pre>
         *
         * <code>string channel_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The channelId.
         */
        public java.lang.String getChannelId() {
          java.lang.Object ref = channelId_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            channelId_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The Slack channel ID.
         * </pre>
         *
         * <code>string channel_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for channelId.
         */
        public com.google.protobuf.ByteString getChannelIdBytes() {
          java.lang.Object ref = channelId_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            channelId_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The Slack channel ID.
         * </pre>
         *
         * <code>string channel_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The channelId to set.
         * @return This builder for chaining.
         */
        public Builder setChannelId(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          channelId_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The Slack channel ID.
         * </pre>
         *
         * <code>string channel_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearChannelId() {
          channelId_ = getDefaultInstance().getChannelId();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The Slack channel ID.
         * </pre>
         *
         * <code>string channel_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for channelId to set.
         * @return This builder for chaining.
         */
        public Builder setChannelIdBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          channelId_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.Timestamp startTime_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            startTimeBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. The starting timestamp for messages to import.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the startTime field is set.
         */
        public boolean hasStartTime() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. The starting timestamp for messages to import.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The startTime.
         */
        public com.google.protobuf.Timestamp getStartTime() {
          if (startTimeBuilder_ == null) {
            return startTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : startTime_;
          } else {
            return startTimeBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The starting timestamp for messages to import.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setStartTime(com.google.protobuf.Timestamp value) {
          if (startTimeBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            startTime_ = value;
          } else {
            startTimeBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The starting timestamp for messages to import.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
          if (startTimeBuilder_ == null) {
            startTime_ = builderForValue.build();
          } else {
            startTimeBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The starting timestamp for messages to import.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
          if (startTimeBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && startTime_ != null
                && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
              getStartTimeBuilder().mergeFrom(value);
            } else {
              startTime_ = value;
            }
          } else {
            startTimeBuilder_.mergeFrom(value);
          }
          if (startTime_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The starting timestamp for messages to import.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearStartTime() {
          bitField0_ = (bitField0_ & ~0x00000002);
          startTime_ = null;
          if (startTimeBuilder_ != null) {
            startTimeBuilder_.dispose();
            startTimeBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The starting timestamp for messages to import.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getStartTimeFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. The starting timestamp for messages to import.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
          if (startTimeBuilder_ != null) {
            return startTimeBuilder_.getMessageOrBuilder();
          } else {
            return startTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : startTime_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The starting timestamp for messages to import.
         * </pre>
         *
         * <code>
         * .google.protobuf.Timestamp start_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            getStartTimeFieldBuilder() {
          if (startTimeBuilder_ == null) {
            startTimeBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Timestamp,
                    com.google.protobuf.Timestamp.Builder,
                    com.google.protobuf.TimestampOrBuilder>(
                    getStartTime(), getParentForChildren(), isClean());
            startTime_ = null;
          }
          return startTimeBuilder_;
        }

        private com.google.protobuf.Timestamp endTime_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            endTimeBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. The ending timestamp for messages to import.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the endTime field is set.
         */
        public boolean hasEndTime() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. The ending timestamp for messages to import.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The endTime.
         */
        public com.google.protobuf.Timestamp getEndTime() {
          if (endTimeBuilder_ == null) {
            return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
          } else {
            return endTimeBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The ending timestamp for messages to import.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setEndTime(com.google.protobuf.Timestamp value) {
          if (endTimeBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            endTime_ = value;
          } else {
            endTimeBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The ending timestamp for messages to import.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
          if (endTimeBuilder_ == null) {
            endTime_ = builderForValue.build();
          } else {
            endTimeBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The ending timestamp for messages to import.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
          if (endTimeBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && endTime_ != null
                && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
              getEndTimeBuilder().mergeFrom(value);
            } else {
              endTime_ = value;
            }
          } else {
            endTimeBuilder_.mergeFrom(value);
          }
          if (endTime_ != null) {
            bitField0_ |= 0x00000004;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The ending timestamp for messages to import.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearEndTime() {
          bitField0_ = (bitField0_ & ~0x00000004);
          endTime_ = null;
          if (endTimeBuilder_ != null) {
            endTimeBuilder_.dispose();
            endTimeBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The ending timestamp for messages to import.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getEndTimeFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. The ending timestamp for messages to import.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
          if (endTimeBuilder_ != null) {
            return endTimeBuilder_.getMessageOrBuilder();
          } else {
            return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The ending timestamp for messages to import.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp end_time = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            getEndTimeFieldBuilder() {
          if (endTimeBuilder_ == null) {
            endTimeBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Timestamp,
                    com.google.protobuf.Timestamp.Builder,
                    com.google.protobuf.TimestampOrBuilder>(
                    getEndTime(), getParentForChildren(), isClean());
            endTime_ = null;
          }
          return endTimeBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel)
      private static final com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel();
      }

      public static com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SlackChannel> PARSER =
          new com.google.protobuf.AbstractParser<SlackChannel>() {
            @java.lang.Override
            public SlackChannel parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SlackChannel> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SlackChannel> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int CHANNELS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel>
        channels_;
    /**
     *
     *
     * <pre>
     * Required. The Slack channel IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel>
        getChannelsList() {
      return channels_;
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channel IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannelOrBuilder>
        getChannelsOrBuilderList() {
      return channels_;
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channel IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getChannelsCount() {
      return channels_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channel IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel getChannels(
        int index) {
      return channels_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channel IDs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannelOrBuilder
        getChannelsOrBuilder(int index) {
      return channels_.get(index);
    }

    public static final int API_KEY_CONFIG_FIELD_NUMBER = 3;
    private com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig apiKeyConfig_;
    /**
     *
     *
     * <pre>
     * Required. The SecretManager secret version resource name (e.g.
     * projects/{project}/secrets/{secret}/versions/{version}) storing the
     * Slack channel access token that has access to the slack channel IDs.
     * See: https://api.slack.com/tutorials/tracks/getting-a-token.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ApiAuth.ApiKeyConfig api_key_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the apiKeyConfig field is set.
     */
    @java.lang.Override
    public boolean hasApiKeyConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The SecretManager secret version resource name (e.g.
     * projects/{project}/secrets/{secret}/versions/{version}) storing the
     * Slack channel access token that has access to the slack channel IDs.
     * See: https://api.slack.com/tutorials/tracks/getting-a-token.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ApiAuth.ApiKeyConfig api_key_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The apiKeyConfig.
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig getApiKeyConfig() {
      return apiKeyConfig_ == null
          ? com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig.getDefaultInstance()
          : apiKeyConfig_;
    }
    /**
     *
     *
     * <pre>
     * Required. The SecretManager secret version resource name (e.g.
     * projects/{project}/secrets/{secret}/versions/{version}) storing the
     * Slack channel access token that has access to the slack channel IDs.
     * See: https://api.slack.com/tutorials/tracks/getting-a-token.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ApiAuth.ApiKeyConfig api_key_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfigOrBuilder getApiKeyConfigOrBuilder() {
      return apiKeyConfig_ == null
          ? com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig.getDefaultInstance()
          : apiKeyConfig_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < channels_.size(); i++) {
        output.writeMessage(1, channels_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getApiKeyConfig());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < channels_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, channels_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getApiKeyConfig());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.vertexai.api.SlackSource.SlackChannels)) {
        return super.equals(obj);
      }
      com.google.cloud.vertexai.api.SlackSource.SlackChannels other =
          (com.google.cloud.vertexai.api.SlackSource.SlackChannels) obj;

      if (!getChannelsList().equals(other.getChannelsList())) return false;
      if (hasApiKeyConfig() != other.hasApiKeyConfig()) return false;
      if (hasApiKeyConfig()) {
        if (!getApiKeyConfig().equals(other.getApiKeyConfig())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getChannelsCount() > 0) {
        hash = (37 * hash) + CHANNELS_FIELD_NUMBER;
        hash = (53 * hash) + getChannelsList().hashCode();
      }
      if (hasApiKeyConfig()) {
        hash = (37 * hash) + API_KEY_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getApiKeyConfig().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.vertexai.api.SlackSource.SlackChannels parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vertexai.api.SlackSource.SlackChannels parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vertexai.api.SlackSource.SlackChannels parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vertexai.api.SlackSource.SlackChannels parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vertexai.api.SlackSource.SlackChannels parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vertexai.api.SlackSource.SlackChannels parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vertexai.api.SlackSource.SlackChannels parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vertexai.api.SlackSource.SlackChannels parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vertexai.api.SlackSource.SlackChannels parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.vertexai.api.SlackSource.SlackChannels parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vertexai.api.SlackSource.SlackChannels parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vertexai.api.SlackSource.SlackChannels parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.vertexai.api.SlackSource.SlackChannels prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * SlackChannels contains the Slack channels and corresponding access token.
     * </pre>
     *
     * Protobuf type {@code google.cloud.vertexai.v1.SlackSource.SlackChannels}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.SlackSource.SlackChannels)
        com.google.cloud.vertexai.api.SlackSource.SlackChannelsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.vertexai.api.IoProto
            .internal_static_google_cloud_vertexai_v1_SlackSource_SlackChannels_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.vertexai.api.IoProto
            .internal_static_google_cloud_vertexai_v1_SlackSource_SlackChannels_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.vertexai.api.SlackSource.SlackChannels.class,
                com.google.cloud.vertexai.api.SlackSource.SlackChannels.Builder.class);
      }

      // Construct using com.google.cloud.vertexai.api.SlackSource.SlackChannels.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getChannelsFieldBuilder();
          getApiKeyConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (channelsBuilder_ == null) {
          channels_ = java.util.Collections.emptyList();
        } else {
          channels_ = null;
          channelsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        apiKeyConfig_ = null;
        if (apiKeyConfigBuilder_ != null) {
          apiKeyConfigBuilder_.dispose();
          apiKeyConfigBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.vertexai.api.IoProto
            .internal_static_google_cloud_vertexai_v1_SlackSource_SlackChannels_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.vertexai.api.SlackSource.SlackChannels getDefaultInstanceForType() {
        return com.google.cloud.vertexai.api.SlackSource.SlackChannels.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.vertexai.api.SlackSource.SlackChannels build() {
        com.google.cloud.vertexai.api.SlackSource.SlackChannels result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.vertexai.api.SlackSource.SlackChannels buildPartial() {
        com.google.cloud.vertexai.api.SlackSource.SlackChannels result =
            new com.google.cloud.vertexai.api.SlackSource.SlackChannels(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.vertexai.api.SlackSource.SlackChannels result) {
        if (channelsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            channels_ = java.util.Collections.unmodifiableList(channels_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.channels_ = channels_;
        } else {
          result.channels_ = channelsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.vertexai.api.SlackSource.SlackChannels result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.apiKeyConfig_ =
              apiKeyConfigBuilder_ == null ? apiKeyConfig_ : apiKeyConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.vertexai.api.SlackSource.SlackChannels) {
          return mergeFrom((com.google.cloud.vertexai.api.SlackSource.SlackChannels) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.vertexai.api.SlackSource.SlackChannels other) {
        if (other == com.google.cloud.vertexai.api.SlackSource.SlackChannels.getDefaultInstance())
          return this;
        if (channelsBuilder_ == null) {
          if (!other.channels_.isEmpty()) {
            if (channels_.isEmpty()) {
              channels_ = other.channels_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureChannelsIsMutable();
              channels_.addAll(other.channels_);
            }
            onChanged();
          }
        } else {
          if (!other.channels_.isEmpty()) {
            if (channelsBuilder_.isEmpty()) {
              channelsBuilder_.dispose();
              channelsBuilder_ = null;
              channels_ = other.channels_;
              bitField0_ = (bitField0_ & ~0x00000001);
              channelsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getChannelsFieldBuilder()
                      : null;
            } else {
              channelsBuilder_.addAllMessages(other.channels_);
            }
          }
        }
        if (other.hasApiKeyConfig()) {
          mergeApiKeyConfig(other.getApiKeyConfig());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel m =
                      input.readMessage(
                          com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel
                              .parser(),
                          extensionRegistry);
                  if (channelsBuilder_ == null) {
                    ensureChannelsIsMutable();
                    channels_.add(m);
                  } else {
                    channelsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 26:
                {
                  input.readMessage(getApiKeyConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel>
          channels_ = java.util.Collections.emptyList();

      private void ensureChannelsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          channels_ =
              new java.util.ArrayList<
                  com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel>(channels_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel,
              com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel.Builder,
              com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannelOrBuilder>
          channelsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel>
          getChannelsList() {
        if (channelsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(channels_);
        } else {
          return channelsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getChannelsCount() {
        if (channelsBuilder_ == null) {
          return channels_.size();
        } else {
          return channelsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel getChannels(
          int index) {
        if (channelsBuilder_ == null) {
          return channels_.get(index);
        } else {
          return channelsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setChannels(
          int index, com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel value) {
        if (channelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureChannelsIsMutable();
          channels_.set(index, value);
          onChanged();
        } else {
          channelsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setChannels(
          int index,
          com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel.Builder
              builderForValue) {
        if (channelsBuilder_ == null) {
          ensureChannelsIsMutable();
          channels_.set(index, builderForValue.build());
          onChanged();
        } else {
          channelsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addChannels(
          com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel value) {
        if (channelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureChannelsIsMutable();
          channels_.add(value);
          onChanged();
        } else {
          channelsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addChannels(
          int index, com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel value) {
        if (channelsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureChannelsIsMutable();
          channels_.add(index, value);
          onChanged();
        } else {
          channelsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addChannels(
          com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel.Builder
              builderForValue) {
        if (channelsBuilder_ == null) {
          ensureChannelsIsMutable();
          channels_.add(builderForValue.build());
          onChanged();
        } else {
          channelsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addChannels(
          int index,
          com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel.Builder
              builderForValue) {
        if (channelsBuilder_ == null) {
          ensureChannelsIsMutable();
          channels_.add(index, builderForValue.build());
          onChanged();
        } else {
          channelsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllChannels(
          java.lang.Iterable<
                  ? extends com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel>
              values) {
        if (channelsBuilder_ == null) {
          ensureChannelsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, channels_);
          onChanged();
        } else {
          channelsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearChannels() {
        if (channelsBuilder_ == null) {
          channels_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          channelsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeChannels(int index) {
        if (channelsBuilder_ == null) {
          ensureChannelsIsMutable();
          channels_.remove(index);
          onChanged();
        } else {
          channelsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel.Builder
          getChannelsBuilder(int index) {
        return getChannelsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannelOrBuilder
          getChannelsOrBuilder(int index) {
        if (channelsBuilder_ == null) {
          return channels_.get(index);
        } else {
          return channelsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannelOrBuilder>
          getChannelsOrBuilderList() {
        if (channelsBuilder_ != null) {
          return channelsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(channels_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel.Builder
          addChannelsBuilder() {
        return getChannelsFieldBuilder()
            .addBuilder(
                com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel.Builder
          addChannelsBuilder(int index) {
        return getChannelsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. The Slack channel IDs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels.SlackChannel channels = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel.Builder>
          getChannelsBuilderList() {
        return getChannelsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel,
              com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel.Builder,
              com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannelOrBuilder>
          getChannelsFieldBuilder() {
        if (channelsBuilder_ == null) {
          channelsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel,
                  com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannel.Builder,
                  com.google.cloud.vertexai.api.SlackSource.SlackChannels.SlackChannelOrBuilder>(
                  channels_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          channels_ = null;
        }
        return channelsBuilder_;
      }

      private com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig apiKeyConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig,
              com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig.Builder,
              com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfigOrBuilder>
          apiKeyConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Slack channel access token that has access to the slack channel IDs.
       * See: https://api.slack.com/tutorials/tracks/getting-a-token.
       * </pre>
       *
       * <code>
       * .google.cloud.vertexai.v1.ApiAuth.ApiKeyConfig api_key_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the apiKeyConfig field is set.
       */
      public boolean hasApiKeyConfig() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Slack channel access token that has access to the slack channel IDs.
       * See: https://api.slack.com/tutorials/tracks/getting-a-token.
       * </pre>
       *
       * <code>
       * .google.cloud.vertexai.v1.ApiAuth.ApiKeyConfig api_key_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The apiKeyConfig.
       */
      public com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig getApiKeyConfig() {
        if (apiKeyConfigBuilder_ == null) {
          return apiKeyConfig_ == null
              ? com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig.getDefaultInstance()
              : apiKeyConfig_;
        } else {
          return apiKeyConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Slack channel access token that has access to the slack channel IDs.
       * See: https://api.slack.com/tutorials/tracks/getting-a-token.
       * </pre>
       *
       * <code>
       * .google.cloud.vertexai.v1.ApiAuth.ApiKeyConfig api_key_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setApiKeyConfig(com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig value) {
        if (apiKeyConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          apiKeyConfig_ = value;
        } else {
          apiKeyConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Slack channel access token that has access to the slack channel IDs.
       * See: https://api.slack.com/tutorials/tracks/getting-a-token.
       * </pre>
       *
       * <code>
       * .google.cloud.vertexai.v1.ApiAuth.ApiKeyConfig api_key_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setApiKeyConfig(
          com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig.Builder builderForValue) {
        if (apiKeyConfigBuilder_ == null) {
          apiKeyConfig_ = builderForValue.build();
        } else {
          apiKeyConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Slack channel access token that has access to the slack channel IDs.
       * See: https://api.slack.com/tutorials/tracks/getting-a-token.
       * </pre>
       *
       * <code>
       * .google.cloud.vertexai.v1.ApiAuth.ApiKeyConfig api_key_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeApiKeyConfig(com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig value) {
        if (apiKeyConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && apiKeyConfig_ != null
              && apiKeyConfig_
                  != com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig.getDefaultInstance()) {
            getApiKeyConfigBuilder().mergeFrom(value);
          } else {
            apiKeyConfig_ = value;
          }
        } else {
          apiKeyConfigBuilder_.mergeFrom(value);
        }
        if (apiKeyConfig_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Slack channel access token that has access to the slack channel IDs.
       * See: https://api.slack.com/tutorials/tracks/getting-a-token.
       * </pre>
       *
       * <code>
       * .google.cloud.vertexai.v1.ApiAuth.ApiKeyConfig api_key_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearApiKeyConfig() {
        bitField0_ = (bitField0_ & ~0x00000002);
        apiKeyConfig_ = null;
        if (apiKeyConfigBuilder_ != null) {
          apiKeyConfigBuilder_.dispose();
          apiKeyConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Slack channel access token that has access to the slack channel IDs.
       * See: https://api.slack.com/tutorials/tracks/getting-a-token.
       * </pre>
       *
       * <code>
       * .google.cloud.vertexai.v1.ApiAuth.ApiKeyConfig api_key_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig.Builder getApiKeyConfigBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getApiKeyConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Slack channel access token that has access to the slack channel IDs.
       * See: https://api.slack.com/tutorials/tracks/getting-a-token.
       * </pre>
       *
       * <code>
       * .google.cloud.vertexai.v1.ApiAuth.ApiKeyConfig api_key_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfigOrBuilder
          getApiKeyConfigOrBuilder() {
        if (apiKeyConfigBuilder_ != null) {
          return apiKeyConfigBuilder_.getMessageOrBuilder();
        } else {
          return apiKeyConfig_ == null
              ? com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig.getDefaultInstance()
              : apiKeyConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The SecretManager secret version resource name (e.g.
       * projects/{project}/secrets/{secret}/versions/{version}) storing the
       * Slack channel access token that has access to the slack channel IDs.
       * See: https://api.slack.com/tutorials/tracks/getting-a-token.
       * </pre>
       *
       * <code>
       * .google.cloud.vertexai.v1.ApiAuth.ApiKeyConfig api_key_config = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig,
              com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig.Builder,
              com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfigOrBuilder>
          getApiKeyConfigFieldBuilder() {
        if (apiKeyConfigBuilder_ == null) {
          apiKeyConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig,
                  com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfig.Builder,
                  com.google.cloud.vertexai.api.ApiAuth.ApiKeyConfigOrBuilder>(
                  getApiKeyConfig(), getParentForChildren(), isClean());
          apiKeyConfig_ = null;
        }
        return apiKeyConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.SlackSource.SlackChannels)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.SlackSource.SlackChannels)
    private static final com.google.cloud.vertexai.api.SlackSource.SlackChannels DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.vertexai.api.SlackSource.SlackChannels();
    }

    public static com.google.cloud.vertexai.api.SlackSource.SlackChannels getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SlackChannels> PARSER =
        new com.google.protobuf.AbstractParser<SlackChannels>() {
          @java.lang.Override
          public SlackChannels parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SlackChannels> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SlackChannels> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.SlackSource.SlackChannels getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CHANNELS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vertexai.api.SlackSource.SlackChannels> channels_;
  /**
   *
   *
   * <pre>
   * Required. The Slack channels.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vertexai.api.SlackSource.SlackChannels> getChannelsList() {
    return channels_;
  }
  /**
   *
   *
   * <pre>
   * Required. The Slack channels.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vertexai.api.SlackSource.SlackChannelsOrBuilder>
      getChannelsOrBuilderList() {
    return channels_;
  }
  /**
   *
   *
   * <pre>
   * Required. The Slack channels.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getChannelsCount() {
    return channels_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The Slack channels.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.SlackSource.SlackChannels getChannels(int index) {
    return channels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The Slack channels.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.SlackSource.SlackChannelsOrBuilder getChannelsOrBuilder(
      int index) {
    return channels_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < channels_.size(); i++) {
      output.writeMessage(1, channels_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < channels_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, channels_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vertexai.api.SlackSource)) {
      return super.equals(obj);
    }
    com.google.cloud.vertexai.api.SlackSource other =
        (com.google.cloud.vertexai.api.SlackSource) obj;

    if (!getChannelsList().equals(other.getChannelsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getChannelsCount() > 0) {
      hash = (37 * hash) + CHANNELS_FIELD_NUMBER;
      hash = (53 * hash) + getChannelsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vertexai.api.SlackSource parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.SlackSource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.SlackSource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.SlackSource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.SlackSource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.SlackSource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.SlackSource parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.SlackSource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.SlackSource parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.SlackSource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.SlackSource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.SlackSource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vertexai.api.SlackSource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The Slack source for the ImportRagFilesRequest.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vertexai.v1.SlackSource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.SlackSource)
      com.google.cloud.vertexai.api.SlackSourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vertexai.api.IoProto
          .internal_static_google_cloud_vertexai_v1_SlackSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vertexai.api.IoProto
          .internal_static_google_cloud_vertexai_v1_SlackSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vertexai.api.SlackSource.class,
              com.google.cloud.vertexai.api.SlackSource.Builder.class);
    }

    // Construct using com.google.cloud.vertexai.api.SlackSource.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (channelsBuilder_ == null) {
        channels_ = java.util.Collections.emptyList();
      } else {
        channels_ = null;
        channelsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vertexai.api.IoProto
          .internal_static_google_cloud_vertexai_v1_SlackSource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.SlackSource getDefaultInstanceForType() {
      return com.google.cloud.vertexai.api.SlackSource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.SlackSource build() {
      com.google.cloud.vertexai.api.SlackSource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.SlackSource buildPartial() {
      com.google.cloud.vertexai.api.SlackSource result =
          new com.google.cloud.vertexai.api.SlackSource(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.vertexai.api.SlackSource result) {
      if (channelsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          channels_ = java.util.Collections.unmodifiableList(channels_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.channels_ = channels_;
      } else {
        result.channels_ = channelsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.vertexai.api.SlackSource result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vertexai.api.SlackSource) {
        return mergeFrom((com.google.cloud.vertexai.api.SlackSource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vertexai.api.SlackSource other) {
      if (other == com.google.cloud.vertexai.api.SlackSource.getDefaultInstance()) return this;
      if (channelsBuilder_ == null) {
        if (!other.channels_.isEmpty()) {
          if (channels_.isEmpty()) {
            channels_ = other.channels_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureChannelsIsMutable();
            channels_.addAll(other.channels_);
          }
          onChanged();
        }
      } else {
        if (!other.channels_.isEmpty()) {
          if (channelsBuilder_.isEmpty()) {
            channelsBuilder_.dispose();
            channelsBuilder_ = null;
            channels_ = other.channels_;
            bitField0_ = (bitField0_ & ~0x00000001);
            channelsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getChannelsFieldBuilder()
                    : null;
          } else {
            channelsBuilder_.addAllMessages(other.channels_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.vertexai.api.SlackSource.SlackChannels m =
                    input.readMessage(
                        com.google.cloud.vertexai.api.SlackSource.SlackChannels.parser(),
                        extensionRegistry);
                if (channelsBuilder_ == null) {
                  ensureChannelsIsMutable();
                  channels_.add(m);
                } else {
                  channelsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.vertexai.api.SlackSource.SlackChannels> channels_ =
        java.util.Collections.emptyList();

    private void ensureChannelsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        channels_ =
            new java.util.ArrayList<com.google.cloud.vertexai.api.SlackSource.SlackChannels>(
                channels_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.SlackSource.SlackChannels,
            com.google.cloud.vertexai.api.SlackSource.SlackChannels.Builder,
            com.google.cloud.vertexai.api.SlackSource.SlackChannelsOrBuilder>
        channelsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.SlackSource.SlackChannels>
        getChannelsList() {
      if (channelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(channels_);
      } else {
        return channelsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getChannelsCount() {
      if (channelsBuilder_ == null) {
        return channels_.size();
      } else {
        return channelsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.vertexai.api.SlackSource.SlackChannels getChannels(int index) {
      if (channelsBuilder_ == null) {
        return channels_.get(index);
      } else {
        return channelsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setChannels(
        int index, com.google.cloud.vertexai.api.SlackSource.SlackChannels value) {
      if (channelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChannelsIsMutable();
        channels_.set(index, value);
        onChanged();
      } else {
        channelsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setChannels(
        int index,
        com.google.cloud.vertexai.api.SlackSource.SlackChannels.Builder builderForValue) {
      if (channelsBuilder_ == null) {
        ensureChannelsIsMutable();
        channels_.set(index, builderForValue.build());
        onChanged();
      } else {
        channelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addChannels(com.google.cloud.vertexai.api.SlackSource.SlackChannels value) {
      if (channelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChannelsIsMutable();
        channels_.add(value);
        onChanged();
      } else {
        channelsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addChannels(
        int index, com.google.cloud.vertexai.api.SlackSource.SlackChannels value) {
      if (channelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChannelsIsMutable();
        channels_.add(index, value);
        onChanged();
      } else {
        channelsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addChannels(
        com.google.cloud.vertexai.api.SlackSource.SlackChannels.Builder builderForValue) {
      if (channelsBuilder_ == null) {
        ensureChannelsIsMutable();
        channels_.add(builderForValue.build());
        onChanged();
      } else {
        channelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addChannels(
        int index,
        com.google.cloud.vertexai.api.SlackSource.SlackChannels.Builder builderForValue) {
      if (channelsBuilder_ == null) {
        ensureChannelsIsMutable();
        channels_.add(index, builderForValue.build());
        onChanged();
      } else {
        channelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllChannels(
        java.lang.Iterable<? extends com.google.cloud.vertexai.api.SlackSource.SlackChannels>
            values) {
      if (channelsBuilder_ == null) {
        ensureChannelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, channels_);
        onChanged();
      } else {
        channelsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearChannels() {
      if (channelsBuilder_ == null) {
        channels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        channelsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeChannels(int index) {
      if (channelsBuilder_ == null) {
        ensureChannelsIsMutable();
        channels_.remove(index);
        onChanged();
      } else {
        channelsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.vertexai.api.SlackSource.SlackChannels.Builder getChannelsBuilder(
        int index) {
      return getChannelsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.vertexai.api.SlackSource.SlackChannelsOrBuilder getChannelsOrBuilder(
        int index) {
      if (channelsBuilder_ == null) {
        return channels_.get(index);
      } else {
        return channelsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.vertexai.api.SlackSource.SlackChannelsOrBuilder>
        getChannelsOrBuilderList() {
      if (channelsBuilder_ != null) {
        return channelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(channels_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.vertexai.api.SlackSource.SlackChannels.Builder addChannelsBuilder() {
      return getChannelsFieldBuilder()
          .addBuilder(com.google.cloud.vertexai.api.SlackSource.SlackChannels.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.vertexai.api.SlackSource.SlackChannels.Builder addChannelsBuilder(
        int index) {
      return getChannelsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.vertexai.api.SlackSource.SlackChannels.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The Slack channels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SlackSource.SlackChannels channels = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.SlackSource.SlackChannels.Builder>
        getChannelsBuilderList() {
      return getChannelsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.SlackSource.SlackChannels,
            com.google.cloud.vertexai.api.SlackSource.SlackChannels.Builder,
            com.google.cloud.vertexai.api.SlackSource.SlackChannelsOrBuilder>
        getChannelsFieldBuilder() {
      if (channelsBuilder_ == null) {
        channelsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vertexai.api.SlackSource.SlackChannels,
                com.google.cloud.vertexai.api.SlackSource.SlackChannels.Builder,
                com.google.cloud.vertexai.api.SlackSource.SlackChannelsOrBuilder>(
                channels_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        channels_ = null;
      }
      return channelsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.SlackSource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.SlackSource)
  private static final com.google.cloud.vertexai.api.SlackSource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vertexai.api.SlackSource();
  }

  public static com.google.cloud.vertexai.api.SlackSource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SlackSource> PARSER =
      new com.google.protobuf.AbstractParser<SlackSource>() {
        @java.lang.Override
        public SlackSource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SlackSource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SlackSource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vertexai.api.SlackSource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
