/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vertexai/v1/prediction_service.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.vertexai.api;

/**
 *
 *
 * <pre>
 * Response message for
 * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
 * </pre>
 *
 * Protobuf type {@code google.cloud.vertexai.v1.ExplainResponse}
 */
public final class ExplainResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.ExplainResponse)
    ExplainResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExplainResponse.newBuilder() to construct.
  private ExplainResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExplainResponse() {
    explanations_ = java.util.Collections.emptyList();
    deployedModelId_ = "";
    predictions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExplainResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vertexai.api.PredictionServiceProto
        .internal_static_google_cloud_vertexai_v1_ExplainResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vertexai.api.PredictionServiceProto
        .internal_static_google_cloud_vertexai_v1_ExplainResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vertexai.api.ExplainResponse.class,
            com.google.cloud.vertexai.api.ExplainResponse.Builder.class);
  }

  public static final int EXPLANATIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vertexai.api.Explanation> explanations_;
  /**
   *
   *
   * <pre>
   * The explanations of the Model's
   * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
   *
   * It has the same number of elements as
   * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
   * explained.
   * </pre>
   *
   * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vertexai.api.Explanation> getExplanationsList() {
    return explanations_;
  }
  /**
   *
   *
   * <pre>
   * The explanations of the Model's
   * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
   *
   * It has the same number of elements as
   * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
   * explained.
   * </pre>
   *
   * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vertexai.api.ExplanationOrBuilder>
      getExplanationsOrBuilderList() {
    return explanations_;
  }
  /**
   *
   *
   * <pre>
   * The explanations of the Model's
   * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
   *
   * It has the same number of elements as
   * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
   * explained.
   * </pre>
   *
   * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
   */
  @java.lang.Override
  public int getExplanationsCount() {
    return explanations_.size();
  }
  /**
   *
   *
   * <pre>
   * The explanations of the Model's
   * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
   *
   * It has the same number of elements as
   * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
   * explained.
   * </pre>
   *
   * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.Explanation getExplanations(int index) {
    return explanations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The explanations of the Model's
   * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
   *
   * It has the same number of elements as
   * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
   * explained.
   * </pre>
   *
   * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.ExplanationOrBuilder getExplanationsOrBuilder(int index) {
    return explanations_.get(index);
  }

  public static final int DEPLOYED_MODEL_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deployedModelId_ = "";
  /**
   *
   *
   * <pre>
   * ID of the Endpoint's DeployedModel that served this explanation.
   * </pre>
   *
   * <code>string deployed_model_id = 2;</code>
   *
   * @return The deployedModelId.
   */
  @java.lang.Override
  public java.lang.String getDeployedModelId() {
    java.lang.Object ref = deployedModelId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deployedModelId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * ID of the Endpoint's DeployedModel that served this explanation.
   * </pre>
   *
   * <code>string deployed_model_id = 2;</code>
   *
   * @return The bytes for deployedModelId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeployedModelIdBytes() {
    java.lang.Object ref = deployedModelId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deployedModelId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREDICTIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.protobuf.Value> predictions_;
  /**
   *
   *
   * <pre>
   * The predictions that are the output of the predictions call.
   * Same as
   * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value predictions = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Value> getPredictionsList() {
    return predictions_;
  }
  /**
   *
   *
   * <pre>
   * The predictions that are the output of the predictions call.
   * Same as
   * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value predictions = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.ValueOrBuilder>
      getPredictionsOrBuilderList() {
    return predictions_;
  }
  /**
   *
   *
   * <pre>
   * The predictions that are the output of the predictions call.
   * Same as
   * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value predictions = 3;</code>
   */
  @java.lang.Override
  public int getPredictionsCount() {
    return predictions_.size();
  }
  /**
   *
   *
   * <pre>
   * The predictions that are the output of the predictions call.
   * Same as
   * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value predictions = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Value getPredictions(int index) {
    return predictions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The predictions that are the output of the predictions call.
   * Same as
   * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
   * </pre>
   *
   * <code>repeated .google.protobuf.Value predictions = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getPredictionsOrBuilder(int index) {
    return predictions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < explanations_.size(); i++) {
      output.writeMessage(1, explanations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployedModelId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, deployedModelId_);
    }
    for (int i = 0; i < predictions_.size(); i++) {
      output.writeMessage(3, predictions_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < explanations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, explanations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployedModelId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, deployedModelId_);
    }
    for (int i = 0; i < predictions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, predictions_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vertexai.api.ExplainResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.vertexai.api.ExplainResponse other =
        (com.google.cloud.vertexai.api.ExplainResponse) obj;

    if (!getExplanationsList().equals(other.getExplanationsList())) return false;
    if (!getDeployedModelId().equals(other.getDeployedModelId())) return false;
    if (!getPredictionsList().equals(other.getPredictionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getExplanationsCount() > 0) {
      hash = (37 * hash) + EXPLANATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getExplanationsList().hashCode();
    }
    hash = (37 * hash) + DEPLOYED_MODEL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDeployedModelId().hashCode();
    if (getPredictionsCount() > 0) {
      hash = (37 * hash) + PREDICTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getPredictionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vertexai.api.ExplainResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.ExplainResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ExplainResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.ExplainResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ExplainResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.ExplainResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ExplainResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.ExplainResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ExplainResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.ExplainResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ExplainResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.ExplainResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vertexai.api.ExplainResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * Protobuf type {@code google.cloud.vertexai.v1.ExplainResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.ExplainResponse)
      com.google.cloud.vertexai.api.ExplainResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vertexai.api.PredictionServiceProto
          .internal_static_google_cloud_vertexai_v1_ExplainResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vertexai.api.PredictionServiceProto
          .internal_static_google_cloud_vertexai_v1_ExplainResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vertexai.api.ExplainResponse.class,
              com.google.cloud.vertexai.api.ExplainResponse.Builder.class);
    }

    // Construct using com.google.cloud.vertexai.api.ExplainResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (explanationsBuilder_ == null) {
        explanations_ = java.util.Collections.emptyList();
      } else {
        explanations_ = null;
        explanationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      deployedModelId_ = "";
      if (predictionsBuilder_ == null) {
        predictions_ = java.util.Collections.emptyList();
      } else {
        predictions_ = null;
        predictionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vertexai.api.PredictionServiceProto
          .internal_static_google_cloud_vertexai_v1_ExplainResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.ExplainResponse getDefaultInstanceForType() {
      return com.google.cloud.vertexai.api.ExplainResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.ExplainResponse build() {
      com.google.cloud.vertexai.api.ExplainResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.ExplainResponse buildPartial() {
      com.google.cloud.vertexai.api.ExplainResponse result =
          new com.google.cloud.vertexai.api.ExplainResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.vertexai.api.ExplainResponse result) {
      if (explanationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          explanations_ = java.util.Collections.unmodifiableList(explanations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.explanations_ = explanations_;
      } else {
        result.explanations_ = explanationsBuilder_.build();
      }
      if (predictionsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          predictions_ = java.util.Collections.unmodifiableList(predictions_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.predictions_ = predictions_;
      } else {
        result.predictions_ = predictionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.vertexai.api.ExplainResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.deployedModelId_ = deployedModelId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vertexai.api.ExplainResponse) {
        return mergeFrom((com.google.cloud.vertexai.api.ExplainResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vertexai.api.ExplainResponse other) {
      if (other == com.google.cloud.vertexai.api.ExplainResponse.getDefaultInstance()) return this;
      if (explanationsBuilder_ == null) {
        if (!other.explanations_.isEmpty()) {
          if (explanations_.isEmpty()) {
            explanations_ = other.explanations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureExplanationsIsMutable();
            explanations_.addAll(other.explanations_);
          }
          onChanged();
        }
      } else {
        if (!other.explanations_.isEmpty()) {
          if (explanationsBuilder_.isEmpty()) {
            explanationsBuilder_.dispose();
            explanationsBuilder_ = null;
            explanations_ = other.explanations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            explanationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExplanationsFieldBuilder()
                    : null;
          } else {
            explanationsBuilder_.addAllMessages(other.explanations_);
          }
        }
      }
      if (!other.getDeployedModelId().isEmpty()) {
        deployedModelId_ = other.deployedModelId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (predictionsBuilder_ == null) {
        if (!other.predictions_.isEmpty()) {
          if (predictions_.isEmpty()) {
            predictions_ = other.predictions_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensurePredictionsIsMutable();
            predictions_.addAll(other.predictions_);
          }
          onChanged();
        }
      } else {
        if (!other.predictions_.isEmpty()) {
          if (predictionsBuilder_.isEmpty()) {
            predictionsBuilder_.dispose();
            predictionsBuilder_ = null;
            predictions_ = other.predictions_;
            bitField0_ = (bitField0_ & ~0x00000004);
            predictionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPredictionsFieldBuilder()
                    : null;
          } else {
            predictionsBuilder_.addAllMessages(other.predictions_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.vertexai.api.Explanation m =
                    input.readMessage(
                        com.google.cloud.vertexai.api.Explanation.parser(), extensionRegistry);
                if (explanationsBuilder_ == null) {
                  ensureExplanationsIsMutable();
                  explanations_.add(m);
                } else {
                  explanationsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                deployedModelId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.Value m =
                    input.readMessage(com.google.protobuf.Value.parser(), extensionRegistry);
                if (predictionsBuilder_ == null) {
                  ensurePredictionsIsMutable();
                  predictions_.add(m);
                } else {
                  predictionsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.vertexai.api.Explanation> explanations_ =
        java.util.Collections.emptyList();

    private void ensureExplanationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        explanations_ =
            new java.util.ArrayList<com.google.cloud.vertexai.api.Explanation>(explanations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.Explanation,
            com.google.cloud.vertexai.api.Explanation.Builder,
            com.google.cloud.vertexai.api.ExplanationOrBuilder>
        explanationsBuilder_;

    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public java.util.List<com.google.cloud.vertexai.api.Explanation> getExplanationsList() {
      if (explanationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(explanations_);
      } else {
        return explanationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public int getExplanationsCount() {
      if (explanationsBuilder_ == null) {
        return explanations_.size();
      } else {
        return explanationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public com.google.cloud.vertexai.api.Explanation getExplanations(int index) {
      if (explanationsBuilder_ == null) {
        return explanations_.get(index);
      } else {
        return explanationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public Builder setExplanations(int index, com.google.cloud.vertexai.api.Explanation value) {
      if (explanationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExplanationsIsMutable();
        explanations_.set(index, value);
        onChanged();
      } else {
        explanationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public Builder setExplanations(
        int index, com.google.cloud.vertexai.api.Explanation.Builder builderForValue) {
      if (explanationsBuilder_ == null) {
        ensureExplanationsIsMutable();
        explanations_.set(index, builderForValue.build());
        onChanged();
      } else {
        explanationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public Builder addExplanations(com.google.cloud.vertexai.api.Explanation value) {
      if (explanationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExplanationsIsMutable();
        explanations_.add(value);
        onChanged();
      } else {
        explanationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public Builder addExplanations(int index, com.google.cloud.vertexai.api.Explanation value) {
      if (explanationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExplanationsIsMutable();
        explanations_.add(index, value);
        onChanged();
      } else {
        explanationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public Builder addExplanations(
        com.google.cloud.vertexai.api.Explanation.Builder builderForValue) {
      if (explanationsBuilder_ == null) {
        ensureExplanationsIsMutable();
        explanations_.add(builderForValue.build());
        onChanged();
      } else {
        explanationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public Builder addExplanations(
        int index, com.google.cloud.vertexai.api.Explanation.Builder builderForValue) {
      if (explanationsBuilder_ == null) {
        ensureExplanationsIsMutable();
        explanations_.add(index, builderForValue.build());
        onChanged();
      } else {
        explanationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public Builder addAllExplanations(
        java.lang.Iterable<? extends com.google.cloud.vertexai.api.Explanation> values) {
      if (explanationsBuilder_ == null) {
        ensureExplanationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, explanations_);
        onChanged();
      } else {
        explanationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public Builder clearExplanations() {
      if (explanationsBuilder_ == null) {
        explanations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        explanationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public Builder removeExplanations(int index) {
      if (explanationsBuilder_ == null) {
        ensureExplanationsIsMutable();
        explanations_.remove(index);
        onChanged();
      } else {
        explanationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public com.google.cloud.vertexai.api.Explanation.Builder getExplanationsBuilder(int index) {
      return getExplanationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public com.google.cloud.vertexai.api.ExplanationOrBuilder getExplanationsOrBuilder(int index) {
      if (explanationsBuilder_ == null) {
        return explanations_.get(index);
      } else {
        return explanationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.vertexai.api.ExplanationOrBuilder>
        getExplanationsOrBuilderList() {
      if (explanationsBuilder_ != null) {
        return explanationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(explanations_);
      }
    }
    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public com.google.cloud.vertexai.api.Explanation.Builder addExplanationsBuilder() {
      return getExplanationsFieldBuilder()
          .addBuilder(com.google.cloud.vertexai.api.Explanation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public com.google.cloud.vertexai.api.Explanation.Builder addExplanationsBuilder(int index) {
      return getExplanationsFieldBuilder()
          .addBuilder(index, com.google.cloud.vertexai.api.Explanation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The explanations of the Model's
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     *
     * It has the same number of elements as
     * [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
     * explained.
     * </pre>
     *
     * <code>repeated .google.cloud.vertexai.v1.Explanation explanations = 1;</code>
     */
    public java.util.List<com.google.cloud.vertexai.api.Explanation.Builder>
        getExplanationsBuilderList() {
      return getExplanationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.Explanation,
            com.google.cloud.vertexai.api.Explanation.Builder,
            com.google.cloud.vertexai.api.ExplanationOrBuilder>
        getExplanationsFieldBuilder() {
      if (explanationsBuilder_ == null) {
        explanationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vertexai.api.Explanation,
                com.google.cloud.vertexai.api.Explanation.Builder,
                com.google.cloud.vertexai.api.ExplanationOrBuilder>(
                explanations_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        explanations_ = null;
      }
      return explanationsBuilder_;
    }

    private java.lang.Object deployedModelId_ = "";
    /**
     *
     *
     * <pre>
     * ID of the Endpoint's DeployedModel that served this explanation.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @return The deployedModelId.
     */
    public java.lang.String getDeployedModelId() {
      java.lang.Object ref = deployedModelId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deployedModelId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ID of the Endpoint's DeployedModel that served this explanation.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @return The bytes for deployedModelId.
     */
    public com.google.protobuf.ByteString getDeployedModelIdBytes() {
      java.lang.Object ref = deployedModelId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deployedModelId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ID of the Endpoint's DeployedModel that served this explanation.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @param value The deployedModelId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployedModelId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deployedModelId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of the Endpoint's DeployedModel that served this explanation.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeployedModelId() {
      deployedModelId_ = getDefaultInstance().getDeployedModelId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of the Endpoint's DeployedModel that served this explanation.
     * </pre>
     *
     * <code>string deployed_model_id = 2;</code>
     *
     * @param value The bytes for deployedModelId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployedModelIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deployedModelId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.protobuf.Value> predictions_ =
        java.util.Collections.emptyList();

    private void ensurePredictionsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        predictions_ = new java.util.ArrayList<com.google.protobuf.Value>(predictions_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        predictionsBuilder_;

    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public java.util.List<com.google.protobuf.Value> getPredictionsList() {
      if (predictionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(predictions_);
      } else {
        return predictionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public int getPredictionsCount() {
      if (predictionsBuilder_ == null) {
        return predictions_.size();
      } else {
        return predictionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public com.google.protobuf.Value getPredictions(int index) {
      if (predictionsBuilder_ == null) {
        return predictions_.get(index);
      } else {
        return predictionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public Builder setPredictions(int index, com.google.protobuf.Value value) {
      if (predictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePredictionsIsMutable();
        predictions_.set(index, value);
        onChanged();
      } else {
        predictionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public Builder setPredictions(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        predictions_.set(index, builderForValue.build());
        onChanged();
      } else {
        predictionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public Builder addPredictions(com.google.protobuf.Value value) {
      if (predictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePredictionsIsMutable();
        predictions_.add(value);
        onChanged();
      } else {
        predictionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public Builder addPredictions(int index, com.google.protobuf.Value value) {
      if (predictionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePredictionsIsMutable();
        predictions_.add(index, value);
        onChanged();
      } else {
        predictionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public Builder addPredictions(com.google.protobuf.Value.Builder builderForValue) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        predictions_.add(builderForValue.build());
        onChanged();
      } else {
        predictionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public Builder addPredictions(int index, com.google.protobuf.Value.Builder builderForValue) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        predictions_.add(index, builderForValue.build());
        onChanged();
      } else {
        predictionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public Builder addAllPredictions(
        java.lang.Iterable<? extends com.google.protobuf.Value> values) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, predictions_);
        onChanged();
      } else {
        predictionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public Builder clearPredictions() {
      if (predictionsBuilder_ == null) {
        predictions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        predictionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public Builder removePredictions(int index) {
      if (predictionsBuilder_ == null) {
        ensurePredictionsIsMutable();
        predictions_.remove(index);
        onChanged();
      } else {
        predictionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public com.google.protobuf.Value.Builder getPredictionsBuilder(int index) {
      return getPredictionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public com.google.protobuf.ValueOrBuilder getPredictionsOrBuilder(int index) {
      if (predictionsBuilder_ == null) {
        return predictions_.get(index);
      } else {
        return predictionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public java.util.List<? extends com.google.protobuf.ValueOrBuilder>
        getPredictionsOrBuilderList() {
      if (predictionsBuilder_ != null) {
        return predictionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(predictions_);
      }
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public com.google.protobuf.Value.Builder addPredictionsBuilder() {
      return getPredictionsFieldBuilder()
          .addBuilder(com.google.protobuf.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public com.google.protobuf.Value.Builder addPredictionsBuilder(int index) {
      return getPredictionsFieldBuilder()
          .addBuilder(index, com.google.protobuf.Value.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The predictions that are the output of the predictions call.
     * Same as
     * [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
     * </pre>
     *
     * <code>repeated .google.protobuf.Value predictions = 3;</code>
     */
    public java.util.List<com.google.protobuf.Value.Builder> getPredictionsBuilderList() {
      return getPredictionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getPredictionsFieldBuilder() {
      if (predictionsBuilder_ == null) {
        predictionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                predictions_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        predictions_ = null;
      }
      return predictionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.ExplainResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.ExplainResponse)
  private static final com.google.cloud.vertexai.api.ExplainResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vertexai.api.ExplainResponse();
  }

  public static com.google.cloud.vertexai.api.ExplainResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExplainResponse> PARSER =
      new com.google.protobuf.AbstractParser<ExplainResponse>() {
        @java.lang.Override
        public ExplainResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExplainResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExplainResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vertexai.api.ExplainResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
