/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vertexai/v1/content.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.vertexai.api;

/**
 *
 *
 * <pre>
 * Represents token counting info for a single modality.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vertexai.v1.ModalityTokenCount}
 */
public final class ModalityTokenCount extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.ModalityTokenCount)
    ModalityTokenCountOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ModalityTokenCount.newBuilder() to construct.
  private ModalityTokenCount(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModalityTokenCount() {
    modality_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModalityTokenCount();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vertexai.api.ContentProto
        .internal_static_google_cloud_vertexai_v1_ModalityTokenCount_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vertexai.api.ContentProto
        .internal_static_google_cloud_vertexai_v1_ModalityTokenCount_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vertexai.api.ModalityTokenCount.class,
            com.google.cloud.vertexai.api.ModalityTokenCount.Builder.class);
  }

  public static final int MODALITY_FIELD_NUMBER = 1;
  private int modality_ = 0;
  /**
   *
   *
   * <pre>
   * The modality associated with this token count.
   * </pre>
   *
   * <code>.google.cloud.vertexai.v1.Modality modality = 1;</code>
   *
   * @return The enum numeric value on the wire for modality.
   */
  @java.lang.Override
  public int getModalityValue() {
    return modality_;
  }
  /**
   *
   *
   * <pre>
   * The modality associated with this token count.
   * </pre>
   *
   * <code>.google.cloud.vertexai.v1.Modality modality = 1;</code>
   *
   * @return The modality.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.Modality getModality() {
    com.google.cloud.vertexai.api.Modality result =
        com.google.cloud.vertexai.api.Modality.forNumber(modality_);
    return result == null ? com.google.cloud.vertexai.api.Modality.UNRECOGNIZED : result;
  }

  public static final int TOKEN_COUNT_FIELD_NUMBER = 2;
  private int tokenCount_ = 0;
  /**
   *
   *
   * <pre>
   * Number of tokens.
   * </pre>
   *
   * <code>int32 token_count = 2;</code>
   *
   * @return The tokenCount.
   */
  @java.lang.Override
  public int getTokenCount() {
    return tokenCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (modality_ != com.google.cloud.vertexai.api.Modality.MODALITY_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, modality_);
    }
    if (tokenCount_ != 0) {
      output.writeInt32(2, tokenCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (modality_ != com.google.cloud.vertexai.api.Modality.MODALITY_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, modality_);
    }
    if (tokenCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, tokenCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vertexai.api.ModalityTokenCount)) {
      return super.equals(obj);
    }
    com.google.cloud.vertexai.api.ModalityTokenCount other =
        (com.google.cloud.vertexai.api.ModalityTokenCount) obj;

    if (modality_ != other.modality_) return false;
    if (getTokenCount() != other.getTokenCount()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MODALITY_FIELD_NUMBER;
    hash = (53 * hash) + modality_;
    hash = (37 * hash) + TOKEN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getTokenCount();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vertexai.api.ModalityTokenCount parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.ModalityTokenCount parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ModalityTokenCount parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.ModalityTokenCount parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ModalityTokenCount parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.ModalityTokenCount parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ModalityTokenCount parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.ModalityTokenCount parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ModalityTokenCount parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.ModalityTokenCount parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ModalityTokenCount parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.ModalityTokenCount parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vertexai.api.ModalityTokenCount prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents token counting info for a single modality.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vertexai.v1.ModalityTokenCount}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.ModalityTokenCount)
      com.google.cloud.vertexai.api.ModalityTokenCountOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vertexai.api.ContentProto
          .internal_static_google_cloud_vertexai_v1_ModalityTokenCount_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vertexai.api.ContentProto
          .internal_static_google_cloud_vertexai_v1_ModalityTokenCount_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vertexai.api.ModalityTokenCount.class,
              com.google.cloud.vertexai.api.ModalityTokenCount.Builder.class);
    }

    // Construct using com.google.cloud.vertexai.api.ModalityTokenCount.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      modality_ = 0;
      tokenCount_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vertexai.api.ContentProto
          .internal_static_google_cloud_vertexai_v1_ModalityTokenCount_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.ModalityTokenCount getDefaultInstanceForType() {
      return com.google.cloud.vertexai.api.ModalityTokenCount.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.ModalityTokenCount build() {
      com.google.cloud.vertexai.api.ModalityTokenCount result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.ModalityTokenCount buildPartial() {
      com.google.cloud.vertexai.api.ModalityTokenCount result =
          new com.google.cloud.vertexai.api.ModalityTokenCount(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.vertexai.api.ModalityTokenCount result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.modality_ = modality_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.tokenCount_ = tokenCount_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vertexai.api.ModalityTokenCount) {
        return mergeFrom((com.google.cloud.vertexai.api.ModalityTokenCount) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vertexai.api.ModalityTokenCount other) {
      if (other == com.google.cloud.vertexai.api.ModalityTokenCount.getDefaultInstance())
        return this;
      if (other.modality_ != 0) {
        setModalityValue(other.getModalityValue());
      }
      if (other.getTokenCount() != 0) {
        setTokenCount(other.getTokenCount());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                modality_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                tokenCount_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int modality_ = 0;
    /**
     *
     *
     * <pre>
     * The modality associated with this token count.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Modality modality = 1;</code>
     *
     * @return The enum numeric value on the wire for modality.
     */
    @java.lang.Override
    public int getModalityValue() {
      return modality_;
    }
    /**
     *
     *
     * <pre>
     * The modality associated with this token count.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Modality modality = 1;</code>
     *
     * @param value The enum numeric value on the wire for modality to set.
     * @return This builder for chaining.
     */
    public Builder setModalityValue(int value) {
      modality_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The modality associated with this token count.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Modality modality = 1;</code>
     *
     * @return The modality.
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.Modality getModality() {
      com.google.cloud.vertexai.api.Modality result =
          com.google.cloud.vertexai.api.Modality.forNumber(modality_);
      return result == null ? com.google.cloud.vertexai.api.Modality.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The modality associated with this token count.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Modality modality = 1;</code>
     *
     * @param value The modality to set.
     * @return This builder for chaining.
     */
    public Builder setModality(com.google.cloud.vertexai.api.Modality value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      modality_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The modality associated with this token count.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.Modality modality = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModality() {
      bitField0_ = (bitField0_ & ~0x00000001);
      modality_ = 0;
      onChanged();
      return this;
    }

    private int tokenCount_;
    /**
     *
     *
     * <pre>
     * Number of tokens.
     * </pre>
     *
     * <code>int32 token_count = 2;</code>
     *
     * @return The tokenCount.
     */
    @java.lang.Override
    public int getTokenCount() {
      return tokenCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of tokens.
     * </pre>
     *
     * <code>int32 token_count = 2;</code>
     *
     * @param value The tokenCount to set.
     * @return This builder for chaining.
     */
    public Builder setTokenCount(int value) {

      tokenCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of tokens.
     * </pre>
     *
     * <code>int32 token_count = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTokenCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      tokenCount_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.ModalityTokenCount)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.ModalityTokenCount)
  private static final com.google.cloud.vertexai.api.ModalityTokenCount DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vertexai.api.ModalityTokenCount();
  }

  public static com.google.cloud.vertexai.api.ModalityTokenCount getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModalityTokenCount> PARSER =
      new com.google.protobuf.AbstractParser<ModalityTokenCount>() {
        @java.lang.Override
        public ModalityTokenCount parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModalityTokenCount> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModalityTokenCount> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vertexai.api.ModalityTokenCount getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
