/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vertexai/v1/reservation_affinity.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.vertexai.api;

/**
 *
 *
 * <pre>
 * A ReservationAffinity can be used to configure a Vertex AI resource (e.g., a
 * DeployedModel) to draw its Compute Engine resources from a Shared
 * Reservation, or exclusively from on-demand capacity.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vertexai.v1.ReservationAffinity}
 */
public final class ReservationAffinity extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.ReservationAffinity)
    ReservationAffinityOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReservationAffinity.newBuilder() to construct.
  private ReservationAffinity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReservationAffinity() {
    reservationAffinityType_ = 0;
    key_ = "";
    values_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReservationAffinity();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vertexai.api.ReservationAffinityProto
        .internal_static_google_cloud_vertexai_v1_ReservationAffinity_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vertexai.api.ReservationAffinityProto
        .internal_static_google_cloud_vertexai_v1_ReservationAffinity_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vertexai.api.ReservationAffinity.class,
            com.google.cloud.vertexai.api.ReservationAffinity.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Identifies a type of reservation affinity.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.vertexai.v1.ReservationAffinity.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This should not be used.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Do not consume from any reserved capacity, only use on-demand.
     * </pre>
     *
     * <code>NO_RESERVATION = 1;</code>
     */
    NO_RESERVATION(1),
    /**
     *
     *
     * <pre>
     * Consume any reservation available, falling back to on-demand.
     * </pre>
     *
     * <code>ANY_RESERVATION = 2;</code>
     */
    ANY_RESERVATION(2),
    /**
     *
     *
     * <pre>
     * Consume from a specific reservation. When chosen, the reservation
     * must be identified via the `key` and `values` fields.
     * </pre>
     *
     * <code>SPECIFIC_RESERVATION = 3;</code>
     */
    SPECIFIC_RESERVATION(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This should not be used.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Do not consume from any reserved capacity, only use on-demand.
     * </pre>
     *
     * <code>NO_RESERVATION = 1;</code>
     */
    public static final int NO_RESERVATION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Consume any reservation available, falling back to on-demand.
     * </pre>
     *
     * <code>ANY_RESERVATION = 2;</code>
     */
    public static final int ANY_RESERVATION_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Consume from a specific reservation. When chosen, the reservation
     * must be identified via the `key` and `values` fields.
     * </pre>
     *
     * <code>SPECIFIC_RESERVATION = 3;</code>
     */
    public static final int SPECIFIC_RESERVATION_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return NO_RESERVATION;
        case 2:
          return ANY_RESERVATION;
        case 3:
          return SPECIFIC_RESERVATION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.vertexai.api.ReservationAffinity.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.vertexai.v1.ReservationAffinity.Type)
  }

  public static final int RESERVATION_AFFINITY_TYPE_FIELD_NUMBER = 1;
  private int reservationAffinityType_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Specifies the reservation affinity type.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.ReservationAffinity.Type reservation_affinity_type = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for reservationAffinityType.
   */
  @java.lang.Override
  public int getReservationAffinityTypeValue() {
    return reservationAffinityType_;
  }
  /**
   *
   *
   * <pre>
   * Required. Specifies the reservation affinity type.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.ReservationAffinity.Type reservation_affinity_type = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The reservationAffinityType.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.ReservationAffinity.Type getReservationAffinityType() {
    com.google.cloud.vertexai.api.ReservationAffinity.Type result =
        com.google.cloud.vertexai.api.ReservationAffinity.Type.forNumber(reservationAffinityType_);
    return result == null
        ? com.google.cloud.vertexai.api.ReservationAffinity.Type.UNRECOGNIZED
        : result;
  }

  public static final int KEY_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object key_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Corresponds to the label key of a reservation resource. To target
   * a SPECIFIC_RESERVATION by name, use
   * `compute.googleapis.com/reservation-name` as the key and specify the name
   * of your reservation as its value.
   * </pre>
   *
   * <code>string key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The key.
   */
  @java.lang.Override
  public java.lang.String getKey() {
    java.lang.Object ref = key_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      key_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Corresponds to the label key of a reservation resource. To target
   * a SPECIFIC_RESERVATION by name, use
   * `compute.googleapis.com/reservation-name` as the key and specify the name
   * of your reservation as its value.
   * </pre>
   *
   * <code>string key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for key.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKeyBytes() {
    java.lang.Object ref = key_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      key_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALUES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList values_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Corresponds to the label values of a reservation resource. This
   * must be the full resource name of the reservation.
   * </pre>
   *
   * <code>
   * repeated string values = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the values.
   */
  public com.google.protobuf.ProtocolStringList getValuesList() {
    return values_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Corresponds to the label values of a reservation resource. This
   * must be the full resource name of the reservation.
   * </pre>
   *
   * <code>
   * repeated string values = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of values.
   */
  public int getValuesCount() {
    return values_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Corresponds to the label values of a reservation resource. This
   * must be the full resource name of the reservation.
   * </pre>
   *
   * <code>
   * repeated string values = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The values at the given index.
   */
  public java.lang.String getValues(int index) {
    return values_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Corresponds to the label values of a reservation resource. This
   * must be the full resource name of the reservation.
   * </pre>
   *
   * <code>
   * repeated string values = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the values at the given index.
   */
  public com.google.protobuf.ByteString getValuesBytes(int index) {
    return values_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (reservationAffinityType_
        != com.google.cloud.vertexai.api.ReservationAffinity.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, reservationAffinityType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, key_);
    }
    for (int i = 0; i < values_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, values_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (reservationAffinityType_
        != com.google.cloud.vertexai.api.ReservationAffinity.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, reservationAffinityType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, key_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < values_.size(); i++) {
        dataSize += computeStringSizeNoTag(values_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getValuesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vertexai.api.ReservationAffinity)) {
      return super.equals(obj);
    }
    com.google.cloud.vertexai.api.ReservationAffinity other =
        (com.google.cloud.vertexai.api.ReservationAffinity) obj;

    if (reservationAffinityType_ != other.reservationAffinityType_) return false;
    if (!getKey().equals(other.getKey())) return false;
    if (!getValuesList().equals(other.getValuesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESERVATION_AFFINITY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + reservationAffinityType_;
    hash = (37 * hash) + KEY_FIELD_NUMBER;
    hash = (53 * hash) + getKey().hashCode();
    if (getValuesCount() > 0) {
      hash = (37 * hash) + VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getValuesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vertexai.api.ReservationAffinity parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.ReservationAffinity parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ReservationAffinity parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.ReservationAffinity parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ReservationAffinity parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.ReservationAffinity parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ReservationAffinity parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.ReservationAffinity parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ReservationAffinity parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.ReservationAffinity parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ReservationAffinity parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.ReservationAffinity parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vertexai.api.ReservationAffinity prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A ReservationAffinity can be used to configure a Vertex AI resource (e.g., a
   * DeployedModel) to draw its Compute Engine resources from a Shared
   * Reservation, or exclusively from on-demand capacity.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vertexai.v1.ReservationAffinity}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.ReservationAffinity)
      com.google.cloud.vertexai.api.ReservationAffinityOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vertexai.api.ReservationAffinityProto
          .internal_static_google_cloud_vertexai_v1_ReservationAffinity_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vertexai.api.ReservationAffinityProto
          .internal_static_google_cloud_vertexai_v1_ReservationAffinity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vertexai.api.ReservationAffinity.class,
              com.google.cloud.vertexai.api.ReservationAffinity.Builder.class);
    }

    // Construct using com.google.cloud.vertexai.api.ReservationAffinity.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      reservationAffinityType_ = 0;
      key_ = "";
      values_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vertexai.api.ReservationAffinityProto
          .internal_static_google_cloud_vertexai_v1_ReservationAffinity_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.ReservationAffinity getDefaultInstanceForType() {
      return com.google.cloud.vertexai.api.ReservationAffinity.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.ReservationAffinity build() {
      com.google.cloud.vertexai.api.ReservationAffinity result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.ReservationAffinity buildPartial() {
      com.google.cloud.vertexai.api.ReservationAffinity result =
          new com.google.cloud.vertexai.api.ReservationAffinity(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.vertexai.api.ReservationAffinity result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.reservationAffinityType_ = reservationAffinityType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.key_ = key_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        values_.makeImmutable();
        result.values_ = values_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vertexai.api.ReservationAffinity) {
        return mergeFrom((com.google.cloud.vertexai.api.ReservationAffinity) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vertexai.api.ReservationAffinity other) {
      if (other == com.google.cloud.vertexai.api.ReservationAffinity.getDefaultInstance())
        return this;
      if (other.reservationAffinityType_ != 0) {
        setReservationAffinityTypeValue(other.getReservationAffinityTypeValue());
      }
      if (!other.getKey().isEmpty()) {
        key_ = other.key_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.values_.isEmpty()) {
        if (values_.isEmpty()) {
          values_ = other.values_;
          bitField0_ |= 0x00000004;
        } else {
          ensureValuesIsMutable();
          values_.addAll(other.values_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                reservationAffinityType_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                key_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureValuesIsMutable();
                values_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int reservationAffinityType_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Specifies the reservation affinity type.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ReservationAffinity.Type reservation_affinity_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for reservationAffinityType.
     */
    @java.lang.Override
    public int getReservationAffinityTypeValue() {
      return reservationAffinityType_;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies the reservation affinity type.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ReservationAffinity.Type reservation_affinity_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for reservationAffinityType to set.
     * @return This builder for chaining.
     */
    public Builder setReservationAffinityTypeValue(int value) {
      reservationAffinityType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies the reservation affinity type.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ReservationAffinity.Type reservation_affinity_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The reservationAffinityType.
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.ReservationAffinity.Type getReservationAffinityType() {
      com.google.cloud.vertexai.api.ReservationAffinity.Type result =
          com.google.cloud.vertexai.api.ReservationAffinity.Type.forNumber(
              reservationAffinityType_);
      return result == null
          ? com.google.cloud.vertexai.api.ReservationAffinity.Type.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies the reservation affinity type.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ReservationAffinity.Type reservation_affinity_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The reservationAffinityType to set.
     * @return This builder for chaining.
     */
    public Builder setReservationAffinityType(
        com.google.cloud.vertexai.api.ReservationAffinity.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      reservationAffinityType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies the reservation affinity type.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.ReservationAffinity.Type reservation_affinity_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReservationAffinityType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      reservationAffinityType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object key_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Corresponds to the label key of a reservation resource. To target
     * a SPECIFIC_RESERVATION by name, use
     * `compute.googleapis.com/reservation-name` as the key and specify the name
     * of your reservation as its value.
     * </pre>
     *
     * <code>string key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The key.
     */
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Corresponds to the label key of a reservation resource. To target
     * a SPECIFIC_RESERVATION by name, use
     * `compute.googleapis.com/reservation-name` as the key and specify the name
     * of your reservation as its value.
     * </pre>
     *
     * <code>string key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for key.
     */
    public com.google.protobuf.ByteString getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Corresponds to the label key of a reservation resource. To target
     * a SPECIFIC_RESERVATION by name, use
     * `compute.googleapis.com/reservation-name` as the key and specify the name
     * of your reservation as its value.
     * </pre>
     *
     * <code>string key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The key to set.
     * @return This builder for chaining.
     */
    public Builder setKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      key_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Corresponds to the label key of a reservation resource. To target
     * a SPECIFIC_RESERVATION by name, use
     * `compute.googleapis.com/reservation-name` as the key and specify the name
     * of your reservation as its value.
     * </pre>
     *
     * <code>string key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKey() {
      key_ = getDefaultInstance().getKey();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Corresponds to the label key of a reservation resource. To target
     * a SPECIFIC_RESERVATION by name, use
     * `compute.googleapis.com/reservation-name` as the key and specify the name
     * of your reservation as its value.
     * </pre>
     *
     * <code>string key = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for key to set.
     * @return This builder for chaining.
     */
    public Builder setKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      key_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList values_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureValuesIsMutable() {
      if (!values_.isModifiable()) {
        values_ = new com.google.protobuf.LazyStringArrayList(values_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Optional. Corresponds to the label values of a reservation resource. This
     * must be the full resource name of the reservation.
     * </pre>
     *
     * <code>
     * repeated string values = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the values.
     */
    public com.google.protobuf.ProtocolStringList getValuesList() {
      values_.makeImmutable();
      return values_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Corresponds to the label values of a reservation resource. This
     * must be the full resource name of the reservation.
     * </pre>
     *
     * <code>
     * repeated string values = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of values.
     */
    public int getValuesCount() {
      return values_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Corresponds to the label values of a reservation resource. This
     * must be the full resource name of the reservation.
     * </pre>
     *
     * <code>
     * repeated string values = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The values at the given index.
     */
    public java.lang.String getValues(int index) {
      return values_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Corresponds to the label values of a reservation resource. This
     * must be the full resource name of the reservation.
     * </pre>
     *
     * <code>
     * repeated string values = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the values at the given index.
     */
    public com.google.protobuf.ByteString getValuesBytes(int index) {
      return values_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Corresponds to the label values of a reservation resource. This
     * must be the full resource name of the reservation.
     * </pre>
     *
     * <code>
     * repeated string values = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The values to set.
     * @return This builder for chaining.
     */
    public Builder setValues(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureValuesIsMutable();
      values_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Corresponds to the label values of a reservation resource. This
     * must be the full resource name of the reservation.
     * </pre>
     *
     * <code>
     * repeated string values = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The values to add.
     * @return This builder for chaining.
     */
    public Builder addValues(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureValuesIsMutable();
      values_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Corresponds to the label values of a reservation resource. This
     * must be the full resource name of the reservation.
     * </pre>
     *
     * <code>
     * repeated string values = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The values to add.
     * @return This builder for chaining.
     */
    public Builder addAllValues(java.lang.Iterable<java.lang.String> values) {
      ensureValuesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Corresponds to the label values of a reservation resource. This
     * must be the full resource name of the reservation.
     * </pre>
     *
     * <code>
     * repeated string values = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValues() {
      values_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Corresponds to the label values of a reservation resource. This
     * must be the full resource name of the reservation.
     * </pre>
     *
     * <code>
     * repeated string values = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the values to add.
     * @return This builder for chaining.
     */
    public Builder addValuesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureValuesIsMutable();
      values_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.ReservationAffinity)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.ReservationAffinity)
  private static final com.google.cloud.vertexai.api.ReservationAffinity DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vertexai.api.ReservationAffinity();
  }

  public static com.google.cloud.vertexai.api.ReservationAffinity getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReservationAffinity> PARSER =
      new com.google.protobuf.AbstractParser<ReservationAffinity>() {
        @java.lang.Override
        public ReservationAffinity parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReservationAffinity> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReservationAffinity> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vertexai.api.ReservationAffinity getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
