/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vertexai/v1/explanation.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.vertexai.api;

/**
 *
 *
 * <pre>
 * Config for SmoothGrad approximation of gradients.
 *
 * When enabled, the gradients are approximated by averaging the gradients from
 * noisy samples in the vicinity of the inputs. Adding noise can help improve
 * the computed gradients. Refer to this paper for more details:
 * https://arxiv.org/pdf/1706.03825.pdf
 * </pre>
 *
 * Protobuf type {@code google.cloud.vertexai.v1.SmoothGradConfig}
 */
public final class SmoothGradConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.SmoothGradConfig)
    SmoothGradConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SmoothGradConfig.newBuilder() to construct.
  private SmoothGradConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SmoothGradConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SmoothGradConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vertexai.api.ExplanationProto
        .internal_static_google_cloud_vertexai_v1_SmoothGradConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vertexai.api.ExplanationProto
        .internal_static_google_cloud_vertexai_v1_SmoothGradConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vertexai.api.SmoothGradConfig.class,
            com.google.cloud.vertexai.api.SmoothGradConfig.Builder.class);
  }

  private int gradientNoiseSigmaCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object gradientNoiseSigma_;

  public enum GradientNoiseSigmaCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    NOISE_SIGMA(1),
    FEATURE_NOISE_SIGMA(2),
    GRADIENTNOISESIGMA_NOT_SET(0);
    private final int value;

    private GradientNoiseSigmaCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static GradientNoiseSigmaCase valueOf(int value) {
      return forNumber(value);
    }

    public static GradientNoiseSigmaCase forNumber(int value) {
      switch (value) {
        case 1:
          return NOISE_SIGMA;
        case 2:
          return FEATURE_NOISE_SIGMA;
        case 0:
          return GRADIENTNOISESIGMA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public GradientNoiseSigmaCase getGradientNoiseSigmaCase() {
    return GradientNoiseSigmaCase.forNumber(gradientNoiseSigmaCase_);
  }

  public static final int NOISE_SIGMA_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * This is a single float value and will be used to add noise to all the
   * features. Use this field when all features are normalized to have the
   * same distribution: scale to range [0, 1], [-1, 1] or z-scoring, where
   * features are normalized to have 0-mean and 1-variance. Learn more about
   * [normalization](https://developers.google.com/machine-learning/data-prep/transform/normalization).
   *
   * For best results the recommended value is about 10% - 20% of the standard
   * deviation of the input feature. Refer to section 3.2 of the SmoothGrad
   * paper: https://arxiv.org/pdf/1706.03825.pdf. Defaults to 0.1.
   *
   * If the distribution is different per feature, set
   * [feature_noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.feature_noise_sigma]
   * instead for each feature.
   * </pre>
   *
   * <code>float noise_sigma = 1;</code>
   *
   * @return Whether the noiseSigma field is set.
   */
  @java.lang.Override
  public boolean hasNoiseSigma() {
    return gradientNoiseSigmaCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * This is a single float value and will be used to add noise to all the
   * features. Use this field when all features are normalized to have the
   * same distribution: scale to range [0, 1], [-1, 1] or z-scoring, where
   * features are normalized to have 0-mean and 1-variance. Learn more about
   * [normalization](https://developers.google.com/machine-learning/data-prep/transform/normalization).
   *
   * For best results the recommended value is about 10% - 20% of the standard
   * deviation of the input feature. Refer to section 3.2 of the SmoothGrad
   * paper: https://arxiv.org/pdf/1706.03825.pdf. Defaults to 0.1.
   *
   * If the distribution is different per feature, set
   * [feature_noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.feature_noise_sigma]
   * instead for each feature.
   * </pre>
   *
   * <code>float noise_sigma = 1;</code>
   *
   * @return The noiseSigma.
   */
  @java.lang.Override
  public float getNoiseSigma() {
    if (gradientNoiseSigmaCase_ == 1) {
      return (java.lang.Float) gradientNoiseSigma_;
    }
    return 0F;
  }

  public static final int FEATURE_NOISE_SIGMA_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * This is similar to
   * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma],
   * but provides additional flexibility. A separate noise sigma can be
   * provided for each feature, which is useful if their distributions are
   * different. No noise is added to features that are not set. If this field
   * is unset,
   * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
   * will be used for all features.
   * </pre>
   *
   * <code>.google.cloud.vertexai.v1.FeatureNoiseSigma feature_noise_sigma = 2;</code>
   *
   * @return Whether the featureNoiseSigma field is set.
   */
  @java.lang.Override
  public boolean hasFeatureNoiseSigma() {
    return gradientNoiseSigmaCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * This is similar to
   * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma],
   * but provides additional flexibility. A separate noise sigma can be
   * provided for each feature, which is useful if their distributions are
   * different. No noise is added to features that are not set. If this field
   * is unset,
   * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
   * will be used for all features.
   * </pre>
   *
   * <code>.google.cloud.vertexai.v1.FeatureNoiseSigma feature_noise_sigma = 2;</code>
   *
   * @return The featureNoiseSigma.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.FeatureNoiseSigma getFeatureNoiseSigma() {
    if (gradientNoiseSigmaCase_ == 2) {
      return (com.google.cloud.vertexai.api.FeatureNoiseSigma) gradientNoiseSigma_;
    }
    return com.google.cloud.vertexai.api.FeatureNoiseSigma.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * This is similar to
   * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma],
   * but provides additional flexibility. A separate noise sigma can be
   * provided for each feature, which is useful if their distributions are
   * different. No noise is added to features that are not set. If this field
   * is unset,
   * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
   * will be used for all features.
   * </pre>
   *
   * <code>.google.cloud.vertexai.v1.FeatureNoiseSigma feature_noise_sigma = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.FeatureNoiseSigmaOrBuilder getFeatureNoiseSigmaOrBuilder() {
    if (gradientNoiseSigmaCase_ == 2) {
      return (com.google.cloud.vertexai.api.FeatureNoiseSigma) gradientNoiseSigma_;
    }
    return com.google.cloud.vertexai.api.FeatureNoiseSigma.getDefaultInstance();
  }

  public static final int NOISY_SAMPLE_COUNT_FIELD_NUMBER = 3;
  private int noisySampleCount_ = 0;
  /**
   *
   *
   * <pre>
   * The number of gradient samples to use for
   * approximation. The higher this number, the more accurate the gradient
   * is, but the runtime complexity increases by this factor as well.
   * Valid range of its value is [1, 50]. Defaults to 3.
   * </pre>
   *
   * <code>int32 noisy_sample_count = 3;</code>
   *
   * @return The noisySampleCount.
   */
  @java.lang.Override
  public int getNoisySampleCount() {
    return noisySampleCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (gradientNoiseSigmaCase_ == 1) {
      output.writeFloat(1, (float) ((java.lang.Float) gradientNoiseSigma_));
    }
    if (gradientNoiseSigmaCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.vertexai.api.FeatureNoiseSigma) gradientNoiseSigma_);
    }
    if (noisySampleCount_ != 0) {
      output.writeInt32(3, noisySampleCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (gradientNoiseSigmaCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeFloatSize(
              1, (float) ((java.lang.Float) gradientNoiseSigma_));
    }
    if (gradientNoiseSigmaCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.vertexai.api.FeatureNoiseSigma) gradientNoiseSigma_);
    }
    if (noisySampleCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, noisySampleCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vertexai.api.SmoothGradConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.vertexai.api.SmoothGradConfig other =
        (com.google.cloud.vertexai.api.SmoothGradConfig) obj;

    if (getNoisySampleCount() != other.getNoisySampleCount()) return false;
    if (!getGradientNoiseSigmaCase().equals(other.getGradientNoiseSigmaCase())) return false;
    switch (gradientNoiseSigmaCase_) {
      case 1:
        if (java.lang.Float.floatToIntBits(getNoiseSigma())
            != java.lang.Float.floatToIntBits(other.getNoiseSigma())) return false;
        break;
      case 2:
        if (!getFeatureNoiseSigma().equals(other.getFeatureNoiseSigma())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NOISY_SAMPLE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getNoisySampleCount();
    switch (gradientNoiseSigmaCase_) {
      case 1:
        hash = (37 * hash) + NOISE_SIGMA_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getNoiseSigma());
        break;
      case 2:
        hash = (37 * hash) + FEATURE_NOISE_SIGMA_FIELD_NUMBER;
        hash = (53 * hash) + getFeatureNoiseSigma().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vertexai.api.SmoothGradConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.SmoothGradConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.SmoothGradConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.SmoothGradConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.SmoothGradConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.SmoothGradConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.SmoothGradConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.SmoothGradConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.SmoothGradConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.SmoothGradConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.SmoothGradConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.SmoothGradConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vertexai.api.SmoothGradConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Config for SmoothGrad approximation of gradients.
   *
   * When enabled, the gradients are approximated by averaging the gradients from
   * noisy samples in the vicinity of the inputs. Adding noise can help improve
   * the computed gradients. Refer to this paper for more details:
   * https://arxiv.org/pdf/1706.03825.pdf
   * </pre>
   *
   * Protobuf type {@code google.cloud.vertexai.v1.SmoothGradConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.SmoothGradConfig)
      com.google.cloud.vertexai.api.SmoothGradConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vertexai.api.ExplanationProto
          .internal_static_google_cloud_vertexai_v1_SmoothGradConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vertexai.api.ExplanationProto
          .internal_static_google_cloud_vertexai_v1_SmoothGradConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vertexai.api.SmoothGradConfig.class,
              com.google.cloud.vertexai.api.SmoothGradConfig.Builder.class);
    }

    // Construct using com.google.cloud.vertexai.api.SmoothGradConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (featureNoiseSigmaBuilder_ != null) {
        featureNoiseSigmaBuilder_.clear();
      }
      noisySampleCount_ = 0;
      gradientNoiseSigmaCase_ = 0;
      gradientNoiseSigma_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vertexai.api.ExplanationProto
          .internal_static_google_cloud_vertexai_v1_SmoothGradConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.SmoothGradConfig getDefaultInstanceForType() {
      return com.google.cloud.vertexai.api.SmoothGradConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.SmoothGradConfig build() {
      com.google.cloud.vertexai.api.SmoothGradConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.SmoothGradConfig buildPartial() {
      com.google.cloud.vertexai.api.SmoothGradConfig result =
          new com.google.cloud.vertexai.api.SmoothGradConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.vertexai.api.SmoothGradConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.noisySampleCount_ = noisySampleCount_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.vertexai.api.SmoothGradConfig result) {
      result.gradientNoiseSigmaCase_ = gradientNoiseSigmaCase_;
      result.gradientNoiseSigma_ = this.gradientNoiseSigma_;
      if (gradientNoiseSigmaCase_ == 2 && featureNoiseSigmaBuilder_ != null) {
        result.gradientNoiseSigma_ = featureNoiseSigmaBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vertexai.api.SmoothGradConfig) {
        return mergeFrom((com.google.cloud.vertexai.api.SmoothGradConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vertexai.api.SmoothGradConfig other) {
      if (other == com.google.cloud.vertexai.api.SmoothGradConfig.getDefaultInstance()) return this;
      if (other.getNoisySampleCount() != 0) {
        setNoisySampleCount(other.getNoisySampleCount());
      }
      switch (other.getGradientNoiseSigmaCase()) {
        case NOISE_SIGMA:
          {
            setNoiseSigma(other.getNoiseSigma());
            break;
          }
        case FEATURE_NOISE_SIGMA:
          {
            mergeFeatureNoiseSigma(other.getFeatureNoiseSigma());
            break;
          }
        case GRADIENTNOISESIGMA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 13:
              {
                gradientNoiseSigma_ = input.readFloat();
                gradientNoiseSigmaCase_ = 1;
                break;
              } // case 13
            case 18:
              {
                input.readMessage(
                    getFeatureNoiseSigmaFieldBuilder().getBuilder(), extensionRegistry);
                gradientNoiseSigmaCase_ = 2;
                break;
              } // case 18
            case 24:
              {
                noisySampleCount_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int gradientNoiseSigmaCase_ = 0;
    private java.lang.Object gradientNoiseSigma_;

    public GradientNoiseSigmaCase getGradientNoiseSigmaCase() {
      return GradientNoiseSigmaCase.forNumber(gradientNoiseSigmaCase_);
    }

    public Builder clearGradientNoiseSigma() {
      gradientNoiseSigmaCase_ = 0;
      gradientNoiseSigma_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * This is a single float value and will be used to add noise to all the
     * features. Use this field when all features are normalized to have the
     * same distribution: scale to range [0, 1], [-1, 1] or z-scoring, where
     * features are normalized to have 0-mean and 1-variance. Learn more about
     * [normalization](https://developers.google.com/machine-learning/data-prep/transform/normalization).
     *
     * For best results the recommended value is about 10% - 20% of the standard
     * deviation of the input feature. Refer to section 3.2 of the SmoothGrad
     * paper: https://arxiv.org/pdf/1706.03825.pdf. Defaults to 0.1.
     *
     * If the distribution is different per feature, set
     * [feature_noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.feature_noise_sigma]
     * instead for each feature.
     * </pre>
     *
     * <code>float noise_sigma = 1;</code>
     *
     * @return Whether the noiseSigma field is set.
     */
    public boolean hasNoiseSigma() {
      return gradientNoiseSigmaCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * This is a single float value and will be used to add noise to all the
     * features. Use this field when all features are normalized to have the
     * same distribution: scale to range [0, 1], [-1, 1] or z-scoring, where
     * features are normalized to have 0-mean and 1-variance. Learn more about
     * [normalization](https://developers.google.com/machine-learning/data-prep/transform/normalization).
     *
     * For best results the recommended value is about 10% - 20% of the standard
     * deviation of the input feature. Refer to section 3.2 of the SmoothGrad
     * paper: https://arxiv.org/pdf/1706.03825.pdf. Defaults to 0.1.
     *
     * If the distribution is different per feature, set
     * [feature_noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.feature_noise_sigma]
     * instead for each feature.
     * </pre>
     *
     * <code>float noise_sigma = 1;</code>
     *
     * @return The noiseSigma.
     */
    public float getNoiseSigma() {
      if (gradientNoiseSigmaCase_ == 1) {
        return (java.lang.Float) gradientNoiseSigma_;
      }
      return 0F;
    }
    /**
     *
     *
     * <pre>
     * This is a single float value and will be used to add noise to all the
     * features. Use this field when all features are normalized to have the
     * same distribution: scale to range [0, 1], [-1, 1] or z-scoring, where
     * features are normalized to have 0-mean and 1-variance. Learn more about
     * [normalization](https://developers.google.com/machine-learning/data-prep/transform/normalization).
     *
     * For best results the recommended value is about 10% - 20% of the standard
     * deviation of the input feature. Refer to section 3.2 of the SmoothGrad
     * paper: https://arxiv.org/pdf/1706.03825.pdf. Defaults to 0.1.
     *
     * If the distribution is different per feature, set
     * [feature_noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.feature_noise_sigma]
     * instead for each feature.
     * </pre>
     *
     * <code>float noise_sigma = 1;</code>
     *
     * @param value The noiseSigma to set.
     * @return This builder for chaining.
     */
    public Builder setNoiseSigma(float value) {

      gradientNoiseSigmaCase_ = 1;
      gradientNoiseSigma_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is a single float value and will be used to add noise to all the
     * features. Use this field when all features are normalized to have the
     * same distribution: scale to range [0, 1], [-1, 1] or z-scoring, where
     * features are normalized to have 0-mean and 1-variance. Learn more about
     * [normalization](https://developers.google.com/machine-learning/data-prep/transform/normalization).
     *
     * For best results the recommended value is about 10% - 20% of the standard
     * deviation of the input feature. Refer to section 3.2 of the SmoothGrad
     * paper: https://arxiv.org/pdf/1706.03825.pdf. Defaults to 0.1.
     *
     * If the distribution is different per feature, set
     * [feature_noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.feature_noise_sigma]
     * instead for each feature.
     * </pre>
     *
     * <code>float noise_sigma = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNoiseSigma() {
      if (gradientNoiseSigmaCase_ == 1) {
        gradientNoiseSigmaCase_ = 0;
        gradientNoiseSigma_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.FeatureNoiseSigma,
            com.google.cloud.vertexai.api.FeatureNoiseSigma.Builder,
            com.google.cloud.vertexai.api.FeatureNoiseSigmaOrBuilder>
        featureNoiseSigmaBuilder_;
    /**
     *
     *
     * <pre>
     * This is similar to
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma],
     * but provides additional flexibility. A separate noise sigma can be
     * provided for each feature, which is useful if their distributions are
     * different. No noise is added to features that are not set. If this field
     * is unset,
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
     * will be used for all features.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.FeatureNoiseSigma feature_noise_sigma = 2;</code>
     *
     * @return Whether the featureNoiseSigma field is set.
     */
    @java.lang.Override
    public boolean hasFeatureNoiseSigma() {
      return gradientNoiseSigmaCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * This is similar to
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma],
     * but provides additional flexibility. A separate noise sigma can be
     * provided for each feature, which is useful if their distributions are
     * different. No noise is added to features that are not set. If this field
     * is unset,
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
     * will be used for all features.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.FeatureNoiseSigma feature_noise_sigma = 2;</code>
     *
     * @return The featureNoiseSigma.
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.FeatureNoiseSigma getFeatureNoiseSigma() {
      if (featureNoiseSigmaBuilder_ == null) {
        if (gradientNoiseSigmaCase_ == 2) {
          return (com.google.cloud.vertexai.api.FeatureNoiseSigma) gradientNoiseSigma_;
        }
        return com.google.cloud.vertexai.api.FeatureNoiseSigma.getDefaultInstance();
      } else {
        if (gradientNoiseSigmaCase_ == 2) {
          return featureNoiseSigmaBuilder_.getMessage();
        }
        return com.google.cloud.vertexai.api.FeatureNoiseSigma.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * This is similar to
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma],
     * but provides additional flexibility. A separate noise sigma can be
     * provided for each feature, which is useful if their distributions are
     * different. No noise is added to features that are not set. If this field
     * is unset,
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
     * will be used for all features.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.FeatureNoiseSigma feature_noise_sigma = 2;</code>
     */
    public Builder setFeatureNoiseSigma(com.google.cloud.vertexai.api.FeatureNoiseSigma value) {
      if (featureNoiseSigmaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gradientNoiseSigma_ = value;
        onChanged();
      } else {
        featureNoiseSigmaBuilder_.setMessage(value);
      }
      gradientNoiseSigmaCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is similar to
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma],
     * but provides additional flexibility. A separate noise sigma can be
     * provided for each feature, which is useful if their distributions are
     * different. No noise is added to features that are not set. If this field
     * is unset,
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
     * will be used for all features.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.FeatureNoiseSigma feature_noise_sigma = 2;</code>
     */
    public Builder setFeatureNoiseSigma(
        com.google.cloud.vertexai.api.FeatureNoiseSigma.Builder builderForValue) {
      if (featureNoiseSigmaBuilder_ == null) {
        gradientNoiseSigma_ = builderForValue.build();
        onChanged();
      } else {
        featureNoiseSigmaBuilder_.setMessage(builderForValue.build());
      }
      gradientNoiseSigmaCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is similar to
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma],
     * but provides additional flexibility. A separate noise sigma can be
     * provided for each feature, which is useful if their distributions are
     * different. No noise is added to features that are not set. If this field
     * is unset,
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
     * will be used for all features.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.FeatureNoiseSigma feature_noise_sigma = 2;</code>
     */
    public Builder mergeFeatureNoiseSigma(com.google.cloud.vertexai.api.FeatureNoiseSigma value) {
      if (featureNoiseSigmaBuilder_ == null) {
        if (gradientNoiseSigmaCase_ == 2
            && gradientNoiseSigma_
                != com.google.cloud.vertexai.api.FeatureNoiseSigma.getDefaultInstance()) {
          gradientNoiseSigma_ =
              com.google.cloud.vertexai.api.FeatureNoiseSigma.newBuilder(
                      (com.google.cloud.vertexai.api.FeatureNoiseSigma) gradientNoiseSigma_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          gradientNoiseSigma_ = value;
        }
        onChanged();
      } else {
        if (gradientNoiseSigmaCase_ == 2) {
          featureNoiseSigmaBuilder_.mergeFrom(value);
        } else {
          featureNoiseSigmaBuilder_.setMessage(value);
        }
      }
      gradientNoiseSigmaCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is similar to
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma],
     * but provides additional flexibility. A separate noise sigma can be
     * provided for each feature, which is useful if their distributions are
     * different. No noise is added to features that are not set. If this field
     * is unset,
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
     * will be used for all features.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.FeatureNoiseSigma feature_noise_sigma = 2;</code>
     */
    public Builder clearFeatureNoiseSigma() {
      if (featureNoiseSigmaBuilder_ == null) {
        if (gradientNoiseSigmaCase_ == 2) {
          gradientNoiseSigmaCase_ = 0;
          gradientNoiseSigma_ = null;
          onChanged();
        }
      } else {
        if (gradientNoiseSigmaCase_ == 2) {
          gradientNoiseSigmaCase_ = 0;
          gradientNoiseSigma_ = null;
        }
        featureNoiseSigmaBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is similar to
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma],
     * but provides additional flexibility. A separate noise sigma can be
     * provided for each feature, which is useful if their distributions are
     * different. No noise is added to features that are not set. If this field
     * is unset,
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
     * will be used for all features.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.FeatureNoiseSigma feature_noise_sigma = 2;</code>
     */
    public com.google.cloud.vertexai.api.FeatureNoiseSigma.Builder getFeatureNoiseSigmaBuilder() {
      return getFeatureNoiseSigmaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * This is similar to
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma],
     * but provides additional flexibility. A separate noise sigma can be
     * provided for each feature, which is useful if their distributions are
     * different. No noise is added to features that are not set. If this field
     * is unset,
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
     * will be used for all features.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.FeatureNoiseSigma feature_noise_sigma = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.FeatureNoiseSigmaOrBuilder
        getFeatureNoiseSigmaOrBuilder() {
      if ((gradientNoiseSigmaCase_ == 2) && (featureNoiseSigmaBuilder_ != null)) {
        return featureNoiseSigmaBuilder_.getMessageOrBuilder();
      } else {
        if (gradientNoiseSigmaCase_ == 2) {
          return (com.google.cloud.vertexai.api.FeatureNoiseSigma) gradientNoiseSigma_;
        }
        return com.google.cloud.vertexai.api.FeatureNoiseSigma.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * This is similar to
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma],
     * but provides additional flexibility. A separate noise sigma can be
     * provided for each feature, which is useful if their distributions are
     * different. No noise is added to features that are not set. If this field
     * is unset,
     * [noise_sigma][google.cloud.aiplatform.v1.SmoothGradConfig.noise_sigma]
     * will be used for all features.
     * </pre>
     *
     * <code>.google.cloud.vertexai.v1.FeatureNoiseSigma feature_noise_sigma = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.FeatureNoiseSigma,
            com.google.cloud.vertexai.api.FeatureNoiseSigma.Builder,
            com.google.cloud.vertexai.api.FeatureNoiseSigmaOrBuilder>
        getFeatureNoiseSigmaFieldBuilder() {
      if (featureNoiseSigmaBuilder_ == null) {
        if (!(gradientNoiseSigmaCase_ == 2)) {
          gradientNoiseSigma_ =
              com.google.cloud.vertexai.api.FeatureNoiseSigma.getDefaultInstance();
        }
        featureNoiseSigmaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vertexai.api.FeatureNoiseSigma,
                com.google.cloud.vertexai.api.FeatureNoiseSigma.Builder,
                com.google.cloud.vertexai.api.FeatureNoiseSigmaOrBuilder>(
                (com.google.cloud.vertexai.api.FeatureNoiseSigma) gradientNoiseSigma_,
                getParentForChildren(),
                isClean());
        gradientNoiseSigma_ = null;
      }
      gradientNoiseSigmaCase_ = 2;
      onChanged();
      return featureNoiseSigmaBuilder_;
    }

    private int noisySampleCount_;
    /**
     *
     *
     * <pre>
     * The number of gradient samples to use for
     * approximation. The higher this number, the more accurate the gradient
     * is, but the runtime complexity increases by this factor as well.
     * Valid range of its value is [1, 50]. Defaults to 3.
     * </pre>
     *
     * <code>int32 noisy_sample_count = 3;</code>
     *
     * @return The noisySampleCount.
     */
    @java.lang.Override
    public int getNoisySampleCount() {
      return noisySampleCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of gradient samples to use for
     * approximation. The higher this number, the more accurate the gradient
     * is, but the runtime complexity increases by this factor as well.
     * Valid range of its value is [1, 50]. Defaults to 3.
     * </pre>
     *
     * <code>int32 noisy_sample_count = 3;</code>
     *
     * @param value The noisySampleCount to set.
     * @return This builder for chaining.
     */
    public Builder setNoisySampleCount(int value) {

      noisySampleCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of gradient samples to use for
     * approximation. The higher this number, the more accurate the gradient
     * is, but the runtime complexity increases by this factor as well.
     * Valid range of its value is [1, 50]. Defaults to 3.
     * </pre>
     *
     * <code>int32 noisy_sample_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNoisySampleCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      noisySampleCount_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.SmoothGradConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.SmoothGradConfig)
  private static final com.google.cloud.vertexai.api.SmoothGradConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vertexai.api.SmoothGradConfig();
  }

  public static com.google.cloud.vertexai.api.SmoothGradConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SmoothGradConfig> PARSER =
      new com.google.protobuf.AbstractParser<SmoothGradConfig>() {
        @java.lang.Override
        public SmoothGradConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SmoothGradConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SmoothGradConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vertexai.api.SmoothGradConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
