/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vertexai/v1/llm_utility_service.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.vertexai.api;

/**
 *
 *
 * <pre>
 * Tokens info with a list of tokens and the corresponding list of token ids.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vertexai.v1.TokensInfo}
 */
public final class TokensInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.TokensInfo)
    TokensInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TokensInfo.newBuilder() to construct.
  private TokensInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TokensInfo() {
    tokens_ = emptyList(com.google.protobuf.ByteString.class);
    tokenIds_ = emptyLongList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TokensInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vertexai.api.LlmUtilityServiceProto
        .internal_static_google_cloud_vertexai_v1_TokensInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vertexai.api.LlmUtilityServiceProto
        .internal_static_google_cloud_vertexai_v1_TokensInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vertexai.api.TokensInfo.class,
            com.google.cloud.vertexai.api.TokensInfo.Builder.class);
  }

  public static final int TOKENS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.ProtobufList<com.google.protobuf.ByteString> tokens_ =
      emptyList(com.google.protobuf.ByteString.class);
  /**
   *
   *
   * <pre>
   * A list of tokens from the input.
   * </pre>
   *
   * <code>repeated bytes tokens = 1;</code>
   *
   * @return A list containing the tokens.
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.ByteString> getTokensList() {
    return tokens_;
  }
  /**
   *
   *
   * <pre>
   * A list of tokens from the input.
   * </pre>
   *
   * <code>repeated bytes tokens = 1;</code>
   *
   * @return The count of tokens.
   */
  public int getTokensCount() {
    return tokens_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of tokens from the input.
   * </pre>
   *
   * <code>repeated bytes tokens = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The tokens at the given index.
   */
  public com.google.protobuf.ByteString getTokens(int index) {
    return tokens_.get(index);
  }

  public static final int TOKEN_IDS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.LongList tokenIds_ = emptyLongList();
  /**
   *
   *
   * <pre>
   * A list of token ids from the input.
   * </pre>
   *
   * <code>repeated int64 token_ids = 2;</code>
   *
   * @return A list containing the tokenIds.
   */
  @java.lang.Override
  public java.util.List<java.lang.Long> getTokenIdsList() {
    return tokenIds_;
  }
  /**
   *
   *
   * <pre>
   * A list of token ids from the input.
   * </pre>
   *
   * <code>repeated int64 token_ids = 2;</code>
   *
   * @return The count of tokenIds.
   */
  public int getTokenIdsCount() {
    return tokenIds_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of token ids from the input.
   * </pre>
   *
   * <code>repeated int64 token_ids = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The tokenIds at the given index.
   */
  public long getTokenIds(int index) {
    return tokenIds_.getLong(index);
  }

  private int tokenIdsMemoizedSerializedSize = -1;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    for (int i = 0; i < tokens_.size(); i++) {
      output.writeBytes(1, tokens_.get(i));
    }
    if (getTokenIdsList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(tokenIdsMemoizedSerializedSize);
    }
    for (int i = 0; i < tokenIds_.size(); i++) {
      output.writeInt64NoTag(tokenIds_.getLong(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < tokens_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeBytesSizeNoTag(tokens_.get(i));
      }
      size += dataSize;
      size += 1 * getTokensList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tokenIds_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt64SizeNoTag(tokenIds_.getLong(i));
      }
      size += dataSize;
      if (!getTokenIdsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      tokenIdsMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vertexai.api.TokensInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.vertexai.api.TokensInfo other = (com.google.cloud.vertexai.api.TokensInfo) obj;

    if (!getTokensList().equals(other.getTokensList())) return false;
    if (!getTokenIdsList().equals(other.getTokenIdsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getTokensCount() > 0) {
      hash = (37 * hash) + TOKENS_FIELD_NUMBER;
      hash = (53 * hash) + getTokensList().hashCode();
    }
    if (getTokenIdsCount() > 0) {
      hash = (37 * hash) + TOKEN_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getTokenIdsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vertexai.api.TokensInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.TokensInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.TokensInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.TokensInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.TokensInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.TokensInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.TokensInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.TokensInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.TokensInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.TokensInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.TokensInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.TokensInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vertexai.api.TokensInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Tokens info with a list of tokens and the corresponding list of token ids.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vertexai.v1.TokensInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.TokensInfo)
      com.google.cloud.vertexai.api.TokensInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vertexai.api.LlmUtilityServiceProto
          .internal_static_google_cloud_vertexai_v1_TokensInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vertexai.api.LlmUtilityServiceProto
          .internal_static_google_cloud_vertexai_v1_TokensInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vertexai.api.TokensInfo.class,
              com.google.cloud.vertexai.api.TokensInfo.Builder.class);
    }

    // Construct using com.google.cloud.vertexai.api.TokensInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      tokens_ = emptyList(com.google.protobuf.ByteString.class);
      tokenIds_ = emptyLongList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vertexai.api.LlmUtilityServiceProto
          .internal_static_google_cloud_vertexai_v1_TokensInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.TokensInfo getDefaultInstanceForType() {
      return com.google.cloud.vertexai.api.TokensInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.TokensInfo build() {
      com.google.cloud.vertexai.api.TokensInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.TokensInfo buildPartial() {
      com.google.cloud.vertexai.api.TokensInfo result =
          new com.google.cloud.vertexai.api.TokensInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.vertexai.api.TokensInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        tokens_.makeImmutable();
        result.tokens_ = tokens_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        tokenIds_.makeImmutable();
        result.tokenIds_ = tokenIds_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vertexai.api.TokensInfo) {
        return mergeFrom((com.google.cloud.vertexai.api.TokensInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vertexai.api.TokensInfo other) {
      if (other == com.google.cloud.vertexai.api.TokensInfo.getDefaultInstance()) return this;
      if (!other.tokens_.isEmpty()) {
        if (tokens_.isEmpty()) {
          tokens_ = other.tokens_;
          tokens_.makeImmutable();
          bitField0_ |= 0x00000001;
        } else {
          ensureTokensIsMutable();
          tokens_.addAll(other.tokens_);
        }
        onChanged();
      }
      if (!other.tokenIds_.isEmpty()) {
        if (tokenIds_.isEmpty()) {
          tokenIds_ = other.tokenIds_;
          tokenIds_.makeImmutable();
          bitField0_ |= 0x00000002;
        } else {
          ensureTokenIdsIsMutable();
          tokenIds_.addAll(other.tokenIds_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.ByteString v = input.readBytes();
                ensureTokensIsMutable();
                tokens_.add(v);
                break;
              } // case 10
            case 16:
              {
                long v = input.readInt64();
                ensureTokenIdsIsMutable();
                tokenIds_.addLong(v);
                break;
              } // case 16
            case 18:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureTokenIdsIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  tokenIds_.addLong(input.readInt64());
                }
                input.popLimit(limit);
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Internal.ProtobufList<com.google.protobuf.ByteString> tokens_ =
        emptyList(com.google.protobuf.ByteString.class);

    private void ensureTokensIsMutable() {
      if (!tokens_.isModifiable()) {
        tokens_ = makeMutableCopy(tokens_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * A list of tokens from the input.
     * </pre>
     *
     * <code>repeated bytes tokens = 1;</code>
     *
     * @return A list containing the tokens.
     */
    public java.util.List<com.google.protobuf.ByteString> getTokensList() {
      tokens_.makeImmutable();
      return tokens_;
    }
    /**
     *
     *
     * <pre>
     * A list of tokens from the input.
     * </pre>
     *
     * <code>repeated bytes tokens = 1;</code>
     *
     * @return The count of tokens.
     */
    public int getTokensCount() {
      return tokens_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of tokens from the input.
     * </pre>
     *
     * <code>repeated bytes tokens = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The tokens at the given index.
     */
    public com.google.protobuf.ByteString getTokens(int index) {
      return tokens_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of tokens from the input.
     * </pre>
     *
     * <code>repeated bytes tokens = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The tokens to set.
     * @return This builder for chaining.
     */
    public Builder setTokens(int index, com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTokensIsMutable();
      tokens_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tokens from the input.
     * </pre>
     *
     * <code>repeated bytes tokens = 1;</code>
     *
     * @param value The tokens to add.
     * @return This builder for chaining.
     */
    public Builder addTokens(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTokensIsMutable();
      tokens_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tokens from the input.
     * </pre>
     *
     * <code>repeated bytes tokens = 1;</code>
     *
     * @param values The tokens to add.
     * @return This builder for chaining.
     */
    public Builder addAllTokens(
        java.lang.Iterable<? extends com.google.protobuf.ByteString> values) {
      ensureTokensIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tokens_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tokens from the input.
     * </pre>
     *
     * <code>repeated bytes tokens = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTokens() {
      tokens_ = emptyList(com.google.protobuf.ByteString.class);
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.LongList tokenIds_ = emptyLongList();

    private void ensureTokenIdsIsMutable() {
      if (!tokenIds_.isModifiable()) {
        tokenIds_ = makeMutableCopy(tokenIds_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * A list of token ids from the input.
     * </pre>
     *
     * <code>repeated int64 token_ids = 2;</code>
     *
     * @return A list containing the tokenIds.
     */
    public java.util.List<java.lang.Long> getTokenIdsList() {
      tokenIds_.makeImmutable();
      return tokenIds_;
    }
    /**
     *
     *
     * <pre>
     * A list of token ids from the input.
     * </pre>
     *
     * <code>repeated int64 token_ids = 2;</code>
     *
     * @return The count of tokenIds.
     */
    public int getTokenIdsCount() {
      return tokenIds_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of token ids from the input.
     * </pre>
     *
     * <code>repeated int64 token_ids = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The tokenIds at the given index.
     */
    public long getTokenIds(int index) {
      return tokenIds_.getLong(index);
    }
    /**
     *
     *
     * <pre>
     * A list of token ids from the input.
     * </pre>
     *
     * <code>repeated int64 token_ids = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The tokenIds to set.
     * @return This builder for chaining.
     */
    public Builder setTokenIds(int index, long value) {

      ensureTokenIdsIsMutable();
      tokenIds_.setLong(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of token ids from the input.
     * </pre>
     *
     * <code>repeated int64 token_ids = 2;</code>
     *
     * @param value The tokenIds to add.
     * @return This builder for chaining.
     */
    public Builder addTokenIds(long value) {

      ensureTokenIdsIsMutable();
      tokenIds_.addLong(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of token ids from the input.
     * </pre>
     *
     * <code>repeated int64 token_ids = 2;</code>
     *
     * @param values The tokenIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllTokenIds(java.lang.Iterable<? extends java.lang.Long> values) {
      ensureTokenIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tokenIds_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of token ids from the input.
     * </pre>
     *
     * <code>repeated int64 token_ids = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTokenIds() {
      tokenIds_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.TokensInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.TokensInfo)
  private static final com.google.cloud.vertexai.api.TokensInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vertexai.api.TokensInfo();
  }

  public static com.google.cloud.vertexai.api.TokensInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TokensInfo> PARSER =
      new com.google.protobuf.AbstractParser<TokensInfo>() {
        @java.lang.Override
        public TokensInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TokensInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TokensInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vertexai.api.TokensInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
