/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vertexai/v1/content.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.vertexai.api;

/**
 *
 *
 * <pre>
 * A response candidate generated from the model.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vertexai.v1.Candidate}
 */
public final class Candidate extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.Candidate)
    CandidateOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Candidate.newBuilder() to construct.
  private Candidate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Candidate() {
    finishReason_ = 0;
    safetyRatings_ = java.util.Collections.emptyList();
    finishMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Candidate();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vertexai.api.ContentProto
        .internal_static_google_cloud_vertexai_v1_Candidate_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vertexai.api.ContentProto
        .internal_static_google_cloud_vertexai_v1_Candidate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vertexai.api.Candidate.class,
            com.google.cloud.vertexai.api.Candidate.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The reason why the model stopped generating tokens.
   * If empty, the model has not stopped generating the tokens.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.vertexai.v1.Candidate.FinishReason}
   */
  public enum FinishReason implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The finish reason is unspecified.
     * </pre>
     *
     * <code>FINISH_REASON_UNSPECIFIED = 0;</code>
     */
    FINISH_REASON_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Natural stop point of the model or provided stop sequence.
     * </pre>
     *
     * <code>STOP = 1;</code>
     */
    STOP(1),
    /**
     *
     *
     * <pre>
     * The maximum number of tokens as specified in the request was reached.
     * </pre>
     *
     * <code>MAX_TOKENS = 2;</code>
     */
    MAX_TOKENS(2),
    /**
     *
     *
     * <pre>
     * The token generation was stopped as the response was flagged for safety
     * reasons. NOTE: When streaming the Candidate.content will be empty if
     * content filters blocked the output.
     * </pre>
     *
     * <code>SAFETY = 3;</code>
     */
    SAFETY(3),
    /**
     *
     *
     * <pre>
     * The token generation was stopped as the response was flagged for
     * unauthorized citations.
     * </pre>
     *
     * <code>RECITATION = 4;</code>
     */
    RECITATION(4),
    /**
     *
     *
     * <pre>
     * All other reasons that stopped the token generation
     * </pre>
     *
     * <code>OTHER = 5;</code>
     */
    OTHER(5),
    /**
     *
     *
     * <pre>
     * The token generation was stopped as the response was flagged for the
     * terms which are included from the terminology blocklist.
     * </pre>
     *
     * <code>BLOCKLIST = 6;</code>
     */
    BLOCKLIST(6),
    /**
     *
     *
     * <pre>
     * The token generation was stopped as the response was flagged for
     * the prohibited contents.
     * </pre>
     *
     * <code>PROHIBITED_CONTENT = 7;</code>
     */
    PROHIBITED_CONTENT(7),
    /**
     *
     *
     * <pre>
     * The token generation was stopped as the response was flagged for
     * Sensitive Personally Identifiable Information (SPII) contents.
     * </pre>
     *
     * <code>SPII = 8;</code>
     */
    SPII(8),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The finish reason is unspecified.
     * </pre>
     *
     * <code>FINISH_REASON_UNSPECIFIED = 0;</code>
     */
    public static final int FINISH_REASON_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Natural stop point of the model or provided stop sequence.
     * </pre>
     *
     * <code>STOP = 1;</code>
     */
    public static final int STOP_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The maximum number of tokens as specified in the request was reached.
     * </pre>
     *
     * <code>MAX_TOKENS = 2;</code>
     */
    public static final int MAX_TOKENS_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The token generation was stopped as the response was flagged for safety
     * reasons. NOTE: When streaming the Candidate.content will be empty if
     * content filters blocked the output.
     * </pre>
     *
     * <code>SAFETY = 3;</code>
     */
    public static final int SAFETY_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The token generation was stopped as the response was flagged for
     * unauthorized citations.
     * </pre>
     *
     * <code>RECITATION = 4;</code>
     */
    public static final int RECITATION_VALUE = 4;
    /**
     *
     *
     * <pre>
     * All other reasons that stopped the token generation
     * </pre>
     *
     * <code>OTHER = 5;</code>
     */
    public static final int OTHER_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The token generation was stopped as the response was flagged for the
     * terms which are included from the terminology blocklist.
     * </pre>
     *
     * <code>BLOCKLIST = 6;</code>
     */
    public static final int BLOCKLIST_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The token generation was stopped as the response was flagged for
     * the prohibited contents.
     * </pre>
     *
     * <code>PROHIBITED_CONTENT = 7;</code>
     */
    public static final int PROHIBITED_CONTENT_VALUE = 7;
    /**
     *
     *
     * <pre>
     * The token generation was stopped as the response was flagged for
     * Sensitive Personally Identifiable Information (SPII) contents.
     * </pre>
     *
     * <code>SPII = 8;</code>
     */
    public static final int SPII_VALUE = 8;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FinishReason valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FinishReason forNumber(int value) {
      switch (value) {
        case 0:
          return FINISH_REASON_UNSPECIFIED;
        case 1:
          return STOP;
        case 2:
          return MAX_TOKENS;
        case 3:
          return SAFETY;
        case 4:
          return RECITATION;
        case 5:
          return OTHER;
        case 6:
          return BLOCKLIST;
        case 7:
          return PROHIBITED_CONTENT;
        case 8:
          return SPII;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FinishReason> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<FinishReason> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<FinishReason>() {
          public FinishReason findValueByNumber(int number) {
            return FinishReason.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.vertexai.api.Candidate.getDescriptor().getEnumTypes().get(0);
    }

    private static final FinishReason[] VALUES = values();

    public static FinishReason valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FinishReason(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.vertexai.v1.Candidate.FinishReason)
  }

  private int bitField0_;
  public static final int INDEX_FIELD_NUMBER = 1;
  private int index_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Index of the candidate.
   * </pre>
   *
   * <code>int32 index = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The index.
   */
  @java.lang.Override
  public int getIndex() {
    return index_;
  }

  public static final int CONTENT_FIELD_NUMBER = 2;
  private com.google.cloud.vertexai.api.Content content_;
  /**
   *
   *
   * <pre>
   * Output only. Content parts of the candidate.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.Content content = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the content field is set.
   */
  @java.lang.Override
  public boolean hasContent() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Content parts of the candidate.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.Content content = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The content.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.Content getContent() {
    return content_ == null ? com.google.cloud.vertexai.api.Content.getDefaultInstance() : content_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Content parts of the candidate.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.Content content = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.ContentOrBuilder getContentOrBuilder() {
    return content_ == null ? com.google.cloud.vertexai.api.Content.getDefaultInstance() : content_;
  }

  public static final int FINISH_REASON_FIELD_NUMBER = 3;
  private int finishReason_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The reason why the model stopped generating tokens.
   * If empty, the model has not stopped generating the tokens.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.Candidate.FinishReason finish_reason = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for finishReason.
   */
  @java.lang.Override
  public int getFinishReasonValue() {
    return finishReason_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The reason why the model stopped generating tokens.
   * If empty, the model has not stopped generating the tokens.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.Candidate.FinishReason finish_reason = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The finishReason.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.Candidate.FinishReason getFinishReason() {
    com.google.cloud.vertexai.api.Candidate.FinishReason result =
        com.google.cloud.vertexai.api.Candidate.FinishReason.forNumber(finishReason_);
    return result == null
        ? com.google.cloud.vertexai.api.Candidate.FinishReason.UNRECOGNIZED
        : result;
  }

  public static final int SAFETY_RATINGS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vertexai.api.SafetyRating> safetyRatings_;
  /**
   *
   *
   * <pre>
   * Output only. List of ratings for the safety of a response candidate.
   *
   * There is at most one rating per category.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vertexai.api.SafetyRating> getSafetyRatingsList() {
    return safetyRatings_;
  }
  /**
   *
   *
   * <pre>
   * Output only. List of ratings for the safety of a response candidate.
   *
   * There is at most one rating per category.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vertexai.api.SafetyRatingOrBuilder>
      getSafetyRatingsOrBuilderList() {
    return safetyRatings_;
  }
  /**
   *
   *
   * <pre>
   * Output only. List of ratings for the safety of a response candidate.
   *
   * There is at most one rating per category.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getSafetyRatingsCount() {
    return safetyRatings_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. List of ratings for the safety of a response candidate.
   *
   * There is at most one rating per category.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.SafetyRating getSafetyRatings(int index) {
    return safetyRatings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. List of ratings for the safety of a response candidate.
   *
   * There is at most one rating per category.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.SafetyRatingOrBuilder getSafetyRatingsOrBuilder(int index) {
    return safetyRatings_.get(index);
  }

  public static final int FINISH_MESSAGE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object finishMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Describes the reason the mode stopped generating tokens in
   * more detail. This is only filled when `finish_reason` is set.
   * </pre>
   *
   * <code>optional string finish_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the finishMessage field is set.
   */
  @java.lang.Override
  public boolean hasFinishMessage() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Describes the reason the mode stopped generating tokens in
   * more detail. This is only filled when `finish_reason` is set.
   * </pre>
   *
   * <code>optional string finish_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The finishMessage.
   */
  @java.lang.Override
  public java.lang.String getFinishMessage() {
    java.lang.Object ref = finishMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      finishMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Describes the reason the mode stopped generating tokens in
   * more detail. This is only filled when `finish_reason` is set.
   * </pre>
   *
   * <code>optional string finish_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for finishMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFinishMessageBytes() {
    java.lang.Object ref = finishMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      finishMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CITATION_METADATA_FIELD_NUMBER = 6;
  private com.google.cloud.vertexai.api.CitationMetadata citationMetadata_;
  /**
   *
   *
   * <pre>
   * Output only. Source attribution of the generated content.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.CitationMetadata citation_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the citationMetadata field is set.
   */
  @java.lang.Override
  public boolean hasCitationMetadata() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Source attribution of the generated content.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.CitationMetadata citation_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The citationMetadata.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.CitationMetadata getCitationMetadata() {
    return citationMetadata_ == null
        ? com.google.cloud.vertexai.api.CitationMetadata.getDefaultInstance()
        : citationMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Source attribution of the generated content.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.CitationMetadata citation_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.CitationMetadataOrBuilder getCitationMetadataOrBuilder() {
    return citationMetadata_ == null
        ? com.google.cloud.vertexai.api.CitationMetadata.getDefaultInstance()
        : citationMetadata_;
  }

  public static final int GROUNDING_METADATA_FIELD_NUMBER = 7;
  private com.google.cloud.vertexai.api.GroundingMetadata groundingMetadata_;
  /**
   *
   *
   * <pre>
   * Output only. Metadata specifies sources used to ground generated content.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.GroundingMetadata grounding_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the groundingMetadata field is set.
   */
  @java.lang.Override
  public boolean hasGroundingMetadata() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Metadata specifies sources used to ground generated content.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.GroundingMetadata grounding_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The groundingMetadata.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.GroundingMetadata getGroundingMetadata() {
    return groundingMetadata_ == null
        ? com.google.cloud.vertexai.api.GroundingMetadata.getDefaultInstance()
        : groundingMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Metadata specifies sources used to ground generated content.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.GroundingMetadata grounding_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.GroundingMetadataOrBuilder getGroundingMetadataOrBuilder() {
    return groundingMetadata_ == null
        ? com.google.cloud.vertexai.api.GroundingMetadata.getDefaultInstance()
        : groundingMetadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (index_ != 0) {
      output.writeInt32(1, index_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getContent());
    }
    if (finishReason_
        != com.google.cloud.vertexai.api.Candidate.FinishReason.FINISH_REASON_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, finishReason_);
    }
    for (int i = 0; i < safetyRatings_.size(); i++) {
      output.writeMessage(4, safetyRatings_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, finishMessage_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(6, getCitationMetadata());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(7, getGroundingMetadata());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (index_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, index_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getContent());
    }
    if (finishReason_
        != com.google.cloud.vertexai.api.Candidate.FinishReason.FINISH_REASON_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, finishReason_);
    }
    for (int i = 0; i < safetyRatings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, safetyRatings_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, finishMessage_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCitationMetadata());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getGroundingMetadata());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vertexai.api.Candidate)) {
      return super.equals(obj);
    }
    com.google.cloud.vertexai.api.Candidate other = (com.google.cloud.vertexai.api.Candidate) obj;

    if (getIndex() != other.getIndex()) return false;
    if (hasContent() != other.hasContent()) return false;
    if (hasContent()) {
      if (!getContent().equals(other.getContent())) return false;
    }
    if (finishReason_ != other.finishReason_) return false;
    if (!getSafetyRatingsList().equals(other.getSafetyRatingsList())) return false;
    if (hasFinishMessage() != other.hasFinishMessage()) return false;
    if (hasFinishMessage()) {
      if (!getFinishMessage().equals(other.getFinishMessage())) return false;
    }
    if (hasCitationMetadata() != other.hasCitationMetadata()) return false;
    if (hasCitationMetadata()) {
      if (!getCitationMetadata().equals(other.getCitationMetadata())) return false;
    }
    if (hasGroundingMetadata() != other.hasGroundingMetadata()) return false;
    if (hasGroundingMetadata()) {
      if (!getGroundingMetadata().equals(other.getGroundingMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INDEX_FIELD_NUMBER;
    hash = (53 * hash) + getIndex();
    if (hasContent()) {
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContent().hashCode();
    }
    hash = (37 * hash) + FINISH_REASON_FIELD_NUMBER;
    hash = (53 * hash) + finishReason_;
    if (getSafetyRatingsCount() > 0) {
      hash = (37 * hash) + SAFETY_RATINGS_FIELD_NUMBER;
      hash = (53 * hash) + getSafetyRatingsList().hashCode();
    }
    if (hasFinishMessage()) {
      hash = (37 * hash) + FINISH_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getFinishMessage().hashCode();
    }
    if (hasCitationMetadata()) {
      hash = (37 * hash) + CITATION_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getCitationMetadata().hashCode();
    }
    if (hasGroundingMetadata()) {
      hash = (37 * hash) + GROUNDING_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getGroundingMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vertexai.api.Candidate parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.Candidate parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.Candidate parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.Candidate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.Candidate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.Candidate parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.Candidate parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.Candidate parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.Candidate parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.Candidate parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.Candidate parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.Candidate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vertexai.api.Candidate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A response candidate generated from the model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vertexai.v1.Candidate}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.Candidate)
      com.google.cloud.vertexai.api.CandidateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vertexai.api.ContentProto
          .internal_static_google_cloud_vertexai_v1_Candidate_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vertexai.api.ContentProto
          .internal_static_google_cloud_vertexai_v1_Candidate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vertexai.api.Candidate.class,
              com.google.cloud.vertexai.api.Candidate.Builder.class);
    }

    // Construct using com.google.cloud.vertexai.api.Candidate.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getContentFieldBuilder();
        getSafetyRatingsFieldBuilder();
        getCitationMetadataFieldBuilder();
        getGroundingMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      index_ = 0;
      content_ = null;
      if (contentBuilder_ != null) {
        contentBuilder_.dispose();
        contentBuilder_ = null;
      }
      finishReason_ = 0;
      if (safetyRatingsBuilder_ == null) {
        safetyRatings_ = java.util.Collections.emptyList();
      } else {
        safetyRatings_ = null;
        safetyRatingsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      finishMessage_ = "";
      citationMetadata_ = null;
      if (citationMetadataBuilder_ != null) {
        citationMetadataBuilder_.dispose();
        citationMetadataBuilder_ = null;
      }
      groundingMetadata_ = null;
      if (groundingMetadataBuilder_ != null) {
        groundingMetadataBuilder_.dispose();
        groundingMetadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vertexai.api.ContentProto
          .internal_static_google_cloud_vertexai_v1_Candidate_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.Candidate getDefaultInstanceForType() {
      return com.google.cloud.vertexai.api.Candidate.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.Candidate build() {
      com.google.cloud.vertexai.api.Candidate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.Candidate buildPartial() {
      com.google.cloud.vertexai.api.Candidate result =
          new com.google.cloud.vertexai.api.Candidate(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.vertexai.api.Candidate result) {
      if (safetyRatingsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          safetyRatings_ = java.util.Collections.unmodifiableList(safetyRatings_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.safetyRatings_ = safetyRatings_;
      } else {
        result.safetyRatings_ = safetyRatingsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.vertexai.api.Candidate result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.index_ = index_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.content_ = contentBuilder_ == null ? content_ : contentBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.finishReason_ = finishReason_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.finishMessage_ = finishMessage_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.citationMetadata_ =
            citationMetadataBuilder_ == null ? citationMetadata_ : citationMetadataBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.groundingMetadata_ =
            groundingMetadataBuilder_ == null
                ? groundingMetadata_
                : groundingMetadataBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vertexai.api.Candidate) {
        return mergeFrom((com.google.cloud.vertexai.api.Candidate) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vertexai.api.Candidate other) {
      if (other == com.google.cloud.vertexai.api.Candidate.getDefaultInstance()) return this;
      if (other.getIndex() != 0) {
        setIndex(other.getIndex());
      }
      if (other.hasContent()) {
        mergeContent(other.getContent());
      }
      if (other.finishReason_ != 0) {
        setFinishReasonValue(other.getFinishReasonValue());
      }
      if (safetyRatingsBuilder_ == null) {
        if (!other.safetyRatings_.isEmpty()) {
          if (safetyRatings_.isEmpty()) {
            safetyRatings_ = other.safetyRatings_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureSafetyRatingsIsMutable();
            safetyRatings_.addAll(other.safetyRatings_);
          }
          onChanged();
        }
      } else {
        if (!other.safetyRatings_.isEmpty()) {
          if (safetyRatingsBuilder_.isEmpty()) {
            safetyRatingsBuilder_.dispose();
            safetyRatingsBuilder_ = null;
            safetyRatings_ = other.safetyRatings_;
            bitField0_ = (bitField0_ & ~0x00000008);
            safetyRatingsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSafetyRatingsFieldBuilder()
                    : null;
          } else {
            safetyRatingsBuilder_.addAllMessages(other.safetyRatings_);
          }
        }
      }
      if (other.hasFinishMessage()) {
        finishMessage_ = other.finishMessage_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasCitationMetadata()) {
        mergeCitationMetadata(other.getCitationMetadata());
      }
      if (other.hasGroundingMetadata()) {
        mergeGroundingMetadata(other.getGroundingMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                index_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(getContentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                finishReason_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.cloud.vertexai.api.SafetyRating m =
                    input.readMessage(
                        com.google.cloud.vertexai.api.SafetyRating.parser(), extensionRegistry);
                if (safetyRatingsBuilder_ == null) {
                  ensureSafetyRatingsIsMutable();
                  safetyRatings_.add(m);
                } else {
                  safetyRatingsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                finishMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getCitationMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getGroundingMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int index_;
    /**
     *
     *
     * <pre>
     * Output only. Index of the candidate.
     * </pre>
     *
     * <code>int32 index = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The index.
     */
    @java.lang.Override
    public int getIndex() {
      return index_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Index of the candidate.
     * </pre>
     *
     * <code>int32 index = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The index to set.
     * @return This builder for chaining.
     */
    public Builder setIndex(int value) {

      index_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Index of the candidate.
     * </pre>
     *
     * <code>int32 index = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndex() {
      bitField0_ = (bitField0_ & ~0x00000001);
      index_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.vertexai.api.Content content_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.Content,
            com.google.cloud.vertexai.api.Content.Builder,
            com.google.cloud.vertexai.api.ContentOrBuilder>
        contentBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Content parts of the candidate.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Content content = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the content field is set.
     */
    public boolean hasContent() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Content parts of the candidate.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Content content = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The content.
     */
    public com.google.cloud.vertexai.api.Content getContent() {
      if (contentBuilder_ == null) {
        return content_ == null
            ? com.google.cloud.vertexai.api.Content.getDefaultInstance()
            : content_;
      } else {
        return contentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Content parts of the candidate.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Content content = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setContent(com.google.cloud.vertexai.api.Content value) {
      if (contentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
      } else {
        contentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Content parts of the candidate.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Content content = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setContent(com.google.cloud.vertexai.api.Content.Builder builderForValue) {
      if (contentBuilder_ == null) {
        content_ = builderForValue.build();
      } else {
        contentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Content parts of the candidate.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Content content = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeContent(com.google.cloud.vertexai.api.Content value) {
      if (contentBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && content_ != null
            && content_ != com.google.cloud.vertexai.api.Content.getDefaultInstance()) {
          getContentBuilder().mergeFrom(value);
        } else {
          content_ = value;
        }
      } else {
        contentBuilder_.mergeFrom(value);
      }
      if (content_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Content parts of the candidate.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Content content = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearContent() {
      bitField0_ = (bitField0_ & ~0x00000002);
      content_ = null;
      if (contentBuilder_ != null) {
        contentBuilder_.dispose();
        contentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Content parts of the candidate.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Content content = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.Content.Builder getContentBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getContentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Content parts of the candidate.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Content content = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.ContentOrBuilder getContentOrBuilder() {
      if (contentBuilder_ != null) {
        return contentBuilder_.getMessageOrBuilder();
      } else {
        return content_ == null
            ? com.google.cloud.vertexai.api.Content.getDefaultInstance()
            : content_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Content parts of the candidate.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Content content = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.Content,
            com.google.cloud.vertexai.api.Content.Builder,
            com.google.cloud.vertexai.api.ContentOrBuilder>
        getContentFieldBuilder() {
      if (contentBuilder_ == null) {
        contentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vertexai.api.Content,
                com.google.cloud.vertexai.api.Content.Builder,
                com.google.cloud.vertexai.api.ContentOrBuilder>(
                getContent(), getParentForChildren(), isClean());
        content_ = null;
      }
      return contentBuilder_;
    }

    private int finishReason_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The reason why the model stopped generating tokens.
     * If empty, the model has not stopped generating the tokens.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Candidate.FinishReason finish_reason = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for finishReason.
     */
    @java.lang.Override
    public int getFinishReasonValue() {
      return finishReason_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason why the model stopped generating tokens.
     * If empty, the model has not stopped generating the tokens.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Candidate.FinishReason finish_reason = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for finishReason to set.
     * @return This builder for chaining.
     */
    public Builder setFinishReasonValue(int value) {
      finishReason_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason why the model stopped generating tokens.
     * If empty, the model has not stopped generating the tokens.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Candidate.FinishReason finish_reason = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The finishReason.
     */
    @java.lang.Override
    public com.google.cloud.vertexai.api.Candidate.FinishReason getFinishReason() {
      com.google.cloud.vertexai.api.Candidate.FinishReason result =
          com.google.cloud.vertexai.api.Candidate.FinishReason.forNumber(finishReason_);
      return result == null
          ? com.google.cloud.vertexai.api.Candidate.FinishReason.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason why the model stopped generating tokens.
     * If empty, the model has not stopped generating the tokens.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Candidate.FinishReason finish_reason = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The finishReason to set.
     * @return This builder for chaining.
     */
    public Builder setFinishReason(com.google.cloud.vertexai.api.Candidate.FinishReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      finishReason_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The reason why the model stopped generating tokens.
     * If empty, the model has not stopped generating the tokens.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Candidate.FinishReason finish_reason = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFinishReason() {
      bitField0_ = (bitField0_ & ~0x00000004);
      finishReason_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.vertexai.api.SafetyRating> safetyRatings_ =
        java.util.Collections.emptyList();

    private void ensureSafetyRatingsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        safetyRatings_ =
            new java.util.ArrayList<com.google.cloud.vertexai.api.SafetyRating>(safetyRatings_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.SafetyRating,
            com.google.cloud.vertexai.api.SafetyRating.Builder,
            com.google.cloud.vertexai.api.SafetyRatingOrBuilder>
        safetyRatingsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.SafetyRating> getSafetyRatingsList() {
      if (safetyRatingsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(safetyRatings_);
      } else {
        return safetyRatingsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getSafetyRatingsCount() {
      if (safetyRatingsBuilder_ == null) {
        return safetyRatings_.size();
      } else {
        return safetyRatingsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.SafetyRating getSafetyRatings(int index) {
      if (safetyRatingsBuilder_ == null) {
        return safetyRatings_.get(index);
      } else {
        return safetyRatingsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSafetyRatings(int index, com.google.cloud.vertexai.api.SafetyRating value) {
      if (safetyRatingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSafetyRatingsIsMutable();
        safetyRatings_.set(index, value);
        onChanged();
      } else {
        safetyRatingsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSafetyRatings(
        int index, com.google.cloud.vertexai.api.SafetyRating.Builder builderForValue) {
      if (safetyRatingsBuilder_ == null) {
        ensureSafetyRatingsIsMutable();
        safetyRatings_.set(index, builderForValue.build());
        onChanged();
      } else {
        safetyRatingsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSafetyRatings(com.google.cloud.vertexai.api.SafetyRating value) {
      if (safetyRatingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSafetyRatingsIsMutable();
        safetyRatings_.add(value);
        onChanged();
      } else {
        safetyRatingsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSafetyRatings(int index, com.google.cloud.vertexai.api.SafetyRating value) {
      if (safetyRatingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSafetyRatingsIsMutable();
        safetyRatings_.add(index, value);
        onChanged();
      } else {
        safetyRatingsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSafetyRatings(
        com.google.cloud.vertexai.api.SafetyRating.Builder builderForValue) {
      if (safetyRatingsBuilder_ == null) {
        ensureSafetyRatingsIsMutable();
        safetyRatings_.add(builderForValue.build());
        onChanged();
      } else {
        safetyRatingsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSafetyRatings(
        int index, com.google.cloud.vertexai.api.SafetyRating.Builder builderForValue) {
      if (safetyRatingsBuilder_ == null) {
        ensureSafetyRatingsIsMutable();
        safetyRatings_.add(index, builderForValue.build());
        onChanged();
      } else {
        safetyRatingsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllSafetyRatings(
        java.lang.Iterable<? extends com.google.cloud.vertexai.api.SafetyRating> values) {
      if (safetyRatingsBuilder_ == null) {
        ensureSafetyRatingsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, safetyRatings_);
        onChanged();
      } else {
        safetyRatingsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSafetyRatings() {
      if (safetyRatingsBuilder_ == null) {
        safetyRatings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        safetyRatingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeSafetyRatings(int index) {
      if (safetyRatingsBuilder_ == null) {
        ensureSafetyRatingsIsMutable();
        safetyRatings_.remove(index);
        onChanged();
      } else {
        safetyRatingsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.SafetyRating.Builder getSafetyRatingsBuilder(int index) {
      return getSafetyRatingsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.SafetyRatingOrBuilder getSafetyRatingsOrBuilder(
        int index) {
      if (safetyRatingsBuilder_ == null) {
        return safetyRatings_.get(index);
      } else {
        return safetyRatingsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.vertexai.api.SafetyRatingOrBuilder>
        getSafetyRatingsOrBuilderList() {
      if (safetyRatingsBuilder_ != null) {
        return safetyRatingsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(safetyRatings_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.SafetyRating.Builder addSafetyRatingsBuilder() {
      return getSafetyRatingsFieldBuilder()
          .addBuilder(com.google.cloud.vertexai.api.SafetyRating.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.SafetyRating.Builder addSafetyRatingsBuilder(int index) {
      return getSafetyRatingsFieldBuilder()
          .addBuilder(index, com.google.cloud.vertexai.api.SafetyRating.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. List of ratings for the safety of a response candidate.
     *
     * There is at most one rating per category.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.SafetyRating safety_ratings = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.SafetyRating.Builder>
        getSafetyRatingsBuilderList() {
      return getSafetyRatingsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.SafetyRating,
            com.google.cloud.vertexai.api.SafetyRating.Builder,
            com.google.cloud.vertexai.api.SafetyRatingOrBuilder>
        getSafetyRatingsFieldBuilder() {
      if (safetyRatingsBuilder_ == null) {
        safetyRatingsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vertexai.api.SafetyRating,
                com.google.cloud.vertexai.api.SafetyRating.Builder,
                com.google.cloud.vertexai.api.SafetyRatingOrBuilder>(
                safetyRatings_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        safetyRatings_ = null;
      }
      return safetyRatingsBuilder_;
    }

    private java.lang.Object finishMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Describes the reason the mode stopped generating tokens in
     * more detail. This is only filled when `finish_reason` is set.
     * </pre>
     *
     * <code>optional string finish_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the finishMessage field is set.
     */
    public boolean hasFinishMessage() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes the reason the mode stopped generating tokens in
     * more detail. This is only filled when `finish_reason` is set.
     * </pre>
     *
     * <code>optional string finish_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The finishMessage.
     */
    public java.lang.String getFinishMessage() {
      java.lang.Object ref = finishMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        finishMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes the reason the mode stopped generating tokens in
     * more detail. This is only filled when `finish_reason` is set.
     * </pre>
     *
     * <code>optional string finish_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for finishMessage.
     */
    public com.google.protobuf.ByteString getFinishMessageBytes() {
      java.lang.Object ref = finishMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        finishMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes the reason the mode stopped generating tokens in
     * more detail. This is only filled when `finish_reason` is set.
     * </pre>
     *
     * <code>optional string finish_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The finishMessage to set.
     * @return This builder for chaining.
     */
    public Builder setFinishMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      finishMessage_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes the reason the mode stopped generating tokens in
     * more detail. This is only filled when `finish_reason` is set.
     * </pre>
     *
     * <code>optional string finish_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFinishMessage() {
      finishMessage_ = getDefaultInstance().getFinishMessage();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes the reason the mode stopped generating tokens in
     * more detail. This is only filled when `finish_reason` is set.
     * </pre>
     *
     * <code>optional string finish_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for finishMessage to set.
     * @return This builder for chaining.
     */
    public Builder setFinishMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      finishMessage_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.cloud.vertexai.api.CitationMetadata citationMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.CitationMetadata,
            com.google.cloud.vertexai.api.CitationMetadata.Builder,
            com.google.cloud.vertexai.api.CitationMetadataOrBuilder>
        citationMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Source attribution of the generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.CitationMetadata citation_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the citationMetadata field is set.
     */
    public boolean hasCitationMetadata() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Source attribution of the generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.CitationMetadata citation_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The citationMetadata.
     */
    public com.google.cloud.vertexai.api.CitationMetadata getCitationMetadata() {
      if (citationMetadataBuilder_ == null) {
        return citationMetadata_ == null
            ? com.google.cloud.vertexai.api.CitationMetadata.getDefaultInstance()
            : citationMetadata_;
      } else {
        return citationMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Source attribution of the generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.CitationMetadata citation_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCitationMetadata(com.google.cloud.vertexai.api.CitationMetadata value) {
      if (citationMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        citationMetadata_ = value;
      } else {
        citationMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Source attribution of the generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.CitationMetadata citation_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCitationMetadata(
        com.google.cloud.vertexai.api.CitationMetadata.Builder builderForValue) {
      if (citationMetadataBuilder_ == null) {
        citationMetadata_ = builderForValue.build();
      } else {
        citationMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Source attribution of the generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.CitationMetadata citation_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCitationMetadata(com.google.cloud.vertexai.api.CitationMetadata value) {
      if (citationMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && citationMetadata_ != null
            && citationMetadata_
                != com.google.cloud.vertexai.api.CitationMetadata.getDefaultInstance()) {
          getCitationMetadataBuilder().mergeFrom(value);
        } else {
          citationMetadata_ = value;
        }
      } else {
        citationMetadataBuilder_.mergeFrom(value);
      }
      if (citationMetadata_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Source attribution of the generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.CitationMetadata citation_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCitationMetadata() {
      bitField0_ = (bitField0_ & ~0x00000020);
      citationMetadata_ = null;
      if (citationMetadataBuilder_ != null) {
        citationMetadataBuilder_.dispose();
        citationMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Source attribution of the generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.CitationMetadata citation_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.CitationMetadata.Builder getCitationMetadataBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCitationMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Source attribution of the generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.CitationMetadata citation_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.CitationMetadataOrBuilder getCitationMetadataOrBuilder() {
      if (citationMetadataBuilder_ != null) {
        return citationMetadataBuilder_.getMessageOrBuilder();
      } else {
        return citationMetadata_ == null
            ? com.google.cloud.vertexai.api.CitationMetadata.getDefaultInstance()
            : citationMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Source attribution of the generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.CitationMetadata citation_metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.CitationMetadata,
            com.google.cloud.vertexai.api.CitationMetadata.Builder,
            com.google.cloud.vertexai.api.CitationMetadataOrBuilder>
        getCitationMetadataFieldBuilder() {
      if (citationMetadataBuilder_ == null) {
        citationMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vertexai.api.CitationMetadata,
                com.google.cloud.vertexai.api.CitationMetadata.Builder,
                com.google.cloud.vertexai.api.CitationMetadataOrBuilder>(
                getCitationMetadata(), getParentForChildren(), isClean());
        citationMetadata_ = null;
      }
      return citationMetadataBuilder_;
    }

    private com.google.cloud.vertexai.api.GroundingMetadata groundingMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.GroundingMetadata,
            com.google.cloud.vertexai.api.GroundingMetadata.Builder,
            com.google.cloud.vertexai.api.GroundingMetadataOrBuilder>
        groundingMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Metadata specifies sources used to ground generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GroundingMetadata grounding_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the groundingMetadata field is set.
     */
    public boolean hasGroundingMetadata() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata specifies sources used to ground generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GroundingMetadata grounding_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The groundingMetadata.
     */
    public com.google.cloud.vertexai.api.GroundingMetadata getGroundingMetadata() {
      if (groundingMetadataBuilder_ == null) {
        return groundingMetadata_ == null
            ? com.google.cloud.vertexai.api.GroundingMetadata.getDefaultInstance()
            : groundingMetadata_;
      } else {
        return groundingMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata specifies sources used to ground generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GroundingMetadata grounding_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGroundingMetadata(com.google.cloud.vertexai.api.GroundingMetadata value) {
      if (groundingMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        groundingMetadata_ = value;
      } else {
        groundingMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata specifies sources used to ground generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GroundingMetadata grounding_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGroundingMetadata(
        com.google.cloud.vertexai.api.GroundingMetadata.Builder builderForValue) {
      if (groundingMetadataBuilder_ == null) {
        groundingMetadata_ = builderForValue.build();
      } else {
        groundingMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata specifies sources used to ground generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GroundingMetadata grounding_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeGroundingMetadata(com.google.cloud.vertexai.api.GroundingMetadata value) {
      if (groundingMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && groundingMetadata_ != null
            && groundingMetadata_
                != com.google.cloud.vertexai.api.GroundingMetadata.getDefaultInstance()) {
          getGroundingMetadataBuilder().mergeFrom(value);
        } else {
          groundingMetadata_ = value;
        }
      } else {
        groundingMetadataBuilder_.mergeFrom(value);
      }
      if (groundingMetadata_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata specifies sources used to ground generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GroundingMetadata grounding_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearGroundingMetadata() {
      bitField0_ = (bitField0_ & ~0x00000040);
      groundingMetadata_ = null;
      if (groundingMetadataBuilder_ != null) {
        groundingMetadataBuilder_.dispose();
        groundingMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata specifies sources used to ground generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GroundingMetadata grounding_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.GroundingMetadata.Builder getGroundingMetadataBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getGroundingMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata specifies sources used to ground generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GroundingMetadata grounding_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.GroundingMetadataOrBuilder
        getGroundingMetadataOrBuilder() {
      if (groundingMetadataBuilder_ != null) {
        return groundingMetadataBuilder_.getMessageOrBuilder();
      } else {
        return groundingMetadata_ == null
            ? com.google.cloud.vertexai.api.GroundingMetadata.getDefaultInstance()
            : groundingMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata specifies sources used to ground generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.GroundingMetadata grounding_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.GroundingMetadata,
            com.google.cloud.vertexai.api.GroundingMetadata.Builder,
            com.google.cloud.vertexai.api.GroundingMetadataOrBuilder>
        getGroundingMetadataFieldBuilder() {
      if (groundingMetadataBuilder_ == null) {
        groundingMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vertexai.api.GroundingMetadata,
                com.google.cloud.vertexai.api.GroundingMetadata.Builder,
                com.google.cloud.vertexai.api.GroundingMetadataOrBuilder>(
                getGroundingMetadata(), getParentForChildren(), isClean());
        groundingMetadata_ = null;
      }
      return groundingMetadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.Candidate)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.Candidate)
  private static final com.google.cloud.vertexai.api.Candidate DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vertexai.api.Candidate();
  }

  public static com.google.cloud.vertexai.api.Candidate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Candidate> PARSER =
      new com.google.protobuf.AbstractParser<Candidate>() {
        @java.lang.Override
        public Candidate parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Candidate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Candidate> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vertexai.api.Candidate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
