/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1/video_intelligence.proto

package com.google.cloud.videointelligence.v1;

/**
 *
 *
 * <pre>
 * A track of an object instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1.Track}
 */
public final class Track extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1.Track)
    TrackOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Track.newBuilder() to construct.
  private Track(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Track() {
    timestampedObjects_ = java.util.Collections.emptyList();
    attributes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Track();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Track(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.videointelligence.v1.VideoSegment.Builder subBuilder = null;
              if (segment_ != null) {
                subBuilder = segment_.toBuilder();
              }
              segment_ =
                  input.readMessage(
                      com.google.cloud.videointelligence.v1.VideoSegment.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(segment_);
                segment_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                timestampedObjects_ =
                    new java.util.ArrayList<
                        com.google.cloud.videointelligence.v1.TimestampedObject>();
                mutable_bitField0_ |= 0x00000001;
              }
              timestampedObjects_.add(
                  input.readMessage(
                      com.google.cloud.videointelligence.v1.TimestampedObject.parser(),
                      extensionRegistry));
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                attributes_ =
                    new java.util.ArrayList<
                        com.google.cloud.videointelligence.v1.DetectedAttribute>();
                mutable_bitField0_ |= 0x00000002;
              }
              attributes_.add(
                  input.readMessage(
                      com.google.cloud.videointelligence.v1.DetectedAttribute.parser(),
                      extensionRegistry));
              break;
            }
          case 37:
            {
              confidence_ = input.readFloat();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        timestampedObjects_ = java.util.Collections.unmodifiableList(timestampedObjects_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        attributes_ = java.util.Collections.unmodifiableList(attributes_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1_Track_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1_Track_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1.Track.class,
            com.google.cloud.videointelligence.v1.Track.Builder.class);
  }

  public static final int SEGMENT_FIELD_NUMBER = 1;
  private com.google.cloud.videointelligence.v1.VideoSegment segment_;
  /**
   *
   *
   * <pre>
   * Video segment of a track.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 1;</code>
   *
   * @return Whether the segment field is set.
   */
  @java.lang.Override
  public boolean hasSegment() {
    return segment_ != null;
  }
  /**
   *
   *
   * <pre>
   * Video segment of a track.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 1;</code>
   *
   * @return The segment.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.VideoSegment getSegment() {
    return segment_ == null
        ? com.google.cloud.videointelligence.v1.VideoSegment.getDefaultInstance()
        : segment_;
  }
  /**
   *
   *
   * <pre>
   * Video segment of a track.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder getSegmentOrBuilder() {
    return getSegment();
  }

  public static final int TIMESTAMPED_OBJECTS_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.videointelligence.v1.TimestampedObject>
      timestampedObjects_;
  /**
   *
   *
   * <pre>
   * The object with timestamp and attributes per frame in the track.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.TimestampedObject>
      getTimestampedObjectsList() {
    return timestampedObjects_;
  }
  /**
   *
   *
   * <pre>
   * The object with timestamp and attributes per frame in the track.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1.TimestampedObjectOrBuilder>
      getTimestampedObjectsOrBuilderList() {
    return timestampedObjects_;
  }
  /**
   *
   *
   * <pre>
   * The object with timestamp and attributes per frame in the track.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
   * </code>
   */
  @java.lang.Override
  public int getTimestampedObjectsCount() {
    return timestampedObjects_.size();
  }
  /**
   *
   *
   * <pre>
   * The object with timestamp and attributes per frame in the track.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.TimestampedObject getTimestampedObjects(int index) {
    return timestampedObjects_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The object with timestamp and attributes per frame in the track.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.TimestampedObjectOrBuilder
      getTimestampedObjectsOrBuilder(int index) {
    return timestampedObjects_.get(index);
  }

  public static final int ATTRIBUTES_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.videointelligence.v1.DetectedAttribute> attributes_;
  /**
   *
   *
   * <pre>
   * Optional. Attributes in the track level.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.DetectedAttribute>
      getAttributesList() {
    return attributes_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Attributes in the track level.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1.DetectedAttributeOrBuilder>
      getAttributesOrBuilderList() {
    return attributes_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Attributes in the track level.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getAttributesCount() {
    return attributes_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Attributes in the track level.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.DetectedAttribute getAttributes(int index) {
    return attributes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Attributes in the track level.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.DetectedAttributeOrBuilder getAttributesOrBuilder(
      int index) {
    return attributes_.get(index);
  }

  public static final int CONFIDENCE_FIELD_NUMBER = 4;
  private float confidence_;
  /**
   *
   *
   * <pre>
   * Optional. The confidence score of the tracked object.
   * </pre>
   *
   * <code>float confidence = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The confidence.
   */
  @java.lang.Override
  public float getConfidence() {
    return confidence_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (segment_ != null) {
      output.writeMessage(1, getSegment());
    }
    for (int i = 0; i < timestampedObjects_.size(); i++) {
      output.writeMessage(2, timestampedObjects_.get(i));
    }
    for (int i = 0; i < attributes_.size(); i++) {
      output.writeMessage(3, attributes_.get(i));
    }
    if (confidence_ != 0F) {
      output.writeFloat(4, confidence_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (segment_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSegment());
    }
    for (int i = 0; i < timestampedObjects_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, timestampedObjects_.get(i));
    }
    for (int i = 0; i < attributes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, attributes_.get(i));
    }
    if (confidence_ != 0F) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, confidence_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.videointelligence.v1.Track)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1.Track other =
        (com.google.cloud.videointelligence.v1.Track) obj;

    if (hasSegment() != other.hasSegment()) return false;
    if (hasSegment()) {
      if (!getSegment().equals(other.getSegment())) return false;
    }
    if (!getTimestampedObjectsList().equals(other.getTimestampedObjectsList())) return false;
    if (!getAttributesList().equals(other.getAttributesList())) return false;
    if (java.lang.Float.floatToIntBits(getConfidence())
        != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasSegment()) {
      hash = (37 * hash) + SEGMENT_FIELD_NUMBER;
      hash = (53 * hash) + getSegment().hashCode();
    }
    if (getTimestampedObjectsCount() > 0) {
      hash = (37 * hash) + TIMESTAMPED_OBJECTS_FIELD_NUMBER;
      hash = (53 * hash) + getTimestampedObjectsList().hashCode();
    }
    if (getAttributesCount() > 0) {
      hash = (37 * hash) + ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + getAttributesList().hashCode();
    }
    hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1.Track parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1.Track parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.Track parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1.Track parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.Track parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1.Track parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.Track parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1.Track parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.Track parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1.Track parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.Track parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1.Track parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.videointelligence.v1.Track prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A track of an object instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1.Track}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1.Track)
      com.google.cloud.videointelligence.v1.TrackOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1_Track_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1_Track_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1.Track.class,
              com.google.cloud.videointelligence.v1.Track.Builder.class);
    }

    // Construct using com.google.cloud.videointelligence.v1.Track.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTimestampedObjectsFieldBuilder();
        getAttributesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (segmentBuilder_ == null) {
        segment_ = null;
      } else {
        segment_ = null;
        segmentBuilder_ = null;
      }
      if (timestampedObjectsBuilder_ == null) {
        timestampedObjects_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        timestampedObjectsBuilder_.clear();
      }
      if (attributesBuilder_ == null) {
        attributes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        attributesBuilder_.clear();
      }
      confidence_ = 0F;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1_Track_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1.Track getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1.Track.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1.Track build() {
      com.google.cloud.videointelligence.v1.Track result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1.Track buildPartial() {
      com.google.cloud.videointelligence.v1.Track result =
          new com.google.cloud.videointelligence.v1.Track(this);
      int from_bitField0_ = bitField0_;
      if (segmentBuilder_ == null) {
        result.segment_ = segment_;
      } else {
        result.segment_ = segmentBuilder_.build();
      }
      if (timestampedObjectsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          timestampedObjects_ = java.util.Collections.unmodifiableList(timestampedObjects_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.timestampedObjects_ = timestampedObjects_;
      } else {
        result.timestampedObjects_ = timestampedObjectsBuilder_.build();
      }
      if (attributesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          attributes_ = java.util.Collections.unmodifiableList(attributes_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.attributes_ = attributes_;
      } else {
        result.attributes_ = attributesBuilder_.build();
      }
      result.confidence_ = confidence_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.videointelligence.v1.Track) {
        return mergeFrom((com.google.cloud.videointelligence.v1.Track) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.videointelligence.v1.Track other) {
      if (other == com.google.cloud.videointelligence.v1.Track.getDefaultInstance()) return this;
      if (other.hasSegment()) {
        mergeSegment(other.getSegment());
      }
      if (timestampedObjectsBuilder_ == null) {
        if (!other.timestampedObjects_.isEmpty()) {
          if (timestampedObjects_.isEmpty()) {
            timestampedObjects_ = other.timestampedObjects_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTimestampedObjectsIsMutable();
            timestampedObjects_.addAll(other.timestampedObjects_);
          }
          onChanged();
        }
      } else {
        if (!other.timestampedObjects_.isEmpty()) {
          if (timestampedObjectsBuilder_.isEmpty()) {
            timestampedObjectsBuilder_.dispose();
            timestampedObjectsBuilder_ = null;
            timestampedObjects_ = other.timestampedObjects_;
            bitField0_ = (bitField0_ & ~0x00000001);
            timestampedObjectsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTimestampedObjectsFieldBuilder()
                    : null;
          } else {
            timestampedObjectsBuilder_.addAllMessages(other.timestampedObjects_);
          }
        }
      }
      if (attributesBuilder_ == null) {
        if (!other.attributes_.isEmpty()) {
          if (attributes_.isEmpty()) {
            attributes_ = other.attributes_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureAttributesIsMutable();
            attributes_.addAll(other.attributes_);
          }
          onChanged();
        }
      } else {
        if (!other.attributes_.isEmpty()) {
          if (attributesBuilder_.isEmpty()) {
            attributesBuilder_.dispose();
            attributesBuilder_ = null;
            attributes_ = other.attributes_;
            bitField0_ = (bitField0_ & ~0x00000002);
            attributesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAttributesFieldBuilder()
                    : null;
          } else {
            attributesBuilder_.addAllMessages(other.attributes_);
          }
        }
      }
      if (other.getConfidence() != 0F) {
        setConfidence(other.getConfidence());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.videointelligence.v1.Track parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.videointelligence.v1.Track) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.cloud.videointelligence.v1.VideoSegment segment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.VideoSegment,
            com.google.cloud.videointelligence.v1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>
        segmentBuilder_;
    /**
     *
     *
     * <pre>
     * Video segment of a track.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 1;</code>
     *
     * @return Whether the segment field is set.
     */
    public boolean hasSegment() {
      return segmentBuilder_ != null || segment_ != null;
    }
    /**
     *
     *
     * <pre>
     * Video segment of a track.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 1;</code>
     *
     * @return The segment.
     */
    public com.google.cloud.videointelligence.v1.VideoSegment getSegment() {
      if (segmentBuilder_ == null) {
        return segment_ == null
            ? com.google.cloud.videointelligence.v1.VideoSegment.getDefaultInstance()
            : segment_;
      } else {
        return segmentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Video segment of a track.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 1;</code>
     */
    public Builder setSegment(com.google.cloud.videointelligence.v1.VideoSegment value) {
      if (segmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        segment_ = value;
        onChanged();
      } else {
        segmentBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segment of a track.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 1;</code>
     */
    public Builder setSegment(
        com.google.cloud.videointelligence.v1.VideoSegment.Builder builderForValue) {
      if (segmentBuilder_ == null) {
        segment_ = builderForValue.build();
        onChanged();
      } else {
        segmentBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segment of a track.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 1;</code>
     */
    public Builder mergeSegment(com.google.cloud.videointelligence.v1.VideoSegment value) {
      if (segmentBuilder_ == null) {
        if (segment_ != null) {
          segment_ =
              com.google.cloud.videointelligence.v1.VideoSegment.newBuilder(segment_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          segment_ = value;
        }
        onChanged();
      } else {
        segmentBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segment of a track.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 1;</code>
     */
    public Builder clearSegment() {
      if (segmentBuilder_ == null) {
        segment_ = null;
        onChanged();
      } else {
        segment_ = null;
        segmentBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segment of a track.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 1;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegment.Builder getSegmentBuilder() {

      onChanged();
      return getSegmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Video segment of a track.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 1;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder getSegmentOrBuilder() {
      if (segmentBuilder_ != null) {
        return segmentBuilder_.getMessageOrBuilder();
      } else {
        return segment_ == null
            ? com.google.cloud.videointelligence.v1.VideoSegment.getDefaultInstance()
            : segment_;
      }
    }
    /**
     *
     *
     * <pre>
     * Video segment of a track.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.VideoSegment,
            com.google.cloud.videointelligence.v1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>
        getSegmentFieldBuilder() {
      if (segmentBuilder_ == null) {
        segmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1.VideoSegment,
                com.google.cloud.videointelligence.v1.VideoSegment.Builder,
                com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>(
                getSegment(), getParentForChildren(), isClean());
        segment_ = null;
      }
      return segmentBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.TimestampedObject>
        timestampedObjects_ = java.util.Collections.emptyList();

    private void ensureTimestampedObjectsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        timestampedObjects_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1.TimestampedObject>(
                timestampedObjects_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.TimestampedObject,
            com.google.cloud.videointelligence.v1.TimestampedObject.Builder,
            com.google.cloud.videointelligence.v1.TimestampedObjectOrBuilder>
        timestampedObjectsBuilder_;

    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.TimestampedObject>
        getTimestampedObjectsList() {
      if (timestampedObjectsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(timestampedObjects_);
      } else {
        return timestampedObjectsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public int getTimestampedObjectsCount() {
      if (timestampedObjectsBuilder_ == null) {
        return timestampedObjects_.size();
      } else {
        return timestampedObjectsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.TimestampedObject getTimestampedObjects(
        int index) {
      if (timestampedObjectsBuilder_ == null) {
        return timestampedObjects_.get(index);
      } else {
        return timestampedObjectsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public Builder setTimestampedObjects(
        int index, com.google.cloud.videointelligence.v1.TimestampedObject value) {
      if (timestampedObjectsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimestampedObjectsIsMutable();
        timestampedObjects_.set(index, value);
        onChanged();
      } else {
        timestampedObjectsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public Builder setTimestampedObjects(
        int index,
        com.google.cloud.videointelligence.v1.TimestampedObject.Builder builderForValue) {
      if (timestampedObjectsBuilder_ == null) {
        ensureTimestampedObjectsIsMutable();
        timestampedObjects_.set(index, builderForValue.build());
        onChanged();
      } else {
        timestampedObjectsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public Builder addTimestampedObjects(
        com.google.cloud.videointelligence.v1.TimestampedObject value) {
      if (timestampedObjectsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimestampedObjectsIsMutable();
        timestampedObjects_.add(value);
        onChanged();
      } else {
        timestampedObjectsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public Builder addTimestampedObjects(
        int index, com.google.cloud.videointelligence.v1.TimestampedObject value) {
      if (timestampedObjectsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimestampedObjectsIsMutable();
        timestampedObjects_.add(index, value);
        onChanged();
      } else {
        timestampedObjectsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public Builder addTimestampedObjects(
        com.google.cloud.videointelligence.v1.TimestampedObject.Builder builderForValue) {
      if (timestampedObjectsBuilder_ == null) {
        ensureTimestampedObjectsIsMutable();
        timestampedObjects_.add(builderForValue.build());
        onChanged();
      } else {
        timestampedObjectsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public Builder addTimestampedObjects(
        int index,
        com.google.cloud.videointelligence.v1.TimestampedObject.Builder builderForValue) {
      if (timestampedObjectsBuilder_ == null) {
        ensureTimestampedObjectsIsMutable();
        timestampedObjects_.add(index, builderForValue.build());
        onChanged();
      } else {
        timestampedObjectsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public Builder addAllTimestampedObjects(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.TimestampedObject>
            values) {
      if (timestampedObjectsBuilder_ == null) {
        ensureTimestampedObjectsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, timestampedObjects_);
        onChanged();
      } else {
        timestampedObjectsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public Builder clearTimestampedObjects() {
      if (timestampedObjectsBuilder_ == null) {
        timestampedObjects_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        timestampedObjectsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public Builder removeTimestampedObjects(int index) {
      if (timestampedObjectsBuilder_ == null) {
        ensureTimestampedObjectsIsMutable();
        timestampedObjects_.remove(index);
        onChanged();
      } else {
        timestampedObjectsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.TimestampedObject.Builder
        getTimestampedObjectsBuilder(int index) {
      return getTimestampedObjectsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.TimestampedObjectOrBuilder
        getTimestampedObjectsOrBuilder(int index) {
      if (timestampedObjectsBuilder_ == null) {
        return timestampedObjects_.get(index);
      } else {
        return timestampedObjectsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1.TimestampedObjectOrBuilder>
        getTimestampedObjectsOrBuilderList() {
      if (timestampedObjectsBuilder_ != null) {
        return timestampedObjectsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(timestampedObjects_);
      }
    }
    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.TimestampedObject.Builder
        addTimestampedObjectsBuilder() {
      return getTimestampedObjectsFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1.TimestampedObject.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.TimestampedObject.Builder
        addTimestampedObjectsBuilder(int index) {
      return getTimestampedObjectsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1.TimestampedObject.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The object with timestamp and attributes per frame in the track.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TimestampedObject timestamped_objects = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.TimestampedObject.Builder>
        getTimestampedObjectsBuilderList() {
      return getTimestampedObjectsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.TimestampedObject,
            com.google.cloud.videointelligence.v1.TimestampedObject.Builder,
            com.google.cloud.videointelligence.v1.TimestampedObjectOrBuilder>
        getTimestampedObjectsFieldBuilder() {
      if (timestampedObjectsBuilder_ == null) {
        timestampedObjectsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.TimestampedObject,
                com.google.cloud.videointelligence.v1.TimestampedObject.Builder,
                com.google.cloud.videointelligence.v1.TimestampedObjectOrBuilder>(
                timestampedObjects_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        timestampedObjects_ = null;
      }
      return timestampedObjectsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.DetectedAttribute> attributes_ =
        java.util.Collections.emptyList();

    private void ensureAttributesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        attributes_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1.DetectedAttribute>(
                attributes_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.DetectedAttribute,
            com.google.cloud.videointelligence.v1.DetectedAttribute.Builder,
            com.google.cloud.videointelligence.v1.DetectedAttributeOrBuilder>
        attributesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.DetectedAttribute>
        getAttributesList() {
      if (attributesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(attributes_);
      } else {
        return attributesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getAttributesCount() {
      if (attributesBuilder_ == null) {
        return attributes_.size();
      } else {
        return attributesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1.DetectedAttribute getAttributes(int index) {
      if (attributesBuilder_ == null) {
        return attributes_.get(index);
      } else {
        return attributesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAttributes(
        int index, com.google.cloud.videointelligence.v1.DetectedAttribute value) {
      if (attributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributesIsMutable();
        attributes_.set(index, value);
        onChanged();
      } else {
        attributesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAttributes(
        int index,
        com.google.cloud.videointelligence.v1.DetectedAttribute.Builder builderForValue) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        attributes_.set(index, builderForValue.build());
        onChanged();
      } else {
        attributesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAttributes(com.google.cloud.videointelligence.v1.DetectedAttribute value) {
      if (attributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributesIsMutable();
        attributes_.add(value);
        onChanged();
      } else {
        attributesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAttributes(
        int index, com.google.cloud.videointelligence.v1.DetectedAttribute value) {
      if (attributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributesIsMutable();
        attributes_.add(index, value);
        onChanged();
      } else {
        attributesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAttributes(
        com.google.cloud.videointelligence.v1.DetectedAttribute.Builder builderForValue) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        attributes_.add(builderForValue.build());
        onChanged();
      } else {
        attributesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAttributes(
        int index,
        com.google.cloud.videointelligence.v1.DetectedAttribute.Builder builderForValue) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        attributes_.add(index, builderForValue.build());
        onChanged();
      } else {
        attributesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllAttributes(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.DetectedAttribute>
            values) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, attributes_);
        onChanged();
      } else {
        attributesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAttributes() {
      if (attributesBuilder_ == null) {
        attributes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        attributesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAttributes(int index) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        attributes_.remove(index);
        onChanged();
      } else {
        attributesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1.DetectedAttribute.Builder getAttributesBuilder(
        int index) {
      return getAttributesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1.DetectedAttributeOrBuilder getAttributesOrBuilder(
        int index) {
      if (attributesBuilder_ == null) {
        return attributes_.get(index);
      } else {
        return attributesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1.DetectedAttributeOrBuilder>
        getAttributesOrBuilderList() {
      if (attributesBuilder_ != null) {
        return attributesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(attributes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1.DetectedAttribute.Builder addAttributesBuilder() {
      return getAttributesFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1.DetectedAttribute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1.DetectedAttribute.Builder addAttributesBuilder(
        int index) {
      return getAttributesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1.DetectedAttribute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Attributes in the track level.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.DetectedAttribute.Builder>
        getAttributesBuilderList() {
      return getAttributesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.DetectedAttribute,
            com.google.cloud.videointelligence.v1.DetectedAttribute.Builder,
            com.google.cloud.videointelligence.v1.DetectedAttributeOrBuilder>
        getAttributesFieldBuilder() {
      if (attributesBuilder_ == null) {
        attributesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.DetectedAttribute,
                com.google.cloud.videointelligence.v1.DetectedAttribute.Builder,
                com.google.cloud.videointelligence.v1.DetectedAttributeOrBuilder>(
                attributes_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        attributes_ = null;
      }
      return attributesBuilder_;
    }

    private float confidence_;
    /**
     *
     *
     * <pre>
     * Optional. The confidence score of the tracked object.
     * </pre>
     *
     * <code>float confidence = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The confidence.
     */
    @java.lang.Override
    public float getConfidence() {
      return confidence_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The confidence score of the tracked object.
     * </pre>
     *
     * <code>float confidence = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The confidence to set.
     * @return This builder for chaining.
     */
    public Builder setConfidence(float value) {

      confidence_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The confidence score of the tracked object.
     * </pre>
     *
     * <code>float confidence = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfidence() {

      confidence_ = 0F;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1.Track)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1.Track)
  private static final com.google.cloud.videointelligence.v1.Track DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.videointelligence.v1.Track();
  }

  public static com.google.cloud.videointelligence.v1.Track getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Track> PARSER =
      new com.google.protobuf.AbstractParser<Track>() {
        @java.lang.Override
        public Track parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Track(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Track> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Track> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1.Track getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
