/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1/video_intelligence.proto

package com.google.cloud.videointelligence.v1;

/**
 *
 *
 * <pre>
 * For tracking related features.
 * An object at time_offset with attributes, and located with
 * normalized_bounding_box.
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1.TimestampedObject}
 */
public final class TimestampedObject extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1.TimestampedObject)
    TimestampedObjectOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TimestampedObject.newBuilder() to construct.
  private TimestampedObject(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TimestampedObject() {
    attributes_ = java.util.Collections.emptyList();
    landmarks_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TimestampedObject();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1_TimestampedObject_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1_TimestampedObject_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1.TimestampedObject.class,
            com.google.cloud.videointelligence.v1.TimestampedObject.Builder.class);
  }

  public static final int NORMALIZED_BOUNDING_BOX_FIELD_NUMBER = 1;
  private com.google.cloud.videointelligence.v1.NormalizedBoundingBox normalizedBoundingBox_;
  /**
   *
   *
   * <pre>
   * Normalized Bounding box in a frame, where the object is located.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.NormalizedBoundingBox normalized_bounding_box = 1;
   * </code>
   *
   * @return Whether the normalizedBoundingBox field is set.
   */
  @java.lang.Override
  public boolean hasNormalizedBoundingBox() {
    return normalizedBoundingBox_ != null;
  }
  /**
   *
   *
   * <pre>
   * Normalized Bounding box in a frame, where the object is located.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.NormalizedBoundingBox normalized_bounding_box = 1;
   * </code>
   *
   * @return The normalizedBoundingBox.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.NormalizedBoundingBox getNormalizedBoundingBox() {
    return normalizedBoundingBox_ == null
        ? com.google.cloud.videointelligence.v1.NormalizedBoundingBox.getDefaultInstance()
        : normalizedBoundingBox_;
  }
  /**
   *
   *
   * <pre>
   * Normalized Bounding box in a frame, where the object is located.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.NormalizedBoundingBox normalized_bounding_box = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.NormalizedBoundingBoxOrBuilder
      getNormalizedBoundingBoxOrBuilder() {
    return normalizedBoundingBox_ == null
        ? com.google.cloud.videointelligence.v1.NormalizedBoundingBox.getDefaultInstance()
        : normalizedBoundingBox_;
  }

  public static final int TIME_OFFSET_FIELD_NUMBER = 2;
  private com.google.protobuf.Duration timeOffset_;
  /**
   *
   *
   * <pre>
   * Time-offset, relative to the beginning of the video,
   * corresponding to the video frame for this object.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_offset = 2;</code>
   *
   * @return Whether the timeOffset field is set.
   */
  @java.lang.Override
  public boolean hasTimeOffset() {
    return timeOffset_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time-offset, relative to the beginning of the video,
   * corresponding to the video frame for this object.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_offset = 2;</code>
   *
   * @return The timeOffset.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeOffset() {
    return timeOffset_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeOffset_;
  }
  /**
   *
   *
   * <pre>
   * Time-offset, relative to the beginning of the video,
   * corresponding to the video frame for this object.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_offset = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeOffsetOrBuilder() {
    return timeOffset_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeOffset_;
  }

  public static final int ATTRIBUTES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.DetectedAttribute> attributes_;
  /**
   *
   *
   * <pre>
   * Optional. The attributes of the object in the bounding box.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.DetectedAttribute>
      getAttributesList() {
    return attributes_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The attributes of the object in the bounding box.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1.DetectedAttributeOrBuilder>
      getAttributesOrBuilderList() {
    return attributes_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The attributes of the object in the bounding box.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getAttributesCount() {
    return attributes_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The attributes of the object in the bounding box.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.DetectedAttribute getAttributes(int index) {
    return attributes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The attributes of the object in the bounding box.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.DetectedAttributeOrBuilder getAttributesOrBuilder(
      int index) {
    return attributes_.get(index);
  }

  public static final int LANDMARKS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.DetectedLandmark> landmarks_;
  /**
   *
   *
   * <pre>
   * Optional. The detected landmarks.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.DetectedLandmark> getLandmarksList() {
    return landmarks_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The detected landmarks.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1.DetectedLandmarkOrBuilder>
      getLandmarksOrBuilderList() {
    return landmarks_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The detected landmarks.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getLandmarksCount() {
    return landmarks_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The detected landmarks.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.DetectedLandmark getLandmarks(int index) {
    return landmarks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The detected landmarks.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.DetectedLandmarkOrBuilder getLandmarksOrBuilder(
      int index) {
    return landmarks_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (normalizedBoundingBox_ != null) {
      output.writeMessage(1, getNormalizedBoundingBox());
    }
    if (timeOffset_ != null) {
      output.writeMessage(2, getTimeOffset());
    }
    for (int i = 0; i < attributes_.size(); i++) {
      output.writeMessage(3, attributes_.get(i));
    }
    for (int i = 0; i < landmarks_.size(); i++) {
      output.writeMessage(4, landmarks_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (normalizedBoundingBox_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, getNormalizedBoundingBox());
    }
    if (timeOffset_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTimeOffset());
    }
    for (int i = 0; i < attributes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, attributes_.get(i));
    }
    for (int i = 0; i < landmarks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, landmarks_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.videointelligence.v1.TimestampedObject)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1.TimestampedObject other =
        (com.google.cloud.videointelligence.v1.TimestampedObject) obj;

    if (hasNormalizedBoundingBox() != other.hasNormalizedBoundingBox()) return false;
    if (hasNormalizedBoundingBox()) {
      if (!getNormalizedBoundingBox().equals(other.getNormalizedBoundingBox())) return false;
    }
    if (hasTimeOffset() != other.hasTimeOffset()) return false;
    if (hasTimeOffset()) {
      if (!getTimeOffset().equals(other.getTimeOffset())) return false;
    }
    if (!getAttributesList().equals(other.getAttributesList())) return false;
    if (!getLandmarksList().equals(other.getLandmarksList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasNormalizedBoundingBox()) {
      hash = (37 * hash) + NORMALIZED_BOUNDING_BOX_FIELD_NUMBER;
      hash = (53 * hash) + getNormalizedBoundingBox().hashCode();
    }
    if (hasTimeOffset()) {
      hash = (37 * hash) + TIME_OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + getTimeOffset().hashCode();
    }
    if (getAttributesCount() > 0) {
      hash = (37 * hash) + ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + getAttributesList().hashCode();
    }
    if (getLandmarksCount() > 0) {
      hash = (37 * hash) + LANDMARKS_FIELD_NUMBER;
      hash = (53 * hash) + getLandmarksList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1.TimestampedObject parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1.TimestampedObject parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.TimestampedObject parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1.TimestampedObject parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.TimestampedObject parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1.TimestampedObject parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.TimestampedObject parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1.TimestampedObject parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.TimestampedObject parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1.TimestampedObject parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.TimestampedObject parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1.TimestampedObject parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.videointelligence.v1.TimestampedObject prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * For tracking related features.
   * An object at time_offset with attributes, and located with
   * normalized_bounding_box.
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1.TimestampedObject}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1.TimestampedObject)
      com.google.cloud.videointelligence.v1.TimestampedObjectOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1_TimestampedObject_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1_TimestampedObject_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1.TimestampedObject.class,
              com.google.cloud.videointelligence.v1.TimestampedObject.Builder.class);
    }

    // Construct using com.google.cloud.videointelligence.v1.TimestampedObject.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      normalizedBoundingBox_ = null;
      if (normalizedBoundingBoxBuilder_ != null) {
        normalizedBoundingBoxBuilder_.dispose();
        normalizedBoundingBoxBuilder_ = null;
      }
      timeOffset_ = null;
      if (timeOffsetBuilder_ != null) {
        timeOffsetBuilder_.dispose();
        timeOffsetBuilder_ = null;
      }
      if (attributesBuilder_ == null) {
        attributes_ = java.util.Collections.emptyList();
      } else {
        attributes_ = null;
        attributesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (landmarksBuilder_ == null) {
        landmarks_ = java.util.Collections.emptyList();
      } else {
        landmarks_ = null;
        landmarksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1_TimestampedObject_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1.TimestampedObject getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1.TimestampedObject.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1.TimestampedObject build() {
      com.google.cloud.videointelligence.v1.TimestampedObject result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1.TimestampedObject buildPartial() {
      com.google.cloud.videointelligence.v1.TimestampedObject result =
          new com.google.cloud.videointelligence.v1.TimestampedObject(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.videointelligence.v1.TimestampedObject result) {
      if (attributesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          attributes_ = java.util.Collections.unmodifiableList(attributes_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.attributes_ = attributes_;
      } else {
        result.attributes_ = attributesBuilder_.build();
      }
      if (landmarksBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          landmarks_ = java.util.Collections.unmodifiableList(landmarks_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.landmarks_ = landmarks_;
      } else {
        result.landmarks_ = landmarksBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.videointelligence.v1.TimestampedObject result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.normalizedBoundingBox_ =
            normalizedBoundingBoxBuilder_ == null
                ? normalizedBoundingBox_
                : normalizedBoundingBoxBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.timeOffset_ = timeOffsetBuilder_ == null ? timeOffset_ : timeOffsetBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.videointelligence.v1.TimestampedObject) {
        return mergeFrom((com.google.cloud.videointelligence.v1.TimestampedObject) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.videointelligence.v1.TimestampedObject other) {
      if (other == com.google.cloud.videointelligence.v1.TimestampedObject.getDefaultInstance())
        return this;
      if (other.hasNormalizedBoundingBox()) {
        mergeNormalizedBoundingBox(other.getNormalizedBoundingBox());
      }
      if (other.hasTimeOffset()) {
        mergeTimeOffset(other.getTimeOffset());
      }
      if (attributesBuilder_ == null) {
        if (!other.attributes_.isEmpty()) {
          if (attributes_.isEmpty()) {
            attributes_ = other.attributes_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureAttributesIsMutable();
            attributes_.addAll(other.attributes_);
          }
          onChanged();
        }
      } else {
        if (!other.attributes_.isEmpty()) {
          if (attributesBuilder_.isEmpty()) {
            attributesBuilder_.dispose();
            attributesBuilder_ = null;
            attributes_ = other.attributes_;
            bitField0_ = (bitField0_ & ~0x00000004);
            attributesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAttributesFieldBuilder()
                    : null;
          } else {
            attributesBuilder_.addAllMessages(other.attributes_);
          }
        }
      }
      if (landmarksBuilder_ == null) {
        if (!other.landmarks_.isEmpty()) {
          if (landmarks_.isEmpty()) {
            landmarks_ = other.landmarks_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureLandmarksIsMutable();
            landmarks_.addAll(other.landmarks_);
          }
          onChanged();
        }
      } else {
        if (!other.landmarks_.isEmpty()) {
          if (landmarksBuilder_.isEmpty()) {
            landmarksBuilder_.dispose();
            landmarksBuilder_ = null;
            landmarks_ = other.landmarks_;
            bitField0_ = (bitField0_ & ~0x00000008);
            landmarksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLandmarksFieldBuilder()
                    : null;
          } else {
            landmarksBuilder_.addAllMessages(other.landmarks_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getNormalizedBoundingBoxFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getTimeOffsetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.videointelligence.v1.DetectedAttribute m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.DetectedAttribute.parser(),
                        extensionRegistry);
                if (attributesBuilder_ == null) {
                  ensureAttributesIsMutable();
                  attributes_.add(m);
                } else {
                  attributesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.videointelligence.v1.DetectedLandmark m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.DetectedLandmark.parser(),
                        extensionRegistry);
                if (landmarksBuilder_ == null) {
                  ensureLandmarksIsMutable();
                  landmarks_.add(m);
                } else {
                  landmarksBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.videointelligence.v1.NormalizedBoundingBox normalizedBoundingBox_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.NormalizedBoundingBox,
            com.google.cloud.videointelligence.v1.NormalizedBoundingBox.Builder,
            com.google.cloud.videointelligence.v1.NormalizedBoundingBoxOrBuilder>
        normalizedBoundingBoxBuilder_;
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     *
     * @return Whether the normalizedBoundingBox field is set.
     */
    public boolean hasNormalizedBoundingBox() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     *
     * @return The normalizedBoundingBox.
     */
    public com.google.cloud.videointelligence.v1.NormalizedBoundingBox getNormalizedBoundingBox() {
      if (normalizedBoundingBoxBuilder_ == null) {
        return normalizedBoundingBox_ == null
            ? com.google.cloud.videointelligence.v1.NormalizedBoundingBox.getDefaultInstance()
            : normalizedBoundingBox_;
      } else {
        return normalizedBoundingBoxBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     */
    public Builder setNormalizedBoundingBox(
        com.google.cloud.videointelligence.v1.NormalizedBoundingBox value) {
      if (normalizedBoundingBoxBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        normalizedBoundingBox_ = value;
      } else {
        normalizedBoundingBoxBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     */
    public Builder setNormalizedBoundingBox(
        com.google.cloud.videointelligence.v1.NormalizedBoundingBox.Builder builderForValue) {
      if (normalizedBoundingBoxBuilder_ == null) {
        normalizedBoundingBox_ = builderForValue.build();
      } else {
        normalizedBoundingBoxBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     */
    public Builder mergeNormalizedBoundingBox(
        com.google.cloud.videointelligence.v1.NormalizedBoundingBox value) {
      if (normalizedBoundingBoxBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && normalizedBoundingBox_ != null
            && normalizedBoundingBox_
                != com.google.cloud.videointelligence.v1.NormalizedBoundingBox
                    .getDefaultInstance()) {
          getNormalizedBoundingBoxBuilder().mergeFrom(value);
        } else {
          normalizedBoundingBox_ = value;
        }
      } else {
        normalizedBoundingBoxBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     */
    public Builder clearNormalizedBoundingBox() {
      bitField0_ = (bitField0_ & ~0x00000001);
      normalizedBoundingBox_ = null;
      if (normalizedBoundingBoxBuilder_ != null) {
        normalizedBoundingBoxBuilder_.dispose();
        normalizedBoundingBoxBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.NormalizedBoundingBox.Builder
        getNormalizedBoundingBoxBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getNormalizedBoundingBoxFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.NormalizedBoundingBoxOrBuilder
        getNormalizedBoundingBoxOrBuilder() {
      if (normalizedBoundingBoxBuilder_ != null) {
        return normalizedBoundingBoxBuilder_.getMessageOrBuilder();
      } else {
        return normalizedBoundingBox_ == null
            ? com.google.cloud.videointelligence.v1.NormalizedBoundingBox.getDefaultInstance()
            : normalizedBoundingBox_;
      }
    }
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.NormalizedBoundingBox,
            com.google.cloud.videointelligence.v1.NormalizedBoundingBox.Builder,
            com.google.cloud.videointelligence.v1.NormalizedBoundingBoxOrBuilder>
        getNormalizedBoundingBoxFieldBuilder() {
      if (normalizedBoundingBoxBuilder_ == null) {
        normalizedBoundingBoxBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1.NormalizedBoundingBox,
                com.google.cloud.videointelligence.v1.NormalizedBoundingBox.Builder,
                com.google.cloud.videointelligence.v1.NormalizedBoundingBoxOrBuilder>(
                getNormalizedBoundingBox(), getParentForChildren(), isClean());
        normalizedBoundingBox_ = null;
      }
      return normalizedBoundingBoxBuilder_;
    }

    private com.google.protobuf.Duration timeOffset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeOffsetBuilder_;
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     *
     * @return Whether the timeOffset field is set.
     */
    public boolean hasTimeOffset() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     *
     * @return The timeOffset.
     */
    public com.google.protobuf.Duration getTimeOffset() {
      if (timeOffsetBuilder_ == null) {
        return timeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeOffset_;
      } else {
        return timeOffsetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public Builder setTimeOffset(com.google.protobuf.Duration value) {
      if (timeOffsetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeOffset_ = value;
      } else {
        timeOffsetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public Builder setTimeOffset(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeOffsetBuilder_ == null) {
        timeOffset_ = builderForValue.build();
      } else {
        timeOffsetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public Builder mergeTimeOffset(com.google.protobuf.Duration value) {
      if (timeOffsetBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && timeOffset_ != null
            && timeOffset_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTimeOffsetBuilder().mergeFrom(value);
        } else {
          timeOffset_ = value;
        }
      } else {
        timeOffsetBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public Builder clearTimeOffset() {
      bitField0_ = (bitField0_ & ~0x00000002);
      timeOffset_ = null;
      if (timeOffsetBuilder_ != null) {
        timeOffsetBuilder_.dispose();
        timeOffsetBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeOffsetBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTimeOffsetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeOffsetOrBuilder() {
      if (timeOffsetBuilder_ != null) {
        return timeOffsetBuilder_.getMessageOrBuilder();
      } else {
        return timeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeOffset_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeOffsetFieldBuilder() {
      if (timeOffsetBuilder_ == null) {
        timeOffsetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeOffset(), getParentForChildren(), isClean());
        timeOffset_ = null;
      }
      return timeOffsetBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.DetectedAttribute> attributes_ =
        java.util.Collections.emptyList();

    private void ensureAttributesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        attributes_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1.DetectedAttribute>(
                attributes_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.DetectedAttribute,
            com.google.cloud.videointelligence.v1.DetectedAttribute.Builder,
            com.google.cloud.videointelligence.v1.DetectedAttributeOrBuilder>
        attributesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.DetectedAttribute>
        getAttributesList() {
      if (attributesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(attributes_);
      } else {
        return attributesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getAttributesCount() {
      if (attributesBuilder_ == null) {
        return attributes_.size();
      } else {
        return attributesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1.DetectedAttribute getAttributes(int index) {
      if (attributesBuilder_ == null) {
        return attributes_.get(index);
      } else {
        return attributesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAttributes(
        int index, com.google.cloud.videointelligence.v1.DetectedAttribute value) {
      if (attributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributesIsMutable();
        attributes_.set(index, value);
        onChanged();
      } else {
        attributesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAttributes(
        int index,
        com.google.cloud.videointelligence.v1.DetectedAttribute.Builder builderForValue) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        attributes_.set(index, builderForValue.build());
        onChanged();
      } else {
        attributesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAttributes(com.google.cloud.videointelligence.v1.DetectedAttribute value) {
      if (attributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributesIsMutable();
        attributes_.add(value);
        onChanged();
      } else {
        attributesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAttributes(
        int index, com.google.cloud.videointelligence.v1.DetectedAttribute value) {
      if (attributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributesIsMutable();
        attributes_.add(index, value);
        onChanged();
      } else {
        attributesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAttributes(
        com.google.cloud.videointelligence.v1.DetectedAttribute.Builder builderForValue) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        attributes_.add(builderForValue.build());
        onChanged();
      } else {
        attributesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAttributes(
        int index,
        com.google.cloud.videointelligence.v1.DetectedAttribute.Builder builderForValue) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        attributes_.add(index, builderForValue.build());
        onChanged();
      } else {
        attributesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllAttributes(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.DetectedAttribute>
            values) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, attributes_);
        onChanged();
      } else {
        attributesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAttributes() {
      if (attributesBuilder_ == null) {
        attributes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        attributesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAttributes(int index) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        attributes_.remove(index);
        onChanged();
      } else {
        attributesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1.DetectedAttribute.Builder getAttributesBuilder(
        int index) {
      return getAttributesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1.DetectedAttributeOrBuilder getAttributesOrBuilder(
        int index) {
      if (attributesBuilder_ == null) {
        return attributes_.get(index);
      } else {
        return attributesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1.DetectedAttributeOrBuilder>
        getAttributesOrBuilderList() {
      if (attributesBuilder_ != null) {
        return attributesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(attributes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1.DetectedAttribute.Builder addAttributesBuilder() {
      return getAttributesFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1.DetectedAttribute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1.DetectedAttribute.Builder addAttributesBuilder(
        int index) {
      return getAttributesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1.DetectedAttribute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.DetectedAttribute.Builder>
        getAttributesBuilderList() {
      return getAttributesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.DetectedAttribute,
            com.google.cloud.videointelligence.v1.DetectedAttribute.Builder,
            com.google.cloud.videointelligence.v1.DetectedAttributeOrBuilder>
        getAttributesFieldBuilder() {
      if (attributesBuilder_ == null) {
        attributesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.DetectedAttribute,
                com.google.cloud.videointelligence.v1.DetectedAttribute.Builder,
                com.google.cloud.videointelligence.v1.DetectedAttributeOrBuilder>(
                attributes_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        attributes_ = null;
      }
      return attributesBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.DetectedLandmark> landmarks_ =
        java.util.Collections.emptyList();

    private void ensureLandmarksIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        landmarks_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1.DetectedLandmark>(
                landmarks_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.DetectedLandmark,
            com.google.cloud.videointelligence.v1.DetectedLandmark.Builder,
            com.google.cloud.videointelligence.v1.DetectedLandmarkOrBuilder>
        landmarksBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.DetectedLandmark>
        getLandmarksList() {
      if (landmarksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(landmarks_);
      } else {
        return landmarksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getLandmarksCount() {
      if (landmarksBuilder_ == null) {
        return landmarks_.size();
      } else {
        return landmarksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1.DetectedLandmark getLandmarks(int index) {
      if (landmarksBuilder_ == null) {
        return landmarks_.get(index);
      } else {
        return landmarksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLandmarks(
        int index, com.google.cloud.videointelligence.v1.DetectedLandmark value) {
      if (landmarksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLandmarksIsMutable();
        landmarks_.set(index, value);
        onChanged();
      } else {
        landmarksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLandmarks(
        int index, com.google.cloud.videointelligence.v1.DetectedLandmark.Builder builderForValue) {
      if (landmarksBuilder_ == null) {
        ensureLandmarksIsMutable();
        landmarks_.set(index, builderForValue.build());
        onChanged();
      } else {
        landmarksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addLandmarks(com.google.cloud.videointelligence.v1.DetectedLandmark value) {
      if (landmarksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLandmarksIsMutable();
        landmarks_.add(value);
        onChanged();
      } else {
        landmarksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addLandmarks(
        int index, com.google.cloud.videointelligence.v1.DetectedLandmark value) {
      if (landmarksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLandmarksIsMutable();
        landmarks_.add(index, value);
        onChanged();
      } else {
        landmarksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addLandmarks(
        com.google.cloud.videointelligence.v1.DetectedLandmark.Builder builderForValue) {
      if (landmarksBuilder_ == null) {
        ensureLandmarksIsMutable();
        landmarks_.add(builderForValue.build());
        onChanged();
      } else {
        landmarksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addLandmarks(
        int index, com.google.cloud.videointelligence.v1.DetectedLandmark.Builder builderForValue) {
      if (landmarksBuilder_ == null) {
        ensureLandmarksIsMutable();
        landmarks_.add(index, builderForValue.build());
        onChanged();
      } else {
        landmarksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllLandmarks(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.DetectedLandmark>
            values) {
      if (landmarksBuilder_ == null) {
        ensureLandmarksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, landmarks_);
        onChanged();
      } else {
        landmarksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearLandmarks() {
      if (landmarksBuilder_ == null) {
        landmarks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        landmarksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeLandmarks(int index) {
      if (landmarksBuilder_ == null) {
        ensureLandmarksIsMutable();
        landmarks_.remove(index);
        onChanged();
      } else {
        landmarksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1.DetectedLandmark.Builder getLandmarksBuilder(
        int index) {
      return getLandmarksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1.DetectedLandmarkOrBuilder getLandmarksOrBuilder(
        int index) {
      if (landmarksBuilder_ == null) {
        return landmarks_.get(index);
      } else {
        return landmarksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.videointelligence.v1.DetectedLandmarkOrBuilder>
        getLandmarksOrBuilderList() {
      if (landmarksBuilder_ != null) {
        return landmarksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(landmarks_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1.DetectedLandmark.Builder addLandmarksBuilder() {
      return getLandmarksFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1.DetectedLandmark.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1.DetectedLandmark.Builder addLandmarksBuilder(
        int index) {
      return getLandmarksFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1.DetectedLandmark.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The detected landmarks.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.DetectedLandmark landmarks = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.DetectedLandmark.Builder>
        getLandmarksBuilderList() {
      return getLandmarksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.DetectedLandmark,
            com.google.cloud.videointelligence.v1.DetectedLandmark.Builder,
            com.google.cloud.videointelligence.v1.DetectedLandmarkOrBuilder>
        getLandmarksFieldBuilder() {
      if (landmarksBuilder_ == null) {
        landmarksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.DetectedLandmark,
                com.google.cloud.videointelligence.v1.DetectedLandmark.Builder,
                com.google.cloud.videointelligence.v1.DetectedLandmarkOrBuilder>(
                landmarks_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        landmarks_ = null;
      }
      return landmarksBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1.TimestampedObject)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1.TimestampedObject)
  private static final com.google.cloud.videointelligence.v1.TimestampedObject DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.videointelligence.v1.TimestampedObject();
  }

  public static com.google.cloud.videointelligence.v1.TimestampedObject getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TimestampedObject> PARSER =
      new com.google.protobuf.AbstractParser<TimestampedObject>() {
        @java.lang.Override
        public TimestampedObject parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TimestampedObject> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TimestampedObject> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1.TimestampedObject getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
