/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1/video_intelligence.proto

package com.google.cloud.videointelligence.v1;

/**
 *
 *
 * <pre>
 * Video context and/or feature-specific parameters.
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1.VideoContext}
 */
public final class VideoContext extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1.VideoContext)
    VideoContextOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VideoContext.newBuilder() to construct.
  private VideoContext(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VideoContext() {
    segments_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VideoContext();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1_VideoContext_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1_VideoContext_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1.VideoContext.class,
            com.google.cloud.videointelligence.v1.VideoContext.Builder.class);
  }

  public static final int SEGMENTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.VideoSegment> segments_;
  /**
   *
   *
   * <pre>
   * Video segments to annotate. The segments may overlap and are not required
   * to be contiguous or span the whole video. If unspecified, each video is
   * treated as a single segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.VideoSegment> getSegmentsList() {
    return segments_;
  }
  /**
   *
   *
   * <pre>
   * Video segments to annotate. The segments may overlap and are not required
   * to be contiguous or span the whole video. If unspecified, each video is
   * treated as a single segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>
      getSegmentsOrBuilderList() {
    return segments_;
  }
  /**
   *
   *
   * <pre>
   * Video segments to annotate. The segments may overlap and are not required
   * to be contiguous or span the whole video. If unspecified, each video is
   * treated as a single segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
   */
  @java.lang.Override
  public int getSegmentsCount() {
    return segments_.size();
  }
  /**
   *
   *
   * <pre>
   * Video segments to annotate. The segments may overlap and are not required
   * to be contiguous or span the whole video. If unspecified, each video is
   * treated as a single segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.VideoSegment getSegments(int index) {
    return segments_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Video segments to annotate. The segments may overlap and are not required
   * to be contiguous or span the whole video. If unspecified, each video is
   * treated as a single segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder getSegmentsOrBuilder(
      int index) {
    return segments_.get(index);
  }

  public static final int LABEL_DETECTION_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.videointelligence.v1.LabelDetectionConfig labelDetectionConfig_;
  /**
   *
   *
   * <pre>
   * Config for LABEL_DETECTION.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.LabelDetectionConfig label_detection_config = 2;
   * </code>
   *
   * @return Whether the labelDetectionConfig field is set.
   */
  @java.lang.Override
  public boolean hasLabelDetectionConfig() {
    return labelDetectionConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Config for LABEL_DETECTION.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.LabelDetectionConfig label_detection_config = 2;
   * </code>
   *
   * @return The labelDetectionConfig.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.LabelDetectionConfig getLabelDetectionConfig() {
    return labelDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1.LabelDetectionConfig.getDefaultInstance()
        : labelDetectionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Config for LABEL_DETECTION.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.LabelDetectionConfig label_detection_config = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.LabelDetectionConfigOrBuilder
      getLabelDetectionConfigOrBuilder() {
    return labelDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1.LabelDetectionConfig.getDefaultInstance()
        : labelDetectionConfig_;
  }

  public static final int SHOT_CHANGE_DETECTION_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig
      shotChangeDetectionConfig_;
  /**
   *
   *
   * <pre>
   * Config for SHOT_CHANGE_DETECTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1.ShotChangeDetectionConfig shot_change_detection_config = 3;
   * </code>
   *
   * @return Whether the shotChangeDetectionConfig field is set.
   */
  @java.lang.Override
  public boolean hasShotChangeDetectionConfig() {
    return shotChangeDetectionConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Config for SHOT_CHANGE_DETECTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1.ShotChangeDetectionConfig shot_change_detection_config = 3;
   * </code>
   *
   * @return The shotChangeDetectionConfig.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig
      getShotChangeDetectionConfig() {
    return shotChangeDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig.getDefaultInstance()
        : shotChangeDetectionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Config for SHOT_CHANGE_DETECTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1.ShotChangeDetectionConfig shot_change_detection_config = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.ShotChangeDetectionConfigOrBuilder
      getShotChangeDetectionConfigOrBuilder() {
    return shotChangeDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig.getDefaultInstance()
        : shotChangeDetectionConfig_;
  }

  public static final int EXPLICIT_CONTENT_DETECTION_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig
      explicitContentDetectionConfig_;
  /**
   *
   *
   * <pre>
   * Config for EXPLICIT_CONTENT_DETECTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
   * </code>
   *
   * @return Whether the explicitContentDetectionConfig field is set.
   */
  @java.lang.Override
  public boolean hasExplicitContentDetectionConfig() {
    return explicitContentDetectionConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Config for EXPLICIT_CONTENT_DETECTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
   * </code>
   *
   * @return The explicitContentDetectionConfig.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig
      getExplicitContentDetectionConfig() {
    return explicitContentDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig.getDefaultInstance()
        : explicitContentDetectionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Config for EXPLICIT_CONTENT_DETECTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfigOrBuilder
      getExplicitContentDetectionConfigOrBuilder() {
    return explicitContentDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig.getDefaultInstance()
        : explicitContentDetectionConfig_;
  }

  public static final int FACE_DETECTION_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.videointelligence.v1.FaceDetectionConfig faceDetectionConfig_;
  /**
   *
   *
   * <pre>
   * Config for FACE_DETECTION.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.FaceDetectionConfig face_detection_config = 5;</code>
   *
   * @return Whether the faceDetectionConfig field is set.
   */
  @java.lang.Override
  public boolean hasFaceDetectionConfig() {
    return faceDetectionConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Config for FACE_DETECTION.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.FaceDetectionConfig face_detection_config = 5;</code>
   *
   * @return The faceDetectionConfig.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.FaceDetectionConfig getFaceDetectionConfig() {
    return faceDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1.FaceDetectionConfig.getDefaultInstance()
        : faceDetectionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Config for FACE_DETECTION.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.FaceDetectionConfig face_detection_config = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.FaceDetectionConfigOrBuilder
      getFaceDetectionConfigOrBuilder() {
    return faceDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1.FaceDetectionConfig.getDefaultInstance()
        : faceDetectionConfig_;
  }

  public static final int SPEECH_TRANSCRIPTION_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig
      speechTranscriptionConfig_;
  /**
   *
   *
   * <pre>
   * Config for SPEECH_TRANSCRIPTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1.SpeechTranscriptionConfig speech_transcription_config = 6;
   * </code>
   *
   * @return Whether the speechTranscriptionConfig field is set.
   */
  @java.lang.Override
  public boolean hasSpeechTranscriptionConfig() {
    return speechTranscriptionConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Config for SPEECH_TRANSCRIPTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1.SpeechTranscriptionConfig speech_transcription_config = 6;
   * </code>
   *
   * @return The speechTranscriptionConfig.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig
      getSpeechTranscriptionConfig() {
    return speechTranscriptionConfig_ == null
        ? com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig.getDefaultInstance()
        : speechTranscriptionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Config for SPEECH_TRANSCRIPTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1.SpeechTranscriptionConfig speech_transcription_config = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.SpeechTranscriptionConfigOrBuilder
      getSpeechTranscriptionConfigOrBuilder() {
    return speechTranscriptionConfig_ == null
        ? com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig.getDefaultInstance()
        : speechTranscriptionConfig_;
  }

  public static final int TEXT_DETECTION_CONFIG_FIELD_NUMBER = 8;
  private com.google.cloud.videointelligence.v1.TextDetectionConfig textDetectionConfig_;
  /**
   *
   *
   * <pre>
   * Config for TEXT_DETECTION.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.TextDetectionConfig text_detection_config = 8;</code>
   *
   * @return Whether the textDetectionConfig field is set.
   */
  @java.lang.Override
  public boolean hasTextDetectionConfig() {
    return textDetectionConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Config for TEXT_DETECTION.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.TextDetectionConfig text_detection_config = 8;</code>
   *
   * @return The textDetectionConfig.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.TextDetectionConfig getTextDetectionConfig() {
    return textDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1.TextDetectionConfig.getDefaultInstance()
        : textDetectionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Config for TEXT_DETECTION.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.TextDetectionConfig text_detection_config = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.TextDetectionConfigOrBuilder
      getTextDetectionConfigOrBuilder() {
    return textDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1.TextDetectionConfig.getDefaultInstance()
        : textDetectionConfig_;
  }

  public static final int PERSON_DETECTION_CONFIG_FIELD_NUMBER = 11;
  private com.google.cloud.videointelligence.v1.PersonDetectionConfig personDetectionConfig_;
  /**
   *
   *
   * <pre>
   * Config for PERSON_DETECTION.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.PersonDetectionConfig person_detection_config = 11;
   * </code>
   *
   * @return Whether the personDetectionConfig field is set.
   */
  @java.lang.Override
  public boolean hasPersonDetectionConfig() {
    return personDetectionConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Config for PERSON_DETECTION.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.PersonDetectionConfig person_detection_config = 11;
   * </code>
   *
   * @return The personDetectionConfig.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.PersonDetectionConfig getPersonDetectionConfig() {
    return personDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1.PersonDetectionConfig.getDefaultInstance()
        : personDetectionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Config for PERSON_DETECTION.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.PersonDetectionConfig person_detection_config = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.PersonDetectionConfigOrBuilder
      getPersonDetectionConfigOrBuilder() {
    return personDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1.PersonDetectionConfig.getDefaultInstance()
        : personDetectionConfig_;
  }

  public static final int OBJECT_TRACKING_CONFIG_FIELD_NUMBER = 13;
  private com.google.cloud.videointelligence.v1.ObjectTrackingConfig objectTrackingConfig_;
  /**
   *
   *
   * <pre>
   * Config for OBJECT_TRACKING.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.ObjectTrackingConfig object_tracking_config = 13;
   * </code>
   *
   * @return Whether the objectTrackingConfig field is set.
   */
  @java.lang.Override
  public boolean hasObjectTrackingConfig() {
    return objectTrackingConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Config for OBJECT_TRACKING.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.ObjectTrackingConfig object_tracking_config = 13;
   * </code>
   *
   * @return The objectTrackingConfig.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.ObjectTrackingConfig getObjectTrackingConfig() {
    return objectTrackingConfig_ == null
        ? com.google.cloud.videointelligence.v1.ObjectTrackingConfig.getDefaultInstance()
        : objectTrackingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Config for OBJECT_TRACKING.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.ObjectTrackingConfig object_tracking_config = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.ObjectTrackingConfigOrBuilder
      getObjectTrackingConfigOrBuilder() {
    return objectTrackingConfig_ == null
        ? com.google.cloud.videointelligence.v1.ObjectTrackingConfig.getDefaultInstance()
        : objectTrackingConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < segments_.size(); i++) {
      output.writeMessage(1, segments_.get(i));
    }
    if (labelDetectionConfig_ != null) {
      output.writeMessage(2, getLabelDetectionConfig());
    }
    if (shotChangeDetectionConfig_ != null) {
      output.writeMessage(3, getShotChangeDetectionConfig());
    }
    if (explicitContentDetectionConfig_ != null) {
      output.writeMessage(4, getExplicitContentDetectionConfig());
    }
    if (faceDetectionConfig_ != null) {
      output.writeMessage(5, getFaceDetectionConfig());
    }
    if (speechTranscriptionConfig_ != null) {
      output.writeMessage(6, getSpeechTranscriptionConfig());
    }
    if (textDetectionConfig_ != null) {
      output.writeMessage(8, getTextDetectionConfig());
    }
    if (personDetectionConfig_ != null) {
      output.writeMessage(11, getPersonDetectionConfig());
    }
    if (objectTrackingConfig_ != null) {
      output.writeMessage(13, getObjectTrackingConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < segments_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, segments_.get(i));
    }
    if (labelDetectionConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLabelDetectionConfig());
    }
    if (shotChangeDetectionConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, getShotChangeDetectionConfig());
    }
    if (explicitContentDetectionConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, getExplicitContentDetectionConfig());
    }
    if (faceDetectionConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getFaceDetectionConfig());
    }
    if (speechTranscriptionConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, getSpeechTranscriptionConfig());
    }
    if (textDetectionConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getTextDetectionConfig());
    }
    if (personDetectionConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(11, getPersonDetectionConfig());
    }
    if (objectTrackingConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(13, getObjectTrackingConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.videointelligence.v1.VideoContext)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1.VideoContext other =
        (com.google.cloud.videointelligence.v1.VideoContext) obj;

    if (!getSegmentsList().equals(other.getSegmentsList())) return false;
    if (hasLabelDetectionConfig() != other.hasLabelDetectionConfig()) return false;
    if (hasLabelDetectionConfig()) {
      if (!getLabelDetectionConfig().equals(other.getLabelDetectionConfig())) return false;
    }
    if (hasShotChangeDetectionConfig() != other.hasShotChangeDetectionConfig()) return false;
    if (hasShotChangeDetectionConfig()) {
      if (!getShotChangeDetectionConfig().equals(other.getShotChangeDetectionConfig()))
        return false;
    }
    if (hasExplicitContentDetectionConfig() != other.hasExplicitContentDetectionConfig())
      return false;
    if (hasExplicitContentDetectionConfig()) {
      if (!getExplicitContentDetectionConfig().equals(other.getExplicitContentDetectionConfig()))
        return false;
    }
    if (hasFaceDetectionConfig() != other.hasFaceDetectionConfig()) return false;
    if (hasFaceDetectionConfig()) {
      if (!getFaceDetectionConfig().equals(other.getFaceDetectionConfig())) return false;
    }
    if (hasSpeechTranscriptionConfig() != other.hasSpeechTranscriptionConfig()) return false;
    if (hasSpeechTranscriptionConfig()) {
      if (!getSpeechTranscriptionConfig().equals(other.getSpeechTranscriptionConfig()))
        return false;
    }
    if (hasTextDetectionConfig() != other.hasTextDetectionConfig()) return false;
    if (hasTextDetectionConfig()) {
      if (!getTextDetectionConfig().equals(other.getTextDetectionConfig())) return false;
    }
    if (hasPersonDetectionConfig() != other.hasPersonDetectionConfig()) return false;
    if (hasPersonDetectionConfig()) {
      if (!getPersonDetectionConfig().equals(other.getPersonDetectionConfig())) return false;
    }
    if (hasObjectTrackingConfig() != other.hasObjectTrackingConfig()) return false;
    if (hasObjectTrackingConfig()) {
      if (!getObjectTrackingConfig().equals(other.getObjectTrackingConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getSegmentsCount() > 0) {
      hash = (37 * hash) + SEGMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getSegmentsList().hashCode();
    }
    if (hasLabelDetectionConfig()) {
      hash = (37 * hash) + LABEL_DETECTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLabelDetectionConfig().hashCode();
    }
    if (hasShotChangeDetectionConfig()) {
      hash = (37 * hash) + SHOT_CHANGE_DETECTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getShotChangeDetectionConfig().hashCode();
    }
    if (hasExplicitContentDetectionConfig()) {
      hash = (37 * hash) + EXPLICIT_CONTENT_DETECTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getExplicitContentDetectionConfig().hashCode();
    }
    if (hasFaceDetectionConfig()) {
      hash = (37 * hash) + FACE_DETECTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getFaceDetectionConfig().hashCode();
    }
    if (hasSpeechTranscriptionConfig()) {
      hash = (37 * hash) + SPEECH_TRANSCRIPTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSpeechTranscriptionConfig().hashCode();
    }
    if (hasTextDetectionConfig()) {
      hash = (37 * hash) + TEXT_DETECTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getTextDetectionConfig().hashCode();
    }
    if (hasPersonDetectionConfig()) {
      hash = (37 * hash) + PERSON_DETECTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPersonDetectionConfig().hashCode();
    }
    if (hasObjectTrackingConfig()) {
      hash = (37 * hash) + OBJECT_TRACKING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getObjectTrackingConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1.VideoContext parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1.VideoContext parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.VideoContext parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1.VideoContext parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.VideoContext parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1.VideoContext parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.VideoContext parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1.VideoContext parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.VideoContext parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1.VideoContext parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.VideoContext parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1.VideoContext parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.videointelligence.v1.VideoContext prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Video context and/or feature-specific parameters.
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1.VideoContext}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1.VideoContext)
      com.google.cloud.videointelligence.v1.VideoContextOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1_VideoContext_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1_VideoContext_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1.VideoContext.class,
              com.google.cloud.videointelligence.v1.VideoContext.Builder.class);
    }

    // Construct using com.google.cloud.videointelligence.v1.VideoContext.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (segmentsBuilder_ == null) {
        segments_ = java.util.Collections.emptyList();
      } else {
        segments_ = null;
        segmentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      labelDetectionConfig_ = null;
      if (labelDetectionConfigBuilder_ != null) {
        labelDetectionConfigBuilder_.dispose();
        labelDetectionConfigBuilder_ = null;
      }
      shotChangeDetectionConfig_ = null;
      if (shotChangeDetectionConfigBuilder_ != null) {
        shotChangeDetectionConfigBuilder_.dispose();
        shotChangeDetectionConfigBuilder_ = null;
      }
      explicitContentDetectionConfig_ = null;
      if (explicitContentDetectionConfigBuilder_ != null) {
        explicitContentDetectionConfigBuilder_.dispose();
        explicitContentDetectionConfigBuilder_ = null;
      }
      faceDetectionConfig_ = null;
      if (faceDetectionConfigBuilder_ != null) {
        faceDetectionConfigBuilder_.dispose();
        faceDetectionConfigBuilder_ = null;
      }
      speechTranscriptionConfig_ = null;
      if (speechTranscriptionConfigBuilder_ != null) {
        speechTranscriptionConfigBuilder_.dispose();
        speechTranscriptionConfigBuilder_ = null;
      }
      textDetectionConfig_ = null;
      if (textDetectionConfigBuilder_ != null) {
        textDetectionConfigBuilder_.dispose();
        textDetectionConfigBuilder_ = null;
      }
      personDetectionConfig_ = null;
      if (personDetectionConfigBuilder_ != null) {
        personDetectionConfigBuilder_.dispose();
        personDetectionConfigBuilder_ = null;
      }
      objectTrackingConfig_ = null;
      if (objectTrackingConfigBuilder_ != null) {
        objectTrackingConfigBuilder_.dispose();
        objectTrackingConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1_VideoContext_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1.VideoContext getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1.VideoContext.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1.VideoContext build() {
      com.google.cloud.videointelligence.v1.VideoContext result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1.VideoContext buildPartial() {
      com.google.cloud.videointelligence.v1.VideoContext result =
          new com.google.cloud.videointelligence.v1.VideoContext(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.videointelligence.v1.VideoContext result) {
      if (segmentsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          segments_ = java.util.Collections.unmodifiableList(segments_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.segments_ = segments_;
      } else {
        result.segments_ = segmentsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.videointelligence.v1.VideoContext result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.labelDetectionConfig_ =
            labelDetectionConfigBuilder_ == null
                ? labelDetectionConfig_
                : labelDetectionConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.shotChangeDetectionConfig_ =
            shotChangeDetectionConfigBuilder_ == null
                ? shotChangeDetectionConfig_
                : shotChangeDetectionConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.explicitContentDetectionConfig_ =
            explicitContentDetectionConfigBuilder_ == null
                ? explicitContentDetectionConfig_
                : explicitContentDetectionConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.faceDetectionConfig_ =
            faceDetectionConfigBuilder_ == null
                ? faceDetectionConfig_
                : faceDetectionConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.speechTranscriptionConfig_ =
            speechTranscriptionConfigBuilder_ == null
                ? speechTranscriptionConfig_
                : speechTranscriptionConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.textDetectionConfig_ =
            textDetectionConfigBuilder_ == null
                ? textDetectionConfig_
                : textDetectionConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.personDetectionConfig_ =
            personDetectionConfigBuilder_ == null
                ? personDetectionConfig_
                : personDetectionConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.objectTrackingConfig_ =
            objectTrackingConfigBuilder_ == null
                ? objectTrackingConfig_
                : objectTrackingConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.videointelligence.v1.VideoContext) {
        return mergeFrom((com.google.cloud.videointelligence.v1.VideoContext) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.videointelligence.v1.VideoContext other) {
      if (other == com.google.cloud.videointelligence.v1.VideoContext.getDefaultInstance())
        return this;
      if (segmentsBuilder_ == null) {
        if (!other.segments_.isEmpty()) {
          if (segments_.isEmpty()) {
            segments_ = other.segments_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSegmentsIsMutable();
            segments_.addAll(other.segments_);
          }
          onChanged();
        }
      } else {
        if (!other.segments_.isEmpty()) {
          if (segmentsBuilder_.isEmpty()) {
            segmentsBuilder_.dispose();
            segmentsBuilder_ = null;
            segments_ = other.segments_;
            bitField0_ = (bitField0_ & ~0x00000001);
            segmentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSegmentsFieldBuilder()
                    : null;
          } else {
            segmentsBuilder_.addAllMessages(other.segments_);
          }
        }
      }
      if (other.hasLabelDetectionConfig()) {
        mergeLabelDetectionConfig(other.getLabelDetectionConfig());
      }
      if (other.hasShotChangeDetectionConfig()) {
        mergeShotChangeDetectionConfig(other.getShotChangeDetectionConfig());
      }
      if (other.hasExplicitContentDetectionConfig()) {
        mergeExplicitContentDetectionConfig(other.getExplicitContentDetectionConfig());
      }
      if (other.hasFaceDetectionConfig()) {
        mergeFaceDetectionConfig(other.getFaceDetectionConfig());
      }
      if (other.hasSpeechTranscriptionConfig()) {
        mergeSpeechTranscriptionConfig(other.getSpeechTranscriptionConfig());
      }
      if (other.hasTextDetectionConfig()) {
        mergeTextDetectionConfig(other.getTextDetectionConfig());
      }
      if (other.hasPersonDetectionConfig()) {
        mergePersonDetectionConfig(other.getPersonDetectionConfig());
      }
      if (other.hasObjectTrackingConfig()) {
        mergeObjectTrackingConfig(other.getObjectTrackingConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.videointelligence.v1.VideoSegment m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.VideoSegment.parser(),
                        extensionRegistry);
                if (segmentsBuilder_ == null) {
                  ensureSegmentsIsMutable();
                  segments_.add(m);
                } else {
                  segmentsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getLabelDetectionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getShotChangeDetectionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getExplicitContentDetectionConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getFaceDetectionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getSpeechTranscriptionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 66:
              {
                input.readMessage(
                    getTextDetectionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 90:
              {
                input.readMessage(
                    getPersonDetectionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 90
            case 106:
              {
                input.readMessage(
                    getObjectTrackingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.videointelligence.v1.VideoSegment> segments_ =
        java.util.Collections.emptyList();

    private void ensureSegmentsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        segments_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1.VideoSegment>(segments_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.VideoSegment,
            com.google.cloud.videointelligence.v1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>
        segmentsBuilder_;

    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.VideoSegment> getSegmentsList() {
      if (segmentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(segments_);
      } else {
        return segmentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public int getSegmentsCount() {
      if (segmentsBuilder_ == null) {
        return segments_.size();
      } else {
        return segmentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegment getSegments(int index) {
      if (segmentsBuilder_ == null) {
        return segments_.get(index);
      } else {
        return segmentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public Builder setSegments(
        int index, com.google.cloud.videointelligence.v1.VideoSegment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.set(index, value);
        onChanged();
      } else {
        segmentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public Builder setSegments(
        int index, com.google.cloud.videointelligence.v1.VideoSegment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.set(index, builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public Builder addSegments(com.google.cloud.videointelligence.v1.VideoSegment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.add(value);
        onChanged();
      } else {
        segmentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public Builder addSegments(
        int index, com.google.cloud.videointelligence.v1.VideoSegment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.add(index, value);
        onChanged();
      } else {
        segmentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public Builder addSegments(
        com.google.cloud.videointelligence.v1.VideoSegment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.add(builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public Builder addSegments(
        int index, com.google.cloud.videointelligence.v1.VideoSegment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.add(index, builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public Builder addAllSegments(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.VideoSegment> values) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, segments_);
        onChanged();
      } else {
        segmentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public Builder clearSegments() {
      if (segmentsBuilder_ == null) {
        segments_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        segmentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public Builder removeSegments(int index) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.remove(index);
        onChanged();
      } else {
        segmentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegment.Builder getSegmentsBuilder(
        int index) {
      return getSegmentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder getSegmentsOrBuilder(
        int index) {
      if (segmentsBuilder_ == null) {
        return segments_.get(index);
      } else {
        return segmentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>
        getSegmentsOrBuilderList() {
      if (segmentsBuilder_ != null) {
        return segmentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(segments_);
      }
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegment.Builder addSegmentsBuilder() {
      return getSegmentsFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1.VideoSegment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegment.Builder addSegmentsBuilder(
        int index) {
      return getSegmentsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1.VideoSegment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 1;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.VideoSegment.Builder>
        getSegmentsBuilderList() {
      return getSegmentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.VideoSegment,
            com.google.cloud.videointelligence.v1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>
        getSegmentsFieldBuilder() {
      if (segmentsBuilder_ == null) {
        segmentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.VideoSegment,
                com.google.cloud.videointelligence.v1.VideoSegment.Builder,
                com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>(
                segments_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        segments_ = null;
      }
      return segmentsBuilder_;
    }

    private com.google.cloud.videointelligence.v1.LabelDetectionConfig labelDetectionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.LabelDetectionConfig,
            com.google.cloud.videointelligence.v1.LabelDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1.LabelDetectionConfigOrBuilder>
        labelDetectionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     *
     * @return Whether the labelDetectionConfig field is set.
     */
    public boolean hasLabelDetectionConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     *
     * @return The labelDetectionConfig.
     */
    public com.google.cloud.videointelligence.v1.LabelDetectionConfig getLabelDetectionConfig() {
      if (labelDetectionConfigBuilder_ == null) {
        return labelDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1.LabelDetectionConfig.getDefaultInstance()
            : labelDetectionConfig_;
      } else {
        return labelDetectionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     */
    public Builder setLabelDetectionConfig(
        com.google.cloud.videointelligence.v1.LabelDetectionConfig value) {
      if (labelDetectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        labelDetectionConfig_ = value;
      } else {
        labelDetectionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     */
    public Builder setLabelDetectionConfig(
        com.google.cloud.videointelligence.v1.LabelDetectionConfig.Builder builderForValue) {
      if (labelDetectionConfigBuilder_ == null) {
        labelDetectionConfig_ = builderForValue.build();
      } else {
        labelDetectionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     */
    public Builder mergeLabelDetectionConfig(
        com.google.cloud.videointelligence.v1.LabelDetectionConfig value) {
      if (labelDetectionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && labelDetectionConfig_ != null
            && labelDetectionConfig_
                != com.google.cloud.videointelligence.v1.LabelDetectionConfig
                    .getDefaultInstance()) {
          getLabelDetectionConfigBuilder().mergeFrom(value);
        } else {
          labelDetectionConfig_ = value;
        }
      } else {
        labelDetectionConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     */
    public Builder clearLabelDetectionConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      labelDetectionConfig_ = null;
      if (labelDetectionConfigBuilder_ != null) {
        labelDetectionConfigBuilder_.dispose();
        labelDetectionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelDetectionConfig.Builder
        getLabelDetectionConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getLabelDetectionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelDetectionConfigOrBuilder
        getLabelDetectionConfigOrBuilder() {
      if (labelDetectionConfigBuilder_ != null) {
        return labelDetectionConfigBuilder_.getMessageOrBuilder();
      } else {
        return labelDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1.LabelDetectionConfig.getDefaultInstance()
            : labelDetectionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.LabelDetectionConfig,
            com.google.cloud.videointelligence.v1.LabelDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1.LabelDetectionConfigOrBuilder>
        getLabelDetectionConfigFieldBuilder() {
      if (labelDetectionConfigBuilder_ == null) {
        labelDetectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1.LabelDetectionConfig,
                com.google.cloud.videointelligence.v1.LabelDetectionConfig.Builder,
                com.google.cloud.videointelligence.v1.LabelDetectionConfigOrBuilder>(
                getLabelDetectionConfig(), getParentForChildren(), isClean());
        labelDetectionConfig_ = null;
      }
      return labelDetectionConfigBuilder_;
    }

    private com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig
        shotChangeDetectionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig,
            com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1.ShotChangeDetectionConfigOrBuilder>
        shotChangeDetectionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     *
     * @return Whether the shotChangeDetectionConfig field is set.
     */
    public boolean hasShotChangeDetectionConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     *
     * @return The shotChangeDetectionConfig.
     */
    public com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig
        getShotChangeDetectionConfig() {
      if (shotChangeDetectionConfigBuilder_ == null) {
        return shotChangeDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig.getDefaultInstance()
            : shotChangeDetectionConfig_;
      } else {
        return shotChangeDetectionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     */
    public Builder setShotChangeDetectionConfig(
        com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig value) {
      if (shotChangeDetectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        shotChangeDetectionConfig_ = value;
      } else {
        shotChangeDetectionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     */
    public Builder setShotChangeDetectionConfig(
        com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig.Builder builderForValue) {
      if (shotChangeDetectionConfigBuilder_ == null) {
        shotChangeDetectionConfig_ = builderForValue.build();
      } else {
        shotChangeDetectionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     */
    public Builder mergeShotChangeDetectionConfig(
        com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig value) {
      if (shotChangeDetectionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && shotChangeDetectionConfig_ != null
            && shotChangeDetectionConfig_
                != com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig
                    .getDefaultInstance()) {
          getShotChangeDetectionConfigBuilder().mergeFrom(value);
        } else {
          shotChangeDetectionConfig_ = value;
        }
      } else {
        shotChangeDetectionConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     */
    public Builder clearShotChangeDetectionConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      shotChangeDetectionConfig_ = null;
      if (shotChangeDetectionConfigBuilder_ != null) {
        shotChangeDetectionConfigBuilder_.dispose();
        shotChangeDetectionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig.Builder
        getShotChangeDetectionConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getShotChangeDetectionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.ShotChangeDetectionConfigOrBuilder
        getShotChangeDetectionConfigOrBuilder() {
      if (shotChangeDetectionConfigBuilder_ != null) {
        return shotChangeDetectionConfigBuilder_.getMessageOrBuilder();
      } else {
        return shotChangeDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig.getDefaultInstance()
            : shotChangeDetectionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig,
            com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1.ShotChangeDetectionConfigOrBuilder>
        getShotChangeDetectionConfigFieldBuilder() {
      if (shotChangeDetectionConfigBuilder_ == null) {
        shotChangeDetectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig,
                com.google.cloud.videointelligence.v1.ShotChangeDetectionConfig.Builder,
                com.google.cloud.videointelligence.v1.ShotChangeDetectionConfigOrBuilder>(
                getShotChangeDetectionConfig(), getParentForChildren(), isClean());
        shotChangeDetectionConfig_ = null;
      }
      return shotChangeDetectionConfigBuilder_;
    }

    private com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig
        explicitContentDetectionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig,
            com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfigOrBuilder>
        explicitContentDetectionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     *
     * @return Whether the explicitContentDetectionConfig field is set.
     */
    public boolean hasExplicitContentDetectionConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     *
     * @return The explicitContentDetectionConfig.
     */
    public com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig
        getExplicitContentDetectionConfig() {
      if (explicitContentDetectionConfigBuilder_ == null) {
        return explicitContentDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig
                .getDefaultInstance()
            : explicitContentDetectionConfig_;
      } else {
        return explicitContentDetectionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     */
    public Builder setExplicitContentDetectionConfig(
        com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig value) {
      if (explicitContentDetectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explicitContentDetectionConfig_ = value;
      } else {
        explicitContentDetectionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     */
    public Builder setExplicitContentDetectionConfig(
        com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig.Builder
            builderForValue) {
      if (explicitContentDetectionConfigBuilder_ == null) {
        explicitContentDetectionConfig_ = builderForValue.build();
      } else {
        explicitContentDetectionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     */
    public Builder mergeExplicitContentDetectionConfig(
        com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig value) {
      if (explicitContentDetectionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && explicitContentDetectionConfig_ != null
            && explicitContentDetectionConfig_
                != com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig
                    .getDefaultInstance()) {
          getExplicitContentDetectionConfigBuilder().mergeFrom(value);
        } else {
          explicitContentDetectionConfig_ = value;
        }
      } else {
        explicitContentDetectionConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     */
    public Builder clearExplicitContentDetectionConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      explicitContentDetectionConfig_ = null;
      if (explicitContentDetectionConfigBuilder_ != null) {
        explicitContentDetectionConfigBuilder_.dispose();
        explicitContentDetectionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig.Builder
        getExplicitContentDetectionConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getExplicitContentDetectionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfigOrBuilder
        getExplicitContentDetectionConfigOrBuilder() {
      if (explicitContentDetectionConfigBuilder_ != null) {
        return explicitContentDetectionConfigBuilder_.getMessageOrBuilder();
      } else {
        return explicitContentDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig
                .getDefaultInstance()
            : explicitContentDetectionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig,
            com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfigOrBuilder>
        getExplicitContentDetectionConfigFieldBuilder() {
      if (explicitContentDetectionConfigBuilder_ == null) {
        explicitContentDetectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig,
                com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfig.Builder,
                com.google.cloud.videointelligence.v1.ExplicitContentDetectionConfigOrBuilder>(
                getExplicitContentDetectionConfig(), getParentForChildren(), isClean());
        explicitContentDetectionConfig_ = null;
      }
      return explicitContentDetectionConfigBuilder_;
    }

    private com.google.cloud.videointelligence.v1.FaceDetectionConfig faceDetectionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.FaceDetectionConfig,
            com.google.cloud.videointelligence.v1.FaceDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1.FaceDetectionConfigOrBuilder>
        faceDetectionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for FACE_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.FaceDetectionConfig face_detection_config = 5;
     * </code>
     *
     * @return Whether the faceDetectionConfig field is set.
     */
    public boolean hasFaceDetectionConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Config for FACE_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.FaceDetectionConfig face_detection_config = 5;
     * </code>
     *
     * @return The faceDetectionConfig.
     */
    public com.google.cloud.videointelligence.v1.FaceDetectionConfig getFaceDetectionConfig() {
      if (faceDetectionConfigBuilder_ == null) {
        return faceDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1.FaceDetectionConfig.getDefaultInstance()
            : faceDetectionConfig_;
      } else {
        return faceDetectionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for FACE_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.FaceDetectionConfig face_detection_config = 5;
     * </code>
     */
    public Builder setFaceDetectionConfig(
        com.google.cloud.videointelligence.v1.FaceDetectionConfig value) {
      if (faceDetectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        faceDetectionConfig_ = value;
      } else {
        faceDetectionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for FACE_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.FaceDetectionConfig face_detection_config = 5;
     * </code>
     */
    public Builder setFaceDetectionConfig(
        com.google.cloud.videointelligence.v1.FaceDetectionConfig.Builder builderForValue) {
      if (faceDetectionConfigBuilder_ == null) {
        faceDetectionConfig_ = builderForValue.build();
      } else {
        faceDetectionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for FACE_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.FaceDetectionConfig face_detection_config = 5;
     * </code>
     */
    public Builder mergeFaceDetectionConfig(
        com.google.cloud.videointelligence.v1.FaceDetectionConfig value) {
      if (faceDetectionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && faceDetectionConfig_ != null
            && faceDetectionConfig_
                != com.google.cloud.videointelligence.v1.FaceDetectionConfig.getDefaultInstance()) {
          getFaceDetectionConfigBuilder().mergeFrom(value);
        } else {
          faceDetectionConfig_ = value;
        }
      } else {
        faceDetectionConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for FACE_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.FaceDetectionConfig face_detection_config = 5;
     * </code>
     */
    public Builder clearFaceDetectionConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      faceDetectionConfig_ = null;
      if (faceDetectionConfigBuilder_ != null) {
        faceDetectionConfigBuilder_.dispose();
        faceDetectionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for FACE_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.FaceDetectionConfig face_detection_config = 5;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.FaceDetectionConfig.Builder
        getFaceDetectionConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getFaceDetectionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for FACE_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.FaceDetectionConfig face_detection_config = 5;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.FaceDetectionConfigOrBuilder
        getFaceDetectionConfigOrBuilder() {
      if (faceDetectionConfigBuilder_ != null) {
        return faceDetectionConfigBuilder_.getMessageOrBuilder();
      } else {
        return faceDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1.FaceDetectionConfig.getDefaultInstance()
            : faceDetectionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Config for FACE_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.FaceDetectionConfig face_detection_config = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.FaceDetectionConfig,
            com.google.cloud.videointelligence.v1.FaceDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1.FaceDetectionConfigOrBuilder>
        getFaceDetectionConfigFieldBuilder() {
      if (faceDetectionConfigBuilder_ == null) {
        faceDetectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1.FaceDetectionConfig,
                com.google.cloud.videointelligence.v1.FaceDetectionConfig.Builder,
                com.google.cloud.videointelligence.v1.FaceDetectionConfigOrBuilder>(
                getFaceDetectionConfig(), getParentForChildren(), isClean());
        faceDetectionConfig_ = null;
      }
      return faceDetectionConfigBuilder_;
    }

    private com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig
        speechTranscriptionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig,
            com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig.Builder,
            com.google.cloud.videointelligence.v1.SpeechTranscriptionConfigOrBuilder>
        speechTranscriptionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for SPEECH_TRANSCRIPTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.SpeechTranscriptionConfig speech_transcription_config = 6;
     * </code>
     *
     * @return Whether the speechTranscriptionConfig field is set.
     */
    public boolean hasSpeechTranscriptionConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Config for SPEECH_TRANSCRIPTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.SpeechTranscriptionConfig speech_transcription_config = 6;
     * </code>
     *
     * @return The speechTranscriptionConfig.
     */
    public com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig
        getSpeechTranscriptionConfig() {
      if (speechTranscriptionConfigBuilder_ == null) {
        return speechTranscriptionConfig_ == null
            ? com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig.getDefaultInstance()
            : speechTranscriptionConfig_;
      } else {
        return speechTranscriptionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for SPEECH_TRANSCRIPTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.SpeechTranscriptionConfig speech_transcription_config = 6;
     * </code>
     */
    public Builder setSpeechTranscriptionConfig(
        com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig value) {
      if (speechTranscriptionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        speechTranscriptionConfig_ = value;
      } else {
        speechTranscriptionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for SPEECH_TRANSCRIPTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.SpeechTranscriptionConfig speech_transcription_config = 6;
     * </code>
     */
    public Builder setSpeechTranscriptionConfig(
        com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig.Builder builderForValue) {
      if (speechTranscriptionConfigBuilder_ == null) {
        speechTranscriptionConfig_ = builderForValue.build();
      } else {
        speechTranscriptionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for SPEECH_TRANSCRIPTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.SpeechTranscriptionConfig speech_transcription_config = 6;
     * </code>
     */
    public Builder mergeSpeechTranscriptionConfig(
        com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig value) {
      if (speechTranscriptionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && speechTranscriptionConfig_ != null
            && speechTranscriptionConfig_
                != com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig
                    .getDefaultInstance()) {
          getSpeechTranscriptionConfigBuilder().mergeFrom(value);
        } else {
          speechTranscriptionConfig_ = value;
        }
      } else {
        speechTranscriptionConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for SPEECH_TRANSCRIPTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.SpeechTranscriptionConfig speech_transcription_config = 6;
     * </code>
     */
    public Builder clearSpeechTranscriptionConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      speechTranscriptionConfig_ = null;
      if (speechTranscriptionConfigBuilder_ != null) {
        speechTranscriptionConfigBuilder_.dispose();
        speechTranscriptionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for SPEECH_TRANSCRIPTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.SpeechTranscriptionConfig speech_transcription_config = 6;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig.Builder
        getSpeechTranscriptionConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getSpeechTranscriptionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for SPEECH_TRANSCRIPTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.SpeechTranscriptionConfig speech_transcription_config = 6;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.SpeechTranscriptionConfigOrBuilder
        getSpeechTranscriptionConfigOrBuilder() {
      if (speechTranscriptionConfigBuilder_ != null) {
        return speechTranscriptionConfigBuilder_.getMessageOrBuilder();
      } else {
        return speechTranscriptionConfig_ == null
            ? com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig.getDefaultInstance()
            : speechTranscriptionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Config for SPEECH_TRANSCRIPTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1.SpeechTranscriptionConfig speech_transcription_config = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig,
            com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig.Builder,
            com.google.cloud.videointelligence.v1.SpeechTranscriptionConfigOrBuilder>
        getSpeechTranscriptionConfigFieldBuilder() {
      if (speechTranscriptionConfigBuilder_ == null) {
        speechTranscriptionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig,
                com.google.cloud.videointelligence.v1.SpeechTranscriptionConfig.Builder,
                com.google.cloud.videointelligence.v1.SpeechTranscriptionConfigOrBuilder>(
                getSpeechTranscriptionConfig(), getParentForChildren(), isClean());
        speechTranscriptionConfig_ = null;
      }
      return speechTranscriptionConfigBuilder_;
    }

    private com.google.cloud.videointelligence.v1.TextDetectionConfig textDetectionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.TextDetectionConfig,
            com.google.cloud.videointelligence.v1.TextDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1.TextDetectionConfigOrBuilder>
        textDetectionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.TextDetectionConfig text_detection_config = 8;
     * </code>
     *
     * @return Whether the textDetectionConfig field is set.
     */
    public boolean hasTextDetectionConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.TextDetectionConfig text_detection_config = 8;
     * </code>
     *
     * @return The textDetectionConfig.
     */
    public com.google.cloud.videointelligence.v1.TextDetectionConfig getTextDetectionConfig() {
      if (textDetectionConfigBuilder_ == null) {
        return textDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1.TextDetectionConfig.getDefaultInstance()
            : textDetectionConfig_;
      } else {
        return textDetectionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.TextDetectionConfig text_detection_config = 8;
     * </code>
     */
    public Builder setTextDetectionConfig(
        com.google.cloud.videointelligence.v1.TextDetectionConfig value) {
      if (textDetectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        textDetectionConfig_ = value;
      } else {
        textDetectionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.TextDetectionConfig text_detection_config = 8;
     * </code>
     */
    public Builder setTextDetectionConfig(
        com.google.cloud.videointelligence.v1.TextDetectionConfig.Builder builderForValue) {
      if (textDetectionConfigBuilder_ == null) {
        textDetectionConfig_ = builderForValue.build();
      } else {
        textDetectionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.TextDetectionConfig text_detection_config = 8;
     * </code>
     */
    public Builder mergeTextDetectionConfig(
        com.google.cloud.videointelligence.v1.TextDetectionConfig value) {
      if (textDetectionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && textDetectionConfig_ != null
            && textDetectionConfig_
                != com.google.cloud.videointelligence.v1.TextDetectionConfig.getDefaultInstance()) {
          getTextDetectionConfigBuilder().mergeFrom(value);
        } else {
          textDetectionConfig_ = value;
        }
      } else {
        textDetectionConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.TextDetectionConfig text_detection_config = 8;
     * </code>
     */
    public Builder clearTextDetectionConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      textDetectionConfig_ = null;
      if (textDetectionConfigBuilder_ != null) {
        textDetectionConfigBuilder_.dispose();
        textDetectionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.TextDetectionConfig text_detection_config = 8;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.TextDetectionConfig.Builder
        getTextDetectionConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getTextDetectionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.TextDetectionConfig text_detection_config = 8;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.TextDetectionConfigOrBuilder
        getTextDetectionConfigOrBuilder() {
      if (textDetectionConfigBuilder_ != null) {
        return textDetectionConfigBuilder_.getMessageOrBuilder();
      } else {
        return textDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1.TextDetectionConfig.getDefaultInstance()
            : textDetectionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.TextDetectionConfig text_detection_config = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.TextDetectionConfig,
            com.google.cloud.videointelligence.v1.TextDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1.TextDetectionConfigOrBuilder>
        getTextDetectionConfigFieldBuilder() {
      if (textDetectionConfigBuilder_ == null) {
        textDetectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1.TextDetectionConfig,
                com.google.cloud.videointelligence.v1.TextDetectionConfig.Builder,
                com.google.cloud.videointelligence.v1.TextDetectionConfigOrBuilder>(
                getTextDetectionConfig(), getParentForChildren(), isClean());
        textDetectionConfig_ = null;
      }
      return textDetectionConfigBuilder_;
    }

    private com.google.cloud.videointelligence.v1.PersonDetectionConfig personDetectionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.PersonDetectionConfig,
            com.google.cloud.videointelligence.v1.PersonDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1.PersonDetectionConfigOrBuilder>
        personDetectionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for PERSON_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.PersonDetectionConfig person_detection_config = 11;
     * </code>
     *
     * @return Whether the personDetectionConfig field is set.
     */
    public boolean hasPersonDetectionConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Config for PERSON_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.PersonDetectionConfig person_detection_config = 11;
     * </code>
     *
     * @return The personDetectionConfig.
     */
    public com.google.cloud.videointelligence.v1.PersonDetectionConfig getPersonDetectionConfig() {
      if (personDetectionConfigBuilder_ == null) {
        return personDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1.PersonDetectionConfig.getDefaultInstance()
            : personDetectionConfig_;
      } else {
        return personDetectionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for PERSON_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.PersonDetectionConfig person_detection_config = 11;
     * </code>
     */
    public Builder setPersonDetectionConfig(
        com.google.cloud.videointelligence.v1.PersonDetectionConfig value) {
      if (personDetectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        personDetectionConfig_ = value;
      } else {
        personDetectionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for PERSON_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.PersonDetectionConfig person_detection_config = 11;
     * </code>
     */
    public Builder setPersonDetectionConfig(
        com.google.cloud.videointelligence.v1.PersonDetectionConfig.Builder builderForValue) {
      if (personDetectionConfigBuilder_ == null) {
        personDetectionConfig_ = builderForValue.build();
      } else {
        personDetectionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for PERSON_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.PersonDetectionConfig person_detection_config = 11;
     * </code>
     */
    public Builder mergePersonDetectionConfig(
        com.google.cloud.videointelligence.v1.PersonDetectionConfig value) {
      if (personDetectionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && personDetectionConfig_ != null
            && personDetectionConfig_
                != com.google.cloud.videointelligence.v1.PersonDetectionConfig
                    .getDefaultInstance()) {
          getPersonDetectionConfigBuilder().mergeFrom(value);
        } else {
          personDetectionConfig_ = value;
        }
      } else {
        personDetectionConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for PERSON_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.PersonDetectionConfig person_detection_config = 11;
     * </code>
     */
    public Builder clearPersonDetectionConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      personDetectionConfig_ = null;
      if (personDetectionConfigBuilder_ != null) {
        personDetectionConfigBuilder_.dispose();
        personDetectionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for PERSON_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.PersonDetectionConfig person_detection_config = 11;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.PersonDetectionConfig.Builder
        getPersonDetectionConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getPersonDetectionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for PERSON_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.PersonDetectionConfig person_detection_config = 11;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.PersonDetectionConfigOrBuilder
        getPersonDetectionConfigOrBuilder() {
      if (personDetectionConfigBuilder_ != null) {
        return personDetectionConfigBuilder_.getMessageOrBuilder();
      } else {
        return personDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1.PersonDetectionConfig.getDefaultInstance()
            : personDetectionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Config for PERSON_DETECTION.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.PersonDetectionConfig person_detection_config = 11;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.PersonDetectionConfig,
            com.google.cloud.videointelligence.v1.PersonDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1.PersonDetectionConfigOrBuilder>
        getPersonDetectionConfigFieldBuilder() {
      if (personDetectionConfigBuilder_ == null) {
        personDetectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1.PersonDetectionConfig,
                com.google.cloud.videointelligence.v1.PersonDetectionConfig.Builder,
                com.google.cloud.videointelligence.v1.PersonDetectionConfigOrBuilder>(
                getPersonDetectionConfig(), getParentForChildren(), isClean());
        personDetectionConfig_ = null;
      }
      return personDetectionConfigBuilder_;
    }

    private com.google.cloud.videointelligence.v1.ObjectTrackingConfig objectTrackingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.ObjectTrackingConfig,
            com.google.cloud.videointelligence.v1.ObjectTrackingConfig.Builder,
            com.google.cloud.videointelligence.v1.ObjectTrackingConfigOrBuilder>
        objectTrackingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for OBJECT_TRACKING.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ObjectTrackingConfig object_tracking_config = 13;
     * </code>
     *
     * @return Whether the objectTrackingConfig field is set.
     */
    public boolean hasObjectTrackingConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Config for OBJECT_TRACKING.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ObjectTrackingConfig object_tracking_config = 13;
     * </code>
     *
     * @return The objectTrackingConfig.
     */
    public com.google.cloud.videointelligence.v1.ObjectTrackingConfig getObjectTrackingConfig() {
      if (objectTrackingConfigBuilder_ == null) {
        return objectTrackingConfig_ == null
            ? com.google.cloud.videointelligence.v1.ObjectTrackingConfig.getDefaultInstance()
            : objectTrackingConfig_;
      } else {
        return objectTrackingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for OBJECT_TRACKING.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ObjectTrackingConfig object_tracking_config = 13;
     * </code>
     */
    public Builder setObjectTrackingConfig(
        com.google.cloud.videointelligence.v1.ObjectTrackingConfig value) {
      if (objectTrackingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        objectTrackingConfig_ = value;
      } else {
        objectTrackingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for OBJECT_TRACKING.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ObjectTrackingConfig object_tracking_config = 13;
     * </code>
     */
    public Builder setObjectTrackingConfig(
        com.google.cloud.videointelligence.v1.ObjectTrackingConfig.Builder builderForValue) {
      if (objectTrackingConfigBuilder_ == null) {
        objectTrackingConfig_ = builderForValue.build();
      } else {
        objectTrackingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for OBJECT_TRACKING.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ObjectTrackingConfig object_tracking_config = 13;
     * </code>
     */
    public Builder mergeObjectTrackingConfig(
        com.google.cloud.videointelligence.v1.ObjectTrackingConfig value) {
      if (objectTrackingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && objectTrackingConfig_ != null
            && objectTrackingConfig_
                != com.google.cloud.videointelligence.v1.ObjectTrackingConfig
                    .getDefaultInstance()) {
          getObjectTrackingConfigBuilder().mergeFrom(value);
        } else {
          objectTrackingConfig_ = value;
        }
      } else {
        objectTrackingConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for OBJECT_TRACKING.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ObjectTrackingConfig object_tracking_config = 13;
     * </code>
     */
    public Builder clearObjectTrackingConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      objectTrackingConfig_ = null;
      if (objectTrackingConfigBuilder_ != null) {
        objectTrackingConfigBuilder_.dispose();
        objectTrackingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for OBJECT_TRACKING.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ObjectTrackingConfig object_tracking_config = 13;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.ObjectTrackingConfig.Builder
        getObjectTrackingConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getObjectTrackingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for OBJECT_TRACKING.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ObjectTrackingConfig object_tracking_config = 13;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.ObjectTrackingConfigOrBuilder
        getObjectTrackingConfigOrBuilder() {
      if (objectTrackingConfigBuilder_ != null) {
        return objectTrackingConfigBuilder_.getMessageOrBuilder();
      } else {
        return objectTrackingConfig_ == null
            ? com.google.cloud.videointelligence.v1.ObjectTrackingConfig.getDefaultInstance()
            : objectTrackingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Config for OBJECT_TRACKING.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ObjectTrackingConfig object_tracking_config = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.ObjectTrackingConfig,
            com.google.cloud.videointelligence.v1.ObjectTrackingConfig.Builder,
            com.google.cloud.videointelligence.v1.ObjectTrackingConfigOrBuilder>
        getObjectTrackingConfigFieldBuilder() {
      if (objectTrackingConfigBuilder_ == null) {
        objectTrackingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1.ObjectTrackingConfig,
                com.google.cloud.videointelligence.v1.ObjectTrackingConfig.Builder,
                com.google.cloud.videointelligence.v1.ObjectTrackingConfigOrBuilder>(
                getObjectTrackingConfig(), getParentForChildren(), isClean());
        objectTrackingConfig_ = null;
      }
      return objectTrackingConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1.VideoContext)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1.VideoContext)
  private static final com.google.cloud.videointelligence.v1.VideoContext DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.videointelligence.v1.VideoContext();
  }

  public static com.google.cloud.videointelligence.v1.VideoContext getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VideoContext> PARSER =
      new com.google.protobuf.AbstractParser<VideoContext>() {
        @java.lang.Override
        public VideoContext parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VideoContext> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VideoContext> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1.VideoContext getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
