/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1/video_intelligence.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.videointelligence.v1;

/**
 *
 *
 * <pre>
 * Annotation corresponding to one detected, tracked and recognized logo class.
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1.LogoRecognitionAnnotation}
 */
public final class LogoRecognitionAnnotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1.LogoRecognitionAnnotation)
    LogoRecognitionAnnotationOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use LogoRecognitionAnnotation.newBuilder() to construct.
  private LogoRecognitionAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LogoRecognitionAnnotation() {
    tracks_ = java.util.Collections.emptyList();
    segments_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LogoRecognitionAnnotation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1_LogoRecognitionAnnotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1_LogoRecognitionAnnotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.class,
            com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.Builder.class);
  }

  private int bitField0_;
  public static final int ENTITY_FIELD_NUMBER = 1;
  private com.google.cloud.videointelligence.v1.Entity entity_;

  /**
   *
   *
   * <pre>
   * Entity category information to specify the logo class that all the logo
   * tracks within this LogoRecognitionAnnotation are recognized as.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.Entity entity = 1;</code>
   *
   * @return Whether the entity field is set.
   */
  @java.lang.Override
  public boolean hasEntity() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Entity category information to specify the logo class that all the logo
   * tracks within this LogoRecognitionAnnotation are recognized as.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.Entity entity = 1;</code>
   *
   * @return The entity.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.Entity getEntity() {
    return entity_ == null
        ? com.google.cloud.videointelligence.v1.Entity.getDefaultInstance()
        : entity_;
  }

  /**
   *
   *
   * <pre>
   * Entity category information to specify the logo class that all the logo
   * tracks within this LogoRecognitionAnnotation are recognized as.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.Entity entity = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.EntityOrBuilder getEntityOrBuilder() {
    return entity_ == null
        ? com.google.cloud.videointelligence.v1.Entity.getDefaultInstance()
        : entity_;
  }

  public static final int TRACKS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.Track> tracks_;

  /**
   *
   *
   * <pre>
   * All logo tracks where the recognized logo appears. Each track corresponds
   * to one logo instance appearing in consecutive frames.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.Track> getTracksList() {
    return tracks_;
  }

  /**
   *
   *
   * <pre>
   * All logo tracks where the recognized logo appears. Each track corresponds
   * to one logo instance appearing in consecutive frames.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1.TrackOrBuilder>
      getTracksOrBuilderList() {
    return tracks_;
  }

  /**
   *
   *
   * <pre>
   * All logo tracks where the recognized logo appears. Each track corresponds
   * to one logo instance appearing in consecutive frames.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
   */
  @java.lang.Override
  public int getTracksCount() {
    return tracks_.size();
  }

  /**
   *
   *
   * <pre>
   * All logo tracks where the recognized logo appears. Each track corresponds
   * to one logo instance appearing in consecutive frames.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.Track getTracks(int index) {
    return tracks_.get(index);
  }

  /**
   *
   *
   * <pre>
   * All logo tracks where the recognized logo appears. Each track corresponds
   * to one logo instance appearing in consecutive frames.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.TrackOrBuilder getTracksOrBuilder(int index) {
    return tracks_.get(index);
  }

  public static final int SEGMENTS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.VideoSegment> segments_;

  /**
   *
   *
   * <pre>
   * All video segments where the recognized logo appears. There might be
   * multiple instances of the same logo class appearing in one VideoSegment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.VideoSegment> getSegmentsList() {
    return segments_;
  }

  /**
   *
   *
   * <pre>
   * All video segments where the recognized logo appears. There might be
   * multiple instances of the same logo class appearing in one VideoSegment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>
      getSegmentsOrBuilderList() {
    return segments_;
  }

  /**
   *
   *
   * <pre>
   * All video segments where the recognized logo appears. There might be
   * multiple instances of the same logo class appearing in one VideoSegment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
   */
  @java.lang.Override
  public int getSegmentsCount() {
    return segments_.size();
  }

  /**
   *
   *
   * <pre>
   * All video segments where the recognized logo appears. There might be
   * multiple instances of the same logo class appearing in one VideoSegment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.VideoSegment getSegments(int index) {
    return segments_.get(index);
  }

  /**
   *
   *
   * <pre>
   * All video segments where the recognized logo appears. There might be
   * multiple instances of the same logo class appearing in one VideoSegment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder getSegmentsOrBuilder(
      int index) {
    return segments_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getEntity());
    }
    for (int i = 0; i < tracks_.size(); i++) {
      output.writeMessage(2, tracks_.get(i));
    }
    for (int i = 0; i < segments_.size(); i++) {
      output.writeMessage(3, segments_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEntity());
    }
    for (int i = 0; i < tracks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, tracks_.get(i));
    }
    for (int i = 0; i < segments_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, segments_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation other =
        (com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation) obj;

    if (hasEntity() != other.hasEntity()) return false;
    if (hasEntity()) {
      if (!getEntity().equals(other.getEntity())) return false;
    }
    if (!getTracksList().equals(other.getTracksList())) return false;
    if (!getSegmentsList().equals(other.getSegmentsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasEntity()) {
      hash = (37 * hash) + ENTITY_FIELD_NUMBER;
      hash = (53 * hash) + getEntity().hashCode();
    }
    if (getTracksCount() > 0) {
      hash = (37 * hash) + TRACKS_FIELD_NUMBER;
      hash = (53 * hash) + getTracksList().hashCode();
    }
    if (getSegmentsCount() > 0) {
      hash = (37 * hash) + SEGMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getSegmentsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Annotation corresponding to one detected, tracked and recognized logo class.
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1.LogoRecognitionAnnotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1.LogoRecognitionAnnotation)
      com.google.cloud.videointelligence.v1.LogoRecognitionAnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1_LogoRecognitionAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1_LogoRecognitionAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.class,
              com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.Builder.class);
    }

    // Construct using com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEntityFieldBuilder();
        getTracksFieldBuilder();
        getSegmentsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      entity_ = null;
      if (entityBuilder_ != null) {
        entityBuilder_.dispose();
        entityBuilder_ = null;
      }
      if (tracksBuilder_ == null) {
        tracks_ = java.util.Collections.emptyList();
      } else {
        tracks_ = null;
        tracksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (segmentsBuilder_ == null) {
        segments_ = java.util.Collections.emptyList();
      } else {
        segments_ = null;
        segmentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1_LogoRecognitionAnnotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation
        getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation build() {
      com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation buildPartial() {
      com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation result =
          new com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation result) {
      if (tracksBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          tracks_ = java.util.Collections.unmodifiableList(tracks_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.tracks_ = tracks_;
      } else {
        result.tracks_ = tracksBuilder_.build();
      }
      if (segmentsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          segments_ = java.util.Collections.unmodifiableList(segments_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.segments_ = segments_;
      } else {
        result.segments_ = segmentsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.entity_ = entityBuilder_ == null ? entity_ : entityBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation) {
        return mergeFrom((com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation other) {
      if (other
          == com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.getDefaultInstance())
        return this;
      if (other.hasEntity()) {
        mergeEntity(other.getEntity());
      }
      if (tracksBuilder_ == null) {
        if (!other.tracks_.isEmpty()) {
          if (tracks_.isEmpty()) {
            tracks_ = other.tracks_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureTracksIsMutable();
            tracks_.addAll(other.tracks_);
          }
          onChanged();
        }
      } else {
        if (!other.tracks_.isEmpty()) {
          if (tracksBuilder_.isEmpty()) {
            tracksBuilder_.dispose();
            tracksBuilder_ = null;
            tracks_ = other.tracks_;
            bitField0_ = (bitField0_ & ~0x00000002);
            tracksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTracksFieldBuilder()
                    : null;
          } else {
            tracksBuilder_.addAllMessages(other.tracks_);
          }
        }
      }
      if (segmentsBuilder_ == null) {
        if (!other.segments_.isEmpty()) {
          if (segments_.isEmpty()) {
            segments_ = other.segments_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureSegmentsIsMutable();
            segments_.addAll(other.segments_);
          }
          onChanged();
        }
      } else {
        if (!other.segments_.isEmpty()) {
          if (segmentsBuilder_.isEmpty()) {
            segmentsBuilder_.dispose();
            segmentsBuilder_ = null;
            segments_ = other.segments_;
            bitField0_ = (bitField0_ & ~0x00000004);
            segmentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSegmentsFieldBuilder()
                    : null;
          } else {
            segmentsBuilder_.addAllMessages(other.segments_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getEntityFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.videointelligence.v1.Track m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.Track.parser(), extensionRegistry);
                if (tracksBuilder_ == null) {
                  ensureTracksIsMutable();
                  tracks_.add(m);
                } else {
                  tracksBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.videointelligence.v1.VideoSegment m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.VideoSegment.parser(),
                        extensionRegistry);
                if (segmentsBuilder_ == null) {
                  ensureSegmentsIsMutable();
                  segments_.add(m);
                } else {
                  segmentsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.videointelligence.v1.Entity entity_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.Entity,
            com.google.cloud.videointelligence.v1.Entity.Builder,
            com.google.cloud.videointelligence.v1.EntityOrBuilder>
        entityBuilder_;

    /**
     *
     *
     * <pre>
     * Entity category information to specify the logo class that all the logo
     * tracks within this LogoRecognitionAnnotation are recognized as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.Entity entity = 1;</code>
     *
     * @return Whether the entity field is set.
     */
    public boolean hasEntity() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Entity category information to specify the logo class that all the logo
     * tracks within this LogoRecognitionAnnotation are recognized as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.Entity entity = 1;</code>
     *
     * @return The entity.
     */
    public com.google.cloud.videointelligence.v1.Entity getEntity() {
      if (entityBuilder_ == null) {
        return entity_ == null
            ? com.google.cloud.videointelligence.v1.Entity.getDefaultInstance()
            : entity_;
      } else {
        return entityBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Entity category information to specify the logo class that all the logo
     * tracks within this LogoRecognitionAnnotation are recognized as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.Entity entity = 1;</code>
     */
    public Builder setEntity(com.google.cloud.videointelligence.v1.Entity value) {
      if (entityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entity_ = value;
      } else {
        entityBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entity category information to specify the logo class that all the logo
     * tracks within this LogoRecognitionAnnotation are recognized as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.Entity entity = 1;</code>
     */
    public Builder setEntity(com.google.cloud.videointelligence.v1.Entity.Builder builderForValue) {
      if (entityBuilder_ == null) {
        entity_ = builderForValue.build();
      } else {
        entityBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entity category information to specify the logo class that all the logo
     * tracks within this LogoRecognitionAnnotation are recognized as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.Entity entity = 1;</code>
     */
    public Builder mergeEntity(com.google.cloud.videointelligence.v1.Entity value) {
      if (entityBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && entity_ != null
            && entity_ != com.google.cloud.videointelligence.v1.Entity.getDefaultInstance()) {
          getEntityBuilder().mergeFrom(value);
        } else {
          entity_ = value;
        }
      } else {
        entityBuilder_.mergeFrom(value);
      }
      if (entity_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entity category information to specify the logo class that all the logo
     * tracks within this LogoRecognitionAnnotation are recognized as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.Entity entity = 1;</code>
     */
    public Builder clearEntity() {
      bitField0_ = (bitField0_ & ~0x00000001);
      entity_ = null;
      if (entityBuilder_ != null) {
        entityBuilder_.dispose();
        entityBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entity category information to specify the logo class that all the logo
     * tracks within this LogoRecognitionAnnotation are recognized as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.Entity entity = 1;</code>
     */
    public com.google.cloud.videointelligence.v1.Entity.Builder getEntityBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getEntityFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Entity category information to specify the logo class that all the logo
     * tracks within this LogoRecognitionAnnotation are recognized as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.Entity entity = 1;</code>
     */
    public com.google.cloud.videointelligence.v1.EntityOrBuilder getEntityOrBuilder() {
      if (entityBuilder_ != null) {
        return entityBuilder_.getMessageOrBuilder();
      } else {
        return entity_ == null
            ? com.google.cloud.videointelligence.v1.Entity.getDefaultInstance()
            : entity_;
      }
    }

    /**
     *
     *
     * <pre>
     * Entity category information to specify the logo class that all the logo
     * tracks within this LogoRecognitionAnnotation are recognized as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.Entity entity = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.Entity,
            com.google.cloud.videointelligence.v1.Entity.Builder,
            com.google.cloud.videointelligence.v1.EntityOrBuilder>
        getEntityFieldBuilder() {
      if (entityBuilder_ == null) {
        entityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1.Entity,
                com.google.cloud.videointelligence.v1.Entity.Builder,
                com.google.cloud.videointelligence.v1.EntityOrBuilder>(
                getEntity(), getParentForChildren(), isClean());
        entity_ = null;
      }
      return entityBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.Track> tracks_ =
        java.util.Collections.emptyList();

    private void ensureTracksIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        tracks_ = new java.util.ArrayList<com.google.cloud.videointelligence.v1.Track>(tracks_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.Track,
            com.google.cloud.videointelligence.v1.Track.Builder,
            com.google.cloud.videointelligence.v1.TrackOrBuilder>
        tracksBuilder_;

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.Track> getTracksList() {
      if (tracksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tracks_);
      } else {
        return tracksBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public int getTracksCount() {
      if (tracksBuilder_ == null) {
        return tracks_.size();
      } else {
        return tracksBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public com.google.cloud.videointelligence.v1.Track getTracks(int index) {
      if (tracksBuilder_ == null) {
        return tracks_.get(index);
      } else {
        return tracksBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public Builder setTracks(int index, com.google.cloud.videointelligence.v1.Track value) {
      if (tracksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTracksIsMutable();
        tracks_.set(index, value);
        onChanged();
      } else {
        tracksBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public Builder setTracks(
        int index, com.google.cloud.videointelligence.v1.Track.Builder builderForValue) {
      if (tracksBuilder_ == null) {
        ensureTracksIsMutable();
        tracks_.set(index, builderForValue.build());
        onChanged();
      } else {
        tracksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public Builder addTracks(com.google.cloud.videointelligence.v1.Track value) {
      if (tracksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTracksIsMutable();
        tracks_.add(value);
        onChanged();
      } else {
        tracksBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public Builder addTracks(int index, com.google.cloud.videointelligence.v1.Track value) {
      if (tracksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTracksIsMutable();
        tracks_.add(index, value);
        onChanged();
      } else {
        tracksBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public Builder addTracks(com.google.cloud.videointelligence.v1.Track.Builder builderForValue) {
      if (tracksBuilder_ == null) {
        ensureTracksIsMutable();
        tracks_.add(builderForValue.build());
        onChanged();
      } else {
        tracksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public Builder addTracks(
        int index, com.google.cloud.videointelligence.v1.Track.Builder builderForValue) {
      if (tracksBuilder_ == null) {
        ensureTracksIsMutable();
        tracks_.add(index, builderForValue.build());
        onChanged();
      } else {
        tracksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public Builder addAllTracks(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.Track> values) {
      if (tracksBuilder_ == null) {
        ensureTracksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tracks_);
        onChanged();
      } else {
        tracksBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public Builder clearTracks() {
      if (tracksBuilder_ == null) {
        tracks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        tracksBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public Builder removeTracks(int index) {
      if (tracksBuilder_ == null) {
        ensureTracksIsMutable();
        tracks_.remove(index);
        onChanged();
      } else {
        tracksBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public com.google.cloud.videointelligence.v1.Track.Builder getTracksBuilder(int index) {
      return getTracksFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public com.google.cloud.videointelligence.v1.TrackOrBuilder getTracksOrBuilder(int index) {
      if (tracksBuilder_ == null) {
        return tracks_.get(index);
      } else {
        return tracksBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.videointelligence.v1.TrackOrBuilder>
        getTracksOrBuilderList() {
      if (tracksBuilder_ != null) {
        return tracksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tracks_);
      }
    }

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public com.google.cloud.videointelligence.v1.Track.Builder addTracksBuilder() {
      return getTracksFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1.Track.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public com.google.cloud.videointelligence.v1.Track.Builder addTracksBuilder(int index) {
      return getTracksFieldBuilder()
          .addBuilder(index, com.google.cloud.videointelligence.v1.Track.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * All logo tracks where the recognized logo appears. Each track corresponds
     * to one logo instance appearing in consecutive frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.Track tracks = 2;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.Track.Builder>
        getTracksBuilderList() {
      return getTracksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.Track,
            com.google.cloud.videointelligence.v1.Track.Builder,
            com.google.cloud.videointelligence.v1.TrackOrBuilder>
        getTracksFieldBuilder() {
      if (tracksBuilder_ == null) {
        tracksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.Track,
                com.google.cloud.videointelligence.v1.Track.Builder,
                com.google.cloud.videointelligence.v1.TrackOrBuilder>(
                tracks_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        tracks_ = null;
      }
      return tracksBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.VideoSegment> segments_ =
        java.util.Collections.emptyList();

    private void ensureSegmentsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        segments_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1.VideoSegment>(segments_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.VideoSegment,
            com.google.cloud.videointelligence.v1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>
        segmentsBuilder_;

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.VideoSegment> getSegmentsList() {
      if (segmentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(segments_);
      } else {
        return segmentsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public int getSegmentsCount() {
      if (segmentsBuilder_ == null) {
        return segments_.size();
      } else {
        return segmentsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegment getSegments(int index) {
      if (segmentsBuilder_ == null) {
        return segments_.get(index);
      } else {
        return segmentsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public Builder setSegments(
        int index, com.google.cloud.videointelligence.v1.VideoSegment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.set(index, value);
        onChanged();
      } else {
        segmentsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public Builder setSegments(
        int index, com.google.cloud.videointelligence.v1.VideoSegment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.set(index, builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public Builder addSegments(com.google.cloud.videointelligence.v1.VideoSegment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.add(value);
        onChanged();
      } else {
        segmentsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public Builder addSegments(
        int index, com.google.cloud.videointelligence.v1.VideoSegment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.add(index, value);
        onChanged();
      } else {
        segmentsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public Builder addSegments(
        com.google.cloud.videointelligence.v1.VideoSegment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.add(builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public Builder addSegments(
        int index, com.google.cloud.videointelligence.v1.VideoSegment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.add(index, builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public Builder addAllSegments(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.VideoSegment> values) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, segments_);
        onChanged();
      } else {
        segmentsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public Builder clearSegments() {
      if (segmentsBuilder_ == null) {
        segments_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        segmentsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public Builder removeSegments(int index) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.remove(index);
        onChanged();
      } else {
        segmentsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegment.Builder getSegmentsBuilder(
        int index) {
      return getSegmentsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder getSegmentsOrBuilder(
        int index) {
      if (segmentsBuilder_ == null) {
        return segments_.get(index);
      } else {
        return segmentsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>
        getSegmentsOrBuilderList() {
      if (segmentsBuilder_ != null) {
        return segmentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(segments_);
      }
    }

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegment.Builder addSegmentsBuilder() {
      return getSegmentsFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1.VideoSegment.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegment.Builder addSegmentsBuilder(
        int index) {
      return getSegmentsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1.VideoSegment.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * All video segments where the recognized logo appears. There might be
     * multiple instances of the same logo class appearing in one VideoSegment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment segments = 3;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.VideoSegment.Builder>
        getSegmentsBuilderList() {
      return getSegmentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.VideoSegment,
            com.google.cloud.videointelligence.v1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>
        getSegmentsFieldBuilder() {
      if (segmentsBuilder_ == null) {
        segmentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.VideoSegment,
                com.google.cloud.videointelligence.v1.VideoSegment.Builder,
                com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>(
                segments_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        segments_ = null;
      }
      return segmentsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1.LogoRecognitionAnnotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1.LogoRecognitionAnnotation)
  private static final com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation();
  }

  public static com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LogoRecognitionAnnotation> PARSER =
      new com.google.protobuf.AbstractParser<LogoRecognitionAnnotation>() {
        @java.lang.Override
        public LogoRecognitionAnnotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LogoRecognitionAnnotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LogoRecognitionAnnotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
