/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1beta2/video_intelligence.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.videointelligence.v1beta2;

/**
 *
 *
 * <pre>
 * Annotation results for a single video.
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1beta2.VideoAnnotationResults}
 */
public final class VideoAnnotationResults extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1beta2.VideoAnnotationResults)
    VideoAnnotationResultsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VideoAnnotationResults.newBuilder() to construct.
  private VideoAnnotationResults(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VideoAnnotationResults() {
    inputUri_ = "";
    segmentLabelAnnotations_ = java.util.Collections.emptyList();
    shotLabelAnnotations_ = java.util.Collections.emptyList();
    frameLabelAnnotations_ = java.util.Collections.emptyList();
    faceAnnotations_ = java.util.Collections.emptyList();
    shotAnnotations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VideoAnnotationResults();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1beta2.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1beta2_VideoAnnotationResults_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1beta2.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1beta2_VideoAnnotationResults_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults.class,
            com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults.Builder.class);
  }

  private int bitField0_;
  public static final int INPUT_URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object inputUri_ = "";
  /**
   *
   *
   * <pre>
   * Video file location in
   * [Google Cloud Storage](https://cloud.google.com/storage/).
   * </pre>
   *
   * <code>string input_uri = 1;</code>
   *
   * @return The inputUri.
   */
  @java.lang.Override
  public java.lang.String getInputUri() {
    java.lang.Object ref = inputUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      inputUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Video file location in
   * [Google Cloud Storage](https://cloud.google.com/storage/).
   * </pre>
   *
   * <code>string input_uri = 1;</code>
   *
   * @return The bytes for inputUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInputUriBytes() {
    java.lang.Object ref = inputUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      inputUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SEGMENT_LABEL_ANNOTATIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1beta2.LabelAnnotation>
      segmentLabelAnnotations_;
  /**
   *
   *
   * <pre>
   * Label annotations on video level or user specified segment level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1beta2.LabelAnnotation>
      getSegmentLabelAnnotationsList() {
    return segmentLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Label annotations on video level or user specified segment level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder>
      getSegmentLabelAnnotationsOrBuilderList() {
    return segmentLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Label annotations on video level or user specified segment level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public int getSegmentLabelAnnotationsCount() {
    return segmentLabelAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Label annotations on video level or user specified segment level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.LabelAnnotation getSegmentLabelAnnotations(
      int index) {
    return segmentLabelAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Label annotations on video level or user specified segment level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder
      getSegmentLabelAnnotationsOrBuilder(int index) {
    return segmentLabelAnnotations_.get(index);
  }

  public static final int SHOT_LABEL_ANNOTATIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1beta2.LabelAnnotation>
      shotLabelAnnotations_;
  /**
   *
   *
   * <pre>
   * Label annotations on shot level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1beta2.LabelAnnotation>
      getShotLabelAnnotationsList() {
    return shotLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Label annotations on shot level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder>
      getShotLabelAnnotationsOrBuilderList() {
    return shotLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Label annotations on shot level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
   * </code>
   */
  @java.lang.Override
  public int getShotLabelAnnotationsCount() {
    return shotLabelAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Label annotations on shot level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.LabelAnnotation getShotLabelAnnotations(
      int index) {
    return shotLabelAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Label annotations on shot level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder
      getShotLabelAnnotationsOrBuilder(int index) {
    return shotLabelAnnotations_.get(index);
  }

  public static final int FRAME_LABEL_ANNOTATIONS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1beta2.LabelAnnotation>
      frameLabelAnnotations_;
  /**
   *
   *
   * <pre>
   * Label annotations on frame level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1beta2.LabelAnnotation>
      getFrameLabelAnnotationsList() {
    return frameLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Label annotations on frame level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder>
      getFrameLabelAnnotationsOrBuilderList() {
    return frameLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Label annotations on frame level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public int getFrameLabelAnnotationsCount() {
    return frameLabelAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Label annotations on frame level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.LabelAnnotation getFrameLabelAnnotations(
      int index) {
    return frameLabelAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Label annotations on frame level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder
      getFrameLabelAnnotationsOrBuilder(int index) {
    return frameLabelAnnotations_.get(index);
  }

  public static final int FACE_ANNOTATIONS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1beta2.FaceAnnotation>
      faceAnnotations_;
  /**
   *
   *
   * <pre>
   * Face annotations. There is exactly one element for each unique face.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1beta2.FaceAnnotation>
      getFaceAnnotationsList() {
    return faceAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Face annotations. There is exactly one element for each unique face.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1beta2.FaceAnnotationOrBuilder>
      getFaceAnnotationsOrBuilderList() {
    return faceAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Face annotations. There is exactly one element for each unique face.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
   * </code>
   */
  @java.lang.Override
  public int getFaceAnnotationsCount() {
    return faceAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Face annotations. There is exactly one element for each unique face.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.FaceAnnotation getFaceAnnotations(int index) {
    return faceAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Face annotations. There is exactly one element for each unique face.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.FaceAnnotationOrBuilder
      getFaceAnnotationsOrBuilder(int index) {
    return faceAnnotations_.get(index);
  }

  public static final int SHOT_ANNOTATIONS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1beta2.VideoSegment> shotAnnotations_;
  /**
   *
   *
   * <pre>
   * Shot annotations. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1beta2.VideoSegment>
      getShotAnnotationsList() {
    return shotAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Shot annotations. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1beta2.VideoSegmentOrBuilder>
      getShotAnnotationsOrBuilderList() {
    return shotAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Shot annotations. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
   * </code>
   */
  @java.lang.Override
  public int getShotAnnotationsCount() {
    return shotAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Shot annotations. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.VideoSegment getShotAnnotations(int index) {
    return shotAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Shot annotations. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.VideoSegmentOrBuilder
      getShotAnnotationsOrBuilder(int index) {
    return shotAnnotations_.get(index);
  }

  public static final int EXPLICIT_ANNOTATION_FIELD_NUMBER = 7;
  private com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation explicitAnnotation_;
  /**
   *
   *
   * <pre>
   * Explicit content annotation.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation explicit_annotation = 7;
   * </code>
   *
   * @return Whether the explicitAnnotation field is set.
   */
  @java.lang.Override
  public boolean hasExplicitAnnotation() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Explicit content annotation.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation explicit_annotation = 7;
   * </code>
   *
   * @return The explicitAnnotation.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation
      getExplicitAnnotation() {
    return explicitAnnotation_ == null
        ? com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation.getDefaultInstance()
        : explicitAnnotation_;
  }
  /**
   *
   *
   * <pre>
   * Explicit content annotation.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation explicit_annotation = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotationOrBuilder
      getExplicitAnnotationOrBuilder() {
    return explicitAnnotation_ == null
        ? com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation.getDefaultInstance()
        : explicitAnnotation_;
  }

  public static final int ERROR_FIELD_NUMBER = 9;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
   * some videos may succeed and some may fail.
   * </pre>
   *
   * <code>.google.rpc.Status error = 9;</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
   * some videos may succeed and some may fail.
   * </pre>
   *
   * <code>.google.rpc.Status error = 9;</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
   * some videos may succeed and some may fail.
   * </pre>
   *
   * <code>.google.rpc.Status error = 9;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, inputUri_);
    }
    for (int i = 0; i < segmentLabelAnnotations_.size(); i++) {
      output.writeMessage(2, segmentLabelAnnotations_.get(i));
    }
    for (int i = 0; i < shotLabelAnnotations_.size(); i++) {
      output.writeMessage(3, shotLabelAnnotations_.get(i));
    }
    for (int i = 0; i < frameLabelAnnotations_.size(); i++) {
      output.writeMessage(4, frameLabelAnnotations_.get(i));
    }
    for (int i = 0; i < faceAnnotations_.size(); i++) {
      output.writeMessage(5, faceAnnotations_.get(i));
    }
    for (int i = 0; i < shotAnnotations_.size(); i++) {
      output.writeMessage(6, shotAnnotations_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getExplicitAnnotation());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(9, getError());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, inputUri_);
    }
    for (int i = 0; i < segmentLabelAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, segmentLabelAnnotations_.get(i));
    }
    for (int i = 0; i < shotLabelAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, shotLabelAnnotations_.get(i));
    }
    for (int i = 0; i < frameLabelAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, frameLabelAnnotations_.get(i));
    }
    for (int i = 0; i < faceAnnotations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, faceAnnotations_.get(i));
    }
    for (int i = 0; i < shotAnnotations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, shotAnnotations_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getExplicitAnnotation());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getError());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults other =
        (com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults) obj;

    if (!getInputUri().equals(other.getInputUri())) return false;
    if (!getSegmentLabelAnnotationsList().equals(other.getSegmentLabelAnnotationsList()))
      return false;
    if (!getShotLabelAnnotationsList().equals(other.getShotLabelAnnotationsList())) return false;
    if (!getFrameLabelAnnotationsList().equals(other.getFrameLabelAnnotationsList())) return false;
    if (!getFaceAnnotationsList().equals(other.getFaceAnnotationsList())) return false;
    if (!getShotAnnotationsList().equals(other.getShotAnnotationsList())) return false;
    if (hasExplicitAnnotation() != other.hasExplicitAnnotation()) return false;
    if (hasExplicitAnnotation()) {
      if (!getExplicitAnnotation().equals(other.getExplicitAnnotation())) return false;
    }
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INPUT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getInputUri().hashCode();
    if (getSegmentLabelAnnotationsCount() > 0) {
      hash = (37 * hash) + SEGMENT_LABEL_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getSegmentLabelAnnotationsList().hashCode();
    }
    if (getShotLabelAnnotationsCount() > 0) {
      hash = (37 * hash) + SHOT_LABEL_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getShotLabelAnnotationsList().hashCode();
    }
    if (getFrameLabelAnnotationsCount() > 0) {
      hash = (37 * hash) + FRAME_LABEL_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFrameLabelAnnotationsList().hashCode();
    }
    if (getFaceAnnotationsCount() > 0) {
      hash = (37 * hash) + FACE_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFaceAnnotationsList().hashCode();
    }
    if (getShotAnnotationsCount() > 0) {
      hash = (37 * hash) + SHOT_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getShotAnnotationsList().hashCode();
    }
    if (hasExplicitAnnotation()) {
      hash = (37 * hash) + EXPLICIT_ANNOTATION_FIELD_NUMBER;
      hash = (53 * hash) + getExplicitAnnotation().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Annotation results for a single video.
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1beta2.VideoAnnotationResults}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1beta2.VideoAnnotationResults)
      com.google.cloud.videointelligence.v1beta2.VideoAnnotationResultsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1beta2.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1beta2_VideoAnnotationResults_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1beta2.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1beta2_VideoAnnotationResults_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults.class,
              com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults.Builder.class);
    }

    // Construct using
    // com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSegmentLabelAnnotationsFieldBuilder();
        getShotLabelAnnotationsFieldBuilder();
        getFrameLabelAnnotationsFieldBuilder();
        getFaceAnnotationsFieldBuilder();
        getShotAnnotationsFieldBuilder();
        getExplicitAnnotationFieldBuilder();
        getErrorFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      inputUri_ = "";
      if (segmentLabelAnnotationsBuilder_ == null) {
        segmentLabelAnnotations_ = java.util.Collections.emptyList();
      } else {
        segmentLabelAnnotations_ = null;
        segmentLabelAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (shotLabelAnnotationsBuilder_ == null) {
        shotLabelAnnotations_ = java.util.Collections.emptyList();
      } else {
        shotLabelAnnotations_ = null;
        shotLabelAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (frameLabelAnnotationsBuilder_ == null) {
        frameLabelAnnotations_ = java.util.Collections.emptyList();
      } else {
        frameLabelAnnotations_ = null;
        frameLabelAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (faceAnnotationsBuilder_ == null) {
        faceAnnotations_ = java.util.Collections.emptyList();
      } else {
        faceAnnotations_ = null;
        faceAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (shotAnnotationsBuilder_ == null) {
        shotAnnotations_ = java.util.Collections.emptyList();
      } else {
        shotAnnotations_ = null;
        shotAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      explicitAnnotation_ = null;
      if (explicitAnnotationBuilder_ != null) {
        explicitAnnotationBuilder_.dispose();
        explicitAnnotationBuilder_ = null;
      }
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1beta2.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1beta2_VideoAnnotationResults_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults
        getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults build() {
      com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults buildPartial() {
      com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults result =
          new com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults result) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          segmentLabelAnnotations_ =
              java.util.Collections.unmodifiableList(segmentLabelAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.segmentLabelAnnotations_ = segmentLabelAnnotations_;
      } else {
        result.segmentLabelAnnotations_ = segmentLabelAnnotationsBuilder_.build();
      }
      if (shotLabelAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          shotLabelAnnotations_ = java.util.Collections.unmodifiableList(shotLabelAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.shotLabelAnnotations_ = shotLabelAnnotations_;
      } else {
        result.shotLabelAnnotations_ = shotLabelAnnotationsBuilder_.build();
      }
      if (frameLabelAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          frameLabelAnnotations_ = java.util.Collections.unmodifiableList(frameLabelAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.frameLabelAnnotations_ = frameLabelAnnotations_;
      } else {
        result.frameLabelAnnotations_ = frameLabelAnnotationsBuilder_.build();
      }
      if (faceAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          faceAnnotations_ = java.util.Collections.unmodifiableList(faceAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.faceAnnotations_ = faceAnnotations_;
      } else {
        result.faceAnnotations_ = faceAnnotationsBuilder_.build();
      }
      if (shotAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          shotAnnotations_ = java.util.Collections.unmodifiableList(shotAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.shotAnnotations_ = shotAnnotations_;
      } else {
        result.shotAnnotations_ = shotAnnotationsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.inputUri_ = inputUri_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.explicitAnnotation_ =
            explicitAnnotationBuilder_ == null
                ? explicitAnnotation_
                : explicitAnnotationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults) {
        return mergeFrom((com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults other) {
      if (other
          == com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults.getDefaultInstance())
        return this;
      if (!other.getInputUri().isEmpty()) {
        inputUri_ = other.inputUri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (segmentLabelAnnotationsBuilder_ == null) {
        if (!other.segmentLabelAnnotations_.isEmpty()) {
          if (segmentLabelAnnotations_.isEmpty()) {
            segmentLabelAnnotations_ = other.segmentLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSegmentLabelAnnotationsIsMutable();
            segmentLabelAnnotations_.addAll(other.segmentLabelAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.segmentLabelAnnotations_.isEmpty()) {
          if (segmentLabelAnnotationsBuilder_.isEmpty()) {
            segmentLabelAnnotationsBuilder_.dispose();
            segmentLabelAnnotationsBuilder_ = null;
            segmentLabelAnnotations_ = other.segmentLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            segmentLabelAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSegmentLabelAnnotationsFieldBuilder()
                    : null;
          } else {
            segmentLabelAnnotationsBuilder_.addAllMessages(other.segmentLabelAnnotations_);
          }
        }
      }
      if (shotLabelAnnotationsBuilder_ == null) {
        if (!other.shotLabelAnnotations_.isEmpty()) {
          if (shotLabelAnnotations_.isEmpty()) {
            shotLabelAnnotations_ = other.shotLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureShotLabelAnnotationsIsMutable();
            shotLabelAnnotations_.addAll(other.shotLabelAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.shotLabelAnnotations_.isEmpty()) {
          if (shotLabelAnnotationsBuilder_.isEmpty()) {
            shotLabelAnnotationsBuilder_.dispose();
            shotLabelAnnotationsBuilder_ = null;
            shotLabelAnnotations_ = other.shotLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000004);
            shotLabelAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getShotLabelAnnotationsFieldBuilder()
                    : null;
          } else {
            shotLabelAnnotationsBuilder_.addAllMessages(other.shotLabelAnnotations_);
          }
        }
      }
      if (frameLabelAnnotationsBuilder_ == null) {
        if (!other.frameLabelAnnotations_.isEmpty()) {
          if (frameLabelAnnotations_.isEmpty()) {
            frameLabelAnnotations_ = other.frameLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureFrameLabelAnnotationsIsMutable();
            frameLabelAnnotations_.addAll(other.frameLabelAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.frameLabelAnnotations_.isEmpty()) {
          if (frameLabelAnnotationsBuilder_.isEmpty()) {
            frameLabelAnnotationsBuilder_.dispose();
            frameLabelAnnotationsBuilder_ = null;
            frameLabelAnnotations_ = other.frameLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000008);
            frameLabelAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFrameLabelAnnotationsFieldBuilder()
                    : null;
          } else {
            frameLabelAnnotationsBuilder_.addAllMessages(other.frameLabelAnnotations_);
          }
        }
      }
      if (faceAnnotationsBuilder_ == null) {
        if (!other.faceAnnotations_.isEmpty()) {
          if (faceAnnotations_.isEmpty()) {
            faceAnnotations_ = other.faceAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureFaceAnnotationsIsMutable();
            faceAnnotations_.addAll(other.faceAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.faceAnnotations_.isEmpty()) {
          if (faceAnnotationsBuilder_.isEmpty()) {
            faceAnnotationsBuilder_.dispose();
            faceAnnotationsBuilder_ = null;
            faceAnnotations_ = other.faceAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000010);
            faceAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFaceAnnotationsFieldBuilder()
                    : null;
          } else {
            faceAnnotationsBuilder_.addAllMessages(other.faceAnnotations_);
          }
        }
      }
      if (shotAnnotationsBuilder_ == null) {
        if (!other.shotAnnotations_.isEmpty()) {
          if (shotAnnotations_.isEmpty()) {
            shotAnnotations_ = other.shotAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureShotAnnotationsIsMutable();
            shotAnnotations_.addAll(other.shotAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.shotAnnotations_.isEmpty()) {
          if (shotAnnotationsBuilder_.isEmpty()) {
            shotAnnotationsBuilder_.dispose();
            shotAnnotationsBuilder_ = null;
            shotAnnotations_ = other.shotAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000020);
            shotAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getShotAnnotationsFieldBuilder()
                    : null;
          } else {
            shotAnnotationsBuilder_.addAllMessages(other.shotAnnotations_);
          }
        }
      }
      if (other.hasExplicitAnnotation()) {
        mergeExplicitAnnotation(other.getExplicitAnnotation());
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                inputUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.videointelligence.v1beta2.LabelAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1beta2.LabelAnnotation.parser(),
                        extensionRegistry);
                if (segmentLabelAnnotationsBuilder_ == null) {
                  ensureSegmentLabelAnnotationsIsMutable();
                  segmentLabelAnnotations_.add(m);
                } else {
                  segmentLabelAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.videointelligence.v1beta2.LabelAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1beta2.LabelAnnotation.parser(),
                        extensionRegistry);
                if (shotLabelAnnotationsBuilder_ == null) {
                  ensureShotLabelAnnotationsIsMutable();
                  shotLabelAnnotations_.add(m);
                } else {
                  shotLabelAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.videointelligence.v1beta2.LabelAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1beta2.LabelAnnotation.parser(),
                        extensionRegistry);
                if (frameLabelAnnotationsBuilder_ == null) {
                  ensureFrameLabelAnnotationsIsMutable();
                  frameLabelAnnotations_.add(m);
                } else {
                  frameLabelAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.videointelligence.v1beta2.FaceAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1beta2.FaceAnnotation.parser(),
                        extensionRegistry);
                if (faceAnnotationsBuilder_ == null) {
                  ensureFaceAnnotationsIsMutable();
                  faceAnnotations_.add(m);
                } else {
                  faceAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.videointelligence.v1beta2.VideoSegment m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1beta2.VideoSegment.parser(),
                        extensionRegistry);
                if (shotAnnotationsBuilder_ == null) {
                  ensureShotAnnotationsIsMutable();
                  shotAnnotations_.add(m);
                } else {
                  shotAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getExplicitAnnotationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 74:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object inputUri_ = "";
    /**
     *
     *
     * <pre>
     * Video file location in
     * [Google Cloud Storage](https://cloud.google.com/storage/).
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     *
     * @return The inputUri.
     */
    public java.lang.String getInputUri() {
      java.lang.Object ref = inputUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inputUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Video file location in
     * [Google Cloud Storage](https://cloud.google.com/storage/).
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     *
     * @return The bytes for inputUri.
     */
    public com.google.protobuf.ByteString getInputUriBytes() {
      java.lang.Object ref = inputUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inputUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Video file location in
     * [Google Cloud Storage](https://cloud.google.com/storage/).
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     *
     * @param value The inputUri to set.
     * @return This builder for chaining.
     */
    public Builder setInputUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      inputUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video file location in
     * [Google Cloud Storage](https://cloud.google.com/storage/).
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInputUri() {
      inputUri_ = getDefaultInstance().getInputUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video file location in
     * [Google Cloud Storage](https://cloud.google.com/storage/).
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     *
     * @param value The bytes for inputUri to set.
     * @return This builder for chaining.
     */
    public Builder setInputUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      inputUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.videointelligence.v1beta2.LabelAnnotation>
        segmentLabelAnnotations_ = java.util.Collections.emptyList();

    private void ensureSegmentLabelAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        segmentLabelAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1beta2.LabelAnnotation>(
                segmentLabelAnnotations_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1beta2.LabelAnnotation,
            com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder>
        segmentLabelAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1beta2.LabelAnnotation>
        getSegmentLabelAnnotationsList() {
      if (segmentLabelAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(segmentLabelAnnotations_);
      } else {
        return segmentLabelAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public int getSegmentLabelAnnotationsCount() {
      if (segmentLabelAnnotationsBuilder_ == null) {
        return segmentLabelAnnotations_.size();
      } else {
        return segmentLabelAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.LabelAnnotation getSegmentLabelAnnotations(
        int index) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        return segmentLabelAnnotations_.get(index);
      } else {
        return segmentLabelAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder setSegmentLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1beta2.LabelAnnotation value) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.set(index, value);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder setSegmentLabelAnnotations(
        int index,
        com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder builderForValue) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder addSegmentLabelAnnotations(
        com.google.cloud.videointelligence.v1beta2.LabelAnnotation value) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.add(value);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder addSegmentLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1beta2.LabelAnnotation value) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.add(index, value);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder addSegmentLabelAnnotations(
        com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder builderForValue) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder addSegmentLabelAnnotations(
        int index,
        com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder builderForValue) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder addAllSegmentLabelAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1beta2.LabelAnnotation>
            values) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        ensureSegmentLabelAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, segmentLabelAnnotations_);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder clearSegmentLabelAnnotations() {
      if (segmentLabelAnnotationsBuilder_ == null) {
        segmentLabelAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder removeSegmentLabelAnnotations(int index) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.remove(index);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder
        getSegmentLabelAnnotationsBuilder(int index) {
      return getSegmentLabelAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder
        getSegmentLabelAnnotationsOrBuilder(int index) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        return segmentLabelAnnotations_.get(index);
      } else {
        return segmentLabelAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder>
        getSegmentLabelAnnotationsOrBuilderList() {
      if (segmentLabelAnnotationsBuilder_ != null) {
        return segmentLabelAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(segmentLabelAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder
        addSegmentLabelAnnotationsBuilder() {
      return getSegmentLabelAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1beta2.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder
        addSegmentLabelAnnotationsBuilder(int index) {
      return getSegmentLabelAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1beta2.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder>
        getSegmentLabelAnnotationsBuilderList() {
      return getSegmentLabelAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1beta2.LabelAnnotation,
            com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder>
        getSegmentLabelAnnotationsFieldBuilder() {
      if (segmentLabelAnnotationsBuilder_ == null) {
        segmentLabelAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1beta2.LabelAnnotation,
                com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder,
                com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder>(
                segmentLabelAnnotations_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        segmentLabelAnnotations_ = null;
      }
      return segmentLabelAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1beta2.LabelAnnotation>
        shotLabelAnnotations_ = java.util.Collections.emptyList();

    private void ensureShotLabelAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        shotLabelAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1beta2.LabelAnnotation>(
                shotLabelAnnotations_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1beta2.LabelAnnotation,
            com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder>
        shotLabelAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1beta2.LabelAnnotation>
        getShotLabelAnnotationsList() {
      if (shotLabelAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(shotLabelAnnotations_);
      } else {
        return shotLabelAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public int getShotLabelAnnotationsCount() {
      if (shotLabelAnnotationsBuilder_ == null) {
        return shotLabelAnnotations_.size();
      } else {
        return shotLabelAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.LabelAnnotation getShotLabelAnnotations(
        int index) {
      if (shotLabelAnnotationsBuilder_ == null) {
        return shotLabelAnnotations_.get(index);
      } else {
        return shotLabelAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder setShotLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1beta2.LabelAnnotation value) {
      if (shotLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.set(index, value);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder setShotLabelAnnotations(
        int index,
        com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder builderForValue) {
      if (shotLabelAnnotationsBuilder_ == null) {
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder addShotLabelAnnotations(
        com.google.cloud.videointelligence.v1beta2.LabelAnnotation value) {
      if (shotLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.add(value);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder addShotLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1beta2.LabelAnnotation value) {
      if (shotLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.add(index, value);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder addShotLabelAnnotations(
        com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder builderForValue) {
      if (shotLabelAnnotationsBuilder_ == null) {
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder addShotLabelAnnotations(
        int index,
        com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder builderForValue) {
      if (shotLabelAnnotationsBuilder_ == null) {
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder addAllShotLabelAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1beta2.LabelAnnotation>
            values) {
      if (shotLabelAnnotationsBuilder_ == null) {
        ensureShotLabelAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, shotLabelAnnotations_);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder clearShotLabelAnnotations() {
      if (shotLabelAnnotationsBuilder_ == null) {
        shotLabelAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder removeShotLabelAnnotations(int index) {
      if (shotLabelAnnotationsBuilder_ == null) {
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.remove(index);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder
        getShotLabelAnnotationsBuilder(int index) {
      return getShotLabelAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder
        getShotLabelAnnotationsOrBuilder(int index) {
      if (shotLabelAnnotationsBuilder_ == null) {
        return shotLabelAnnotations_.get(index);
      } else {
        return shotLabelAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder>
        getShotLabelAnnotationsOrBuilderList() {
      if (shotLabelAnnotationsBuilder_ != null) {
        return shotLabelAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(shotLabelAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder
        addShotLabelAnnotationsBuilder() {
      return getShotLabelAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1beta2.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder
        addShotLabelAnnotationsBuilder(int index) {
      return getShotLabelAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1beta2.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder>
        getShotLabelAnnotationsBuilderList() {
      return getShotLabelAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1beta2.LabelAnnotation,
            com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder>
        getShotLabelAnnotationsFieldBuilder() {
      if (shotLabelAnnotationsBuilder_ == null) {
        shotLabelAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1beta2.LabelAnnotation,
                com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder,
                com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder>(
                shotLabelAnnotations_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        shotLabelAnnotations_ = null;
      }
      return shotLabelAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1beta2.LabelAnnotation>
        frameLabelAnnotations_ = java.util.Collections.emptyList();

    private void ensureFrameLabelAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        frameLabelAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1beta2.LabelAnnotation>(
                frameLabelAnnotations_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1beta2.LabelAnnotation,
            com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder>
        frameLabelAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1beta2.LabelAnnotation>
        getFrameLabelAnnotationsList() {
      if (frameLabelAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(frameLabelAnnotations_);
      } else {
        return frameLabelAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public int getFrameLabelAnnotationsCount() {
      if (frameLabelAnnotationsBuilder_ == null) {
        return frameLabelAnnotations_.size();
      } else {
        return frameLabelAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.LabelAnnotation getFrameLabelAnnotations(
        int index) {
      if (frameLabelAnnotationsBuilder_ == null) {
        return frameLabelAnnotations_.get(index);
      } else {
        return frameLabelAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder setFrameLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1beta2.LabelAnnotation value) {
      if (frameLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.set(index, value);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder setFrameLabelAnnotations(
        int index,
        com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder builderForValue) {
      if (frameLabelAnnotationsBuilder_ == null) {
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder addFrameLabelAnnotations(
        com.google.cloud.videointelligence.v1beta2.LabelAnnotation value) {
      if (frameLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.add(value);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder addFrameLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1beta2.LabelAnnotation value) {
      if (frameLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.add(index, value);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder addFrameLabelAnnotations(
        com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder builderForValue) {
      if (frameLabelAnnotationsBuilder_ == null) {
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder addFrameLabelAnnotations(
        int index,
        com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder builderForValue) {
      if (frameLabelAnnotationsBuilder_ == null) {
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder addAllFrameLabelAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1beta2.LabelAnnotation>
            values) {
      if (frameLabelAnnotationsBuilder_ == null) {
        ensureFrameLabelAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, frameLabelAnnotations_);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder clearFrameLabelAnnotations() {
      if (frameLabelAnnotationsBuilder_ == null) {
        frameLabelAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder removeFrameLabelAnnotations(int index) {
      if (frameLabelAnnotationsBuilder_ == null) {
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.remove(index);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder
        getFrameLabelAnnotationsBuilder(int index) {
      return getFrameLabelAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder
        getFrameLabelAnnotationsOrBuilder(int index) {
      if (frameLabelAnnotationsBuilder_ == null) {
        return frameLabelAnnotations_.get(index);
      } else {
        return frameLabelAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder>
        getFrameLabelAnnotationsOrBuilderList() {
      if (frameLabelAnnotationsBuilder_ != null) {
        return frameLabelAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(frameLabelAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder
        addFrameLabelAnnotationsBuilder() {
      return getFrameLabelAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1beta2.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder
        addFrameLabelAnnotationsBuilder(int index) {
      return getFrameLabelAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1beta2.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1beta2.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder>
        getFrameLabelAnnotationsBuilderList() {
      return getFrameLabelAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1beta2.LabelAnnotation,
            com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder>
        getFrameLabelAnnotationsFieldBuilder() {
      if (frameLabelAnnotationsBuilder_ == null) {
        frameLabelAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1beta2.LabelAnnotation,
                com.google.cloud.videointelligence.v1beta2.LabelAnnotation.Builder,
                com.google.cloud.videointelligence.v1beta2.LabelAnnotationOrBuilder>(
                frameLabelAnnotations_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        frameLabelAnnotations_ = null;
      }
      return frameLabelAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1beta2.FaceAnnotation>
        faceAnnotations_ = java.util.Collections.emptyList();

    private void ensureFaceAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        faceAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1beta2.FaceAnnotation>(
                faceAnnotations_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1beta2.FaceAnnotation,
            com.google.cloud.videointelligence.v1beta2.FaceAnnotation.Builder,
            com.google.cloud.videointelligence.v1beta2.FaceAnnotationOrBuilder>
        faceAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1beta2.FaceAnnotation>
        getFaceAnnotationsList() {
      if (faceAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(faceAnnotations_);
      } else {
        return faceAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public int getFaceAnnotationsCount() {
      if (faceAnnotationsBuilder_ == null) {
        return faceAnnotations_.size();
      } else {
        return faceAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.FaceAnnotation getFaceAnnotations(int index) {
      if (faceAnnotationsBuilder_ == null) {
        return faceAnnotations_.get(index);
      } else {
        return faceAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public Builder setFaceAnnotations(
        int index, com.google.cloud.videointelligence.v1beta2.FaceAnnotation value) {
      if (faceAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.set(index, value);
        onChanged();
      } else {
        faceAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public Builder setFaceAnnotations(
        int index,
        com.google.cloud.videointelligence.v1beta2.FaceAnnotation.Builder builderForValue) {
      if (faceAnnotationsBuilder_ == null) {
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        faceAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public Builder addFaceAnnotations(
        com.google.cloud.videointelligence.v1beta2.FaceAnnotation value) {
      if (faceAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.add(value);
        onChanged();
      } else {
        faceAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public Builder addFaceAnnotations(
        int index, com.google.cloud.videointelligence.v1beta2.FaceAnnotation value) {
      if (faceAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.add(index, value);
        onChanged();
      } else {
        faceAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public Builder addFaceAnnotations(
        com.google.cloud.videointelligence.v1beta2.FaceAnnotation.Builder builderForValue) {
      if (faceAnnotationsBuilder_ == null) {
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        faceAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public Builder addFaceAnnotations(
        int index,
        com.google.cloud.videointelligence.v1beta2.FaceAnnotation.Builder builderForValue) {
      if (faceAnnotationsBuilder_ == null) {
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        faceAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public Builder addAllFaceAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1beta2.FaceAnnotation>
            values) {
      if (faceAnnotationsBuilder_ == null) {
        ensureFaceAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, faceAnnotations_);
        onChanged();
      } else {
        faceAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public Builder clearFaceAnnotations() {
      if (faceAnnotationsBuilder_ == null) {
        faceAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        faceAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public Builder removeFaceAnnotations(int index) {
      if (faceAnnotationsBuilder_ == null) {
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.remove(index);
        onChanged();
      } else {
        faceAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.FaceAnnotation.Builder
        getFaceAnnotationsBuilder(int index) {
      return getFaceAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.FaceAnnotationOrBuilder
        getFaceAnnotationsOrBuilder(int index) {
      if (faceAnnotationsBuilder_ == null) {
        return faceAnnotations_.get(index);
      } else {
        return faceAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1beta2.FaceAnnotationOrBuilder>
        getFaceAnnotationsOrBuilderList() {
      if (faceAnnotationsBuilder_ != null) {
        return faceAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(faceAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.FaceAnnotation.Builder
        addFaceAnnotationsBuilder() {
      return getFaceAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1beta2.FaceAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.FaceAnnotation.Builder
        addFaceAnnotationsBuilder(int index) {
      return getFaceAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1beta2.FaceAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Face annotations. There is exactly one element for each unique face.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceAnnotation face_annotations = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1beta2.FaceAnnotation.Builder>
        getFaceAnnotationsBuilderList() {
      return getFaceAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1beta2.FaceAnnotation,
            com.google.cloud.videointelligence.v1beta2.FaceAnnotation.Builder,
            com.google.cloud.videointelligence.v1beta2.FaceAnnotationOrBuilder>
        getFaceAnnotationsFieldBuilder() {
      if (faceAnnotationsBuilder_ == null) {
        faceAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1beta2.FaceAnnotation,
                com.google.cloud.videointelligence.v1beta2.FaceAnnotation.Builder,
                com.google.cloud.videointelligence.v1beta2.FaceAnnotationOrBuilder>(
                faceAnnotations_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        faceAnnotations_ = null;
      }
      return faceAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1beta2.VideoSegment>
        shotAnnotations_ = java.util.Collections.emptyList();

    private void ensureShotAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        shotAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1beta2.VideoSegment>(
                shotAnnotations_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1beta2.VideoSegment,
            com.google.cloud.videointelligence.v1beta2.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1beta2.VideoSegmentOrBuilder>
        shotAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1beta2.VideoSegment>
        getShotAnnotationsList() {
      if (shotAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(shotAnnotations_);
      } else {
        return shotAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public int getShotAnnotationsCount() {
      if (shotAnnotationsBuilder_ == null) {
        return shotAnnotations_.size();
      } else {
        return shotAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.VideoSegment getShotAnnotations(int index) {
      if (shotAnnotationsBuilder_ == null) {
        return shotAnnotations_.get(index);
      } else {
        return shotAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder setShotAnnotations(
        int index, com.google.cloud.videointelligence.v1beta2.VideoSegment value) {
      if (shotAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.set(index, value);
        onChanged();
      } else {
        shotAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder setShotAnnotations(
        int index,
        com.google.cloud.videointelligence.v1beta2.VideoSegment.Builder builderForValue) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        shotAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder addShotAnnotations(
        com.google.cloud.videointelligence.v1beta2.VideoSegment value) {
      if (shotAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.add(value);
        onChanged();
      } else {
        shotAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder addShotAnnotations(
        int index, com.google.cloud.videointelligence.v1beta2.VideoSegment value) {
      if (shotAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.add(index, value);
        onChanged();
      } else {
        shotAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder addShotAnnotations(
        com.google.cloud.videointelligence.v1beta2.VideoSegment.Builder builderForValue) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        shotAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder addShotAnnotations(
        int index,
        com.google.cloud.videointelligence.v1beta2.VideoSegment.Builder builderForValue) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        shotAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder addAllShotAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1beta2.VideoSegment>
            values) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, shotAnnotations_);
        onChanged();
      } else {
        shotAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder clearShotAnnotations() {
      if (shotAnnotationsBuilder_ == null) {
        shotAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        shotAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder removeShotAnnotations(int index) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.remove(index);
        onChanged();
      } else {
        shotAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.VideoSegment.Builder
        getShotAnnotationsBuilder(int index) {
      return getShotAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.VideoSegmentOrBuilder
        getShotAnnotationsOrBuilder(int index) {
      if (shotAnnotationsBuilder_ == null) {
        return shotAnnotations_.get(index);
      } else {
        return shotAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1beta2.VideoSegmentOrBuilder>
        getShotAnnotationsOrBuilderList() {
      if (shotAnnotationsBuilder_ != null) {
        return shotAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(shotAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.VideoSegment.Builder
        addShotAnnotationsBuilder() {
      return getShotAnnotationsFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1beta2.VideoSegment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.VideoSegment.Builder
        addShotAnnotationsBuilder(int index) {
      return getShotAnnotationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1beta2.VideoSegment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.VideoSegment shot_annotations = 6;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1beta2.VideoSegment.Builder>
        getShotAnnotationsBuilderList() {
      return getShotAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1beta2.VideoSegment,
            com.google.cloud.videointelligence.v1beta2.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1beta2.VideoSegmentOrBuilder>
        getShotAnnotationsFieldBuilder() {
      if (shotAnnotationsBuilder_ == null) {
        shotAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1beta2.VideoSegment,
                com.google.cloud.videointelligence.v1beta2.VideoSegment.Builder,
                com.google.cloud.videointelligence.v1beta2.VideoSegmentOrBuilder>(
                shotAnnotations_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        shotAnnotations_ = null;
      }
      return shotAnnotationsBuilder_;
    }

    private com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation
        explicitAnnotation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation,
            com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation.Builder,
            com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotationOrBuilder>
        explicitAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     *
     * @return Whether the explicitAnnotation field is set.
     */
    public boolean hasExplicitAnnotation() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     *
     * @return The explicitAnnotation.
     */
    public com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation
        getExplicitAnnotation() {
      if (explicitAnnotationBuilder_ == null) {
        return explicitAnnotation_ == null
            ? com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation
                .getDefaultInstance()
            : explicitAnnotation_;
      } else {
        return explicitAnnotationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public Builder setExplicitAnnotation(
        com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation value) {
      if (explicitAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explicitAnnotation_ = value;
      } else {
        explicitAnnotationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public Builder setExplicitAnnotation(
        com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation.Builder
            builderForValue) {
      if (explicitAnnotationBuilder_ == null) {
        explicitAnnotation_ = builderForValue.build();
      } else {
        explicitAnnotationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public Builder mergeExplicitAnnotation(
        com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation value) {
      if (explicitAnnotationBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && explicitAnnotation_ != null
            && explicitAnnotation_
                != com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation
                    .getDefaultInstance()) {
          getExplicitAnnotationBuilder().mergeFrom(value);
        } else {
          explicitAnnotation_ = value;
        }
      } else {
        explicitAnnotationBuilder_.mergeFrom(value);
      }
      if (explicitAnnotation_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public Builder clearExplicitAnnotation() {
      bitField0_ = (bitField0_ & ~0x00000040);
      explicitAnnotation_ = null;
      if (explicitAnnotationBuilder_ != null) {
        explicitAnnotationBuilder_.dispose();
        explicitAnnotationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation.Builder
        getExplicitAnnotationBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getExplicitAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotationOrBuilder
        getExplicitAnnotationOrBuilder() {
      if (explicitAnnotationBuilder_ != null) {
        return explicitAnnotationBuilder_.getMessageOrBuilder();
      } else {
        return explicitAnnotation_ == null
            ? com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation
                .getDefaultInstance()
            : explicitAnnotation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation,
            com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation.Builder,
            com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotationOrBuilder>
        getExplicitAnnotationFieldBuilder() {
      if (explicitAnnotationBuilder_ == null) {
        explicitAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation,
                com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation.Builder,
                com.google.cloud.videointelligence.v1beta2.ExplicitContentAnnotationOrBuilder>(
                getExplicitAnnotation(), getParentForChildren(), isClean());
        explicitAnnotation_ = null;
      }
      return explicitAnnotationBuilder_;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      if (error_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00000080);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1beta2.VideoAnnotationResults)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1beta2.VideoAnnotationResults)
  private static final com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults();
  }

  public static com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VideoAnnotationResults> PARSER =
      new com.google.protobuf.AbstractParser<VideoAnnotationResults>() {
        @java.lang.Override
        public VideoAnnotationResults parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VideoAnnotationResults> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VideoAnnotationResults> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.VideoAnnotationResults
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
