/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1beta2/video_intelligence.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.videointelligence.v1beta2;

/**
 *
 *
 * <pre>
 * Face annotation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1beta2.FaceAnnotation}
 */
public final class FaceAnnotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1beta2.FaceAnnotation)
    FaceAnnotationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FaceAnnotation.newBuilder() to construct.
  private FaceAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FaceAnnotation() {
    thumbnail_ = com.google.protobuf.ByteString.EMPTY;
    segments_ = java.util.Collections.emptyList();
    frames_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FaceAnnotation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1beta2.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1beta2_FaceAnnotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1beta2.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1beta2_FaceAnnotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1beta2.FaceAnnotation.class,
            com.google.cloud.videointelligence.v1beta2.FaceAnnotation.Builder.class);
  }

  public static final int THUMBNAIL_FIELD_NUMBER = 1;
  private com.google.protobuf.ByteString thumbnail_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Thumbnail of a representative face view (in JPEG format).
   * </pre>
   *
   * <code>bytes thumbnail = 1;</code>
   *
   * @return The thumbnail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getThumbnail() {
    return thumbnail_;
  }

  public static final int SEGMENTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1beta2.FaceSegment> segments_;
  /**
   *
   *
   * <pre>
   * All video segments where a face was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1beta2.FaceSegment> getSegmentsList() {
    return segments_;
  }
  /**
   *
   *
   * <pre>
   * All video segments where a face was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1beta2.FaceSegmentOrBuilder>
      getSegmentsOrBuilderList() {
    return segments_;
  }
  /**
   *
   *
   * <pre>
   * All video segments where a face was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
   */
  @java.lang.Override
  public int getSegmentsCount() {
    return segments_.size();
  }
  /**
   *
   *
   * <pre>
   * All video segments where a face was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.FaceSegment getSegments(int index) {
    return segments_.get(index);
  }
  /**
   *
   *
   * <pre>
   * All video segments where a face was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.FaceSegmentOrBuilder getSegmentsOrBuilder(
      int index) {
    return segments_.get(index);
  }

  public static final int FRAMES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1beta2.FaceFrame> frames_;
  /**
   *
   *
   * <pre>
   * All video frames where a face was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1beta2.FaceFrame> getFramesList() {
    return frames_;
  }
  /**
   *
   *
   * <pre>
   * All video frames where a face was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1beta2.FaceFrameOrBuilder>
      getFramesOrBuilderList() {
    return frames_;
  }
  /**
   *
   *
   * <pre>
   * All video frames where a face was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
   */
  @java.lang.Override
  public int getFramesCount() {
    return frames_.size();
  }
  /**
   *
   *
   * <pre>
   * All video frames where a face was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.FaceFrame getFrames(int index) {
    return frames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * All video frames where a face was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.FaceFrameOrBuilder getFramesOrBuilder(
      int index) {
    return frames_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!thumbnail_.isEmpty()) {
      output.writeBytes(1, thumbnail_);
    }
    for (int i = 0; i < segments_.size(); i++) {
      output.writeMessage(2, segments_.get(i));
    }
    for (int i = 0; i < frames_.size(); i++) {
      output.writeMessage(3, frames_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!thumbnail_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, thumbnail_);
    }
    for (int i = 0; i < segments_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, segments_.get(i));
    }
    for (int i = 0; i < frames_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, frames_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.videointelligence.v1beta2.FaceAnnotation)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1beta2.FaceAnnotation other =
        (com.google.cloud.videointelligence.v1beta2.FaceAnnotation) obj;

    if (!getThumbnail().equals(other.getThumbnail())) return false;
    if (!getSegmentsList().equals(other.getSegmentsList())) return false;
    if (!getFramesList().equals(other.getFramesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + THUMBNAIL_FIELD_NUMBER;
    hash = (53 * hash) + getThumbnail().hashCode();
    if (getSegmentsCount() > 0) {
      hash = (37 * hash) + SEGMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getSegmentsList().hashCode();
    }
    if (getFramesCount() > 0) {
      hash = (37 * hash) + FRAMES_FIELD_NUMBER;
      hash = (53 * hash) + getFramesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1beta2.FaceAnnotation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1beta2.FaceAnnotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1beta2.FaceAnnotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1beta2.FaceAnnotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1beta2.FaceAnnotation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1beta2.FaceAnnotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1beta2.FaceAnnotation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1beta2.FaceAnnotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1beta2.FaceAnnotation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1beta2.FaceAnnotation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1beta2.FaceAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1beta2.FaceAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.videointelligence.v1beta2.FaceAnnotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Face annotation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1beta2.FaceAnnotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1beta2.FaceAnnotation)
      com.google.cloud.videointelligence.v1beta2.FaceAnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1beta2.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1beta2_FaceAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1beta2.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1beta2_FaceAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1beta2.FaceAnnotation.class,
              com.google.cloud.videointelligence.v1beta2.FaceAnnotation.Builder.class);
    }

    // Construct using com.google.cloud.videointelligence.v1beta2.FaceAnnotation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      thumbnail_ = com.google.protobuf.ByteString.EMPTY;
      if (segmentsBuilder_ == null) {
        segments_ = java.util.Collections.emptyList();
      } else {
        segments_ = null;
        segmentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (framesBuilder_ == null) {
        frames_ = java.util.Collections.emptyList();
      } else {
        frames_ = null;
        framesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1beta2.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1beta2_FaceAnnotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1beta2.FaceAnnotation getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1beta2.FaceAnnotation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1beta2.FaceAnnotation build() {
      com.google.cloud.videointelligence.v1beta2.FaceAnnotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1beta2.FaceAnnotation buildPartial() {
      com.google.cloud.videointelligence.v1beta2.FaceAnnotation result =
          new com.google.cloud.videointelligence.v1beta2.FaceAnnotation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.videointelligence.v1beta2.FaceAnnotation result) {
      if (segmentsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          segments_ = java.util.Collections.unmodifiableList(segments_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.segments_ = segments_;
      } else {
        result.segments_ = segmentsBuilder_.build();
      }
      if (framesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          frames_ = java.util.Collections.unmodifiableList(frames_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.frames_ = frames_;
      } else {
        result.frames_ = framesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.videointelligence.v1beta2.FaceAnnotation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.thumbnail_ = thumbnail_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.videointelligence.v1beta2.FaceAnnotation) {
        return mergeFrom((com.google.cloud.videointelligence.v1beta2.FaceAnnotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.videointelligence.v1beta2.FaceAnnotation other) {
      if (other == com.google.cloud.videointelligence.v1beta2.FaceAnnotation.getDefaultInstance())
        return this;
      if (other.getThumbnail() != com.google.protobuf.ByteString.EMPTY) {
        setThumbnail(other.getThumbnail());
      }
      if (segmentsBuilder_ == null) {
        if (!other.segments_.isEmpty()) {
          if (segments_.isEmpty()) {
            segments_ = other.segments_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSegmentsIsMutable();
            segments_.addAll(other.segments_);
          }
          onChanged();
        }
      } else {
        if (!other.segments_.isEmpty()) {
          if (segmentsBuilder_.isEmpty()) {
            segmentsBuilder_.dispose();
            segmentsBuilder_ = null;
            segments_ = other.segments_;
            bitField0_ = (bitField0_ & ~0x00000002);
            segmentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSegmentsFieldBuilder()
                    : null;
          } else {
            segmentsBuilder_.addAllMessages(other.segments_);
          }
        }
      }
      if (framesBuilder_ == null) {
        if (!other.frames_.isEmpty()) {
          if (frames_.isEmpty()) {
            frames_ = other.frames_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureFramesIsMutable();
            frames_.addAll(other.frames_);
          }
          onChanged();
        }
      } else {
        if (!other.frames_.isEmpty()) {
          if (framesBuilder_.isEmpty()) {
            framesBuilder_.dispose();
            framesBuilder_ = null;
            frames_ = other.frames_;
            bitField0_ = (bitField0_ & ~0x00000004);
            framesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFramesFieldBuilder()
                    : null;
          } else {
            framesBuilder_.addAllMessages(other.frames_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                thumbnail_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.videointelligence.v1beta2.FaceSegment m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1beta2.FaceSegment.parser(),
                        extensionRegistry);
                if (segmentsBuilder_ == null) {
                  ensureSegmentsIsMutable();
                  segments_.add(m);
                } else {
                  segmentsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.videointelligence.v1beta2.FaceFrame m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1beta2.FaceFrame.parser(),
                        extensionRegistry);
                if (framesBuilder_ == null) {
                  ensureFramesIsMutable();
                  frames_.add(m);
                } else {
                  framesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.ByteString thumbnail_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Thumbnail of a representative face view (in JPEG format).
     * </pre>
     *
     * <code>bytes thumbnail = 1;</code>
     *
     * @return The thumbnail.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getThumbnail() {
      return thumbnail_;
    }
    /**
     *
     *
     * <pre>
     * Thumbnail of a representative face view (in JPEG format).
     * </pre>
     *
     * <code>bytes thumbnail = 1;</code>
     *
     * @param value The thumbnail to set.
     * @return This builder for chaining.
     */
    public Builder setThumbnail(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      thumbnail_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Thumbnail of a representative face view (in JPEG format).
     * </pre>
     *
     * <code>bytes thumbnail = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearThumbnail() {
      bitField0_ = (bitField0_ & ~0x00000001);
      thumbnail_ = getDefaultInstance().getThumbnail();
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.videointelligence.v1beta2.FaceSegment> segments_ =
        java.util.Collections.emptyList();

    private void ensureSegmentsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        segments_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1beta2.FaceSegment>(
                segments_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1beta2.FaceSegment,
            com.google.cloud.videointelligence.v1beta2.FaceSegment.Builder,
            com.google.cloud.videointelligence.v1beta2.FaceSegmentOrBuilder>
        segmentsBuilder_;

    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1beta2.FaceSegment>
        getSegmentsList() {
      if (segmentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(segments_);
      } else {
        return segmentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public int getSegmentsCount() {
      if (segmentsBuilder_ == null) {
        return segments_.size();
      } else {
        return segmentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public com.google.cloud.videointelligence.v1beta2.FaceSegment getSegments(int index) {
      if (segmentsBuilder_ == null) {
        return segments_.get(index);
      } else {
        return segmentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public Builder setSegments(
        int index, com.google.cloud.videointelligence.v1beta2.FaceSegment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.set(index, value);
        onChanged();
      } else {
        segmentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public Builder setSegments(
        int index, com.google.cloud.videointelligence.v1beta2.FaceSegment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.set(index, builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public Builder addSegments(com.google.cloud.videointelligence.v1beta2.FaceSegment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.add(value);
        onChanged();
      } else {
        segmentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public Builder addSegments(
        int index, com.google.cloud.videointelligence.v1beta2.FaceSegment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.add(index, value);
        onChanged();
      } else {
        segmentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public Builder addSegments(
        com.google.cloud.videointelligence.v1beta2.FaceSegment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.add(builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public Builder addSegments(
        int index, com.google.cloud.videointelligence.v1beta2.FaceSegment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.add(index, builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public Builder addAllSegments(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1beta2.FaceSegment>
            values) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, segments_);
        onChanged();
      } else {
        segmentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public Builder clearSegments() {
      if (segmentsBuilder_ == null) {
        segments_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        segmentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public Builder removeSegments(int index) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.remove(index);
        onChanged();
      } else {
        segmentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public com.google.cloud.videointelligence.v1beta2.FaceSegment.Builder getSegmentsBuilder(
        int index) {
      return getSegmentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public com.google.cloud.videointelligence.v1beta2.FaceSegmentOrBuilder getSegmentsOrBuilder(
        int index) {
      if (segmentsBuilder_ == null) {
        return segments_.get(index);
      } else {
        return segmentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.videointelligence.v1beta2.FaceSegmentOrBuilder>
        getSegmentsOrBuilderList() {
      if (segmentsBuilder_ != null) {
        return segmentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(segments_);
      }
    }
    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public com.google.cloud.videointelligence.v1beta2.FaceSegment.Builder addSegmentsBuilder() {
      return getSegmentsFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1beta2.FaceSegment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public com.google.cloud.videointelligence.v1beta2.FaceSegment.Builder addSegmentsBuilder(
        int index) {
      return getSegmentsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1beta2.FaceSegment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All video segments where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceSegment segments = 2;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1beta2.FaceSegment.Builder>
        getSegmentsBuilderList() {
      return getSegmentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1beta2.FaceSegment,
            com.google.cloud.videointelligence.v1beta2.FaceSegment.Builder,
            com.google.cloud.videointelligence.v1beta2.FaceSegmentOrBuilder>
        getSegmentsFieldBuilder() {
      if (segmentsBuilder_ == null) {
        segmentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1beta2.FaceSegment,
                com.google.cloud.videointelligence.v1beta2.FaceSegment.Builder,
                com.google.cloud.videointelligence.v1beta2.FaceSegmentOrBuilder>(
                segments_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        segments_ = null;
      }
      return segmentsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1beta2.FaceFrame> frames_ =
        java.util.Collections.emptyList();

    private void ensureFramesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        frames_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1beta2.FaceFrame>(frames_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1beta2.FaceFrame,
            com.google.cloud.videointelligence.v1beta2.FaceFrame.Builder,
            com.google.cloud.videointelligence.v1beta2.FaceFrameOrBuilder>
        framesBuilder_;

    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1beta2.FaceFrame> getFramesList() {
      if (framesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(frames_);
      } else {
        return framesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public int getFramesCount() {
      if (framesBuilder_ == null) {
        return frames_.size();
      } else {
        return framesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public com.google.cloud.videointelligence.v1beta2.FaceFrame getFrames(int index) {
      if (framesBuilder_ == null) {
        return frames_.get(index);
      } else {
        return framesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public Builder setFrames(
        int index, com.google.cloud.videointelligence.v1beta2.FaceFrame value) {
      if (framesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFramesIsMutable();
        frames_.set(index, value);
        onChanged();
      } else {
        framesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public Builder setFrames(
        int index, com.google.cloud.videointelligence.v1beta2.FaceFrame.Builder builderForValue) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.set(index, builderForValue.build());
        onChanged();
      } else {
        framesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public Builder addFrames(com.google.cloud.videointelligence.v1beta2.FaceFrame value) {
      if (framesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFramesIsMutable();
        frames_.add(value);
        onChanged();
      } else {
        framesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public Builder addFrames(
        int index, com.google.cloud.videointelligence.v1beta2.FaceFrame value) {
      if (framesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFramesIsMutable();
        frames_.add(index, value);
        onChanged();
      } else {
        framesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public Builder addFrames(
        com.google.cloud.videointelligence.v1beta2.FaceFrame.Builder builderForValue) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.add(builderForValue.build());
        onChanged();
      } else {
        framesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public Builder addFrames(
        int index, com.google.cloud.videointelligence.v1beta2.FaceFrame.Builder builderForValue) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.add(index, builderForValue.build());
        onChanged();
      } else {
        framesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public Builder addAllFrames(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1beta2.FaceFrame> values) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, frames_);
        onChanged();
      } else {
        framesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public Builder clearFrames() {
      if (framesBuilder_ == null) {
        frames_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        framesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public Builder removeFrames(int index) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.remove(index);
        onChanged();
      } else {
        framesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public com.google.cloud.videointelligence.v1beta2.FaceFrame.Builder getFramesBuilder(
        int index) {
      return getFramesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public com.google.cloud.videointelligence.v1beta2.FaceFrameOrBuilder getFramesOrBuilder(
        int index) {
      if (framesBuilder_ == null) {
        return frames_.get(index);
      } else {
        return framesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.videointelligence.v1beta2.FaceFrameOrBuilder>
        getFramesOrBuilderList() {
      if (framesBuilder_ != null) {
        return framesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(frames_);
      }
    }
    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public com.google.cloud.videointelligence.v1beta2.FaceFrame.Builder addFramesBuilder() {
      return getFramesFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1beta2.FaceFrame.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public com.google.cloud.videointelligence.v1beta2.FaceFrame.Builder addFramesBuilder(
        int index) {
      return getFramesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1beta2.FaceFrame.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All video frames where a face was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1beta2.FaceFrame frames = 3;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1beta2.FaceFrame.Builder>
        getFramesBuilderList() {
      return getFramesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1beta2.FaceFrame,
            com.google.cloud.videointelligence.v1beta2.FaceFrame.Builder,
            com.google.cloud.videointelligence.v1beta2.FaceFrameOrBuilder>
        getFramesFieldBuilder() {
      if (framesBuilder_ == null) {
        framesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1beta2.FaceFrame,
                com.google.cloud.videointelligence.v1beta2.FaceFrame.Builder,
                com.google.cloud.videointelligence.v1beta2.FaceFrameOrBuilder>(
                frames_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        frames_ = null;
      }
      return framesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1beta2.FaceAnnotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1beta2.FaceAnnotation)
  private static final com.google.cloud.videointelligence.v1beta2.FaceAnnotation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.videointelligence.v1beta2.FaceAnnotation();
  }

  public static com.google.cloud.videointelligence.v1beta2.FaceAnnotation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FaceAnnotation> PARSER =
      new com.google.protobuf.AbstractParser<FaceAnnotation>() {
        @java.lang.Override
        public FaceAnnotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FaceAnnotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FaceAnnotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1beta2.FaceAnnotation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
