/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1p1beta1/video_intelligence.proto

package com.google.cloud.videointelligence.v1p1beta1;

/**
 *
 *
 * <pre>
 * Video annotation request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest}
 */
public final class AnnotateVideoRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest)
    AnnotateVideoRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnnotateVideoRequest.newBuilder() to construct.
  private AnnotateVideoRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnnotateVideoRequest() {
    inputUri_ = "";
    inputContent_ = com.google.protobuf.ByteString.EMPTY;
    features_ = java.util.Collections.emptyList();
    outputUri_ = "";
    locationId_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private AnnotateVideoRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              inputUri_ = s;
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                features_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000004;
              }
              features_.add(rawValue);
              break;
            }
          case 18:
            {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while (input.getBytesUntilLimit() > 0) {
                int rawValue = input.readEnum();
                if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                  features_ = new java.util.ArrayList<java.lang.Integer>();
                  mutable_bitField0_ |= 0x00000004;
                }
                features_.add(rawValue);
              }
              input.popLimit(oldLimit);
              break;
            }
          case 26:
            {
              com.google.cloud.videointelligence.v1p1beta1.VideoContext.Builder subBuilder = null;
              if (videoContext_ != null) {
                subBuilder = videoContext_.toBuilder();
              }
              videoContext_ =
                  input.readMessage(
                      com.google.cloud.videointelligence.v1p1beta1.VideoContext.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(videoContext_);
                videoContext_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              outputUri_ = s;
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              locationId_ = s;
              break;
            }
          case 50:
            {
              inputContent_ = input.readBytes();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        features_ = java.util.Collections.unmodifiableList(features_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1p1beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p1beta1_AnnotateVideoRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1p1beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p1beta1_AnnotateVideoRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest.class,
            com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest.Builder.class);
  }

  private int bitField0_;
  public static final int INPUT_URI_FIELD_NUMBER = 1;
  private volatile java.lang.Object inputUri_;
  /**
   *
   *
   * <pre>
   * Input video location. Currently, only
   * [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
   * supported, which must be specified in the following format:
   * `gs://bucket-id/object-id` (other URI formats return
   * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
   * more information, see [Request URIs](/storage/docs/reference-uris). A video
   * URI may include wildcards in `object-id`, and thus identify multiple
   * videos. Supported wildcards: '*' to match 0 or more characters;
   * '?' to match 1 character. If unset, the input video should be embedded
   * in the request as `input_content`. If set, `input_content` should be unset.
   * </pre>
   *
   * <code>string input_uri = 1;</code>
   */
  public java.lang.String getInputUri() {
    java.lang.Object ref = inputUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      inputUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Input video location. Currently, only
   * [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
   * supported, which must be specified in the following format:
   * `gs://bucket-id/object-id` (other URI formats return
   * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
   * more information, see [Request URIs](/storage/docs/reference-uris). A video
   * URI may include wildcards in `object-id`, and thus identify multiple
   * videos. Supported wildcards: '*' to match 0 or more characters;
   * '?' to match 1 character. If unset, the input video should be embedded
   * in the request as `input_content`. If set, `input_content` should be unset.
   * </pre>
   *
   * <code>string input_uri = 1;</code>
   */
  public com.google.protobuf.ByteString getInputUriBytes() {
    java.lang.Object ref = inputUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      inputUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUT_CONTENT_FIELD_NUMBER = 6;
  private com.google.protobuf.ByteString inputContent_;
  /**
   *
   *
   * <pre>
   * The video data bytes.
   * If unset, the input video(s) should be specified via `input_uri`.
   * If set, `input_uri` should be unset.
   * </pre>
   *
   * <code>bytes input_content = 6;</code>
   */
  public com.google.protobuf.ByteString getInputContent() {
    return inputContent_;
  }

  public static final int FEATURES_FIELD_NUMBER = 2;
  private java.util.List<java.lang.Integer> features_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.videointelligence.v1p1beta1.Feature>
      features_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.videointelligence.v1p1beta1.Feature>() {
            public com.google.cloud.videointelligence.v1p1beta1.Feature convert(
                java.lang.Integer from) {
              @SuppressWarnings("deprecation")
              com.google.cloud.videointelligence.v1p1beta1.Feature result =
                  com.google.cloud.videointelligence.v1p1beta1.Feature.valueOf(from);
              return result == null
                  ? com.google.cloud.videointelligence.v1p1beta1.Feature.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Requested video annotation features.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p1beta1.Feature features = 2;</code>
   */
  public java.util.List<com.google.cloud.videointelligence.v1p1beta1.Feature> getFeaturesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.videointelligence.v1p1beta1.Feature>(
        features_, features_converter_);
  }
  /**
   *
   *
   * <pre>
   * Requested video annotation features.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p1beta1.Feature features = 2;</code>
   */
  public int getFeaturesCount() {
    return features_.size();
  }
  /**
   *
   *
   * <pre>
   * Requested video annotation features.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p1beta1.Feature features = 2;</code>
   */
  public com.google.cloud.videointelligence.v1p1beta1.Feature getFeatures(int index) {
    return features_converter_.convert(features_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Requested video annotation features.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p1beta1.Feature features = 2;</code>
   */
  public java.util.List<java.lang.Integer> getFeaturesValueList() {
    return features_;
  }
  /**
   *
   *
   * <pre>
   * Requested video annotation features.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p1beta1.Feature features = 2;</code>
   */
  public int getFeaturesValue(int index) {
    return features_.get(index);
  }

  private int featuresMemoizedSerializedSize;

  public static final int VIDEO_CONTEXT_FIELD_NUMBER = 3;
  private com.google.cloud.videointelligence.v1p1beta1.VideoContext videoContext_;
  /**
   *
   *
   * <pre>
   * Additional video context and/or feature-specific parameters.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p1beta1.VideoContext video_context = 3;</code>
   */
  public boolean hasVideoContext() {
    return videoContext_ != null;
  }
  /**
   *
   *
   * <pre>
   * Additional video context and/or feature-specific parameters.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p1beta1.VideoContext video_context = 3;</code>
   */
  public com.google.cloud.videointelligence.v1p1beta1.VideoContext getVideoContext() {
    return videoContext_ == null
        ? com.google.cloud.videointelligence.v1p1beta1.VideoContext.getDefaultInstance()
        : videoContext_;
  }
  /**
   *
   *
   * <pre>
   * Additional video context and/or feature-specific parameters.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p1beta1.VideoContext video_context = 3;</code>
   */
  public com.google.cloud.videointelligence.v1p1beta1.VideoContextOrBuilder
      getVideoContextOrBuilder() {
    return getVideoContext();
  }

  public static final int OUTPUT_URI_FIELD_NUMBER = 4;
  private volatile java.lang.Object outputUri_;
  /**
   *
   *
   * <pre>
   * Optional location where the output (in JSON format) should be stored.
   * Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
   * URIs are supported, which must be specified in the following format:
   * `gs://bucket-id/object-id` (other URI formats return
   * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
   * more information, see [Request URIs](/storage/docs/reference-uris).
   * </pre>
   *
   * <code>string output_uri = 4;</code>
   */
  public java.lang.String getOutputUri() {
    java.lang.Object ref = outputUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      outputUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional location where the output (in JSON format) should be stored.
   * Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
   * URIs are supported, which must be specified in the following format:
   * `gs://bucket-id/object-id` (other URI formats return
   * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
   * more information, see [Request URIs](/storage/docs/reference-uris).
   * </pre>
   *
   * <code>string output_uri = 4;</code>
   */
  public com.google.protobuf.ByteString getOutputUriBytes() {
    java.lang.Object ref = outputUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      outputUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_ID_FIELD_NUMBER = 5;
  private volatile java.lang.Object locationId_;
  /**
   *
   *
   * <pre>
   * Optional cloud region where annotation should take place. Supported cloud
   * regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
   * is specified, a region will be determined based on video file location.
   * </pre>
   *
   * <code>string location_id = 5;</code>
   */
  public java.lang.String getLocationId() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional cloud region where annotation should take place. Supported cloud
   * regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
   * is specified, a region will be determined based on video file location.
   * </pre>
   *
   * <code>string location_id = 5;</code>
   */
  public com.google.protobuf.ByteString getLocationIdBytes() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!getInputUriBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, inputUri_);
    }
    if (getFeaturesList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(featuresMemoizedSerializedSize);
    }
    for (int i = 0; i < features_.size(); i++) {
      output.writeEnumNoTag(features_.get(i));
    }
    if (videoContext_ != null) {
      output.writeMessage(3, getVideoContext());
    }
    if (!getOutputUriBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, outputUri_);
    }
    if (!getLocationIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, locationId_);
    }
    if (!inputContent_.isEmpty()) {
      output.writeBytes(6, inputContent_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getInputUriBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, inputUri_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < features_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(features_.get(i));
      }
      size += dataSize;
      if (!getFeaturesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      featuresMemoizedSerializedSize = dataSize;
    }
    if (videoContext_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getVideoContext());
    }
    if (!getOutputUriBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, outputUri_);
    }
    if (!getLocationIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, locationId_);
    }
    if (!inputContent_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(6, inputContent_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest other =
        (com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest) obj;

    if (!getInputUri().equals(other.getInputUri())) return false;
    if (!getInputContent().equals(other.getInputContent())) return false;
    if (!features_.equals(other.features_)) return false;
    if (hasVideoContext() != other.hasVideoContext()) return false;
    if (hasVideoContext()) {
      if (!getVideoContext().equals(other.getVideoContext())) return false;
    }
    if (!getOutputUri().equals(other.getOutputUri())) return false;
    if (!getLocationId().equals(other.getLocationId())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INPUT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getInputUri().hashCode();
    hash = (37 * hash) + INPUT_CONTENT_FIELD_NUMBER;
    hash = (53 * hash) + getInputContent().hashCode();
    if (getFeaturesCount() > 0) {
      hash = (37 * hash) + FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + features_.hashCode();
    }
    if (hasVideoContext()) {
      hash = (37 * hash) + VIDEO_CONTEXT_FIELD_NUMBER;
      hash = (53 * hash) + getVideoContext().hashCode();
    }
    hash = (37 * hash) + OUTPUT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getOutputUri().hashCode();
    hash = (37 * hash) + LOCATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getLocationId().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Video annotation request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest)
      com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1p1beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p1beta1_AnnotateVideoRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1p1beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p1beta1_AnnotateVideoRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest.class,
              com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      inputUri_ = "";

      inputContent_ = com.google.protobuf.ByteString.EMPTY;

      features_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      if (videoContextBuilder_ == null) {
        videoContext_ = null;
      } else {
        videoContext_ = null;
        videoContextBuilder_ = null;
      }
      outputUri_ = "";

      locationId_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1p1beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p1beta1_AnnotateVideoRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest
        getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest build() {
      com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest buildPartial() {
      com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest result =
          new com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.inputUri_ = inputUri_;
      result.inputContent_ = inputContent_;
      if (((bitField0_ & 0x00000004) != 0)) {
        features_ = java.util.Collections.unmodifiableList(features_);
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.features_ = features_;
      if (videoContextBuilder_ == null) {
        result.videoContext_ = videoContext_;
      } else {
        result.videoContext_ = videoContextBuilder_.build();
      }
      result.outputUri_ = outputUri_;
      result.locationId_ = locationId_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest) {
        return mergeFrom((com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest other) {
      if (other
          == com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest.getDefaultInstance())
        return this;
      if (!other.getInputUri().isEmpty()) {
        inputUri_ = other.inputUri_;
        onChanged();
      }
      if (other.getInputContent() != com.google.protobuf.ByteString.EMPTY) {
        setInputContent(other.getInputContent());
      }
      if (!other.features_.isEmpty()) {
        if (features_.isEmpty()) {
          features_ = other.features_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureFeaturesIsMutable();
          features_.addAll(other.features_);
        }
        onChanged();
      }
      if (other.hasVideoContext()) {
        mergeVideoContext(other.getVideoContext());
      }
      if (!other.getOutputUri().isEmpty()) {
        outputUri_ = other.outputUri_;
        onChanged();
      }
      if (!other.getLocationId().isEmpty()) {
        locationId_ = other.locationId_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object inputUri_ = "";
    /**
     *
     *
     * <pre>
     * Input video location. Currently, only
     * [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
     * supported, which must be specified in the following format:
     * `gs://bucket-id/object-id` (other URI formats return
     * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
     * more information, see [Request URIs](/storage/docs/reference-uris). A video
     * URI may include wildcards in `object-id`, and thus identify multiple
     * videos. Supported wildcards: '*' to match 0 or more characters;
     * '?' to match 1 character. If unset, the input video should be embedded
     * in the request as `input_content`. If set, `input_content` should be unset.
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     */
    public java.lang.String getInputUri() {
      java.lang.Object ref = inputUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inputUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input video location. Currently, only
     * [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
     * supported, which must be specified in the following format:
     * `gs://bucket-id/object-id` (other URI formats return
     * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
     * more information, see [Request URIs](/storage/docs/reference-uris). A video
     * URI may include wildcards in `object-id`, and thus identify multiple
     * videos. Supported wildcards: '*' to match 0 or more characters;
     * '?' to match 1 character. If unset, the input video should be embedded
     * in the request as `input_content`. If set, `input_content` should be unset.
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     */
    public com.google.protobuf.ByteString getInputUriBytes() {
      java.lang.Object ref = inputUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inputUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input video location. Currently, only
     * [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
     * supported, which must be specified in the following format:
     * `gs://bucket-id/object-id` (other URI formats return
     * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
     * more information, see [Request URIs](/storage/docs/reference-uris). A video
     * URI may include wildcards in `object-id`, and thus identify multiple
     * videos. Supported wildcards: '*' to match 0 or more characters;
     * '?' to match 1 character. If unset, the input video should be embedded
     * in the request as `input_content`. If set, `input_content` should be unset.
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     */
    public Builder setInputUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      inputUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input video location. Currently, only
     * [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
     * supported, which must be specified in the following format:
     * `gs://bucket-id/object-id` (other URI formats return
     * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
     * more information, see [Request URIs](/storage/docs/reference-uris). A video
     * URI may include wildcards in `object-id`, and thus identify multiple
     * videos. Supported wildcards: '*' to match 0 or more characters;
     * '?' to match 1 character. If unset, the input video should be embedded
     * in the request as `input_content`. If set, `input_content` should be unset.
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     */
    public Builder clearInputUri() {

      inputUri_ = getDefaultInstance().getInputUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input video location. Currently, only
     * [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
     * supported, which must be specified in the following format:
     * `gs://bucket-id/object-id` (other URI formats return
     * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
     * more information, see [Request URIs](/storage/docs/reference-uris). A video
     * URI may include wildcards in `object-id`, and thus identify multiple
     * videos. Supported wildcards: '*' to match 0 or more characters;
     * '?' to match 1 character. If unset, the input video should be embedded
     * in the request as `input_content`. If set, `input_content` should be unset.
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     */
    public Builder setInputUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      inputUri_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString inputContent_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The video data bytes.
     * If unset, the input video(s) should be specified via `input_uri`.
     * If set, `input_uri` should be unset.
     * </pre>
     *
     * <code>bytes input_content = 6;</code>
     */
    public com.google.protobuf.ByteString getInputContent() {
      return inputContent_;
    }
    /**
     *
     *
     * <pre>
     * The video data bytes.
     * If unset, the input video(s) should be specified via `input_uri`.
     * If set, `input_uri` should be unset.
     * </pre>
     *
     * <code>bytes input_content = 6;</code>
     */
    public Builder setInputContent(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      inputContent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The video data bytes.
     * If unset, the input video(s) should be specified via `input_uri`.
     * If set, `input_uri` should be unset.
     * </pre>
     *
     * <code>bytes input_content = 6;</code>
     */
    public Builder clearInputContent() {

      inputContent_ = getDefaultInstance().getInputContent();
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> features_ = java.util.Collections.emptyList();

    private void ensureFeaturesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        features_ = new java.util.ArrayList<java.lang.Integer>(features_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * Requested video annotation features.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p1beta1.Feature features = 2;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p1beta1.Feature> getFeaturesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.videointelligence.v1p1beta1.Feature>(
          features_, features_converter_);
    }
    /**
     *
     *
     * <pre>
     * Requested video annotation features.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p1beta1.Feature features = 2;</code>
     */
    public int getFeaturesCount() {
      return features_.size();
    }
    /**
     *
     *
     * <pre>
     * Requested video annotation features.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p1beta1.Feature features = 2;</code>
     */
    public com.google.cloud.videointelligence.v1p1beta1.Feature getFeatures(int index) {
      return features_converter_.convert(features_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Requested video annotation features.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p1beta1.Feature features = 2;</code>
     */
    public Builder setFeatures(
        int index, com.google.cloud.videointelligence.v1p1beta1.Feature value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFeaturesIsMutable();
      features_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested video annotation features.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p1beta1.Feature features = 2;</code>
     */
    public Builder addFeatures(com.google.cloud.videointelligence.v1p1beta1.Feature value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFeaturesIsMutable();
      features_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested video annotation features.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p1beta1.Feature features = 2;</code>
     */
    public Builder addAllFeatures(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1p1beta1.Feature> values) {
      ensureFeaturesIsMutable();
      for (com.google.cloud.videointelligence.v1p1beta1.Feature value : values) {
        features_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested video annotation features.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p1beta1.Feature features = 2;</code>
     */
    public Builder clearFeatures() {
      features_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested video annotation features.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p1beta1.Feature features = 2;</code>
     */
    public java.util.List<java.lang.Integer> getFeaturesValueList() {
      return java.util.Collections.unmodifiableList(features_);
    }
    /**
     *
     *
     * <pre>
     * Requested video annotation features.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p1beta1.Feature features = 2;</code>
     */
    public int getFeaturesValue(int index) {
      return features_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Requested video annotation features.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p1beta1.Feature features = 2;</code>
     */
    public Builder setFeaturesValue(int index, int value) {
      ensureFeaturesIsMutable();
      features_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested video annotation features.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p1beta1.Feature features = 2;</code>
     */
    public Builder addFeaturesValue(int value) {
      ensureFeaturesIsMutable();
      features_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested video annotation features.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p1beta1.Feature features = 2;</code>
     */
    public Builder addAllFeaturesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureFeaturesIsMutable();
      for (int value : values) {
        features_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.cloud.videointelligence.v1p1beta1.VideoContext videoContext_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p1beta1.VideoContext,
            com.google.cloud.videointelligence.v1p1beta1.VideoContext.Builder,
            com.google.cloud.videointelligence.v1p1beta1.VideoContextOrBuilder>
        videoContextBuilder_;
    /**
     *
     *
     * <pre>
     * Additional video context and/or feature-specific parameters.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p1beta1.VideoContext video_context = 3;</code>
     */
    public boolean hasVideoContext() {
      return videoContextBuilder_ != null || videoContext_ != null;
    }
    /**
     *
     *
     * <pre>
     * Additional video context and/or feature-specific parameters.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p1beta1.VideoContext video_context = 3;</code>
     */
    public com.google.cloud.videointelligence.v1p1beta1.VideoContext getVideoContext() {
      if (videoContextBuilder_ == null) {
        return videoContext_ == null
            ? com.google.cloud.videointelligence.v1p1beta1.VideoContext.getDefaultInstance()
            : videoContext_;
      } else {
        return videoContextBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional video context and/or feature-specific parameters.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p1beta1.VideoContext video_context = 3;</code>
     */
    public Builder setVideoContext(
        com.google.cloud.videointelligence.v1p1beta1.VideoContext value) {
      if (videoContextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        videoContext_ = value;
        onChanged();
      } else {
        videoContextBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional video context and/or feature-specific parameters.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p1beta1.VideoContext video_context = 3;</code>
     */
    public Builder setVideoContext(
        com.google.cloud.videointelligence.v1p1beta1.VideoContext.Builder builderForValue) {
      if (videoContextBuilder_ == null) {
        videoContext_ = builderForValue.build();
        onChanged();
      } else {
        videoContextBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional video context and/or feature-specific parameters.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p1beta1.VideoContext video_context = 3;</code>
     */
    public Builder mergeVideoContext(
        com.google.cloud.videointelligence.v1p1beta1.VideoContext value) {
      if (videoContextBuilder_ == null) {
        if (videoContext_ != null) {
          videoContext_ =
              com.google.cloud.videointelligence.v1p1beta1.VideoContext.newBuilder(videoContext_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          videoContext_ = value;
        }
        onChanged();
      } else {
        videoContextBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional video context and/or feature-specific parameters.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p1beta1.VideoContext video_context = 3;</code>
     */
    public Builder clearVideoContext() {
      if (videoContextBuilder_ == null) {
        videoContext_ = null;
        onChanged();
      } else {
        videoContext_ = null;
        videoContextBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional video context and/or feature-specific parameters.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p1beta1.VideoContext video_context = 3;</code>
     */
    public com.google.cloud.videointelligence.v1p1beta1.VideoContext.Builder
        getVideoContextBuilder() {

      onChanged();
      return getVideoContextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional video context and/or feature-specific parameters.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p1beta1.VideoContext video_context = 3;</code>
     */
    public com.google.cloud.videointelligence.v1p1beta1.VideoContextOrBuilder
        getVideoContextOrBuilder() {
      if (videoContextBuilder_ != null) {
        return videoContextBuilder_.getMessageOrBuilder();
      } else {
        return videoContext_ == null
            ? com.google.cloud.videointelligence.v1p1beta1.VideoContext.getDefaultInstance()
            : videoContext_;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional video context and/or feature-specific parameters.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p1beta1.VideoContext video_context = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p1beta1.VideoContext,
            com.google.cloud.videointelligence.v1p1beta1.VideoContext.Builder,
            com.google.cloud.videointelligence.v1p1beta1.VideoContextOrBuilder>
        getVideoContextFieldBuilder() {
      if (videoContextBuilder_ == null) {
        videoContextBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1p1beta1.VideoContext,
                com.google.cloud.videointelligence.v1p1beta1.VideoContext.Builder,
                com.google.cloud.videointelligence.v1p1beta1.VideoContextOrBuilder>(
                getVideoContext(), getParentForChildren(), isClean());
        videoContext_ = null;
      }
      return videoContextBuilder_;
    }

    private java.lang.Object outputUri_ = "";
    /**
     *
     *
     * <pre>
     * Optional location where the output (in JSON format) should be stored.
     * Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
     * URIs are supported, which must be specified in the following format:
     * `gs://bucket-id/object-id` (other URI formats return
     * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
     * more information, see [Request URIs](/storage/docs/reference-uris).
     * </pre>
     *
     * <code>string output_uri = 4;</code>
     */
    public java.lang.String getOutputUri() {
      java.lang.Object ref = outputUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        outputUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional location where the output (in JSON format) should be stored.
     * Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
     * URIs are supported, which must be specified in the following format:
     * `gs://bucket-id/object-id` (other URI formats return
     * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
     * more information, see [Request URIs](/storage/docs/reference-uris).
     * </pre>
     *
     * <code>string output_uri = 4;</code>
     */
    public com.google.protobuf.ByteString getOutputUriBytes() {
      java.lang.Object ref = outputUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        outputUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional location where the output (in JSON format) should be stored.
     * Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
     * URIs are supported, which must be specified in the following format:
     * `gs://bucket-id/object-id` (other URI formats return
     * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
     * more information, see [Request URIs](/storage/docs/reference-uris).
     * </pre>
     *
     * <code>string output_uri = 4;</code>
     */
    public Builder setOutputUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      outputUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional location where the output (in JSON format) should be stored.
     * Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
     * URIs are supported, which must be specified in the following format:
     * `gs://bucket-id/object-id` (other URI formats return
     * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
     * more information, see [Request URIs](/storage/docs/reference-uris).
     * </pre>
     *
     * <code>string output_uri = 4;</code>
     */
    public Builder clearOutputUri() {

      outputUri_ = getDefaultInstance().getOutputUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional location where the output (in JSON format) should be stored.
     * Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
     * URIs are supported, which must be specified in the following format:
     * `gs://bucket-id/object-id` (other URI formats return
     * [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
     * more information, see [Request URIs](/storage/docs/reference-uris).
     * </pre>
     *
     * <code>string output_uri = 4;</code>
     */
    public Builder setOutputUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      outputUri_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object locationId_ = "";
    /**
     *
     *
     * <pre>
     * Optional cloud region where annotation should take place. Supported cloud
     * regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
     * is specified, a region will be determined based on video file location.
     * </pre>
     *
     * <code>string location_id = 5;</code>
     */
    public java.lang.String getLocationId() {
      java.lang.Object ref = locationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional cloud region where annotation should take place. Supported cloud
     * regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
     * is specified, a region will be determined based on video file location.
     * </pre>
     *
     * <code>string location_id = 5;</code>
     */
    public com.google.protobuf.ByteString getLocationIdBytes() {
      java.lang.Object ref = locationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional cloud region where annotation should take place. Supported cloud
     * regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
     * is specified, a region will be determined based on video file location.
     * </pre>
     *
     * <code>string location_id = 5;</code>
     */
    public Builder setLocationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      locationId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional cloud region where annotation should take place. Supported cloud
     * regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
     * is specified, a region will be determined based on video file location.
     * </pre>
     *
     * <code>string location_id = 5;</code>
     */
    public Builder clearLocationId() {

      locationId_ = getDefaultInstance().getLocationId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional cloud region where annotation should take place. Supported cloud
     * regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
     * is specified, a region will be determined based on video file location.
     * </pre>
     *
     * <code>string location_id = 5;</code>
     */
    public Builder setLocationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      locationId_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest)
  private static final com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest();
  }

  public static com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnnotateVideoRequest> PARSER =
      new com.google.protobuf.AbstractParser<AnnotateVideoRequest>() {
        @java.lang.Override
        public AnnotateVideoRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AnnotateVideoRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<AnnotateVideoRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnnotateVideoRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1p1beta1.AnnotateVideoRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
