/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1p2beta1/video_intelligence.proto

package com.google.cloud.videointelligence.v1p2beta1;

/**
 *
 *
 * <pre>
 * Annotation results for a single video.
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults}
 */
public final class VideoAnnotationResults extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults)
    VideoAnnotationResultsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VideoAnnotationResults.newBuilder() to construct.
  private VideoAnnotationResults(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VideoAnnotationResults() {
    inputUri_ = "";
    segmentLabelAnnotations_ = java.util.Collections.emptyList();
    shotLabelAnnotations_ = java.util.Collections.emptyList();
    frameLabelAnnotations_ = java.util.Collections.emptyList();
    shotAnnotations_ = java.util.Collections.emptyList();
    textAnnotations_ = java.util.Collections.emptyList();
    objectAnnotations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VideoAnnotationResults();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1p2beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p2beta1_VideoAnnotationResults_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1p2beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p2beta1_VideoAnnotationResults_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults.class,
            com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults.Builder.class);
  }

  public static final int INPUT_URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object inputUri_ = "";
  /**
   *
   *
   * <pre>
   * Video file location in
   * [Google Cloud Storage](https://cloud.google.com/storage/).
   * </pre>
   *
   * <code>string input_uri = 1;</code>
   *
   * @return The inputUri.
   */
  @java.lang.Override
  public java.lang.String getInputUri() {
    java.lang.Object ref = inputUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      inputUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Video file location in
   * [Google Cloud Storage](https://cloud.google.com/storage/).
   * </pre>
   *
   * <code>string input_uri = 1;</code>
   *
   * @return The bytes for inputUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInputUriBytes() {
    java.lang.Object ref = inputUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      inputUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SEGMENT_LABEL_ANNOTATIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>
      segmentLabelAnnotations_;
  /**
   *
   *
   * <pre>
   * Label annotations on video level or user specified segment level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>
      getSegmentLabelAnnotationsList() {
    return segmentLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Label annotations on video level or user specified segment level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder>
      getSegmentLabelAnnotationsOrBuilderList() {
    return segmentLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Label annotations on video level or user specified segment level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public int getSegmentLabelAnnotationsCount() {
    return segmentLabelAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Label annotations on video level or user specified segment level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation getSegmentLabelAnnotations(
      int index) {
    return segmentLabelAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Label annotations on video level or user specified segment level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder
      getSegmentLabelAnnotationsOrBuilder(int index) {
    return segmentLabelAnnotations_.get(index);
  }

  public static final int SHOT_LABEL_ANNOTATIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>
      shotLabelAnnotations_;
  /**
   *
   *
   * <pre>
   * Label annotations on shot level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>
      getShotLabelAnnotationsList() {
    return shotLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Label annotations on shot level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder>
      getShotLabelAnnotationsOrBuilderList() {
    return shotLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Label annotations on shot level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
   * </code>
   */
  @java.lang.Override
  public int getShotLabelAnnotationsCount() {
    return shotLabelAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Label annotations on shot level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation getShotLabelAnnotations(
      int index) {
    return shotLabelAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Label annotations on shot level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder
      getShotLabelAnnotationsOrBuilder(int index) {
    return shotLabelAnnotations_.get(index);
  }

  public static final int FRAME_LABEL_ANNOTATIONS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>
      frameLabelAnnotations_;
  /**
   *
   *
   * <pre>
   * Label annotations on frame level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>
      getFrameLabelAnnotationsList() {
    return frameLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Label annotations on frame level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder>
      getFrameLabelAnnotationsOrBuilderList() {
    return frameLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Label annotations on frame level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public int getFrameLabelAnnotationsCount() {
    return frameLabelAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Label annotations on frame level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation getFrameLabelAnnotations(
      int index) {
    return frameLabelAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Label annotations on frame level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder
      getFrameLabelAnnotationsOrBuilder(int index) {
    return frameLabelAnnotations_.get(index);
  }

  public static final int SHOT_ANNOTATIONS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1p2beta1.VideoSegment>
      shotAnnotations_;
  /**
   *
   *
   * <pre>
   * Shot annotations. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1p2beta1.VideoSegment>
      getShotAnnotationsList() {
    return shotAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Shot annotations. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder>
      getShotAnnotationsOrBuilderList() {
    return shotAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Shot annotations. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
   * </code>
   */
  @java.lang.Override
  public int getShotAnnotationsCount() {
    return shotAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Shot annotations. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.VideoSegment getShotAnnotations(int index) {
    return shotAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Shot annotations. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder
      getShotAnnotationsOrBuilder(int index) {
    return shotAnnotations_.get(index);
  }

  public static final int EXPLICIT_ANNOTATION_FIELD_NUMBER = 7;
  private com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation
      explicitAnnotation_;
  /**
   *
   *
   * <pre>
   * Explicit content annotation.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation explicit_annotation = 7;
   * </code>
   *
   * @return Whether the explicitAnnotation field is set.
   */
  @java.lang.Override
  public boolean hasExplicitAnnotation() {
    return explicitAnnotation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Explicit content annotation.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation explicit_annotation = 7;
   * </code>
   *
   * @return The explicitAnnotation.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation
      getExplicitAnnotation() {
    return explicitAnnotation_ == null
        ? com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation
            .getDefaultInstance()
        : explicitAnnotation_;
  }
  /**
   *
   *
   * <pre>
   * Explicit content annotation.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation explicit_annotation = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotationOrBuilder
      getExplicitAnnotationOrBuilder() {
    return explicitAnnotation_ == null
        ? com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation
            .getDefaultInstance()
        : explicitAnnotation_;
  }

  public static final int TEXT_ANNOTATIONS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1p2beta1.TextAnnotation>
      textAnnotations_;
  /**
   *
   *
   * <pre>
   * OCR text detection and tracking.
   * Annotations for list of detected text snippets. Each will have list of
   * frame information associated with it.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1p2beta1.TextAnnotation>
      getTextAnnotationsList() {
    return textAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * OCR text detection and tracking.
   * Annotations for list of detected text snippets. Each will have list of
   * frame information associated with it.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1p2beta1.TextAnnotationOrBuilder>
      getTextAnnotationsOrBuilderList() {
    return textAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * OCR text detection and tracking.
   * Annotations for list of detected text snippets. Each will have list of
   * frame information associated with it.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
   * </code>
   */
  @java.lang.Override
  public int getTextAnnotationsCount() {
    return textAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * OCR text detection and tracking.
   * Annotations for list of detected text snippets. Each will have list of
   * frame information associated with it.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.TextAnnotation getTextAnnotations(int index) {
    return textAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * OCR text detection and tracking.
   * Annotations for list of detected text snippets. Each will have list of
   * frame information associated with it.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.TextAnnotationOrBuilder
      getTextAnnotationsOrBuilder(int index) {
    return textAnnotations_.get(index);
  }

  public static final int OBJECT_ANNOTATIONS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation>
      objectAnnotations_;
  /**
   *
   *
   * <pre>
   * Annotations for list of objects detected and tracked in video.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation>
      getObjectAnnotationsList() {
    return objectAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Annotations for list of objects detected and tracked in video.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotationOrBuilder>
      getObjectAnnotationsOrBuilderList() {
    return objectAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Annotations for list of objects detected and tracked in video.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
   * </code>
   */
  @java.lang.Override
  public int getObjectAnnotationsCount() {
    return objectAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Annotations for list of objects detected and tracked in video.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation getObjectAnnotations(
      int index) {
    return objectAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Annotations for list of objects detected and tracked in video.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotationOrBuilder
      getObjectAnnotationsOrBuilder(int index) {
    return objectAnnotations_.get(index);
  }

  public static final int ERROR_FIELD_NUMBER = 9;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
   * some videos may succeed and some may fail.
   * </pre>
   *
   * <code>.google.rpc.Status error = 9;</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return error_ != null;
  }
  /**
   *
   *
   * <pre>
   * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
   * some videos may succeed and some may fail.
   * </pre>
   *
   * <code>.google.rpc.Status error = 9;</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
   * some videos may succeed and some may fail.
   * </pre>
   *
   * <code>.google.rpc.Status error = 9;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, inputUri_);
    }
    for (int i = 0; i < segmentLabelAnnotations_.size(); i++) {
      output.writeMessage(2, segmentLabelAnnotations_.get(i));
    }
    for (int i = 0; i < shotLabelAnnotations_.size(); i++) {
      output.writeMessage(3, shotLabelAnnotations_.get(i));
    }
    for (int i = 0; i < frameLabelAnnotations_.size(); i++) {
      output.writeMessage(4, frameLabelAnnotations_.get(i));
    }
    for (int i = 0; i < shotAnnotations_.size(); i++) {
      output.writeMessage(6, shotAnnotations_.get(i));
    }
    if (explicitAnnotation_ != null) {
      output.writeMessage(7, getExplicitAnnotation());
    }
    if (error_ != null) {
      output.writeMessage(9, getError());
    }
    for (int i = 0; i < textAnnotations_.size(); i++) {
      output.writeMessage(12, textAnnotations_.get(i));
    }
    for (int i = 0; i < objectAnnotations_.size(); i++) {
      output.writeMessage(14, objectAnnotations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, inputUri_);
    }
    for (int i = 0; i < segmentLabelAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, segmentLabelAnnotations_.get(i));
    }
    for (int i = 0; i < shotLabelAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, shotLabelAnnotations_.get(i));
    }
    for (int i = 0; i < frameLabelAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, frameLabelAnnotations_.get(i));
    }
    for (int i = 0; i < shotAnnotations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, shotAnnotations_.get(i));
    }
    if (explicitAnnotation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getExplicitAnnotation());
    }
    if (error_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getError());
    }
    for (int i = 0; i < textAnnotations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, textAnnotations_.get(i));
    }
    for (int i = 0; i < objectAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(14, objectAnnotations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults other =
        (com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults) obj;

    if (!getInputUri().equals(other.getInputUri())) return false;
    if (!getSegmentLabelAnnotationsList().equals(other.getSegmentLabelAnnotationsList()))
      return false;
    if (!getShotLabelAnnotationsList().equals(other.getShotLabelAnnotationsList())) return false;
    if (!getFrameLabelAnnotationsList().equals(other.getFrameLabelAnnotationsList())) return false;
    if (!getShotAnnotationsList().equals(other.getShotAnnotationsList())) return false;
    if (hasExplicitAnnotation() != other.hasExplicitAnnotation()) return false;
    if (hasExplicitAnnotation()) {
      if (!getExplicitAnnotation().equals(other.getExplicitAnnotation())) return false;
    }
    if (!getTextAnnotationsList().equals(other.getTextAnnotationsList())) return false;
    if (!getObjectAnnotationsList().equals(other.getObjectAnnotationsList())) return false;
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INPUT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getInputUri().hashCode();
    if (getSegmentLabelAnnotationsCount() > 0) {
      hash = (37 * hash) + SEGMENT_LABEL_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getSegmentLabelAnnotationsList().hashCode();
    }
    if (getShotLabelAnnotationsCount() > 0) {
      hash = (37 * hash) + SHOT_LABEL_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getShotLabelAnnotationsList().hashCode();
    }
    if (getFrameLabelAnnotationsCount() > 0) {
      hash = (37 * hash) + FRAME_LABEL_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFrameLabelAnnotationsList().hashCode();
    }
    if (getShotAnnotationsCount() > 0) {
      hash = (37 * hash) + SHOT_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getShotAnnotationsList().hashCode();
    }
    if (hasExplicitAnnotation()) {
      hash = (37 * hash) + EXPLICIT_ANNOTATION_FIELD_NUMBER;
      hash = (53 * hash) + getExplicitAnnotation().hashCode();
    }
    if (getTextAnnotationsCount() > 0) {
      hash = (37 * hash) + TEXT_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getTextAnnotationsList().hashCode();
    }
    if (getObjectAnnotationsCount() > 0) {
      hash = (37 * hash) + OBJECT_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getObjectAnnotationsList().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Annotation results for a single video.
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults)
      com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResultsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1p2beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p2beta1_VideoAnnotationResults_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1p2beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p2beta1_VideoAnnotationResults_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults.class,
              com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults.Builder.class);
    }

    // Construct using
    // com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      inputUri_ = "";
      if (segmentLabelAnnotationsBuilder_ == null) {
        segmentLabelAnnotations_ = java.util.Collections.emptyList();
      } else {
        segmentLabelAnnotations_ = null;
        segmentLabelAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (shotLabelAnnotationsBuilder_ == null) {
        shotLabelAnnotations_ = java.util.Collections.emptyList();
      } else {
        shotLabelAnnotations_ = null;
        shotLabelAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (frameLabelAnnotationsBuilder_ == null) {
        frameLabelAnnotations_ = java.util.Collections.emptyList();
      } else {
        frameLabelAnnotations_ = null;
        frameLabelAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (shotAnnotationsBuilder_ == null) {
        shotAnnotations_ = java.util.Collections.emptyList();
      } else {
        shotAnnotations_ = null;
        shotAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      explicitAnnotation_ = null;
      if (explicitAnnotationBuilder_ != null) {
        explicitAnnotationBuilder_.dispose();
        explicitAnnotationBuilder_ = null;
      }
      if (textAnnotationsBuilder_ == null) {
        textAnnotations_ = java.util.Collections.emptyList();
      } else {
        textAnnotations_ = null;
        textAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      if (objectAnnotationsBuilder_ == null) {
        objectAnnotations_ = java.util.Collections.emptyList();
      } else {
        objectAnnotations_ = null;
        objectAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1p2beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p2beta1_VideoAnnotationResults_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults
        getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults build() {
      com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults buildPartial() {
      com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults result =
          new com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults result) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          segmentLabelAnnotations_ =
              java.util.Collections.unmodifiableList(segmentLabelAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.segmentLabelAnnotations_ = segmentLabelAnnotations_;
      } else {
        result.segmentLabelAnnotations_ = segmentLabelAnnotationsBuilder_.build();
      }
      if (shotLabelAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          shotLabelAnnotations_ = java.util.Collections.unmodifiableList(shotLabelAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.shotLabelAnnotations_ = shotLabelAnnotations_;
      } else {
        result.shotLabelAnnotations_ = shotLabelAnnotationsBuilder_.build();
      }
      if (frameLabelAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          frameLabelAnnotations_ = java.util.Collections.unmodifiableList(frameLabelAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.frameLabelAnnotations_ = frameLabelAnnotations_;
      } else {
        result.frameLabelAnnotations_ = frameLabelAnnotationsBuilder_.build();
      }
      if (shotAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          shotAnnotations_ = java.util.Collections.unmodifiableList(shotAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.shotAnnotations_ = shotAnnotations_;
      } else {
        result.shotAnnotations_ = shotAnnotationsBuilder_.build();
      }
      if (textAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          textAnnotations_ = java.util.Collections.unmodifiableList(textAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.textAnnotations_ = textAnnotations_;
      } else {
        result.textAnnotations_ = textAnnotationsBuilder_.build();
      }
      if (objectAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          objectAnnotations_ = java.util.Collections.unmodifiableList(objectAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.objectAnnotations_ = objectAnnotations_;
      } else {
        result.objectAnnotations_ = objectAnnotationsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.inputUri_ = inputUri_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.explicitAnnotation_ =
            explicitAnnotationBuilder_ == null
                ? explicitAnnotation_
                : explicitAnnotationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults) {
        return mergeFrom(
            (com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults other) {
      if (other
          == com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults
              .getDefaultInstance()) return this;
      if (!other.getInputUri().isEmpty()) {
        inputUri_ = other.inputUri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (segmentLabelAnnotationsBuilder_ == null) {
        if (!other.segmentLabelAnnotations_.isEmpty()) {
          if (segmentLabelAnnotations_.isEmpty()) {
            segmentLabelAnnotations_ = other.segmentLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSegmentLabelAnnotationsIsMutable();
            segmentLabelAnnotations_.addAll(other.segmentLabelAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.segmentLabelAnnotations_.isEmpty()) {
          if (segmentLabelAnnotationsBuilder_.isEmpty()) {
            segmentLabelAnnotationsBuilder_.dispose();
            segmentLabelAnnotationsBuilder_ = null;
            segmentLabelAnnotations_ = other.segmentLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            segmentLabelAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSegmentLabelAnnotationsFieldBuilder()
                    : null;
          } else {
            segmentLabelAnnotationsBuilder_.addAllMessages(other.segmentLabelAnnotations_);
          }
        }
      }
      if (shotLabelAnnotationsBuilder_ == null) {
        if (!other.shotLabelAnnotations_.isEmpty()) {
          if (shotLabelAnnotations_.isEmpty()) {
            shotLabelAnnotations_ = other.shotLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureShotLabelAnnotationsIsMutable();
            shotLabelAnnotations_.addAll(other.shotLabelAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.shotLabelAnnotations_.isEmpty()) {
          if (shotLabelAnnotationsBuilder_.isEmpty()) {
            shotLabelAnnotationsBuilder_.dispose();
            shotLabelAnnotationsBuilder_ = null;
            shotLabelAnnotations_ = other.shotLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000004);
            shotLabelAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getShotLabelAnnotationsFieldBuilder()
                    : null;
          } else {
            shotLabelAnnotationsBuilder_.addAllMessages(other.shotLabelAnnotations_);
          }
        }
      }
      if (frameLabelAnnotationsBuilder_ == null) {
        if (!other.frameLabelAnnotations_.isEmpty()) {
          if (frameLabelAnnotations_.isEmpty()) {
            frameLabelAnnotations_ = other.frameLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureFrameLabelAnnotationsIsMutable();
            frameLabelAnnotations_.addAll(other.frameLabelAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.frameLabelAnnotations_.isEmpty()) {
          if (frameLabelAnnotationsBuilder_.isEmpty()) {
            frameLabelAnnotationsBuilder_.dispose();
            frameLabelAnnotationsBuilder_ = null;
            frameLabelAnnotations_ = other.frameLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000008);
            frameLabelAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFrameLabelAnnotationsFieldBuilder()
                    : null;
          } else {
            frameLabelAnnotationsBuilder_.addAllMessages(other.frameLabelAnnotations_);
          }
        }
      }
      if (shotAnnotationsBuilder_ == null) {
        if (!other.shotAnnotations_.isEmpty()) {
          if (shotAnnotations_.isEmpty()) {
            shotAnnotations_ = other.shotAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureShotAnnotationsIsMutable();
            shotAnnotations_.addAll(other.shotAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.shotAnnotations_.isEmpty()) {
          if (shotAnnotationsBuilder_.isEmpty()) {
            shotAnnotationsBuilder_.dispose();
            shotAnnotationsBuilder_ = null;
            shotAnnotations_ = other.shotAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000010);
            shotAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getShotAnnotationsFieldBuilder()
                    : null;
          } else {
            shotAnnotationsBuilder_.addAllMessages(other.shotAnnotations_);
          }
        }
      }
      if (other.hasExplicitAnnotation()) {
        mergeExplicitAnnotation(other.getExplicitAnnotation());
      }
      if (textAnnotationsBuilder_ == null) {
        if (!other.textAnnotations_.isEmpty()) {
          if (textAnnotations_.isEmpty()) {
            textAnnotations_ = other.textAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureTextAnnotationsIsMutable();
            textAnnotations_.addAll(other.textAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.textAnnotations_.isEmpty()) {
          if (textAnnotationsBuilder_.isEmpty()) {
            textAnnotationsBuilder_.dispose();
            textAnnotationsBuilder_ = null;
            textAnnotations_ = other.textAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000040);
            textAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTextAnnotationsFieldBuilder()
                    : null;
          } else {
            textAnnotationsBuilder_.addAllMessages(other.textAnnotations_);
          }
        }
      }
      if (objectAnnotationsBuilder_ == null) {
        if (!other.objectAnnotations_.isEmpty()) {
          if (objectAnnotations_.isEmpty()) {
            objectAnnotations_ = other.objectAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureObjectAnnotationsIsMutable();
            objectAnnotations_.addAll(other.objectAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.objectAnnotations_.isEmpty()) {
          if (objectAnnotationsBuilder_.isEmpty()) {
            objectAnnotationsBuilder_.dispose();
            objectAnnotationsBuilder_ = null;
            objectAnnotations_ = other.objectAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000080);
            objectAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getObjectAnnotationsFieldBuilder()
                    : null;
          } else {
            objectAnnotationsBuilder_.addAllMessages(other.objectAnnotations_);
          }
        }
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                inputUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.parser(),
                        extensionRegistry);
                if (segmentLabelAnnotationsBuilder_ == null) {
                  ensureSegmentLabelAnnotationsIsMutable();
                  segmentLabelAnnotations_.add(m);
                } else {
                  segmentLabelAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.parser(),
                        extensionRegistry);
                if (shotLabelAnnotationsBuilder_ == null) {
                  ensureShotLabelAnnotationsIsMutable();
                  shotLabelAnnotations_.add(m);
                } else {
                  shotLabelAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.parser(),
                        extensionRegistry);
                if (frameLabelAnnotationsBuilder_ == null) {
                  ensureFrameLabelAnnotationsIsMutable();
                  frameLabelAnnotations_.add(m);
                } else {
                  frameLabelAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 50:
              {
                com.google.cloud.videointelligence.v1p2beta1.VideoSegment m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1p2beta1.VideoSegment.parser(),
                        extensionRegistry);
                if (shotAnnotationsBuilder_ == null) {
                  ensureShotAnnotationsIsMutable();
                  shotAnnotations_.add(m);
                } else {
                  shotAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getExplicitAnnotationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 74:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 98:
              {
                com.google.cloud.videointelligence.v1p2beta1.TextAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1p2beta1.TextAnnotation.parser(),
                        extensionRegistry);
                if (textAnnotationsBuilder_ == null) {
                  ensureTextAnnotationsIsMutable();
                  textAnnotations_.add(m);
                } else {
                  textAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 114:
              {
                com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation
                            .parser(),
                        extensionRegistry);
                if (objectAnnotationsBuilder_ == null) {
                  ensureObjectAnnotationsIsMutable();
                  objectAnnotations_.add(m);
                } else {
                  objectAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object inputUri_ = "";
    /**
     *
     *
     * <pre>
     * Video file location in
     * [Google Cloud Storage](https://cloud.google.com/storage/).
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     *
     * @return The inputUri.
     */
    public java.lang.String getInputUri() {
      java.lang.Object ref = inputUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inputUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Video file location in
     * [Google Cloud Storage](https://cloud.google.com/storage/).
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     *
     * @return The bytes for inputUri.
     */
    public com.google.protobuf.ByteString getInputUriBytes() {
      java.lang.Object ref = inputUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inputUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Video file location in
     * [Google Cloud Storage](https://cloud.google.com/storage/).
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     *
     * @param value The inputUri to set.
     * @return This builder for chaining.
     */
    public Builder setInputUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      inputUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video file location in
     * [Google Cloud Storage](https://cloud.google.com/storage/).
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInputUri() {
      inputUri_ = getDefaultInstance().getInputUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video file location in
     * [Google Cloud Storage](https://cloud.google.com/storage/).
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     *
     * @param value The bytes for inputUri to set.
     * @return This builder for chaining.
     */
    public Builder setInputUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      inputUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>
        segmentLabelAnnotations_ = java.util.Collections.emptyList();

    private void ensureSegmentLabelAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        segmentLabelAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>(
                segmentLabelAnnotations_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation,
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder>
        segmentLabelAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>
        getSegmentLabelAnnotationsList() {
      if (segmentLabelAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(segmentLabelAnnotations_);
      } else {
        return segmentLabelAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public int getSegmentLabelAnnotationsCount() {
      if (segmentLabelAnnotationsBuilder_ == null) {
        return segmentLabelAnnotations_.size();
      } else {
        return segmentLabelAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation getSegmentLabelAnnotations(
        int index) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        return segmentLabelAnnotations_.get(index);
      } else {
        return segmentLabelAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder setSegmentLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation value) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.set(index, value);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder setSegmentLabelAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder builderForValue) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder addSegmentLabelAnnotations(
        com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation value) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.add(value);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder addSegmentLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation value) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.add(index, value);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder addSegmentLabelAnnotations(
        com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder builderForValue) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder addSegmentLabelAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder builderForValue) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder addAllSegmentLabelAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>
            values) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        ensureSegmentLabelAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, segmentLabelAnnotations_);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder clearSegmentLabelAnnotations() {
      if (segmentLabelAnnotationsBuilder_ == null) {
        segmentLabelAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder removeSegmentLabelAnnotations(int index) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.remove(index);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder
        getSegmentLabelAnnotationsBuilder(int index) {
      return getSegmentLabelAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder
        getSegmentLabelAnnotationsOrBuilder(int index) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        return segmentLabelAnnotations_.get(index);
      } else {
        return segmentLabelAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder>
        getSegmentLabelAnnotationsOrBuilderList() {
      if (segmentLabelAnnotationsBuilder_ != null) {
        return segmentLabelAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(segmentLabelAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder
        addSegmentLabelAnnotationsBuilder() {
      return getSegmentLabelAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder
        addSegmentLabelAnnotationsBuilder(int index) {
      return getSegmentLabelAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Label annotations on video level or user specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder>
        getSegmentLabelAnnotationsBuilderList() {
      return getSegmentLabelAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation,
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder>
        getSegmentLabelAnnotationsFieldBuilder() {
      if (segmentLabelAnnotationsBuilder_ == null) {
        segmentLabelAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation,
                com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder,
                com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder>(
                segmentLabelAnnotations_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        segmentLabelAnnotations_ = null;
      }
      return segmentLabelAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>
        shotLabelAnnotations_ = java.util.Collections.emptyList();

    private void ensureShotLabelAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        shotLabelAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>(
                shotLabelAnnotations_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation,
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder>
        shotLabelAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>
        getShotLabelAnnotationsList() {
      if (shotLabelAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(shotLabelAnnotations_);
      } else {
        return shotLabelAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public int getShotLabelAnnotationsCount() {
      if (shotLabelAnnotationsBuilder_ == null) {
        return shotLabelAnnotations_.size();
      } else {
        return shotLabelAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation getShotLabelAnnotations(
        int index) {
      if (shotLabelAnnotationsBuilder_ == null) {
        return shotLabelAnnotations_.get(index);
      } else {
        return shotLabelAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder setShotLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation value) {
      if (shotLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.set(index, value);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder setShotLabelAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder builderForValue) {
      if (shotLabelAnnotationsBuilder_ == null) {
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder addShotLabelAnnotations(
        com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation value) {
      if (shotLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.add(value);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder addShotLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation value) {
      if (shotLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.add(index, value);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder addShotLabelAnnotations(
        com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder builderForValue) {
      if (shotLabelAnnotationsBuilder_ == null) {
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder addShotLabelAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder builderForValue) {
      if (shotLabelAnnotationsBuilder_ == null) {
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder addAllShotLabelAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>
            values) {
      if (shotLabelAnnotationsBuilder_ == null) {
        ensureShotLabelAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, shotLabelAnnotations_);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder clearShotLabelAnnotations() {
      if (shotLabelAnnotationsBuilder_ == null) {
        shotLabelAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder removeShotLabelAnnotations(int index) {
      if (shotLabelAnnotationsBuilder_ == null) {
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.remove(index);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder
        getShotLabelAnnotationsBuilder(int index) {
      return getShotLabelAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder
        getShotLabelAnnotationsOrBuilder(int index) {
      if (shotLabelAnnotationsBuilder_ == null) {
        return shotLabelAnnotations_.get(index);
      } else {
        return shotLabelAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder>
        getShotLabelAnnotationsOrBuilderList() {
      if (shotLabelAnnotationsBuilder_ != null) {
        return shotLabelAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(shotLabelAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder
        addShotLabelAnnotationsBuilder() {
      return getShotLabelAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder
        addShotLabelAnnotationsBuilder(int index) {
      return getShotLabelAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder>
        getShotLabelAnnotationsBuilderList() {
      return getShotLabelAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation,
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder>
        getShotLabelAnnotationsFieldBuilder() {
      if (shotLabelAnnotationsBuilder_ == null) {
        shotLabelAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation,
                com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder,
                com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder>(
                shotLabelAnnotations_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        shotLabelAnnotations_ = null;
      }
      return shotLabelAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>
        frameLabelAnnotations_ = java.util.Collections.emptyList();

    private void ensureFrameLabelAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        frameLabelAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>(
                frameLabelAnnotations_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation,
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder>
        frameLabelAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>
        getFrameLabelAnnotationsList() {
      if (frameLabelAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(frameLabelAnnotations_);
      } else {
        return frameLabelAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public int getFrameLabelAnnotationsCount() {
      if (frameLabelAnnotationsBuilder_ == null) {
        return frameLabelAnnotations_.size();
      } else {
        return frameLabelAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation getFrameLabelAnnotations(
        int index) {
      if (frameLabelAnnotationsBuilder_ == null) {
        return frameLabelAnnotations_.get(index);
      } else {
        return frameLabelAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder setFrameLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation value) {
      if (frameLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.set(index, value);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder setFrameLabelAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder builderForValue) {
      if (frameLabelAnnotationsBuilder_ == null) {
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder addFrameLabelAnnotations(
        com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation value) {
      if (frameLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.add(value);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder addFrameLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation value) {
      if (frameLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.add(index, value);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder addFrameLabelAnnotations(
        com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder builderForValue) {
      if (frameLabelAnnotationsBuilder_ == null) {
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder addFrameLabelAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder builderForValue) {
      if (frameLabelAnnotationsBuilder_ == null) {
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder addAllFrameLabelAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation>
            values) {
      if (frameLabelAnnotationsBuilder_ == null) {
        ensureFrameLabelAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, frameLabelAnnotations_);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder clearFrameLabelAnnotations() {
      if (frameLabelAnnotationsBuilder_ == null) {
        frameLabelAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder removeFrameLabelAnnotations(int index) {
      if (frameLabelAnnotationsBuilder_ == null) {
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.remove(index);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder
        getFrameLabelAnnotationsBuilder(int index) {
      return getFrameLabelAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder
        getFrameLabelAnnotationsOrBuilder(int index) {
      if (frameLabelAnnotationsBuilder_ == null) {
        return frameLabelAnnotations_.get(index);
      } else {
        return frameLabelAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder>
        getFrameLabelAnnotationsOrBuilderList() {
      if (frameLabelAnnotationsBuilder_ != null) {
        return frameLabelAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(frameLabelAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder
        addFrameLabelAnnotationsBuilder() {
      return getFrameLabelAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder
        addFrameLabelAnnotationsBuilder(int index) {
      return getFrameLabelAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder>
        getFrameLabelAnnotationsBuilderList() {
      return getFrameLabelAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation,
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder>
        getFrameLabelAnnotationsFieldBuilder() {
      if (frameLabelAnnotationsBuilder_ == null) {
        frameLabelAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation,
                com.google.cloud.videointelligence.v1p2beta1.LabelAnnotation.Builder,
                com.google.cloud.videointelligence.v1p2beta1.LabelAnnotationOrBuilder>(
                frameLabelAnnotations_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        frameLabelAnnotations_ = null;
      }
      return frameLabelAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1p2beta1.VideoSegment>
        shotAnnotations_ = java.util.Collections.emptyList();

    private void ensureShotAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        shotAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1p2beta1.VideoSegment>(
                shotAnnotations_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.VideoSegment,
            com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder>
        shotAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p2beta1.VideoSegment>
        getShotAnnotationsList() {
      if (shotAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(shotAnnotations_);
      } else {
        return shotAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public int getShotAnnotationsCount() {
      if (shotAnnotationsBuilder_ == null) {
        return shotAnnotations_.size();
      } else {
        return shotAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.VideoSegment getShotAnnotations(int index) {
      if (shotAnnotationsBuilder_ == null) {
        return shotAnnotations_.get(index);
      } else {
        return shotAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder setShotAnnotations(
        int index, com.google.cloud.videointelligence.v1p2beta1.VideoSegment value) {
      if (shotAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.set(index, value);
        onChanged();
      } else {
        shotAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder setShotAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder builderForValue) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        shotAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder addShotAnnotations(
        com.google.cloud.videointelligence.v1p2beta1.VideoSegment value) {
      if (shotAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.add(value);
        onChanged();
      } else {
        shotAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder addShotAnnotations(
        int index, com.google.cloud.videointelligence.v1p2beta1.VideoSegment value) {
      if (shotAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.add(index, value);
        onChanged();
      } else {
        shotAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder addShotAnnotations(
        com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder builderForValue) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        shotAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder addShotAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder builderForValue) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        shotAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder addAllShotAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1p2beta1.VideoSegment>
            values) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, shotAnnotations_);
        onChanged();
      } else {
        shotAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder clearShotAnnotations() {
      if (shotAnnotationsBuilder_ == null) {
        shotAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        shotAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public Builder removeShotAnnotations(int index) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.remove(index);
        onChanged();
      } else {
        shotAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder
        getShotAnnotationsBuilder(int index) {
      return getShotAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder
        getShotAnnotationsOrBuilder(int index) {
      if (shotAnnotationsBuilder_ == null) {
        return shotAnnotations_.get(index);
      } else {
        return shotAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder>
        getShotAnnotationsOrBuilderList() {
      if (shotAnnotationsBuilder_ != null) {
        return shotAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(shotAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder
        addShotAnnotationsBuilder() {
      return getShotAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1p2beta1.VideoSegment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder
        addShotAnnotationsBuilder(int index) {
      return getShotAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1p2beta1.VideoSegment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment shot_annotations = 6;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder>
        getShotAnnotationsBuilderList() {
      return getShotAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.VideoSegment,
            com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder>
        getShotAnnotationsFieldBuilder() {
      if (shotAnnotationsBuilder_ == null) {
        shotAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p2beta1.VideoSegment,
                com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder,
                com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder>(
                shotAnnotations_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        shotAnnotations_ = null;
      }
      return shotAnnotationsBuilder_;
    }

    private com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation
        explicitAnnotation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation,
            com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation.Builder,
            com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotationOrBuilder>
        explicitAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     *
     * @return Whether the explicitAnnotation field is set.
     */
    public boolean hasExplicitAnnotation() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     *
     * @return The explicitAnnotation.
     */
    public com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation
        getExplicitAnnotation() {
      if (explicitAnnotationBuilder_ == null) {
        return explicitAnnotation_ == null
            ? com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation
                .getDefaultInstance()
            : explicitAnnotation_;
      } else {
        return explicitAnnotationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public Builder setExplicitAnnotation(
        com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation value) {
      if (explicitAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explicitAnnotation_ = value;
      } else {
        explicitAnnotationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public Builder setExplicitAnnotation(
        com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation.Builder
            builderForValue) {
      if (explicitAnnotationBuilder_ == null) {
        explicitAnnotation_ = builderForValue.build();
      } else {
        explicitAnnotationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public Builder mergeExplicitAnnotation(
        com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation value) {
      if (explicitAnnotationBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && explicitAnnotation_ != null
            && explicitAnnotation_
                != com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation
                    .getDefaultInstance()) {
          getExplicitAnnotationBuilder().mergeFrom(value);
        } else {
          explicitAnnotation_ = value;
        }
      } else {
        explicitAnnotationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public Builder clearExplicitAnnotation() {
      bitField0_ = (bitField0_ & ~0x00000020);
      explicitAnnotation_ = null;
      if (explicitAnnotationBuilder_ != null) {
        explicitAnnotationBuilder_.dispose();
        explicitAnnotationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation.Builder
        getExplicitAnnotationBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getExplicitAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotationOrBuilder
        getExplicitAnnotationOrBuilder() {
      if (explicitAnnotationBuilder_ != null) {
        return explicitAnnotationBuilder_.getMessageOrBuilder();
      } else {
        return explicitAnnotation_ == null
            ? com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation
                .getDefaultInstance()
            : explicitAnnotation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation,
            com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation.Builder,
            com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotationOrBuilder>
        getExplicitAnnotationFieldBuilder() {
      if (explicitAnnotationBuilder_ == null) {
        explicitAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation,
                com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation.Builder,
                com.google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotationOrBuilder>(
                getExplicitAnnotation(), getParentForChildren(), isClean());
        explicitAnnotation_ = null;
      }
      return explicitAnnotationBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1p2beta1.TextAnnotation>
        textAnnotations_ = java.util.Collections.emptyList();

    private void ensureTextAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        textAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1p2beta1.TextAnnotation>(
                textAnnotations_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.TextAnnotation,
            com.google.cloud.videointelligence.v1p2beta1.TextAnnotation.Builder,
            com.google.cloud.videointelligence.v1p2beta1.TextAnnotationOrBuilder>
        textAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p2beta1.TextAnnotation>
        getTextAnnotationsList() {
      if (textAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(textAnnotations_);
      } else {
        return textAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public int getTextAnnotationsCount() {
      if (textAnnotationsBuilder_ == null) {
        return textAnnotations_.size();
      } else {
        return textAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.TextAnnotation getTextAnnotations(
        int index) {
      if (textAnnotationsBuilder_ == null) {
        return textAnnotations_.get(index);
      } else {
        return textAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder setTextAnnotations(
        int index, com.google.cloud.videointelligence.v1p2beta1.TextAnnotation value) {
      if (textAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTextAnnotationsIsMutable();
        textAnnotations_.set(index, value);
        onChanged();
      } else {
        textAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder setTextAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p2beta1.TextAnnotation.Builder builderForValue) {
      if (textAnnotationsBuilder_ == null) {
        ensureTextAnnotationsIsMutable();
        textAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        textAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder addTextAnnotations(
        com.google.cloud.videointelligence.v1p2beta1.TextAnnotation value) {
      if (textAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTextAnnotationsIsMutable();
        textAnnotations_.add(value);
        onChanged();
      } else {
        textAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder addTextAnnotations(
        int index, com.google.cloud.videointelligence.v1p2beta1.TextAnnotation value) {
      if (textAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTextAnnotationsIsMutable();
        textAnnotations_.add(index, value);
        onChanged();
      } else {
        textAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder addTextAnnotations(
        com.google.cloud.videointelligence.v1p2beta1.TextAnnotation.Builder builderForValue) {
      if (textAnnotationsBuilder_ == null) {
        ensureTextAnnotationsIsMutable();
        textAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        textAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder addTextAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p2beta1.TextAnnotation.Builder builderForValue) {
      if (textAnnotationsBuilder_ == null) {
        ensureTextAnnotationsIsMutable();
        textAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        textAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder addAllTextAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1p2beta1.TextAnnotation>
            values) {
      if (textAnnotationsBuilder_ == null) {
        ensureTextAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, textAnnotations_);
        onChanged();
      } else {
        textAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder clearTextAnnotations() {
      if (textAnnotationsBuilder_ == null) {
        textAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        textAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder removeTextAnnotations(int index) {
      if (textAnnotationsBuilder_ == null) {
        ensureTextAnnotationsIsMutable();
        textAnnotations_.remove(index);
        onChanged();
      } else {
        textAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.TextAnnotation.Builder
        getTextAnnotationsBuilder(int index) {
      return getTextAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.TextAnnotationOrBuilder
        getTextAnnotationsOrBuilder(int index) {
      if (textAnnotationsBuilder_ == null) {
        return textAnnotations_.get(index);
      } else {
        return textAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1p2beta1.TextAnnotationOrBuilder>
        getTextAnnotationsOrBuilderList() {
      if (textAnnotationsBuilder_ != null) {
        return textAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(textAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.TextAnnotation.Builder
        addTextAnnotationsBuilder() {
      return getTextAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1p2beta1.TextAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.TextAnnotation.Builder
        addTextAnnotationsBuilder(int index) {
      return getTextAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1p2beta1.TextAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p2beta1.TextAnnotation.Builder>
        getTextAnnotationsBuilderList() {
      return getTextAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.TextAnnotation,
            com.google.cloud.videointelligence.v1p2beta1.TextAnnotation.Builder,
            com.google.cloud.videointelligence.v1p2beta1.TextAnnotationOrBuilder>
        getTextAnnotationsFieldBuilder() {
      if (textAnnotationsBuilder_ == null) {
        textAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p2beta1.TextAnnotation,
                com.google.cloud.videointelligence.v1p2beta1.TextAnnotation.Builder,
                com.google.cloud.videointelligence.v1p2beta1.TextAnnotationOrBuilder>(
                textAnnotations_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        textAnnotations_ = null;
      }
      return textAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation>
        objectAnnotations_ = java.util.Collections.emptyList();

    private void ensureObjectAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        objectAnnotations_ =
            new java.util.ArrayList<
                com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation>(
                objectAnnotations_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation,
            com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation.Builder,
            com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotationOrBuilder>
        objectAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation>
        getObjectAnnotationsList() {
      if (objectAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(objectAnnotations_);
      } else {
        return objectAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public int getObjectAnnotationsCount() {
      if (objectAnnotationsBuilder_ == null) {
        return objectAnnotations_.size();
      } else {
        return objectAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation
        getObjectAnnotations(int index) {
      if (objectAnnotationsBuilder_ == null) {
        return objectAnnotations_.get(index);
      } else {
        return objectAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder setObjectAnnotations(
        int index, com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation value) {
      if (objectAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.set(index, value);
        onChanged();
      } else {
        objectAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder setObjectAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation.Builder
            builderForValue) {
      if (objectAnnotationsBuilder_ == null) {
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        objectAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder addObjectAnnotations(
        com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation value) {
      if (objectAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.add(value);
        onChanged();
      } else {
        objectAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder addObjectAnnotations(
        int index, com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation value) {
      if (objectAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.add(index, value);
        onChanged();
      } else {
        objectAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder addObjectAnnotations(
        com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation.Builder
            builderForValue) {
      if (objectAnnotationsBuilder_ == null) {
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        objectAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder addObjectAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation.Builder
            builderForValue) {
      if (objectAnnotationsBuilder_ == null) {
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        objectAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder addAllObjectAnnotations(
        java.lang.Iterable<
                ? extends com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation>
            values) {
      if (objectAnnotationsBuilder_ == null) {
        ensureObjectAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, objectAnnotations_);
        onChanged();
      } else {
        objectAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder clearObjectAnnotations() {
      if (objectAnnotationsBuilder_ == null) {
        objectAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        objectAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder removeObjectAnnotations(int index) {
      if (objectAnnotationsBuilder_ == null) {
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.remove(index);
        onChanged();
      } else {
        objectAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation.Builder
        getObjectAnnotationsBuilder(int index) {
      return getObjectAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotationOrBuilder
        getObjectAnnotationsOrBuilder(int index) {
      if (objectAnnotationsBuilder_ == null) {
        return objectAnnotations_.get(index);
      } else {
        return objectAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotationOrBuilder>
        getObjectAnnotationsOrBuilderList() {
      if (objectAnnotationsBuilder_ != null) {
        return objectAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(objectAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation.Builder
        addObjectAnnotationsBuilder() {
      return getObjectAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation.Builder
        addObjectAnnotationsBuilder(int index) {
      return getObjectAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public java.util.List<
            com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation.Builder>
        getObjectAnnotationsBuilderList() {
      return getObjectAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation,
            com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation.Builder,
            com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotationOrBuilder>
        getObjectAnnotationsFieldBuilder() {
      if (objectAnnotationsBuilder_ == null) {
        objectAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation,
                com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation.Builder,
                com.google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotationOrBuilder>(
                objectAnnotations_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        objectAnnotations_ = null;
      }
      return objectAnnotationsBuilder_;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00000100);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults)
  private static final com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults();
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VideoAnnotationResults> PARSER =
      new com.google.protobuf.AbstractParser<VideoAnnotationResults>() {
        @java.lang.Override
        public VideoAnnotationResults parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VideoAnnotationResults> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VideoAnnotationResults> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
