/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1p2beta1/video_intelligence.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.videointelligence.v1p2beta1;

/**
 *
 *
 * <pre>
 * Video context and/or feature-specific parameters.
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1p2beta1.VideoContext}
 */
public final class VideoContext extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1p2beta1.VideoContext)
    VideoContextOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VideoContext.newBuilder() to construct.
  private VideoContext(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VideoContext() {
    segments_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VideoContext();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1p2beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p2beta1_VideoContext_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1p2beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p2beta1_VideoContext_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1p2beta1.VideoContext.class,
            com.google.cloud.videointelligence.v1p2beta1.VideoContext.Builder.class);
  }

  private int bitField0_;
  public static final int SEGMENTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1p2beta1.VideoSegment> segments_;
  /**
   *
   *
   * <pre>
   * Video segments to annotate. The segments may overlap and are not required
   * to be contiguous or span the whole video. If unspecified, each video is
   * treated as a single segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1p2beta1.VideoSegment>
      getSegmentsList() {
    return segments_;
  }
  /**
   *
   *
   * <pre>
   * Video segments to annotate. The segments may overlap and are not required
   * to be contiguous or span the whole video. If unspecified, each video is
   * treated as a single segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder>
      getSegmentsOrBuilderList() {
    return segments_;
  }
  /**
   *
   *
   * <pre>
   * Video segments to annotate. The segments may overlap and are not required
   * to be contiguous or span the whole video. If unspecified, each video is
   * treated as a single segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
   */
  @java.lang.Override
  public int getSegmentsCount() {
    return segments_.size();
  }
  /**
   *
   *
   * <pre>
   * Video segments to annotate. The segments may overlap and are not required
   * to be contiguous or span the whole video. If unspecified, each video is
   * treated as a single segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.VideoSegment getSegments(int index) {
    return segments_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Video segments to annotate. The segments may overlap and are not required
   * to be contiguous or span the whole video. If unspecified, each video is
   * treated as a single segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder getSegmentsOrBuilder(
      int index) {
    return segments_.get(index);
  }

  public static final int LABEL_DETECTION_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig labelDetectionConfig_;
  /**
   *
   *
   * <pre>
   * Config for LABEL_DETECTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig label_detection_config = 2;
   * </code>
   *
   * @return Whether the labelDetectionConfig field is set.
   */
  @java.lang.Override
  public boolean hasLabelDetectionConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Config for LABEL_DETECTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig label_detection_config = 2;
   * </code>
   *
   * @return The labelDetectionConfig.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig
      getLabelDetectionConfig() {
    return labelDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig.getDefaultInstance()
        : labelDetectionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Config for LABEL_DETECTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig label_detection_config = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfigOrBuilder
      getLabelDetectionConfigOrBuilder() {
    return labelDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig.getDefaultInstance()
        : labelDetectionConfig_;
  }

  public static final int SHOT_CHANGE_DETECTION_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig
      shotChangeDetectionConfig_;
  /**
   *
   *
   * <pre>
   * Config for SHOT_CHANGE_DETECTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig shot_change_detection_config = 3;
   * </code>
   *
   * @return Whether the shotChangeDetectionConfig field is set.
   */
  @java.lang.Override
  public boolean hasShotChangeDetectionConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Config for SHOT_CHANGE_DETECTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig shot_change_detection_config = 3;
   * </code>
   *
   * @return The shotChangeDetectionConfig.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig
      getShotChangeDetectionConfig() {
    return shotChangeDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig
            .getDefaultInstance()
        : shotChangeDetectionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Config for SHOT_CHANGE_DETECTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig shot_change_detection_config = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfigOrBuilder
      getShotChangeDetectionConfigOrBuilder() {
    return shotChangeDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig
            .getDefaultInstance()
        : shotChangeDetectionConfig_;
  }

  public static final int EXPLICIT_CONTENT_DETECTION_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig
      explicitContentDetectionConfig_;
  /**
   *
   *
   * <pre>
   * Config for EXPLICIT_CONTENT_DETECTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
   * </code>
   *
   * @return Whether the explicitContentDetectionConfig field is set.
   */
  @java.lang.Override
  public boolean hasExplicitContentDetectionConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Config for EXPLICIT_CONTENT_DETECTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
   * </code>
   *
   * @return The explicitContentDetectionConfig.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig
      getExplicitContentDetectionConfig() {
    return explicitContentDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig
            .getDefaultInstance()
        : explicitContentDetectionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Config for EXPLICIT_CONTENT_DETECTION.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfigOrBuilder
      getExplicitContentDetectionConfigOrBuilder() {
    return explicitContentDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig
            .getDefaultInstance()
        : explicitContentDetectionConfig_;
  }

  public static final int TEXT_DETECTION_CONFIG_FIELD_NUMBER = 8;
  private com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig textDetectionConfig_;
  /**
   *
   *
   * <pre>
   * Config for TEXT_DETECTION.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig text_detection_config = 8;
   * </code>
   *
   * @return Whether the textDetectionConfig field is set.
   */
  @java.lang.Override
  public boolean hasTextDetectionConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Config for TEXT_DETECTION.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig text_detection_config = 8;
   * </code>
   *
   * @return The textDetectionConfig.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig getTextDetectionConfig() {
    return textDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig.getDefaultInstance()
        : textDetectionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Config for TEXT_DETECTION.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig text_detection_config = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfigOrBuilder
      getTextDetectionConfigOrBuilder() {
    return textDetectionConfig_ == null
        ? com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig.getDefaultInstance()
        : textDetectionConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < segments_.size(); i++) {
      output.writeMessage(1, segments_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getLabelDetectionConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getShotChangeDetectionConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getExplicitContentDetectionConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(8, getTextDetectionConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < segments_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, segments_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLabelDetectionConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, getShotChangeDetectionConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, getExplicitContentDetectionConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getTextDetectionConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.videointelligence.v1p2beta1.VideoContext)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1p2beta1.VideoContext other =
        (com.google.cloud.videointelligence.v1p2beta1.VideoContext) obj;

    if (!getSegmentsList().equals(other.getSegmentsList())) return false;
    if (hasLabelDetectionConfig() != other.hasLabelDetectionConfig()) return false;
    if (hasLabelDetectionConfig()) {
      if (!getLabelDetectionConfig().equals(other.getLabelDetectionConfig())) return false;
    }
    if (hasShotChangeDetectionConfig() != other.hasShotChangeDetectionConfig()) return false;
    if (hasShotChangeDetectionConfig()) {
      if (!getShotChangeDetectionConfig().equals(other.getShotChangeDetectionConfig()))
        return false;
    }
    if (hasExplicitContentDetectionConfig() != other.hasExplicitContentDetectionConfig())
      return false;
    if (hasExplicitContentDetectionConfig()) {
      if (!getExplicitContentDetectionConfig().equals(other.getExplicitContentDetectionConfig()))
        return false;
    }
    if (hasTextDetectionConfig() != other.hasTextDetectionConfig()) return false;
    if (hasTextDetectionConfig()) {
      if (!getTextDetectionConfig().equals(other.getTextDetectionConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getSegmentsCount() > 0) {
      hash = (37 * hash) + SEGMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getSegmentsList().hashCode();
    }
    if (hasLabelDetectionConfig()) {
      hash = (37 * hash) + LABEL_DETECTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLabelDetectionConfig().hashCode();
    }
    if (hasShotChangeDetectionConfig()) {
      hash = (37 * hash) + SHOT_CHANGE_DETECTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getShotChangeDetectionConfig().hashCode();
    }
    if (hasExplicitContentDetectionConfig()) {
      hash = (37 * hash) + EXPLICIT_CONTENT_DETECTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getExplicitContentDetectionConfig().hashCode();
    }
    if (hasTextDetectionConfig()) {
      hash = (37 * hash) + TEXT_DETECTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getTextDetectionConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoContext parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoContext parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoContext parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoContext parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoContext parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoContext parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoContext parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoContext parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoContext parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoContext parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoContext parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoContext parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.videointelligence.v1p2beta1.VideoContext prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Video context and/or feature-specific parameters.
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1p2beta1.VideoContext}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1p2beta1.VideoContext)
      com.google.cloud.videointelligence.v1p2beta1.VideoContextOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1p2beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p2beta1_VideoContext_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1p2beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p2beta1_VideoContext_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1p2beta1.VideoContext.class,
              com.google.cloud.videointelligence.v1p2beta1.VideoContext.Builder.class);
    }

    // Construct using com.google.cloud.videointelligence.v1p2beta1.VideoContext.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSegmentsFieldBuilder();
        getLabelDetectionConfigFieldBuilder();
        getShotChangeDetectionConfigFieldBuilder();
        getExplicitContentDetectionConfigFieldBuilder();
        getTextDetectionConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (segmentsBuilder_ == null) {
        segments_ = java.util.Collections.emptyList();
      } else {
        segments_ = null;
        segmentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      labelDetectionConfig_ = null;
      if (labelDetectionConfigBuilder_ != null) {
        labelDetectionConfigBuilder_.dispose();
        labelDetectionConfigBuilder_ = null;
      }
      shotChangeDetectionConfig_ = null;
      if (shotChangeDetectionConfigBuilder_ != null) {
        shotChangeDetectionConfigBuilder_.dispose();
        shotChangeDetectionConfigBuilder_ = null;
      }
      explicitContentDetectionConfig_ = null;
      if (explicitContentDetectionConfigBuilder_ != null) {
        explicitContentDetectionConfigBuilder_.dispose();
        explicitContentDetectionConfigBuilder_ = null;
      }
      textDetectionConfig_ = null;
      if (textDetectionConfigBuilder_ != null) {
        textDetectionConfigBuilder_.dispose();
        textDetectionConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1p2beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p2beta1_VideoContext_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p2beta1.VideoContext getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1p2beta1.VideoContext.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p2beta1.VideoContext build() {
      com.google.cloud.videointelligence.v1p2beta1.VideoContext result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p2beta1.VideoContext buildPartial() {
      com.google.cloud.videointelligence.v1p2beta1.VideoContext result =
          new com.google.cloud.videointelligence.v1p2beta1.VideoContext(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.videointelligence.v1p2beta1.VideoContext result) {
      if (segmentsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          segments_ = java.util.Collections.unmodifiableList(segments_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.segments_ = segments_;
      } else {
        result.segments_ = segmentsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.videointelligence.v1p2beta1.VideoContext result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.labelDetectionConfig_ =
            labelDetectionConfigBuilder_ == null
                ? labelDetectionConfig_
                : labelDetectionConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.shotChangeDetectionConfig_ =
            shotChangeDetectionConfigBuilder_ == null
                ? shotChangeDetectionConfig_
                : shotChangeDetectionConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.explicitContentDetectionConfig_ =
            explicitContentDetectionConfigBuilder_ == null
                ? explicitContentDetectionConfig_
                : explicitContentDetectionConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.textDetectionConfig_ =
            textDetectionConfigBuilder_ == null
                ? textDetectionConfig_
                : textDetectionConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.videointelligence.v1p2beta1.VideoContext) {
        return mergeFrom((com.google.cloud.videointelligence.v1p2beta1.VideoContext) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.videointelligence.v1p2beta1.VideoContext other) {
      if (other == com.google.cloud.videointelligence.v1p2beta1.VideoContext.getDefaultInstance())
        return this;
      if (segmentsBuilder_ == null) {
        if (!other.segments_.isEmpty()) {
          if (segments_.isEmpty()) {
            segments_ = other.segments_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSegmentsIsMutable();
            segments_.addAll(other.segments_);
          }
          onChanged();
        }
      } else {
        if (!other.segments_.isEmpty()) {
          if (segmentsBuilder_.isEmpty()) {
            segmentsBuilder_.dispose();
            segmentsBuilder_ = null;
            segments_ = other.segments_;
            bitField0_ = (bitField0_ & ~0x00000001);
            segmentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSegmentsFieldBuilder()
                    : null;
          } else {
            segmentsBuilder_.addAllMessages(other.segments_);
          }
        }
      }
      if (other.hasLabelDetectionConfig()) {
        mergeLabelDetectionConfig(other.getLabelDetectionConfig());
      }
      if (other.hasShotChangeDetectionConfig()) {
        mergeShotChangeDetectionConfig(other.getShotChangeDetectionConfig());
      }
      if (other.hasExplicitContentDetectionConfig()) {
        mergeExplicitContentDetectionConfig(other.getExplicitContentDetectionConfig());
      }
      if (other.hasTextDetectionConfig()) {
        mergeTextDetectionConfig(other.getTextDetectionConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.videointelligence.v1p2beta1.VideoSegment m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1p2beta1.VideoSegment.parser(),
                        extensionRegistry);
                if (segmentsBuilder_ == null) {
                  ensureSegmentsIsMutable();
                  segments_.add(m);
                } else {
                  segmentsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getLabelDetectionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getShotChangeDetectionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getExplicitContentDetectionConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 66:
              {
                input.readMessage(
                    getTextDetectionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.videointelligence.v1p2beta1.VideoSegment> segments_ =
        java.util.Collections.emptyList();

    private void ensureSegmentsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        segments_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1p2beta1.VideoSegment>(
                segments_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.VideoSegment,
            com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder>
        segmentsBuilder_;

    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p2beta1.VideoSegment>
        getSegmentsList() {
      if (segmentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(segments_);
      } else {
        return segmentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public int getSegmentsCount() {
      if (segmentsBuilder_ == null) {
        return segments_.size();
      } else {
        return segmentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.VideoSegment getSegments(int index) {
      if (segmentsBuilder_ == null) {
        return segments_.get(index);
      } else {
        return segmentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public Builder setSegments(
        int index, com.google.cloud.videointelligence.v1p2beta1.VideoSegment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.set(index, value);
        onChanged();
      } else {
        segmentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public Builder setSegments(
        int index,
        com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.set(index, builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public Builder addSegments(com.google.cloud.videointelligence.v1p2beta1.VideoSegment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.add(value);
        onChanged();
      } else {
        segmentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public Builder addSegments(
        int index, com.google.cloud.videointelligence.v1p2beta1.VideoSegment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.add(index, value);
        onChanged();
      } else {
        segmentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public Builder addSegments(
        com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.add(builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public Builder addSegments(
        int index,
        com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.add(index, builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public Builder addAllSegments(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1p2beta1.VideoSegment>
            values) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, segments_);
        onChanged();
      } else {
        segmentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public Builder clearSegments() {
      if (segmentsBuilder_ == null) {
        segments_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        segmentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public Builder removeSegments(int index) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.remove(index);
        onChanged();
      } else {
        segmentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder getSegmentsBuilder(
        int index) {
      return getSegmentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder getSegmentsOrBuilder(
        int index) {
      if (segmentsBuilder_ == null) {
        return segments_.get(index);
      } else {
        return segmentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder>
        getSegmentsOrBuilderList() {
      if (segmentsBuilder_ != null) {
        return segmentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(segments_);
      }
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder addSegmentsBuilder() {
      return getSegmentsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1p2beta1.VideoSegment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder addSegmentsBuilder(
        int index) {
      return getSegmentsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1p2beta1.VideoSegment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Video segments to annotate. The segments may overlap and are not required
     * to be contiguous or span the whole video. If unspecified, each video is
     * treated as a single segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.VideoSegment segments = 1;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder>
        getSegmentsBuilderList() {
      return getSegmentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.VideoSegment,
            com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder>
        getSegmentsFieldBuilder() {
      if (segmentsBuilder_ == null) {
        segmentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p2beta1.VideoSegment,
                com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder,
                com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder>(
                segments_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        segments_ = null;
      }
      return segmentsBuilder_;
    }

    private com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig labelDetectionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig,
            com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfigOrBuilder>
        labelDetectionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     *
     * @return Whether the labelDetectionConfig field is set.
     */
    public boolean hasLabelDetectionConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     *
     * @return The labelDetectionConfig.
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig
        getLabelDetectionConfig() {
      if (labelDetectionConfigBuilder_ == null) {
        return labelDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig.getDefaultInstance()
            : labelDetectionConfig_;
      } else {
        return labelDetectionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     */
    public Builder setLabelDetectionConfig(
        com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig value) {
      if (labelDetectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        labelDetectionConfig_ = value;
      } else {
        labelDetectionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     */
    public Builder setLabelDetectionConfig(
        com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig.Builder builderForValue) {
      if (labelDetectionConfigBuilder_ == null) {
        labelDetectionConfig_ = builderForValue.build();
      } else {
        labelDetectionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     */
    public Builder mergeLabelDetectionConfig(
        com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig value) {
      if (labelDetectionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && labelDetectionConfig_ != null
            && labelDetectionConfig_
                != com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig
                    .getDefaultInstance()) {
          getLabelDetectionConfigBuilder().mergeFrom(value);
        } else {
          labelDetectionConfig_ = value;
        }
      } else {
        labelDetectionConfigBuilder_.mergeFrom(value);
      }
      if (labelDetectionConfig_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     */
    public Builder clearLabelDetectionConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      labelDetectionConfig_ = null;
      if (labelDetectionConfigBuilder_ != null) {
        labelDetectionConfigBuilder_.dispose();
        labelDetectionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig.Builder
        getLabelDetectionConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getLabelDetectionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfigOrBuilder
        getLabelDetectionConfigOrBuilder() {
      if (labelDetectionConfigBuilder_ != null) {
        return labelDetectionConfigBuilder_.getMessageOrBuilder();
      } else {
        return labelDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig.getDefaultInstance()
            : labelDetectionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Config for LABEL_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig label_detection_config = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig,
            com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfigOrBuilder>
        getLabelDetectionConfigFieldBuilder() {
      if (labelDetectionConfigBuilder_ == null) {
        labelDetectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig,
                com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig.Builder,
                com.google.cloud.videointelligence.v1p2beta1.LabelDetectionConfigOrBuilder>(
                getLabelDetectionConfig(), getParentForChildren(), isClean());
        labelDetectionConfig_ = null;
      }
      return labelDetectionConfigBuilder_;
    }

    private com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig
        shotChangeDetectionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig,
            com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfigOrBuilder>
        shotChangeDetectionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     *
     * @return Whether the shotChangeDetectionConfig field is set.
     */
    public boolean hasShotChangeDetectionConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     *
     * @return The shotChangeDetectionConfig.
     */
    public com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig
        getShotChangeDetectionConfig() {
      if (shotChangeDetectionConfigBuilder_ == null) {
        return shotChangeDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig
                .getDefaultInstance()
            : shotChangeDetectionConfig_;
      } else {
        return shotChangeDetectionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     */
    public Builder setShotChangeDetectionConfig(
        com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig value) {
      if (shotChangeDetectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        shotChangeDetectionConfig_ = value;
      } else {
        shotChangeDetectionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     */
    public Builder setShotChangeDetectionConfig(
        com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig.Builder
            builderForValue) {
      if (shotChangeDetectionConfigBuilder_ == null) {
        shotChangeDetectionConfig_ = builderForValue.build();
      } else {
        shotChangeDetectionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     */
    public Builder mergeShotChangeDetectionConfig(
        com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig value) {
      if (shotChangeDetectionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && shotChangeDetectionConfig_ != null
            && shotChangeDetectionConfig_
                != com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig
                    .getDefaultInstance()) {
          getShotChangeDetectionConfigBuilder().mergeFrom(value);
        } else {
          shotChangeDetectionConfig_ = value;
        }
      } else {
        shotChangeDetectionConfigBuilder_.mergeFrom(value);
      }
      if (shotChangeDetectionConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     */
    public Builder clearShotChangeDetectionConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      shotChangeDetectionConfig_ = null;
      if (shotChangeDetectionConfigBuilder_ != null) {
        shotChangeDetectionConfigBuilder_.dispose();
        shotChangeDetectionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig.Builder
        getShotChangeDetectionConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getShotChangeDetectionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfigOrBuilder
        getShotChangeDetectionConfigOrBuilder() {
      if (shotChangeDetectionConfigBuilder_ != null) {
        return shotChangeDetectionConfigBuilder_.getMessageOrBuilder();
      } else {
        return shotChangeDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig
                .getDefaultInstance()
            : shotChangeDetectionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Config for SHOT_CHANGE_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig shot_change_detection_config = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig,
            com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfigOrBuilder>
        getShotChangeDetectionConfigFieldBuilder() {
      if (shotChangeDetectionConfigBuilder_ == null) {
        shotChangeDetectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig,
                com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig.Builder,
                com.google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfigOrBuilder>(
                getShotChangeDetectionConfig(), getParentForChildren(), isClean());
        shotChangeDetectionConfig_ = null;
      }
      return shotChangeDetectionConfigBuilder_;
    }

    private com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig
        explicitContentDetectionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig,
            com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfigOrBuilder>
        explicitContentDetectionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     *
     * @return Whether the explicitContentDetectionConfig field is set.
     */
    public boolean hasExplicitContentDetectionConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     *
     * @return The explicitContentDetectionConfig.
     */
    public com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig
        getExplicitContentDetectionConfig() {
      if (explicitContentDetectionConfigBuilder_ == null) {
        return explicitContentDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig
                .getDefaultInstance()
            : explicitContentDetectionConfig_;
      } else {
        return explicitContentDetectionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     */
    public Builder setExplicitContentDetectionConfig(
        com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig value) {
      if (explicitContentDetectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explicitContentDetectionConfig_ = value;
      } else {
        explicitContentDetectionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     */
    public Builder setExplicitContentDetectionConfig(
        com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig.Builder
            builderForValue) {
      if (explicitContentDetectionConfigBuilder_ == null) {
        explicitContentDetectionConfig_ = builderForValue.build();
      } else {
        explicitContentDetectionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     */
    public Builder mergeExplicitContentDetectionConfig(
        com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig value) {
      if (explicitContentDetectionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && explicitContentDetectionConfig_ != null
            && explicitContentDetectionConfig_
                != com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig
                    .getDefaultInstance()) {
          getExplicitContentDetectionConfigBuilder().mergeFrom(value);
        } else {
          explicitContentDetectionConfig_ = value;
        }
      } else {
        explicitContentDetectionConfigBuilder_.mergeFrom(value);
      }
      if (explicitContentDetectionConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     */
    public Builder clearExplicitContentDetectionConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      explicitContentDetectionConfig_ = null;
      if (explicitContentDetectionConfigBuilder_ != null) {
        explicitContentDetectionConfigBuilder_.dispose();
        explicitContentDetectionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig.Builder
        getExplicitContentDetectionConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getExplicitContentDetectionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfigOrBuilder
        getExplicitContentDetectionConfigOrBuilder() {
      if (explicitContentDetectionConfigBuilder_ != null) {
        return explicitContentDetectionConfigBuilder_.getMessageOrBuilder();
      } else {
        return explicitContentDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig
                .getDefaultInstance()
            : explicitContentDetectionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Config for EXPLICIT_CONTENT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig explicit_content_detection_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig,
            com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfigOrBuilder>
        getExplicitContentDetectionConfigFieldBuilder() {
      if (explicitContentDetectionConfigBuilder_ == null) {
        explicitContentDetectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig,
                com.google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig.Builder,
                com.google.cloud.videointelligence.v1p2beta1
                    .ExplicitContentDetectionConfigOrBuilder>(
                getExplicitContentDetectionConfig(), getParentForChildren(), isClean());
        explicitContentDetectionConfig_ = null;
      }
      return explicitContentDetectionConfigBuilder_;
    }

    private com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig textDetectionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig,
            com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfigOrBuilder>
        textDetectionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.TextDetectionConfig text_detection_config = 8;
     * </code>
     *
     * @return Whether the textDetectionConfig field is set.
     */
    public boolean hasTextDetectionConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.TextDetectionConfig text_detection_config = 8;
     * </code>
     *
     * @return The textDetectionConfig.
     */
    public com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig
        getTextDetectionConfig() {
      if (textDetectionConfigBuilder_ == null) {
        return textDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig.getDefaultInstance()
            : textDetectionConfig_;
      } else {
        return textDetectionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.TextDetectionConfig text_detection_config = 8;
     * </code>
     */
    public Builder setTextDetectionConfig(
        com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig value) {
      if (textDetectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        textDetectionConfig_ = value;
      } else {
        textDetectionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.TextDetectionConfig text_detection_config = 8;
     * </code>
     */
    public Builder setTextDetectionConfig(
        com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig.Builder builderForValue) {
      if (textDetectionConfigBuilder_ == null) {
        textDetectionConfig_ = builderForValue.build();
      } else {
        textDetectionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.TextDetectionConfig text_detection_config = 8;
     * </code>
     */
    public Builder mergeTextDetectionConfig(
        com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig value) {
      if (textDetectionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && textDetectionConfig_ != null
            && textDetectionConfig_
                != com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig
                    .getDefaultInstance()) {
          getTextDetectionConfigBuilder().mergeFrom(value);
        } else {
          textDetectionConfig_ = value;
        }
      } else {
        textDetectionConfigBuilder_.mergeFrom(value);
      }
      if (textDetectionConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.TextDetectionConfig text_detection_config = 8;
     * </code>
     */
    public Builder clearTextDetectionConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      textDetectionConfig_ = null;
      if (textDetectionConfigBuilder_ != null) {
        textDetectionConfigBuilder_.dispose();
        textDetectionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.TextDetectionConfig text_detection_config = 8;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig.Builder
        getTextDetectionConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getTextDetectionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.TextDetectionConfig text_detection_config = 8;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfigOrBuilder
        getTextDetectionConfigOrBuilder() {
      if (textDetectionConfigBuilder_ != null) {
        return textDetectionConfigBuilder_.getMessageOrBuilder();
      } else {
        return textDetectionConfig_ == null
            ? com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig.getDefaultInstance()
            : textDetectionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Config for TEXT_DETECTION.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p2beta1.TextDetectionConfig text_detection_config = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig,
            com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig.Builder,
            com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfigOrBuilder>
        getTextDetectionConfigFieldBuilder() {
      if (textDetectionConfigBuilder_ == null) {
        textDetectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig,
                com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfig.Builder,
                com.google.cloud.videointelligence.v1p2beta1.TextDetectionConfigOrBuilder>(
                getTextDetectionConfig(), getParentForChildren(), isClean());
        textDetectionConfig_ = null;
      }
      return textDetectionConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1p2beta1.VideoContext)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1p2beta1.VideoContext)
  private static final com.google.cloud.videointelligence.v1p2beta1.VideoContext DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.videointelligence.v1p2beta1.VideoContext();
  }

  public static com.google.cloud.videointelligence.v1p2beta1.VideoContext getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VideoContext> PARSER =
      new com.google.protobuf.AbstractParser<VideoContext>() {
        @java.lang.Override
        public VideoContext parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VideoContext> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VideoContext> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.VideoContext getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
