/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1p2beta1/video_intelligence.proto

package com.google.cloud.videointelligence.v1p2beta1;

/**
 *
 *
 * <pre>
 * Video segment level annotation results for text detection.
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1p2beta1.TextSegment}
 */
public final class TextSegment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1p2beta1.TextSegment)
    TextSegmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TextSegment.newBuilder() to construct.
  private TextSegment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TextSegment() {
    frames_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TextSegment();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private TextSegment(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder subBuilder = null;
              if (segment_ != null) {
                subBuilder = segment_.toBuilder();
              }
              segment_ =
                  input.readMessage(
                      com.google.cloud.videointelligence.v1p2beta1.VideoSegment.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(segment_);
                segment_ = subBuilder.buildPartial();
              }

              break;
            }
          case 21:
            {
              confidence_ = input.readFloat();
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                frames_ =
                    new java.util.ArrayList<
                        com.google.cloud.videointelligence.v1p2beta1.TextFrame>();
                mutable_bitField0_ |= 0x00000001;
              }
              frames_.add(
                  input.readMessage(
                      com.google.cloud.videointelligence.v1p2beta1.TextFrame.parser(),
                      extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        frames_ = java.util.Collections.unmodifiableList(frames_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1p2beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p2beta1_TextSegment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1p2beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p2beta1_TextSegment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1p2beta1.TextSegment.class,
            com.google.cloud.videointelligence.v1p2beta1.TextSegment.Builder.class);
  }

  public static final int SEGMENT_FIELD_NUMBER = 1;
  private com.google.cloud.videointelligence.v1p2beta1.VideoSegment segment_;
  /**
   *
   *
   * <pre>
   * Video segment where a text snippet was detected.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p2beta1.VideoSegment segment = 1;</code>
   *
   * @return Whether the segment field is set.
   */
  @java.lang.Override
  public boolean hasSegment() {
    return segment_ != null;
  }
  /**
   *
   *
   * <pre>
   * Video segment where a text snippet was detected.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p2beta1.VideoSegment segment = 1;</code>
   *
   * @return The segment.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.VideoSegment getSegment() {
    return segment_ == null
        ? com.google.cloud.videointelligence.v1p2beta1.VideoSegment.getDefaultInstance()
        : segment_;
  }
  /**
   *
   *
   * <pre>
   * Video segment where a text snippet was detected.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p2beta1.VideoSegment segment = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder getSegmentOrBuilder() {
    return getSegment();
  }

  public static final int CONFIDENCE_FIELD_NUMBER = 2;
  private float confidence_;
  /**
   *
   *
   * <pre>
   * Confidence for the track of detected text. It is calculated as the highest
   * over all frames where OCR detected text appears.
   * </pre>
   *
   * <code>float confidence = 2;</code>
   *
   * @return The confidence.
   */
  @java.lang.Override
  public float getConfidence() {
    return confidence_;
  }

  public static final int FRAMES_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.videointelligence.v1p2beta1.TextFrame> frames_;
  /**
   *
   *
   * <pre>
   * Information related to the frames where OCR detected text appears.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1p2beta1.TextFrame> getFramesList() {
    return frames_;
  }
  /**
   *
   *
   * <pre>
   * Information related to the frames where OCR detected text appears.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1p2beta1.TextFrameOrBuilder>
      getFramesOrBuilderList() {
    return frames_;
  }
  /**
   *
   *
   * <pre>
   * Information related to the frames where OCR detected text appears.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
   */
  @java.lang.Override
  public int getFramesCount() {
    return frames_.size();
  }
  /**
   *
   *
   * <pre>
   * Information related to the frames where OCR detected text appears.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.TextFrame getFrames(int index) {
    return frames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Information related to the frames where OCR detected text appears.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.TextFrameOrBuilder getFramesOrBuilder(
      int index) {
    return frames_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (segment_ != null) {
      output.writeMessage(1, getSegment());
    }
    if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
      output.writeFloat(2, confidence_);
    }
    for (int i = 0; i < frames_.size(); i++) {
      output.writeMessage(3, frames_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (segment_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSegment());
    }
    if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, confidence_);
    }
    for (int i = 0; i < frames_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, frames_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.videointelligence.v1p2beta1.TextSegment)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1p2beta1.TextSegment other =
        (com.google.cloud.videointelligence.v1p2beta1.TextSegment) obj;

    if (hasSegment() != other.hasSegment()) return false;
    if (hasSegment()) {
      if (!getSegment().equals(other.getSegment())) return false;
    }
    if (java.lang.Float.floatToIntBits(getConfidence())
        != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
    if (!getFramesList().equals(other.getFramesList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasSegment()) {
      hash = (37 * hash) + SEGMENT_FIELD_NUMBER;
      hash = (53 * hash) + getSegment().hashCode();
    }
    hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
    if (getFramesCount() > 0) {
      hash = (37 * hash) + FRAMES_FIELD_NUMBER;
      hash = (53 * hash) + getFramesList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1p2beta1.TextSegment parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.TextSegment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.TextSegment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.TextSegment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.TextSegment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.TextSegment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.TextSegment parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.TextSegment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.TextSegment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.TextSegment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.TextSegment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p2beta1.TextSegment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.videointelligence.v1p2beta1.TextSegment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Video segment level annotation results for text detection.
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1p2beta1.TextSegment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1p2beta1.TextSegment)
      com.google.cloud.videointelligence.v1p2beta1.TextSegmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1p2beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p2beta1_TextSegment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1p2beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p2beta1_TextSegment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1p2beta1.TextSegment.class,
              com.google.cloud.videointelligence.v1p2beta1.TextSegment.Builder.class);
    }

    // Construct using com.google.cloud.videointelligence.v1p2beta1.TextSegment.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFramesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (segmentBuilder_ == null) {
        segment_ = null;
      } else {
        segment_ = null;
        segmentBuilder_ = null;
      }
      confidence_ = 0F;

      if (framesBuilder_ == null) {
        frames_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        framesBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1p2beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p2beta1_TextSegment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p2beta1.TextSegment getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1p2beta1.TextSegment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p2beta1.TextSegment build() {
      com.google.cloud.videointelligence.v1p2beta1.TextSegment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p2beta1.TextSegment buildPartial() {
      com.google.cloud.videointelligence.v1p2beta1.TextSegment result =
          new com.google.cloud.videointelligence.v1p2beta1.TextSegment(this);
      int from_bitField0_ = bitField0_;
      if (segmentBuilder_ == null) {
        result.segment_ = segment_;
      } else {
        result.segment_ = segmentBuilder_.build();
      }
      result.confidence_ = confidence_;
      if (framesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          frames_ = java.util.Collections.unmodifiableList(frames_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.frames_ = frames_;
      } else {
        result.frames_ = framesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.videointelligence.v1p2beta1.TextSegment) {
        return mergeFrom((com.google.cloud.videointelligence.v1p2beta1.TextSegment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.videointelligence.v1p2beta1.TextSegment other) {
      if (other == com.google.cloud.videointelligence.v1p2beta1.TextSegment.getDefaultInstance())
        return this;
      if (other.hasSegment()) {
        mergeSegment(other.getSegment());
      }
      if (other.getConfidence() != 0F) {
        setConfidence(other.getConfidence());
      }
      if (framesBuilder_ == null) {
        if (!other.frames_.isEmpty()) {
          if (frames_.isEmpty()) {
            frames_ = other.frames_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFramesIsMutable();
            frames_.addAll(other.frames_);
          }
          onChanged();
        }
      } else {
        if (!other.frames_.isEmpty()) {
          if (framesBuilder_.isEmpty()) {
            framesBuilder_.dispose();
            framesBuilder_ = null;
            frames_ = other.frames_;
            bitField0_ = (bitField0_ & ~0x00000001);
            framesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFramesFieldBuilder()
                    : null;
          } else {
            framesBuilder_.addAllMessages(other.frames_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.videointelligence.v1p2beta1.TextSegment parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.videointelligence.v1p2beta1.TextSegment) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.cloud.videointelligence.v1p2beta1.VideoSegment segment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.VideoSegment,
            com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder>
        segmentBuilder_;
    /**
     *
     *
     * <pre>
     * Video segment where a text snippet was detected.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p2beta1.VideoSegment segment = 1;</code>
     *
     * @return Whether the segment field is set.
     */
    public boolean hasSegment() {
      return segmentBuilder_ != null || segment_ != null;
    }
    /**
     *
     *
     * <pre>
     * Video segment where a text snippet was detected.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p2beta1.VideoSegment segment = 1;</code>
     *
     * @return The segment.
     */
    public com.google.cloud.videointelligence.v1p2beta1.VideoSegment getSegment() {
      if (segmentBuilder_ == null) {
        return segment_ == null
            ? com.google.cloud.videointelligence.v1p2beta1.VideoSegment.getDefaultInstance()
            : segment_;
      } else {
        return segmentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Video segment where a text snippet was detected.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p2beta1.VideoSegment segment = 1;</code>
     */
    public Builder setSegment(com.google.cloud.videointelligence.v1p2beta1.VideoSegment value) {
      if (segmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        segment_ = value;
        onChanged();
      } else {
        segmentBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segment where a text snippet was detected.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p2beta1.VideoSegment segment = 1;</code>
     */
    public Builder setSegment(
        com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder builderForValue) {
      if (segmentBuilder_ == null) {
        segment_ = builderForValue.build();
        onChanged();
      } else {
        segmentBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segment where a text snippet was detected.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p2beta1.VideoSegment segment = 1;</code>
     */
    public Builder mergeSegment(com.google.cloud.videointelligence.v1p2beta1.VideoSegment value) {
      if (segmentBuilder_ == null) {
        if (segment_ != null) {
          segment_ =
              com.google.cloud.videointelligence.v1p2beta1.VideoSegment.newBuilder(segment_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          segment_ = value;
        }
        onChanged();
      } else {
        segmentBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segment where a text snippet was detected.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p2beta1.VideoSegment segment = 1;</code>
     */
    public Builder clearSegment() {
      if (segmentBuilder_ == null) {
        segment_ = null;
        onChanged();
      } else {
        segment_ = null;
        segmentBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segment where a text snippet was detected.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p2beta1.VideoSegment segment = 1;</code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder getSegmentBuilder() {

      onChanged();
      return getSegmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Video segment where a text snippet was detected.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p2beta1.VideoSegment segment = 1;</code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder
        getSegmentOrBuilder() {
      if (segmentBuilder_ != null) {
        return segmentBuilder_.getMessageOrBuilder();
      } else {
        return segment_ == null
            ? com.google.cloud.videointelligence.v1p2beta1.VideoSegment.getDefaultInstance()
            : segment_;
      }
    }
    /**
     *
     *
     * <pre>
     * Video segment where a text snippet was detected.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p2beta1.VideoSegment segment = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.VideoSegment,
            com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder>
        getSegmentFieldBuilder() {
      if (segmentBuilder_ == null) {
        segmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1p2beta1.VideoSegment,
                com.google.cloud.videointelligence.v1p2beta1.VideoSegment.Builder,
                com.google.cloud.videointelligence.v1p2beta1.VideoSegmentOrBuilder>(
                getSegment(), getParentForChildren(), isClean());
        segment_ = null;
      }
      return segmentBuilder_;
    }

    private float confidence_;
    /**
     *
     *
     * <pre>
     * Confidence for the track of detected text. It is calculated as the highest
     * over all frames where OCR detected text appears.
     * </pre>
     *
     * <code>float confidence = 2;</code>
     *
     * @return The confidence.
     */
    @java.lang.Override
    public float getConfidence() {
      return confidence_;
    }
    /**
     *
     *
     * <pre>
     * Confidence for the track of detected text. It is calculated as the highest
     * over all frames where OCR detected text appears.
     * </pre>
     *
     * <code>float confidence = 2;</code>
     *
     * @param value The confidence to set.
     * @return This builder for chaining.
     */
    public Builder setConfidence(float value) {

      confidence_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Confidence for the track of detected text. It is calculated as the highest
     * over all frames where OCR detected text appears.
     * </pre>
     *
     * <code>float confidence = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfidence() {

      confidence_ = 0F;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.videointelligence.v1p2beta1.TextFrame> frames_ =
        java.util.Collections.emptyList();

    private void ensureFramesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        frames_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1p2beta1.TextFrame>(
                frames_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.TextFrame,
            com.google.cloud.videointelligence.v1p2beta1.TextFrame.Builder,
            com.google.cloud.videointelligence.v1p2beta1.TextFrameOrBuilder>
        framesBuilder_;

    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p2beta1.TextFrame> getFramesList() {
      if (framesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(frames_);
      } else {
        return framesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public int getFramesCount() {
      if (framesBuilder_ == null) {
        return frames_.size();
      } else {
        return framesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.TextFrame getFrames(int index) {
      if (framesBuilder_ == null) {
        return frames_.get(index);
      } else {
        return framesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public Builder setFrames(
        int index, com.google.cloud.videointelligence.v1p2beta1.TextFrame value) {
      if (framesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFramesIsMutable();
        frames_.set(index, value);
        onChanged();
      } else {
        framesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public Builder setFrames(
        int index, com.google.cloud.videointelligence.v1p2beta1.TextFrame.Builder builderForValue) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.set(index, builderForValue.build());
        onChanged();
      } else {
        framesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public Builder addFrames(com.google.cloud.videointelligence.v1p2beta1.TextFrame value) {
      if (framesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFramesIsMutable();
        frames_.add(value);
        onChanged();
      } else {
        framesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public Builder addFrames(
        int index, com.google.cloud.videointelligence.v1p2beta1.TextFrame value) {
      if (framesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFramesIsMutable();
        frames_.add(index, value);
        onChanged();
      } else {
        framesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public Builder addFrames(
        com.google.cloud.videointelligence.v1p2beta1.TextFrame.Builder builderForValue) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.add(builderForValue.build());
        onChanged();
      } else {
        framesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public Builder addFrames(
        int index, com.google.cloud.videointelligence.v1p2beta1.TextFrame.Builder builderForValue) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.add(index, builderForValue.build());
        onChanged();
      } else {
        framesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public Builder addAllFrames(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1p2beta1.TextFrame>
            values) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, frames_);
        onChanged();
      } else {
        framesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public Builder clearFrames() {
      if (framesBuilder_ == null) {
        frames_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        framesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public Builder removeFrames(int index) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.remove(index);
        onChanged();
      } else {
        framesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.TextFrame.Builder getFramesBuilder(
        int index) {
      return getFramesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.TextFrameOrBuilder getFramesOrBuilder(
        int index) {
      if (framesBuilder_ == null) {
        return frames_.get(index);
      } else {
        return framesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.videointelligence.v1p2beta1.TextFrameOrBuilder>
        getFramesOrBuilderList() {
      if (framesBuilder_ != null) {
        return framesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(frames_);
      }
    }
    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.TextFrame.Builder addFramesBuilder() {
      return getFramesFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1p2beta1.TextFrame.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public com.google.cloud.videointelligence.v1p2beta1.TextFrame.Builder addFramesBuilder(
        int index) {
      return getFramesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1p2beta1.TextFrame.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Information related to the frames where OCR detected text appears.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p2beta1.TextFrame frames = 3;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p2beta1.TextFrame.Builder>
        getFramesBuilderList() {
      return getFramesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p2beta1.TextFrame,
            com.google.cloud.videointelligence.v1p2beta1.TextFrame.Builder,
            com.google.cloud.videointelligence.v1p2beta1.TextFrameOrBuilder>
        getFramesFieldBuilder() {
      if (framesBuilder_ == null) {
        framesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p2beta1.TextFrame,
                com.google.cloud.videointelligence.v1p2beta1.TextFrame.Builder,
                com.google.cloud.videointelligence.v1p2beta1.TextFrameOrBuilder>(
                frames_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        frames_ = null;
      }
      return framesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1p2beta1.TextSegment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1p2beta1.TextSegment)
  private static final com.google.cloud.videointelligence.v1p2beta1.TextSegment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.videointelligence.v1p2beta1.TextSegment();
  }

  public static com.google.cloud.videointelligence.v1p2beta1.TextSegment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TextSegment> PARSER =
      new com.google.protobuf.AbstractParser<TextSegment>() {
        @java.lang.Override
        public TextSegment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new TextSegment(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<TextSegment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TextSegment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1p2beta1.TextSegment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
