/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1p3beta1/video_intelligence.proto

package com.google.cloud.videointelligence.v1p3beta1;

/**
 *
 *
 * <pre>
 * Config for SPEECH_TRANSCRIPTION.
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig}
 */
public final class SpeechTranscriptionConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig)
    SpeechTranscriptionConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SpeechTranscriptionConfig.newBuilder() to construct.
  private SpeechTranscriptionConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SpeechTranscriptionConfig() {
    languageCode_ = "";
    speechContexts_ = java.util.Collections.emptyList();
    audioTracks_ = emptyIntList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SpeechTranscriptionConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p3beta1_SpeechTranscriptionConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p3beta1_SpeechTranscriptionConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig.class,
            com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig.Builder.class);
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * Required. *Required* The language of the supplied audio as a
   * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
   * Example: "en-US".
   * See [Language Support](https://cloud.google.com/speech/docs/languages)
   * for a list of the currently supported language codes.
   * </pre>
   *
   * <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. *Required* The language of the supplied audio as a
   * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
   * Example: "en-US".
   * See [Language Support](https://cloud.google.com/speech/docs/languages)
   * for a list of the currently supported language codes.
   * </pre>
   *
   * <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_ALTERNATIVES_FIELD_NUMBER = 2;
  private int maxAlternatives_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Maximum number of recognition hypotheses to be returned.
   * Specifically, the maximum number of `SpeechRecognitionAlternative` messages
   * within each `SpeechTranscription`. The server may return fewer than
   * `max_alternatives`. Valid values are `0`-`30`. A value of `0` or `1` will
   * return a maximum of one. If omitted, will return a maximum of one.
   * </pre>
   *
   * <code>int32 max_alternatives = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maxAlternatives.
   */
  @java.lang.Override
  public int getMaxAlternatives() {
    return maxAlternatives_;
  }

  public static final int FILTER_PROFANITY_FIELD_NUMBER = 3;
  private boolean filterProfanity_ = false;
  /**
   *
   *
   * <pre>
   * Optional. If set to `true`, the server will attempt to filter out
   * profanities, replacing all but the initial character in each filtered word
   * with asterisks, e.g. "f***". If set to `false` or omitted, profanities
   * won't be filtered out.
   * </pre>
   *
   * <code>bool filter_profanity = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filterProfanity.
   */
  @java.lang.Override
  public boolean getFilterProfanity() {
    return filterProfanity_;
  }

  public static final int SPEECH_CONTEXTS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1p3beta1.SpeechContext>
      speechContexts_;
  /**
   *
   *
   * <pre>
   * Optional. A means to provide context to assist the speech recognition.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1p3beta1.SpeechContext>
      getSpeechContextsList() {
    return speechContexts_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A means to provide context to assist the speech recognition.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1p3beta1.SpeechContextOrBuilder>
      getSpeechContextsOrBuilderList() {
    return speechContexts_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A means to provide context to assist the speech recognition.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getSpeechContextsCount() {
    return speechContexts_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A means to provide context to assist the speech recognition.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.SpeechContext getSpeechContexts(int index) {
    return speechContexts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A means to provide context to assist the speech recognition.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.SpeechContextOrBuilder
      getSpeechContextsOrBuilder(int index) {
    return speechContexts_.get(index);
  }

  public static final int ENABLE_AUTOMATIC_PUNCTUATION_FIELD_NUMBER = 5;
  private boolean enableAutomaticPunctuation_ = false;
  /**
   *
   *
   * <pre>
   * Optional. If 'true', adds punctuation to recognition result hypotheses.
   * This feature is only available in select languages. Setting this for
   * requests in other languages has no effect at all. The default 'false' value
   * does not add punctuation to result hypotheses. NOTE: "This is currently
   * offered as an experimental service, complimentary to all users. In the
   * future this may be exclusively available as a premium feature."
   * </pre>
   *
   * <code>bool enable_automatic_punctuation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableAutomaticPunctuation.
   */
  @java.lang.Override
  public boolean getEnableAutomaticPunctuation() {
    return enableAutomaticPunctuation_;
  }

  public static final int AUDIO_TRACKS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList audioTracks_;
  /**
   *
   *
   * <pre>
   * Optional. For file formats, such as MXF or MKV, supporting multiple audio
   * tracks, specify up to two tracks. Default: track 0.
   * </pre>
   *
   * <code>repeated int32 audio_tracks = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the audioTracks.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getAudioTracksList() {
    return audioTracks_;
  }
  /**
   *
   *
   * <pre>
   * Optional. For file formats, such as MXF or MKV, supporting multiple audio
   * tracks, specify up to two tracks. Default: track 0.
   * </pre>
   *
   * <code>repeated int32 audio_tracks = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of audioTracks.
   */
  public int getAudioTracksCount() {
    return audioTracks_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. For file formats, such as MXF or MKV, supporting multiple audio
   * tracks, specify up to two tracks. Default: track 0.
   * </pre>
   *
   * <code>repeated int32 audio_tracks = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The audioTracks at the given index.
   */
  public int getAudioTracks(int index) {
    return audioTracks_.getInt(index);
  }

  private int audioTracksMemoizedSerializedSize = -1;

  public static final int ENABLE_SPEAKER_DIARIZATION_FIELD_NUMBER = 7;
  private boolean enableSpeakerDiarization_ = false;
  /**
   *
   *
   * <pre>
   * Optional. If 'true', enables speaker detection for each recognized word in
   * the top alternative of the recognition result using a speaker_tag provided
   * in the WordInfo.
   * Note: When this is true, we send all the words from the beginning of the
   * audio for the top alternative in every consecutive response.
   * This is done in order to improve our speaker tags as our models learn to
   * identify the speakers in the conversation over time.
   * </pre>
   *
   * <code>bool enable_speaker_diarization = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableSpeakerDiarization.
   */
  @java.lang.Override
  public boolean getEnableSpeakerDiarization() {
    return enableSpeakerDiarization_;
  }

  public static final int DIARIZATION_SPEAKER_COUNT_FIELD_NUMBER = 8;
  private int diarizationSpeakerCount_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. If set, specifies the estimated number of speakers in the
   * conversation. If not set, defaults to '2'. Ignored unless
   * enable_speaker_diarization is set to true.
   * </pre>
   *
   * <code>int32 diarization_speaker_count = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The diarizationSpeakerCount.
   */
  @java.lang.Override
  public int getDiarizationSpeakerCount() {
    return diarizationSpeakerCount_;
  }

  public static final int ENABLE_WORD_CONFIDENCE_FIELD_NUMBER = 9;
  private boolean enableWordConfidence_ = false;
  /**
   *
   *
   * <pre>
   * Optional. If `true`, the top result includes a list of words and the
   * confidence for those words. If `false`, no word-level confidence
   * information is returned. The default is `false`.
   * </pre>
   *
   * <code>bool enable_word_confidence = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableWordConfidence.
   */
  @java.lang.Override
  public boolean getEnableWordConfidence() {
    return enableWordConfidence_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, languageCode_);
    }
    if (maxAlternatives_ != 0) {
      output.writeInt32(2, maxAlternatives_);
    }
    if (filterProfanity_ != false) {
      output.writeBool(3, filterProfanity_);
    }
    for (int i = 0; i < speechContexts_.size(); i++) {
      output.writeMessage(4, speechContexts_.get(i));
    }
    if (enableAutomaticPunctuation_ != false) {
      output.writeBool(5, enableAutomaticPunctuation_);
    }
    if (getAudioTracksList().size() > 0) {
      output.writeUInt32NoTag(50);
      output.writeUInt32NoTag(audioTracksMemoizedSerializedSize);
    }
    for (int i = 0; i < audioTracks_.size(); i++) {
      output.writeInt32NoTag(audioTracks_.getInt(i));
    }
    if (enableSpeakerDiarization_ != false) {
      output.writeBool(7, enableSpeakerDiarization_);
    }
    if (diarizationSpeakerCount_ != 0) {
      output.writeInt32(8, diarizationSpeakerCount_);
    }
    if (enableWordConfidence_ != false) {
      output.writeBool(9, enableWordConfidence_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, languageCode_);
    }
    if (maxAlternatives_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxAlternatives_);
    }
    if (filterProfanity_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, filterProfanity_);
    }
    for (int i = 0; i < speechContexts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, speechContexts_.get(i));
    }
    if (enableAutomaticPunctuation_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, enableAutomaticPunctuation_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < audioTracks_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(audioTracks_.getInt(i));
      }
      size += dataSize;
      if (!getAudioTracksList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      audioTracksMemoizedSerializedSize = dataSize;
    }
    if (enableSpeakerDiarization_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, enableSpeakerDiarization_);
    }
    if (diarizationSpeakerCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, diarizationSpeakerCount_);
    }
    if (enableWordConfidence_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, enableWordConfidence_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig other =
        (com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig) obj;

    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (getMaxAlternatives() != other.getMaxAlternatives()) return false;
    if (getFilterProfanity() != other.getFilterProfanity()) return false;
    if (!getSpeechContextsList().equals(other.getSpeechContextsList())) return false;
    if (getEnableAutomaticPunctuation() != other.getEnableAutomaticPunctuation()) return false;
    if (!getAudioTracksList().equals(other.getAudioTracksList())) return false;
    if (getEnableSpeakerDiarization() != other.getEnableSpeakerDiarization()) return false;
    if (getDiarizationSpeakerCount() != other.getDiarizationSpeakerCount()) return false;
    if (getEnableWordConfidence() != other.getEnableWordConfidence()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + MAX_ALTERNATIVES_FIELD_NUMBER;
    hash = (53 * hash) + getMaxAlternatives();
    hash = (37 * hash) + FILTER_PROFANITY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getFilterProfanity());
    if (getSpeechContextsCount() > 0) {
      hash = (37 * hash) + SPEECH_CONTEXTS_FIELD_NUMBER;
      hash = (53 * hash) + getSpeechContextsList().hashCode();
    }
    hash = (37 * hash) + ENABLE_AUTOMATIC_PUNCTUATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableAutomaticPunctuation());
    if (getAudioTracksCount() > 0) {
      hash = (37 * hash) + AUDIO_TRACKS_FIELD_NUMBER;
      hash = (53 * hash) + getAudioTracksList().hashCode();
    }
    hash = (37 * hash) + ENABLE_SPEAKER_DIARIZATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableSpeakerDiarization());
    hash = (37 * hash) + DIARIZATION_SPEAKER_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getDiarizationSpeakerCount();
    hash = (37 * hash) + ENABLE_WORD_CONFIDENCE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableWordConfidence());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Config for SPEECH_TRANSCRIPTION.
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig)
      com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_SpeechTranscriptionConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_SpeechTranscriptionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig.class,
              com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig.Builder.class);
    }

    // Construct using
    // com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      languageCode_ = "";
      maxAlternatives_ = 0;
      filterProfanity_ = false;
      if (speechContextsBuilder_ == null) {
        speechContexts_ = java.util.Collections.emptyList();
      } else {
        speechContexts_ = null;
        speechContextsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      enableAutomaticPunctuation_ = false;
      audioTracks_ = emptyIntList();
      enableSpeakerDiarization_ = false;
      diarizationSpeakerCount_ = 0;
      enableWordConfidence_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_SpeechTranscriptionConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig
        getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig build() {
      com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig buildPartial() {
      com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig result =
          new com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig result) {
      if (speechContextsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          speechContexts_ = java.util.Collections.unmodifiableList(speechContexts_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.speechContexts_ = speechContexts_;
      } else {
        result.speechContexts_ = speechContextsBuilder_.build();
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        audioTracks_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000020);
      }
      result.audioTracks_ = audioTracks_;
    }

    private void buildPartial0(
        com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.languageCode_ = languageCode_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.maxAlternatives_ = maxAlternatives_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.filterProfanity_ = filterProfanity_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.enableAutomaticPunctuation_ = enableAutomaticPunctuation_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.enableSpeakerDiarization_ = enableSpeakerDiarization_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.diarizationSpeakerCount_ = diarizationSpeakerCount_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.enableWordConfidence_ = enableWordConfidence_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig) {
        return mergeFrom(
            (com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig other) {
      if (other
          == com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig
              .getDefaultInstance()) return this;
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getMaxAlternatives() != 0) {
        setMaxAlternatives(other.getMaxAlternatives());
      }
      if (other.getFilterProfanity() != false) {
        setFilterProfanity(other.getFilterProfanity());
      }
      if (speechContextsBuilder_ == null) {
        if (!other.speechContexts_.isEmpty()) {
          if (speechContexts_.isEmpty()) {
            speechContexts_ = other.speechContexts_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureSpeechContextsIsMutable();
            speechContexts_.addAll(other.speechContexts_);
          }
          onChanged();
        }
      } else {
        if (!other.speechContexts_.isEmpty()) {
          if (speechContextsBuilder_.isEmpty()) {
            speechContextsBuilder_.dispose();
            speechContextsBuilder_ = null;
            speechContexts_ = other.speechContexts_;
            bitField0_ = (bitField0_ & ~0x00000008);
            speechContextsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSpeechContextsFieldBuilder()
                    : null;
          } else {
            speechContextsBuilder_.addAllMessages(other.speechContexts_);
          }
        }
      }
      if (other.getEnableAutomaticPunctuation() != false) {
        setEnableAutomaticPunctuation(other.getEnableAutomaticPunctuation());
      }
      if (!other.audioTracks_.isEmpty()) {
        if (audioTracks_.isEmpty()) {
          audioTracks_ = other.audioTracks_;
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          ensureAudioTracksIsMutable();
          audioTracks_.addAll(other.audioTracks_);
        }
        onChanged();
      }
      if (other.getEnableSpeakerDiarization() != false) {
        setEnableSpeakerDiarization(other.getEnableSpeakerDiarization());
      }
      if (other.getDiarizationSpeakerCount() != 0) {
        setDiarizationSpeakerCount(other.getDiarizationSpeakerCount());
      }
      if (other.getEnableWordConfidence() != false) {
        setEnableWordConfidence(other.getEnableWordConfidence());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                maxAlternatives_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                filterProfanity_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.cloud.videointelligence.v1p3beta1.SpeechContext m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1p3beta1.SpeechContext.parser(),
                        extensionRegistry);
                if (speechContextsBuilder_ == null) {
                  ensureSpeechContextsIsMutable();
                  speechContexts_.add(m);
                } else {
                  speechContextsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 40:
              {
                enableAutomaticPunctuation_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                int v = input.readInt32();
                ensureAudioTracksIsMutable();
                audioTracks_.addInt(v);
                break;
              } // case 48
            case 50:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureAudioTracksIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  audioTracks_.addInt(input.readInt32());
                }
                input.popLimit(limit);
                break;
              } // case 50
            case 56:
              {
                enableSpeakerDiarization_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                diarizationSpeakerCount_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 72:
              {
                enableWordConfidence_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Required. *Required* The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     * Example: "en-US".
     * See [Language Support](https://cloud.google.com/speech/docs/languages)
     * for a list of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. *Required* The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     * Example: "en-US".
     * See [Language Support](https://cloud.google.com/speech/docs/languages)
     * for a list of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. *Required* The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     * Example: "en-US".
     * See [Language Support](https://cloud.google.com/speech/docs/languages)
     * for a list of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. *Required* The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     * Example: "en-US".
     * See [Language Support](https://cloud.google.com/speech/docs/languages)
     * for a list of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. *Required* The language of the supplied audio as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
     * Example: "en-US".
     * See [Language Support](https://cloud.google.com/speech/docs/languages)
     * for a list of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int maxAlternatives_;
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of recognition hypotheses to be returned.
     * Specifically, the maximum number of `SpeechRecognitionAlternative` messages
     * within each `SpeechTranscription`. The server may return fewer than
     * `max_alternatives`. Valid values are `0`-`30`. A value of `0` or `1` will
     * return a maximum of one. If omitted, will return a maximum of one.
     * </pre>
     *
     * <code>int32 max_alternatives = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxAlternatives.
     */
    @java.lang.Override
    public int getMaxAlternatives() {
      return maxAlternatives_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of recognition hypotheses to be returned.
     * Specifically, the maximum number of `SpeechRecognitionAlternative` messages
     * within each `SpeechTranscription`. The server may return fewer than
     * `max_alternatives`. Valid values are `0`-`30`. A value of `0` or `1` will
     * return a maximum of one. If omitted, will return a maximum of one.
     * </pre>
     *
     * <code>int32 max_alternatives = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The maxAlternatives to set.
     * @return This builder for chaining.
     */
    public Builder setMaxAlternatives(int value) {

      maxAlternatives_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of recognition hypotheses to be returned.
     * Specifically, the maximum number of `SpeechRecognitionAlternative` messages
     * within each `SpeechTranscription`. The server may return fewer than
     * `max_alternatives`. Valid values are `0`-`30`. A value of `0` or `1` will
     * return a maximum of one. If omitted, will return a maximum of one.
     * </pre>
     *
     * <code>int32 max_alternatives = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxAlternatives() {
      bitField0_ = (bitField0_ & ~0x00000002);
      maxAlternatives_ = 0;
      onChanged();
      return this;
    }

    private boolean filterProfanity_;
    /**
     *
     *
     * <pre>
     * Optional. If set to `true`, the server will attempt to filter out
     * profanities, replacing all but the initial character in each filtered word
     * with asterisks, e.g. "f***". If set to `false` or omitted, profanities
     * won't be filtered out.
     * </pre>
     *
     * <code>bool filter_profanity = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The filterProfanity.
     */
    @java.lang.Override
    public boolean getFilterProfanity() {
      return filterProfanity_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set to `true`, the server will attempt to filter out
     * profanities, replacing all but the initial character in each filtered word
     * with asterisks, e.g. "f***". If set to `false` or omitted, profanities
     * won't be filtered out.
     * </pre>
     *
     * <code>bool filter_profanity = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The filterProfanity to set.
     * @return This builder for chaining.
     */
    public Builder setFilterProfanity(boolean value) {

      filterProfanity_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set to `true`, the server will attempt to filter out
     * profanities, replacing all but the initial character in each filtered word
     * with asterisks, e.g. "f***". If set to `false` or omitted, profanities
     * won't be filtered out.
     * </pre>
     *
     * <code>bool filter_profanity = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilterProfanity() {
      bitField0_ = (bitField0_ & ~0x00000004);
      filterProfanity_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.videointelligence.v1p3beta1.SpeechContext>
        speechContexts_ = java.util.Collections.emptyList();

    private void ensureSpeechContextsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        speechContexts_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1p3beta1.SpeechContext>(
                speechContexts_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.SpeechContext,
            com.google.cloud.videointelligence.v1p3beta1.SpeechContext.Builder,
            com.google.cloud.videointelligence.v1p3beta1.SpeechContextOrBuilder>
        speechContextsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.SpeechContext>
        getSpeechContextsList() {
      if (speechContextsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(speechContexts_);
      } else {
        return speechContextsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getSpeechContextsCount() {
      if (speechContextsBuilder_ == null) {
        return speechContexts_.size();
      } else {
        return speechContextsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.SpeechContext getSpeechContexts(int index) {
      if (speechContextsBuilder_ == null) {
        return speechContexts_.get(index);
      } else {
        return speechContextsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpeechContexts(
        int index, com.google.cloud.videointelligence.v1p3beta1.SpeechContext value) {
      if (speechContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechContextsIsMutable();
        speechContexts_.set(index, value);
        onChanged();
      } else {
        speechContextsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpeechContexts(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.SpeechContext.Builder builderForValue) {
      if (speechContextsBuilder_ == null) {
        ensureSpeechContextsIsMutable();
        speechContexts_.set(index, builderForValue.build());
        onChanged();
      } else {
        speechContextsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSpeechContexts(
        com.google.cloud.videointelligence.v1p3beta1.SpeechContext value) {
      if (speechContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechContextsIsMutable();
        speechContexts_.add(value);
        onChanged();
      } else {
        speechContextsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSpeechContexts(
        int index, com.google.cloud.videointelligence.v1p3beta1.SpeechContext value) {
      if (speechContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechContextsIsMutable();
        speechContexts_.add(index, value);
        onChanged();
      } else {
        speechContextsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSpeechContexts(
        com.google.cloud.videointelligence.v1p3beta1.SpeechContext.Builder builderForValue) {
      if (speechContextsBuilder_ == null) {
        ensureSpeechContextsIsMutable();
        speechContexts_.add(builderForValue.build());
        onChanged();
      } else {
        speechContextsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSpeechContexts(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.SpeechContext.Builder builderForValue) {
      if (speechContextsBuilder_ == null) {
        ensureSpeechContextsIsMutable();
        speechContexts_.add(index, builderForValue.build());
        onChanged();
      } else {
        speechContextsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllSpeechContexts(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1p3beta1.SpeechContext>
            values) {
      if (speechContextsBuilder_ == null) {
        ensureSpeechContextsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, speechContexts_);
        onChanged();
      } else {
        speechContextsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSpeechContexts() {
      if (speechContextsBuilder_ == null) {
        speechContexts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        speechContextsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeSpeechContexts(int index) {
      if (speechContextsBuilder_ == null) {
        ensureSpeechContextsIsMutable();
        speechContexts_.remove(index);
        onChanged();
      } else {
        speechContextsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.SpeechContext.Builder
        getSpeechContextsBuilder(int index) {
      return getSpeechContextsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.SpeechContextOrBuilder
        getSpeechContextsOrBuilder(int index) {
      if (speechContextsBuilder_ == null) {
        return speechContexts_.get(index);
      } else {
        return speechContextsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1p3beta1.SpeechContextOrBuilder>
        getSpeechContextsOrBuilderList() {
      if (speechContextsBuilder_ != null) {
        return speechContextsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(speechContexts_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.SpeechContext.Builder
        addSpeechContextsBuilder() {
      return getSpeechContextsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1p3beta1.SpeechContext.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.SpeechContext.Builder
        addSpeechContextsBuilder(int index) {
      return getSpeechContextsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1p3beta1.SpeechContext.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. A means to provide context to assist the speech recognition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.SpeechContext speech_contexts = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.SpeechContext.Builder>
        getSpeechContextsBuilderList() {
      return getSpeechContextsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.SpeechContext,
            com.google.cloud.videointelligence.v1p3beta1.SpeechContext.Builder,
            com.google.cloud.videointelligence.v1p3beta1.SpeechContextOrBuilder>
        getSpeechContextsFieldBuilder() {
      if (speechContextsBuilder_ == null) {
        speechContextsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p3beta1.SpeechContext,
                com.google.cloud.videointelligence.v1p3beta1.SpeechContext.Builder,
                com.google.cloud.videointelligence.v1p3beta1.SpeechContextOrBuilder>(
                speechContexts_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        speechContexts_ = null;
      }
      return speechContextsBuilder_;
    }

    private boolean enableAutomaticPunctuation_;
    /**
     *
     *
     * <pre>
     * Optional. If 'true', adds punctuation to recognition result hypotheses.
     * This feature is only available in select languages. Setting this for
     * requests in other languages has no effect at all. The default 'false' value
     * does not add punctuation to result hypotheses. NOTE: "This is currently
     * offered as an experimental service, complimentary to all users. In the
     * future this may be exclusively available as a premium feature."
     * </pre>
     *
     * <code>bool enable_automatic_punctuation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableAutomaticPunctuation.
     */
    @java.lang.Override
    public boolean getEnableAutomaticPunctuation() {
      return enableAutomaticPunctuation_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If 'true', adds punctuation to recognition result hypotheses.
     * This feature is only available in select languages. Setting this for
     * requests in other languages has no effect at all. The default 'false' value
     * does not add punctuation to result hypotheses. NOTE: "This is currently
     * offered as an experimental service, complimentary to all users. In the
     * future this may be exclusively available as a premium feature."
     * </pre>
     *
     * <code>bool enable_automatic_punctuation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableAutomaticPunctuation to set.
     * @return This builder for chaining.
     */
    public Builder setEnableAutomaticPunctuation(boolean value) {

      enableAutomaticPunctuation_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If 'true', adds punctuation to recognition result hypotheses.
     * This feature is only available in select languages. Setting this for
     * requests in other languages has no effect at all. The default 'false' value
     * does not add punctuation to result hypotheses. NOTE: "This is currently
     * offered as an experimental service, complimentary to all users. In the
     * future this may be exclusively available as a premium feature."
     * </pre>
     *
     * <code>bool enable_automatic_punctuation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableAutomaticPunctuation() {
      bitField0_ = (bitField0_ & ~0x00000010);
      enableAutomaticPunctuation_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.IntList audioTracks_ = emptyIntList();

    private void ensureAudioTracksIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        audioTracks_ = mutableCopy(audioTracks_);
        bitField0_ |= 0x00000020;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. For file formats, such as MXF or MKV, supporting multiple audio
     * tracks, specify up to two tracks. Default: track 0.
     * </pre>
     *
     * <code>repeated int32 audio_tracks = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the audioTracks.
     */
    public java.util.List<java.lang.Integer> getAudioTracksList() {
      return ((bitField0_ & 0x00000020) != 0)
          ? java.util.Collections.unmodifiableList(audioTracks_)
          : audioTracks_;
    }
    /**
     *
     *
     * <pre>
     * Optional. For file formats, such as MXF or MKV, supporting multiple audio
     * tracks, specify up to two tracks. Default: track 0.
     * </pre>
     *
     * <code>repeated int32 audio_tracks = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of audioTracks.
     */
    public int getAudioTracksCount() {
      return audioTracks_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. For file formats, such as MXF or MKV, supporting multiple audio
     * tracks, specify up to two tracks. Default: track 0.
     * </pre>
     *
     * <code>repeated int32 audio_tracks = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The audioTracks at the given index.
     */
    public int getAudioTracks(int index) {
      return audioTracks_.getInt(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. For file formats, such as MXF or MKV, supporting multiple audio
     * tracks, specify up to two tracks. Default: track 0.
     * </pre>
     *
     * <code>repeated int32 audio_tracks = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The audioTracks to set.
     * @return This builder for chaining.
     */
    public Builder setAudioTracks(int index, int value) {

      ensureAudioTracksIsMutable();
      audioTracks_.setInt(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. For file formats, such as MXF or MKV, supporting multiple audio
     * tracks, specify up to two tracks. Default: track 0.
     * </pre>
     *
     * <code>repeated int32 audio_tracks = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The audioTracks to add.
     * @return This builder for chaining.
     */
    public Builder addAudioTracks(int value) {

      ensureAudioTracksIsMutable();
      audioTracks_.addInt(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. For file formats, such as MXF or MKV, supporting multiple audio
     * tracks, specify up to two tracks. Default: track 0.
     * </pre>
     *
     * <code>repeated int32 audio_tracks = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The audioTracks to add.
     * @return This builder for chaining.
     */
    public Builder addAllAudioTracks(java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureAudioTracksIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, audioTracks_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. For file formats, such as MXF or MKV, supporting multiple audio
     * tracks, specify up to two tracks. Default: track 0.
     * </pre>
     *
     * <code>repeated int32 audio_tracks = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAudioTracks() {
      audioTracks_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    private boolean enableSpeakerDiarization_;
    /**
     *
     *
     * <pre>
     * Optional. If 'true', enables speaker detection for each recognized word in
     * the top alternative of the recognition result using a speaker_tag provided
     * in the WordInfo.
     * Note: When this is true, we send all the words from the beginning of the
     * audio for the top alternative in every consecutive response.
     * This is done in order to improve our speaker tags as our models learn to
     * identify the speakers in the conversation over time.
     * </pre>
     *
     * <code>bool enable_speaker_diarization = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableSpeakerDiarization.
     */
    @java.lang.Override
    public boolean getEnableSpeakerDiarization() {
      return enableSpeakerDiarization_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If 'true', enables speaker detection for each recognized word in
     * the top alternative of the recognition result using a speaker_tag provided
     * in the WordInfo.
     * Note: When this is true, we send all the words from the beginning of the
     * audio for the top alternative in every consecutive response.
     * This is done in order to improve our speaker tags as our models learn to
     * identify the speakers in the conversation over time.
     * </pre>
     *
     * <code>bool enable_speaker_diarization = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableSpeakerDiarization to set.
     * @return This builder for chaining.
     */
    public Builder setEnableSpeakerDiarization(boolean value) {

      enableSpeakerDiarization_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If 'true', enables speaker detection for each recognized word in
     * the top alternative of the recognition result using a speaker_tag provided
     * in the WordInfo.
     * Note: When this is true, we send all the words from the beginning of the
     * audio for the top alternative in every consecutive response.
     * This is done in order to improve our speaker tags as our models learn to
     * identify the speakers in the conversation over time.
     * </pre>
     *
     * <code>bool enable_speaker_diarization = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableSpeakerDiarization() {
      bitField0_ = (bitField0_ & ~0x00000040);
      enableSpeakerDiarization_ = false;
      onChanged();
      return this;
    }

    private int diarizationSpeakerCount_;
    /**
     *
     *
     * <pre>
     * Optional. If set, specifies the estimated number of speakers in the
     * conversation. If not set, defaults to '2'. Ignored unless
     * enable_speaker_diarization is set to true.
     * </pre>
     *
     * <code>int32 diarization_speaker_count = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The diarizationSpeakerCount.
     */
    @java.lang.Override
    public int getDiarizationSpeakerCount() {
      return diarizationSpeakerCount_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, specifies the estimated number of speakers in the
     * conversation. If not set, defaults to '2'. Ignored unless
     * enable_speaker_diarization is set to true.
     * </pre>
     *
     * <code>int32 diarization_speaker_count = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The diarizationSpeakerCount to set.
     * @return This builder for chaining.
     */
    public Builder setDiarizationSpeakerCount(int value) {

      diarizationSpeakerCount_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, specifies the estimated number of speakers in the
     * conversation. If not set, defaults to '2'. Ignored unless
     * enable_speaker_diarization is set to true.
     * </pre>
     *
     * <code>int32 diarization_speaker_count = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiarizationSpeakerCount() {
      bitField0_ = (bitField0_ & ~0x00000080);
      diarizationSpeakerCount_ = 0;
      onChanged();
      return this;
    }

    private boolean enableWordConfidence_;
    /**
     *
     *
     * <pre>
     * Optional. If `true`, the top result includes a list of words and the
     * confidence for those words. If `false`, no word-level confidence
     * information is returned. The default is `false`.
     * </pre>
     *
     * <code>bool enable_word_confidence = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableWordConfidence.
     */
    @java.lang.Override
    public boolean getEnableWordConfidence() {
      return enableWordConfidence_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If `true`, the top result includes a list of words and the
     * confidence for those words. If `false`, no word-level confidence
     * information is returned. The default is `false`.
     * </pre>
     *
     * <code>bool enable_word_confidence = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableWordConfidence to set.
     * @return This builder for chaining.
     */
    public Builder setEnableWordConfidence(boolean value) {

      enableWordConfidence_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If `true`, the top result includes a list of words and the
     * confidence for those words. If `false`, no word-level confidence
     * information is returned. The default is `false`.
     * </pre>
     *
     * <code>bool enable_word_confidence = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableWordConfidence() {
      bitField0_ = (bitField0_ & ~0x00000100);
      enableWordConfidence_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig)
  private static final com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig();
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SpeechTranscriptionConfig> PARSER =
      new com.google.protobuf.AbstractParser<SpeechTranscriptionConfig>() {
        @java.lang.Override
        public SpeechTranscriptionConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SpeechTranscriptionConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SpeechTranscriptionConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.SpeechTranscriptionConfig
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
