/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1p3beta1/video_intelligence.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.videointelligence.v1p3beta1;

/**
 *
 *
 * <pre>
 * Annotations corresponding to one tracked object.
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation}
 */
public final class ObjectTrackingAnnotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation)
    ObjectTrackingAnnotationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ObjectTrackingAnnotation.newBuilder() to construct.
  private ObjectTrackingAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ObjectTrackingAnnotation() {
    frames_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ObjectTrackingAnnotation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p3beta1_ObjectTrackingAnnotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p3beta1_ObjectTrackingAnnotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation.class,
            com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation.Builder.class);
  }

  private int bitField0_;
  private int trackInfoCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object trackInfo_;

  public enum TrackInfoCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SEGMENT(3),
    TRACK_ID(5),
    TRACKINFO_NOT_SET(0);
    private final int value;

    private TrackInfoCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TrackInfoCase valueOf(int value) {
      return forNumber(value);
    }

    public static TrackInfoCase forNumber(int value) {
      switch (value) {
        case 3:
          return SEGMENT;
        case 5:
          return TRACK_ID;
        case 0:
          return TRACKINFO_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TrackInfoCase getTrackInfoCase() {
    return TrackInfoCase.forNumber(trackInfoCase_);
  }

  public static final int SEGMENT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Non-streaming batch mode ONLY.
   * Each object track corresponds to one video segment where it appears.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p3beta1.VideoSegment segment = 3;</code>
   *
   * @return Whether the segment field is set.
   */
  @java.lang.Override
  public boolean hasSegment() {
    return trackInfoCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Non-streaming batch mode ONLY.
   * Each object track corresponds to one video segment where it appears.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p3beta1.VideoSegment segment = 3;</code>
   *
   * @return The segment.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.VideoSegment getSegment() {
    if (trackInfoCase_ == 3) {
      return (com.google.cloud.videointelligence.v1p3beta1.VideoSegment) trackInfo_;
    }
    return com.google.cloud.videointelligence.v1p3beta1.VideoSegment.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Non-streaming batch mode ONLY.
   * Each object track corresponds to one video segment where it appears.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p3beta1.VideoSegment segment = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.VideoSegmentOrBuilder getSegmentOrBuilder() {
    if (trackInfoCase_ == 3) {
      return (com.google.cloud.videointelligence.v1p3beta1.VideoSegment) trackInfo_;
    }
    return com.google.cloud.videointelligence.v1p3beta1.VideoSegment.getDefaultInstance();
  }

  public static final int TRACK_ID_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Streaming mode ONLY.
   * In streaming mode, we do not know the end time of a tracked object
   * before it is completed. Hence, there is no VideoSegment info returned.
   * Instead, we provide a unique identifiable integer track_id so that
   * the customers can correlate the results of the ongoing
   * ObjectTrackAnnotation of the same track_id over time.
   * </pre>
   *
   * <code>int64 track_id = 5;</code>
   *
   * @return Whether the trackId field is set.
   */
  @java.lang.Override
  public boolean hasTrackId() {
    return trackInfoCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Streaming mode ONLY.
   * In streaming mode, we do not know the end time of a tracked object
   * before it is completed. Hence, there is no VideoSegment info returned.
   * Instead, we provide a unique identifiable integer track_id so that
   * the customers can correlate the results of the ongoing
   * ObjectTrackAnnotation of the same track_id over time.
   * </pre>
   *
   * <code>int64 track_id = 5;</code>
   *
   * @return The trackId.
   */
  @java.lang.Override
  public long getTrackId() {
    if (trackInfoCase_ == 5) {
      return (java.lang.Long) trackInfo_;
    }
    return 0L;
  }

  public static final int ENTITY_FIELD_NUMBER = 1;
  private com.google.cloud.videointelligence.v1p3beta1.Entity entity_;
  /**
   *
   *
   * <pre>
   * Entity to specify the object category that this track is labeled as.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
   *
   * @return Whether the entity field is set.
   */
  @java.lang.Override
  public boolean hasEntity() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Entity to specify the object category that this track is labeled as.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
   *
   * @return The entity.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.Entity getEntity() {
    return entity_ == null
        ? com.google.cloud.videointelligence.v1p3beta1.Entity.getDefaultInstance()
        : entity_;
  }
  /**
   *
   *
   * <pre>
   * Entity to specify the object category that this track is labeled as.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.EntityOrBuilder getEntityOrBuilder() {
    return entity_ == null
        ? com.google.cloud.videointelligence.v1p3beta1.Entity.getDefaultInstance()
        : entity_;
  }

  public static final int CONFIDENCE_FIELD_NUMBER = 4;
  private float confidence_ = 0F;
  /**
   *
   *
   * <pre>
   * Object category's labeling confidence of this track.
   * </pre>
   *
   * <code>float confidence = 4;</code>
   *
   * @return The confidence.
   */
  @java.lang.Override
  public float getConfidence() {
    return confidence_;
  }

  public static final int FRAMES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame> frames_;
  /**
   *
   *
   * <pre>
   * Information corresponding to all frames where this object track appears.
   * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
   * messages in frames.
   * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame>
      getFramesList() {
    return frames_;
  }
  /**
   *
   *
   * <pre>
   * Information corresponding to all frames where this object track appears.
   * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
   * messages in frames.
   * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrameOrBuilder>
      getFramesOrBuilderList() {
    return frames_;
  }
  /**
   *
   *
   * <pre>
   * Information corresponding to all frames where this object track appears.
   * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
   * messages in frames.
   * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;</code>
   */
  @java.lang.Override
  public int getFramesCount() {
    return frames_.size();
  }
  /**
   *
   *
   * <pre>
   * Information corresponding to all frames where this object track appears.
   * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
   * messages in frames.
   * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame getFrames(int index) {
    return frames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Information corresponding to all frames where this object track appears.
   * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
   * messages in frames.
   * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrameOrBuilder
      getFramesOrBuilder(int index) {
    return frames_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getEntity());
    }
    for (int i = 0; i < frames_.size(); i++) {
      output.writeMessage(2, frames_.get(i));
    }
    if (trackInfoCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.videointelligence.v1p3beta1.VideoSegment) trackInfo_);
    }
    if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
      output.writeFloat(4, confidence_);
    }
    if (trackInfoCase_ == 5) {
      output.writeInt64(5, (long) ((java.lang.Long) trackInfo_));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEntity());
    }
    for (int i = 0; i < frames_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, frames_.get(i));
    }
    if (trackInfoCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.videointelligence.v1p3beta1.VideoSegment) trackInfo_);
    }
    if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, confidence_);
    }
    if (trackInfoCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              5, (long) ((java.lang.Long) trackInfo_));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation other =
        (com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation) obj;

    if (hasEntity() != other.hasEntity()) return false;
    if (hasEntity()) {
      if (!getEntity().equals(other.getEntity())) return false;
    }
    if (java.lang.Float.floatToIntBits(getConfidence())
        != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
    if (!getFramesList().equals(other.getFramesList())) return false;
    if (!getTrackInfoCase().equals(other.getTrackInfoCase())) return false;
    switch (trackInfoCase_) {
      case 3:
        if (!getSegment().equals(other.getSegment())) return false;
        break;
      case 5:
        if (getTrackId() != other.getTrackId()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasEntity()) {
      hash = (37 * hash) + ENTITY_FIELD_NUMBER;
      hash = (53 * hash) + getEntity().hashCode();
    }
    hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
    if (getFramesCount() > 0) {
      hash = (37 * hash) + FRAMES_FIELD_NUMBER;
      hash = (53 * hash) + getFramesList().hashCode();
    }
    switch (trackInfoCase_) {
      case 3:
        hash = (37 * hash) + SEGMENT_FIELD_NUMBER;
        hash = (53 * hash) + getSegment().hashCode();
        break;
      case 5:
        hash = (37 * hash) + TRACK_ID_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTrackId());
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Annotations corresponding to one tracked object.
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation)
      com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_ObjectTrackingAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_ObjectTrackingAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation.class,
              com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation.Builder.class);
    }

    // Construct using
    // com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEntityFieldBuilder();
        getFramesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (segmentBuilder_ != null) {
        segmentBuilder_.clear();
      }
      entity_ = null;
      if (entityBuilder_ != null) {
        entityBuilder_.dispose();
        entityBuilder_ = null;
      }
      confidence_ = 0F;
      if (framesBuilder_ == null) {
        frames_ = java.util.Collections.emptyList();
      } else {
        frames_ = null;
        framesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      trackInfoCase_ = 0;
      trackInfo_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_ObjectTrackingAnnotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation
        getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation build() {
      com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation buildPartial() {
      com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation result =
          new com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation result) {
      if (framesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          frames_ = java.util.Collections.unmodifiableList(frames_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.frames_ = frames_;
      } else {
        result.frames_ = framesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.entity_ = entityBuilder_ == null ? entity_ : entityBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.confidence_ = confidence_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation result) {
      result.trackInfoCase_ = trackInfoCase_;
      result.trackInfo_ = this.trackInfo_;
      if (trackInfoCase_ == 3 && segmentBuilder_ != null) {
        result.trackInfo_ = segmentBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation) {
        return mergeFrom(
            (com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation other) {
      if (other
          == com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation
              .getDefaultInstance()) return this;
      if (other.hasEntity()) {
        mergeEntity(other.getEntity());
      }
      if (other.getConfidence() != 0F) {
        setConfidence(other.getConfidence());
      }
      if (framesBuilder_ == null) {
        if (!other.frames_.isEmpty()) {
          if (frames_.isEmpty()) {
            frames_ = other.frames_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureFramesIsMutable();
            frames_.addAll(other.frames_);
          }
          onChanged();
        }
      } else {
        if (!other.frames_.isEmpty()) {
          if (framesBuilder_.isEmpty()) {
            framesBuilder_.dispose();
            framesBuilder_ = null;
            frames_ = other.frames_;
            bitField0_ = (bitField0_ & ~0x00000010);
            framesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFramesFieldBuilder()
                    : null;
          } else {
            framesBuilder_.addAllMessages(other.frames_);
          }
        }
      }
      switch (other.getTrackInfoCase()) {
        case SEGMENT:
          {
            mergeSegment(other.getSegment());
            break;
          }
        case TRACK_ID:
          {
            setTrackId(other.getTrackId());
            break;
          }
        case TRACKINFO_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getEntityFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame.parser(),
                        extensionRegistry);
                if (framesBuilder_ == null) {
                  ensureFramesIsMutable();
                  frames_.add(m);
                } else {
                  framesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getSegmentFieldBuilder().getBuilder(), extensionRegistry);
                trackInfoCase_ = 3;
                break;
              } // case 26
            case 37:
              {
                confidence_ = input.readFloat();
                bitField0_ |= 0x00000008;
                break;
              } // case 37
            case 40:
              {
                trackInfo_ = input.readInt64();
                trackInfoCase_ = 5;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int trackInfoCase_ = 0;
    private java.lang.Object trackInfo_;

    public TrackInfoCase getTrackInfoCase() {
      return TrackInfoCase.forNumber(trackInfoCase_);
    }

    public Builder clearTrackInfo() {
      trackInfoCase_ = 0;
      trackInfo_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.VideoSegment,
            com.google.cloud.videointelligence.v1p3beta1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1p3beta1.VideoSegmentOrBuilder>
        segmentBuilder_;
    /**
     *
     *
     * <pre>
     * Non-streaming batch mode ONLY.
     * Each object track corresponds to one video segment where it appears.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.VideoSegment segment = 3;</code>
     *
     * @return Whether the segment field is set.
     */
    @java.lang.Override
    public boolean hasSegment() {
      return trackInfoCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Non-streaming batch mode ONLY.
     * Each object track corresponds to one video segment where it appears.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.VideoSegment segment = 3;</code>
     *
     * @return The segment.
     */
    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.VideoSegment getSegment() {
      if (segmentBuilder_ == null) {
        if (trackInfoCase_ == 3) {
          return (com.google.cloud.videointelligence.v1p3beta1.VideoSegment) trackInfo_;
        }
        return com.google.cloud.videointelligence.v1p3beta1.VideoSegment.getDefaultInstance();
      } else {
        if (trackInfoCase_ == 3) {
          return segmentBuilder_.getMessage();
        }
        return com.google.cloud.videointelligence.v1p3beta1.VideoSegment.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Non-streaming batch mode ONLY.
     * Each object track corresponds to one video segment where it appears.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.VideoSegment segment = 3;</code>
     */
    public Builder setSegment(com.google.cloud.videointelligence.v1p3beta1.VideoSegment value) {
      if (segmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trackInfo_ = value;
        onChanged();
      } else {
        segmentBuilder_.setMessage(value);
      }
      trackInfoCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Non-streaming batch mode ONLY.
     * Each object track corresponds to one video segment where it appears.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.VideoSegment segment = 3;</code>
     */
    public Builder setSegment(
        com.google.cloud.videointelligence.v1p3beta1.VideoSegment.Builder builderForValue) {
      if (segmentBuilder_ == null) {
        trackInfo_ = builderForValue.build();
        onChanged();
      } else {
        segmentBuilder_.setMessage(builderForValue.build());
      }
      trackInfoCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Non-streaming batch mode ONLY.
     * Each object track corresponds to one video segment where it appears.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.VideoSegment segment = 3;</code>
     */
    public Builder mergeSegment(com.google.cloud.videointelligence.v1p3beta1.VideoSegment value) {
      if (segmentBuilder_ == null) {
        if (trackInfoCase_ == 3
            && trackInfo_
                != com.google.cloud.videointelligence.v1p3beta1.VideoSegment.getDefaultInstance()) {
          trackInfo_ =
              com.google.cloud.videointelligence.v1p3beta1.VideoSegment.newBuilder(
                      (com.google.cloud.videointelligence.v1p3beta1.VideoSegment) trackInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          trackInfo_ = value;
        }
        onChanged();
      } else {
        if (trackInfoCase_ == 3) {
          segmentBuilder_.mergeFrom(value);
        } else {
          segmentBuilder_.setMessage(value);
        }
      }
      trackInfoCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Non-streaming batch mode ONLY.
     * Each object track corresponds to one video segment where it appears.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.VideoSegment segment = 3;</code>
     */
    public Builder clearSegment() {
      if (segmentBuilder_ == null) {
        if (trackInfoCase_ == 3) {
          trackInfoCase_ = 0;
          trackInfo_ = null;
          onChanged();
        }
      } else {
        if (trackInfoCase_ == 3) {
          trackInfoCase_ = 0;
          trackInfo_ = null;
        }
        segmentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Non-streaming batch mode ONLY.
     * Each object track corresponds to one video segment where it appears.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.VideoSegment segment = 3;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.VideoSegment.Builder getSegmentBuilder() {
      return getSegmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Non-streaming batch mode ONLY.
     * Each object track corresponds to one video segment where it appears.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.VideoSegment segment = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.VideoSegmentOrBuilder
        getSegmentOrBuilder() {
      if ((trackInfoCase_ == 3) && (segmentBuilder_ != null)) {
        return segmentBuilder_.getMessageOrBuilder();
      } else {
        if (trackInfoCase_ == 3) {
          return (com.google.cloud.videointelligence.v1p3beta1.VideoSegment) trackInfo_;
        }
        return com.google.cloud.videointelligence.v1p3beta1.VideoSegment.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Non-streaming batch mode ONLY.
     * Each object track corresponds to one video segment where it appears.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.VideoSegment segment = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.VideoSegment,
            com.google.cloud.videointelligence.v1p3beta1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1p3beta1.VideoSegmentOrBuilder>
        getSegmentFieldBuilder() {
      if (segmentBuilder_ == null) {
        if (!(trackInfoCase_ == 3)) {
          trackInfo_ =
              com.google.cloud.videointelligence.v1p3beta1.VideoSegment.getDefaultInstance();
        }
        segmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1p3beta1.VideoSegment,
                com.google.cloud.videointelligence.v1p3beta1.VideoSegment.Builder,
                com.google.cloud.videointelligence.v1p3beta1.VideoSegmentOrBuilder>(
                (com.google.cloud.videointelligence.v1p3beta1.VideoSegment) trackInfo_,
                getParentForChildren(),
                isClean());
        trackInfo_ = null;
      }
      trackInfoCase_ = 3;
      onChanged();
      return segmentBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Streaming mode ONLY.
     * In streaming mode, we do not know the end time of a tracked object
     * before it is completed. Hence, there is no VideoSegment info returned.
     * Instead, we provide a unique identifiable integer track_id so that
     * the customers can correlate the results of the ongoing
     * ObjectTrackAnnotation of the same track_id over time.
     * </pre>
     *
     * <code>int64 track_id = 5;</code>
     *
     * @return Whether the trackId field is set.
     */
    public boolean hasTrackId() {
      return trackInfoCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Streaming mode ONLY.
     * In streaming mode, we do not know the end time of a tracked object
     * before it is completed. Hence, there is no VideoSegment info returned.
     * Instead, we provide a unique identifiable integer track_id so that
     * the customers can correlate the results of the ongoing
     * ObjectTrackAnnotation of the same track_id over time.
     * </pre>
     *
     * <code>int64 track_id = 5;</code>
     *
     * @return The trackId.
     */
    public long getTrackId() {
      if (trackInfoCase_ == 5) {
        return (java.lang.Long) trackInfo_;
      }
      return 0L;
    }
    /**
     *
     *
     * <pre>
     * Streaming mode ONLY.
     * In streaming mode, we do not know the end time of a tracked object
     * before it is completed. Hence, there is no VideoSegment info returned.
     * Instead, we provide a unique identifiable integer track_id so that
     * the customers can correlate the results of the ongoing
     * ObjectTrackAnnotation of the same track_id over time.
     * </pre>
     *
     * <code>int64 track_id = 5;</code>
     *
     * @param value The trackId to set.
     * @return This builder for chaining.
     */
    public Builder setTrackId(long value) {

      trackInfoCase_ = 5;
      trackInfo_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Streaming mode ONLY.
     * In streaming mode, we do not know the end time of a tracked object
     * before it is completed. Hence, there is no VideoSegment info returned.
     * Instead, we provide a unique identifiable integer track_id so that
     * the customers can correlate the results of the ongoing
     * ObjectTrackAnnotation of the same track_id over time.
     * </pre>
     *
     * <code>int64 track_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrackId() {
      if (trackInfoCase_ == 5) {
        trackInfoCase_ = 0;
        trackInfo_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.cloud.videointelligence.v1p3beta1.Entity entity_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.Entity,
            com.google.cloud.videointelligence.v1p3beta1.Entity.Builder,
            com.google.cloud.videointelligence.v1p3beta1.EntityOrBuilder>
        entityBuilder_;
    /**
     *
     *
     * <pre>
     * Entity to specify the object category that this track is labeled as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     *
     * @return Whether the entity field is set.
     */
    public boolean hasEntity() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Entity to specify the object category that this track is labeled as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     *
     * @return The entity.
     */
    public com.google.cloud.videointelligence.v1p3beta1.Entity getEntity() {
      if (entityBuilder_ == null) {
        return entity_ == null
            ? com.google.cloud.videointelligence.v1p3beta1.Entity.getDefaultInstance()
            : entity_;
      } else {
        return entityBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Entity to specify the object category that this track is labeled as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     */
    public Builder setEntity(com.google.cloud.videointelligence.v1p3beta1.Entity value) {
      if (entityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entity_ = value;
      } else {
        entityBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity to specify the object category that this track is labeled as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     */
    public Builder setEntity(
        com.google.cloud.videointelligence.v1p3beta1.Entity.Builder builderForValue) {
      if (entityBuilder_ == null) {
        entity_ = builderForValue.build();
      } else {
        entityBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity to specify the object category that this track is labeled as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     */
    public Builder mergeEntity(com.google.cloud.videointelligence.v1p3beta1.Entity value) {
      if (entityBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && entity_ != null
            && entity_
                != com.google.cloud.videointelligence.v1p3beta1.Entity.getDefaultInstance()) {
          getEntityBuilder().mergeFrom(value);
        } else {
          entity_ = value;
        }
      } else {
        entityBuilder_.mergeFrom(value);
      }
      if (entity_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity to specify the object category that this track is labeled as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     */
    public Builder clearEntity() {
      bitField0_ = (bitField0_ & ~0x00000004);
      entity_ = null;
      if (entityBuilder_ != null) {
        entityBuilder_.dispose();
        entityBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity to specify the object category that this track is labeled as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.Entity.Builder getEntityBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getEntityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Entity to specify the object category that this track is labeled as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.EntityOrBuilder getEntityOrBuilder() {
      if (entityBuilder_ != null) {
        return entityBuilder_.getMessageOrBuilder();
      } else {
        return entity_ == null
            ? com.google.cloud.videointelligence.v1p3beta1.Entity.getDefaultInstance()
            : entity_;
      }
    }
    /**
     *
     *
     * <pre>
     * Entity to specify the object category that this track is labeled as.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.Entity,
            com.google.cloud.videointelligence.v1p3beta1.Entity.Builder,
            com.google.cloud.videointelligence.v1p3beta1.EntityOrBuilder>
        getEntityFieldBuilder() {
      if (entityBuilder_ == null) {
        entityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1p3beta1.Entity,
                com.google.cloud.videointelligence.v1p3beta1.Entity.Builder,
                com.google.cloud.videointelligence.v1p3beta1.EntityOrBuilder>(
                getEntity(), getParentForChildren(), isClean());
        entity_ = null;
      }
      return entityBuilder_;
    }

    private float confidence_;
    /**
     *
     *
     * <pre>
     * Object category's labeling confidence of this track.
     * </pre>
     *
     * <code>float confidence = 4;</code>
     *
     * @return The confidence.
     */
    @java.lang.Override
    public float getConfidence() {
      return confidence_;
    }
    /**
     *
     *
     * <pre>
     * Object category's labeling confidence of this track.
     * </pre>
     *
     * <code>float confidence = 4;</code>
     *
     * @param value The confidence to set.
     * @return This builder for chaining.
     */
    public Builder setConfidence(float value) {

      confidence_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Object category's labeling confidence of this track.
     * </pre>
     *
     * <code>float confidence = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfidence() {
      bitField0_ = (bitField0_ & ~0x00000008);
      confidence_ = 0F;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame>
        frames_ = java.util.Collections.emptyList();

    private void ensureFramesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        frames_ =
            new java.util.ArrayList<
                com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame>(frames_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame,
            com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame.Builder,
            com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrameOrBuilder>
        framesBuilder_;

    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame>
        getFramesList() {
      if (framesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(frames_);
      } else {
        return framesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public int getFramesCount() {
      if (framesBuilder_ == null) {
        return frames_.size();
      } else {
        return framesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame getFrames(int index) {
      if (framesBuilder_ == null) {
        return frames_.get(index);
      } else {
        return framesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public Builder setFrames(
        int index, com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame value) {
      if (framesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFramesIsMutable();
        frames_.set(index, value);
        onChanged();
      } else {
        framesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public Builder setFrames(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame.Builder builderForValue) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.set(index, builderForValue.build());
        onChanged();
      } else {
        framesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public Builder addFrames(
        com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame value) {
      if (framesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFramesIsMutable();
        frames_.add(value);
        onChanged();
      } else {
        framesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public Builder addFrames(
        int index, com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame value) {
      if (framesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFramesIsMutable();
        frames_.add(index, value);
        onChanged();
      } else {
        framesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public Builder addFrames(
        com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame.Builder builderForValue) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.add(builderForValue.build());
        onChanged();
      } else {
        framesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public Builder addFrames(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame.Builder builderForValue) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.add(index, builderForValue.build());
        onChanged();
      } else {
        framesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public Builder addAllFrames(
        java.lang.Iterable<
                ? extends com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame>
            values) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, frames_);
        onChanged();
      } else {
        framesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public Builder clearFrames() {
      if (framesBuilder_ == null) {
        frames_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        framesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public Builder removeFrames(int index) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.remove(index);
        onChanged();
      } else {
        framesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame.Builder
        getFramesBuilder(int index) {
      return getFramesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrameOrBuilder
        getFramesOrBuilder(int index) {
      if (framesBuilder_ == null) {
        return frames_.get(index);
      } else {
        return framesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrameOrBuilder>
        getFramesOrBuilderList() {
      if (framesBuilder_ != null) {
        return framesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(frames_);
      }
    }
    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame.Builder
        addFramesBuilder() {
      return getFramesFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame.Builder
        addFramesBuilder(int index) {
      return getFramesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Information corresponding to all frames where this object track appears.
     * Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
     * messages in frames.
     * Streaming mode: it can only be one ObjectTrackingFrame message in frames.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame frames = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame.Builder>
        getFramesBuilderList() {
      return getFramesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame,
            com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame.Builder,
            com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrameOrBuilder>
        getFramesFieldBuilder() {
      if (framesBuilder_ == null) {
        framesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame,
                com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame.Builder,
                com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrameOrBuilder>(
                frames_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        frames_ = null;
      }
      return framesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation)
  private static final com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation();
  }

  public static com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ObjectTrackingAnnotation> PARSER =
      new com.google.protobuf.AbstractParser<ObjectTrackingAnnotation>() {
        @java.lang.Override
        public ObjectTrackingAnnotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ObjectTrackingAnnotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ObjectTrackingAnnotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
