/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1p3beta1/video_intelligence.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.videointelligence.v1p3beta1;

/**
 *
 *
 * <pre>
 * Streaming annotation results corresponding to a portion of the video
 * that is currently being processed.
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults}
 */
public final class StreamingVideoAnnotationResults extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults)
    StreamingVideoAnnotationResultsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use StreamingVideoAnnotationResults.newBuilder() to construct.
  private StreamingVideoAnnotationResults(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamingVideoAnnotationResults() {
    shotAnnotations_ = java.util.Collections.emptyList();
    labelAnnotations_ = java.util.Collections.emptyList();
    objectAnnotations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamingVideoAnnotationResults();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p3beta1_StreamingVideoAnnotationResults_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p3beta1_StreamingVideoAnnotationResults_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults.class,
            com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults.Builder
                .class);
  }

  private int bitField0_;
  public static final int SHOT_ANNOTATIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1p3beta1.VideoSegment>
      shotAnnotations_;

  /**
   *
   *
   * <pre>
   * Shot annotation results. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1p3beta1.VideoSegment>
      getShotAnnotationsList() {
    return shotAnnotations_;
  }

  /**
   *
   *
   * <pre>
   * Shot annotation results. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1p3beta1.VideoSegmentOrBuilder>
      getShotAnnotationsOrBuilderList() {
    return shotAnnotations_;
  }

  /**
   *
   *
   * <pre>
   * Shot annotation results. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
   * </code>
   */
  @java.lang.Override
  public int getShotAnnotationsCount() {
    return shotAnnotations_.size();
  }

  /**
   *
   *
   * <pre>
   * Shot annotation results. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.VideoSegment getShotAnnotations(int index) {
    return shotAnnotations_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Shot annotation results. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.VideoSegmentOrBuilder
      getShotAnnotationsOrBuilder(int index) {
    return shotAnnotations_.get(index);
  }

  public static final int LABEL_ANNOTATIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation>
      labelAnnotations_;

  /**
   *
   *
   * <pre>
   * Label annotation results.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation>
      getLabelAnnotationsList() {
    return labelAnnotations_;
  }

  /**
   *
   *
   * <pre>
   * Label annotation results.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1p3beta1.LabelAnnotationOrBuilder>
      getLabelAnnotationsOrBuilderList() {
    return labelAnnotations_;
  }

  /**
   *
   *
   * <pre>
   * Label annotation results.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public int getLabelAnnotationsCount() {
    return labelAnnotations_.size();
  }

  /**
   *
   *
   * <pre>
   * Label annotation results.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation getLabelAnnotations(
      int index) {
    return labelAnnotations_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Label annotation results.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.LabelAnnotationOrBuilder
      getLabelAnnotationsOrBuilder(int index) {
    return labelAnnotations_.get(index);
  }

  public static final int EXPLICIT_ANNOTATION_FIELD_NUMBER = 3;
  private com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation
      explicitAnnotation_;

  /**
   *
   *
   * <pre>
   * Explicit content annotation results.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation explicit_annotation = 3;
   * </code>
   *
   * @return Whether the explicitAnnotation field is set.
   */
  @java.lang.Override
  public boolean hasExplicitAnnotation() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Explicit content annotation results.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation explicit_annotation = 3;
   * </code>
   *
   * @return The explicitAnnotation.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation
      getExplicitAnnotation() {
    return explicitAnnotation_ == null
        ? com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation
            .getDefaultInstance()
        : explicitAnnotation_;
  }

  /**
   *
   *
   * <pre>
   * Explicit content annotation results.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation explicit_annotation = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotationOrBuilder
      getExplicitAnnotationOrBuilder() {
    return explicitAnnotation_ == null
        ? com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation
            .getDefaultInstance()
        : explicitAnnotation_;
  }

  public static final int OBJECT_ANNOTATIONS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation>
      objectAnnotations_;

  /**
   *
   *
   * <pre>
   * Object tracking results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation>
      getObjectAnnotationsList() {
    return objectAnnotations_;
  }

  /**
   *
   *
   * <pre>
   * Object tracking results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotationOrBuilder>
      getObjectAnnotationsOrBuilderList() {
    return objectAnnotations_;
  }

  /**
   *
   *
   * <pre>
   * Object tracking results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public int getObjectAnnotationsCount() {
    return objectAnnotations_.size();
  }

  /**
   *
   *
   * <pre>
   * Object tracking results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation getObjectAnnotations(
      int index) {
    return objectAnnotations_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Object tracking results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotationOrBuilder
      getObjectAnnotationsOrBuilder(int index) {
    return objectAnnotations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < shotAnnotations_.size(); i++) {
      output.writeMessage(1, shotAnnotations_.get(i));
    }
    for (int i = 0; i < labelAnnotations_.size(); i++) {
      output.writeMessage(2, labelAnnotations_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getExplicitAnnotation());
    }
    for (int i = 0; i < objectAnnotations_.size(); i++) {
      output.writeMessage(4, objectAnnotations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < shotAnnotations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, shotAnnotations_.get(i));
    }
    for (int i = 0; i < labelAnnotations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, labelAnnotations_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getExplicitAnnotation());
    }
    for (int i = 0; i < objectAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, objectAnnotations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults other =
        (com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults) obj;

    if (!getShotAnnotationsList().equals(other.getShotAnnotationsList())) return false;
    if (!getLabelAnnotationsList().equals(other.getLabelAnnotationsList())) return false;
    if (hasExplicitAnnotation() != other.hasExplicitAnnotation()) return false;
    if (hasExplicitAnnotation()) {
      if (!getExplicitAnnotation().equals(other.getExplicitAnnotation())) return false;
    }
    if (!getObjectAnnotationsList().equals(other.getObjectAnnotationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getShotAnnotationsCount() > 0) {
      hash = (37 * hash) + SHOT_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getShotAnnotationsList().hashCode();
    }
    if (getLabelAnnotationsCount() > 0) {
      hash = (37 * hash) + LABEL_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getLabelAnnotationsList().hashCode();
    }
    if (hasExplicitAnnotation()) {
      hash = (37 * hash) + EXPLICIT_ANNOTATION_FIELD_NUMBER;
      hash = (53 * hash) + getExplicitAnnotation().hashCode();
    }
    if (getObjectAnnotationsCount() > 0) {
      hash = (37 * hash) + OBJECT_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getObjectAnnotationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Streaming annotation results corresponding to a portion of the video
   * that is currently being processed.
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults)
      com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResultsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_StreamingVideoAnnotationResults_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_StreamingVideoAnnotationResults_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults.class,
              com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getShotAnnotationsFieldBuilder();
        getLabelAnnotationsFieldBuilder();
        getExplicitAnnotationFieldBuilder();
        getObjectAnnotationsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (shotAnnotationsBuilder_ == null) {
        shotAnnotations_ = java.util.Collections.emptyList();
      } else {
        shotAnnotations_ = null;
        shotAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (labelAnnotationsBuilder_ == null) {
        labelAnnotations_ = java.util.Collections.emptyList();
      } else {
        labelAnnotations_ = null;
        labelAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      explicitAnnotation_ = null;
      if (explicitAnnotationBuilder_ != null) {
        explicitAnnotationBuilder_.dispose();
        explicitAnnotationBuilder_ = null;
      }
      if (objectAnnotationsBuilder_ == null) {
        objectAnnotations_ = java.util.Collections.emptyList();
      } else {
        objectAnnotations_ = null;
        objectAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_StreamingVideoAnnotationResults_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
        getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults build() {
      com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
        buildPartial() {
      com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults result =
          new com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults result) {
      if (shotAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          shotAnnotations_ = java.util.Collections.unmodifiableList(shotAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.shotAnnotations_ = shotAnnotations_;
      } else {
        result.shotAnnotations_ = shotAnnotationsBuilder_.build();
      }
      if (labelAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          labelAnnotations_ = java.util.Collections.unmodifiableList(labelAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.labelAnnotations_ = labelAnnotations_;
      } else {
        result.labelAnnotations_ = labelAnnotationsBuilder_.build();
      }
      if (objectAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          objectAnnotations_ = java.util.Collections.unmodifiableList(objectAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.objectAnnotations_ = objectAnnotations_;
      } else {
        result.objectAnnotations_ = objectAnnotationsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.explicitAnnotation_ =
            explicitAnnotationBuilder_ == null
                ? explicitAnnotation_
                : explicitAnnotationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults) {
        return mergeFrom(
            (com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults other) {
      if (other
          == com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
              .getDefaultInstance()) return this;
      if (shotAnnotationsBuilder_ == null) {
        if (!other.shotAnnotations_.isEmpty()) {
          if (shotAnnotations_.isEmpty()) {
            shotAnnotations_ = other.shotAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureShotAnnotationsIsMutable();
            shotAnnotations_.addAll(other.shotAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.shotAnnotations_.isEmpty()) {
          if (shotAnnotationsBuilder_.isEmpty()) {
            shotAnnotationsBuilder_.dispose();
            shotAnnotationsBuilder_ = null;
            shotAnnotations_ = other.shotAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            shotAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getShotAnnotationsFieldBuilder()
                    : null;
          } else {
            shotAnnotationsBuilder_.addAllMessages(other.shotAnnotations_);
          }
        }
      }
      if (labelAnnotationsBuilder_ == null) {
        if (!other.labelAnnotations_.isEmpty()) {
          if (labelAnnotations_.isEmpty()) {
            labelAnnotations_ = other.labelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureLabelAnnotationsIsMutable();
            labelAnnotations_.addAll(other.labelAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.labelAnnotations_.isEmpty()) {
          if (labelAnnotationsBuilder_.isEmpty()) {
            labelAnnotationsBuilder_.dispose();
            labelAnnotationsBuilder_ = null;
            labelAnnotations_ = other.labelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            labelAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLabelAnnotationsFieldBuilder()
                    : null;
          } else {
            labelAnnotationsBuilder_.addAllMessages(other.labelAnnotations_);
          }
        }
      }
      if (other.hasExplicitAnnotation()) {
        mergeExplicitAnnotation(other.getExplicitAnnotation());
      }
      if (objectAnnotationsBuilder_ == null) {
        if (!other.objectAnnotations_.isEmpty()) {
          if (objectAnnotations_.isEmpty()) {
            objectAnnotations_ = other.objectAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureObjectAnnotationsIsMutable();
            objectAnnotations_.addAll(other.objectAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.objectAnnotations_.isEmpty()) {
          if (objectAnnotationsBuilder_.isEmpty()) {
            objectAnnotationsBuilder_.dispose();
            objectAnnotationsBuilder_ = null;
            objectAnnotations_ = other.objectAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000008);
            objectAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getObjectAnnotationsFieldBuilder()
                    : null;
          } else {
            objectAnnotationsBuilder_.addAllMessages(other.objectAnnotations_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.videointelligence.v1p3beta1.VideoSegment m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1p3beta1.VideoSegment.parser(),
                        extensionRegistry);
                if (shotAnnotationsBuilder_ == null) {
                  ensureShotAnnotationsIsMutable();
                  shotAnnotations_.add(m);
                } else {
                  shotAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.parser(),
                        extensionRegistry);
                if (labelAnnotationsBuilder_ == null) {
                  ensureLabelAnnotationsIsMutable();
                  labelAnnotations_.add(m);
                } else {
                  labelAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getExplicitAnnotationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation
                            .parser(),
                        extensionRegistry);
                if (objectAnnotationsBuilder_ == null) {
                  ensureObjectAnnotationsIsMutable();
                  objectAnnotations_.add(m);
                } else {
                  objectAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.videointelligence.v1p3beta1.VideoSegment>
        shotAnnotations_ = java.util.Collections.emptyList();

    private void ensureShotAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        shotAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1p3beta1.VideoSegment>(
                shotAnnotations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.VideoSegment,
            com.google.cloud.videointelligence.v1p3beta1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1p3beta1.VideoSegmentOrBuilder>
        shotAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.VideoSegment>
        getShotAnnotationsList() {
      if (shotAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(shotAnnotations_);
      } else {
        return shotAnnotationsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public int getShotAnnotationsCount() {
      if (shotAnnotationsBuilder_ == null) {
        return shotAnnotations_.size();
      } else {
        return shotAnnotationsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.VideoSegment getShotAnnotations(int index) {
      if (shotAnnotationsBuilder_ == null) {
        return shotAnnotations_.get(index);
      } else {
        return shotAnnotationsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public Builder setShotAnnotations(
        int index, com.google.cloud.videointelligence.v1p3beta1.VideoSegment value) {
      if (shotAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.set(index, value);
        onChanged();
      } else {
        shotAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public Builder setShotAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.VideoSegment.Builder builderForValue) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        shotAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public Builder addShotAnnotations(
        com.google.cloud.videointelligence.v1p3beta1.VideoSegment value) {
      if (shotAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.add(value);
        onChanged();
      } else {
        shotAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public Builder addShotAnnotations(
        int index, com.google.cloud.videointelligence.v1p3beta1.VideoSegment value) {
      if (shotAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.add(index, value);
        onChanged();
      } else {
        shotAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public Builder addShotAnnotations(
        com.google.cloud.videointelligence.v1p3beta1.VideoSegment.Builder builderForValue) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        shotAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public Builder addShotAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.VideoSegment.Builder builderForValue) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        shotAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public Builder addAllShotAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1p3beta1.VideoSegment>
            values) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, shotAnnotations_);
        onChanged();
      } else {
        shotAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public Builder clearShotAnnotations() {
      if (shotAnnotationsBuilder_ == null) {
        shotAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        shotAnnotationsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public Builder removeShotAnnotations(int index) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.remove(index);
        onChanged();
      } else {
        shotAnnotationsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.VideoSegment.Builder
        getShotAnnotationsBuilder(int index) {
      return getShotAnnotationsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.VideoSegmentOrBuilder
        getShotAnnotationsOrBuilder(int index) {
      if (shotAnnotationsBuilder_ == null) {
        return shotAnnotations_.get(index);
      } else {
        return shotAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1p3beta1.VideoSegmentOrBuilder>
        getShotAnnotationsOrBuilderList() {
      if (shotAnnotationsBuilder_ != null) {
        return shotAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(shotAnnotations_);
      }
    }

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.VideoSegment.Builder
        addShotAnnotationsBuilder() {
      return getShotAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1p3beta1.VideoSegment.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.VideoSegment.Builder
        addShotAnnotationsBuilder(int index) {
      return getShotAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1p3beta1.VideoSegment.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Shot annotation results. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.VideoSegment shot_annotations = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.VideoSegment.Builder>
        getShotAnnotationsBuilderList() {
      return getShotAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.VideoSegment,
            com.google.cloud.videointelligence.v1p3beta1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1p3beta1.VideoSegmentOrBuilder>
        getShotAnnotationsFieldBuilder() {
      if (shotAnnotationsBuilder_ == null) {
        shotAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p3beta1.VideoSegment,
                com.google.cloud.videointelligence.v1p3beta1.VideoSegment.Builder,
                com.google.cloud.videointelligence.v1p3beta1.VideoSegmentOrBuilder>(
                shotAnnotations_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        shotAnnotations_ = null;
      }
      return shotAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation>
        labelAnnotations_ = java.util.Collections.emptyList();

    private void ensureLabelAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        labelAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation>(
                labelAnnotations_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation,
            com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1p3beta1.LabelAnnotationOrBuilder>
        labelAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation>
        getLabelAnnotationsList() {
      if (labelAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(labelAnnotations_);
      } else {
        return labelAnnotationsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public int getLabelAnnotationsCount() {
      if (labelAnnotationsBuilder_ == null) {
        return labelAnnotations_.size();
      } else {
        return labelAnnotationsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation getLabelAnnotations(
        int index) {
      if (labelAnnotationsBuilder_ == null) {
        return labelAnnotations_.get(index);
      } else {
        return labelAnnotationsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public Builder setLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation value) {
      if (labelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelAnnotationsIsMutable();
        labelAnnotations_.set(index, value);
        onChanged();
      } else {
        labelAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public Builder setLabelAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.Builder builderForValue) {
      if (labelAnnotationsBuilder_ == null) {
        ensureLabelAnnotationsIsMutable();
        labelAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        labelAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public Builder addLabelAnnotations(
        com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation value) {
      if (labelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelAnnotationsIsMutable();
        labelAnnotations_.add(value);
        onChanged();
      } else {
        labelAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public Builder addLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation value) {
      if (labelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelAnnotationsIsMutable();
        labelAnnotations_.add(index, value);
        onChanged();
      } else {
        labelAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public Builder addLabelAnnotations(
        com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.Builder builderForValue) {
      if (labelAnnotationsBuilder_ == null) {
        ensureLabelAnnotationsIsMutable();
        labelAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        labelAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public Builder addLabelAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.Builder builderForValue) {
      if (labelAnnotationsBuilder_ == null) {
        ensureLabelAnnotationsIsMutable();
        labelAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        labelAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public Builder addAllLabelAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation>
            values) {
      if (labelAnnotationsBuilder_ == null) {
        ensureLabelAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, labelAnnotations_);
        onChanged();
      } else {
        labelAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public Builder clearLabelAnnotations() {
      if (labelAnnotationsBuilder_ == null) {
        labelAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        labelAnnotationsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public Builder removeLabelAnnotations(int index) {
      if (labelAnnotationsBuilder_ == null) {
        ensureLabelAnnotationsIsMutable();
        labelAnnotations_.remove(index);
        onChanged();
      } else {
        labelAnnotationsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.Builder
        getLabelAnnotationsBuilder(int index) {
      return getLabelAnnotationsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.LabelAnnotationOrBuilder
        getLabelAnnotationsOrBuilder(int index) {
      if (labelAnnotationsBuilder_ == null) {
        return labelAnnotations_.get(index);
      } else {
        return labelAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1p3beta1.LabelAnnotationOrBuilder>
        getLabelAnnotationsOrBuilderList() {
      if (labelAnnotationsBuilder_ != null) {
        return labelAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(labelAnnotations_);
      }
    }

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.Builder
        addLabelAnnotationsBuilder() {
      return getLabelAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.Builder
        addLabelAnnotationsBuilder(int index) {
      return getLabelAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Label annotation results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.LabelAnnotation label_annotations = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.Builder>
        getLabelAnnotationsBuilderList() {
      return getLabelAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation,
            com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1p3beta1.LabelAnnotationOrBuilder>
        getLabelAnnotationsFieldBuilder() {
      if (labelAnnotationsBuilder_ == null) {
        labelAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation,
                com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.Builder,
                com.google.cloud.videointelligence.v1p3beta1.LabelAnnotationOrBuilder>(
                labelAnnotations_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        labelAnnotations_ = null;
      }
      return labelAnnotationsBuilder_;
    }

    private com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation
        explicitAnnotation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation,
            com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation.Builder,
            com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotationOrBuilder>
        explicitAnnotationBuilder_;

    /**
     *
     *
     * <pre>
     * Explicit content annotation results.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation explicit_annotation = 3;
     * </code>
     *
     * @return Whether the explicitAnnotation field is set.
     */
    public boolean hasExplicitAnnotation() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Explicit content annotation results.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation explicit_annotation = 3;
     * </code>
     *
     * @return The explicitAnnotation.
     */
    public com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation
        getExplicitAnnotation() {
      if (explicitAnnotationBuilder_ == null) {
        return explicitAnnotation_ == null
            ? com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation
                .getDefaultInstance()
            : explicitAnnotation_;
      } else {
        return explicitAnnotationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Explicit content annotation results.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation explicit_annotation = 3;
     * </code>
     */
    public Builder setExplicitAnnotation(
        com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation value) {
      if (explicitAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explicitAnnotation_ = value;
      } else {
        explicitAnnotationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Explicit content annotation results.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation explicit_annotation = 3;
     * </code>
     */
    public Builder setExplicitAnnotation(
        com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation.Builder
            builderForValue) {
      if (explicitAnnotationBuilder_ == null) {
        explicitAnnotation_ = builderForValue.build();
      } else {
        explicitAnnotationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Explicit content annotation results.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation explicit_annotation = 3;
     * </code>
     */
    public Builder mergeExplicitAnnotation(
        com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation value) {
      if (explicitAnnotationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && explicitAnnotation_ != null
            && explicitAnnotation_
                != com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation
                    .getDefaultInstance()) {
          getExplicitAnnotationBuilder().mergeFrom(value);
        } else {
          explicitAnnotation_ = value;
        }
      } else {
        explicitAnnotationBuilder_.mergeFrom(value);
      }
      if (explicitAnnotation_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Explicit content annotation results.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation explicit_annotation = 3;
     * </code>
     */
    public Builder clearExplicitAnnotation() {
      bitField0_ = (bitField0_ & ~0x00000004);
      explicitAnnotation_ = null;
      if (explicitAnnotationBuilder_ != null) {
        explicitAnnotationBuilder_.dispose();
        explicitAnnotationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Explicit content annotation results.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation explicit_annotation = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation.Builder
        getExplicitAnnotationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getExplicitAnnotationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Explicit content annotation results.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation explicit_annotation = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotationOrBuilder
        getExplicitAnnotationOrBuilder() {
      if (explicitAnnotationBuilder_ != null) {
        return explicitAnnotationBuilder_.getMessageOrBuilder();
      } else {
        return explicitAnnotation_ == null
            ? com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation
                .getDefaultInstance()
            : explicitAnnotation_;
      }
    }

    /**
     *
     *
     * <pre>
     * Explicit content annotation results.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation explicit_annotation = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation,
            com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation.Builder,
            com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotationOrBuilder>
        getExplicitAnnotationFieldBuilder() {
      if (explicitAnnotationBuilder_ == null) {
        explicitAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation,
                com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation.Builder,
                com.google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotationOrBuilder>(
                getExplicitAnnotation(), getParentForChildren(), isClean());
        explicitAnnotation_ = null;
      }
      return explicitAnnotationBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation>
        objectAnnotations_ = java.util.Collections.emptyList();

    private void ensureObjectAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        objectAnnotations_ =
            new java.util.ArrayList<
                com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation>(
                objectAnnotations_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation,
            com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation.Builder,
            com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotationOrBuilder>
        objectAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation>
        getObjectAnnotationsList() {
      if (objectAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(objectAnnotations_);
      } else {
        return objectAnnotationsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public int getObjectAnnotationsCount() {
      if (objectAnnotationsBuilder_ == null) {
        return objectAnnotations_.size();
      } else {
        return objectAnnotationsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation
        getObjectAnnotations(int index) {
      if (objectAnnotationsBuilder_ == null) {
        return objectAnnotations_.get(index);
      } else {
        return objectAnnotationsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public Builder setObjectAnnotations(
        int index, com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation value) {
      if (objectAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.set(index, value);
        onChanged();
      } else {
        objectAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public Builder setObjectAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation.Builder
            builderForValue) {
      if (objectAnnotationsBuilder_ == null) {
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        objectAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public Builder addObjectAnnotations(
        com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation value) {
      if (objectAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.add(value);
        onChanged();
      } else {
        objectAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public Builder addObjectAnnotations(
        int index, com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation value) {
      if (objectAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.add(index, value);
        onChanged();
      } else {
        objectAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public Builder addObjectAnnotations(
        com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation.Builder
            builderForValue) {
      if (objectAnnotationsBuilder_ == null) {
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        objectAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public Builder addObjectAnnotations(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation.Builder
            builderForValue) {
      if (objectAnnotationsBuilder_ == null) {
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        objectAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public Builder addAllObjectAnnotations(
        java.lang.Iterable<
                ? extends com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation>
            values) {
      if (objectAnnotationsBuilder_ == null) {
        ensureObjectAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, objectAnnotations_);
        onChanged();
      } else {
        objectAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public Builder clearObjectAnnotations() {
      if (objectAnnotationsBuilder_ == null) {
        objectAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        objectAnnotationsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public Builder removeObjectAnnotations(int index) {
      if (objectAnnotationsBuilder_ == null) {
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.remove(index);
        onChanged();
      } else {
        objectAnnotationsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation.Builder
        getObjectAnnotationsBuilder(int index) {
      return getObjectAnnotationsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotationOrBuilder
        getObjectAnnotationsOrBuilder(int index) {
      if (objectAnnotationsBuilder_ == null) {
        return objectAnnotations_.get(index);
      } else {
        return objectAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotationOrBuilder>
        getObjectAnnotationsOrBuilderList() {
      if (objectAnnotationsBuilder_ != null) {
        return objectAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(objectAnnotations_);
      }
    }

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation.Builder
        addObjectAnnotationsBuilder() {
      return getObjectAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation.Builder
        addObjectAnnotationsBuilder(int index) {
      return getObjectAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Object tracking results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation object_annotations = 4;
     * </code>
     */
    public java.util.List<
            com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation.Builder>
        getObjectAnnotationsBuilderList() {
      return getObjectAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation,
            com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation.Builder,
            com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotationOrBuilder>
        getObjectAnnotationsFieldBuilder() {
      if (objectAnnotationsBuilder_ == null) {
        objectAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation,
                com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation.Builder,
                com.google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotationOrBuilder>(
                objectAnnotations_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        objectAnnotations_ = null;
      }
      return objectAnnotationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults)
  private static final com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults();
  }

  public static com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamingVideoAnnotationResults> PARSER =
      new com.google.protobuf.AbstractParser<StreamingVideoAnnotationResults>() {
        @java.lang.Override
        public StreamingVideoAnnotationResults parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StreamingVideoAnnotationResults> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamingVideoAnnotationResults> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
