/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1p3beta1/video_intelligence.proto

package com.google.cloud.videointelligence.v1p3beta1;

/**
 *
 *
 * <pre>
 * The annotation result of a celebrity face track. RecognizedCelebrity field
 * could be empty if the face track does not have any matched celebrities.
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1p3beta1.CelebrityTrack}
 */
public final class CelebrityTrack extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1p3beta1.CelebrityTrack)
    CelebrityTrackOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CelebrityTrack.newBuilder() to construct.
  private CelebrityTrack(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CelebrityTrack() {
    celebrities_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CelebrityTrack();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private CelebrityTrack(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                celebrities_ =
                    new java.util.ArrayList<
                        com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack
                            .RecognizedCelebrity>();
                mutable_bitField0_ |= 0x00000001;
              }
              celebrities_.add(
                  input.readMessage(
                      com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack
                          .RecognizedCelebrity.parser(),
                      extensionRegistry));
              break;
            }
          case 26:
            {
              com.google.cloud.videointelligence.v1p3beta1.Track.Builder subBuilder = null;
              if (faceTrack_ != null) {
                subBuilder = faceTrack_.toBuilder();
              }
              faceTrack_ =
                  input.readMessage(
                      com.google.cloud.videointelligence.v1p3beta1.Track.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(faceTrack_);
                faceTrack_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        celebrities_ = java.util.Collections.unmodifiableList(celebrities_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p3beta1_CelebrityTrack_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p3beta1_CelebrityTrack_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.class,
            com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.Builder.class);
  }

  public interface RecognizedCelebrityOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The recognized celebrity.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Celebrity celebrity = 1;</code>
     *
     * @return Whether the celebrity field is set.
     */
    boolean hasCelebrity();
    /**
     *
     *
     * <pre>
     * The recognized celebrity.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Celebrity celebrity = 1;</code>
     *
     * @return The celebrity.
     */
    com.google.cloud.videointelligence.v1p3beta1.Celebrity getCelebrity();
    /**
     *
     *
     * <pre>
     * The recognized celebrity.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Celebrity celebrity = 1;</code>
     */
    com.google.cloud.videointelligence.v1p3beta1.CelebrityOrBuilder getCelebrityOrBuilder();

    /**
     *
     *
     * <pre>
     * Recognition confidence. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 2;</code>
     *
     * @return The confidence.
     */
    float getConfidence();
  }
  /**
   *
   *
   * <pre>
   * The recognized celebrity with confidence score.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity}
   */
  public static final class RecognizedCelebrity extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity)
      RecognizedCelebrityOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RecognizedCelebrity.newBuilder() to construct.
    private RecognizedCelebrity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RecognizedCelebrity() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RecognizedCelebrity();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private RecognizedCelebrity(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.videointelligence.v1p3beta1.Celebrity.Builder subBuilder = null;
                if (celebrity_ != null) {
                  subBuilder = celebrity_.toBuilder();
                }
                celebrity_ =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1p3beta1.Celebrity.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(celebrity_);
                  celebrity_ = subBuilder.buildPartial();
                }

                break;
              }
            case 21:
              {
                confidence_ = input.readFloat();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_CelebrityTrack_RecognizedCelebrity_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_CelebrityTrack_RecognizedCelebrity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity.class,
              com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
                  .Builder.class);
    }

    public static final int CELEBRITY_FIELD_NUMBER = 1;
    private com.google.cloud.videointelligence.v1p3beta1.Celebrity celebrity_;
    /**
     *
     *
     * <pre>
     * The recognized celebrity.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Celebrity celebrity = 1;</code>
     *
     * @return Whether the celebrity field is set.
     */
    public boolean hasCelebrity() {
      return celebrity_ != null;
    }
    /**
     *
     *
     * <pre>
     * The recognized celebrity.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Celebrity celebrity = 1;</code>
     *
     * @return The celebrity.
     */
    public com.google.cloud.videointelligence.v1p3beta1.Celebrity getCelebrity() {
      return celebrity_ == null
          ? com.google.cloud.videointelligence.v1p3beta1.Celebrity.getDefaultInstance()
          : celebrity_;
    }
    /**
     *
     *
     * <pre>
     * The recognized celebrity.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Celebrity celebrity = 1;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.CelebrityOrBuilder getCelebrityOrBuilder() {
      return getCelebrity();
    }

    public static final int CONFIDENCE_FIELD_NUMBER = 2;
    private float confidence_;
    /**
     *
     *
     * <pre>
     * Recognition confidence. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 2;</code>
     *
     * @return The confidence.
     */
    public float getConfidence() {
      return confidence_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (celebrity_ != null) {
        output.writeMessage(1, getCelebrity());
      }
      if (confidence_ != 0F) {
        output.writeFloat(2, confidence_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (celebrity_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCelebrity());
      }
      if (confidence_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, confidence_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity)) {
        return super.equals(obj);
      }
      com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity other =
          (com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity) obj;

      if (hasCelebrity() != other.hasCelebrity()) return false;
      if (hasCelebrity()) {
        if (!getCelebrity().equals(other.getCelebrity())) return false;
      }
      if (java.lang.Float.floatToIntBits(getConfidence())
          != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCelebrity()) {
        hash = (37 * hash) + CELEBRITY_FIELD_NUMBER;
        hash = (53 * hash) + getCelebrity().hashCode();
      }
      hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The recognized celebrity with confidence score.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity)
        com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrityOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
            .internal_static_google_cloud_videointelligence_v1p3beta1_CelebrityTrack_RecognizedCelebrity_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
            .internal_static_google_cloud_videointelligence_v1p3beta1_CelebrityTrack_RecognizedCelebrity_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
                    .class,
                com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (celebrityBuilder_ == null) {
          celebrity_ = null;
        } else {
          celebrity_ = null;
          celebrityBuilder_ = null;
        }
        confidence_ = 0F;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
            .internal_static_google_cloud_videointelligence_v1p3beta1_CelebrityTrack_RecognizedCelebrity_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
          getDefaultInstanceForType() {
        return com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
          build() {
        com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
          buildPartial() {
        com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity result =
            new com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity(
                this);
        if (celebrityBuilder_ == null) {
          result.celebrity_ = celebrity_;
        } else {
          result.celebrity_ = celebrityBuilder_.build();
        }
        result.confidence_ = confidence_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity) {
          return mergeFrom(
              (com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity other) {
        if (other
            == com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
                .getDefaultInstance()) return this;
        if (other.hasCelebrity()) {
          mergeCelebrity(other.getCelebrity());
        }
        if (other.getConfidence() != 0F) {
          setConfidence(other.getConfidence());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private com.google.cloud.videointelligence.v1p3beta1.Celebrity celebrity_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.videointelligence.v1p3beta1.Celebrity,
              com.google.cloud.videointelligence.v1p3beta1.Celebrity.Builder,
              com.google.cloud.videointelligence.v1p3beta1.CelebrityOrBuilder>
          celebrityBuilder_;
      /**
       *
       *
       * <pre>
       * The recognized celebrity.
       * </pre>
       *
       * <code>.google.cloud.videointelligence.v1p3beta1.Celebrity celebrity = 1;</code>
       *
       * @return Whether the celebrity field is set.
       */
      public boolean hasCelebrity() {
        return celebrityBuilder_ != null || celebrity_ != null;
      }
      /**
       *
       *
       * <pre>
       * The recognized celebrity.
       * </pre>
       *
       * <code>.google.cloud.videointelligence.v1p3beta1.Celebrity celebrity = 1;</code>
       *
       * @return The celebrity.
       */
      public com.google.cloud.videointelligence.v1p3beta1.Celebrity getCelebrity() {
        if (celebrityBuilder_ == null) {
          return celebrity_ == null
              ? com.google.cloud.videointelligence.v1p3beta1.Celebrity.getDefaultInstance()
              : celebrity_;
        } else {
          return celebrityBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The recognized celebrity.
       * </pre>
       *
       * <code>.google.cloud.videointelligence.v1p3beta1.Celebrity celebrity = 1;</code>
       */
      public Builder setCelebrity(com.google.cloud.videointelligence.v1p3beta1.Celebrity value) {
        if (celebrityBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          celebrity_ = value;
          onChanged();
        } else {
          celebrityBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The recognized celebrity.
       * </pre>
       *
       * <code>.google.cloud.videointelligence.v1p3beta1.Celebrity celebrity = 1;</code>
       */
      public Builder setCelebrity(
          com.google.cloud.videointelligence.v1p3beta1.Celebrity.Builder builderForValue) {
        if (celebrityBuilder_ == null) {
          celebrity_ = builderForValue.build();
          onChanged();
        } else {
          celebrityBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The recognized celebrity.
       * </pre>
       *
       * <code>.google.cloud.videointelligence.v1p3beta1.Celebrity celebrity = 1;</code>
       */
      public Builder mergeCelebrity(com.google.cloud.videointelligence.v1p3beta1.Celebrity value) {
        if (celebrityBuilder_ == null) {
          if (celebrity_ != null) {
            celebrity_ =
                com.google.cloud.videointelligence.v1p3beta1.Celebrity.newBuilder(celebrity_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            celebrity_ = value;
          }
          onChanged();
        } else {
          celebrityBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The recognized celebrity.
       * </pre>
       *
       * <code>.google.cloud.videointelligence.v1p3beta1.Celebrity celebrity = 1;</code>
       */
      public Builder clearCelebrity() {
        if (celebrityBuilder_ == null) {
          celebrity_ = null;
          onChanged();
        } else {
          celebrity_ = null;
          celebrityBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The recognized celebrity.
       * </pre>
       *
       * <code>.google.cloud.videointelligence.v1p3beta1.Celebrity celebrity = 1;</code>
       */
      public com.google.cloud.videointelligence.v1p3beta1.Celebrity.Builder getCelebrityBuilder() {

        onChanged();
        return getCelebrityFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The recognized celebrity.
       * </pre>
       *
       * <code>.google.cloud.videointelligence.v1p3beta1.Celebrity celebrity = 1;</code>
       */
      public com.google.cloud.videointelligence.v1p3beta1.CelebrityOrBuilder
          getCelebrityOrBuilder() {
        if (celebrityBuilder_ != null) {
          return celebrityBuilder_.getMessageOrBuilder();
        } else {
          return celebrity_ == null
              ? com.google.cloud.videointelligence.v1p3beta1.Celebrity.getDefaultInstance()
              : celebrity_;
        }
      }
      /**
       *
       *
       * <pre>
       * The recognized celebrity.
       * </pre>
       *
       * <code>.google.cloud.videointelligence.v1p3beta1.Celebrity celebrity = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.videointelligence.v1p3beta1.Celebrity,
              com.google.cloud.videointelligence.v1p3beta1.Celebrity.Builder,
              com.google.cloud.videointelligence.v1p3beta1.CelebrityOrBuilder>
          getCelebrityFieldBuilder() {
        if (celebrityBuilder_ == null) {
          celebrityBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.videointelligence.v1p3beta1.Celebrity,
                  com.google.cloud.videointelligence.v1p3beta1.Celebrity.Builder,
                  com.google.cloud.videointelligence.v1p3beta1.CelebrityOrBuilder>(
                  getCelebrity(), getParentForChildren(), isClean());
          celebrity_ = null;
        }
        return celebrityBuilder_;
      }

      private float confidence_;
      /**
       *
       *
       * <pre>
       * Recognition confidence. Range [0, 1].
       * </pre>
       *
       * <code>float confidence = 2;</code>
       *
       * @return The confidence.
       */
      public float getConfidence() {
        return confidence_;
      }
      /**
       *
       *
       * <pre>
       * Recognition confidence. Range [0, 1].
       * </pre>
       *
       * <code>float confidence = 2;</code>
       *
       * @param value The confidence to set.
       * @return This builder for chaining.
       */
      public Builder setConfidence(float value) {

        confidence_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Recognition confidence. Range [0, 1].
       * </pre>
       *
       * <code>float confidence = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConfidence() {

        confidence_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity)
    private static final com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack
            .RecognizedCelebrity
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity();
    }

    public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RecognizedCelebrity> PARSER =
        new com.google.protobuf.AbstractParser<RecognizedCelebrity>() {
          @java.lang.Override
          public RecognizedCelebrity parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new RecognizedCelebrity(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<RecognizedCelebrity> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RecognizedCelebrity> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CELEBRITIES_FIELD_NUMBER = 1;
  private java.util.List<
          com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity>
      celebrities_;
  /**
   *
   *
   * <pre>
   * Top N match of the celebrities for the face in this track.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
   * </code>
   */
  public java.util.List<
          com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity>
      getCelebritiesList() {
    return celebrities_;
  }
  /**
   *
   *
   * <pre>
   * Top N match of the celebrities for the face in this track.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
   * </code>
   */
  public java.util.List<
          ? extends
              com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack
                  .RecognizedCelebrityOrBuilder>
      getCelebritiesOrBuilderList() {
    return celebrities_;
  }
  /**
   *
   *
   * <pre>
   * Top N match of the celebrities for the face in this track.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
   * </code>
   */
  public int getCelebritiesCount() {
    return celebrities_.size();
  }
  /**
   *
   *
   * <pre>
   * Top N match of the celebrities for the face in this track.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
   * </code>
   */
  public com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
      getCelebrities(int index) {
    return celebrities_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Top N match of the celebrities for the face in this track.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
   * </code>
   */
  public com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrityOrBuilder
      getCelebritiesOrBuilder(int index) {
    return celebrities_.get(index);
  }

  public static final int FACE_TRACK_FIELD_NUMBER = 3;
  private com.google.cloud.videointelligence.v1p3beta1.Track faceTrack_;
  /**
   *
   *
   * <pre>
   * A track of a person's face.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p3beta1.Track face_track = 3;</code>
   *
   * @return Whether the faceTrack field is set.
   */
  public boolean hasFaceTrack() {
    return faceTrack_ != null;
  }
  /**
   *
   *
   * <pre>
   * A track of a person's face.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p3beta1.Track face_track = 3;</code>
   *
   * @return The faceTrack.
   */
  public com.google.cloud.videointelligence.v1p3beta1.Track getFaceTrack() {
    return faceTrack_ == null
        ? com.google.cloud.videointelligence.v1p3beta1.Track.getDefaultInstance()
        : faceTrack_;
  }
  /**
   *
   *
   * <pre>
   * A track of a person's face.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p3beta1.Track face_track = 3;</code>
   */
  public com.google.cloud.videointelligence.v1p3beta1.TrackOrBuilder getFaceTrackOrBuilder() {
    return getFaceTrack();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < celebrities_.size(); i++) {
      output.writeMessage(1, celebrities_.get(i));
    }
    if (faceTrack_ != null) {
      output.writeMessage(3, getFaceTrack());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < celebrities_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, celebrities_.get(i));
    }
    if (faceTrack_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getFaceTrack());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack other =
        (com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack) obj;

    if (!getCelebritiesList().equals(other.getCelebritiesList())) return false;
    if (hasFaceTrack() != other.hasFaceTrack()) return false;
    if (hasFaceTrack()) {
      if (!getFaceTrack().equals(other.getFaceTrack())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getCelebritiesCount() > 0) {
      hash = (37 * hash) + CELEBRITIES_FIELD_NUMBER;
      hash = (53 * hash) + getCelebritiesList().hashCode();
    }
    if (hasFaceTrack()) {
      hash = (37 * hash) + FACE_TRACK_FIELD_NUMBER;
      hash = (53 * hash) + getFaceTrack().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The annotation result of a celebrity face track. RecognizedCelebrity field
   * could be empty if the face track does not have any matched celebrities.
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1p3beta1.CelebrityTrack}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1p3beta1.CelebrityTrack)
      com.google.cloud.videointelligence.v1p3beta1.CelebrityTrackOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_CelebrityTrack_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_CelebrityTrack_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.class,
              com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.Builder.class);
    }

    // Construct using com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCelebritiesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (celebritiesBuilder_ == null) {
        celebrities_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        celebritiesBuilder_.clear();
      }
      if (faceTrackBuilder_ == null) {
        faceTrack_ = null;
      } else {
        faceTrack_ = null;
        faceTrackBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_CelebrityTrack_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack build() {
      com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack buildPartial() {
      com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack result =
          new com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack(this);
      int from_bitField0_ = bitField0_;
      if (celebritiesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          celebrities_ = java.util.Collections.unmodifiableList(celebrities_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.celebrities_ = celebrities_;
      } else {
        result.celebrities_ = celebritiesBuilder_.build();
      }
      if (faceTrackBuilder_ == null) {
        result.faceTrack_ = faceTrack_;
      } else {
        result.faceTrack_ = faceTrackBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack) {
        return mergeFrom((com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack other) {
      if (other == com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.getDefaultInstance())
        return this;
      if (celebritiesBuilder_ == null) {
        if (!other.celebrities_.isEmpty()) {
          if (celebrities_.isEmpty()) {
            celebrities_ = other.celebrities_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureCelebritiesIsMutable();
            celebrities_.addAll(other.celebrities_);
          }
          onChanged();
        }
      } else {
        if (!other.celebrities_.isEmpty()) {
          if (celebritiesBuilder_.isEmpty()) {
            celebritiesBuilder_.dispose();
            celebritiesBuilder_ = null;
            celebrities_ = other.celebrities_;
            bitField0_ = (bitField0_ & ~0x00000001);
            celebritiesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCelebritiesFieldBuilder()
                    : null;
          } else {
            celebritiesBuilder_.addAllMessages(other.celebrities_);
          }
        }
      }
      if (other.hasFaceTrack()) {
        mergeFaceTrack(other.getFaceTrack());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity>
        celebrities_ = java.util.Collections.emptyList();

    private void ensureCelebritiesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        celebrities_ =
            new java.util.ArrayList<
                com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity>(
                celebrities_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity,
            com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity.Builder,
            com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack
                .RecognizedCelebrityOrBuilder>
        celebritiesBuilder_;

    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity>
        getCelebritiesList() {
      if (celebritiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(celebrities_);
      } else {
        return celebritiesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public int getCelebritiesCount() {
      if (celebritiesBuilder_ == null) {
        return celebrities_.size();
      } else {
        return celebritiesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
        getCelebrities(int index) {
      if (celebritiesBuilder_ == null) {
        return celebrities_.get(index);
      } else {
        return celebritiesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public Builder setCelebrities(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity value) {
      if (celebritiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCelebritiesIsMutable();
        celebrities_.set(index, value);
        onChanged();
      } else {
        celebritiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public Builder setCelebrities(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity.Builder
            builderForValue) {
      if (celebritiesBuilder_ == null) {
        ensureCelebritiesIsMutable();
        celebrities_.set(index, builderForValue.build());
        onChanged();
      } else {
        celebritiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public Builder addCelebrities(
        com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity value) {
      if (celebritiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCelebritiesIsMutable();
        celebrities_.add(value);
        onChanged();
      } else {
        celebritiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public Builder addCelebrities(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity value) {
      if (celebritiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCelebritiesIsMutable();
        celebrities_.add(index, value);
        onChanged();
      } else {
        celebritiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public Builder addCelebrities(
        com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity.Builder
            builderForValue) {
      if (celebritiesBuilder_ == null) {
        ensureCelebritiesIsMutable();
        celebrities_.add(builderForValue.build());
        onChanged();
      } else {
        celebritiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public Builder addCelebrities(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity.Builder
            builderForValue) {
      if (celebritiesBuilder_ == null) {
        ensureCelebritiesIsMutable();
        celebrities_.add(index, builderForValue.build());
        onChanged();
      } else {
        celebritiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public Builder addAllCelebrities(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity>
            values) {
      if (celebritiesBuilder_ == null) {
        ensureCelebritiesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, celebrities_);
        onChanged();
      } else {
        celebritiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public Builder clearCelebrities() {
      if (celebritiesBuilder_ == null) {
        celebrities_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        celebritiesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public Builder removeCelebrities(int index) {
      if (celebritiesBuilder_ == null) {
        ensureCelebritiesIsMutable();
        celebrities_.remove(index);
        onChanged();
      } else {
        celebritiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity.Builder
        getCelebritiesBuilder(int index) {
      return getCelebritiesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrityOrBuilder
        getCelebritiesOrBuilder(int index) {
      if (celebritiesBuilder_ == null) {
        return celebrities_.get(index);
      } else {
        return celebritiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack
                    .RecognizedCelebrityOrBuilder>
        getCelebritiesOrBuilderList() {
      if (celebritiesBuilder_ != null) {
        return celebritiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(celebrities_);
      }
    }
    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity.Builder
        addCelebritiesBuilder() {
      return getCelebritiesFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity.Builder
        addCelebritiesBuilder(int index) {
      return getCelebritiesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Top N match of the celebrities for the face in this track.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity celebrities = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity.Builder>
        getCelebritiesBuilderList() {
      return getCelebritiesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity,
            com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity.Builder,
            com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack
                .RecognizedCelebrityOrBuilder>
        getCelebritiesFieldBuilder() {
      if (celebritiesBuilder_ == null) {
        celebritiesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity,
                com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack.RecognizedCelebrity
                    .Builder,
                com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack
                    .RecognizedCelebrityOrBuilder>(
                celebrities_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        celebrities_ = null;
      }
      return celebritiesBuilder_;
    }

    private com.google.cloud.videointelligence.v1p3beta1.Track faceTrack_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.Track,
            com.google.cloud.videointelligence.v1p3beta1.Track.Builder,
            com.google.cloud.videointelligence.v1p3beta1.TrackOrBuilder>
        faceTrackBuilder_;
    /**
     *
     *
     * <pre>
     * A track of a person's face.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Track face_track = 3;</code>
     *
     * @return Whether the faceTrack field is set.
     */
    public boolean hasFaceTrack() {
      return faceTrackBuilder_ != null || faceTrack_ != null;
    }
    /**
     *
     *
     * <pre>
     * A track of a person's face.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Track face_track = 3;</code>
     *
     * @return The faceTrack.
     */
    public com.google.cloud.videointelligence.v1p3beta1.Track getFaceTrack() {
      if (faceTrackBuilder_ == null) {
        return faceTrack_ == null
            ? com.google.cloud.videointelligence.v1p3beta1.Track.getDefaultInstance()
            : faceTrack_;
      } else {
        return faceTrackBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A track of a person's face.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Track face_track = 3;</code>
     */
    public Builder setFaceTrack(com.google.cloud.videointelligence.v1p3beta1.Track value) {
      if (faceTrackBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        faceTrack_ = value;
        onChanged();
      } else {
        faceTrackBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A track of a person's face.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Track face_track = 3;</code>
     */
    public Builder setFaceTrack(
        com.google.cloud.videointelligence.v1p3beta1.Track.Builder builderForValue) {
      if (faceTrackBuilder_ == null) {
        faceTrack_ = builderForValue.build();
        onChanged();
      } else {
        faceTrackBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A track of a person's face.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Track face_track = 3;</code>
     */
    public Builder mergeFaceTrack(com.google.cloud.videointelligence.v1p3beta1.Track value) {
      if (faceTrackBuilder_ == null) {
        if (faceTrack_ != null) {
          faceTrack_ =
              com.google.cloud.videointelligence.v1p3beta1.Track.newBuilder(faceTrack_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          faceTrack_ = value;
        }
        onChanged();
      } else {
        faceTrackBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A track of a person's face.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Track face_track = 3;</code>
     */
    public Builder clearFaceTrack() {
      if (faceTrackBuilder_ == null) {
        faceTrack_ = null;
        onChanged();
      } else {
        faceTrack_ = null;
        faceTrackBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A track of a person's face.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Track face_track = 3;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.Track.Builder getFaceTrackBuilder() {

      onChanged();
      return getFaceTrackFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A track of a person's face.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Track face_track = 3;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.TrackOrBuilder getFaceTrackOrBuilder() {
      if (faceTrackBuilder_ != null) {
        return faceTrackBuilder_.getMessageOrBuilder();
      } else {
        return faceTrack_ == null
            ? com.google.cloud.videointelligence.v1p3beta1.Track.getDefaultInstance()
            : faceTrack_;
      }
    }
    /**
     *
     *
     * <pre>
     * A track of a person's face.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Track face_track = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.Track,
            com.google.cloud.videointelligence.v1p3beta1.Track.Builder,
            com.google.cloud.videointelligence.v1p3beta1.TrackOrBuilder>
        getFaceTrackFieldBuilder() {
      if (faceTrackBuilder_ == null) {
        faceTrackBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1p3beta1.Track,
                com.google.cloud.videointelligence.v1p3beta1.Track.Builder,
                com.google.cloud.videointelligence.v1p3beta1.TrackOrBuilder>(
                getFaceTrack(), getParentForChildren(), isClean());
        faceTrack_ = null;
      }
      return faceTrackBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1p3beta1.CelebrityTrack)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1p3beta1.CelebrityTrack)
  private static final com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack();
  }

  public static com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CelebrityTrack> PARSER =
      new com.google.protobuf.AbstractParser<CelebrityTrack>() {
        @java.lang.Override
        public CelebrityTrack parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new CelebrityTrack(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<CelebrityTrack> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CelebrityTrack> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.CelebrityTrack getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
