/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1p3beta1/video_intelligence.proto

package com.google.cloud.videointelligence.v1p3beta1;

/**
 *
 *
 * <pre>
 * For tracking related features.
 * An object at time_offset with attributes, and located with
 * normalized_bounding_box.
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1p3beta1.TimestampedObject}
 */
public final class TimestampedObject extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1p3beta1.TimestampedObject)
    TimestampedObjectOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TimestampedObject.newBuilder() to construct.
  private TimestampedObject(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TimestampedObject() {
    attributes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TimestampedObject();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private TimestampedObject(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox.Builder
                  subBuilder = null;
              if (normalizedBoundingBox_ != null) {
                subBuilder = normalizedBoundingBox_.toBuilder();
              }
              normalizedBoundingBox_ =
                  input.readMessage(
                      com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(normalizedBoundingBox_);
                normalizedBoundingBox_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (timeOffset_ != null) {
                subBuilder = timeOffset_.toBuilder();
              }
              timeOffset_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(timeOffset_);
                timeOffset_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                attributes_ =
                    new java.util.ArrayList<
                        com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute>();
                mutable_bitField0_ |= 0x00000001;
              }
              attributes_.add(
                  input.readMessage(
                      com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute.parser(),
                      extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        attributes_ = java.util.Collections.unmodifiableList(attributes_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p3beta1_TimestampedObject_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p3beta1_TimestampedObject_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1p3beta1.TimestampedObject.class,
            com.google.cloud.videointelligence.v1p3beta1.TimestampedObject.Builder.class);
  }

  public static final int NORMALIZED_BOUNDING_BOX_FIELD_NUMBER = 1;
  private com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox normalizedBoundingBox_;
  /**
   *
   *
   * <pre>
   * Normalized Bounding box in a frame, where the object is located.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox normalized_bounding_box = 1;
   * </code>
   *
   * @return Whether the normalizedBoundingBox field is set.
   */
  public boolean hasNormalizedBoundingBox() {
    return normalizedBoundingBox_ != null;
  }
  /**
   *
   *
   * <pre>
   * Normalized Bounding box in a frame, where the object is located.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox normalized_bounding_box = 1;
   * </code>
   *
   * @return The normalizedBoundingBox.
   */
  public com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox
      getNormalizedBoundingBox() {
    return normalizedBoundingBox_ == null
        ? com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox.getDefaultInstance()
        : normalizedBoundingBox_;
  }
  /**
   *
   *
   * <pre>
   * Normalized Bounding box in a frame, where the object is located.
   * </pre>
   *
   * <code>
   * .google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox normalized_bounding_box = 1;
   * </code>
   */
  public com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBoxOrBuilder
      getNormalizedBoundingBoxOrBuilder() {
    return getNormalizedBoundingBox();
  }

  public static final int TIME_OFFSET_FIELD_NUMBER = 2;
  private com.google.protobuf.Duration timeOffset_;
  /**
   *
   *
   * <pre>
   * Time-offset, relative to the beginning of the video,
   * corresponding to the video frame for this object.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_offset = 2;</code>
   *
   * @return Whether the timeOffset field is set.
   */
  public boolean hasTimeOffset() {
    return timeOffset_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time-offset, relative to the beginning of the video,
   * corresponding to the video frame for this object.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_offset = 2;</code>
   *
   * @return The timeOffset.
   */
  public com.google.protobuf.Duration getTimeOffset() {
    return timeOffset_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeOffset_;
  }
  /**
   *
   *
   * <pre>
   * Time-offset, relative to the beginning of the video,
   * corresponding to the video frame for this object.
   * </pre>
   *
   * <code>.google.protobuf.Duration time_offset = 2;</code>
   */
  public com.google.protobuf.DurationOrBuilder getTimeOffsetOrBuilder() {
    return getTimeOffset();
  }

  public static final int ATTRIBUTES_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute>
      attributes_;
  /**
   *
   *
   * <pre>
   * Optional. The attributes of the object in the bounding box.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public java.util.List<com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute>
      getAttributesList() {
    return attributes_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The attributes of the object in the bounding box.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1p3beta1.DetectedAttributeOrBuilder>
      getAttributesOrBuilderList() {
    return attributes_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The attributes of the object in the bounding box.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public int getAttributesCount() {
    return attributes_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The attributes of the object in the bounding box.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute getAttributes(int index) {
    return attributes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The attributes of the object in the bounding box.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  public com.google.cloud.videointelligence.v1p3beta1.DetectedAttributeOrBuilder
      getAttributesOrBuilder(int index) {
    return attributes_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (normalizedBoundingBox_ != null) {
      output.writeMessage(1, getNormalizedBoundingBox());
    }
    if (timeOffset_ != null) {
      output.writeMessage(2, getTimeOffset());
    }
    for (int i = 0; i < attributes_.size(); i++) {
      output.writeMessage(3, attributes_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (normalizedBoundingBox_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, getNormalizedBoundingBox());
    }
    if (timeOffset_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTimeOffset());
    }
    for (int i = 0; i < attributes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, attributes_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.videointelligence.v1p3beta1.TimestampedObject)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1p3beta1.TimestampedObject other =
        (com.google.cloud.videointelligence.v1p3beta1.TimestampedObject) obj;

    if (hasNormalizedBoundingBox() != other.hasNormalizedBoundingBox()) return false;
    if (hasNormalizedBoundingBox()) {
      if (!getNormalizedBoundingBox().equals(other.getNormalizedBoundingBox())) return false;
    }
    if (hasTimeOffset() != other.hasTimeOffset()) return false;
    if (hasTimeOffset()) {
      if (!getTimeOffset().equals(other.getTimeOffset())) return false;
    }
    if (!getAttributesList().equals(other.getAttributesList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasNormalizedBoundingBox()) {
      hash = (37 * hash) + NORMALIZED_BOUNDING_BOX_FIELD_NUMBER;
      hash = (53 * hash) + getNormalizedBoundingBox().hashCode();
    }
    if (hasTimeOffset()) {
      hash = (37 * hash) + TIME_OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + getTimeOffset().hashCode();
    }
    if (getAttributesCount() > 0) {
      hash = (37 * hash) + ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + getAttributesList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1p3beta1.TimestampedObject parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.TimestampedObject parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.TimestampedObject parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.TimestampedObject parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.TimestampedObject parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.TimestampedObject parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.TimestampedObject parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.TimestampedObject parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.TimestampedObject parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.TimestampedObject parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.TimestampedObject parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.TimestampedObject parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.videointelligence.v1p3beta1.TimestampedObject prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * For tracking related features.
   * An object at time_offset with attributes, and located with
   * normalized_bounding_box.
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1p3beta1.TimestampedObject}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1p3beta1.TimestampedObject)
      com.google.cloud.videointelligence.v1p3beta1.TimestampedObjectOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_TimestampedObject_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_TimestampedObject_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1p3beta1.TimestampedObject.class,
              com.google.cloud.videointelligence.v1p3beta1.TimestampedObject.Builder.class);
    }

    // Construct using com.google.cloud.videointelligence.v1p3beta1.TimestampedObject.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAttributesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (normalizedBoundingBoxBuilder_ == null) {
        normalizedBoundingBox_ = null;
      } else {
        normalizedBoundingBox_ = null;
        normalizedBoundingBoxBuilder_ = null;
      }
      if (timeOffsetBuilder_ == null) {
        timeOffset_ = null;
      } else {
        timeOffset_ = null;
        timeOffsetBuilder_ = null;
      }
      if (attributesBuilder_ == null) {
        attributes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        attributesBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_TimestampedObject_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.TimestampedObject
        getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1p3beta1.TimestampedObject.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.TimestampedObject build() {
      com.google.cloud.videointelligence.v1p3beta1.TimestampedObject result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.TimestampedObject buildPartial() {
      com.google.cloud.videointelligence.v1p3beta1.TimestampedObject result =
          new com.google.cloud.videointelligence.v1p3beta1.TimestampedObject(this);
      int from_bitField0_ = bitField0_;
      if (normalizedBoundingBoxBuilder_ == null) {
        result.normalizedBoundingBox_ = normalizedBoundingBox_;
      } else {
        result.normalizedBoundingBox_ = normalizedBoundingBoxBuilder_.build();
      }
      if (timeOffsetBuilder_ == null) {
        result.timeOffset_ = timeOffset_;
      } else {
        result.timeOffset_ = timeOffsetBuilder_.build();
      }
      if (attributesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          attributes_ = java.util.Collections.unmodifiableList(attributes_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.attributes_ = attributes_;
      } else {
        result.attributes_ = attributesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.videointelligence.v1p3beta1.TimestampedObject) {
        return mergeFrom((com.google.cloud.videointelligence.v1p3beta1.TimestampedObject) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.videointelligence.v1p3beta1.TimestampedObject other) {
      if (other
          == com.google.cloud.videointelligence.v1p3beta1.TimestampedObject.getDefaultInstance())
        return this;
      if (other.hasNormalizedBoundingBox()) {
        mergeNormalizedBoundingBox(other.getNormalizedBoundingBox());
      }
      if (other.hasTimeOffset()) {
        mergeTimeOffset(other.getTimeOffset());
      }
      if (attributesBuilder_ == null) {
        if (!other.attributes_.isEmpty()) {
          if (attributes_.isEmpty()) {
            attributes_ = other.attributes_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAttributesIsMutable();
            attributes_.addAll(other.attributes_);
          }
          onChanged();
        }
      } else {
        if (!other.attributes_.isEmpty()) {
          if (attributesBuilder_.isEmpty()) {
            attributesBuilder_.dispose();
            attributesBuilder_ = null;
            attributes_ = other.attributes_;
            bitField0_ = (bitField0_ & ~0x00000001);
            attributesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAttributesFieldBuilder()
                    : null;
          } else {
            attributesBuilder_.addAllMessages(other.attributes_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.videointelligence.v1p3beta1.TimestampedObject parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.videointelligence.v1p3beta1.TimestampedObject)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox
        normalizedBoundingBox_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox,
            com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox.Builder,
            com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBoxOrBuilder>
        normalizedBoundingBoxBuilder_;
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     *
     * @return Whether the normalizedBoundingBox field is set.
     */
    public boolean hasNormalizedBoundingBox() {
      return normalizedBoundingBoxBuilder_ != null || normalizedBoundingBox_ != null;
    }
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     *
     * @return The normalizedBoundingBox.
     */
    public com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox
        getNormalizedBoundingBox() {
      if (normalizedBoundingBoxBuilder_ == null) {
        return normalizedBoundingBox_ == null
            ? com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox
                .getDefaultInstance()
            : normalizedBoundingBox_;
      } else {
        return normalizedBoundingBoxBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     */
    public Builder setNormalizedBoundingBox(
        com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox value) {
      if (normalizedBoundingBoxBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        normalizedBoundingBox_ = value;
        onChanged();
      } else {
        normalizedBoundingBoxBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     */
    public Builder setNormalizedBoundingBox(
        com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox.Builder
            builderForValue) {
      if (normalizedBoundingBoxBuilder_ == null) {
        normalizedBoundingBox_ = builderForValue.build();
        onChanged();
      } else {
        normalizedBoundingBoxBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     */
    public Builder mergeNormalizedBoundingBox(
        com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox value) {
      if (normalizedBoundingBoxBuilder_ == null) {
        if (normalizedBoundingBox_ != null) {
          normalizedBoundingBox_ =
              com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox.newBuilder(
                      normalizedBoundingBox_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          normalizedBoundingBox_ = value;
        }
        onChanged();
      } else {
        normalizedBoundingBoxBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     */
    public Builder clearNormalizedBoundingBox() {
      if (normalizedBoundingBoxBuilder_ == null) {
        normalizedBoundingBox_ = null;
        onChanged();
      } else {
        normalizedBoundingBox_ = null;
        normalizedBoundingBoxBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox.Builder
        getNormalizedBoundingBoxBuilder() {

      onChanged();
      return getNormalizedBoundingBoxFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBoxOrBuilder
        getNormalizedBoundingBoxOrBuilder() {
      if (normalizedBoundingBoxBuilder_ != null) {
        return normalizedBoundingBoxBuilder_.getMessageOrBuilder();
      } else {
        return normalizedBoundingBox_ == null
            ? com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox
                .getDefaultInstance()
            : normalizedBoundingBox_;
      }
    }
    /**
     *
     *
     * <pre>
     * Normalized Bounding box in a frame, where the object is located.
     * </pre>
     *
     * <code>
     * .google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox normalized_bounding_box = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox,
            com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox.Builder,
            com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBoxOrBuilder>
        getNormalizedBoundingBoxFieldBuilder() {
      if (normalizedBoundingBoxBuilder_ == null) {
        normalizedBoundingBoxBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox,
                com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox.Builder,
                com.google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBoxOrBuilder>(
                getNormalizedBoundingBox(), getParentForChildren(), isClean());
        normalizedBoundingBox_ = null;
      }
      return normalizedBoundingBoxBuilder_;
    }

    private com.google.protobuf.Duration timeOffset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeOffsetBuilder_;
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     *
     * @return Whether the timeOffset field is set.
     */
    public boolean hasTimeOffset() {
      return timeOffsetBuilder_ != null || timeOffset_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     *
     * @return The timeOffset.
     */
    public com.google.protobuf.Duration getTimeOffset() {
      if (timeOffsetBuilder_ == null) {
        return timeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeOffset_;
      } else {
        return timeOffsetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public Builder setTimeOffset(com.google.protobuf.Duration value) {
      if (timeOffsetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeOffset_ = value;
        onChanged();
      } else {
        timeOffsetBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public Builder setTimeOffset(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeOffsetBuilder_ == null) {
        timeOffset_ = builderForValue.build();
        onChanged();
      } else {
        timeOffsetBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public Builder mergeTimeOffset(com.google.protobuf.Duration value) {
      if (timeOffsetBuilder_ == null) {
        if (timeOffset_ != null) {
          timeOffset_ =
              com.google.protobuf.Duration.newBuilder(timeOffset_).mergeFrom(value).buildPartial();
        } else {
          timeOffset_ = value;
        }
        onChanged();
      } else {
        timeOffsetBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public Builder clearTimeOffset() {
      if (timeOffsetBuilder_ == null) {
        timeOffset_ = null;
        onChanged();
      } else {
        timeOffset_ = null;
        timeOffsetBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeOffsetBuilder() {

      onChanged();
      return getTimeOffsetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeOffsetOrBuilder() {
      if (timeOffsetBuilder_ != null) {
        return timeOffsetBuilder_.getMessageOrBuilder();
      } else {
        return timeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : timeOffset_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time-offset, relative to the beginning of the video,
     * corresponding to the video frame for this object.
     * </pre>
     *
     * <code>.google.protobuf.Duration time_offset = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeOffsetFieldBuilder() {
      if (timeOffsetBuilder_ == null) {
        timeOffsetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeOffset(), getParentForChildren(), isClean());
        timeOffset_ = null;
      }
      return timeOffsetBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute>
        attributes_ = java.util.Collections.emptyList();

    private void ensureAttributesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        attributes_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute>(
                attributes_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute,
            com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute.Builder,
            com.google.cloud.videointelligence.v1p3beta1.DetectedAttributeOrBuilder>
        attributesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute>
        getAttributesList() {
      if (attributesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(attributes_);
      } else {
        return attributesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getAttributesCount() {
      if (attributesBuilder_ == null) {
        return attributes_.size();
      } else {
        return attributesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute getAttributes(int index) {
      if (attributesBuilder_ == null) {
        return attributes_.get(index);
      } else {
        return attributesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAttributes(
        int index, com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute value) {
      if (attributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributesIsMutable();
        attributes_.set(index, value);
        onChanged();
      } else {
        attributesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAttributes(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute.Builder builderForValue) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        attributes_.set(index, builderForValue.build());
        onChanged();
      } else {
        attributesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAttributes(
        com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute value) {
      if (attributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributesIsMutable();
        attributes_.add(value);
        onChanged();
      } else {
        attributesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAttributes(
        int index, com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute value) {
      if (attributesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttributesIsMutable();
        attributes_.add(index, value);
        onChanged();
      } else {
        attributesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAttributes(
        com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute.Builder builderForValue) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        attributes_.add(builderForValue.build());
        onChanged();
      } else {
        attributesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAttributes(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute.Builder builderForValue) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        attributes_.add(index, builderForValue.build());
        onChanged();
      } else {
        attributesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllAttributes(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute>
            values) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, attributes_);
        onChanged();
      } else {
        attributesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAttributes() {
      if (attributesBuilder_ == null) {
        attributes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        attributesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAttributes(int index) {
      if (attributesBuilder_ == null) {
        ensureAttributesIsMutable();
        attributes_.remove(index);
        onChanged();
      } else {
        attributesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute.Builder
        getAttributesBuilder(int index) {
      return getAttributesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.DetectedAttributeOrBuilder
        getAttributesOrBuilder(int index) {
      if (attributesBuilder_ == null) {
        return attributes_.get(index);
      } else {
        return attributesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1p3beta1.DetectedAttributeOrBuilder>
        getAttributesOrBuilderList() {
      if (attributesBuilder_ != null) {
        return attributesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(attributes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute.Builder
        addAttributesBuilder() {
      return getAttributesFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute.Builder
        addAttributesBuilder(int index) {
      return getAttributesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The attributes of the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.DetectedAttribute attributes = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute.Builder>
        getAttributesBuilderList() {
      return getAttributesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute,
            com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute.Builder,
            com.google.cloud.videointelligence.v1p3beta1.DetectedAttributeOrBuilder>
        getAttributesFieldBuilder() {
      if (attributesBuilder_ == null) {
        attributesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute,
                com.google.cloud.videointelligence.v1p3beta1.DetectedAttribute.Builder,
                com.google.cloud.videointelligence.v1p3beta1.DetectedAttributeOrBuilder>(
                attributes_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        attributes_ = null;
      }
      return attributesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1p3beta1.TimestampedObject)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1p3beta1.TimestampedObject)
  private static final com.google.cloud.videointelligence.v1p3beta1.TimestampedObject
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.videointelligence.v1p3beta1.TimestampedObject();
  }

  public static com.google.cloud.videointelligence.v1p3beta1.TimestampedObject
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TimestampedObject> PARSER =
      new com.google.protobuf.AbstractParser<TimestampedObject>() {
        @java.lang.Override
        public TimestampedObject parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new TimestampedObject(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<TimestampedObject> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TimestampedObject> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.TimestampedObject
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
