/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1p3beta1/video_intelligence.proto

package com.google.cloud.videointelligence.v1p3beta1;

/**
 *
 *
 * <pre>
 * Label annotation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1p3beta1.LabelAnnotation}
 */
public final class LabelAnnotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1p3beta1.LabelAnnotation)
    LabelAnnotationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LabelAnnotation.newBuilder() to construct.
  private LabelAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LabelAnnotation() {
    categoryEntities_ = java.util.Collections.emptyList();
    segments_ = java.util.Collections.emptyList();
    frames_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LabelAnnotation();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private LabelAnnotation(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.videointelligence.v1p3beta1.Entity.Builder subBuilder = null;
              if (entity_ != null) {
                subBuilder = entity_.toBuilder();
              }
              entity_ =
                  input.readMessage(
                      com.google.cloud.videointelligence.v1p3beta1.Entity.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(entity_);
                entity_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                categoryEntities_ =
                    new java.util.ArrayList<com.google.cloud.videointelligence.v1p3beta1.Entity>();
                mutable_bitField0_ |= 0x00000001;
              }
              categoryEntities_.add(
                  input.readMessage(
                      com.google.cloud.videointelligence.v1p3beta1.Entity.parser(),
                      extensionRegistry));
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                segments_ =
                    new java.util.ArrayList<
                        com.google.cloud.videointelligence.v1p3beta1.LabelSegment>();
                mutable_bitField0_ |= 0x00000002;
              }
              segments_.add(
                  input.readMessage(
                      com.google.cloud.videointelligence.v1p3beta1.LabelSegment.parser(),
                      extensionRegistry));
              break;
            }
          case 34:
            {
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                frames_ =
                    new java.util.ArrayList<
                        com.google.cloud.videointelligence.v1p3beta1.LabelFrame>();
                mutable_bitField0_ |= 0x00000004;
              }
              frames_.add(
                  input.readMessage(
                      com.google.cloud.videointelligence.v1p3beta1.LabelFrame.parser(),
                      extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        categoryEntities_ = java.util.Collections.unmodifiableList(categoryEntities_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        segments_ = java.util.Collections.unmodifiableList(segments_);
      }
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        frames_ = java.util.Collections.unmodifiableList(frames_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p3beta1_LabelAnnotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p3beta1_LabelAnnotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.class,
            com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.Builder.class);
  }

  public static final int ENTITY_FIELD_NUMBER = 1;
  private com.google.cloud.videointelligence.v1p3beta1.Entity entity_;
  /**
   *
   *
   * <pre>
   * Detected entity.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
   *
   * @return Whether the entity field is set.
   */
  @java.lang.Override
  public boolean hasEntity() {
    return entity_ != null;
  }
  /**
   *
   *
   * <pre>
   * Detected entity.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
   *
   * @return The entity.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.Entity getEntity() {
    return entity_ == null
        ? com.google.cloud.videointelligence.v1p3beta1.Entity.getDefaultInstance()
        : entity_;
  }
  /**
   *
   *
   * <pre>
   * Detected entity.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.EntityOrBuilder getEntityOrBuilder() {
    return getEntity();
  }

  public static final int CATEGORY_ENTITIES_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.videointelligence.v1p3beta1.Entity> categoryEntities_;
  /**
   *
   *
   * <pre>
   * Common categories for the detected entity.
   * For example, when the label is `Terrier`, the category is likely `dog`. And
   * in some cases there might be more than one categories e.g., `Terrier` could
   * also be a `pet`.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1p3beta1.Entity>
      getCategoryEntitiesList() {
    return categoryEntities_;
  }
  /**
   *
   *
   * <pre>
   * Common categories for the detected entity.
   * For example, when the label is `Terrier`, the category is likely `dog`. And
   * in some cases there might be more than one categories e.g., `Terrier` could
   * also be a `pet`.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1p3beta1.EntityOrBuilder>
      getCategoryEntitiesOrBuilderList() {
    return categoryEntities_;
  }
  /**
   *
   *
   * <pre>
   * Common categories for the detected entity.
   * For example, when the label is `Terrier`, the category is likely `dog`. And
   * in some cases there might be more than one categories e.g., `Terrier` could
   * also be a `pet`.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
   */
  @java.lang.Override
  public int getCategoryEntitiesCount() {
    return categoryEntities_.size();
  }
  /**
   *
   *
   * <pre>
   * Common categories for the detected entity.
   * For example, when the label is `Terrier`, the category is likely `dog`. And
   * in some cases there might be more than one categories e.g., `Terrier` could
   * also be a `pet`.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.Entity getCategoryEntities(int index) {
    return categoryEntities_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Common categories for the detected entity.
   * For example, when the label is `Terrier`, the category is likely `dog`. And
   * in some cases there might be more than one categories e.g., `Terrier` could
   * also be a `pet`.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.EntityOrBuilder getCategoryEntitiesOrBuilder(
      int index) {
    return categoryEntities_.get(index);
  }

  public static final int SEGMENTS_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.videointelligence.v1p3beta1.LabelSegment> segments_;
  /**
   *
   *
   * <pre>
   * All video segments where a label was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1p3beta1.LabelSegment>
      getSegmentsList() {
    return segments_;
  }
  /**
   *
   *
   * <pre>
   * All video segments where a label was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1p3beta1.LabelSegmentOrBuilder>
      getSegmentsOrBuilderList() {
    return segments_;
  }
  /**
   *
   *
   * <pre>
   * All video segments where a label was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
   */
  @java.lang.Override
  public int getSegmentsCount() {
    return segments_.size();
  }
  /**
   *
   *
   * <pre>
   * All video segments where a label was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.LabelSegment getSegments(int index) {
    return segments_.get(index);
  }
  /**
   *
   *
   * <pre>
   * All video segments where a label was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.LabelSegmentOrBuilder getSegmentsOrBuilder(
      int index) {
    return segments_.get(index);
  }

  public static final int FRAMES_FIELD_NUMBER = 4;
  private java.util.List<com.google.cloud.videointelligence.v1p3beta1.LabelFrame> frames_;
  /**
   *
   *
   * <pre>
   * All video frames where a label was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1p3beta1.LabelFrame> getFramesList() {
    return frames_;
  }
  /**
   *
   *
   * <pre>
   * All video frames where a label was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1p3beta1.LabelFrameOrBuilder>
      getFramesOrBuilderList() {
    return frames_;
  }
  /**
   *
   *
   * <pre>
   * All video frames where a label was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
   */
  @java.lang.Override
  public int getFramesCount() {
    return frames_.size();
  }
  /**
   *
   *
   * <pre>
   * All video frames where a label was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.LabelFrame getFrames(int index) {
    return frames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * All video frames where a label was detected.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.LabelFrameOrBuilder getFramesOrBuilder(
      int index) {
    return frames_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (entity_ != null) {
      output.writeMessage(1, getEntity());
    }
    for (int i = 0; i < categoryEntities_.size(); i++) {
      output.writeMessage(2, categoryEntities_.get(i));
    }
    for (int i = 0; i < segments_.size(); i++) {
      output.writeMessage(3, segments_.get(i));
    }
    for (int i = 0; i < frames_.size(); i++) {
      output.writeMessage(4, frames_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (entity_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEntity());
    }
    for (int i = 0; i < categoryEntities_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, categoryEntities_.get(i));
    }
    for (int i = 0; i < segments_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, segments_.get(i));
    }
    for (int i = 0; i < frames_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, frames_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation other =
        (com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation) obj;

    if (hasEntity() != other.hasEntity()) return false;
    if (hasEntity()) {
      if (!getEntity().equals(other.getEntity())) return false;
    }
    if (!getCategoryEntitiesList().equals(other.getCategoryEntitiesList())) return false;
    if (!getSegmentsList().equals(other.getSegmentsList())) return false;
    if (!getFramesList().equals(other.getFramesList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasEntity()) {
      hash = (37 * hash) + ENTITY_FIELD_NUMBER;
      hash = (53 * hash) + getEntity().hashCode();
    }
    if (getCategoryEntitiesCount() > 0) {
      hash = (37 * hash) + CATEGORY_ENTITIES_FIELD_NUMBER;
      hash = (53 * hash) + getCategoryEntitiesList().hashCode();
    }
    if (getSegmentsCount() > 0) {
      hash = (37 * hash) + SEGMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getSegmentsList().hashCode();
    }
    if (getFramesCount() > 0) {
      hash = (37 * hash) + FRAMES_FIELD_NUMBER;
      hash = (53 * hash) + getFramesList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Label annotation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1p3beta1.LabelAnnotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1p3beta1.LabelAnnotation)
      com.google.cloud.videointelligence.v1p3beta1.LabelAnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_LabelAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_LabelAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.class,
              com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.Builder.class);
    }

    // Construct using com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCategoryEntitiesFieldBuilder();
        getSegmentsFieldBuilder();
        getFramesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (entityBuilder_ == null) {
        entity_ = null;
      } else {
        entity_ = null;
        entityBuilder_ = null;
      }
      if (categoryEntitiesBuilder_ == null) {
        categoryEntities_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        categoryEntitiesBuilder_.clear();
      }
      if (segmentsBuilder_ == null) {
        segments_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        segmentsBuilder_.clear();
      }
      if (framesBuilder_ == null) {
        frames_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
      } else {
        framesBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_LabelAnnotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation
        getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation build() {
      com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation buildPartial() {
      com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation result =
          new com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation(this);
      int from_bitField0_ = bitField0_;
      if (entityBuilder_ == null) {
        result.entity_ = entity_;
      } else {
        result.entity_ = entityBuilder_.build();
      }
      if (categoryEntitiesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          categoryEntities_ = java.util.Collections.unmodifiableList(categoryEntities_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.categoryEntities_ = categoryEntities_;
      } else {
        result.categoryEntities_ = categoryEntitiesBuilder_.build();
      }
      if (segmentsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          segments_ = java.util.Collections.unmodifiableList(segments_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.segments_ = segments_;
      } else {
        result.segments_ = segmentsBuilder_.build();
      }
      if (framesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          frames_ = java.util.Collections.unmodifiableList(frames_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.frames_ = frames_;
      } else {
        result.frames_ = framesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation) {
        return mergeFrom((com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation other) {
      if (other
          == com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation.getDefaultInstance())
        return this;
      if (other.hasEntity()) {
        mergeEntity(other.getEntity());
      }
      if (categoryEntitiesBuilder_ == null) {
        if (!other.categoryEntities_.isEmpty()) {
          if (categoryEntities_.isEmpty()) {
            categoryEntities_ = other.categoryEntities_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureCategoryEntitiesIsMutable();
            categoryEntities_.addAll(other.categoryEntities_);
          }
          onChanged();
        }
      } else {
        if (!other.categoryEntities_.isEmpty()) {
          if (categoryEntitiesBuilder_.isEmpty()) {
            categoryEntitiesBuilder_.dispose();
            categoryEntitiesBuilder_ = null;
            categoryEntities_ = other.categoryEntities_;
            bitField0_ = (bitField0_ & ~0x00000001);
            categoryEntitiesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCategoryEntitiesFieldBuilder()
                    : null;
          } else {
            categoryEntitiesBuilder_.addAllMessages(other.categoryEntities_);
          }
        }
      }
      if (segmentsBuilder_ == null) {
        if (!other.segments_.isEmpty()) {
          if (segments_.isEmpty()) {
            segments_ = other.segments_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSegmentsIsMutable();
            segments_.addAll(other.segments_);
          }
          onChanged();
        }
      } else {
        if (!other.segments_.isEmpty()) {
          if (segmentsBuilder_.isEmpty()) {
            segmentsBuilder_.dispose();
            segmentsBuilder_ = null;
            segments_ = other.segments_;
            bitField0_ = (bitField0_ & ~0x00000002);
            segmentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSegmentsFieldBuilder()
                    : null;
          } else {
            segmentsBuilder_.addAllMessages(other.segments_);
          }
        }
      }
      if (framesBuilder_ == null) {
        if (!other.frames_.isEmpty()) {
          if (frames_.isEmpty()) {
            frames_ = other.frames_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureFramesIsMutable();
            frames_.addAll(other.frames_);
          }
          onChanged();
        }
      } else {
        if (!other.frames_.isEmpty()) {
          if (framesBuilder_.isEmpty()) {
            framesBuilder_.dispose();
            framesBuilder_ = null;
            frames_ = other.frames_;
            bitField0_ = (bitField0_ & ~0x00000004);
            framesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFramesFieldBuilder()
                    : null;
          } else {
            framesBuilder_.addAllMessages(other.frames_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.cloud.videointelligence.v1p3beta1.Entity entity_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.Entity,
            com.google.cloud.videointelligence.v1p3beta1.Entity.Builder,
            com.google.cloud.videointelligence.v1p3beta1.EntityOrBuilder>
        entityBuilder_;
    /**
     *
     *
     * <pre>
     * Detected entity.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     *
     * @return Whether the entity field is set.
     */
    public boolean hasEntity() {
      return entityBuilder_ != null || entity_ != null;
    }
    /**
     *
     *
     * <pre>
     * Detected entity.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     *
     * @return The entity.
     */
    public com.google.cloud.videointelligence.v1p3beta1.Entity getEntity() {
      if (entityBuilder_ == null) {
        return entity_ == null
            ? com.google.cloud.videointelligence.v1p3beta1.Entity.getDefaultInstance()
            : entity_;
      } else {
        return entityBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Detected entity.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     */
    public Builder setEntity(com.google.cloud.videointelligence.v1p3beta1.Entity value) {
      if (entityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entity_ = value;
        onChanged();
      } else {
        entityBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Detected entity.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     */
    public Builder setEntity(
        com.google.cloud.videointelligence.v1p3beta1.Entity.Builder builderForValue) {
      if (entityBuilder_ == null) {
        entity_ = builderForValue.build();
        onChanged();
      } else {
        entityBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Detected entity.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     */
    public Builder mergeEntity(com.google.cloud.videointelligence.v1p3beta1.Entity value) {
      if (entityBuilder_ == null) {
        if (entity_ != null) {
          entity_ =
              com.google.cloud.videointelligence.v1p3beta1.Entity.newBuilder(entity_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          entity_ = value;
        }
        onChanged();
      } else {
        entityBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Detected entity.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     */
    public Builder clearEntity() {
      if (entityBuilder_ == null) {
        entity_ = null;
        onChanged();
      } else {
        entity_ = null;
        entityBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Detected entity.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.Entity.Builder getEntityBuilder() {

      onChanged();
      return getEntityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Detected entity.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.EntityOrBuilder getEntityOrBuilder() {
      if (entityBuilder_ != null) {
        return entityBuilder_.getMessageOrBuilder();
      } else {
        return entity_ == null
            ? com.google.cloud.videointelligence.v1p3beta1.Entity.getDefaultInstance()
            : entity_;
      }
    }
    /**
     *
     *
     * <pre>
     * Detected entity.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1p3beta1.Entity entity = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.Entity,
            com.google.cloud.videointelligence.v1p3beta1.Entity.Builder,
            com.google.cloud.videointelligence.v1p3beta1.EntityOrBuilder>
        getEntityFieldBuilder() {
      if (entityBuilder_ == null) {
        entityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1p3beta1.Entity,
                com.google.cloud.videointelligence.v1p3beta1.Entity.Builder,
                com.google.cloud.videointelligence.v1p3beta1.EntityOrBuilder>(
                getEntity(), getParentForChildren(), isClean());
        entity_ = null;
      }
      return entityBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1p3beta1.Entity> categoryEntities_ =
        java.util.Collections.emptyList();

    private void ensureCategoryEntitiesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        categoryEntities_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1p3beta1.Entity>(
                categoryEntities_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.Entity,
            com.google.cloud.videointelligence.v1p3beta1.Entity.Builder,
            com.google.cloud.videointelligence.v1p3beta1.EntityOrBuilder>
        categoryEntitiesBuilder_;

    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.Entity>
        getCategoryEntitiesList() {
      if (categoryEntitiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(categoryEntities_);
      } else {
        return categoryEntitiesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public int getCategoryEntitiesCount() {
      if (categoryEntitiesBuilder_ == null) {
        return categoryEntities_.size();
      } else {
        return categoryEntitiesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.Entity getCategoryEntities(int index) {
      if (categoryEntitiesBuilder_ == null) {
        return categoryEntities_.get(index);
      } else {
        return categoryEntitiesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public Builder setCategoryEntities(
        int index, com.google.cloud.videointelligence.v1p3beta1.Entity value) {
      if (categoryEntitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCategoryEntitiesIsMutable();
        categoryEntities_.set(index, value);
        onChanged();
      } else {
        categoryEntitiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public Builder setCategoryEntities(
        int index, com.google.cloud.videointelligence.v1p3beta1.Entity.Builder builderForValue) {
      if (categoryEntitiesBuilder_ == null) {
        ensureCategoryEntitiesIsMutable();
        categoryEntities_.set(index, builderForValue.build());
        onChanged();
      } else {
        categoryEntitiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public Builder addCategoryEntities(com.google.cloud.videointelligence.v1p3beta1.Entity value) {
      if (categoryEntitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCategoryEntitiesIsMutable();
        categoryEntities_.add(value);
        onChanged();
      } else {
        categoryEntitiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public Builder addCategoryEntities(
        int index, com.google.cloud.videointelligence.v1p3beta1.Entity value) {
      if (categoryEntitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCategoryEntitiesIsMutable();
        categoryEntities_.add(index, value);
        onChanged();
      } else {
        categoryEntitiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public Builder addCategoryEntities(
        com.google.cloud.videointelligence.v1p3beta1.Entity.Builder builderForValue) {
      if (categoryEntitiesBuilder_ == null) {
        ensureCategoryEntitiesIsMutable();
        categoryEntities_.add(builderForValue.build());
        onChanged();
      } else {
        categoryEntitiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public Builder addCategoryEntities(
        int index, com.google.cloud.videointelligence.v1p3beta1.Entity.Builder builderForValue) {
      if (categoryEntitiesBuilder_ == null) {
        ensureCategoryEntitiesIsMutable();
        categoryEntities_.add(index, builderForValue.build());
        onChanged();
      } else {
        categoryEntitiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public Builder addAllCategoryEntities(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1p3beta1.Entity> values) {
      if (categoryEntitiesBuilder_ == null) {
        ensureCategoryEntitiesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, categoryEntities_);
        onChanged();
      } else {
        categoryEntitiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public Builder clearCategoryEntities() {
      if (categoryEntitiesBuilder_ == null) {
        categoryEntities_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        categoryEntitiesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public Builder removeCategoryEntities(int index) {
      if (categoryEntitiesBuilder_ == null) {
        ensureCategoryEntitiesIsMutable();
        categoryEntities_.remove(index);
        onChanged();
      } else {
        categoryEntitiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.Entity.Builder getCategoryEntitiesBuilder(
        int index) {
      return getCategoryEntitiesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.EntityOrBuilder
        getCategoryEntitiesOrBuilder(int index) {
      if (categoryEntitiesBuilder_ == null) {
        return categoryEntities_.get(index);
      } else {
        return categoryEntitiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.videointelligence.v1p3beta1.EntityOrBuilder>
        getCategoryEntitiesOrBuilderList() {
      if (categoryEntitiesBuilder_ != null) {
        return categoryEntitiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(categoryEntities_);
      }
    }
    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.Entity.Builder
        addCategoryEntitiesBuilder() {
      return getCategoryEntitiesFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1p3beta1.Entity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.Entity.Builder addCategoryEntitiesBuilder(
        int index) {
      return getCategoryEntitiesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1p3beta1.Entity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Common categories for the detected entity.
     * For example, when the label is `Terrier`, the category is likely `dog`. And
     * in some cases there might be more than one categories e.g., `Terrier` could
     * also be a `pet`.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.Entity category_entities = 2;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.Entity.Builder>
        getCategoryEntitiesBuilderList() {
      return getCategoryEntitiesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.Entity,
            com.google.cloud.videointelligence.v1p3beta1.Entity.Builder,
            com.google.cloud.videointelligence.v1p3beta1.EntityOrBuilder>
        getCategoryEntitiesFieldBuilder() {
      if (categoryEntitiesBuilder_ == null) {
        categoryEntitiesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p3beta1.Entity,
                com.google.cloud.videointelligence.v1p3beta1.Entity.Builder,
                com.google.cloud.videointelligence.v1p3beta1.EntityOrBuilder>(
                categoryEntities_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        categoryEntities_ = null;
      }
      return categoryEntitiesBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1p3beta1.LabelSegment> segments_ =
        java.util.Collections.emptyList();

    private void ensureSegmentsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        segments_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1p3beta1.LabelSegment>(
                segments_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.LabelSegment,
            com.google.cloud.videointelligence.v1p3beta1.LabelSegment.Builder,
            com.google.cloud.videointelligence.v1p3beta1.LabelSegmentOrBuilder>
        segmentsBuilder_;

    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.LabelSegment>
        getSegmentsList() {
      if (segmentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(segments_);
      } else {
        return segmentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public int getSegmentsCount() {
      if (segmentsBuilder_ == null) {
        return segments_.size();
      } else {
        return segmentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.LabelSegment getSegments(int index) {
      if (segmentsBuilder_ == null) {
        return segments_.get(index);
      } else {
        return segmentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public Builder setSegments(
        int index, com.google.cloud.videointelligence.v1p3beta1.LabelSegment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.set(index, value);
        onChanged();
      } else {
        segmentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public Builder setSegments(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.LabelSegment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.set(index, builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public Builder addSegments(com.google.cloud.videointelligence.v1p3beta1.LabelSegment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.add(value);
        onChanged();
      } else {
        segmentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public Builder addSegments(
        int index, com.google.cloud.videointelligence.v1p3beta1.LabelSegment value) {
      if (segmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentsIsMutable();
        segments_.add(index, value);
        onChanged();
      } else {
        segmentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public Builder addSegments(
        com.google.cloud.videointelligence.v1p3beta1.LabelSegment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.add(builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public Builder addSegments(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.LabelSegment.Builder builderForValue) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.add(index, builderForValue.build());
        onChanged();
      } else {
        segmentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public Builder addAllSegments(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1p3beta1.LabelSegment>
            values) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, segments_);
        onChanged();
      } else {
        segmentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public Builder clearSegments() {
      if (segmentsBuilder_ == null) {
        segments_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        segmentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public Builder removeSegments(int index) {
      if (segmentsBuilder_ == null) {
        ensureSegmentsIsMutable();
        segments_.remove(index);
        onChanged();
      } else {
        segmentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.LabelSegment.Builder getSegmentsBuilder(
        int index) {
      return getSegmentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.LabelSegmentOrBuilder getSegmentsOrBuilder(
        int index) {
      if (segmentsBuilder_ == null) {
        return segments_.get(index);
      } else {
        return segmentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1p3beta1.LabelSegmentOrBuilder>
        getSegmentsOrBuilderList() {
      if (segmentsBuilder_ != null) {
        return segmentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(segments_);
      }
    }
    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.LabelSegment.Builder addSegmentsBuilder() {
      return getSegmentsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1p3beta1.LabelSegment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.LabelSegment.Builder addSegmentsBuilder(
        int index) {
      return getSegmentsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1p3beta1.LabelSegment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All video segments where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelSegment segments = 3;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.LabelSegment.Builder>
        getSegmentsBuilderList() {
      return getSegmentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.LabelSegment,
            com.google.cloud.videointelligence.v1p3beta1.LabelSegment.Builder,
            com.google.cloud.videointelligence.v1p3beta1.LabelSegmentOrBuilder>
        getSegmentsFieldBuilder() {
      if (segmentsBuilder_ == null) {
        segmentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p3beta1.LabelSegment,
                com.google.cloud.videointelligence.v1p3beta1.LabelSegment.Builder,
                com.google.cloud.videointelligence.v1p3beta1.LabelSegmentOrBuilder>(
                segments_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        segments_ = null;
      }
      return segmentsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1p3beta1.LabelFrame> frames_ =
        java.util.Collections.emptyList();

    private void ensureFramesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        frames_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1p3beta1.LabelFrame>(
                frames_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.LabelFrame,
            com.google.cloud.videointelligence.v1p3beta1.LabelFrame.Builder,
            com.google.cloud.videointelligence.v1p3beta1.LabelFrameOrBuilder>
        framesBuilder_;

    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.LabelFrame> getFramesList() {
      if (framesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(frames_);
      } else {
        return framesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public int getFramesCount() {
      if (framesBuilder_ == null) {
        return frames_.size();
      } else {
        return framesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.LabelFrame getFrames(int index) {
      if (framesBuilder_ == null) {
        return frames_.get(index);
      } else {
        return framesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public Builder setFrames(
        int index, com.google.cloud.videointelligence.v1p3beta1.LabelFrame value) {
      if (framesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFramesIsMutable();
        frames_.set(index, value);
        onChanged();
      } else {
        framesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public Builder setFrames(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.LabelFrame.Builder builderForValue) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.set(index, builderForValue.build());
        onChanged();
      } else {
        framesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public Builder addFrames(com.google.cloud.videointelligence.v1p3beta1.LabelFrame value) {
      if (framesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFramesIsMutable();
        frames_.add(value);
        onChanged();
      } else {
        framesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public Builder addFrames(
        int index, com.google.cloud.videointelligence.v1p3beta1.LabelFrame value) {
      if (framesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFramesIsMutable();
        frames_.add(index, value);
        onChanged();
      } else {
        framesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public Builder addFrames(
        com.google.cloud.videointelligence.v1p3beta1.LabelFrame.Builder builderForValue) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.add(builderForValue.build());
        onChanged();
      } else {
        framesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public Builder addFrames(
        int index,
        com.google.cloud.videointelligence.v1p3beta1.LabelFrame.Builder builderForValue) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.add(index, builderForValue.build());
        onChanged();
      } else {
        framesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public Builder addAllFrames(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1p3beta1.LabelFrame>
            values) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, frames_);
        onChanged();
      } else {
        framesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public Builder clearFrames() {
      if (framesBuilder_ == null) {
        frames_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        framesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public Builder removeFrames(int index) {
      if (framesBuilder_ == null) {
        ensureFramesIsMutable();
        frames_.remove(index);
        onChanged();
      } else {
        framesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.LabelFrame.Builder getFramesBuilder(
        int index) {
      return getFramesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.LabelFrameOrBuilder getFramesOrBuilder(
        int index) {
      if (framesBuilder_ == null) {
        return frames_.get(index);
      } else {
        return framesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1p3beta1.LabelFrameOrBuilder>
        getFramesOrBuilderList() {
      if (framesBuilder_ != null) {
        return framesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(frames_);
      }
    }
    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.LabelFrame.Builder addFramesBuilder() {
      return getFramesFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1p3beta1.LabelFrame.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.LabelFrame.Builder addFramesBuilder(
        int index) {
      return getFramesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1p3beta1.LabelFrame.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All video frames where a label was detected.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1p3beta1.LabelFrame frames = 4;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.LabelFrame.Builder>
        getFramesBuilderList() {
      return getFramesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.LabelFrame,
            com.google.cloud.videointelligence.v1p3beta1.LabelFrame.Builder,
            com.google.cloud.videointelligence.v1p3beta1.LabelFrameOrBuilder>
        getFramesFieldBuilder() {
      if (framesBuilder_ == null) {
        framesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p3beta1.LabelFrame,
                com.google.cloud.videointelligence.v1p3beta1.LabelFrame.Builder,
                com.google.cloud.videointelligence.v1p3beta1.LabelFrameOrBuilder>(
                frames_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        frames_ = null;
      }
      return framesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1p3beta1.LabelAnnotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1p3beta1.LabelAnnotation)
  private static final com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation();
  }

  public static com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LabelAnnotation> PARSER =
      new com.google.protobuf.AbstractParser<LabelAnnotation>() {
        @java.lang.Override
        public LabelAnnotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new LabelAnnotation(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<LabelAnnotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LabelAnnotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.LabelAnnotation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
