/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1p3beta1/video_intelligence.proto

package com.google.cloud.videointelligence.v1p3beta1;

/**
 *
 *
 * <pre>
 * Alternative hypotheses (a.k.a. n-best list).
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative}
 */
public final class SpeechRecognitionAlternative extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative)
    SpeechRecognitionAlternativeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SpeechRecognitionAlternative.newBuilder() to construct.
  private SpeechRecognitionAlternative(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SpeechRecognitionAlternative() {
    transcript_ = "";
    words_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SpeechRecognitionAlternative();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p3beta1_SpeechRecognitionAlternative_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1p3beta1_SpeechRecognitionAlternative_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative.class,
            com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative.Builder
                .class);
  }

  public static final int TRANSCRIPT_FIELD_NUMBER = 1;
  private volatile java.lang.Object transcript_;
  /**
   *
   *
   * <pre>
   * Transcript text representing the words that the user spoke.
   * </pre>
   *
   * <code>string transcript = 1;</code>
   *
   * @return The transcript.
   */
  @java.lang.Override
  public java.lang.String getTranscript() {
    java.lang.Object ref = transcript_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      transcript_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Transcript text representing the words that the user spoke.
   * </pre>
   *
   * <code>string transcript = 1;</code>
   *
   * @return The bytes for transcript.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTranscriptBytes() {
    java.lang.Object ref = transcript_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      transcript_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIDENCE_FIELD_NUMBER = 2;
  private float confidence_;
  /**
   *
   *
   * <pre>
   * Output only. The confidence estimate between 0.0 and 1.0. A higher number
   * indicates an estimated greater likelihood that the recognized words are
   * correct. This field is set only for the top alternative.
   * This field is not guaranteed to be accurate and users should not rely on it
   * to be always provided.
   * The default of 0.0 is a sentinel value indicating `confidence` was not set.
   * </pre>
   *
   * <code>float confidence = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The confidence.
   */
  @java.lang.Override
  public float getConfidence() {
    return confidence_;
  }

  public static final int WORDS_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.videointelligence.v1p3beta1.WordInfo> words_;
  /**
   *
   *
   * <pre>
   * Output only. A list of word-specific information for each recognized word.
   * Note: When `enable_speaker_diarization` is set to true, you will see all
   * the words from the beginning of the audio.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1p3beta1.WordInfo> getWordsList() {
    return words_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of word-specific information for each recognized word.
   * Note: When `enable_speaker_diarization` is set to true, you will see all
   * the words from the beginning of the audio.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1p3beta1.WordInfoOrBuilder>
      getWordsOrBuilderList() {
    return words_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of word-specific information for each recognized word.
   * Note: When `enable_speaker_diarization` is set to true, you will see all
   * the words from the beginning of the audio.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getWordsCount() {
    return words_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of word-specific information for each recognized word.
   * Note: When `enable_speaker_diarization` is set to true, you will see all
   * the words from the beginning of the audio.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.WordInfo getWords(int index) {
    return words_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of word-specific information for each recognized word.
   * Note: When `enable_speaker_diarization` is set to true, you will see all
   * the words from the beginning of the audio.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.WordInfoOrBuilder getWordsOrBuilder(
      int index) {
    return words_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(transcript_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, transcript_);
    }
    if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
      output.writeFloat(2, confidence_);
    }
    for (int i = 0; i < words_.size(); i++) {
      output.writeMessage(3, words_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(transcript_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, transcript_);
    }
    if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, confidence_);
    }
    for (int i = 0; i < words_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, words_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative other =
        (com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative) obj;

    if (!getTranscript().equals(other.getTranscript())) return false;
    if (java.lang.Float.floatToIntBits(getConfidence())
        != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
    if (!getWordsList().equals(other.getWordsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TRANSCRIPT_FIELD_NUMBER;
    hash = (53 * hash) + getTranscript().hashCode();
    hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
    if (getWordsCount() > 0) {
      hash = (37 * hash) + WORDS_FIELD_NUMBER;
      hash = (53 * hash) + getWordsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Alternative hypotheses (a.k.a. n-best list).
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative)
      com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternativeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_SpeechRecognitionAlternative_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_SpeechRecognitionAlternative_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative.class,
              com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      transcript_ = "";

      confidence_ = 0F;

      if (wordsBuilder_ == null) {
        words_ = java.util.Collections.emptyList();
      } else {
        words_ = null;
        wordsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1p3beta1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1p3beta1_SpeechRecognitionAlternative_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative
        getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative build() {
      com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative
        buildPartial() {
      com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative result =
          new com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative(this);
      int from_bitField0_ = bitField0_;
      result.transcript_ = transcript_;
      result.confidence_ = confidence_;
      if (wordsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          words_ = java.util.Collections.unmodifiableList(words_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.words_ = words_;
      } else {
        result.words_ = wordsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative) {
        return mergeFrom(
            (com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative other) {
      if (other
          == com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative
              .getDefaultInstance()) return this;
      if (!other.getTranscript().isEmpty()) {
        transcript_ = other.transcript_;
        onChanged();
      }
      if (other.getConfidence() != 0F) {
        setConfidence(other.getConfidence());
      }
      if (wordsBuilder_ == null) {
        if (!other.words_.isEmpty()) {
          if (words_.isEmpty()) {
            words_ = other.words_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureWordsIsMutable();
            words_.addAll(other.words_);
          }
          onChanged();
        }
      } else {
        if (!other.words_.isEmpty()) {
          if (wordsBuilder_.isEmpty()) {
            wordsBuilder_.dispose();
            wordsBuilder_ = null;
            words_ = other.words_;
            bitField0_ = (bitField0_ & ~0x00000001);
            wordsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWordsFieldBuilder()
                    : null;
          } else {
            wordsBuilder_.addAllMessages(other.words_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                transcript_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 21:
              {
                confidence_ = input.readFloat();

                break;
              } // case 21
            case 26:
              {
                com.google.cloud.videointelligence.v1p3beta1.WordInfo m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1p3beta1.WordInfo.parser(),
                        extensionRegistry);
                if (wordsBuilder_ == null) {
                  ensureWordsIsMutable();
                  words_.add(m);
                } else {
                  wordsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object transcript_ = "";
    /**
     *
     *
     * <pre>
     * Transcript text representing the words that the user spoke.
     * </pre>
     *
     * <code>string transcript = 1;</code>
     *
     * @return The transcript.
     */
    public java.lang.String getTranscript() {
      java.lang.Object ref = transcript_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        transcript_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Transcript text representing the words that the user spoke.
     * </pre>
     *
     * <code>string transcript = 1;</code>
     *
     * @return The bytes for transcript.
     */
    public com.google.protobuf.ByteString getTranscriptBytes() {
      java.lang.Object ref = transcript_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        transcript_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Transcript text representing the words that the user spoke.
     * </pre>
     *
     * <code>string transcript = 1;</code>
     *
     * @param value The transcript to set.
     * @return This builder for chaining.
     */
    public Builder setTranscript(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      transcript_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transcript text representing the words that the user spoke.
     * </pre>
     *
     * <code>string transcript = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTranscript() {

      transcript_ = getDefaultInstance().getTranscript();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transcript text representing the words that the user spoke.
     * </pre>
     *
     * <code>string transcript = 1;</code>
     *
     * @param value The bytes for transcript to set.
     * @return This builder for chaining.
     */
    public Builder setTranscriptBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      transcript_ = value;
      onChanged();
      return this;
    }

    private float confidence_;
    /**
     *
     *
     * <pre>
     * Output only. The confidence estimate between 0.0 and 1.0. A higher number
     * indicates an estimated greater likelihood that the recognized words are
     * correct. This field is set only for the top alternative.
     * This field is not guaranteed to be accurate and users should not rely on it
     * to be always provided.
     * The default of 0.0 is a sentinel value indicating `confidence` was not set.
     * </pre>
     *
     * <code>float confidence = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The confidence.
     */
    @java.lang.Override
    public float getConfidence() {
      return confidence_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The confidence estimate between 0.0 and 1.0. A higher number
     * indicates an estimated greater likelihood that the recognized words are
     * correct. This field is set only for the top alternative.
     * This field is not guaranteed to be accurate and users should not rely on it
     * to be always provided.
     * The default of 0.0 is a sentinel value indicating `confidence` was not set.
     * </pre>
     *
     * <code>float confidence = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The confidence to set.
     * @return This builder for chaining.
     */
    public Builder setConfidence(float value) {

      confidence_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The confidence estimate between 0.0 and 1.0. A higher number
     * indicates an estimated greater likelihood that the recognized words are
     * correct. This field is set only for the top alternative.
     * This field is not guaranteed to be accurate and users should not rely on it
     * to be always provided.
     * The default of 0.0 is a sentinel value indicating `confidence` was not set.
     * </pre>
     *
     * <code>float confidence = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfidence() {

      confidence_ = 0F;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.videointelligence.v1p3beta1.WordInfo> words_ =
        java.util.Collections.emptyList();

    private void ensureWordsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        words_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1p3beta1.WordInfo>(words_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.WordInfo,
            com.google.cloud.videointelligence.v1p3beta1.WordInfo.Builder,
            com.google.cloud.videointelligence.v1p3beta1.WordInfoOrBuilder>
        wordsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.WordInfo> getWordsList() {
      if (wordsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(words_);
      } else {
        return wordsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getWordsCount() {
      if (wordsBuilder_ == null) {
        return words_.size();
      } else {
        return wordsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.WordInfo getWords(int index) {
      if (wordsBuilder_ == null) {
        return words_.get(index);
      } else {
        return wordsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setWords(
        int index, com.google.cloud.videointelligence.v1p3beta1.WordInfo value) {
      if (wordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWordsIsMutable();
        words_.set(index, value);
        onChanged();
      } else {
        wordsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setWords(
        int index, com.google.cloud.videointelligence.v1p3beta1.WordInfo.Builder builderForValue) {
      if (wordsBuilder_ == null) {
        ensureWordsIsMutable();
        words_.set(index, builderForValue.build());
        onChanged();
      } else {
        wordsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addWords(com.google.cloud.videointelligence.v1p3beta1.WordInfo value) {
      if (wordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWordsIsMutable();
        words_.add(value);
        onChanged();
      } else {
        wordsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addWords(
        int index, com.google.cloud.videointelligence.v1p3beta1.WordInfo value) {
      if (wordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWordsIsMutable();
        words_.add(index, value);
        onChanged();
      } else {
        wordsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addWords(
        com.google.cloud.videointelligence.v1p3beta1.WordInfo.Builder builderForValue) {
      if (wordsBuilder_ == null) {
        ensureWordsIsMutable();
        words_.add(builderForValue.build());
        onChanged();
      } else {
        wordsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addWords(
        int index, com.google.cloud.videointelligence.v1p3beta1.WordInfo.Builder builderForValue) {
      if (wordsBuilder_ == null) {
        ensureWordsIsMutable();
        words_.add(index, builderForValue.build());
        onChanged();
      } else {
        wordsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllWords(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1p3beta1.WordInfo>
            values) {
      if (wordsBuilder_ == null) {
        ensureWordsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, words_);
        onChanged();
      } else {
        wordsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearWords() {
      if (wordsBuilder_ == null) {
        words_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        wordsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeWords(int index) {
      if (wordsBuilder_ == null) {
        ensureWordsIsMutable();
        words_.remove(index);
        onChanged();
      } else {
        wordsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.WordInfo.Builder getWordsBuilder(
        int index) {
      return getWordsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.WordInfoOrBuilder getWordsOrBuilder(
        int index) {
      if (wordsBuilder_ == null) {
        return words_.get(index);
      } else {
        return wordsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.videointelligence.v1p3beta1.WordInfoOrBuilder>
        getWordsOrBuilderList() {
      if (wordsBuilder_ != null) {
        return wordsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(words_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.WordInfo.Builder addWordsBuilder() {
      return getWordsFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1p3beta1.WordInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.videointelligence.v1p3beta1.WordInfo.Builder addWordsBuilder(
        int index) {
      return getWordsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1p3beta1.WordInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of word-specific information for each recognized word.
     * Note: When `enable_speaker_diarization` is set to true, you will see all
     * the words from the beginning of the audio.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1p3beta1.WordInfo words = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1p3beta1.WordInfo.Builder>
        getWordsBuilderList() {
      return getWordsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1p3beta1.WordInfo,
            com.google.cloud.videointelligence.v1p3beta1.WordInfo.Builder,
            com.google.cloud.videointelligence.v1p3beta1.WordInfoOrBuilder>
        getWordsFieldBuilder() {
      if (wordsBuilder_ == null) {
        wordsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1p3beta1.WordInfo,
                com.google.cloud.videointelligence.v1p3beta1.WordInfo.Builder,
                com.google.cloud.videointelligence.v1p3beta1.WordInfoOrBuilder>(
                words_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        words_ = null;
      }
      return wordsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative)
  private static final com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative();
  }

  public static com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SpeechRecognitionAlternative> PARSER =
      new com.google.protobuf.AbstractParser<SpeechRecognitionAlternative>() {
        @java.lang.Override
        public SpeechRecognitionAlternative parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SpeechRecognitionAlternative> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SpeechRecognitionAlternative> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1p3beta1.SpeechRecognitionAlternative
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
