/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.stitcher.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CdnKeyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CDN_KEY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/cdnKeys/{cdn_key}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String cdnKey;

    @Deprecated
    protected CdnKeyName() {
        this.project = null;
        this.location = null;
        this.cdnKey = null;
    }

    private CdnKeyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cdnKey = (String)Preconditions.checkNotNull((Object)builder.getCdnKey());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCdnKey() {
        return this.cdnKey;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CdnKeyName of(String project, String location, String cdnKey) {
        return CdnKeyName.newBuilder().setProject(project).setLocation(location).setCdnKey(cdnKey).build();
    }

    public static String format(String project, String location, String cdnKey) {
        return CdnKeyName.newBuilder().setProject(project).setLocation(location).setCdnKey(cdnKey).build().toString();
    }

    public static CdnKeyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CDN_KEY.validatedMatch(formattedString, "CdnKeyName.parse: formattedString not in valid format");
        return CdnKeyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cdn_key"));
    }

    public static List<CdnKeyName> parseList(List<String> formattedStrings) {
        ArrayList<CdnKeyName> list = new ArrayList<CdnKeyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CdnKeyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CdnKeyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CdnKeyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CDN_KEY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CdnKeyName cdnKeyName = this;
            synchronized (cdnKeyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cdnKey != null) {
                        fieldMapBuilder.put((Object)"cdn_key", (Object)this.cdnKey);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CDN_KEY.instantiate(new String[]{"project", this.project, "location", this.location, "cdn_key", this.cdnKey});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CdnKeyName that = (CdnKeyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cdnKey, that.cdnKey);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cdnKey);
    }

    public static class Builder {
        private String project;
        private String location;
        private String cdnKey;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCdnKey() {
            return this.cdnKey;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCdnKey(String cdnKey) {
            this.cdnKey = cdnKey;
            return this;
        }

        private Builder(CdnKeyName cdnKeyName) {
            this.project = cdnKeyName.project;
            this.location = cdnKeyName.location;
            this.cdnKey = cdnKeyName.cdnKey;
        }

        public CdnKeyName build() {
            return new CdnKeyName(this);
        }
    }
}

