/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.transcoder.v1beta1;

import com.google.cloud.video.transcoder.v1beta1.AudioStreamOrBuilder;
import com.google.cloud.video.transcoder.v1beta1.ResourcesProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class AudioStream
extends GeneratedMessageV3
implements AudioStreamOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int CODEC_FIELD_NUMBER = 1;
    private volatile Object codec_;
    public static final int BITRATE_BPS_FIELD_NUMBER = 2;
    private int bitrateBps_;
    public static final int CHANNEL_COUNT_FIELD_NUMBER = 3;
    private int channelCount_;
    public static final int CHANNEL_LAYOUT_FIELD_NUMBER = 4;
    private LazyStringList channelLayout_;
    public static final int MAPPING_FIELD_NUMBER = 5;
    private List<AudioAtom> mapping_;
    public static final int SAMPLE_RATE_HERTZ_FIELD_NUMBER = 6;
    private int sampleRateHertz_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final AudioStream DEFAULT_INSTANCE = new AudioStream();
    private static final Parser<AudioStream> PARSER = new AbstractParser<AudioStream>(){

        public AudioStream parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new AudioStream(input, extensionRegistry);
        }
    };

    private AudioStream(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private AudioStream() {
        this.codec_ = "";
        this.channelLayout_ = LazyStringArrayList.EMPTY;
        this.mapping_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new AudioStream();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private AudioStream(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block15: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block15;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.codec_ = s;
                        continue block15;
                    }
                    case 16: {
                        this.bitrateBps_ = input.readInt32();
                        continue block15;
                    }
                    case 24: {
                        this.channelCount_ = input.readInt32();
                        continue block15;
                    }
                    case 34: {
                        String s = input.readStringRequireUtf8();
                        if ((mutable_bitField0_ & 1) == 0) {
                            this.channelLayout_ = new LazyStringArrayList();
                            mutable_bitField0_ |= 1;
                        }
                        this.channelLayout_.add((Object)s);
                        continue block15;
                    }
                    case 42: {
                        if ((mutable_bitField0_ & 2) == 0) {
                            this.mapping_ = new ArrayList<AudioAtom>();
                            mutable_bitField0_ |= 2;
                        }
                        this.mapping_.add((AudioAtom)input.readMessage(AudioAtom.parser(), extensionRegistry));
                        continue block15;
                    }
                    case 48: {
                        this.sampleRateHertz_ = input.readInt32();
                        continue block15;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.channelLayout_ = this.channelLayout_.getUnmodifiableView();
            }
            if ((mutable_bitField0_ & 2) != 0) {
                this.mapping_ = Collections.unmodifiableList(this.mapping_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_fieldAccessorTable.ensureFieldAccessorsInitialized(AudioStream.class, Builder.class);
    }

    @Override
    public String getCodec() {
        Object ref = this.codec_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.codec_ = s;
        return s;
    }

    @Override
    public ByteString getCodecBytes() {
        Object ref = this.codec_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.codec_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getBitrateBps() {
        return this.bitrateBps_;
    }

    @Override
    public int getChannelCount() {
        return this.channelCount_;
    }

    public ProtocolStringList getChannelLayoutList() {
        return this.channelLayout_;
    }

    @Override
    public int getChannelLayoutCount() {
        return this.channelLayout_.size();
    }

    @Override
    public String getChannelLayout(int index) {
        return (String)this.channelLayout_.get(index);
    }

    @Override
    public ByteString getChannelLayoutBytes(int index) {
        return this.channelLayout_.getByteString(index);
    }

    @Override
    public List<AudioAtom> getMappingList() {
        return this.mapping_;
    }

    @Override
    public List<? extends AudioAtomOrBuilder> getMappingOrBuilderList() {
        return this.mapping_;
    }

    @Override
    public int getMappingCount() {
        return this.mapping_.size();
    }

    @Override
    public AudioAtom getMapping(int index) {
        return this.mapping_.get(index);
    }

    @Override
    public AudioAtomOrBuilder getMappingOrBuilder(int index) {
        return this.mapping_.get(index);
    }

    @Override
    public int getSampleRateHertz() {
        return this.sampleRateHertz_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!this.getCodecBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.codec_);
        }
        if (this.bitrateBps_ != 0) {
            output.writeInt32(2, this.bitrateBps_);
        }
        if (this.channelCount_ != 0) {
            output.writeInt32(3, this.channelCount_);
        }
        for (i = 0; i < this.channelLayout_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.channelLayout_.getRaw(i));
        }
        for (i = 0; i < this.mapping_.size(); ++i) {
            output.writeMessage(5, (MessageLite)this.mapping_.get(i));
        }
        if (this.sampleRateHertz_ != 0) {
            output.writeInt32(6, this.sampleRateHertz_);
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!this.getCodecBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.codec_);
        }
        if (this.bitrateBps_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)2, (int)this.bitrateBps_);
        }
        if (this.channelCount_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)3, (int)this.channelCount_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.channelLayout_.size(); ++i) {
            dataSize += AudioStream.computeStringSizeNoTag((Object)this.channelLayout_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getChannelLayoutList().size();
        for (int i = 0; i < this.mapping_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)((MessageLite)this.mapping_.get(i)));
        }
        if (this.sampleRateHertz_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)6, (int)this.sampleRateHertz_);
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AudioStream)) {
            return super.equals(obj);
        }
        AudioStream other = (AudioStream)obj;
        if (!this.getCodec().equals(other.getCodec())) {
            return false;
        }
        if (this.getBitrateBps() != other.getBitrateBps()) {
            return false;
        }
        if (this.getChannelCount() != other.getChannelCount()) {
            return false;
        }
        if (!this.getChannelLayoutList().equals(other.getChannelLayoutList())) {
            return false;
        }
        if (!this.getMappingList().equals(other.getMappingList())) {
            return false;
        }
        if (this.getSampleRateHertz() != other.getSampleRateHertz()) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + AudioStream.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getCodec().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getBitrateBps();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getChannelCount();
        if (this.getChannelLayoutCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getChannelLayoutList().hashCode();
        }
        if (this.getMappingCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getMappingList().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getSampleRateHertz();
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static AudioStream parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (AudioStream)PARSER.parseFrom(data);
    }

    public static AudioStream parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AudioStream)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AudioStream parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (AudioStream)PARSER.parseFrom(data);
    }

    public static AudioStream parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AudioStream)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AudioStream parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (AudioStream)PARSER.parseFrom(data);
    }

    public static AudioStream parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AudioStream)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AudioStream parseFrom(InputStream input) throws IOException {
        return (AudioStream)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static AudioStream parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AudioStream)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AudioStream parseDelimitedFrom(InputStream input) throws IOException {
        return (AudioStream)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static AudioStream parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AudioStream)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AudioStream parseFrom(CodedInputStream input) throws IOException {
        return (AudioStream)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static AudioStream parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AudioStream)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return AudioStream.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AudioStream prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static AudioStream getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<AudioStream> parser() {
        return PARSER;
    }

    public Parser<AudioStream> getParserForType() {
        return PARSER;
    }

    public AudioStream getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements AudioStreamOrBuilder {
        private int bitField0_;
        private Object codec_ = "";
        private int bitrateBps_;
        private int channelCount_;
        private LazyStringList channelLayout_ = LazyStringArrayList.EMPTY;
        private List<AudioAtom> mapping_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AudioAtom, AudioAtom.Builder, AudioAtomOrBuilder> mappingBuilder_;
        private int sampleRateHertz_;

        public static final Descriptors.Descriptor getDescriptor() {
            return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_fieldAccessorTable.ensureFieldAccessorsInitialized(AudioStream.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getMappingFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.codec_ = "";
            this.bitrateBps_ = 0;
            this.channelCount_ = 0;
            this.channelLayout_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            if (this.mappingBuilder_ == null) {
                this.mapping_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
            } else {
                this.mappingBuilder_.clear();
            }
            this.sampleRateHertz_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_descriptor;
        }

        public AudioStream getDefaultInstanceForType() {
            return AudioStream.getDefaultInstance();
        }

        public AudioStream build() {
            AudioStream result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public AudioStream buildPartial() {
            AudioStream result = new AudioStream(this);
            int from_bitField0_ = this.bitField0_;
            result.codec_ = this.codec_;
            result.bitrateBps_ = this.bitrateBps_;
            result.channelCount_ = this.channelCount_;
            if ((this.bitField0_ & 1) != 0) {
                this.channelLayout_ = this.channelLayout_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.channelLayout_ = this.channelLayout_;
            if (this.mappingBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.mapping_ = Collections.unmodifiableList(this.mapping_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.mapping_ = this.mapping_;
            } else {
                result.mapping_ = this.mappingBuilder_.build();
            }
            result.sampleRateHertz_ = this.sampleRateHertz_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof AudioStream) {
                return this.mergeFrom((AudioStream)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(AudioStream other) {
            if (other == AudioStream.getDefaultInstance()) {
                return this;
            }
            if (!other.getCodec().isEmpty()) {
                this.codec_ = other.codec_;
                this.onChanged();
            }
            if (other.getBitrateBps() != 0) {
                this.setBitrateBps(other.getBitrateBps());
            }
            if (other.getChannelCount() != 0) {
                this.setChannelCount(other.getChannelCount());
            }
            if (!other.channelLayout_.isEmpty()) {
                if (this.channelLayout_.isEmpty()) {
                    this.channelLayout_ = other.channelLayout_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureChannelLayoutIsMutable();
                    this.channelLayout_.addAll((Collection)other.channelLayout_);
                }
                this.onChanged();
            }
            if (this.mappingBuilder_ == null) {
                if (!other.mapping_.isEmpty()) {
                    if (this.mapping_.isEmpty()) {
                        this.mapping_ = other.mapping_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureMappingIsMutable();
                        this.mapping_.addAll(other.mapping_);
                    }
                    this.onChanged();
                }
            } else if (!other.mapping_.isEmpty()) {
                if (this.mappingBuilder_.isEmpty()) {
                    this.mappingBuilder_.dispose();
                    this.mappingBuilder_ = null;
                    this.mapping_ = other.mapping_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.mappingBuilder_ = alwaysUseFieldBuilders ? this.getMappingFieldBuilder() : null;
                } else {
                    this.mappingBuilder_.addAllMessages((Iterable)other.mapping_);
                }
            }
            if (other.getSampleRateHertz() != 0) {
                this.setSampleRateHertz(other.getSampleRateHertz());
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            AudioStream parsedMessage = null;
            try {
                parsedMessage = (AudioStream)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (AudioStream)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getCodec() {
            Object ref = this.codec_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.codec_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCodecBytes() {
            Object ref = this.codec_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.codec_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCodec(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.codec_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearCodec() {
            this.codec_ = AudioStream.getDefaultInstance().getCodec();
            this.onChanged();
            return this;
        }

        public Builder setCodecBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AudioStream.checkByteStringIsUtf8((ByteString)value);
            this.codec_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public int getBitrateBps() {
            return this.bitrateBps_;
        }

        public Builder setBitrateBps(int value) {
            this.bitrateBps_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearBitrateBps() {
            this.bitrateBps_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getChannelCount() {
            return this.channelCount_;
        }

        public Builder setChannelCount(int value) {
            this.channelCount_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearChannelCount() {
            this.channelCount_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureChannelLayoutIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.channelLayout_ = new LazyStringArrayList(this.channelLayout_);
                this.bitField0_ |= 1;
            }
        }

        public ProtocolStringList getChannelLayoutList() {
            return this.channelLayout_.getUnmodifiableView();
        }

        @Override
        public int getChannelLayoutCount() {
            return this.channelLayout_.size();
        }

        @Override
        public String getChannelLayout(int index) {
            return (String)this.channelLayout_.get(index);
        }

        @Override
        public ByteString getChannelLayoutBytes(int index) {
            return this.channelLayout_.getByteString(index);
        }

        public Builder setChannelLayout(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureChannelLayoutIsMutable();
            this.channelLayout_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addChannelLayout(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureChannelLayoutIsMutable();
            this.channelLayout_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllChannelLayout(Iterable<String> values) {
            this.ensureChannelLayoutIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.channelLayout_);
            this.onChanged();
            return this;
        }

        public Builder clearChannelLayout() {
            this.channelLayout_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder addChannelLayoutBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AudioStream.checkByteStringIsUtf8((ByteString)value);
            this.ensureChannelLayoutIsMutable();
            this.channelLayout_.add(value);
            this.onChanged();
            return this;
        }

        private void ensureMappingIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.mapping_ = new ArrayList<AudioAtom>(this.mapping_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<AudioAtom> getMappingList() {
            if (this.mappingBuilder_ == null) {
                return Collections.unmodifiableList(this.mapping_);
            }
            return this.mappingBuilder_.getMessageList();
        }

        @Override
        public int getMappingCount() {
            if (this.mappingBuilder_ == null) {
                return this.mapping_.size();
            }
            return this.mappingBuilder_.getCount();
        }

        @Override
        public AudioAtom getMapping(int index) {
            if (this.mappingBuilder_ == null) {
                return this.mapping_.get(index);
            }
            return (AudioAtom)this.mappingBuilder_.getMessage(index);
        }

        public Builder setMapping(int index, AudioAtom value) {
            if (this.mappingBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureMappingIsMutable();
                this.mapping_.set(index, value);
                this.onChanged();
            } else {
                this.mappingBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setMapping(int index, AudioAtom.Builder builderForValue) {
            if (this.mappingBuilder_ == null) {
                this.ensureMappingIsMutable();
                this.mapping_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.mappingBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addMapping(AudioAtom value) {
            if (this.mappingBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureMappingIsMutable();
                this.mapping_.add(value);
                this.onChanged();
            } else {
                this.mappingBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addMapping(int index, AudioAtom value) {
            if (this.mappingBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureMappingIsMutable();
                this.mapping_.add(index, value);
                this.onChanged();
            } else {
                this.mappingBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addMapping(AudioAtom.Builder builderForValue) {
            if (this.mappingBuilder_ == null) {
                this.ensureMappingIsMutable();
                this.mapping_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.mappingBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addMapping(int index, AudioAtom.Builder builderForValue) {
            if (this.mappingBuilder_ == null) {
                this.ensureMappingIsMutable();
                this.mapping_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.mappingBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllMapping(Iterable<? extends AudioAtom> values) {
            if (this.mappingBuilder_ == null) {
                this.ensureMappingIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.mapping_);
                this.onChanged();
            } else {
                this.mappingBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearMapping() {
            if (this.mappingBuilder_ == null) {
                this.mapping_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.mappingBuilder_.clear();
            }
            return this;
        }

        public Builder removeMapping(int index) {
            if (this.mappingBuilder_ == null) {
                this.ensureMappingIsMutable();
                this.mapping_.remove(index);
                this.onChanged();
            } else {
                this.mappingBuilder_.remove(index);
            }
            return this;
        }

        public AudioAtom.Builder getMappingBuilder(int index) {
            return (AudioAtom.Builder)this.getMappingFieldBuilder().getBuilder(index);
        }

        @Override
        public AudioAtomOrBuilder getMappingOrBuilder(int index) {
            if (this.mappingBuilder_ == null) {
                return this.mapping_.get(index);
            }
            return (AudioAtomOrBuilder)this.mappingBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AudioAtomOrBuilder> getMappingOrBuilderList() {
            if (this.mappingBuilder_ != null) {
                return this.mappingBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.mapping_);
        }

        public AudioAtom.Builder addMappingBuilder() {
            return (AudioAtom.Builder)this.getMappingFieldBuilder().addBuilder((AbstractMessage)AudioAtom.getDefaultInstance());
        }

        public AudioAtom.Builder addMappingBuilder(int index) {
            return (AudioAtom.Builder)this.getMappingFieldBuilder().addBuilder(index, (AbstractMessage)AudioAtom.getDefaultInstance());
        }

        public List<AudioAtom.Builder> getMappingBuilderList() {
            return this.getMappingFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AudioAtom, AudioAtom.Builder, AudioAtomOrBuilder> getMappingFieldBuilder() {
            if (this.mappingBuilder_ == null) {
                this.mappingBuilder_ = new RepeatedFieldBuilderV3(this.mapping_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.mapping_ = null;
            }
            return this.mappingBuilder_;
        }

        @Override
        public int getSampleRateHertz() {
            return this.sampleRateHertz_;
        }

        public Builder setSampleRateHertz(int value) {
            this.sampleRateHertz_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearSampleRateHertz() {
            this.sampleRateHertz_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class AudioAtom
    extends GeneratedMessageV3
    implements AudioAtomOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int KEY_FIELD_NUMBER = 1;
        private volatile Object key_;
        public static final int CHANNELS_FIELD_NUMBER = 2;
        private List<AudioChannel> channels_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final AudioAtom DEFAULT_INSTANCE = new AudioAtom();
        private static final Parser<AudioAtom> PARSER = new AbstractParser<AudioAtom>(){

            public AudioAtom parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return new AudioAtom(input, extensionRegistry);
            }
        };

        private AudioAtom(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private AudioAtom() {
            this.key_ = "";
            this.channels_ = Collections.emptyList();
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new AudioAtom();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        private AudioAtom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            boolean mutable_bitField0_ = false;
            UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                block11: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block11;
                        }
                        case 10: {
                            String s = input.readStringRequireUtf8();
                            this.key_ = s;
                            continue block11;
                        }
                        case 18: {
                            if (!(mutable_bitField0_ & true)) {
                                this.channels_ = new ArrayList<AudioChannel>();
                                mutable_bitField0_ |= true;
                            }
                            this.channels_.add((AudioChannel)input.readMessage(AudioChannel.parser(), extensionRegistry));
                            continue block11;
                        }
                    }
                    if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)this);
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
            }
            finally {
                if (mutable_bitField0_ & true) {
                    this.channels_ = Collections.unmodifiableList(this.channels_);
                }
                this.unknownFields = unknownFields.build();
                this.makeExtensionsImmutable();
            }
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_AudioAtom_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_AudioAtom_fieldAccessorTable.ensureFieldAccessorsInitialized(AudioAtom.class, Builder.class);
        }

        @Override
        public String getKey() {
            Object ref = this.key_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.key_ = s;
            return s;
        }

        @Override
        public ByteString getKeyBytes() {
            Object ref = this.key_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.key_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public List<AudioChannel> getChannelsList() {
            return this.channels_;
        }

        @Override
        public List<? extends AudioChannelOrBuilder> getChannelsOrBuilderList() {
            return this.channels_;
        }

        @Override
        public int getChannelsCount() {
            return this.channels_.size();
        }

        @Override
        public AudioChannel getChannels(int index) {
            return this.channels_.get(index);
        }

        @Override
        public AudioChannelOrBuilder getChannelsOrBuilder(int index) {
            return this.channels_.get(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (!this.getKeyBytes().isEmpty()) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.key_);
            }
            for (int i = 0; i < this.channels_.size(); ++i) {
                output.writeMessage(2, (MessageLite)this.channels_.get(i));
            }
            this.unknownFields.writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!this.getKeyBytes().isEmpty()) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.key_);
            }
            for (int i = 0; i < this.channels_.size(); ++i) {
                size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((MessageLite)this.channels_.get(i)));
            }
            this.memoizedSize = size += this.unknownFields.getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AudioAtom)) {
                return super.equals(obj);
            }
            AudioAtom other = (AudioAtom)obj;
            if (!this.getKey().equals(other.getKey())) {
                return false;
            }
            if (!this.getChannelsList().equals(other.getChannelsList())) {
                return false;
            }
            return this.unknownFields.equals((Object)other.unknownFields);
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + AudioAtom.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getKey().hashCode();
            if (this.getChannelsCount() > 0) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getChannelsList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
            return hash;
        }

        public static AudioAtom parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (AudioAtom)PARSER.parseFrom(data);
        }

        public static AudioAtom parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AudioAtom)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AudioAtom parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (AudioAtom)PARSER.parseFrom(data);
        }

        public static AudioAtom parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AudioAtom)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AudioAtom parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (AudioAtom)PARSER.parseFrom(data);
        }

        public static AudioAtom parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AudioAtom)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AudioAtom parseFrom(InputStream input) throws IOException {
            return (AudioAtom)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static AudioAtom parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AudioAtom)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AudioAtom parseDelimitedFrom(InputStream input) throws IOException {
            return (AudioAtom)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static AudioAtom parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AudioAtom)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AudioAtom parseFrom(CodedInputStream input) throws IOException {
            return (AudioAtom)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static AudioAtom parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AudioAtom)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return AudioAtom.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(AudioAtom prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static AudioAtom getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<AudioAtom> parser() {
            return PARSER;
        }

        public Parser<AudioAtom> getParserForType() {
            return PARSER;
        }

        public AudioAtom getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements AudioAtomOrBuilder {
            private int bitField0_;
            private Object key_ = "";
            private List<AudioChannel> channels_ = Collections.emptyList();
            private RepeatedFieldBuilderV3<AudioChannel, AudioChannel.Builder, AudioChannelOrBuilder> channelsBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_AudioAtom_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_AudioAtom_fieldAccessorTable.ensureFieldAccessorsInitialized(AudioAtom.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    this.getChannelsFieldBuilder();
                }
            }

            public Builder clear() {
                super.clear();
                this.key_ = "";
                if (this.channelsBuilder_ == null) {
                    this.channels_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.channelsBuilder_.clear();
                }
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_AudioAtom_descriptor;
            }

            public AudioAtom getDefaultInstanceForType() {
                return AudioAtom.getDefaultInstance();
            }

            public AudioAtom build() {
                AudioAtom result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public AudioAtom buildPartial() {
                AudioAtom result = new AudioAtom(this);
                int from_bitField0_ = this.bitField0_;
                result.key_ = this.key_;
                if (this.channelsBuilder_ == null) {
                    if ((this.bitField0_ & 1) != 0) {
                        this.channels_ = Collections.unmodifiableList(this.channels_);
                        this.bitField0_ &= 0xFFFFFFFE;
                    }
                    result.channels_ = this.channels_;
                } else {
                    result.channels_ = this.channelsBuilder_.build();
                }
                this.onBuilt();
                return result;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof AudioAtom) {
                    return this.mergeFrom((AudioAtom)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(AudioAtom other) {
                if (other == AudioAtom.getDefaultInstance()) {
                    return this;
                }
                if (!other.getKey().isEmpty()) {
                    this.key_ = other.key_;
                    this.onChanged();
                }
                if (this.channelsBuilder_ == null) {
                    if (!other.channels_.isEmpty()) {
                        if (this.channels_.isEmpty()) {
                            this.channels_ = other.channels_;
                            this.bitField0_ &= 0xFFFFFFFE;
                        } else {
                            this.ensureChannelsIsMutable();
                            this.channels_.addAll(other.channels_);
                        }
                        this.onChanged();
                    }
                } else if (!other.channels_.isEmpty()) {
                    if (this.channelsBuilder_.isEmpty()) {
                        this.channelsBuilder_.dispose();
                        this.channelsBuilder_ = null;
                        this.channels_ = other.channels_;
                        this.bitField0_ &= 0xFFFFFFFE;
                        this.channelsBuilder_ = alwaysUseFieldBuilders ? this.getChannelsFieldBuilder() : null;
                    } else {
                        this.channelsBuilder_.addAllMessages((Iterable)other.channels_);
                    }
                }
                this.mergeUnknownFields(other.unknownFields);
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                AudioAtom parsedMessage = null;
                try {
                    parsedMessage = (AudioAtom)PARSER.parsePartialFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    parsedMessage = (AudioAtom)e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                }
                finally {
                    if (parsedMessage != null) {
                        this.mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            @Override
            public String getKey() {
                Object ref = this.key_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.key_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getKeyBytes() {
                Object ref = this.key_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.key_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setKey(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.key_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearKey() {
                this.key_ = AudioAtom.getDefaultInstance().getKey();
                this.onChanged();
                return this;
            }

            public Builder setKeyBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                AudioAtom.checkByteStringIsUtf8((ByteString)value);
                this.key_ = value;
                this.onChanged();
                return this;
            }

            private void ensureChannelsIsMutable() {
                if ((this.bitField0_ & 1) == 0) {
                    this.channels_ = new ArrayList<AudioChannel>(this.channels_);
                    this.bitField0_ |= 1;
                }
            }

            @Override
            public List<AudioChannel> getChannelsList() {
                if (this.channelsBuilder_ == null) {
                    return Collections.unmodifiableList(this.channels_);
                }
                return this.channelsBuilder_.getMessageList();
            }

            @Override
            public int getChannelsCount() {
                if (this.channelsBuilder_ == null) {
                    return this.channels_.size();
                }
                return this.channelsBuilder_.getCount();
            }

            @Override
            public AudioChannel getChannels(int index) {
                if (this.channelsBuilder_ == null) {
                    return this.channels_.get(index);
                }
                return (AudioChannel)this.channelsBuilder_.getMessage(index);
            }

            public Builder setChannels(int index, AudioChannel value) {
                if (this.channelsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureChannelsIsMutable();
                    this.channels_.set(index, value);
                    this.onChanged();
                } else {
                    this.channelsBuilder_.setMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder setChannels(int index, AudioChannel.Builder builderForValue) {
                if (this.channelsBuilder_ == null) {
                    this.ensureChannelsIsMutable();
                    this.channels_.set(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.channelsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addChannels(AudioChannel value) {
                if (this.channelsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureChannelsIsMutable();
                    this.channels_.add(value);
                    this.onChanged();
                } else {
                    this.channelsBuilder_.addMessage((AbstractMessage)value);
                }
                return this;
            }

            public Builder addChannels(int index, AudioChannel value) {
                if (this.channelsBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureChannelsIsMutable();
                    this.channels_.add(index, value);
                    this.onChanged();
                } else {
                    this.channelsBuilder_.addMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder addChannels(AudioChannel.Builder builderForValue) {
                if (this.channelsBuilder_ == null) {
                    this.ensureChannelsIsMutable();
                    this.channels_.add(builderForValue.build());
                    this.onChanged();
                } else {
                    this.channelsBuilder_.addMessage((AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addChannels(int index, AudioChannel.Builder builderForValue) {
                if (this.channelsBuilder_ == null) {
                    this.ensureChannelsIsMutable();
                    this.channels_.add(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.channelsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addAllChannels(Iterable<? extends AudioChannel> values) {
                if (this.channelsBuilder_ == null) {
                    this.ensureChannelsIsMutable();
                    AbstractMessageLite.Builder.addAll(values, this.channels_);
                    this.onChanged();
                } else {
                    this.channelsBuilder_.addAllMessages(values);
                }
                return this;
            }

            public Builder clearChannels() {
                if (this.channelsBuilder_ == null) {
                    this.channels_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.onChanged();
                } else {
                    this.channelsBuilder_.clear();
                }
                return this;
            }

            public Builder removeChannels(int index) {
                if (this.channelsBuilder_ == null) {
                    this.ensureChannelsIsMutable();
                    this.channels_.remove(index);
                    this.onChanged();
                } else {
                    this.channelsBuilder_.remove(index);
                }
                return this;
            }

            public AudioChannel.Builder getChannelsBuilder(int index) {
                return (AudioChannel.Builder)this.getChannelsFieldBuilder().getBuilder(index);
            }

            @Override
            public AudioChannelOrBuilder getChannelsOrBuilder(int index) {
                if (this.channelsBuilder_ == null) {
                    return this.channels_.get(index);
                }
                return (AudioChannelOrBuilder)this.channelsBuilder_.getMessageOrBuilder(index);
            }

            @Override
            public List<? extends AudioChannelOrBuilder> getChannelsOrBuilderList() {
                if (this.channelsBuilder_ != null) {
                    return this.channelsBuilder_.getMessageOrBuilderList();
                }
                return Collections.unmodifiableList(this.channels_);
            }

            public AudioChannel.Builder addChannelsBuilder() {
                return (AudioChannel.Builder)this.getChannelsFieldBuilder().addBuilder((AbstractMessage)AudioChannel.getDefaultInstance());
            }

            public AudioChannel.Builder addChannelsBuilder(int index) {
                return (AudioChannel.Builder)this.getChannelsFieldBuilder().addBuilder(index, (AbstractMessage)AudioChannel.getDefaultInstance());
            }

            public List<AudioChannel.Builder> getChannelsBuilderList() {
                return this.getChannelsFieldBuilder().getBuilderList();
            }

            private RepeatedFieldBuilderV3<AudioChannel, AudioChannel.Builder, AudioChannelOrBuilder> getChannelsFieldBuilder() {
                if (this.channelsBuilder_ == null) {
                    this.channelsBuilder_ = new RepeatedFieldBuilderV3(this.channels_, (this.bitField0_ & 1) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.channels_ = null;
                }
                return this.channelsBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static final class AudioChannel
        extends GeneratedMessageV3
        implements AudioChannelOrBuilder {
            private static final long serialVersionUID = 0L;
            public static final int INPUTS_FIELD_NUMBER = 2;
            private List<AudioChannelInput> inputs_;
            private byte memoizedIsInitialized = (byte)-1;
            private static final AudioChannel DEFAULT_INSTANCE = new AudioChannel();
            private static final Parser<AudioChannel> PARSER = new AbstractParser<AudioChannel>(){

                public AudioChannel parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    return new AudioChannel(input, extensionRegistry);
                }
            };

            private AudioChannel(GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }

            private AudioChannel() {
                this.inputs_ = Collections.emptyList();
            }

            protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
                return new AudioChannel();
            }

            public final UnknownFieldSet getUnknownFields() {
                return this.unknownFields;
            }

            private AudioChannel(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                this();
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                boolean mutable_bitField0_ = false;
                UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 18: {
                                if (!(mutable_bitField0_ & true)) {
                                    this.inputs_ = new ArrayList<AudioChannelInput>();
                                    mutable_bitField0_ |= true;
                                }
                                this.inputs_.add((AudioChannelInput)input.readMessage(AudioChannelInput.parser(), extensionRegistry));
                                continue block10;
                            }
                        }
                        if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)this);
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
                }
                finally {
                    if (mutable_bitField0_ & true) {
                        this.inputs_ = Collections.unmodifiableList(this.inputs_);
                    }
                    this.unknownFields = unknownFields.build();
                    this.makeExtensionsImmutable();
                }
            }

            public static final Descriptors.Descriptor getDescriptor() {
                return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_AudioAtom_AudioChannel_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_AudioAtom_AudioChannel_fieldAccessorTable.ensureFieldAccessorsInitialized(AudioChannel.class, Builder.class);
            }

            @Override
            public List<AudioChannelInput> getInputsList() {
                return this.inputs_;
            }

            @Override
            public List<? extends AudioChannelInputOrBuilder> getInputsOrBuilderList() {
                return this.inputs_;
            }

            @Override
            public int getInputsCount() {
                return this.inputs_.size();
            }

            @Override
            public AudioChannelInput getInputs(int index) {
                return this.inputs_.get(index);
            }

            @Override
            public AudioChannelInputOrBuilder getInputsOrBuilder(int index) {
                return this.inputs_.get(index);
            }

            public final boolean isInitialized() {
                byte isInitialized = this.memoizedIsInitialized;
                if (isInitialized == 1) {
                    return true;
                }
                if (isInitialized == 0) {
                    return false;
                }
                this.memoizedIsInitialized = 1;
                return true;
            }

            public void writeTo(CodedOutputStream output) throws IOException {
                for (int i = 0; i < this.inputs_.size(); ++i) {
                    output.writeMessage(2, (MessageLite)this.inputs_.get(i));
                }
                this.unknownFields.writeTo(output);
            }

            public int getSerializedSize() {
                int size = this.memoizedSize;
                if (size != -1) {
                    return size;
                }
                size = 0;
                for (int i = 0; i < this.inputs_.size(); ++i) {
                    size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((MessageLite)this.inputs_.get(i)));
                }
                this.memoizedSize = size += this.unknownFields.getSerializedSize();
                return size;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof AudioChannel)) {
                    return super.equals(obj);
                }
                AudioChannel other = (AudioChannel)obj;
                if (!this.getInputsList().equals(other.getInputsList())) {
                    return false;
                }
                return this.unknownFields.equals((Object)other.unknownFields);
            }

            public int hashCode() {
                if (this.memoizedHashCode != 0) {
                    return this.memoizedHashCode;
                }
                int hash = 41;
                hash = 19 * hash + AudioChannel.getDescriptor().hashCode();
                if (this.getInputsCount() > 0) {
                    hash = 37 * hash + 2;
                    hash = 53 * hash + this.getInputsList().hashCode();
                }
                this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
                return hash;
            }

            public static AudioChannel parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
                return (AudioChannel)PARSER.parseFrom(data);
            }

            public static AudioChannel parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (AudioChannel)PARSER.parseFrom(data, extensionRegistry);
            }

            public static AudioChannel parseFrom(ByteString data) throws InvalidProtocolBufferException {
                return (AudioChannel)PARSER.parseFrom(data);
            }

            public static AudioChannel parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (AudioChannel)PARSER.parseFrom(data, extensionRegistry);
            }

            public static AudioChannel parseFrom(byte[] data) throws InvalidProtocolBufferException {
                return (AudioChannel)PARSER.parseFrom(data);
            }

            public static AudioChannel parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (AudioChannel)PARSER.parseFrom(data, extensionRegistry);
            }

            public static AudioChannel parseFrom(InputStream input) throws IOException {
                return (AudioChannel)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
            }

            public static AudioChannel parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (AudioChannel)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static AudioChannel parseDelimitedFrom(InputStream input) throws IOException {
                return (AudioChannel)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
            }

            public static AudioChannel parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (AudioChannel)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static AudioChannel parseFrom(CodedInputStream input) throws IOException {
                return (AudioChannel)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
            }

            public static AudioChannel parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (AudioChannel)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public Builder newBuilderForType() {
                return AudioChannel.newBuilder();
            }

            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(AudioChannel prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }

            public static AudioChannel getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            public static Parser<AudioChannel> parser() {
                return PARSER;
            }

            public Parser<AudioChannel> getParserForType() {
                return PARSER;
            }

            public AudioChannel getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

            public static final class Builder
            extends GeneratedMessageV3.Builder<Builder>
            implements AudioChannelOrBuilder {
                private int bitField0_;
                private List<AudioChannelInput> inputs_ = Collections.emptyList();
                private RepeatedFieldBuilderV3<AudioChannelInput, AudioChannelInput.Builder, AudioChannelInputOrBuilder> inputsBuilder_;

                public static final Descriptors.Descriptor getDescriptor() {
                    return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_AudioAtom_AudioChannel_descriptor;
                }

                protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                    return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_AudioAtom_AudioChannel_fieldAccessorTable.ensureFieldAccessorsInitialized(AudioChannel.class, Builder.class);
                }

                private Builder() {
                    this.maybeForceBuilderInitialization();
                }

                private Builder(GeneratedMessageV3.BuilderParent parent) {
                    super(parent);
                    this.maybeForceBuilderInitialization();
                }

                private void maybeForceBuilderInitialization() {
                    if (alwaysUseFieldBuilders) {
                        this.getInputsFieldBuilder();
                    }
                }

                public Builder clear() {
                    super.clear();
                    if (this.inputsBuilder_ == null) {
                        this.inputs_ = Collections.emptyList();
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.inputsBuilder_.clear();
                    }
                    return this;
                }

                public Descriptors.Descriptor getDescriptorForType() {
                    return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_AudioAtom_AudioChannel_descriptor;
                }

                public AudioChannel getDefaultInstanceForType() {
                    return AudioChannel.getDefaultInstance();
                }

                public AudioChannel build() {
                    AudioChannel result = this.buildPartial();
                    if (!result.isInitialized()) {
                        throw Builder.newUninitializedMessageException((Message)result);
                    }
                    return result;
                }

                public AudioChannel buildPartial() {
                    AudioChannel result = new AudioChannel(this);
                    int from_bitField0_ = this.bitField0_;
                    if (this.inputsBuilder_ == null) {
                        if ((this.bitField0_ & 1) != 0) {
                            this.inputs_ = Collections.unmodifiableList(this.inputs_);
                            this.bitField0_ &= 0xFFFFFFFE;
                        }
                        result.inputs_ = this.inputs_;
                    } else {
                        result.inputs_ = this.inputsBuilder_.build();
                    }
                    this.onBuilt();
                    return result;
                }

                public Builder clone() {
                    return (Builder)super.clone();
                }

                public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.setField(field, value);
                }

                public Builder clearField(Descriptors.FieldDescriptor field) {
                    return (Builder)super.clearField(field);
                }

                public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                    return (Builder)super.clearOneof(oneof);
                }

                public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                    return (Builder)super.setRepeatedField(field, index, value);
                }

                public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.addRepeatedField(field, value);
                }

                public Builder mergeFrom(Message other) {
                    if (other instanceof AudioChannel) {
                        return this.mergeFrom((AudioChannel)other);
                    }
                    super.mergeFrom(other);
                    return this;
                }

                public Builder mergeFrom(AudioChannel other) {
                    if (other == AudioChannel.getDefaultInstance()) {
                        return this;
                    }
                    if (this.inputsBuilder_ == null) {
                        if (!other.inputs_.isEmpty()) {
                            if (this.inputs_.isEmpty()) {
                                this.inputs_ = other.inputs_;
                                this.bitField0_ &= 0xFFFFFFFE;
                            } else {
                                this.ensureInputsIsMutable();
                                this.inputs_.addAll(other.inputs_);
                            }
                            this.onChanged();
                        }
                    } else if (!other.inputs_.isEmpty()) {
                        if (this.inputsBuilder_.isEmpty()) {
                            this.inputsBuilder_.dispose();
                            this.inputsBuilder_ = null;
                            this.inputs_ = other.inputs_;
                            this.bitField0_ &= 0xFFFFFFFE;
                            this.inputsBuilder_ = alwaysUseFieldBuilders ? this.getInputsFieldBuilder() : null;
                        } else {
                            this.inputsBuilder_.addAllMessages((Iterable)other.inputs_);
                        }
                    }
                    this.mergeUnknownFields(other.unknownFields);
                    this.onChanged();
                    return this;
                }

                public final boolean isInitialized() {
                    return true;
                }

                public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    AudioChannel parsedMessage = null;
                    try {
                        parsedMessage = (AudioChannel)PARSER.parsePartialFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        parsedMessage = (AudioChannel)e.getUnfinishedMessage();
                        throw e.unwrapIOException();
                    }
                    finally {
                        if (parsedMessage != null) {
                            this.mergeFrom(parsedMessage);
                        }
                    }
                    return this;
                }

                private void ensureInputsIsMutable() {
                    if ((this.bitField0_ & 1) == 0) {
                        this.inputs_ = new ArrayList<AudioChannelInput>(this.inputs_);
                        this.bitField0_ |= 1;
                    }
                }

                @Override
                public List<AudioChannelInput> getInputsList() {
                    if (this.inputsBuilder_ == null) {
                        return Collections.unmodifiableList(this.inputs_);
                    }
                    return this.inputsBuilder_.getMessageList();
                }

                @Override
                public int getInputsCount() {
                    if (this.inputsBuilder_ == null) {
                        return this.inputs_.size();
                    }
                    return this.inputsBuilder_.getCount();
                }

                @Override
                public AudioChannelInput getInputs(int index) {
                    if (this.inputsBuilder_ == null) {
                        return this.inputs_.get(index);
                    }
                    return (AudioChannelInput)this.inputsBuilder_.getMessage(index);
                }

                public Builder setInputs(int index, AudioChannelInput value) {
                    if (this.inputsBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        this.ensureInputsIsMutable();
                        this.inputs_.set(index, value);
                        this.onChanged();
                    } else {
                        this.inputsBuilder_.setMessage(index, (AbstractMessage)value);
                    }
                    return this;
                }

                public Builder setInputs(int index, AudioChannelInput.Builder builderForValue) {
                    if (this.inputsBuilder_ == null) {
                        this.ensureInputsIsMutable();
                        this.inputs_.set(index, builderForValue.build());
                        this.onChanged();
                    } else {
                        this.inputsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
                    }
                    return this;
                }

                public Builder addInputs(AudioChannelInput value) {
                    if (this.inputsBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        this.ensureInputsIsMutable();
                        this.inputs_.add(value);
                        this.onChanged();
                    } else {
                        this.inputsBuilder_.addMessage((AbstractMessage)value);
                    }
                    return this;
                }

                public Builder addInputs(int index, AudioChannelInput value) {
                    if (this.inputsBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        this.ensureInputsIsMutable();
                        this.inputs_.add(index, value);
                        this.onChanged();
                    } else {
                        this.inputsBuilder_.addMessage(index, (AbstractMessage)value);
                    }
                    return this;
                }

                public Builder addInputs(AudioChannelInput.Builder builderForValue) {
                    if (this.inputsBuilder_ == null) {
                        this.ensureInputsIsMutable();
                        this.inputs_.add(builderForValue.build());
                        this.onChanged();
                    } else {
                        this.inputsBuilder_.addMessage((AbstractMessage)builderForValue.build());
                    }
                    return this;
                }

                public Builder addInputs(int index, AudioChannelInput.Builder builderForValue) {
                    if (this.inputsBuilder_ == null) {
                        this.ensureInputsIsMutable();
                        this.inputs_.add(index, builderForValue.build());
                        this.onChanged();
                    } else {
                        this.inputsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
                    }
                    return this;
                }

                public Builder addAllInputs(Iterable<? extends AudioChannelInput> values) {
                    if (this.inputsBuilder_ == null) {
                        this.ensureInputsIsMutable();
                        AbstractMessageLite.Builder.addAll(values, this.inputs_);
                        this.onChanged();
                    } else {
                        this.inputsBuilder_.addAllMessages(values);
                    }
                    return this;
                }

                public Builder clearInputs() {
                    if (this.inputsBuilder_ == null) {
                        this.inputs_ = Collections.emptyList();
                        this.bitField0_ &= 0xFFFFFFFE;
                        this.onChanged();
                    } else {
                        this.inputsBuilder_.clear();
                    }
                    return this;
                }

                public Builder removeInputs(int index) {
                    if (this.inputsBuilder_ == null) {
                        this.ensureInputsIsMutable();
                        this.inputs_.remove(index);
                        this.onChanged();
                    } else {
                        this.inputsBuilder_.remove(index);
                    }
                    return this;
                }

                public AudioChannelInput.Builder getInputsBuilder(int index) {
                    return (AudioChannelInput.Builder)this.getInputsFieldBuilder().getBuilder(index);
                }

                @Override
                public AudioChannelInputOrBuilder getInputsOrBuilder(int index) {
                    if (this.inputsBuilder_ == null) {
                        return this.inputs_.get(index);
                    }
                    return (AudioChannelInputOrBuilder)this.inputsBuilder_.getMessageOrBuilder(index);
                }

                @Override
                public List<? extends AudioChannelInputOrBuilder> getInputsOrBuilderList() {
                    if (this.inputsBuilder_ != null) {
                        return this.inputsBuilder_.getMessageOrBuilderList();
                    }
                    return Collections.unmodifiableList(this.inputs_);
                }

                public AudioChannelInput.Builder addInputsBuilder() {
                    return (AudioChannelInput.Builder)this.getInputsFieldBuilder().addBuilder((AbstractMessage)AudioChannelInput.getDefaultInstance());
                }

                public AudioChannelInput.Builder addInputsBuilder(int index) {
                    return (AudioChannelInput.Builder)this.getInputsFieldBuilder().addBuilder(index, (AbstractMessage)AudioChannelInput.getDefaultInstance());
                }

                public List<AudioChannelInput.Builder> getInputsBuilderList() {
                    return this.getInputsFieldBuilder().getBuilderList();
                }

                private RepeatedFieldBuilderV3<AudioChannelInput, AudioChannelInput.Builder, AudioChannelInputOrBuilder> getInputsFieldBuilder() {
                    if (this.inputsBuilder_ == null) {
                        this.inputsBuilder_ = new RepeatedFieldBuilderV3(this.inputs_, (this.bitField0_ & 1) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                        this.inputs_ = null;
                    }
                    return this.inputsBuilder_;
                }

                public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.setUnknownFields(unknownFields);
                }

                public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.mergeUnknownFields(unknownFields);
                }
            }

            public static final class AudioChannelInput
            extends GeneratedMessageV3
            implements AudioChannelInputOrBuilder {
                private static final long serialVersionUID = 0L;
                public static final int KEY_FIELD_NUMBER = 1;
                private volatile Object key_;
                public static final int TRACK_FIELD_NUMBER = 2;
                private int track_;
                public static final int CHANNEL_FIELD_NUMBER = 3;
                private int channel_;
                public static final int GAIN_DB_FIELD_NUMBER = 4;
                private double gainDb_;
                private byte memoizedIsInitialized = (byte)-1;
                private static final AudioChannelInput DEFAULT_INSTANCE = new AudioChannelInput();
                private static final Parser<AudioChannelInput> PARSER = new AbstractParser<AudioChannelInput>(){

                    public AudioChannelInput parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                        return new AudioChannelInput(input, extensionRegistry);
                    }
                };

                private AudioChannelInput(GeneratedMessageV3.Builder<?> builder) {
                    super(builder);
                }

                private AudioChannelInput() {
                    this.key_ = "";
                }

                protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
                    return new AudioChannelInput();
                }

                public final UnknownFieldSet getUnknownFields() {
                    return this.unknownFields;
                }

                private AudioChannelInput(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    this();
                    if (extensionRegistry == null) {
                        throw new NullPointerException();
                    }
                    UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
                    try {
                        boolean done = false;
                        block13: while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0: {
                                    done = true;
                                    continue block13;
                                }
                                case 10: {
                                    String s = input.readStringRequireUtf8();
                                    this.key_ = s;
                                    continue block13;
                                }
                                case 16: {
                                    this.track_ = input.readInt32();
                                    continue block13;
                                }
                                case 24: {
                                    this.channel_ = input.readInt32();
                                    continue block13;
                                }
                                case 33: {
                                    this.gainDb_ = input.readDouble();
                                    continue block13;
                                }
                            }
                            if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                            done = true;
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage((MessageLite)this);
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
                    }
                    finally {
                        this.unknownFields = unknownFields.build();
                        this.makeExtensionsImmutable();
                    }
                }

                public static final Descriptors.Descriptor getDescriptor() {
                    return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_AudioAtom_AudioChannel_AudioChannelInput_descriptor;
                }

                protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                    return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_AudioAtom_AudioChannel_AudioChannelInput_fieldAccessorTable.ensureFieldAccessorsInitialized(AudioChannelInput.class, Builder.class);
                }

                @Override
                public String getKey() {
                    Object ref = this.key_;
                    if (ref instanceof String) {
                        return (String)ref;
                    }
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.key_ = s;
                    return s;
                }

                @Override
                public ByteString getKeyBytes() {
                    Object ref = this.key_;
                    if (ref instanceof String) {
                        ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                        this.key_ = b;
                        return b;
                    }
                    return (ByteString)ref;
                }

                @Override
                public int getTrack() {
                    return this.track_;
                }

                @Override
                public int getChannel() {
                    return this.channel_;
                }

                @Override
                public double getGainDb() {
                    return this.gainDb_;
                }

                public final boolean isInitialized() {
                    byte isInitialized = this.memoizedIsInitialized;
                    if (isInitialized == 1) {
                        return true;
                    }
                    if (isInitialized == 0) {
                        return false;
                    }
                    this.memoizedIsInitialized = 1;
                    return true;
                }

                public void writeTo(CodedOutputStream output) throws IOException {
                    if (!this.getKeyBytes().isEmpty()) {
                        GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.key_);
                    }
                    if (this.track_ != 0) {
                        output.writeInt32(2, this.track_);
                    }
                    if (this.channel_ != 0) {
                        output.writeInt32(3, this.channel_);
                    }
                    if (this.gainDb_ != 0.0) {
                        output.writeDouble(4, this.gainDb_);
                    }
                    this.unknownFields.writeTo(output);
                }

                public int getSerializedSize() {
                    int size = this.memoizedSize;
                    if (size != -1) {
                        return size;
                    }
                    size = 0;
                    if (!this.getKeyBytes().isEmpty()) {
                        size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.key_);
                    }
                    if (this.track_ != 0) {
                        size += CodedOutputStream.computeInt32Size((int)2, (int)this.track_);
                    }
                    if (this.channel_ != 0) {
                        size += CodedOutputStream.computeInt32Size((int)3, (int)this.channel_);
                    }
                    if (this.gainDb_ != 0.0) {
                        size += CodedOutputStream.computeDoubleSize((int)4, (double)this.gainDb_);
                    }
                    this.memoizedSize = size += this.unknownFields.getSerializedSize();
                    return size;
                }

                public boolean equals(Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (!(obj instanceof AudioChannelInput)) {
                        return super.equals(obj);
                    }
                    AudioChannelInput other = (AudioChannelInput)obj;
                    if (!this.getKey().equals(other.getKey())) {
                        return false;
                    }
                    if (this.getTrack() != other.getTrack()) {
                        return false;
                    }
                    if (this.getChannel() != other.getChannel()) {
                        return false;
                    }
                    if (Double.doubleToLongBits(this.getGainDb()) != Double.doubleToLongBits(other.getGainDb())) {
                        return false;
                    }
                    return this.unknownFields.equals((Object)other.unknownFields);
                }

                public int hashCode() {
                    if (this.memoizedHashCode != 0) {
                        return this.memoizedHashCode;
                    }
                    int hash = 41;
                    hash = 19 * hash + AudioChannelInput.getDescriptor().hashCode();
                    hash = 37 * hash + 1;
                    hash = 53 * hash + this.getKey().hashCode();
                    hash = 37 * hash + 2;
                    hash = 53 * hash + this.getTrack();
                    hash = 37 * hash + 3;
                    hash = 53 * hash + this.getChannel();
                    hash = 37 * hash + 4;
                    hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getGainDb()));
                    this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
                    return hash;
                }

                public static AudioChannelInput parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
                    return (AudioChannelInput)PARSER.parseFrom(data);
                }

                public static AudioChannelInput parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    return (AudioChannelInput)PARSER.parseFrom(data, extensionRegistry);
                }

                public static AudioChannelInput parseFrom(ByteString data) throws InvalidProtocolBufferException {
                    return (AudioChannelInput)PARSER.parseFrom(data);
                }

                public static AudioChannelInput parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    return (AudioChannelInput)PARSER.parseFrom(data, extensionRegistry);
                }

                public static AudioChannelInput parseFrom(byte[] data) throws InvalidProtocolBufferException {
                    return (AudioChannelInput)PARSER.parseFrom(data);
                }

                public static AudioChannelInput parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    return (AudioChannelInput)PARSER.parseFrom(data, extensionRegistry);
                }

                public static AudioChannelInput parseFrom(InputStream input) throws IOException {
                    return (AudioChannelInput)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
                }

                public static AudioChannelInput parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    return (AudioChannelInput)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
                }

                public static AudioChannelInput parseDelimitedFrom(InputStream input) throws IOException {
                    return (AudioChannelInput)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
                }

                public static AudioChannelInput parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    return (AudioChannelInput)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
                }

                public static AudioChannelInput parseFrom(CodedInputStream input) throws IOException {
                    return (AudioChannelInput)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
                }

                public static AudioChannelInput parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    return (AudioChannelInput)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
                }

                public Builder newBuilderForType() {
                    return AudioChannelInput.newBuilder();
                }

                public static Builder newBuilder() {
                    return DEFAULT_INSTANCE.toBuilder();
                }

                public static Builder newBuilder(AudioChannelInput prototype) {
                    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
                }

                public Builder toBuilder() {
                    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
                }

                protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
                    Builder builder = new Builder(parent);
                    return builder;
                }

                public static AudioChannelInput getDefaultInstance() {
                    return DEFAULT_INSTANCE;
                }

                public static Parser<AudioChannelInput> parser() {
                    return PARSER;
                }

                public Parser<AudioChannelInput> getParserForType() {
                    return PARSER;
                }

                public AudioChannelInput getDefaultInstanceForType() {
                    return DEFAULT_INSTANCE;
                }

                public static final class Builder
                extends GeneratedMessageV3.Builder<Builder>
                implements AudioChannelInputOrBuilder {
                    private Object key_ = "";
                    private int track_;
                    private int channel_;
                    private double gainDb_;

                    public static final Descriptors.Descriptor getDescriptor() {
                        return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_AudioAtom_AudioChannel_AudioChannelInput_descriptor;
                    }

                    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                        return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_AudioAtom_AudioChannel_AudioChannelInput_fieldAccessorTable.ensureFieldAccessorsInitialized(AudioChannelInput.class, Builder.class);
                    }

                    private Builder() {
                        this.maybeForceBuilderInitialization();
                    }

                    private Builder(GeneratedMessageV3.BuilderParent parent) {
                        super(parent);
                        this.maybeForceBuilderInitialization();
                    }

                    private void maybeForceBuilderInitialization() {
                        if (alwaysUseFieldBuilders) {
                            // empty if block
                        }
                    }

                    public Builder clear() {
                        super.clear();
                        this.key_ = "";
                        this.track_ = 0;
                        this.channel_ = 0;
                        this.gainDb_ = 0.0;
                        return this;
                    }

                    public Descriptors.Descriptor getDescriptorForType() {
                        return ResourcesProto.internal_static_google_cloud_video_transcoder_v1beta1_AudioStream_AudioAtom_AudioChannel_AudioChannelInput_descriptor;
                    }

                    public AudioChannelInput getDefaultInstanceForType() {
                        return AudioChannelInput.getDefaultInstance();
                    }

                    public AudioChannelInput build() {
                        AudioChannelInput result = this.buildPartial();
                        if (!result.isInitialized()) {
                            throw Builder.newUninitializedMessageException((Message)result);
                        }
                        return result;
                    }

                    public AudioChannelInput buildPartial() {
                        AudioChannelInput result = new AudioChannelInput(this);
                        result.key_ = this.key_;
                        result.track_ = this.track_;
                        result.channel_ = this.channel_;
                        result.gainDb_ = this.gainDb_;
                        this.onBuilt();
                        return result;
                    }

                    public Builder clone() {
                        return (Builder)super.clone();
                    }

                    public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                        return (Builder)super.setField(field, value);
                    }

                    public Builder clearField(Descriptors.FieldDescriptor field) {
                        return (Builder)super.clearField(field);
                    }

                    public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                        return (Builder)super.clearOneof(oneof);
                    }

                    public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                        return (Builder)super.setRepeatedField(field, index, value);
                    }

                    public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                        return (Builder)super.addRepeatedField(field, value);
                    }

                    public Builder mergeFrom(Message other) {
                        if (other instanceof AudioChannelInput) {
                            return this.mergeFrom((AudioChannelInput)other);
                        }
                        super.mergeFrom(other);
                        return this;
                    }

                    public Builder mergeFrom(AudioChannelInput other) {
                        if (other == AudioChannelInput.getDefaultInstance()) {
                            return this;
                        }
                        if (!other.getKey().isEmpty()) {
                            this.key_ = other.key_;
                            this.onChanged();
                        }
                        if (other.getTrack() != 0) {
                            this.setTrack(other.getTrack());
                        }
                        if (other.getChannel() != 0) {
                            this.setChannel(other.getChannel());
                        }
                        if (other.getGainDb() != 0.0) {
                            this.setGainDb(other.getGainDb());
                        }
                        this.mergeUnknownFields(other.unknownFields);
                        this.onChanged();
                        return this;
                    }

                    public final boolean isInitialized() {
                        return true;
                    }

                    public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                        AudioChannelInput parsedMessage = null;
                        try {
                            parsedMessage = (AudioChannelInput)PARSER.parsePartialFrom(input, extensionRegistry);
                        }
                        catch (InvalidProtocolBufferException e) {
                            parsedMessage = (AudioChannelInput)e.getUnfinishedMessage();
                            throw e.unwrapIOException();
                        }
                        finally {
                            if (parsedMessage != null) {
                                this.mergeFrom(parsedMessage);
                            }
                        }
                        return this;
                    }

                    @Override
                    public String getKey() {
                        Object ref = this.key_;
                        if (!(ref instanceof String)) {
                            ByteString bs = (ByteString)ref;
                            String s = bs.toStringUtf8();
                            this.key_ = s;
                            return s;
                        }
                        return (String)ref;
                    }

                    @Override
                    public ByteString getKeyBytes() {
                        Object ref = this.key_;
                        if (ref instanceof String) {
                            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                            this.key_ = b;
                            return b;
                        }
                        return (ByteString)ref;
                    }

                    public Builder setKey(String value) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        this.key_ = value;
                        this.onChanged();
                        return this;
                    }

                    public Builder clearKey() {
                        this.key_ = AudioChannelInput.getDefaultInstance().getKey();
                        this.onChanged();
                        return this;
                    }

                    public Builder setKeyBytes(ByteString value) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        AudioChannelInput.checkByteStringIsUtf8((ByteString)value);
                        this.key_ = value;
                        this.onChanged();
                        return this;
                    }

                    @Override
                    public int getTrack() {
                        return this.track_;
                    }

                    public Builder setTrack(int value) {
                        this.track_ = value;
                        this.onChanged();
                        return this;
                    }

                    public Builder clearTrack() {
                        this.track_ = 0;
                        this.onChanged();
                        return this;
                    }

                    @Override
                    public int getChannel() {
                        return this.channel_;
                    }

                    public Builder setChannel(int value) {
                        this.channel_ = value;
                        this.onChanged();
                        return this;
                    }

                    public Builder clearChannel() {
                        this.channel_ = 0;
                        this.onChanged();
                        return this;
                    }

                    @Override
                    public double getGainDb() {
                        return this.gainDb_;
                    }

                    public Builder setGainDb(double value) {
                        this.gainDb_ = value;
                        this.onChanged();
                        return this;
                    }

                    public Builder clearGainDb() {
                        this.gainDb_ = 0.0;
                        this.onChanged();
                        return this;
                    }

                    public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                        return (Builder)super.setUnknownFields(unknownFields);
                    }

                    public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                        return (Builder)super.mergeUnknownFields(unknownFields);
                    }
                }
            }

            public static interface AudioChannelInputOrBuilder
            extends MessageOrBuilder {
                public String getKey();

                public ByteString getKeyBytes();

                public int getTrack();

                public int getChannel();

                public double getGainDb();
            }
        }

        public static interface AudioChannelOrBuilder
        extends MessageOrBuilder {
            public List<AudioChannel.AudioChannelInput> getInputsList();

            public AudioChannel.AudioChannelInput getInputs(int var1);

            public int getInputsCount();

            public List<? extends AudioChannel.AudioChannelInputOrBuilder> getInputsOrBuilderList();

            public AudioChannel.AudioChannelInputOrBuilder getInputsOrBuilder(int var1);
        }
    }

    public static interface AudioAtomOrBuilder
    extends MessageOrBuilder {
        public String getKey();

        public ByteString getKeyBytes();

        public List<AudioAtom.AudioChannel> getChannelsList();

        public AudioAtom.AudioChannel getChannels(int var1);

        public int getChannelsCount();

        public List<? extends AudioAtom.AudioChannelOrBuilder> getChannelsOrBuilderList();

        public AudioAtom.AudioChannelOrBuilder getChannelsOrBuilder(int var1);
    }
}

