/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProductSetName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/productSets/{product_set}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String productSet;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProductSet() {
        return this.productSet;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProductSetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.productSet = (String)Preconditions.checkNotNull((Object)builder.getProductSet());
    }

    public static ProductSetName of(String project, String location, String productSet) {
        return ProductSetName.newBuilder().setProject(project).setLocation(location).setProductSet(productSet).build();
    }

    public static String format(String project, String location, String productSet) {
        return ProductSetName.newBuilder().setProject(project).setLocation(location).setProductSet(productSet).build().toString();
    }

    public static ProductSetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProductSetName.parse: formattedString not in valid format");
        return ProductSetName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("product_set"));
    }

    public static List<ProductSetName> parseList(List<String> formattedStrings) {
        ArrayList<ProductSetName> list = new ArrayList<ProductSetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProductSetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProductSetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProductSetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProductSetName productSetName = this;
            synchronized (productSetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"productSet", (Object)this.productSet);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "product_set", this.productSet});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProductSetName) {
            ProductSetName that = (ProductSetName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.productSet.equals(that.productSet);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.productSet.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String productSet;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProductSet() {
            return this.productSet;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setProductSet(String productSet) {
            this.productSet = productSet;
            return this;
        }

        private Builder() {
        }

        private Builder(ProductSetName productSetName) {
            this.project = productSetName.project;
            this.location = productSetName.location;
            this.productSet = productSetName.productSet;
        }

        public ProductSetName build() {
            return new ProductSetName(this);
        }
    }
}

