/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReferenceImageName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/products/{product}/referenceImages/{reference_image}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String product;
    private final String referenceImage;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProduct() {
        return this.product;
    }

    public String getReferenceImage() {
        return this.referenceImage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ReferenceImageName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.product = (String)Preconditions.checkNotNull((Object)builder.getProduct());
        this.referenceImage = (String)Preconditions.checkNotNull((Object)builder.getReferenceImage());
    }

    public static ReferenceImageName of(String project, String location, String product, String referenceImage) {
        return ReferenceImageName.newBuilder().setProject(project).setLocation(location).setProduct(product).setReferenceImage(referenceImage).build();
    }

    public static String format(String project, String location, String product, String referenceImage) {
        return ReferenceImageName.newBuilder().setProject(project).setLocation(location).setProduct(product).setReferenceImage(referenceImage).build().toString();
    }

    public static ReferenceImageName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ReferenceImageName.parse: formattedString not in valid format");
        return ReferenceImageName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("product"), (String)matchMap.get("reference_image"));
    }

    public static List<ReferenceImageName> parseList(List<String> formattedStrings) {
        ArrayList<ReferenceImageName> list = new ArrayList<ReferenceImageName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReferenceImageName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReferenceImageName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReferenceImageName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReferenceImageName referenceImageName = this;
            synchronized (referenceImageName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"product", (Object)this.product);
                    fieldMapBuilder.put((Object)"referenceImage", (Object)this.referenceImage);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "product", this.product, "reference_image", this.referenceImage});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReferenceImageName) {
            ReferenceImageName that = (ReferenceImageName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.product.equals(that.product) && this.referenceImage.equals(that.referenceImage);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.product.hashCode();
        h *= 1000003;
        return h ^= this.referenceImage.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String product;
        private String referenceImage;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProduct() {
            return this.product;
        }

        public String getReferenceImage() {
            return this.referenceImage;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setProduct(String product) {
            this.product = product;
            return this;
        }

        public Builder setReferenceImage(String referenceImage) {
            this.referenceImage = referenceImage;
            return this;
        }

        private Builder() {
        }

        private Builder(ReferenceImageName referenceImageName) {
            this.project = referenceImageName.project;
            this.location = referenceImageName.location;
            this.product = referenceImageName.product;
            this.referenceImage = referenceImageName.referenceImage;
        }

        public ReferenceImageName build() {
            return new ReferenceImageName(this);
        }
    }
}

