/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1/image_annotator.proto

package com.google.cloud.vision.v1;

/**
 *
 *
 * <pre>
 * Image context and/or feature-specific parameters.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1.ImageContext}
 */
public final class ImageContext extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1.ImageContext)
    ImageContextOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImageContext.newBuilder() to construct.
  private ImageContext(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImageContext() {
    languageHints_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImageContext();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1.ImageAnnotatorProto
        .internal_static_google_cloud_vision_v1_ImageContext_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1.ImageAnnotatorProto
        .internal_static_google_cloud_vision_v1_ImageContext_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1.ImageContext.class,
            com.google.cloud.vision.v1.ImageContext.Builder.class);
  }

  public static final int LAT_LONG_RECT_FIELD_NUMBER = 1;
  private com.google.cloud.vision.v1.LatLongRect latLongRect_;
  /**
   *
   *
   * <pre>
   * Not used.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.LatLongRect lat_long_rect = 1;</code>
   *
   * @return Whether the latLongRect field is set.
   */
  @java.lang.Override
  public boolean hasLatLongRect() {
    return latLongRect_ != null;
  }
  /**
   *
   *
   * <pre>
   * Not used.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.LatLongRect lat_long_rect = 1;</code>
   *
   * @return The latLongRect.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1.LatLongRect getLatLongRect() {
    return latLongRect_ == null
        ? com.google.cloud.vision.v1.LatLongRect.getDefaultInstance()
        : latLongRect_;
  }
  /**
   *
   *
   * <pre>
   * Not used.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.LatLongRect lat_long_rect = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1.LatLongRectOrBuilder getLatLongRectOrBuilder() {
    return latLongRect_ == null
        ? com.google.cloud.vision.v1.LatLongRect.getDefaultInstance()
        : latLongRect_;
  }

  public static final int LANGUAGE_HINTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList languageHints_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * List of languages to use for TEXT_DETECTION. In most cases, an empty value
   * yields the best results since it enables automatic language detection. For
   * languages based on the Latin alphabet, setting `language_hints` is not
   * needed. In rare cases, when the language of the text in the image is known,
   * setting a hint will help get better results (although it will be a
   * significant hindrance if the hint is wrong). Text detection returns an
   * error if one or more of the specified languages is not one of the
   * [supported languages](https://cloud.google.com/vision/docs/languages).
   * </pre>
   *
   * <code>repeated string language_hints = 2;</code>
   *
   * @return A list containing the languageHints.
   */
  public com.google.protobuf.ProtocolStringList getLanguageHintsList() {
    return languageHints_;
  }
  /**
   *
   *
   * <pre>
   * List of languages to use for TEXT_DETECTION. In most cases, an empty value
   * yields the best results since it enables automatic language detection. For
   * languages based on the Latin alphabet, setting `language_hints` is not
   * needed. In rare cases, when the language of the text in the image is known,
   * setting a hint will help get better results (although it will be a
   * significant hindrance if the hint is wrong). Text detection returns an
   * error if one or more of the specified languages is not one of the
   * [supported languages](https://cloud.google.com/vision/docs/languages).
   * </pre>
   *
   * <code>repeated string language_hints = 2;</code>
   *
   * @return The count of languageHints.
   */
  public int getLanguageHintsCount() {
    return languageHints_.size();
  }
  /**
   *
   *
   * <pre>
   * List of languages to use for TEXT_DETECTION. In most cases, an empty value
   * yields the best results since it enables automatic language detection. For
   * languages based on the Latin alphabet, setting `language_hints` is not
   * needed. In rare cases, when the language of the text in the image is known,
   * setting a hint will help get better results (although it will be a
   * significant hindrance if the hint is wrong). Text detection returns an
   * error if one or more of the specified languages is not one of the
   * [supported languages](https://cloud.google.com/vision/docs/languages).
   * </pre>
   *
   * <code>repeated string language_hints = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The languageHints at the given index.
   */
  public java.lang.String getLanguageHints(int index) {
    return languageHints_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of languages to use for TEXT_DETECTION. In most cases, an empty value
   * yields the best results since it enables automatic language detection. For
   * languages based on the Latin alphabet, setting `language_hints` is not
   * needed. In rare cases, when the language of the text in the image is known,
   * setting a hint will help get better results (although it will be a
   * significant hindrance if the hint is wrong). Text detection returns an
   * error if one or more of the specified languages is not one of the
   * [supported languages](https://cloud.google.com/vision/docs/languages).
   * </pre>
   *
   * <code>repeated string language_hints = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the languageHints at the given index.
   */
  public com.google.protobuf.ByteString getLanguageHintsBytes(int index) {
    return languageHints_.getByteString(index);
  }

  public static final int CROP_HINTS_PARAMS_FIELD_NUMBER = 4;
  private com.google.cloud.vision.v1.CropHintsParams cropHintsParams_;
  /**
   *
   *
   * <pre>
   * Parameters for crop hints annotation request.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.CropHintsParams crop_hints_params = 4;</code>
   *
   * @return Whether the cropHintsParams field is set.
   */
  @java.lang.Override
  public boolean hasCropHintsParams() {
    return cropHintsParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * Parameters for crop hints annotation request.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.CropHintsParams crop_hints_params = 4;</code>
   *
   * @return The cropHintsParams.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1.CropHintsParams getCropHintsParams() {
    return cropHintsParams_ == null
        ? com.google.cloud.vision.v1.CropHintsParams.getDefaultInstance()
        : cropHintsParams_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for crop hints annotation request.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.CropHintsParams crop_hints_params = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1.CropHintsParamsOrBuilder getCropHintsParamsOrBuilder() {
    return cropHintsParams_ == null
        ? com.google.cloud.vision.v1.CropHintsParams.getDefaultInstance()
        : cropHintsParams_;
  }

  public static final int PRODUCT_SEARCH_PARAMS_FIELD_NUMBER = 5;
  private com.google.cloud.vision.v1.ProductSearchParams productSearchParams_;
  /**
   *
   *
   * <pre>
   * Parameters for product search.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.ProductSearchParams product_search_params = 5;</code>
   *
   * @return Whether the productSearchParams field is set.
   */
  @java.lang.Override
  public boolean hasProductSearchParams() {
    return productSearchParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * Parameters for product search.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.ProductSearchParams product_search_params = 5;</code>
   *
   * @return The productSearchParams.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1.ProductSearchParams getProductSearchParams() {
    return productSearchParams_ == null
        ? com.google.cloud.vision.v1.ProductSearchParams.getDefaultInstance()
        : productSearchParams_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for product search.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.ProductSearchParams product_search_params = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1.ProductSearchParamsOrBuilder getProductSearchParamsOrBuilder() {
    return productSearchParams_ == null
        ? com.google.cloud.vision.v1.ProductSearchParams.getDefaultInstance()
        : productSearchParams_;
  }

  public static final int WEB_DETECTION_PARAMS_FIELD_NUMBER = 6;
  private com.google.cloud.vision.v1.WebDetectionParams webDetectionParams_;
  /**
   *
   *
   * <pre>
   * Parameters for web detection.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.WebDetectionParams web_detection_params = 6;</code>
   *
   * @return Whether the webDetectionParams field is set.
   */
  @java.lang.Override
  public boolean hasWebDetectionParams() {
    return webDetectionParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * Parameters for web detection.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.WebDetectionParams web_detection_params = 6;</code>
   *
   * @return The webDetectionParams.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1.WebDetectionParams getWebDetectionParams() {
    return webDetectionParams_ == null
        ? com.google.cloud.vision.v1.WebDetectionParams.getDefaultInstance()
        : webDetectionParams_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for web detection.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.WebDetectionParams web_detection_params = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1.WebDetectionParamsOrBuilder getWebDetectionParamsOrBuilder() {
    return webDetectionParams_ == null
        ? com.google.cloud.vision.v1.WebDetectionParams.getDefaultInstance()
        : webDetectionParams_;
  }

  public static final int TEXT_DETECTION_PARAMS_FIELD_NUMBER = 12;
  private com.google.cloud.vision.v1.TextDetectionParams textDetectionParams_;
  /**
   *
   *
   * <pre>
   * Parameters for text detection and document text detection.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.TextDetectionParams text_detection_params = 12;</code>
   *
   * @return Whether the textDetectionParams field is set.
   */
  @java.lang.Override
  public boolean hasTextDetectionParams() {
    return textDetectionParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * Parameters for text detection and document text detection.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.TextDetectionParams text_detection_params = 12;</code>
   *
   * @return The textDetectionParams.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1.TextDetectionParams getTextDetectionParams() {
    return textDetectionParams_ == null
        ? com.google.cloud.vision.v1.TextDetectionParams.getDefaultInstance()
        : textDetectionParams_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for text detection and document text detection.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.TextDetectionParams text_detection_params = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1.TextDetectionParamsOrBuilder getTextDetectionParamsOrBuilder() {
    return textDetectionParams_ == null
        ? com.google.cloud.vision.v1.TextDetectionParams.getDefaultInstance()
        : textDetectionParams_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (latLongRect_ != null) {
      output.writeMessage(1, getLatLongRect());
    }
    for (int i = 0; i < languageHints_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, languageHints_.getRaw(i));
    }
    if (cropHintsParams_ != null) {
      output.writeMessage(4, getCropHintsParams());
    }
    if (productSearchParams_ != null) {
      output.writeMessage(5, getProductSearchParams());
    }
    if (webDetectionParams_ != null) {
      output.writeMessage(6, getWebDetectionParams());
    }
    if (textDetectionParams_ != null) {
      output.writeMessage(12, getTextDetectionParams());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (latLongRect_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLatLongRect());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < languageHints_.size(); i++) {
        dataSize += computeStringSizeNoTag(languageHints_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getLanguageHintsList().size();
    }
    if (cropHintsParams_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCropHintsParams());
    }
    if (productSearchParams_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getProductSearchParams());
    }
    if (webDetectionParams_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getWebDetectionParams());
    }
    if (textDetectionParams_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(12, getTextDetectionParams());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1.ImageContext)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1.ImageContext other = (com.google.cloud.vision.v1.ImageContext) obj;

    if (hasLatLongRect() != other.hasLatLongRect()) return false;
    if (hasLatLongRect()) {
      if (!getLatLongRect().equals(other.getLatLongRect())) return false;
    }
    if (!getLanguageHintsList().equals(other.getLanguageHintsList())) return false;
    if (hasCropHintsParams() != other.hasCropHintsParams()) return false;
    if (hasCropHintsParams()) {
      if (!getCropHintsParams().equals(other.getCropHintsParams())) return false;
    }
    if (hasProductSearchParams() != other.hasProductSearchParams()) return false;
    if (hasProductSearchParams()) {
      if (!getProductSearchParams().equals(other.getProductSearchParams())) return false;
    }
    if (hasWebDetectionParams() != other.hasWebDetectionParams()) return false;
    if (hasWebDetectionParams()) {
      if (!getWebDetectionParams().equals(other.getWebDetectionParams())) return false;
    }
    if (hasTextDetectionParams() != other.hasTextDetectionParams()) return false;
    if (hasTextDetectionParams()) {
      if (!getTextDetectionParams().equals(other.getTextDetectionParams())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasLatLongRect()) {
      hash = (37 * hash) + LAT_LONG_RECT_FIELD_NUMBER;
      hash = (53 * hash) + getLatLongRect().hashCode();
    }
    if (getLanguageHintsCount() > 0) {
      hash = (37 * hash) + LANGUAGE_HINTS_FIELD_NUMBER;
      hash = (53 * hash) + getLanguageHintsList().hashCode();
    }
    if (hasCropHintsParams()) {
      hash = (37 * hash) + CROP_HINTS_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getCropHintsParams().hashCode();
    }
    if (hasProductSearchParams()) {
      hash = (37 * hash) + PRODUCT_SEARCH_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getProductSearchParams().hashCode();
    }
    if (hasWebDetectionParams()) {
      hash = (37 * hash) + WEB_DETECTION_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getWebDetectionParams().hashCode();
    }
    if (hasTextDetectionParams()) {
      hash = (37 * hash) + TEXT_DETECTION_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getTextDetectionParams().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1.ImageContext parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1.ImageContext parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1.ImageContext parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1.ImageContext parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1.ImageContext parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1.ImageContext parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1.ImageContext parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1.ImageContext parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1.ImageContext parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1.ImageContext parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1.ImageContext parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1.ImageContext parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vision.v1.ImageContext prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Image context and/or feature-specific parameters.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1.ImageContext}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1.ImageContext)
      com.google.cloud.vision.v1.ImageContextOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1_ImageContext_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1_ImageContext_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1.ImageContext.class,
              com.google.cloud.vision.v1.ImageContext.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1.ImageContext.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      latLongRect_ = null;
      if (latLongRectBuilder_ != null) {
        latLongRectBuilder_.dispose();
        latLongRectBuilder_ = null;
      }
      languageHints_ = com.google.protobuf.LazyStringArrayList.emptyList();
      cropHintsParams_ = null;
      if (cropHintsParamsBuilder_ != null) {
        cropHintsParamsBuilder_.dispose();
        cropHintsParamsBuilder_ = null;
      }
      productSearchParams_ = null;
      if (productSearchParamsBuilder_ != null) {
        productSearchParamsBuilder_.dispose();
        productSearchParamsBuilder_ = null;
      }
      webDetectionParams_ = null;
      if (webDetectionParamsBuilder_ != null) {
        webDetectionParamsBuilder_.dispose();
        webDetectionParamsBuilder_ = null;
      }
      textDetectionParams_ = null;
      if (textDetectionParamsBuilder_ != null) {
        textDetectionParamsBuilder_.dispose();
        textDetectionParamsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1_ImageContext_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1.ImageContext getDefaultInstanceForType() {
      return com.google.cloud.vision.v1.ImageContext.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1.ImageContext build() {
      com.google.cloud.vision.v1.ImageContext result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1.ImageContext buildPartial() {
      com.google.cloud.vision.v1.ImageContext result =
          new com.google.cloud.vision.v1.ImageContext(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.vision.v1.ImageContext result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.latLongRect_ =
            latLongRectBuilder_ == null ? latLongRect_ : latLongRectBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        languageHints_.makeImmutable();
        result.languageHints_ = languageHints_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.cropHintsParams_ =
            cropHintsParamsBuilder_ == null ? cropHintsParams_ : cropHintsParamsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.productSearchParams_ =
            productSearchParamsBuilder_ == null
                ? productSearchParams_
                : productSearchParamsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.webDetectionParams_ =
            webDetectionParamsBuilder_ == null
                ? webDetectionParams_
                : webDetectionParamsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.textDetectionParams_ =
            textDetectionParamsBuilder_ == null
                ? textDetectionParams_
                : textDetectionParamsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1.ImageContext) {
        return mergeFrom((com.google.cloud.vision.v1.ImageContext) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1.ImageContext other) {
      if (other == com.google.cloud.vision.v1.ImageContext.getDefaultInstance()) return this;
      if (other.hasLatLongRect()) {
        mergeLatLongRect(other.getLatLongRect());
      }
      if (!other.languageHints_.isEmpty()) {
        if (languageHints_.isEmpty()) {
          languageHints_ = other.languageHints_;
          bitField0_ |= 0x00000002;
        } else {
          ensureLanguageHintsIsMutable();
          languageHints_.addAll(other.languageHints_);
        }
        onChanged();
      }
      if (other.hasCropHintsParams()) {
        mergeCropHintsParams(other.getCropHintsParams());
      }
      if (other.hasProductSearchParams()) {
        mergeProductSearchParams(other.getProductSearchParams());
      }
      if (other.hasWebDetectionParams()) {
        mergeWebDetectionParams(other.getWebDetectionParams());
      }
      if (other.hasTextDetectionParams()) {
        mergeTextDetectionParams(other.getTextDetectionParams());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getLatLongRectFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLanguageHintsIsMutable();
                languageHints_.add(s);
                break;
              } // case 18
            case 34:
              {
                input.readMessage(getCropHintsParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getProductSearchParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getWebDetectionParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 98:
              {
                input.readMessage(
                    getTextDetectionParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.vision.v1.LatLongRect latLongRect_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1.LatLongRect,
            com.google.cloud.vision.v1.LatLongRect.Builder,
            com.google.cloud.vision.v1.LatLongRectOrBuilder>
        latLongRectBuilder_;
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.LatLongRect lat_long_rect = 1;</code>
     *
     * @return Whether the latLongRect field is set.
     */
    public boolean hasLatLongRect() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.LatLongRect lat_long_rect = 1;</code>
     *
     * @return The latLongRect.
     */
    public com.google.cloud.vision.v1.LatLongRect getLatLongRect() {
      if (latLongRectBuilder_ == null) {
        return latLongRect_ == null
            ? com.google.cloud.vision.v1.LatLongRect.getDefaultInstance()
            : latLongRect_;
      } else {
        return latLongRectBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.LatLongRect lat_long_rect = 1;</code>
     */
    public Builder setLatLongRect(com.google.cloud.vision.v1.LatLongRect value) {
      if (latLongRectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        latLongRect_ = value;
      } else {
        latLongRectBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.LatLongRect lat_long_rect = 1;</code>
     */
    public Builder setLatLongRect(com.google.cloud.vision.v1.LatLongRect.Builder builderForValue) {
      if (latLongRectBuilder_ == null) {
        latLongRect_ = builderForValue.build();
      } else {
        latLongRectBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.LatLongRect lat_long_rect = 1;</code>
     */
    public Builder mergeLatLongRect(com.google.cloud.vision.v1.LatLongRect value) {
      if (latLongRectBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && latLongRect_ != null
            && latLongRect_ != com.google.cloud.vision.v1.LatLongRect.getDefaultInstance()) {
          getLatLongRectBuilder().mergeFrom(value);
        } else {
          latLongRect_ = value;
        }
      } else {
        latLongRectBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.LatLongRect lat_long_rect = 1;</code>
     */
    public Builder clearLatLongRect() {
      bitField0_ = (bitField0_ & ~0x00000001);
      latLongRect_ = null;
      if (latLongRectBuilder_ != null) {
        latLongRectBuilder_.dispose();
        latLongRectBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.LatLongRect lat_long_rect = 1;</code>
     */
    public com.google.cloud.vision.v1.LatLongRect.Builder getLatLongRectBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getLatLongRectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.LatLongRect lat_long_rect = 1;</code>
     */
    public com.google.cloud.vision.v1.LatLongRectOrBuilder getLatLongRectOrBuilder() {
      if (latLongRectBuilder_ != null) {
        return latLongRectBuilder_.getMessageOrBuilder();
      } else {
        return latLongRect_ == null
            ? com.google.cloud.vision.v1.LatLongRect.getDefaultInstance()
            : latLongRect_;
      }
    }
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.LatLongRect lat_long_rect = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1.LatLongRect,
            com.google.cloud.vision.v1.LatLongRect.Builder,
            com.google.cloud.vision.v1.LatLongRectOrBuilder>
        getLatLongRectFieldBuilder() {
      if (latLongRectBuilder_ == null) {
        latLongRectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1.LatLongRect,
                com.google.cloud.vision.v1.LatLongRect.Builder,
                com.google.cloud.vision.v1.LatLongRectOrBuilder>(
                getLatLongRect(), getParentForChildren(), isClean());
        latLongRect_ = null;
      }
      return latLongRectBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList languageHints_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureLanguageHintsIsMutable() {
      if (!languageHints_.isModifiable()) {
        languageHints_ = new com.google.protobuf.LazyStringArrayList(languageHints_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @return A list containing the languageHints.
     */
    public com.google.protobuf.ProtocolStringList getLanguageHintsList() {
      languageHints_.makeImmutable();
      return languageHints_;
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @return The count of languageHints.
     */
    public int getLanguageHintsCount() {
      return languageHints_.size();
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The languageHints at the given index.
     */
    public java.lang.String getLanguageHints(int index) {
      return languageHints_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the languageHints at the given index.
     */
    public com.google.protobuf.ByteString getLanguageHintsBytes(int index) {
      return languageHints_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The languageHints to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageHints(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLanguageHintsIsMutable();
      languageHints_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @param value The languageHints to add.
     * @return This builder for chaining.
     */
    public Builder addLanguageHints(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLanguageHintsIsMutable();
      languageHints_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @param values The languageHints to add.
     * @return This builder for chaining.
     */
    public Builder addAllLanguageHints(java.lang.Iterable<java.lang.String> values) {
      ensureLanguageHintsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, languageHints_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageHints() {
      languageHints_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of languages to use for TEXT_DETECTION. In most cases, an empty value
     * yields the best results since it enables automatic language detection. For
     * languages based on the Latin alphabet, setting `language_hints` is not
     * needed. In rare cases, when the language of the text in the image is known,
     * setting a hint will help get better results (although it will be a
     * significant hindrance if the hint is wrong). Text detection returns an
     * error if one or more of the specified languages is not one of the
     * [supported languages](https://cloud.google.com/vision/docs/languages).
     * </pre>
     *
     * <code>repeated string language_hints = 2;</code>
     *
     * @param value The bytes of the languageHints to add.
     * @return This builder for chaining.
     */
    public Builder addLanguageHintsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLanguageHintsIsMutable();
      languageHints_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.vision.v1.CropHintsParams cropHintsParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1.CropHintsParams,
            com.google.cloud.vision.v1.CropHintsParams.Builder,
            com.google.cloud.vision.v1.CropHintsParamsOrBuilder>
        cropHintsParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.CropHintsParams crop_hints_params = 4;</code>
     *
     * @return Whether the cropHintsParams field is set.
     */
    public boolean hasCropHintsParams() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.CropHintsParams crop_hints_params = 4;</code>
     *
     * @return The cropHintsParams.
     */
    public com.google.cloud.vision.v1.CropHintsParams getCropHintsParams() {
      if (cropHintsParamsBuilder_ == null) {
        return cropHintsParams_ == null
            ? com.google.cloud.vision.v1.CropHintsParams.getDefaultInstance()
            : cropHintsParams_;
      } else {
        return cropHintsParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.CropHintsParams crop_hints_params = 4;</code>
     */
    public Builder setCropHintsParams(com.google.cloud.vision.v1.CropHintsParams value) {
      if (cropHintsParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cropHintsParams_ = value;
      } else {
        cropHintsParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.CropHintsParams crop_hints_params = 4;</code>
     */
    public Builder setCropHintsParams(
        com.google.cloud.vision.v1.CropHintsParams.Builder builderForValue) {
      if (cropHintsParamsBuilder_ == null) {
        cropHintsParams_ = builderForValue.build();
      } else {
        cropHintsParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.CropHintsParams crop_hints_params = 4;</code>
     */
    public Builder mergeCropHintsParams(com.google.cloud.vision.v1.CropHintsParams value) {
      if (cropHintsParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && cropHintsParams_ != null
            && cropHintsParams_
                != com.google.cloud.vision.v1.CropHintsParams.getDefaultInstance()) {
          getCropHintsParamsBuilder().mergeFrom(value);
        } else {
          cropHintsParams_ = value;
        }
      } else {
        cropHintsParamsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.CropHintsParams crop_hints_params = 4;</code>
     */
    public Builder clearCropHintsParams() {
      bitField0_ = (bitField0_ & ~0x00000004);
      cropHintsParams_ = null;
      if (cropHintsParamsBuilder_ != null) {
        cropHintsParamsBuilder_.dispose();
        cropHintsParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.CropHintsParams crop_hints_params = 4;</code>
     */
    public com.google.cloud.vision.v1.CropHintsParams.Builder getCropHintsParamsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCropHintsParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.CropHintsParams crop_hints_params = 4;</code>
     */
    public com.google.cloud.vision.v1.CropHintsParamsOrBuilder getCropHintsParamsOrBuilder() {
      if (cropHintsParamsBuilder_ != null) {
        return cropHintsParamsBuilder_.getMessageOrBuilder();
      } else {
        return cropHintsParams_ == null
            ? com.google.cloud.vision.v1.CropHintsParams.getDefaultInstance()
            : cropHintsParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for crop hints annotation request.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.CropHintsParams crop_hints_params = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1.CropHintsParams,
            com.google.cloud.vision.v1.CropHintsParams.Builder,
            com.google.cloud.vision.v1.CropHintsParamsOrBuilder>
        getCropHintsParamsFieldBuilder() {
      if (cropHintsParamsBuilder_ == null) {
        cropHintsParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1.CropHintsParams,
                com.google.cloud.vision.v1.CropHintsParams.Builder,
                com.google.cloud.vision.v1.CropHintsParamsOrBuilder>(
                getCropHintsParams(), getParentForChildren(), isClean());
        cropHintsParams_ = null;
      }
      return cropHintsParamsBuilder_;
    }

    private com.google.cloud.vision.v1.ProductSearchParams productSearchParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1.ProductSearchParams,
            com.google.cloud.vision.v1.ProductSearchParams.Builder,
            com.google.cloud.vision.v1.ProductSearchParamsOrBuilder>
        productSearchParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ProductSearchParams product_search_params = 5;</code>
     *
     * @return Whether the productSearchParams field is set.
     */
    public boolean hasProductSearchParams() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ProductSearchParams product_search_params = 5;</code>
     *
     * @return The productSearchParams.
     */
    public com.google.cloud.vision.v1.ProductSearchParams getProductSearchParams() {
      if (productSearchParamsBuilder_ == null) {
        return productSearchParams_ == null
            ? com.google.cloud.vision.v1.ProductSearchParams.getDefaultInstance()
            : productSearchParams_;
      } else {
        return productSearchParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ProductSearchParams product_search_params = 5;</code>
     */
    public Builder setProductSearchParams(com.google.cloud.vision.v1.ProductSearchParams value) {
      if (productSearchParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        productSearchParams_ = value;
      } else {
        productSearchParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ProductSearchParams product_search_params = 5;</code>
     */
    public Builder setProductSearchParams(
        com.google.cloud.vision.v1.ProductSearchParams.Builder builderForValue) {
      if (productSearchParamsBuilder_ == null) {
        productSearchParams_ = builderForValue.build();
      } else {
        productSearchParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ProductSearchParams product_search_params = 5;</code>
     */
    public Builder mergeProductSearchParams(com.google.cloud.vision.v1.ProductSearchParams value) {
      if (productSearchParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && productSearchParams_ != null
            && productSearchParams_
                != com.google.cloud.vision.v1.ProductSearchParams.getDefaultInstance()) {
          getProductSearchParamsBuilder().mergeFrom(value);
        } else {
          productSearchParams_ = value;
        }
      } else {
        productSearchParamsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ProductSearchParams product_search_params = 5;</code>
     */
    public Builder clearProductSearchParams() {
      bitField0_ = (bitField0_ & ~0x00000008);
      productSearchParams_ = null;
      if (productSearchParamsBuilder_ != null) {
        productSearchParamsBuilder_.dispose();
        productSearchParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ProductSearchParams product_search_params = 5;</code>
     */
    public com.google.cloud.vision.v1.ProductSearchParams.Builder getProductSearchParamsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getProductSearchParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ProductSearchParams product_search_params = 5;</code>
     */
    public com.google.cloud.vision.v1.ProductSearchParamsOrBuilder
        getProductSearchParamsOrBuilder() {
      if (productSearchParamsBuilder_ != null) {
        return productSearchParamsBuilder_.getMessageOrBuilder();
      } else {
        return productSearchParams_ == null
            ? com.google.cloud.vision.v1.ProductSearchParams.getDefaultInstance()
            : productSearchParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for product search.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ProductSearchParams product_search_params = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1.ProductSearchParams,
            com.google.cloud.vision.v1.ProductSearchParams.Builder,
            com.google.cloud.vision.v1.ProductSearchParamsOrBuilder>
        getProductSearchParamsFieldBuilder() {
      if (productSearchParamsBuilder_ == null) {
        productSearchParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1.ProductSearchParams,
                com.google.cloud.vision.v1.ProductSearchParams.Builder,
                com.google.cloud.vision.v1.ProductSearchParamsOrBuilder>(
                getProductSearchParams(), getParentForChildren(), isClean());
        productSearchParams_ = null;
      }
      return productSearchParamsBuilder_;
    }

    private com.google.cloud.vision.v1.WebDetectionParams webDetectionParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1.WebDetectionParams,
            com.google.cloud.vision.v1.WebDetectionParams.Builder,
            com.google.cloud.vision.v1.WebDetectionParamsOrBuilder>
        webDetectionParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.WebDetectionParams web_detection_params = 6;</code>
     *
     * @return Whether the webDetectionParams field is set.
     */
    public boolean hasWebDetectionParams() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.WebDetectionParams web_detection_params = 6;</code>
     *
     * @return The webDetectionParams.
     */
    public com.google.cloud.vision.v1.WebDetectionParams getWebDetectionParams() {
      if (webDetectionParamsBuilder_ == null) {
        return webDetectionParams_ == null
            ? com.google.cloud.vision.v1.WebDetectionParams.getDefaultInstance()
            : webDetectionParams_;
      } else {
        return webDetectionParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.WebDetectionParams web_detection_params = 6;</code>
     */
    public Builder setWebDetectionParams(com.google.cloud.vision.v1.WebDetectionParams value) {
      if (webDetectionParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        webDetectionParams_ = value;
      } else {
        webDetectionParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.WebDetectionParams web_detection_params = 6;</code>
     */
    public Builder setWebDetectionParams(
        com.google.cloud.vision.v1.WebDetectionParams.Builder builderForValue) {
      if (webDetectionParamsBuilder_ == null) {
        webDetectionParams_ = builderForValue.build();
      } else {
        webDetectionParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.WebDetectionParams web_detection_params = 6;</code>
     */
    public Builder mergeWebDetectionParams(com.google.cloud.vision.v1.WebDetectionParams value) {
      if (webDetectionParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && webDetectionParams_ != null
            && webDetectionParams_
                != com.google.cloud.vision.v1.WebDetectionParams.getDefaultInstance()) {
          getWebDetectionParamsBuilder().mergeFrom(value);
        } else {
          webDetectionParams_ = value;
        }
      } else {
        webDetectionParamsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.WebDetectionParams web_detection_params = 6;</code>
     */
    public Builder clearWebDetectionParams() {
      bitField0_ = (bitField0_ & ~0x00000010);
      webDetectionParams_ = null;
      if (webDetectionParamsBuilder_ != null) {
        webDetectionParamsBuilder_.dispose();
        webDetectionParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.WebDetectionParams web_detection_params = 6;</code>
     */
    public com.google.cloud.vision.v1.WebDetectionParams.Builder getWebDetectionParamsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getWebDetectionParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.WebDetectionParams web_detection_params = 6;</code>
     */
    public com.google.cloud.vision.v1.WebDetectionParamsOrBuilder getWebDetectionParamsOrBuilder() {
      if (webDetectionParamsBuilder_ != null) {
        return webDetectionParamsBuilder_.getMessageOrBuilder();
      } else {
        return webDetectionParams_ == null
            ? com.google.cloud.vision.v1.WebDetectionParams.getDefaultInstance()
            : webDetectionParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for web detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.WebDetectionParams web_detection_params = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1.WebDetectionParams,
            com.google.cloud.vision.v1.WebDetectionParams.Builder,
            com.google.cloud.vision.v1.WebDetectionParamsOrBuilder>
        getWebDetectionParamsFieldBuilder() {
      if (webDetectionParamsBuilder_ == null) {
        webDetectionParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1.WebDetectionParams,
                com.google.cloud.vision.v1.WebDetectionParams.Builder,
                com.google.cloud.vision.v1.WebDetectionParamsOrBuilder>(
                getWebDetectionParams(), getParentForChildren(), isClean());
        webDetectionParams_ = null;
      }
      return webDetectionParamsBuilder_;
    }

    private com.google.cloud.vision.v1.TextDetectionParams textDetectionParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1.TextDetectionParams,
            com.google.cloud.vision.v1.TextDetectionParams.Builder,
            com.google.cloud.vision.v1.TextDetectionParamsOrBuilder>
        textDetectionParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.TextDetectionParams text_detection_params = 12;</code>
     *
     * @return Whether the textDetectionParams field is set.
     */
    public boolean hasTextDetectionParams() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.TextDetectionParams text_detection_params = 12;</code>
     *
     * @return The textDetectionParams.
     */
    public com.google.cloud.vision.v1.TextDetectionParams getTextDetectionParams() {
      if (textDetectionParamsBuilder_ == null) {
        return textDetectionParams_ == null
            ? com.google.cloud.vision.v1.TextDetectionParams.getDefaultInstance()
            : textDetectionParams_;
      } else {
        return textDetectionParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.TextDetectionParams text_detection_params = 12;</code>
     */
    public Builder setTextDetectionParams(com.google.cloud.vision.v1.TextDetectionParams value) {
      if (textDetectionParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        textDetectionParams_ = value;
      } else {
        textDetectionParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.TextDetectionParams text_detection_params = 12;</code>
     */
    public Builder setTextDetectionParams(
        com.google.cloud.vision.v1.TextDetectionParams.Builder builderForValue) {
      if (textDetectionParamsBuilder_ == null) {
        textDetectionParams_ = builderForValue.build();
      } else {
        textDetectionParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.TextDetectionParams text_detection_params = 12;</code>
     */
    public Builder mergeTextDetectionParams(com.google.cloud.vision.v1.TextDetectionParams value) {
      if (textDetectionParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && textDetectionParams_ != null
            && textDetectionParams_
                != com.google.cloud.vision.v1.TextDetectionParams.getDefaultInstance()) {
          getTextDetectionParamsBuilder().mergeFrom(value);
        } else {
          textDetectionParams_ = value;
        }
      } else {
        textDetectionParamsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.TextDetectionParams text_detection_params = 12;</code>
     */
    public Builder clearTextDetectionParams() {
      bitField0_ = (bitField0_ & ~0x00000020);
      textDetectionParams_ = null;
      if (textDetectionParamsBuilder_ != null) {
        textDetectionParamsBuilder_.dispose();
        textDetectionParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.TextDetectionParams text_detection_params = 12;</code>
     */
    public com.google.cloud.vision.v1.TextDetectionParams.Builder getTextDetectionParamsBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getTextDetectionParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.TextDetectionParams text_detection_params = 12;</code>
     */
    public com.google.cloud.vision.v1.TextDetectionParamsOrBuilder
        getTextDetectionParamsOrBuilder() {
      if (textDetectionParamsBuilder_ != null) {
        return textDetectionParamsBuilder_.getMessageOrBuilder();
      } else {
        return textDetectionParams_ == null
            ? com.google.cloud.vision.v1.TextDetectionParams.getDefaultInstance()
            : textDetectionParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for text detection and document text detection.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.TextDetectionParams text_detection_params = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1.TextDetectionParams,
            com.google.cloud.vision.v1.TextDetectionParams.Builder,
            com.google.cloud.vision.v1.TextDetectionParamsOrBuilder>
        getTextDetectionParamsFieldBuilder() {
      if (textDetectionParamsBuilder_ == null) {
        textDetectionParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1.TextDetectionParams,
                com.google.cloud.vision.v1.TextDetectionParams.Builder,
                com.google.cloud.vision.v1.TextDetectionParamsOrBuilder>(
                getTextDetectionParams(), getParentForChildren(), isClean());
        textDetectionParams_ = null;
      }
      return textDetectionParamsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1.ImageContext)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1.ImageContext)
  private static final com.google.cloud.vision.v1.ImageContext DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1.ImageContext();
  }

  public static com.google.cloud.vision.v1.ImageContext getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImageContext> PARSER =
      new com.google.protobuf.AbstractParser<ImageContext>() {
        @java.lang.Override
        public ImageContext parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImageContext> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImageContext> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1.ImageContext getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
