/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1/image_annotator.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.vision.v1;

/**
 *
 *
 * <pre>
 * A request to annotate one single file, e.g. a PDF, TIFF or GIF file.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1.AnnotateFileRequest}
 */
public final class AnnotateFileRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1.AnnotateFileRequest)
    AnnotateFileRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnnotateFileRequest.newBuilder() to construct.
  private AnnotateFileRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnnotateFileRequest() {
    features_ = java.util.Collections.emptyList();
    pages_ = emptyIntList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnnotateFileRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1.ImageAnnotatorProto
        .internal_static_google_cloud_vision_v1_AnnotateFileRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1.ImageAnnotatorProto
        .internal_static_google_cloud_vision_v1_AnnotateFileRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1.AnnotateFileRequest.class,
            com.google.cloud.vision.v1.AnnotateFileRequest.Builder.class);
  }

  private int bitField0_;
  public static final int INPUT_CONFIG_FIELD_NUMBER = 1;
  private com.google.cloud.vision.v1.InputConfig inputConfig_;
  /**
   *
   *
   * <pre>
   * Required. Information about the input file.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.InputConfig input_config = 1;</code>
   *
   * @return Whether the inputConfig field is set.
   */
  @java.lang.Override
  public boolean hasInputConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Information about the input file.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.InputConfig input_config = 1;</code>
   *
   * @return The inputConfig.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1.InputConfig getInputConfig() {
    return inputConfig_ == null
        ? com.google.cloud.vision.v1.InputConfig.getDefaultInstance()
        : inputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Information about the input file.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.InputConfig input_config = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1.InputConfigOrBuilder getInputConfigOrBuilder() {
    return inputConfig_ == null
        ? com.google.cloud.vision.v1.InputConfig.getDefaultInstance()
        : inputConfig_;
  }

  public static final int FEATURES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vision.v1.Feature> features_;
  /**
   *
   *
   * <pre>
   * Required. Requested features.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vision.v1.Feature> getFeaturesList() {
    return features_;
  }
  /**
   *
   *
   * <pre>
   * Required. Requested features.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vision.v1.FeatureOrBuilder>
      getFeaturesOrBuilderList() {
    return features_;
  }
  /**
   *
   *
   * <pre>
   * Required. Requested features.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
   */
  @java.lang.Override
  public int getFeaturesCount() {
    return features_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Requested features.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1.Feature getFeatures(int index) {
    return features_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Requested features.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1.FeatureOrBuilder getFeaturesOrBuilder(int index) {
    return features_.get(index);
  }

  public static final int IMAGE_CONTEXT_FIELD_NUMBER = 3;
  private com.google.cloud.vision.v1.ImageContext imageContext_;
  /**
   *
   *
   * <pre>
   * Additional context that may accompany the image(s) in the file.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.ImageContext image_context = 3;</code>
   *
   * @return Whether the imageContext field is set.
   */
  @java.lang.Override
  public boolean hasImageContext() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Additional context that may accompany the image(s) in the file.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.ImageContext image_context = 3;</code>
   *
   * @return The imageContext.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1.ImageContext getImageContext() {
    return imageContext_ == null
        ? com.google.cloud.vision.v1.ImageContext.getDefaultInstance()
        : imageContext_;
  }
  /**
   *
   *
   * <pre>
   * Additional context that may accompany the image(s) in the file.
   * </pre>
   *
   * <code>.google.cloud.vision.v1.ImageContext image_context = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1.ImageContextOrBuilder getImageContextOrBuilder() {
    return imageContext_ == null
        ? com.google.cloud.vision.v1.ImageContext.getDefaultInstance()
        : imageContext_;
  }

  public static final int PAGES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList pages_ = emptyIntList();
  /**
   *
   *
   * <pre>
   * Pages of the file to perform image annotation.
   *
   * Pages starts from 1, we assume the first page of the file is page 1.
   * At most 5 pages are supported per request. Pages can be negative.
   *
   * Page 1 means the first page.
   * Page 2 means the second page.
   * Page -1 means the last page.
   * Page -2 means the second to the last page.
   *
   * If the file is GIF instead of PDF or TIFF, page refers to GIF frames.
   *
   * If this field is empty, by default the service performs image annotation
   * for the first 5 pages of the file.
   * </pre>
   *
   * <code>repeated int32 pages = 4;</code>
   *
   * @return A list containing the pages.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getPagesList() {
    return pages_;
  }
  /**
   *
   *
   * <pre>
   * Pages of the file to perform image annotation.
   *
   * Pages starts from 1, we assume the first page of the file is page 1.
   * At most 5 pages are supported per request. Pages can be negative.
   *
   * Page 1 means the first page.
   * Page 2 means the second page.
   * Page -1 means the last page.
   * Page -2 means the second to the last page.
   *
   * If the file is GIF instead of PDF or TIFF, page refers to GIF frames.
   *
   * If this field is empty, by default the service performs image annotation
   * for the first 5 pages of the file.
   * </pre>
   *
   * <code>repeated int32 pages = 4;</code>
   *
   * @return The count of pages.
   */
  public int getPagesCount() {
    return pages_.size();
  }
  /**
   *
   *
   * <pre>
   * Pages of the file to perform image annotation.
   *
   * Pages starts from 1, we assume the first page of the file is page 1.
   * At most 5 pages are supported per request. Pages can be negative.
   *
   * Page 1 means the first page.
   * Page 2 means the second page.
   * Page -1 means the last page.
   * Page -2 means the second to the last page.
   *
   * If the file is GIF instead of PDF or TIFF, page refers to GIF frames.
   *
   * If this field is empty, by default the service performs image annotation
   * for the first 5 pages of the file.
   * </pre>
   *
   * <code>repeated int32 pages = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The pages at the given index.
   */
  public int getPages(int index) {
    return pages_.getInt(index);
  }

  private int pagesMemoizedSerializedSize = -1;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getInputConfig());
    }
    for (int i = 0; i < features_.size(); i++) {
      output.writeMessage(2, features_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getImageContext());
    }
    if (getPagesList().size() > 0) {
      output.writeUInt32NoTag(34);
      output.writeUInt32NoTag(pagesMemoizedSerializedSize);
    }
    for (int i = 0; i < pages_.size(); i++) {
      output.writeInt32NoTag(pages_.getInt(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInputConfig());
    }
    for (int i = 0; i < features_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, features_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getImageContext());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < pages_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(pages_.getInt(i));
      }
      size += dataSize;
      if (!getPagesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      pagesMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1.AnnotateFileRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1.AnnotateFileRequest other =
        (com.google.cloud.vision.v1.AnnotateFileRequest) obj;

    if (hasInputConfig() != other.hasInputConfig()) return false;
    if (hasInputConfig()) {
      if (!getInputConfig().equals(other.getInputConfig())) return false;
    }
    if (!getFeaturesList().equals(other.getFeaturesList())) return false;
    if (hasImageContext() != other.hasImageContext()) return false;
    if (hasImageContext()) {
      if (!getImageContext().equals(other.getImageContext())) return false;
    }
    if (!getPagesList().equals(other.getPagesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasInputConfig()) {
      hash = (37 * hash) + INPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInputConfig().hashCode();
    }
    if (getFeaturesCount() > 0) {
      hash = (37 * hash) + FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getFeaturesList().hashCode();
    }
    if (hasImageContext()) {
      hash = (37 * hash) + IMAGE_CONTEXT_FIELD_NUMBER;
      hash = (53 * hash) + getImageContext().hashCode();
    }
    if (getPagesCount() > 0) {
      hash = (37 * hash) + PAGES_FIELD_NUMBER;
      hash = (53 * hash) + getPagesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1.AnnotateFileRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1.AnnotateFileRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1.AnnotateFileRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1.AnnotateFileRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1.AnnotateFileRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1.AnnotateFileRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1.AnnotateFileRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1.AnnotateFileRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1.AnnotateFileRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1.AnnotateFileRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1.AnnotateFileRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1.AnnotateFileRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vision.v1.AnnotateFileRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request to annotate one single file, e.g. a PDF, TIFF or GIF file.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1.AnnotateFileRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1.AnnotateFileRequest)
      com.google.cloud.vision.v1.AnnotateFileRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1_AnnotateFileRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1_AnnotateFileRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1.AnnotateFileRequest.class,
              com.google.cloud.vision.v1.AnnotateFileRequest.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1.AnnotateFileRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInputConfigFieldBuilder();
        getFeaturesFieldBuilder();
        getImageContextFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      inputConfig_ = null;
      if (inputConfigBuilder_ != null) {
        inputConfigBuilder_.dispose();
        inputConfigBuilder_ = null;
      }
      if (featuresBuilder_ == null) {
        features_ = java.util.Collections.emptyList();
      } else {
        features_ = null;
        featuresBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      imageContext_ = null;
      if (imageContextBuilder_ != null) {
        imageContextBuilder_.dispose();
        imageContextBuilder_ = null;
      }
      pages_ = emptyIntList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1_AnnotateFileRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1.AnnotateFileRequest getDefaultInstanceForType() {
      return com.google.cloud.vision.v1.AnnotateFileRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1.AnnotateFileRequest build() {
      com.google.cloud.vision.v1.AnnotateFileRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1.AnnotateFileRequest buildPartial() {
      com.google.cloud.vision.v1.AnnotateFileRequest result =
          new com.google.cloud.vision.v1.AnnotateFileRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.vision.v1.AnnotateFileRequest result) {
      if (featuresBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          features_ = java.util.Collections.unmodifiableList(features_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.features_ = features_;
      } else {
        result.features_ = featuresBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.vision.v1.AnnotateFileRequest result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.inputConfig_ =
            inputConfigBuilder_ == null ? inputConfig_ : inputConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.imageContext_ =
            imageContextBuilder_ == null ? imageContext_ : imageContextBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        pages_.makeImmutable();
        result.pages_ = pages_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1.AnnotateFileRequest) {
        return mergeFrom((com.google.cloud.vision.v1.AnnotateFileRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1.AnnotateFileRequest other) {
      if (other == com.google.cloud.vision.v1.AnnotateFileRequest.getDefaultInstance()) return this;
      if (other.hasInputConfig()) {
        mergeInputConfig(other.getInputConfig());
      }
      if (featuresBuilder_ == null) {
        if (!other.features_.isEmpty()) {
          if (features_.isEmpty()) {
            features_ = other.features_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureFeaturesIsMutable();
            features_.addAll(other.features_);
          }
          onChanged();
        }
      } else {
        if (!other.features_.isEmpty()) {
          if (featuresBuilder_.isEmpty()) {
            featuresBuilder_.dispose();
            featuresBuilder_ = null;
            features_ = other.features_;
            bitField0_ = (bitField0_ & ~0x00000002);
            featuresBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFeaturesFieldBuilder()
                    : null;
          } else {
            featuresBuilder_.addAllMessages(other.features_);
          }
        }
      }
      if (other.hasImageContext()) {
        mergeImageContext(other.getImageContext());
      }
      if (!other.pages_.isEmpty()) {
        if (pages_.isEmpty()) {
          pages_ = other.pages_;
          pages_.makeImmutable();
          bitField0_ |= 0x00000008;
        } else {
          ensurePagesIsMutable();
          pages_.addAll(other.pages_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getInputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.vision.v1.Feature m =
                    input.readMessage(
                        com.google.cloud.vision.v1.Feature.parser(), extensionRegistry);
                if (featuresBuilder_ == null) {
                  ensureFeaturesIsMutable();
                  features_.add(m);
                } else {
                  featuresBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getImageContextFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                int v = input.readInt32();
                ensurePagesIsMutable();
                pages_.addInt(v);
                break;
              } // case 32
            case 34:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensurePagesIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  pages_.addInt(input.readInt32());
                }
                input.popLimit(limit);
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.vision.v1.InputConfig inputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1.InputConfig,
            com.google.cloud.vision.v1.InputConfig.Builder,
            com.google.cloud.vision.v1.InputConfigOrBuilder>
        inputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.InputConfig input_config = 1;</code>
     *
     * @return Whether the inputConfig field is set.
     */
    public boolean hasInputConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.InputConfig input_config = 1;</code>
     *
     * @return The inputConfig.
     */
    public com.google.cloud.vision.v1.InputConfig getInputConfig() {
      if (inputConfigBuilder_ == null) {
        return inputConfig_ == null
            ? com.google.cloud.vision.v1.InputConfig.getDefaultInstance()
            : inputConfig_;
      } else {
        return inputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.InputConfig input_config = 1;</code>
     */
    public Builder setInputConfig(com.google.cloud.vision.v1.InputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputConfig_ = value;
      } else {
        inputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.InputConfig input_config = 1;</code>
     */
    public Builder setInputConfig(com.google.cloud.vision.v1.InputConfig.Builder builderForValue) {
      if (inputConfigBuilder_ == null) {
        inputConfig_ = builderForValue.build();
      } else {
        inputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.InputConfig input_config = 1;</code>
     */
    public Builder mergeInputConfig(com.google.cloud.vision.v1.InputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && inputConfig_ != null
            && inputConfig_ != com.google.cloud.vision.v1.InputConfig.getDefaultInstance()) {
          getInputConfigBuilder().mergeFrom(value);
        } else {
          inputConfig_ = value;
        }
      } else {
        inputConfigBuilder_.mergeFrom(value);
      }
      if (inputConfig_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.InputConfig input_config = 1;</code>
     */
    public Builder clearInputConfig() {
      bitField0_ = (bitField0_ & ~0x00000001);
      inputConfig_ = null;
      if (inputConfigBuilder_ != null) {
        inputConfigBuilder_.dispose();
        inputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.InputConfig input_config = 1;</code>
     */
    public com.google.cloud.vision.v1.InputConfig.Builder getInputConfigBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getInputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.InputConfig input_config = 1;</code>
     */
    public com.google.cloud.vision.v1.InputConfigOrBuilder getInputConfigOrBuilder() {
      if (inputConfigBuilder_ != null) {
        return inputConfigBuilder_.getMessageOrBuilder();
      } else {
        return inputConfig_ == null
            ? com.google.cloud.vision.v1.InputConfig.getDefaultInstance()
            : inputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Information about the input file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.InputConfig input_config = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1.InputConfig,
            com.google.cloud.vision.v1.InputConfig.Builder,
            com.google.cloud.vision.v1.InputConfigOrBuilder>
        getInputConfigFieldBuilder() {
      if (inputConfigBuilder_ == null) {
        inputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1.InputConfig,
                com.google.cloud.vision.v1.InputConfig.Builder,
                com.google.cloud.vision.v1.InputConfigOrBuilder>(
                getInputConfig(), getParentForChildren(), isClean());
        inputConfig_ = null;
      }
      return inputConfigBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1.Feature> features_ =
        java.util.Collections.emptyList();

    private void ensureFeaturesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        features_ = new java.util.ArrayList<com.google.cloud.vision.v1.Feature>(features_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1.Feature,
            com.google.cloud.vision.v1.Feature.Builder,
            com.google.cloud.vision.v1.FeatureOrBuilder>
        featuresBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public java.util.List<com.google.cloud.vision.v1.Feature> getFeaturesList() {
      if (featuresBuilder_ == null) {
        return java.util.Collections.unmodifiableList(features_);
      } else {
        return featuresBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public int getFeaturesCount() {
      if (featuresBuilder_ == null) {
        return features_.size();
      } else {
        return featuresBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public com.google.cloud.vision.v1.Feature getFeatures(int index) {
      if (featuresBuilder_ == null) {
        return features_.get(index);
      } else {
        return featuresBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public Builder setFeatures(int index, com.google.cloud.vision.v1.Feature value) {
      if (featuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeaturesIsMutable();
        features_.set(index, value);
        onChanged();
      } else {
        featuresBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public Builder setFeatures(
        int index, com.google.cloud.vision.v1.Feature.Builder builderForValue) {
      if (featuresBuilder_ == null) {
        ensureFeaturesIsMutable();
        features_.set(index, builderForValue.build());
        onChanged();
      } else {
        featuresBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public Builder addFeatures(com.google.cloud.vision.v1.Feature value) {
      if (featuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeaturesIsMutable();
        features_.add(value);
        onChanged();
      } else {
        featuresBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public Builder addFeatures(int index, com.google.cloud.vision.v1.Feature value) {
      if (featuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeaturesIsMutable();
        features_.add(index, value);
        onChanged();
      } else {
        featuresBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public Builder addFeatures(com.google.cloud.vision.v1.Feature.Builder builderForValue) {
      if (featuresBuilder_ == null) {
        ensureFeaturesIsMutable();
        features_.add(builderForValue.build());
        onChanged();
      } else {
        featuresBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public Builder addFeatures(
        int index, com.google.cloud.vision.v1.Feature.Builder builderForValue) {
      if (featuresBuilder_ == null) {
        ensureFeaturesIsMutable();
        features_.add(index, builderForValue.build());
        onChanged();
      } else {
        featuresBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public Builder addAllFeatures(
        java.lang.Iterable<? extends com.google.cloud.vision.v1.Feature> values) {
      if (featuresBuilder_ == null) {
        ensureFeaturesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, features_);
        onChanged();
      } else {
        featuresBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public Builder clearFeatures() {
      if (featuresBuilder_ == null) {
        features_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        featuresBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public Builder removeFeatures(int index) {
      if (featuresBuilder_ == null) {
        ensureFeaturesIsMutable();
        features_.remove(index);
        onChanged();
      } else {
        featuresBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public com.google.cloud.vision.v1.Feature.Builder getFeaturesBuilder(int index) {
      return getFeaturesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public com.google.cloud.vision.v1.FeatureOrBuilder getFeaturesOrBuilder(int index) {
      if (featuresBuilder_ == null) {
        return features_.get(index);
      } else {
        return featuresBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1.FeatureOrBuilder>
        getFeaturesOrBuilderList() {
      if (featuresBuilder_ != null) {
        return featuresBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(features_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public com.google.cloud.vision.v1.Feature.Builder addFeaturesBuilder() {
      return getFeaturesFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1.Feature.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public com.google.cloud.vision.v1.Feature.Builder addFeaturesBuilder(int index) {
      return getFeaturesFieldBuilder()
          .addBuilder(index, com.google.cloud.vision.v1.Feature.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.Feature features = 2;</code>
     */
    public java.util.List<com.google.cloud.vision.v1.Feature.Builder> getFeaturesBuilderList() {
      return getFeaturesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1.Feature,
            com.google.cloud.vision.v1.Feature.Builder,
            com.google.cloud.vision.v1.FeatureOrBuilder>
        getFeaturesFieldBuilder() {
      if (featuresBuilder_ == null) {
        featuresBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1.Feature,
                com.google.cloud.vision.v1.Feature.Builder,
                com.google.cloud.vision.v1.FeatureOrBuilder>(
                features_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        features_ = null;
      }
      return featuresBuilder_;
    }

    private com.google.cloud.vision.v1.ImageContext imageContext_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1.ImageContext,
            com.google.cloud.vision.v1.ImageContext.Builder,
            com.google.cloud.vision.v1.ImageContextOrBuilder>
        imageContextBuilder_;
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image(s) in the file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ImageContext image_context = 3;</code>
     *
     * @return Whether the imageContext field is set.
     */
    public boolean hasImageContext() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image(s) in the file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ImageContext image_context = 3;</code>
     *
     * @return The imageContext.
     */
    public com.google.cloud.vision.v1.ImageContext getImageContext() {
      if (imageContextBuilder_ == null) {
        return imageContext_ == null
            ? com.google.cloud.vision.v1.ImageContext.getDefaultInstance()
            : imageContext_;
      } else {
        return imageContextBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image(s) in the file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ImageContext image_context = 3;</code>
     */
    public Builder setImageContext(com.google.cloud.vision.v1.ImageContext value) {
      if (imageContextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        imageContext_ = value;
      } else {
        imageContextBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image(s) in the file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ImageContext image_context = 3;</code>
     */
    public Builder setImageContext(
        com.google.cloud.vision.v1.ImageContext.Builder builderForValue) {
      if (imageContextBuilder_ == null) {
        imageContext_ = builderForValue.build();
      } else {
        imageContextBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image(s) in the file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ImageContext image_context = 3;</code>
     */
    public Builder mergeImageContext(com.google.cloud.vision.v1.ImageContext value) {
      if (imageContextBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && imageContext_ != null
            && imageContext_ != com.google.cloud.vision.v1.ImageContext.getDefaultInstance()) {
          getImageContextBuilder().mergeFrom(value);
        } else {
          imageContext_ = value;
        }
      } else {
        imageContextBuilder_.mergeFrom(value);
      }
      if (imageContext_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image(s) in the file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ImageContext image_context = 3;</code>
     */
    public Builder clearImageContext() {
      bitField0_ = (bitField0_ & ~0x00000004);
      imageContext_ = null;
      if (imageContextBuilder_ != null) {
        imageContextBuilder_.dispose();
        imageContextBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image(s) in the file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ImageContext image_context = 3;</code>
     */
    public com.google.cloud.vision.v1.ImageContext.Builder getImageContextBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getImageContextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image(s) in the file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ImageContext image_context = 3;</code>
     */
    public com.google.cloud.vision.v1.ImageContextOrBuilder getImageContextOrBuilder() {
      if (imageContextBuilder_ != null) {
        return imageContextBuilder_.getMessageOrBuilder();
      } else {
        return imageContext_ == null
            ? com.google.cloud.vision.v1.ImageContext.getDefaultInstance()
            : imageContext_;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image(s) in the file.
     * </pre>
     *
     * <code>.google.cloud.vision.v1.ImageContext image_context = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1.ImageContext,
            com.google.cloud.vision.v1.ImageContext.Builder,
            com.google.cloud.vision.v1.ImageContextOrBuilder>
        getImageContextFieldBuilder() {
      if (imageContextBuilder_ == null) {
        imageContextBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1.ImageContext,
                com.google.cloud.vision.v1.ImageContext.Builder,
                com.google.cloud.vision.v1.ImageContextOrBuilder>(
                getImageContext(), getParentForChildren(), isClean());
        imageContext_ = null;
      }
      return imageContextBuilder_;
    }

    private com.google.protobuf.Internal.IntList pages_ = emptyIntList();

    private void ensurePagesIsMutable() {
      if (!pages_.isModifiable()) {
        pages_ = makeMutableCopy(pages_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Pages of the file to perform image annotation.
     *
     * Pages starts from 1, we assume the first page of the file is page 1.
     * At most 5 pages are supported per request. Pages can be negative.
     *
     * Page 1 means the first page.
     * Page 2 means the second page.
     * Page -1 means the last page.
     * Page -2 means the second to the last page.
     *
     * If the file is GIF instead of PDF or TIFF, page refers to GIF frames.
     *
     * If this field is empty, by default the service performs image annotation
     * for the first 5 pages of the file.
     * </pre>
     *
     * <code>repeated int32 pages = 4;</code>
     *
     * @return A list containing the pages.
     */
    public java.util.List<java.lang.Integer> getPagesList() {
      pages_.makeImmutable();
      return pages_;
    }
    /**
     *
     *
     * <pre>
     * Pages of the file to perform image annotation.
     *
     * Pages starts from 1, we assume the first page of the file is page 1.
     * At most 5 pages are supported per request. Pages can be negative.
     *
     * Page 1 means the first page.
     * Page 2 means the second page.
     * Page -1 means the last page.
     * Page -2 means the second to the last page.
     *
     * If the file is GIF instead of PDF or TIFF, page refers to GIF frames.
     *
     * If this field is empty, by default the service performs image annotation
     * for the first 5 pages of the file.
     * </pre>
     *
     * <code>repeated int32 pages = 4;</code>
     *
     * @return The count of pages.
     */
    public int getPagesCount() {
      return pages_.size();
    }
    /**
     *
     *
     * <pre>
     * Pages of the file to perform image annotation.
     *
     * Pages starts from 1, we assume the first page of the file is page 1.
     * At most 5 pages are supported per request. Pages can be negative.
     *
     * Page 1 means the first page.
     * Page 2 means the second page.
     * Page -1 means the last page.
     * Page -2 means the second to the last page.
     *
     * If the file is GIF instead of PDF or TIFF, page refers to GIF frames.
     *
     * If this field is empty, by default the service performs image annotation
     * for the first 5 pages of the file.
     * </pre>
     *
     * <code>repeated int32 pages = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The pages at the given index.
     */
    public int getPages(int index) {
      return pages_.getInt(index);
    }
    /**
     *
     *
     * <pre>
     * Pages of the file to perform image annotation.
     *
     * Pages starts from 1, we assume the first page of the file is page 1.
     * At most 5 pages are supported per request. Pages can be negative.
     *
     * Page 1 means the first page.
     * Page 2 means the second page.
     * Page -1 means the last page.
     * Page -2 means the second to the last page.
     *
     * If the file is GIF instead of PDF or TIFF, page refers to GIF frames.
     *
     * If this field is empty, by default the service performs image annotation
     * for the first 5 pages of the file.
     * </pre>
     *
     * <code>repeated int32 pages = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The pages to set.
     * @return This builder for chaining.
     */
    public Builder setPages(int index, int value) {

      ensurePagesIsMutable();
      pages_.setInt(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pages of the file to perform image annotation.
     *
     * Pages starts from 1, we assume the first page of the file is page 1.
     * At most 5 pages are supported per request. Pages can be negative.
     *
     * Page 1 means the first page.
     * Page 2 means the second page.
     * Page -1 means the last page.
     * Page -2 means the second to the last page.
     *
     * If the file is GIF instead of PDF or TIFF, page refers to GIF frames.
     *
     * If this field is empty, by default the service performs image annotation
     * for the first 5 pages of the file.
     * </pre>
     *
     * <code>repeated int32 pages = 4;</code>
     *
     * @param value The pages to add.
     * @return This builder for chaining.
     */
    public Builder addPages(int value) {

      ensurePagesIsMutable();
      pages_.addInt(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pages of the file to perform image annotation.
     *
     * Pages starts from 1, we assume the first page of the file is page 1.
     * At most 5 pages are supported per request. Pages can be negative.
     *
     * Page 1 means the first page.
     * Page 2 means the second page.
     * Page -1 means the last page.
     * Page -2 means the second to the last page.
     *
     * If the file is GIF instead of PDF or TIFF, page refers to GIF frames.
     *
     * If this field is empty, by default the service performs image annotation
     * for the first 5 pages of the file.
     * </pre>
     *
     * <code>repeated int32 pages = 4;</code>
     *
     * @param values The pages to add.
     * @return This builder for chaining.
     */
    public Builder addAllPages(java.lang.Iterable<? extends java.lang.Integer> values) {
      ensurePagesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pages_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pages of the file to perform image annotation.
     *
     * Pages starts from 1, we assume the first page of the file is page 1.
     * At most 5 pages are supported per request. Pages can be negative.
     *
     * Page 1 means the first page.
     * Page 2 means the second page.
     * Page -1 means the last page.
     * Page -2 means the second to the last page.
     *
     * If the file is GIF instead of PDF or TIFF, page refers to GIF frames.
     *
     * If this field is empty, by default the service performs image annotation
     * for the first 5 pages of the file.
     * </pre>
     *
     * <code>repeated int32 pages = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPages() {
      pages_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1.AnnotateFileRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1.AnnotateFileRequest)
  private static final com.google.cloud.vision.v1.AnnotateFileRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1.AnnotateFileRequest();
  }

  public static com.google.cloud.vision.v1.AnnotateFileRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnnotateFileRequest> PARSER =
      new com.google.protobuf.AbstractParser<AnnotateFileRequest>() {
        @java.lang.Override
        public AnnotateFileRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AnnotateFileRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnnotateFileRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1.AnnotateFileRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
