/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1p2beta1/text_annotation.proto

package com.google.cloud.vision.v1p2beta1;

/**
 *
 *
 * <pre>
 * TextAnnotation contains a structured representation of OCR extracted text.
 * The hierarchy of an OCR extracted text structure is like this:
 *     TextAnnotation -&gt; Page -&gt; Block -&gt; Paragraph -&gt; Word -&gt; Symbol
 * Each structural component, starting from Page, may further have their own
 * properties. Properties describe detected languages, breaks etc.. Please refer
 * to the
 * [TextAnnotation.TextProperty][google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty]
 * message definition below for more detail.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1p2beta1.TextAnnotation}
 */
public final class TextAnnotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p2beta1.TextAnnotation)
    TextAnnotationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TextAnnotation.newBuilder() to construct.
  private TextAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TextAnnotation() {
    pages_ = java.util.Collections.emptyList();
    text_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private TextAnnotation(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                pages_ = new java.util.ArrayList<com.google.cloud.vision.v1p2beta1.Page>();
                mutable_bitField0_ |= 0x00000001;
              }
              pages_.add(
                  input.readMessage(
                      com.google.cloud.vision.v1p2beta1.Page.parser(), extensionRegistry));
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              text_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        pages_ = java.util.Collections.unmodifiableList(pages_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
        .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
        .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1p2beta1.TextAnnotation.class,
            com.google.cloud.vision.v1p2beta1.TextAnnotation.Builder.class);
  }

  public interface DetectedLanguageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
     * </pre>
     *
     * <code>string language_code = 1;</code>
     */
    java.lang.String getLanguageCode();
    /**
     *
     *
     * <pre>
     * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
     * </pre>
     *
     * <code>string language_code = 1;</code>
     */
    com.google.protobuf.ByteString getLanguageCodeBytes();

    /**
     *
     *
     * <pre>
     * Confidence of detected language. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 2;</code>
     */
    float getConfidence();
  }
  /**
   *
   *
   * <pre>
   * Detected language for a structural component.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage}
   */
  public static final class DetectedLanguage extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage)
      DetectedLanguageOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DetectedLanguage.newBuilder() to construct.
    private DetectedLanguage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DetectedLanguage() {
      languageCode_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DetectedLanguage(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                languageCode_ = s;
                break;
              }
            case 21:
              {
                confidence_ = input.readFloat();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_DetectedLanguage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_DetectedLanguage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage.class,
              com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage.Builder.class);
    }

    public static final int LANGUAGE_CODE_FIELD_NUMBER = 1;
    private volatile java.lang.Object languageCode_;
    /**
     *
     *
     * <pre>
     * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
     * </pre>
     *
     * <code>string language_code = 1;</code>
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
     * </pre>
     *
     * <code>string language_code = 1;</code>
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONFIDENCE_FIELD_NUMBER = 2;
    private float confidence_;
    /**
     *
     *
     * <pre>
     * Confidence of detected language. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 2;</code>
     */
    public float getConfidence() {
      return confidence_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getLanguageCodeBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, languageCode_);
      }
      if (confidence_ != 0F) {
        output.writeFloat(2, confidence_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getLanguageCodeBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, languageCode_);
      }
      if (confidence_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, confidence_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage)) {
        return super.equals(obj);
      }
      com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage other =
          (com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage) obj;

      if (!getLanguageCode().equals(other.getLanguageCode())) return false;
      if (java.lang.Float.floatToIntBits(getConfidence())
          != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getLanguageCode().hashCode();
      hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Detected language for a structural component.
     * </pre>
     *
     * Protobuf type {@code google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage)
        com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
            .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_DetectedLanguage_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
            .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_DetectedLanguage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage.class,
                com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage.Builder.class);
      }

      // Construct using
      // com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        languageCode_ = "";

        confidence_ = 0F;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
            .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_DetectedLanguage_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage
          getDefaultInstanceForType() {
        return com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage build() {
        com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage buildPartial() {
        com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage result =
            new com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage(this);
        result.languageCode_ = languageCode_;
        result.confidence_ = confidence_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage) {
          return mergeFrom(
              (com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage other) {
        if (other
            == com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage
                .getDefaultInstance()) return this;
        if (!other.getLanguageCode().isEmpty()) {
          languageCode_ = other.languageCode_;
          onChanged();
        }
        if (other.getConfidence() != 0F) {
          setConfidence(other.getConfidence());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object languageCode_ = "";
      /**
       *
       *
       * <pre>
       * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
       * information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 1;</code>
       */
      public java.lang.String getLanguageCode() {
        java.lang.Object ref = languageCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          languageCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
       * information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 1;</code>
       */
      public com.google.protobuf.ByteString getLanguageCodeBytes() {
        java.lang.Object ref = languageCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          languageCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
       * information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 1;</code>
       */
      public Builder setLanguageCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        languageCode_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
       * information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 1;</code>
       */
      public Builder clearLanguageCode() {

        languageCode_ = getDefaultInstance().getLanguageCode();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
       * information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 1;</code>
       */
      public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        languageCode_ = value;
        onChanged();
        return this;
      }

      private float confidence_;
      /**
       *
       *
       * <pre>
       * Confidence of detected language. Range [0, 1].
       * </pre>
       *
       * <code>float confidence = 2;</code>
       */
      public float getConfidence() {
        return confidence_;
      }
      /**
       *
       *
       * <pre>
       * Confidence of detected language. Range [0, 1].
       * </pre>
       *
       * <code>float confidence = 2;</code>
       */
      public Builder setConfidence(float value) {

        confidence_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Confidence of detected language. Range [0, 1].
       * </pre>
       *
       * <code>float confidence = 2;</code>
       */
      public Builder clearConfidence() {

        confidence_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage)
    private static final com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage();
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DetectedLanguage> PARSER =
        new com.google.protobuf.AbstractParser<DetectedLanguage>() {
          @java.lang.Override
          public DetectedLanguage parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DetectedLanguage(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DetectedLanguage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DetectedLanguage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DetectedBreakOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Detected break type.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType type = 1;</code>
     */
    int getTypeValue();
    /**
     *
     *
     * <pre>
     * Detected break type.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType type = 1;</code>
     */
    com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType getType();

    /**
     *
     *
     * <pre>
     * True if break prepends the element.
     * </pre>
     *
     * <code>bool is_prefix = 2;</code>
     */
    boolean getIsPrefix();
  }
  /**
   *
   *
   * <pre>
   * Detected start or end of a structural component.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak}
   */
  public static final class DetectedBreak extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak)
      DetectedBreakOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DetectedBreak.newBuilder() to construct.
    private DetectedBreak(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DetectedBreak() {
      type_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DetectedBreak(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int rawValue = input.readEnum();

                type_ = rawValue;
                break;
              }
            case 16:
              {
                isPrefix_ = input.readBool();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_DetectedBreak_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_DetectedBreak_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.class,
              com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Enum to denote the type of break found. New line, space etc.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType}
     */
    public enum BreakType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unknown break label type.
       * </pre>
       *
       * <code>UNKNOWN = 0;</code>
       */
      UNKNOWN(0),
      /**
       *
       *
       * <pre>
       * Regular space.
       * </pre>
       *
       * <code>SPACE = 1;</code>
       */
      SPACE(1),
      /**
       *
       *
       * <pre>
       * Sure space (very wide).
       * </pre>
       *
       * <code>SURE_SPACE = 2;</code>
       */
      SURE_SPACE(2),
      /**
       *
       *
       * <pre>
       * Line-wrapping break.
       * </pre>
       *
       * <code>EOL_SURE_SPACE = 3;</code>
       */
      EOL_SURE_SPACE(3),
      /**
       *
       *
       * <pre>
       * End-line hyphen that is not present in text; does not co-occur with
       * `SPACE`, `LEADER_SPACE`, or `LINE_BREAK`.
       * </pre>
       *
       * <code>HYPHEN = 4;</code>
       */
      HYPHEN(4),
      /**
       *
       *
       * <pre>
       * Line break that ends a paragraph.
       * </pre>
       *
       * <code>LINE_BREAK = 5;</code>
       */
      LINE_BREAK(5),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unknown break label type.
       * </pre>
       *
       * <code>UNKNOWN = 0;</code>
       */
      public static final int UNKNOWN_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Regular space.
       * </pre>
       *
       * <code>SPACE = 1;</code>
       */
      public static final int SPACE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Sure space (very wide).
       * </pre>
       *
       * <code>SURE_SPACE = 2;</code>
       */
      public static final int SURE_SPACE_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Line-wrapping break.
       * </pre>
       *
       * <code>EOL_SURE_SPACE = 3;</code>
       */
      public static final int EOL_SURE_SPACE_VALUE = 3;
      /**
       *
       *
       * <pre>
       * End-line hyphen that is not present in text; does not co-occur with
       * `SPACE`, `LEADER_SPACE`, or `LINE_BREAK`.
       * </pre>
       *
       * <code>HYPHEN = 4;</code>
       */
      public static final int HYPHEN_VALUE = 4;
      /**
       *
       *
       * <pre>
       * Line break that ends a paragraph.
       * </pre>
       *
       * <code>LINE_BREAK = 5;</code>
       */
      public static final int LINE_BREAK_VALUE = 5;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /** @deprecated Use {@link #forNumber(int)} instead. */
      @java.lang.Deprecated
      public static BreakType valueOf(int value) {
        return forNumber(value);
      }

      public static BreakType forNumber(int value) {
        switch (value) {
          case 0:
            return UNKNOWN;
          case 1:
            return SPACE;
          case 2:
            return SURE_SPACE;
          case 3:
            return EOL_SURE_SPACE;
          case 4:
            return HYPHEN;
          case 5:
            return LINE_BREAK;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<BreakType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<BreakType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<BreakType>() {
            public BreakType findValueByNumber(int number) {
              return BreakType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final BreakType[] VALUES = values();

      public static BreakType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private BreakType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType)
    }

    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_;
    /**
     *
     *
     * <pre>
     * Detected break type.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType type = 1;</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Detected break type.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType type = 1;</code>
     */
    public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType getType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType result =
          com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType.valueOf(type_);
      return result == null
          ? com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType.UNRECOGNIZED
          : result;
    }

    public static final int IS_PREFIX_FIELD_NUMBER = 2;
    private boolean isPrefix_;
    /**
     *
     *
     * <pre>
     * True if break prepends the element.
     * </pre>
     *
     * <code>bool is_prefix = 2;</code>
     */
    public boolean getIsPrefix() {
      return isPrefix_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (type_
          != com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType.UNKNOWN
              .getNumber()) {
        output.writeEnum(1, type_);
      }
      if (isPrefix_ != false) {
        output.writeBool(2, isPrefix_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_
          != com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType.UNKNOWN
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
      }
      if (isPrefix_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, isPrefix_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak)) {
        return super.equals(obj);
      }
      com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak other =
          (com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak) obj;

      if (type_ != other.type_) return false;
      if (getIsPrefix() != other.getIsPrefix()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (37 * hash) + IS_PREFIX_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsPrefix());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Detected start or end of a structural component.
     * </pre>
     *
     * Protobuf type {@code google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak)
        com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreakOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
            .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_DetectedBreak_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
            .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_DetectedBreak_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.class,
                com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.Builder.class);
      }

      // Construct using com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        type_ = 0;

        isPrefix_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
            .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_DetectedBreak_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak
          getDefaultInstanceForType() {
        return com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak build() {
        com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak buildPartial() {
        com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak result =
            new com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak(this);
        result.type_ = type_;
        result.isPrefix_ = isPrefix_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak) {
          return mergeFrom((com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak other) {
        if (other
            == com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.getDefaultInstance())
          return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (other.getIsPrefix() != false) {
          setIsPrefix(other.getIsPrefix());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int type_ = 0;
      /**
       *
       *
       * <pre>
       * Detected break type.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType type = 1;
       * </code>
       */
      public int getTypeValue() {
        return type_;
      }
      /**
       *
       *
       * <pre>
       * Detected break type.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType type = 1;
       * </code>
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Detected break type.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType type = 1;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType getType() {
        @SuppressWarnings("deprecation")
        com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType result =
            com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType.valueOf(type_);
        return result == null
            ? com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Detected break type.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType type = 1;
       * </code>
       */
      public Builder setType(
          com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType value) {
        if (value == null) {
          throw new NullPointerException();
        }

        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Detected break type.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.BreakType type = 1;
       * </code>
       */
      public Builder clearType() {

        type_ = 0;
        onChanged();
        return this;
      }

      private boolean isPrefix_;
      /**
       *
       *
       * <pre>
       * True if break prepends the element.
       * </pre>
       *
       * <code>bool is_prefix = 2;</code>
       */
      public boolean getIsPrefix() {
        return isPrefix_;
      }
      /**
       *
       *
       * <pre>
       * True if break prepends the element.
       * </pre>
       *
       * <code>bool is_prefix = 2;</code>
       */
      public Builder setIsPrefix(boolean value) {

        isPrefix_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * True if break prepends the element.
       * </pre>
       *
       * <code>bool is_prefix = 2;</code>
       */
      public Builder clearIsPrefix() {

        isPrefix_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak)
    private static final com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak();
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DetectedBreak> PARSER =
        new com.google.protobuf.AbstractParser<DetectedBreak>() {
          @java.lang.Override
          public DetectedBreak parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DetectedBreak(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DetectedBreak> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DetectedBreak> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TextPropertyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
     * </code>
     */
    java.util.List<com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage>
        getDetectedLanguagesList();
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
     * </code>
     */
    com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage getDetectedLanguages(
        int index);
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
     * </code>
     */
    int getDetectedLanguagesCount();
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguageOrBuilder>
        getDetectedLanguagesOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
     * </code>
     */
    com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguageOrBuilder
        getDetectedLanguagesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Detected start or end of a text segment.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak detected_break = 2;</code>
     */
    boolean hasDetectedBreak();
    /**
     *
     *
     * <pre>
     * Detected start or end of a text segment.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak detected_break = 2;</code>
     */
    com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak getDetectedBreak();
    /**
     *
     *
     * <pre>
     * Detected start or end of a text segment.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak detected_break = 2;</code>
     */
    com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreakOrBuilder
        getDetectedBreakOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Additional information detected on the structural component.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty}
   */
  public static final class TextProperty extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty)
      TextPropertyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TextProperty.newBuilder() to construct.
    private TextProperty(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TextProperty() {
      detectedLanguages_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private TextProperty(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  detectedLanguages_ =
                      new java.util.ArrayList<
                          com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage>();
                  mutable_bitField0_ |= 0x00000001;
                }
                detectedLanguages_.add(
                    input.readMessage(
                        com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage.parser(),
                        extensionRegistry));
                break;
              }
            case 18:
              {
                com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.Builder subBuilder =
                    null;
                if (detectedBreak_ != null) {
                  subBuilder = detectedBreak_.toBuilder();
                }
                detectedBreak_ =
                    input.readMessage(
                        com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.parser(),
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(detectedBreak_);
                  detectedBreak_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_TextProperty_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_TextProperty_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty.class,
              com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty.Builder.class);
    }

    private int bitField0_;
    public static final int DETECTED_LANGUAGES_FIELD_NUMBER = 1;
    private java.util.List<com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage>
        detectedLanguages_;
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage>
        getDetectedLanguagesList() {
      return detectedLanguages_;
    }
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguageOrBuilder>
        getDetectedLanguagesOrBuilderList() {
      return detectedLanguages_;
    }
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
     * </code>
     */
    public int getDetectedLanguagesCount() {
      return detectedLanguages_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage getDetectedLanguages(
        int index) {
      return detectedLanguages_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguageOrBuilder
        getDetectedLanguagesOrBuilder(int index) {
      return detectedLanguages_.get(index);
    }

    public static final int DETECTED_BREAK_FIELD_NUMBER = 2;
    private com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak detectedBreak_;
    /**
     *
     *
     * <pre>
     * Detected start or end of a text segment.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak detected_break = 2;</code>
     */
    public boolean hasDetectedBreak() {
      return detectedBreak_ != null;
    }
    /**
     *
     *
     * <pre>
     * Detected start or end of a text segment.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak detected_break = 2;</code>
     */
    public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak getDetectedBreak() {
      return detectedBreak_ == null
          ? com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.getDefaultInstance()
          : detectedBreak_;
    }
    /**
     *
     *
     * <pre>
     * Detected start or end of a text segment.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak detected_break = 2;</code>
     */
    public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreakOrBuilder
        getDetectedBreakOrBuilder() {
      return getDetectedBreak();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < detectedLanguages_.size(); i++) {
        output.writeMessage(1, detectedLanguages_.get(i));
      }
      if (detectedBreak_ != null) {
        output.writeMessage(2, getDetectedBreak());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < detectedLanguages_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, detectedLanguages_.get(i));
      }
      if (detectedBreak_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDetectedBreak());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty)) {
        return super.equals(obj);
      }
      com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty other =
          (com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty) obj;

      if (!getDetectedLanguagesList().equals(other.getDetectedLanguagesList())) return false;
      if (hasDetectedBreak() != other.hasDetectedBreak()) return false;
      if (hasDetectedBreak()) {
        if (!getDetectedBreak().equals(other.getDetectedBreak())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDetectedLanguagesCount() > 0) {
        hash = (37 * hash) + DETECTED_LANGUAGES_FIELD_NUMBER;
        hash = (53 * hash) + getDetectedLanguagesList().hashCode();
      }
      if (hasDetectedBreak()) {
        hash = (37 * hash) + DETECTED_BREAK_FIELD_NUMBER;
        hash = (53 * hash) + getDetectedBreak().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Additional information detected on the structural component.
     * </pre>
     *
     * Protobuf type {@code google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty)
        com.google.cloud.vision.v1p2beta1.TextAnnotation.TextPropertyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
            .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_TextProperty_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
            .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_TextProperty_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty.class,
                com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty.Builder.class);
      }

      // Construct using com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDetectedLanguagesFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (detectedLanguagesBuilder_ == null) {
          detectedLanguages_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          detectedLanguagesBuilder_.clear();
        }
        if (detectedBreakBuilder_ == null) {
          detectedBreak_ = null;
        } else {
          detectedBreak_ = null;
          detectedBreakBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
            .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_TextProperty_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty
          getDefaultInstanceForType() {
        return com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty build() {
        com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty buildPartial() {
        com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty result =
            new com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (detectedLanguagesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.detectedLanguages_ = detectedLanguages_;
        } else {
          result.detectedLanguages_ = detectedLanguagesBuilder_.build();
        }
        if (detectedBreakBuilder_ == null) {
          result.detectedBreak_ = detectedBreak_;
        } else {
          result.detectedBreak_ = detectedBreakBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty) {
          return mergeFrom((com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty other) {
        if (other
            == com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty.getDefaultInstance())
          return this;
        if (detectedLanguagesBuilder_ == null) {
          if (!other.detectedLanguages_.isEmpty()) {
            if (detectedLanguages_.isEmpty()) {
              detectedLanguages_ = other.detectedLanguages_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureDetectedLanguagesIsMutable();
              detectedLanguages_.addAll(other.detectedLanguages_);
            }
            onChanged();
          }
        } else {
          if (!other.detectedLanguages_.isEmpty()) {
            if (detectedLanguagesBuilder_.isEmpty()) {
              detectedLanguagesBuilder_.dispose();
              detectedLanguagesBuilder_ = null;
              detectedLanguages_ = other.detectedLanguages_;
              bitField0_ = (bitField0_ & ~0x00000001);
              detectedLanguagesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDetectedLanguagesFieldBuilder()
                      : null;
            } else {
              detectedLanguagesBuilder_.addAllMessages(other.detectedLanguages_);
            }
          }
        }
        if (other.hasDetectedBreak()) {
          mergeDetectedBreak(other.getDetectedBreak());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage>
          detectedLanguages_ = java.util.Collections.emptyList();

      private void ensureDetectedLanguagesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          detectedLanguages_ =
              new java.util.ArrayList<
                  com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage>(
                  detectedLanguages_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage,
              com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage.Builder,
              com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguageOrBuilder>
          detectedLanguagesBuilder_;

      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage>
          getDetectedLanguagesList() {
        if (detectedLanguagesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(detectedLanguages_);
        } else {
          return detectedLanguagesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public int getDetectedLanguagesCount() {
        if (detectedLanguagesBuilder_ == null) {
          return detectedLanguages_.size();
        } else {
          return detectedLanguagesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage getDetectedLanguages(
          int index) {
        if (detectedLanguagesBuilder_ == null) {
          return detectedLanguages_.get(index);
        } else {
          return detectedLanguagesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public Builder setDetectedLanguages(
          int index, com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage value) {
        if (detectedLanguagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDetectedLanguagesIsMutable();
          detectedLanguages_.set(index, value);
          onChanged();
        } else {
          detectedLanguagesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public Builder setDetectedLanguages(
          int index,
          com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage.Builder
              builderForValue) {
        if (detectedLanguagesBuilder_ == null) {
          ensureDetectedLanguagesIsMutable();
          detectedLanguages_.set(index, builderForValue.build());
          onChanged();
        } else {
          detectedLanguagesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public Builder addDetectedLanguages(
          com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage value) {
        if (detectedLanguagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDetectedLanguagesIsMutable();
          detectedLanguages_.add(value);
          onChanged();
        } else {
          detectedLanguagesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public Builder addDetectedLanguages(
          int index, com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage value) {
        if (detectedLanguagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDetectedLanguagesIsMutable();
          detectedLanguages_.add(index, value);
          onChanged();
        } else {
          detectedLanguagesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public Builder addDetectedLanguages(
          com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage.Builder
              builderForValue) {
        if (detectedLanguagesBuilder_ == null) {
          ensureDetectedLanguagesIsMutable();
          detectedLanguages_.add(builderForValue.build());
          onChanged();
        } else {
          detectedLanguagesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public Builder addDetectedLanguages(
          int index,
          com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage.Builder
              builderForValue) {
        if (detectedLanguagesBuilder_ == null) {
          ensureDetectedLanguagesIsMutable();
          detectedLanguages_.add(index, builderForValue.build());
          onChanged();
        } else {
          detectedLanguagesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public Builder addAllDetectedLanguages(
          java.lang.Iterable<
                  ? extends com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage>
              values) {
        if (detectedLanguagesBuilder_ == null) {
          ensureDetectedLanguagesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detectedLanguages_);
          onChanged();
        } else {
          detectedLanguagesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public Builder clearDetectedLanguages() {
        if (detectedLanguagesBuilder_ == null) {
          detectedLanguages_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          detectedLanguagesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public Builder removeDetectedLanguages(int index) {
        if (detectedLanguagesBuilder_ == null) {
          ensureDetectedLanguagesIsMutable();
          detectedLanguages_.remove(index);
          onChanged();
        } else {
          detectedLanguagesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage.Builder
          getDetectedLanguagesBuilder(int index) {
        return getDetectedLanguagesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index) {
        if (detectedLanguagesBuilder_ == null) {
          return detectedLanguages_.get(index);
        } else {
          return detectedLanguagesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList() {
        if (detectedLanguagesBuilder_ != null) {
          return detectedLanguagesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(detectedLanguages_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage.Builder
          addDetectedLanguagesBuilder() {
        return getDetectedLanguagesFieldBuilder()
            .addBuilder(
                com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage.Builder
          addDetectedLanguagesBuilder(int index) {
        return getDetectedLanguagesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage detected_languages = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage.Builder>
          getDetectedLanguagesBuilderList() {
        return getDetectedLanguagesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage,
              com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage.Builder,
              com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguageOrBuilder>
          getDetectedLanguagesFieldBuilder() {
        if (detectedLanguagesBuilder_ == null) {
          detectedLanguagesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage,
                  com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguage.Builder,
                  com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedLanguageOrBuilder>(
                  detectedLanguages_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          detectedLanguages_ = null;
        }
        return detectedLanguagesBuilder_;
      }

      private com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak detectedBreak_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak,
              com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.Builder,
              com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreakOrBuilder>
          detectedBreakBuilder_;
      /**
       *
       *
       * <pre>
       * Detected start or end of a text segment.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak detected_break = 2;
       * </code>
       */
      public boolean hasDetectedBreak() {
        return detectedBreakBuilder_ != null || detectedBreak_ != null;
      }
      /**
       *
       *
       * <pre>
       * Detected start or end of a text segment.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak detected_break = 2;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak getDetectedBreak() {
        if (detectedBreakBuilder_ == null) {
          return detectedBreak_ == null
              ? com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.getDefaultInstance()
              : detectedBreak_;
        } else {
          return detectedBreakBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Detected start or end of a text segment.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak detected_break = 2;
       * </code>
       */
      public Builder setDetectedBreak(
          com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak value) {
        if (detectedBreakBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          detectedBreak_ = value;
          onChanged();
        } else {
          detectedBreakBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Detected start or end of a text segment.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak detected_break = 2;
       * </code>
       */
      public Builder setDetectedBreak(
          com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.Builder builderForValue) {
        if (detectedBreakBuilder_ == null) {
          detectedBreak_ = builderForValue.build();
          onChanged();
        } else {
          detectedBreakBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Detected start or end of a text segment.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak detected_break = 2;
       * </code>
       */
      public Builder mergeDetectedBreak(
          com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak value) {
        if (detectedBreakBuilder_ == null) {
          if (detectedBreak_ != null) {
            detectedBreak_ =
                com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.newBuilder(
                        detectedBreak_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            detectedBreak_ = value;
          }
          onChanged();
        } else {
          detectedBreakBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Detected start or end of a text segment.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak detected_break = 2;
       * </code>
       */
      public Builder clearDetectedBreak() {
        if (detectedBreakBuilder_ == null) {
          detectedBreak_ = null;
          onChanged();
        } else {
          detectedBreak_ = null;
          detectedBreakBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Detected start or end of a text segment.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak detected_break = 2;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.Builder
          getDetectedBreakBuilder() {

        onChanged();
        return getDetectedBreakFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Detected start or end of a text segment.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak detected_break = 2;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreakOrBuilder
          getDetectedBreakOrBuilder() {
        if (detectedBreakBuilder_ != null) {
          return detectedBreakBuilder_.getMessageOrBuilder();
        } else {
          return detectedBreak_ == null
              ? com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.getDefaultInstance()
              : detectedBreak_;
        }
      }
      /**
       *
       *
       * <pre>
       * Detected start or end of a text segment.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak detected_break = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak,
              com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.Builder,
              com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreakOrBuilder>
          getDetectedBreakFieldBuilder() {
        if (detectedBreakBuilder_ == null) {
          detectedBreakBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak,
                  com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreak.Builder,
                  com.google.cloud.vision.v1p2beta1.TextAnnotation.DetectedBreakOrBuilder>(
                  getDetectedBreak(), getParentForChildren(), isClean());
          detectedBreak_ = null;
        }
        return detectedBreakBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty)
    private static final com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty();
    }

    public static com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TextProperty> PARSER =
        new com.google.protobuf.AbstractParser<TextProperty>() {
          @java.lang.Override
          public TextProperty parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new TextProperty(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<TextProperty> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TextProperty> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int PAGES_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.vision.v1p2beta1.Page> pages_;
  /**
   *
   *
   * <pre>
   * List of pages detected by OCR.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
   */
  public java.util.List<com.google.cloud.vision.v1p2beta1.Page> getPagesList() {
    return pages_;
  }
  /**
   *
   *
   * <pre>
   * List of pages detected by OCR.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
   */
  public java.util.List<? extends com.google.cloud.vision.v1p2beta1.PageOrBuilder>
      getPagesOrBuilderList() {
    return pages_;
  }
  /**
   *
   *
   * <pre>
   * List of pages detected by OCR.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
   */
  public int getPagesCount() {
    return pages_.size();
  }
  /**
   *
   *
   * <pre>
   * List of pages detected by OCR.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
   */
  public com.google.cloud.vision.v1p2beta1.Page getPages(int index) {
    return pages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of pages detected by OCR.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
   */
  public com.google.cloud.vision.v1p2beta1.PageOrBuilder getPagesOrBuilder(int index) {
    return pages_.get(index);
  }

  public static final int TEXT_FIELD_NUMBER = 2;
  private volatile java.lang.Object text_;
  /**
   *
   *
   * <pre>
   * UTF-8 text detected on the pages.
   * </pre>
   *
   * <code>string text = 2;</code>
   */
  public java.lang.String getText() {
    java.lang.Object ref = text_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      text_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * UTF-8 text detected on the pages.
   * </pre>
   *
   * <code>string text = 2;</code>
   */
  public com.google.protobuf.ByteString getTextBytes() {
    java.lang.Object ref = text_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      text_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < pages_.size(); i++) {
      output.writeMessage(1, pages_.get(i));
    }
    if (!getTextBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, text_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < pages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, pages_.get(i));
    }
    if (!getTextBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, text_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1p2beta1.TextAnnotation)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1p2beta1.TextAnnotation other =
        (com.google.cloud.vision.v1p2beta1.TextAnnotation) obj;

    if (!getPagesList().equals(other.getPagesList())) return false;
    if (!getText().equals(other.getText())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getPagesCount() > 0) {
      hash = (37 * hash) + PAGES_FIELD_NUMBER;
      hash = (53 * hash) + getPagesList().hashCode();
    }
    hash = (37 * hash) + TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getText().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1p2beta1.TextAnnotation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p2beta1.TextAnnotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.TextAnnotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p2beta1.TextAnnotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.TextAnnotation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p2beta1.TextAnnotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.TextAnnotation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p2beta1.TextAnnotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.TextAnnotation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p2beta1.TextAnnotation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.TextAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p2beta1.TextAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vision.v1p2beta1.TextAnnotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * TextAnnotation contains a structured representation of OCR extracted text.
   * The hierarchy of an OCR extracted text structure is like this:
   *     TextAnnotation -&gt; Page -&gt; Block -&gt; Paragraph -&gt; Word -&gt; Symbol
   * Each structural component, starting from Page, may further have their own
   * properties. Properties describe detected languages, breaks etc.. Please refer
   * to the
   * [TextAnnotation.TextProperty][google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty]
   * message definition below for more detail.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p2beta1.TextAnnotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p2beta1.TextAnnotation)
      com.google.cloud.vision.v1p2beta1.TextAnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p2beta1.TextAnnotation.class,
              com.google.cloud.vision.v1p2beta1.TextAnnotation.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1p2beta1.TextAnnotation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPagesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (pagesBuilder_ == null) {
        pages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        pagesBuilder_.clear();
      }
      text_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p2beta1_TextAnnotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.TextAnnotation getDefaultInstanceForType() {
      return com.google.cloud.vision.v1p2beta1.TextAnnotation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.TextAnnotation build() {
      com.google.cloud.vision.v1p2beta1.TextAnnotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.TextAnnotation buildPartial() {
      com.google.cloud.vision.v1p2beta1.TextAnnotation result =
          new com.google.cloud.vision.v1p2beta1.TextAnnotation(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (pagesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          pages_ = java.util.Collections.unmodifiableList(pages_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.pages_ = pages_;
      } else {
        result.pages_ = pagesBuilder_.build();
      }
      result.text_ = text_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1p2beta1.TextAnnotation) {
        return mergeFrom((com.google.cloud.vision.v1p2beta1.TextAnnotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1p2beta1.TextAnnotation other) {
      if (other == com.google.cloud.vision.v1p2beta1.TextAnnotation.getDefaultInstance())
        return this;
      if (pagesBuilder_ == null) {
        if (!other.pages_.isEmpty()) {
          if (pages_.isEmpty()) {
            pages_ = other.pages_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePagesIsMutable();
            pages_.addAll(other.pages_);
          }
          onChanged();
        }
      } else {
        if (!other.pages_.isEmpty()) {
          if (pagesBuilder_.isEmpty()) {
            pagesBuilder_.dispose();
            pagesBuilder_ = null;
            pages_ = other.pages_;
            bitField0_ = (bitField0_ & ~0x00000001);
            pagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPagesFieldBuilder()
                    : null;
          } else {
            pagesBuilder_.addAllMessages(other.pages_);
          }
        }
      }
      if (!other.getText().isEmpty()) {
        text_ = other.text_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.vision.v1p2beta1.TextAnnotation parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.vision.v1p2beta1.TextAnnotation) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.vision.v1p2beta1.Page> pages_ =
        java.util.Collections.emptyList();

    private void ensurePagesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        pages_ = new java.util.ArrayList<com.google.cloud.vision.v1p2beta1.Page>(pages_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.Page,
            com.google.cloud.vision.v1p2beta1.Page.Builder,
            com.google.cloud.vision.v1p2beta1.PageOrBuilder>
        pagesBuilder_;

    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.Page> getPagesList() {
      if (pagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pages_);
      } else {
        return pagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public int getPagesCount() {
      if (pagesBuilder_ == null) {
        return pages_.size();
      } else {
        return pagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public com.google.cloud.vision.v1p2beta1.Page getPages(int index) {
      if (pagesBuilder_ == null) {
        return pages_.get(index);
      } else {
        return pagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public Builder setPages(int index, com.google.cloud.vision.v1p2beta1.Page value) {
      if (pagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePagesIsMutable();
        pages_.set(index, value);
        onChanged();
      } else {
        pagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public Builder setPages(
        int index, com.google.cloud.vision.v1p2beta1.Page.Builder builderForValue) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        pages_.set(index, builderForValue.build());
        onChanged();
      } else {
        pagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public Builder addPages(com.google.cloud.vision.v1p2beta1.Page value) {
      if (pagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePagesIsMutable();
        pages_.add(value);
        onChanged();
      } else {
        pagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public Builder addPages(int index, com.google.cloud.vision.v1p2beta1.Page value) {
      if (pagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePagesIsMutable();
        pages_.add(index, value);
        onChanged();
      } else {
        pagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public Builder addPages(com.google.cloud.vision.v1p2beta1.Page.Builder builderForValue) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        pages_.add(builderForValue.build());
        onChanged();
      } else {
        pagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public Builder addPages(
        int index, com.google.cloud.vision.v1p2beta1.Page.Builder builderForValue) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        pages_.add(index, builderForValue.build());
        onChanged();
      } else {
        pagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public Builder addAllPages(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p2beta1.Page> values) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pages_);
        onChanged();
      } else {
        pagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public Builder clearPages() {
      if (pagesBuilder_ == null) {
        pages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        pagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public Builder removePages(int index) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        pages_.remove(index);
        onChanged();
      } else {
        pagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public com.google.cloud.vision.v1p2beta1.Page.Builder getPagesBuilder(int index) {
      return getPagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public com.google.cloud.vision.v1p2beta1.PageOrBuilder getPagesOrBuilder(int index) {
      if (pagesBuilder_ == null) {
        return pages_.get(index);
      } else {
        return pagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1p2beta1.PageOrBuilder>
        getPagesOrBuilderList() {
      if (pagesBuilder_ != null) {
        return pagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pages_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public com.google.cloud.vision.v1p2beta1.Page.Builder addPagesBuilder() {
      return getPagesFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p2beta1.Page.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public com.google.cloud.vision.v1p2beta1.Page.Builder addPagesBuilder(int index) {
      return getPagesFieldBuilder()
          .addBuilder(index, com.google.cloud.vision.v1p2beta1.Page.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of pages detected by OCR.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Page pages = 1;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.Page.Builder> getPagesBuilderList() {
      return getPagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.Page,
            com.google.cloud.vision.v1p2beta1.Page.Builder,
            com.google.cloud.vision.v1p2beta1.PageOrBuilder>
        getPagesFieldBuilder() {
      if (pagesBuilder_ == null) {
        pagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p2beta1.Page,
                com.google.cloud.vision.v1p2beta1.Page.Builder,
                com.google.cloud.vision.v1p2beta1.PageOrBuilder>(
                pages_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        pages_ = null;
      }
      return pagesBuilder_;
    }

    private java.lang.Object text_ = "";
    /**
     *
     *
     * <pre>
     * UTF-8 text detected on the pages.
     * </pre>
     *
     * <code>string text = 2;</code>
     */
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * UTF-8 text detected on the pages.
     * </pre>
     *
     * <code>string text = 2;</code>
     */
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * UTF-8 text detected on the pages.
     * </pre>
     *
     * <code>string text = 2;</code>
     */
    public Builder setText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      text_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * UTF-8 text detected on the pages.
     * </pre>
     *
     * <code>string text = 2;</code>
     */
    public Builder clearText() {

      text_ = getDefaultInstance().getText();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * UTF-8 text detected on the pages.
     * </pre>
     *
     * <code>string text = 2;</code>
     */
    public Builder setTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      text_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p2beta1.TextAnnotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p2beta1.TextAnnotation)
  private static final com.google.cloud.vision.v1p2beta1.TextAnnotation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1p2beta1.TextAnnotation();
  }

  public static com.google.cloud.vision.v1p2beta1.TextAnnotation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TextAnnotation> PARSER =
      new com.google.protobuf.AbstractParser<TextAnnotation>() {
        @java.lang.Override
        public TextAnnotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new TextAnnotation(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<TextAnnotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TextAnnotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.TextAnnotation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
