/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1p2beta1/image_annotator.proto

package com.google.cloud.vision.v1p2beta1;

/**
 *
 *
 * <pre>
 * Request for performing Google Cloud Vision API tasks over a user-provided
 * image, with user-requested features.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1p2beta1.AnnotateImageRequest}
 */
public final class AnnotateImageRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p2beta1.AnnotateImageRequest)
    AnnotateImageRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnnotateImageRequest.newBuilder() to construct.
  private AnnotateImageRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnnotateImageRequest() {
    features_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnnotateImageRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private AnnotateImageRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.vision.v1p2beta1.Image.Builder subBuilder = null;
              if (image_ != null) {
                subBuilder = image_.toBuilder();
              }
              image_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p2beta1.Image.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(image_);
                image_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                features_ = new java.util.ArrayList<com.google.cloud.vision.v1p2beta1.Feature>();
                mutable_bitField0_ |= 0x00000001;
              }
              features_.add(
                  input.readMessage(
                      com.google.cloud.vision.v1p2beta1.Feature.parser(), extensionRegistry));
              break;
            }
          case 26:
            {
              com.google.cloud.vision.v1p2beta1.ImageContext.Builder subBuilder = null;
              if (imageContext_ != null) {
                subBuilder = imageContext_.toBuilder();
              }
              imageContext_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p2beta1.ImageContext.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(imageContext_);
                imageContext_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        features_ = java.util.Collections.unmodifiableList(features_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1p2beta1.ImageAnnotatorProto
        .internal_static_google_cloud_vision_v1p2beta1_AnnotateImageRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1p2beta1.ImageAnnotatorProto
        .internal_static_google_cloud_vision_v1p2beta1_AnnotateImageRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1p2beta1.AnnotateImageRequest.class,
            com.google.cloud.vision.v1p2beta1.AnnotateImageRequest.Builder.class);
  }

  public static final int IMAGE_FIELD_NUMBER = 1;
  private com.google.cloud.vision.v1p2beta1.Image image_;
  /**
   *
   *
   * <pre>
   * The image to be processed.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.Image image = 1;</code>
   *
   * @return Whether the image field is set.
   */
  @java.lang.Override
  public boolean hasImage() {
    return image_ != null;
  }
  /**
   *
   *
   * <pre>
   * The image to be processed.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.Image image = 1;</code>
   *
   * @return The image.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.Image getImage() {
    return image_ == null ? com.google.cloud.vision.v1p2beta1.Image.getDefaultInstance() : image_;
  }
  /**
   *
   *
   * <pre>
   * The image to be processed.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.Image image = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.ImageOrBuilder getImageOrBuilder() {
    return getImage();
  }

  public static final int FEATURES_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.vision.v1p2beta1.Feature> features_;
  /**
   *
   *
   * <pre>
   * Requested features.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vision.v1p2beta1.Feature> getFeaturesList() {
    return features_;
  }
  /**
   *
   *
   * <pre>
   * Requested features.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vision.v1p2beta1.FeatureOrBuilder>
      getFeaturesOrBuilderList() {
    return features_;
  }
  /**
   *
   *
   * <pre>
   * Requested features.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
   */
  @java.lang.Override
  public int getFeaturesCount() {
    return features_.size();
  }
  /**
   *
   *
   * <pre>
   * Requested features.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.Feature getFeatures(int index) {
    return features_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Requested features.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.FeatureOrBuilder getFeaturesOrBuilder(int index) {
    return features_.get(index);
  }

  public static final int IMAGE_CONTEXT_FIELD_NUMBER = 3;
  private com.google.cloud.vision.v1p2beta1.ImageContext imageContext_;
  /**
   *
   *
   * <pre>
   * Additional context that may accompany the image.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.ImageContext image_context = 3;</code>
   *
   * @return Whether the imageContext field is set.
   */
  @java.lang.Override
  public boolean hasImageContext() {
    return imageContext_ != null;
  }
  /**
   *
   *
   * <pre>
   * Additional context that may accompany the image.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.ImageContext image_context = 3;</code>
   *
   * @return The imageContext.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.ImageContext getImageContext() {
    return imageContext_ == null
        ? com.google.cloud.vision.v1p2beta1.ImageContext.getDefaultInstance()
        : imageContext_;
  }
  /**
   *
   *
   * <pre>
   * Additional context that may accompany the image.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.ImageContext image_context = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.ImageContextOrBuilder getImageContextOrBuilder() {
    return getImageContext();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (image_ != null) {
      output.writeMessage(1, getImage());
    }
    for (int i = 0; i < features_.size(); i++) {
      output.writeMessage(2, features_.get(i));
    }
    if (imageContext_ != null) {
      output.writeMessage(3, getImageContext());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (image_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getImage());
    }
    for (int i = 0; i < features_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, features_.get(i));
    }
    if (imageContext_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getImageContext());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1p2beta1.AnnotateImageRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1p2beta1.AnnotateImageRequest other =
        (com.google.cloud.vision.v1p2beta1.AnnotateImageRequest) obj;

    if (hasImage() != other.hasImage()) return false;
    if (hasImage()) {
      if (!getImage().equals(other.getImage())) return false;
    }
    if (!getFeaturesList().equals(other.getFeaturesList())) return false;
    if (hasImageContext() != other.hasImageContext()) return false;
    if (hasImageContext()) {
      if (!getImageContext().equals(other.getImageContext())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasImage()) {
      hash = (37 * hash) + IMAGE_FIELD_NUMBER;
      hash = (53 * hash) + getImage().hashCode();
    }
    if (getFeaturesCount() > 0) {
      hash = (37 * hash) + FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getFeaturesList().hashCode();
    }
    if (hasImageContext()) {
      hash = (37 * hash) + IMAGE_CONTEXT_FIELD_NUMBER;
      hash = (53 * hash) + getImageContext().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1p2beta1.AnnotateImageRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p2beta1.AnnotateImageRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.AnnotateImageRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p2beta1.AnnotateImageRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.AnnotateImageRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p2beta1.AnnotateImageRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.AnnotateImageRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p2beta1.AnnotateImageRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.AnnotateImageRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p2beta1.AnnotateImageRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.AnnotateImageRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p2beta1.AnnotateImageRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.vision.v1p2beta1.AnnotateImageRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request for performing Google Cloud Vision API tasks over a user-provided
   * image, with user-requested features.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p2beta1.AnnotateImageRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p2beta1.AnnotateImageRequest)
      com.google.cloud.vision.v1p2beta1.AnnotateImageRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p2beta1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1p2beta1_AnnotateImageRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p2beta1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1p2beta1_AnnotateImageRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p2beta1.AnnotateImageRequest.class,
              com.google.cloud.vision.v1p2beta1.AnnotateImageRequest.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1p2beta1.AnnotateImageRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFeaturesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (imageBuilder_ == null) {
        image_ = null;
      } else {
        image_ = null;
        imageBuilder_ = null;
      }
      if (featuresBuilder_ == null) {
        features_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        featuresBuilder_.clear();
      }
      if (imageContextBuilder_ == null) {
        imageContext_ = null;
      } else {
        imageContext_ = null;
        imageContextBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1p2beta1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1p2beta1_AnnotateImageRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.AnnotateImageRequest getDefaultInstanceForType() {
      return com.google.cloud.vision.v1p2beta1.AnnotateImageRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.AnnotateImageRequest build() {
      com.google.cloud.vision.v1p2beta1.AnnotateImageRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.AnnotateImageRequest buildPartial() {
      com.google.cloud.vision.v1p2beta1.AnnotateImageRequest result =
          new com.google.cloud.vision.v1p2beta1.AnnotateImageRequest(this);
      int from_bitField0_ = bitField0_;
      if (imageBuilder_ == null) {
        result.image_ = image_;
      } else {
        result.image_ = imageBuilder_.build();
      }
      if (featuresBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          features_ = java.util.Collections.unmodifiableList(features_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.features_ = features_;
      } else {
        result.features_ = featuresBuilder_.build();
      }
      if (imageContextBuilder_ == null) {
        result.imageContext_ = imageContext_;
      } else {
        result.imageContext_ = imageContextBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1p2beta1.AnnotateImageRequest) {
        return mergeFrom((com.google.cloud.vision.v1p2beta1.AnnotateImageRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1p2beta1.AnnotateImageRequest other) {
      if (other == com.google.cloud.vision.v1p2beta1.AnnotateImageRequest.getDefaultInstance())
        return this;
      if (other.hasImage()) {
        mergeImage(other.getImage());
      }
      if (featuresBuilder_ == null) {
        if (!other.features_.isEmpty()) {
          if (features_.isEmpty()) {
            features_ = other.features_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFeaturesIsMutable();
            features_.addAll(other.features_);
          }
          onChanged();
        }
      } else {
        if (!other.features_.isEmpty()) {
          if (featuresBuilder_.isEmpty()) {
            featuresBuilder_.dispose();
            featuresBuilder_ = null;
            features_ = other.features_;
            bitField0_ = (bitField0_ & ~0x00000001);
            featuresBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFeaturesFieldBuilder()
                    : null;
          } else {
            featuresBuilder_.addAllMessages(other.features_);
          }
        }
      }
      if (other.hasImageContext()) {
        mergeImageContext(other.getImageContext());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.vision.v1p2beta1.AnnotateImageRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.vision.v1p2beta1.AnnotateImageRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.cloud.vision.v1p2beta1.Image image_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.Image,
            com.google.cloud.vision.v1p2beta1.Image.Builder,
            com.google.cloud.vision.v1p2beta1.ImageOrBuilder>
        imageBuilder_;
    /**
     *
     *
     * <pre>
     * The image to be processed.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Image image = 1;</code>
     *
     * @return Whether the image field is set.
     */
    public boolean hasImage() {
      return imageBuilder_ != null || image_ != null;
    }
    /**
     *
     *
     * <pre>
     * The image to be processed.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Image image = 1;</code>
     *
     * @return The image.
     */
    public com.google.cloud.vision.v1p2beta1.Image getImage() {
      if (imageBuilder_ == null) {
        return image_ == null
            ? com.google.cloud.vision.v1p2beta1.Image.getDefaultInstance()
            : image_;
      } else {
        return imageBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The image to be processed.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Image image = 1;</code>
     */
    public Builder setImage(com.google.cloud.vision.v1p2beta1.Image value) {
      if (imageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        image_ = value;
        onChanged();
      } else {
        imageBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The image to be processed.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Image image = 1;</code>
     */
    public Builder setImage(com.google.cloud.vision.v1p2beta1.Image.Builder builderForValue) {
      if (imageBuilder_ == null) {
        image_ = builderForValue.build();
        onChanged();
      } else {
        imageBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The image to be processed.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Image image = 1;</code>
     */
    public Builder mergeImage(com.google.cloud.vision.v1p2beta1.Image value) {
      if (imageBuilder_ == null) {
        if (image_ != null) {
          image_ =
              com.google.cloud.vision.v1p2beta1.Image.newBuilder(image_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          image_ = value;
        }
        onChanged();
      } else {
        imageBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The image to be processed.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Image image = 1;</code>
     */
    public Builder clearImage() {
      if (imageBuilder_ == null) {
        image_ = null;
        onChanged();
      } else {
        image_ = null;
        imageBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The image to be processed.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Image image = 1;</code>
     */
    public com.google.cloud.vision.v1p2beta1.Image.Builder getImageBuilder() {

      onChanged();
      return getImageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The image to be processed.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Image image = 1;</code>
     */
    public com.google.cloud.vision.v1p2beta1.ImageOrBuilder getImageOrBuilder() {
      if (imageBuilder_ != null) {
        return imageBuilder_.getMessageOrBuilder();
      } else {
        return image_ == null
            ? com.google.cloud.vision.v1p2beta1.Image.getDefaultInstance()
            : image_;
      }
    }
    /**
     *
     *
     * <pre>
     * The image to be processed.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Image image = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.Image,
            com.google.cloud.vision.v1p2beta1.Image.Builder,
            com.google.cloud.vision.v1p2beta1.ImageOrBuilder>
        getImageFieldBuilder() {
      if (imageBuilder_ == null) {
        imageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p2beta1.Image,
                com.google.cloud.vision.v1p2beta1.Image.Builder,
                com.google.cloud.vision.v1p2beta1.ImageOrBuilder>(
                getImage(), getParentForChildren(), isClean());
        image_ = null;
      }
      return imageBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p2beta1.Feature> features_ =
        java.util.Collections.emptyList();

    private void ensureFeaturesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        features_ = new java.util.ArrayList<com.google.cloud.vision.v1p2beta1.Feature>(features_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.Feature,
            com.google.cloud.vision.v1p2beta1.Feature.Builder,
            com.google.cloud.vision.v1p2beta1.FeatureOrBuilder>
        featuresBuilder_;

    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.Feature> getFeaturesList() {
      if (featuresBuilder_ == null) {
        return java.util.Collections.unmodifiableList(features_);
      } else {
        return featuresBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public int getFeaturesCount() {
      if (featuresBuilder_ == null) {
        return features_.size();
      } else {
        return featuresBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public com.google.cloud.vision.v1p2beta1.Feature getFeatures(int index) {
      if (featuresBuilder_ == null) {
        return features_.get(index);
      } else {
        return featuresBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public Builder setFeatures(int index, com.google.cloud.vision.v1p2beta1.Feature value) {
      if (featuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeaturesIsMutable();
        features_.set(index, value);
        onChanged();
      } else {
        featuresBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public Builder setFeatures(
        int index, com.google.cloud.vision.v1p2beta1.Feature.Builder builderForValue) {
      if (featuresBuilder_ == null) {
        ensureFeaturesIsMutable();
        features_.set(index, builderForValue.build());
        onChanged();
      } else {
        featuresBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public Builder addFeatures(com.google.cloud.vision.v1p2beta1.Feature value) {
      if (featuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeaturesIsMutable();
        features_.add(value);
        onChanged();
      } else {
        featuresBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public Builder addFeatures(int index, com.google.cloud.vision.v1p2beta1.Feature value) {
      if (featuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeaturesIsMutable();
        features_.add(index, value);
        onChanged();
      } else {
        featuresBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public Builder addFeatures(com.google.cloud.vision.v1p2beta1.Feature.Builder builderForValue) {
      if (featuresBuilder_ == null) {
        ensureFeaturesIsMutable();
        features_.add(builderForValue.build());
        onChanged();
      } else {
        featuresBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public Builder addFeatures(
        int index, com.google.cloud.vision.v1p2beta1.Feature.Builder builderForValue) {
      if (featuresBuilder_ == null) {
        ensureFeaturesIsMutable();
        features_.add(index, builderForValue.build());
        onChanged();
      } else {
        featuresBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public Builder addAllFeatures(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p2beta1.Feature> values) {
      if (featuresBuilder_ == null) {
        ensureFeaturesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, features_);
        onChanged();
      } else {
        featuresBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public Builder clearFeatures() {
      if (featuresBuilder_ == null) {
        features_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        featuresBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public Builder removeFeatures(int index) {
      if (featuresBuilder_ == null) {
        ensureFeaturesIsMutable();
        features_.remove(index);
        onChanged();
      } else {
        featuresBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public com.google.cloud.vision.v1p2beta1.Feature.Builder getFeaturesBuilder(int index) {
      return getFeaturesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public com.google.cloud.vision.v1p2beta1.FeatureOrBuilder getFeaturesOrBuilder(int index) {
      if (featuresBuilder_ == null) {
        return features_.get(index);
      } else {
        return featuresBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1p2beta1.FeatureOrBuilder>
        getFeaturesOrBuilderList() {
      if (featuresBuilder_ != null) {
        return featuresBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(features_);
      }
    }
    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public com.google.cloud.vision.v1p2beta1.Feature.Builder addFeaturesBuilder() {
      return getFeaturesFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p2beta1.Feature.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public com.google.cloud.vision.v1p2beta1.Feature.Builder addFeaturesBuilder(int index) {
      return getFeaturesFieldBuilder()
          .addBuilder(index, com.google.cloud.vision.v1p2beta1.Feature.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Requested features.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Feature features = 2;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.Feature.Builder>
        getFeaturesBuilderList() {
      return getFeaturesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.Feature,
            com.google.cloud.vision.v1p2beta1.Feature.Builder,
            com.google.cloud.vision.v1p2beta1.FeatureOrBuilder>
        getFeaturesFieldBuilder() {
      if (featuresBuilder_ == null) {
        featuresBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p2beta1.Feature,
                com.google.cloud.vision.v1p2beta1.Feature.Builder,
                com.google.cloud.vision.v1p2beta1.FeatureOrBuilder>(
                features_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        features_ = null;
      }
      return featuresBuilder_;
    }

    private com.google.cloud.vision.v1p2beta1.ImageContext imageContext_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.ImageContext,
            com.google.cloud.vision.v1p2beta1.ImageContext.Builder,
            com.google.cloud.vision.v1p2beta1.ImageContextOrBuilder>
        imageContextBuilder_;
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.ImageContext image_context = 3;</code>
     *
     * @return Whether the imageContext field is set.
     */
    public boolean hasImageContext() {
      return imageContextBuilder_ != null || imageContext_ != null;
    }
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.ImageContext image_context = 3;</code>
     *
     * @return The imageContext.
     */
    public com.google.cloud.vision.v1p2beta1.ImageContext getImageContext() {
      if (imageContextBuilder_ == null) {
        return imageContext_ == null
            ? com.google.cloud.vision.v1p2beta1.ImageContext.getDefaultInstance()
            : imageContext_;
      } else {
        return imageContextBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.ImageContext image_context = 3;</code>
     */
    public Builder setImageContext(com.google.cloud.vision.v1p2beta1.ImageContext value) {
      if (imageContextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        imageContext_ = value;
        onChanged();
      } else {
        imageContextBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.ImageContext image_context = 3;</code>
     */
    public Builder setImageContext(
        com.google.cloud.vision.v1p2beta1.ImageContext.Builder builderForValue) {
      if (imageContextBuilder_ == null) {
        imageContext_ = builderForValue.build();
        onChanged();
      } else {
        imageContextBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.ImageContext image_context = 3;</code>
     */
    public Builder mergeImageContext(com.google.cloud.vision.v1p2beta1.ImageContext value) {
      if (imageContextBuilder_ == null) {
        if (imageContext_ != null) {
          imageContext_ =
              com.google.cloud.vision.v1p2beta1.ImageContext.newBuilder(imageContext_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          imageContext_ = value;
        }
        onChanged();
      } else {
        imageContextBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.ImageContext image_context = 3;</code>
     */
    public Builder clearImageContext() {
      if (imageContextBuilder_ == null) {
        imageContext_ = null;
        onChanged();
      } else {
        imageContext_ = null;
        imageContextBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.ImageContext image_context = 3;</code>
     */
    public com.google.cloud.vision.v1p2beta1.ImageContext.Builder getImageContextBuilder() {

      onChanged();
      return getImageContextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.ImageContext image_context = 3;</code>
     */
    public com.google.cloud.vision.v1p2beta1.ImageContextOrBuilder getImageContextOrBuilder() {
      if (imageContextBuilder_ != null) {
        return imageContextBuilder_.getMessageOrBuilder();
      } else {
        return imageContext_ == null
            ? com.google.cloud.vision.v1p2beta1.ImageContext.getDefaultInstance()
            : imageContext_;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional context that may accompany the image.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.ImageContext image_context = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.ImageContext,
            com.google.cloud.vision.v1p2beta1.ImageContext.Builder,
            com.google.cloud.vision.v1p2beta1.ImageContextOrBuilder>
        getImageContextFieldBuilder() {
      if (imageContextBuilder_ == null) {
        imageContextBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p2beta1.ImageContext,
                com.google.cloud.vision.v1p2beta1.ImageContext.Builder,
                com.google.cloud.vision.v1p2beta1.ImageContextOrBuilder>(
                getImageContext(), getParentForChildren(), isClean());
        imageContext_ = null;
      }
      return imageContextBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p2beta1.AnnotateImageRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p2beta1.AnnotateImageRequest)
  private static final com.google.cloud.vision.v1p2beta1.AnnotateImageRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1p2beta1.AnnotateImageRequest();
  }

  public static com.google.cloud.vision.v1p2beta1.AnnotateImageRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnnotateImageRequest> PARSER =
      new com.google.protobuf.AbstractParser<AnnotateImageRequest>() {
        @java.lang.Override
        public AnnotateImageRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AnnotateImageRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<AnnotateImageRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnnotateImageRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.AnnotateImageRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
