/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1p2beta1/image_annotator.proto

package com.google.cloud.vision.v1p2beta1;

/**
 *
 *
 * <pre>
 * A face annotation object contains the results of face detection.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1p2beta1.FaceAnnotation}
 */
public final class FaceAnnotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p2beta1.FaceAnnotation)
    FaceAnnotationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FaceAnnotation.newBuilder() to construct.
  private FaceAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FaceAnnotation() {
    landmarks_ = java.util.Collections.emptyList();
    joyLikelihood_ = 0;
    sorrowLikelihood_ = 0;
    angerLikelihood_ = 0;
    surpriseLikelihood_ = 0;
    underExposedLikelihood_ = 0;
    blurredLikelihood_ = 0;
    headwearLikelihood_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FaceAnnotation();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private FaceAnnotation(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.vision.v1p2beta1.BoundingPoly.Builder subBuilder = null;
              if (boundingPoly_ != null) {
                subBuilder = boundingPoly_.toBuilder();
              }
              boundingPoly_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p2beta1.BoundingPoly.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(boundingPoly_);
                boundingPoly_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              com.google.cloud.vision.v1p2beta1.BoundingPoly.Builder subBuilder = null;
              if (fdBoundingPoly_ != null) {
                subBuilder = fdBoundingPoly_.toBuilder();
              }
              fdBoundingPoly_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p2beta1.BoundingPoly.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(fdBoundingPoly_);
                fdBoundingPoly_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                landmarks_ =
                    new java.util.ArrayList<
                        com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark>();
                mutable_bitField0_ |= 0x00000001;
              }
              landmarks_.add(
                  input.readMessage(
                      com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.parser(),
                      extensionRegistry));
              break;
            }
          case 37:
            {
              rollAngle_ = input.readFloat();
              break;
            }
          case 45:
            {
              panAngle_ = input.readFloat();
              break;
            }
          case 53:
            {
              tiltAngle_ = input.readFloat();
              break;
            }
          case 61:
            {
              detectionConfidence_ = input.readFloat();
              break;
            }
          case 69:
            {
              landmarkingConfidence_ = input.readFloat();
              break;
            }
          case 72:
            {
              int rawValue = input.readEnum();

              joyLikelihood_ = rawValue;
              break;
            }
          case 80:
            {
              int rawValue = input.readEnum();

              sorrowLikelihood_ = rawValue;
              break;
            }
          case 88:
            {
              int rawValue = input.readEnum();

              angerLikelihood_ = rawValue;
              break;
            }
          case 96:
            {
              int rawValue = input.readEnum();

              surpriseLikelihood_ = rawValue;
              break;
            }
          case 104:
            {
              int rawValue = input.readEnum();

              underExposedLikelihood_ = rawValue;
              break;
            }
          case 112:
            {
              int rawValue = input.readEnum();

              blurredLikelihood_ = rawValue;
              break;
            }
          case 120:
            {
              int rawValue = input.readEnum();

              headwearLikelihood_ = rawValue;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        landmarks_ = java.util.Collections.unmodifiableList(landmarks_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1p2beta1.ImageAnnotatorProto
        .internal_static_google_cloud_vision_v1p2beta1_FaceAnnotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1p2beta1.ImageAnnotatorProto
        .internal_static_google_cloud_vision_v1p2beta1_FaceAnnotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1p2beta1.FaceAnnotation.class,
            com.google.cloud.vision.v1p2beta1.FaceAnnotation.Builder.class);
  }

  public interface LandmarkOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Face landmark type.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type type = 3;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();
    /**
     *
     *
     * <pre>
     * Face landmark type.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type type = 3;</code>
     *
     * @return The type.
     */
    com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type getType();

    /**
     *
     *
     * <pre>
     * Face landmark position.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Position position = 4;</code>
     *
     * @return Whether the position field is set.
     */
    boolean hasPosition();
    /**
     *
     *
     * <pre>
     * Face landmark position.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Position position = 4;</code>
     *
     * @return The position.
     */
    com.google.cloud.vision.v1p2beta1.Position getPosition();
    /**
     *
     *
     * <pre>
     * Face landmark position.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Position position = 4;</code>
     */
    com.google.cloud.vision.v1p2beta1.PositionOrBuilder getPositionOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A face-specific landmark (for example, a face feature).
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark}
   */
  public static final class Landmark extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark)
      LandmarkOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Landmark.newBuilder() to construct.
    private Landmark(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Landmark() {
      type_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Landmark();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Landmark(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 24:
              {
                int rawValue = input.readEnum();

                type_ = rawValue;
                break;
              }
            case 34:
              {
                com.google.cloud.vision.v1p2beta1.Position.Builder subBuilder = null;
                if (position_ != null) {
                  subBuilder = position_.toBuilder();
                }
                position_ =
                    input.readMessage(
                        com.google.cloud.vision.v1p2beta1.Position.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(position_);
                  position_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p2beta1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1p2beta1_FaceAnnotation_Landmark_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p2beta1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1p2beta1_FaceAnnotation_Landmark_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.class,
              com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Face landmark (feature) type.
     * Left and right are defined from the vantage of the viewer of the image
     * without considering mirror projections typical of photos. So, `LEFT_EYE`,
     * typically, is the person's right eye.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type}
     */
    public enum Type implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unknown face landmark detected. Should not be filled.
       * </pre>
       *
       * <code>UNKNOWN_LANDMARK = 0;</code>
       */
      UNKNOWN_LANDMARK(0),
      /**
       *
       *
       * <pre>
       * Left eye.
       * </pre>
       *
       * <code>LEFT_EYE = 1;</code>
       */
      LEFT_EYE(1),
      /**
       *
       *
       * <pre>
       * Right eye.
       * </pre>
       *
       * <code>RIGHT_EYE = 2;</code>
       */
      RIGHT_EYE(2),
      /**
       *
       *
       * <pre>
       * Left of left eyebrow.
       * </pre>
       *
       * <code>LEFT_OF_LEFT_EYEBROW = 3;</code>
       */
      LEFT_OF_LEFT_EYEBROW(3),
      /**
       *
       *
       * <pre>
       * Right of left eyebrow.
       * </pre>
       *
       * <code>RIGHT_OF_LEFT_EYEBROW = 4;</code>
       */
      RIGHT_OF_LEFT_EYEBROW(4),
      /**
       *
       *
       * <pre>
       * Left of right eyebrow.
       * </pre>
       *
       * <code>LEFT_OF_RIGHT_EYEBROW = 5;</code>
       */
      LEFT_OF_RIGHT_EYEBROW(5),
      /**
       *
       *
       * <pre>
       * Right of right eyebrow.
       * </pre>
       *
       * <code>RIGHT_OF_RIGHT_EYEBROW = 6;</code>
       */
      RIGHT_OF_RIGHT_EYEBROW(6),
      /**
       *
       *
       * <pre>
       * Midpoint between eyes.
       * </pre>
       *
       * <code>MIDPOINT_BETWEEN_EYES = 7;</code>
       */
      MIDPOINT_BETWEEN_EYES(7),
      /**
       *
       *
       * <pre>
       * Nose tip.
       * </pre>
       *
       * <code>NOSE_TIP = 8;</code>
       */
      NOSE_TIP(8),
      /**
       *
       *
       * <pre>
       * Upper lip.
       * </pre>
       *
       * <code>UPPER_LIP = 9;</code>
       */
      UPPER_LIP(9),
      /**
       *
       *
       * <pre>
       * Lower lip.
       * </pre>
       *
       * <code>LOWER_LIP = 10;</code>
       */
      LOWER_LIP(10),
      /**
       *
       *
       * <pre>
       * Mouth left.
       * </pre>
       *
       * <code>MOUTH_LEFT = 11;</code>
       */
      MOUTH_LEFT(11),
      /**
       *
       *
       * <pre>
       * Mouth right.
       * </pre>
       *
       * <code>MOUTH_RIGHT = 12;</code>
       */
      MOUTH_RIGHT(12),
      /**
       *
       *
       * <pre>
       * Mouth center.
       * </pre>
       *
       * <code>MOUTH_CENTER = 13;</code>
       */
      MOUTH_CENTER(13),
      /**
       *
       *
       * <pre>
       * Nose, bottom right.
       * </pre>
       *
       * <code>NOSE_BOTTOM_RIGHT = 14;</code>
       */
      NOSE_BOTTOM_RIGHT(14),
      /**
       *
       *
       * <pre>
       * Nose, bottom left.
       * </pre>
       *
       * <code>NOSE_BOTTOM_LEFT = 15;</code>
       */
      NOSE_BOTTOM_LEFT(15),
      /**
       *
       *
       * <pre>
       * Nose, bottom center.
       * </pre>
       *
       * <code>NOSE_BOTTOM_CENTER = 16;</code>
       */
      NOSE_BOTTOM_CENTER(16),
      /**
       *
       *
       * <pre>
       * Left eye, top boundary.
       * </pre>
       *
       * <code>LEFT_EYE_TOP_BOUNDARY = 17;</code>
       */
      LEFT_EYE_TOP_BOUNDARY(17),
      /**
       *
       *
       * <pre>
       * Left eye, right corner.
       * </pre>
       *
       * <code>LEFT_EYE_RIGHT_CORNER = 18;</code>
       */
      LEFT_EYE_RIGHT_CORNER(18),
      /**
       *
       *
       * <pre>
       * Left eye, bottom boundary.
       * </pre>
       *
       * <code>LEFT_EYE_BOTTOM_BOUNDARY = 19;</code>
       */
      LEFT_EYE_BOTTOM_BOUNDARY(19),
      /**
       *
       *
       * <pre>
       * Left eye, left corner.
       * </pre>
       *
       * <code>LEFT_EYE_LEFT_CORNER = 20;</code>
       */
      LEFT_EYE_LEFT_CORNER(20),
      /**
       *
       *
       * <pre>
       * Right eye, top boundary.
       * </pre>
       *
       * <code>RIGHT_EYE_TOP_BOUNDARY = 21;</code>
       */
      RIGHT_EYE_TOP_BOUNDARY(21),
      /**
       *
       *
       * <pre>
       * Right eye, right corner.
       * </pre>
       *
       * <code>RIGHT_EYE_RIGHT_CORNER = 22;</code>
       */
      RIGHT_EYE_RIGHT_CORNER(22),
      /**
       *
       *
       * <pre>
       * Right eye, bottom boundary.
       * </pre>
       *
       * <code>RIGHT_EYE_BOTTOM_BOUNDARY = 23;</code>
       */
      RIGHT_EYE_BOTTOM_BOUNDARY(23),
      /**
       *
       *
       * <pre>
       * Right eye, left corner.
       * </pre>
       *
       * <code>RIGHT_EYE_LEFT_CORNER = 24;</code>
       */
      RIGHT_EYE_LEFT_CORNER(24),
      /**
       *
       *
       * <pre>
       * Left eyebrow, upper midpoint.
       * </pre>
       *
       * <code>LEFT_EYEBROW_UPPER_MIDPOINT = 25;</code>
       */
      LEFT_EYEBROW_UPPER_MIDPOINT(25),
      /**
       *
       *
       * <pre>
       * Right eyebrow, upper midpoint.
       * </pre>
       *
       * <code>RIGHT_EYEBROW_UPPER_MIDPOINT = 26;</code>
       */
      RIGHT_EYEBROW_UPPER_MIDPOINT(26),
      /**
       *
       *
       * <pre>
       * Left ear tragion.
       * </pre>
       *
       * <code>LEFT_EAR_TRAGION = 27;</code>
       */
      LEFT_EAR_TRAGION(27),
      /**
       *
       *
       * <pre>
       * Right ear tragion.
       * </pre>
       *
       * <code>RIGHT_EAR_TRAGION = 28;</code>
       */
      RIGHT_EAR_TRAGION(28),
      /**
       *
       *
       * <pre>
       * Left eye pupil.
       * </pre>
       *
       * <code>LEFT_EYE_PUPIL = 29;</code>
       */
      LEFT_EYE_PUPIL(29),
      /**
       *
       *
       * <pre>
       * Right eye pupil.
       * </pre>
       *
       * <code>RIGHT_EYE_PUPIL = 30;</code>
       */
      RIGHT_EYE_PUPIL(30),
      /**
       *
       *
       * <pre>
       * Forehead glabella.
       * </pre>
       *
       * <code>FOREHEAD_GLABELLA = 31;</code>
       */
      FOREHEAD_GLABELLA(31),
      /**
       *
       *
       * <pre>
       * Chin gnathion.
       * </pre>
       *
       * <code>CHIN_GNATHION = 32;</code>
       */
      CHIN_GNATHION(32),
      /**
       *
       *
       * <pre>
       * Chin left gonion.
       * </pre>
       *
       * <code>CHIN_LEFT_GONION = 33;</code>
       */
      CHIN_LEFT_GONION(33),
      /**
       *
       *
       * <pre>
       * Chin right gonion.
       * </pre>
       *
       * <code>CHIN_RIGHT_GONION = 34;</code>
       */
      CHIN_RIGHT_GONION(34),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unknown face landmark detected. Should not be filled.
       * </pre>
       *
       * <code>UNKNOWN_LANDMARK = 0;</code>
       */
      public static final int UNKNOWN_LANDMARK_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Left eye.
       * </pre>
       *
       * <code>LEFT_EYE = 1;</code>
       */
      public static final int LEFT_EYE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Right eye.
       * </pre>
       *
       * <code>RIGHT_EYE = 2;</code>
       */
      public static final int RIGHT_EYE_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Left of left eyebrow.
       * </pre>
       *
       * <code>LEFT_OF_LEFT_EYEBROW = 3;</code>
       */
      public static final int LEFT_OF_LEFT_EYEBROW_VALUE = 3;
      /**
       *
       *
       * <pre>
       * Right of left eyebrow.
       * </pre>
       *
       * <code>RIGHT_OF_LEFT_EYEBROW = 4;</code>
       */
      public static final int RIGHT_OF_LEFT_EYEBROW_VALUE = 4;
      /**
       *
       *
       * <pre>
       * Left of right eyebrow.
       * </pre>
       *
       * <code>LEFT_OF_RIGHT_EYEBROW = 5;</code>
       */
      public static final int LEFT_OF_RIGHT_EYEBROW_VALUE = 5;
      /**
       *
       *
       * <pre>
       * Right of right eyebrow.
       * </pre>
       *
       * <code>RIGHT_OF_RIGHT_EYEBROW = 6;</code>
       */
      public static final int RIGHT_OF_RIGHT_EYEBROW_VALUE = 6;
      /**
       *
       *
       * <pre>
       * Midpoint between eyes.
       * </pre>
       *
       * <code>MIDPOINT_BETWEEN_EYES = 7;</code>
       */
      public static final int MIDPOINT_BETWEEN_EYES_VALUE = 7;
      /**
       *
       *
       * <pre>
       * Nose tip.
       * </pre>
       *
       * <code>NOSE_TIP = 8;</code>
       */
      public static final int NOSE_TIP_VALUE = 8;
      /**
       *
       *
       * <pre>
       * Upper lip.
       * </pre>
       *
       * <code>UPPER_LIP = 9;</code>
       */
      public static final int UPPER_LIP_VALUE = 9;
      /**
       *
       *
       * <pre>
       * Lower lip.
       * </pre>
       *
       * <code>LOWER_LIP = 10;</code>
       */
      public static final int LOWER_LIP_VALUE = 10;
      /**
       *
       *
       * <pre>
       * Mouth left.
       * </pre>
       *
       * <code>MOUTH_LEFT = 11;</code>
       */
      public static final int MOUTH_LEFT_VALUE = 11;
      /**
       *
       *
       * <pre>
       * Mouth right.
       * </pre>
       *
       * <code>MOUTH_RIGHT = 12;</code>
       */
      public static final int MOUTH_RIGHT_VALUE = 12;
      /**
       *
       *
       * <pre>
       * Mouth center.
       * </pre>
       *
       * <code>MOUTH_CENTER = 13;</code>
       */
      public static final int MOUTH_CENTER_VALUE = 13;
      /**
       *
       *
       * <pre>
       * Nose, bottom right.
       * </pre>
       *
       * <code>NOSE_BOTTOM_RIGHT = 14;</code>
       */
      public static final int NOSE_BOTTOM_RIGHT_VALUE = 14;
      /**
       *
       *
       * <pre>
       * Nose, bottom left.
       * </pre>
       *
       * <code>NOSE_BOTTOM_LEFT = 15;</code>
       */
      public static final int NOSE_BOTTOM_LEFT_VALUE = 15;
      /**
       *
       *
       * <pre>
       * Nose, bottom center.
       * </pre>
       *
       * <code>NOSE_BOTTOM_CENTER = 16;</code>
       */
      public static final int NOSE_BOTTOM_CENTER_VALUE = 16;
      /**
       *
       *
       * <pre>
       * Left eye, top boundary.
       * </pre>
       *
       * <code>LEFT_EYE_TOP_BOUNDARY = 17;</code>
       */
      public static final int LEFT_EYE_TOP_BOUNDARY_VALUE = 17;
      /**
       *
       *
       * <pre>
       * Left eye, right corner.
       * </pre>
       *
       * <code>LEFT_EYE_RIGHT_CORNER = 18;</code>
       */
      public static final int LEFT_EYE_RIGHT_CORNER_VALUE = 18;
      /**
       *
       *
       * <pre>
       * Left eye, bottom boundary.
       * </pre>
       *
       * <code>LEFT_EYE_BOTTOM_BOUNDARY = 19;</code>
       */
      public static final int LEFT_EYE_BOTTOM_BOUNDARY_VALUE = 19;
      /**
       *
       *
       * <pre>
       * Left eye, left corner.
       * </pre>
       *
       * <code>LEFT_EYE_LEFT_CORNER = 20;</code>
       */
      public static final int LEFT_EYE_LEFT_CORNER_VALUE = 20;
      /**
       *
       *
       * <pre>
       * Right eye, top boundary.
       * </pre>
       *
       * <code>RIGHT_EYE_TOP_BOUNDARY = 21;</code>
       */
      public static final int RIGHT_EYE_TOP_BOUNDARY_VALUE = 21;
      /**
       *
       *
       * <pre>
       * Right eye, right corner.
       * </pre>
       *
       * <code>RIGHT_EYE_RIGHT_CORNER = 22;</code>
       */
      public static final int RIGHT_EYE_RIGHT_CORNER_VALUE = 22;
      /**
       *
       *
       * <pre>
       * Right eye, bottom boundary.
       * </pre>
       *
       * <code>RIGHT_EYE_BOTTOM_BOUNDARY = 23;</code>
       */
      public static final int RIGHT_EYE_BOTTOM_BOUNDARY_VALUE = 23;
      /**
       *
       *
       * <pre>
       * Right eye, left corner.
       * </pre>
       *
       * <code>RIGHT_EYE_LEFT_CORNER = 24;</code>
       */
      public static final int RIGHT_EYE_LEFT_CORNER_VALUE = 24;
      /**
       *
       *
       * <pre>
       * Left eyebrow, upper midpoint.
       * </pre>
       *
       * <code>LEFT_EYEBROW_UPPER_MIDPOINT = 25;</code>
       */
      public static final int LEFT_EYEBROW_UPPER_MIDPOINT_VALUE = 25;
      /**
       *
       *
       * <pre>
       * Right eyebrow, upper midpoint.
       * </pre>
       *
       * <code>RIGHT_EYEBROW_UPPER_MIDPOINT = 26;</code>
       */
      public static final int RIGHT_EYEBROW_UPPER_MIDPOINT_VALUE = 26;
      /**
       *
       *
       * <pre>
       * Left ear tragion.
       * </pre>
       *
       * <code>LEFT_EAR_TRAGION = 27;</code>
       */
      public static final int LEFT_EAR_TRAGION_VALUE = 27;
      /**
       *
       *
       * <pre>
       * Right ear tragion.
       * </pre>
       *
       * <code>RIGHT_EAR_TRAGION = 28;</code>
       */
      public static final int RIGHT_EAR_TRAGION_VALUE = 28;
      /**
       *
       *
       * <pre>
       * Left eye pupil.
       * </pre>
       *
       * <code>LEFT_EYE_PUPIL = 29;</code>
       */
      public static final int LEFT_EYE_PUPIL_VALUE = 29;
      /**
       *
       *
       * <pre>
       * Right eye pupil.
       * </pre>
       *
       * <code>RIGHT_EYE_PUPIL = 30;</code>
       */
      public static final int RIGHT_EYE_PUPIL_VALUE = 30;
      /**
       *
       *
       * <pre>
       * Forehead glabella.
       * </pre>
       *
       * <code>FOREHEAD_GLABELLA = 31;</code>
       */
      public static final int FOREHEAD_GLABELLA_VALUE = 31;
      /**
       *
       *
       * <pre>
       * Chin gnathion.
       * </pre>
       *
       * <code>CHIN_GNATHION = 32;</code>
       */
      public static final int CHIN_GNATHION_VALUE = 32;
      /**
       *
       *
       * <pre>
       * Chin left gonion.
       * </pre>
       *
       * <code>CHIN_LEFT_GONION = 33;</code>
       */
      public static final int CHIN_LEFT_GONION_VALUE = 33;
      /**
       *
       *
       * <pre>
       * Chin right gonion.
       * </pre>
       *
       * <code>CHIN_RIGHT_GONION = 34;</code>
       */
      public static final int CHIN_RIGHT_GONION_VALUE = 34;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Type forNumber(int value) {
        switch (value) {
          case 0:
            return UNKNOWN_LANDMARK;
          case 1:
            return LEFT_EYE;
          case 2:
            return RIGHT_EYE;
          case 3:
            return LEFT_OF_LEFT_EYEBROW;
          case 4:
            return RIGHT_OF_LEFT_EYEBROW;
          case 5:
            return LEFT_OF_RIGHT_EYEBROW;
          case 6:
            return RIGHT_OF_RIGHT_EYEBROW;
          case 7:
            return MIDPOINT_BETWEEN_EYES;
          case 8:
            return NOSE_TIP;
          case 9:
            return UPPER_LIP;
          case 10:
            return LOWER_LIP;
          case 11:
            return MOUTH_LEFT;
          case 12:
            return MOUTH_RIGHT;
          case 13:
            return MOUTH_CENTER;
          case 14:
            return NOSE_BOTTOM_RIGHT;
          case 15:
            return NOSE_BOTTOM_LEFT;
          case 16:
            return NOSE_BOTTOM_CENTER;
          case 17:
            return LEFT_EYE_TOP_BOUNDARY;
          case 18:
            return LEFT_EYE_RIGHT_CORNER;
          case 19:
            return LEFT_EYE_BOTTOM_BOUNDARY;
          case 20:
            return LEFT_EYE_LEFT_CORNER;
          case 21:
            return RIGHT_EYE_TOP_BOUNDARY;
          case 22:
            return RIGHT_EYE_RIGHT_CORNER;
          case 23:
            return RIGHT_EYE_BOTTOM_BOUNDARY;
          case 24:
            return RIGHT_EYE_LEFT_CORNER;
          case 25:
            return LEFT_EYEBROW_UPPER_MIDPOINT;
          case 26:
            return RIGHT_EYEBROW_UPPER_MIDPOINT;
          case 27:
            return LEFT_EAR_TRAGION;
          case 28:
            return RIGHT_EAR_TRAGION;
          case 29:
            return LEFT_EYE_PUPIL;
          case 30:
            return RIGHT_EYE_PUPIL;
          case 31:
            return FOREHEAD_GLABELLA;
          case 32:
            return CHIN_GNATHION;
          case 33:
            return CHIN_LEFT_GONION;
          case 34:
            return CHIN_RIGHT_GONION;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Type>() {
            public Type findValueByNumber(int number) {
              return Type.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type)
    }

    public static final int TYPE_FIELD_NUMBER = 3;
    private int type_;
    /**
     *
     *
     * <pre>
     * Face landmark type.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type type = 3;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Face landmark type.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type type = 3;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type getType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type result =
          com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type.valueOf(type_);
      return result == null
          ? com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type.UNRECOGNIZED
          : result;
    }

    public static final int POSITION_FIELD_NUMBER = 4;
    private com.google.cloud.vision.v1p2beta1.Position position_;
    /**
     *
     *
     * <pre>
     * Face landmark position.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Position position = 4;</code>
     *
     * @return Whether the position field is set.
     */
    @java.lang.Override
    public boolean hasPosition() {
      return position_ != null;
    }
    /**
     *
     *
     * <pre>
     * Face landmark position.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Position position = 4;</code>
     *
     * @return The position.
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.Position getPosition() {
      return position_ == null
          ? com.google.cloud.vision.v1p2beta1.Position.getDefaultInstance()
          : position_;
    }
    /**
     *
     *
     * <pre>
     * Face landmark position.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Position position = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.PositionOrBuilder getPositionOrBuilder() {
      return getPosition();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (type_
          != com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type.UNKNOWN_LANDMARK
              .getNumber()) {
        output.writeEnum(3, type_);
      }
      if (position_ != null) {
        output.writeMessage(4, getPosition());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_
          != com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type.UNKNOWN_LANDMARK
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, type_);
      }
      if (position_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPosition());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark)) {
        return super.equals(obj);
      }
      com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark other =
          (com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark) obj;

      if (type_ != other.type_) return false;
      if (hasPosition() != other.hasPosition()) return false;
      if (hasPosition()) {
        if (!getPosition().equals(other.getPosition())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      if (hasPosition()) {
        hash = (37 * hash) + POSITION_FIELD_NUMBER;
        hash = (53 * hash) + getPosition().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A face-specific landmark (for example, a face feature).
     * </pre>
     *
     * Protobuf type {@code google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark)
        com.google.cloud.vision.v1p2beta1.FaceAnnotation.LandmarkOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.vision.v1p2beta1.ImageAnnotatorProto
            .internal_static_google_cloud_vision_v1p2beta1_FaceAnnotation_Landmark_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.vision.v1p2beta1.ImageAnnotatorProto
            .internal_static_google_cloud_vision_v1p2beta1_FaceAnnotation_Landmark_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.class,
                com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Builder.class);
      }

      // Construct using com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        type_ = 0;

        if (positionBuilder_ == null) {
          position_ = null;
        } else {
          position_ = null;
          positionBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.vision.v1p2beta1.ImageAnnotatorProto
            .internal_static_google_cloud_vision_v1p2beta1_FaceAnnotation_Landmark_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark getDefaultInstanceForType() {
        return com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark build() {
        com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark buildPartial() {
        com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark result =
            new com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark(this);
        result.type_ = type_;
        if (positionBuilder_ == null) {
          result.position_ = position_;
        } else {
          result.position_ = positionBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark) {
          return mergeFrom((com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark other) {
        if (other == com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.getDefaultInstance())
          return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (other.hasPosition()) {
          mergePosition(other.getPosition());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int type_ = 0;
      /**
       *
       *
       * <pre>
       * Face landmark type.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type type = 3;</code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }
      /**
       *
       *
       * <pre>
       * Face landmark type.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type type = 3;</code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {

        type_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Face landmark type.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type type = 3;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type getType() {
        @SuppressWarnings("deprecation")
        com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type result =
            com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type.valueOf(type_);
        return result == null
            ? com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Face landmark type.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type type = 3;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }

        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Face landmark type.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Type type = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {

        type_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.vision.v1p2beta1.Position position_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.vision.v1p2beta1.Position,
              com.google.cloud.vision.v1p2beta1.Position.Builder,
              com.google.cloud.vision.v1p2beta1.PositionOrBuilder>
          positionBuilder_;
      /**
       *
       *
       * <pre>
       * Face landmark position.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.Position position = 4;</code>
       *
       * @return Whether the position field is set.
       */
      public boolean hasPosition() {
        return positionBuilder_ != null || position_ != null;
      }
      /**
       *
       *
       * <pre>
       * Face landmark position.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.Position position = 4;</code>
       *
       * @return The position.
       */
      public com.google.cloud.vision.v1p2beta1.Position getPosition() {
        if (positionBuilder_ == null) {
          return position_ == null
              ? com.google.cloud.vision.v1p2beta1.Position.getDefaultInstance()
              : position_;
        } else {
          return positionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Face landmark position.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.Position position = 4;</code>
       */
      public Builder setPosition(com.google.cloud.vision.v1p2beta1.Position value) {
        if (positionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          position_ = value;
          onChanged();
        } else {
          positionBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Face landmark position.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.Position position = 4;</code>
       */
      public Builder setPosition(
          com.google.cloud.vision.v1p2beta1.Position.Builder builderForValue) {
        if (positionBuilder_ == null) {
          position_ = builderForValue.build();
          onChanged();
        } else {
          positionBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Face landmark position.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.Position position = 4;</code>
       */
      public Builder mergePosition(com.google.cloud.vision.v1p2beta1.Position value) {
        if (positionBuilder_ == null) {
          if (position_ != null) {
            position_ =
                com.google.cloud.vision.v1p2beta1.Position.newBuilder(position_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            position_ = value;
          }
          onChanged();
        } else {
          positionBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Face landmark position.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.Position position = 4;</code>
       */
      public Builder clearPosition() {
        if (positionBuilder_ == null) {
          position_ = null;
          onChanged();
        } else {
          position_ = null;
          positionBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Face landmark position.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.Position position = 4;</code>
       */
      public com.google.cloud.vision.v1p2beta1.Position.Builder getPositionBuilder() {

        onChanged();
        return getPositionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Face landmark position.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.Position position = 4;</code>
       */
      public com.google.cloud.vision.v1p2beta1.PositionOrBuilder getPositionOrBuilder() {
        if (positionBuilder_ != null) {
          return positionBuilder_.getMessageOrBuilder();
        } else {
          return position_ == null
              ? com.google.cloud.vision.v1p2beta1.Position.getDefaultInstance()
              : position_;
        }
      }
      /**
       *
       *
       * <pre>
       * Face landmark position.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p2beta1.Position position = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.vision.v1p2beta1.Position,
              com.google.cloud.vision.v1p2beta1.Position.Builder,
              com.google.cloud.vision.v1p2beta1.PositionOrBuilder>
          getPositionFieldBuilder() {
        if (positionBuilder_ == null) {
          positionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.vision.v1p2beta1.Position,
                  com.google.cloud.vision.v1p2beta1.Position.Builder,
                  com.google.cloud.vision.v1p2beta1.PositionOrBuilder>(
                  getPosition(), getParentForChildren(), isClean());
          position_ = null;
        }
        return positionBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark)
    private static final com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark();
    }

    public static com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Landmark> PARSER =
        new com.google.protobuf.AbstractParser<Landmark>() {
          @java.lang.Override
          public Landmark parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Landmark(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Landmark> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Landmark> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int BOUNDING_POLY_FIELD_NUMBER = 1;
  private com.google.cloud.vision.v1p2beta1.BoundingPoly boundingPoly_;
  /**
   *
   *
   * <pre>
   * The bounding polygon around the face. The coordinates of the bounding box
   * are in the original image's scale, as returned in `ImageParams`.
   * The bounding box is computed to "frame" the face in accordance with human
   * expectations. It is based on the landmarker results.
   * Note that one or more x and/or y coordinates may not be generated in the
   * `BoundingPoly` (the polygon will be unbounded) if only a partial face
   * appears in the image to be annotated.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.BoundingPoly bounding_poly = 1;</code>
   *
   * @return Whether the boundingPoly field is set.
   */
  @java.lang.Override
  public boolean hasBoundingPoly() {
    return boundingPoly_ != null;
  }
  /**
   *
   *
   * <pre>
   * The bounding polygon around the face. The coordinates of the bounding box
   * are in the original image's scale, as returned in `ImageParams`.
   * The bounding box is computed to "frame" the face in accordance with human
   * expectations. It is based on the landmarker results.
   * Note that one or more x and/or y coordinates may not be generated in the
   * `BoundingPoly` (the polygon will be unbounded) if only a partial face
   * appears in the image to be annotated.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.BoundingPoly bounding_poly = 1;</code>
   *
   * @return The boundingPoly.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.BoundingPoly getBoundingPoly() {
    return boundingPoly_ == null
        ? com.google.cloud.vision.v1p2beta1.BoundingPoly.getDefaultInstance()
        : boundingPoly_;
  }
  /**
   *
   *
   * <pre>
   * The bounding polygon around the face. The coordinates of the bounding box
   * are in the original image's scale, as returned in `ImageParams`.
   * The bounding box is computed to "frame" the face in accordance with human
   * expectations. It is based on the landmarker results.
   * Note that one or more x and/or y coordinates may not be generated in the
   * `BoundingPoly` (the polygon will be unbounded) if only a partial face
   * appears in the image to be annotated.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.BoundingPoly bounding_poly = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder() {
    return getBoundingPoly();
  }

  public static final int FD_BOUNDING_POLY_FIELD_NUMBER = 2;
  private com.google.cloud.vision.v1p2beta1.BoundingPoly fdBoundingPoly_;
  /**
   *
   *
   * <pre>
   * The `fd_bounding_poly` bounding polygon is tighter than the
   * `boundingPoly`, and encloses only the skin part of the face. Typically, it
   * is used to eliminate the face from any image analysis that detects the
   * "amount of skin" visible in an image. It is not based on the
   * landmarker results, only on the initial face detection, hence
   * the &lt;code&gt;fd&lt;/code&gt; (face detection) prefix.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.BoundingPoly fd_bounding_poly = 2;</code>
   *
   * @return Whether the fdBoundingPoly field is set.
   */
  @java.lang.Override
  public boolean hasFdBoundingPoly() {
    return fdBoundingPoly_ != null;
  }
  /**
   *
   *
   * <pre>
   * The `fd_bounding_poly` bounding polygon is tighter than the
   * `boundingPoly`, and encloses only the skin part of the face. Typically, it
   * is used to eliminate the face from any image analysis that detects the
   * "amount of skin" visible in an image. It is not based on the
   * landmarker results, only on the initial face detection, hence
   * the &lt;code&gt;fd&lt;/code&gt; (face detection) prefix.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.BoundingPoly fd_bounding_poly = 2;</code>
   *
   * @return The fdBoundingPoly.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.BoundingPoly getFdBoundingPoly() {
    return fdBoundingPoly_ == null
        ? com.google.cloud.vision.v1p2beta1.BoundingPoly.getDefaultInstance()
        : fdBoundingPoly_;
  }
  /**
   *
   *
   * <pre>
   * The `fd_bounding_poly` bounding polygon is tighter than the
   * `boundingPoly`, and encloses only the skin part of the face. Typically, it
   * is used to eliminate the face from any image analysis that detects the
   * "amount of skin" visible in an image. It is not based on the
   * landmarker results, only on the initial face detection, hence
   * the &lt;code&gt;fd&lt;/code&gt; (face detection) prefix.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.BoundingPoly fd_bounding_poly = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.BoundingPolyOrBuilder getFdBoundingPolyOrBuilder() {
    return getFdBoundingPoly();
  }

  public static final int LANDMARKS_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark> landmarks_;
  /**
   *
   *
   * <pre>
   * Detected face landmarks.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark>
      getLandmarksList() {
    return landmarks_;
  }
  /**
   *
   *
   * <pre>
   * Detected face landmarks.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.vision.v1p2beta1.FaceAnnotation.LandmarkOrBuilder>
      getLandmarksOrBuilderList() {
    return landmarks_;
  }
  /**
   *
   *
   * <pre>
   * Detected face landmarks.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
   */
  @java.lang.Override
  public int getLandmarksCount() {
    return landmarks_.size();
  }
  /**
   *
   *
   * <pre>
   * Detected face landmarks.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark getLandmarks(int index) {
    return landmarks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Detected face landmarks.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.FaceAnnotation.LandmarkOrBuilder getLandmarksOrBuilder(
      int index) {
    return landmarks_.get(index);
  }

  public static final int ROLL_ANGLE_FIELD_NUMBER = 4;
  private float rollAngle_;
  /**
   *
   *
   * <pre>
   * Roll angle, which indicates the amount of clockwise/anti-clockwise rotation
   * of the face relative to the image vertical about the axis perpendicular to
   * the face. Range [-180,180].
   * </pre>
   *
   * <code>float roll_angle = 4;</code>
   *
   * @return The rollAngle.
   */
  @java.lang.Override
  public float getRollAngle() {
    return rollAngle_;
  }

  public static final int PAN_ANGLE_FIELD_NUMBER = 5;
  private float panAngle_;
  /**
   *
   *
   * <pre>
   * Yaw angle, which indicates the leftward/rightward angle that the face is
   * pointing relative to the vertical plane perpendicular to the image. Range
   * [-180,180].
   * </pre>
   *
   * <code>float pan_angle = 5;</code>
   *
   * @return The panAngle.
   */
  @java.lang.Override
  public float getPanAngle() {
    return panAngle_;
  }

  public static final int TILT_ANGLE_FIELD_NUMBER = 6;
  private float tiltAngle_;
  /**
   *
   *
   * <pre>
   * Pitch angle, which indicates the upwards/downwards angle that the face is
   * pointing relative to the image's horizontal plane. Range [-180,180].
   * </pre>
   *
   * <code>float tilt_angle = 6;</code>
   *
   * @return The tiltAngle.
   */
  @java.lang.Override
  public float getTiltAngle() {
    return tiltAngle_;
  }

  public static final int DETECTION_CONFIDENCE_FIELD_NUMBER = 7;
  private float detectionConfidence_;
  /**
   *
   *
   * <pre>
   * Detection confidence. Range [0, 1].
   * </pre>
   *
   * <code>float detection_confidence = 7;</code>
   *
   * @return The detectionConfidence.
   */
  @java.lang.Override
  public float getDetectionConfidence() {
    return detectionConfidence_;
  }

  public static final int LANDMARKING_CONFIDENCE_FIELD_NUMBER = 8;
  private float landmarkingConfidence_;
  /**
   *
   *
   * <pre>
   * Face landmarking confidence. Range [0, 1].
   * </pre>
   *
   * <code>float landmarking_confidence = 8;</code>
   *
   * @return The landmarkingConfidence.
   */
  @java.lang.Override
  public float getLandmarkingConfidence() {
    return landmarkingConfidence_;
  }

  public static final int JOY_LIKELIHOOD_FIELD_NUMBER = 9;
  private int joyLikelihood_;
  /**
   *
   *
   * <pre>
   * Joy likelihood.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.Likelihood joy_likelihood = 9;</code>
   *
   * @return The enum numeric value on the wire for joyLikelihood.
   */
  @java.lang.Override
  public int getJoyLikelihoodValue() {
    return joyLikelihood_;
  }
  /**
   *
   *
   * <pre>
   * Joy likelihood.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.Likelihood joy_likelihood = 9;</code>
   *
   * @return The joyLikelihood.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.Likelihood getJoyLikelihood() {
    @SuppressWarnings("deprecation")
    com.google.cloud.vision.v1p2beta1.Likelihood result =
        com.google.cloud.vision.v1p2beta1.Likelihood.valueOf(joyLikelihood_);
    return result == null ? com.google.cloud.vision.v1p2beta1.Likelihood.UNRECOGNIZED : result;
  }

  public static final int SORROW_LIKELIHOOD_FIELD_NUMBER = 10;
  private int sorrowLikelihood_;
  /**
   *
   *
   * <pre>
   * Sorrow likelihood.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.Likelihood sorrow_likelihood = 10;</code>
   *
   * @return The enum numeric value on the wire for sorrowLikelihood.
   */
  @java.lang.Override
  public int getSorrowLikelihoodValue() {
    return sorrowLikelihood_;
  }
  /**
   *
   *
   * <pre>
   * Sorrow likelihood.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.Likelihood sorrow_likelihood = 10;</code>
   *
   * @return The sorrowLikelihood.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.Likelihood getSorrowLikelihood() {
    @SuppressWarnings("deprecation")
    com.google.cloud.vision.v1p2beta1.Likelihood result =
        com.google.cloud.vision.v1p2beta1.Likelihood.valueOf(sorrowLikelihood_);
    return result == null ? com.google.cloud.vision.v1p2beta1.Likelihood.UNRECOGNIZED : result;
  }

  public static final int ANGER_LIKELIHOOD_FIELD_NUMBER = 11;
  private int angerLikelihood_;
  /**
   *
   *
   * <pre>
   * Anger likelihood.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.Likelihood anger_likelihood = 11;</code>
   *
   * @return The enum numeric value on the wire for angerLikelihood.
   */
  @java.lang.Override
  public int getAngerLikelihoodValue() {
    return angerLikelihood_;
  }
  /**
   *
   *
   * <pre>
   * Anger likelihood.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.Likelihood anger_likelihood = 11;</code>
   *
   * @return The angerLikelihood.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.Likelihood getAngerLikelihood() {
    @SuppressWarnings("deprecation")
    com.google.cloud.vision.v1p2beta1.Likelihood result =
        com.google.cloud.vision.v1p2beta1.Likelihood.valueOf(angerLikelihood_);
    return result == null ? com.google.cloud.vision.v1p2beta1.Likelihood.UNRECOGNIZED : result;
  }

  public static final int SURPRISE_LIKELIHOOD_FIELD_NUMBER = 12;
  private int surpriseLikelihood_;
  /**
   *
   *
   * <pre>
   * Surprise likelihood.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.Likelihood surprise_likelihood = 12;</code>
   *
   * @return The enum numeric value on the wire for surpriseLikelihood.
   */
  @java.lang.Override
  public int getSurpriseLikelihoodValue() {
    return surpriseLikelihood_;
  }
  /**
   *
   *
   * <pre>
   * Surprise likelihood.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.Likelihood surprise_likelihood = 12;</code>
   *
   * @return The surpriseLikelihood.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.Likelihood getSurpriseLikelihood() {
    @SuppressWarnings("deprecation")
    com.google.cloud.vision.v1p2beta1.Likelihood result =
        com.google.cloud.vision.v1p2beta1.Likelihood.valueOf(surpriseLikelihood_);
    return result == null ? com.google.cloud.vision.v1p2beta1.Likelihood.UNRECOGNIZED : result;
  }

  public static final int UNDER_EXPOSED_LIKELIHOOD_FIELD_NUMBER = 13;
  private int underExposedLikelihood_;
  /**
   *
   *
   * <pre>
   * Under-exposed likelihood.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.Likelihood under_exposed_likelihood = 13;</code>
   *
   * @return The enum numeric value on the wire for underExposedLikelihood.
   */
  @java.lang.Override
  public int getUnderExposedLikelihoodValue() {
    return underExposedLikelihood_;
  }
  /**
   *
   *
   * <pre>
   * Under-exposed likelihood.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.Likelihood under_exposed_likelihood = 13;</code>
   *
   * @return The underExposedLikelihood.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.Likelihood getUnderExposedLikelihood() {
    @SuppressWarnings("deprecation")
    com.google.cloud.vision.v1p2beta1.Likelihood result =
        com.google.cloud.vision.v1p2beta1.Likelihood.valueOf(underExposedLikelihood_);
    return result == null ? com.google.cloud.vision.v1p2beta1.Likelihood.UNRECOGNIZED : result;
  }

  public static final int BLURRED_LIKELIHOOD_FIELD_NUMBER = 14;
  private int blurredLikelihood_;
  /**
   *
   *
   * <pre>
   * Blurred likelihood.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.Likelihood blurred_likelihood = 14;</code>
   *
   * @return The enum numeric value on the wire for blurredLikelihood.
   */
  @java.lang.Override
  public int getBlurredLikelihoodValue() {
    return blurredLikelihood_;
  }
  /**
   *
   *
   * <pre>
   * Blurred likelihood.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.Likelihood blurred_likelihood = 14;</code>
   *
   * @return The blurredLikelihood.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.Likelihood getBlurredLikelihood() {
    @SuppressWarnings("deprecation")
    com.google.cloud.vision.v1p2beta1.Likelihood result =
        com.google.cloud.vision.v1p2beta1.Likelihood.valueOf(blurredLikelihood_);
    return result == null ? com.google.cloud.vision.v1p2beta1.Likelihood.UNRECOGNIZED : result;
  }

  public static final int HEADWEAR_LIKELIHOOD_FIELD_NUMBER = 15;
  private int headwearLikelihood_;
  /**
   *
   *
   * <pre>
   * Headwear likelihood.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.Likelihood headwear_likelihood = 15;</code>
   *
   * @return The enum numeric value on the wire for headwearLikelihood.
   */
  @java.lang.Override
  public int getHeadwearLikelihoodValue() {
    return headwearLikelihood_;
  }
  /**
   *
   *
   * <pre>
   * Headwear likelihood.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.Likelihood headwear_likelihood = 15;</code>
   *
   * @return The headwearLikelihood.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.Likelihood getHeadwearLikelihood() {
    @SuppressWarnings("deprecation")
    com.google.cloud.vision.v1p2beta1.Likelihood result =
        com.google.cloud.vision.v1p2beta1.Likelihood.valueOf(headwearLikelihood_);
    return result == null ? com.google.cloud.vision.v1p2beta1.Likelihood.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (boundingPoly_ != null) {
      output.writeMessage(1, getBoundingPoly());
    }
    if (fdBoundingPoly_ != null) {
      output.writeMessage(2, getFdBoundingPoly());
    }
    for (int i = 0; i < landmarks_.size(); i++) {
      output.writeMessage(3, landmarks_.get(i));
    }
    if (java.lang.Float.floatToRawIntBits(rollAngle_) != 0) {
      output.writeFloat(4, rollAngle_);
    }
    if (java.lang.Float.floatToRawIntBits(panAngle_) != 0) {
      output.writeFloat(5, panAngle_);
    }
    if (java.lang.Float.floatToRawIntBits(tiltAngle_) != 0) {
      output.writeFloat(6, tiltAngle_);
    }
    if (java.lang.Float.floatToRawIntBits(detectionConfidence_) != 0) {
      output.writeFloat(7, detectionConfidence_);
    }
    if (java.lang.Float.floatToRawIntBits(landmarkingConfidence_) != 0) {
      output.writeFloat(8, landmarkingConfidence_);
    }
    if (joyLikelihood_ != com.google.cloud.vision.v1p2beta1.Likelihood.UNKNOWN.getNumber()) {
      output.writeEnum(9, joyLikelihood_);
    }
    if (sorrowLikelihood_ != com.google.cloud.vision.v1p2beta1.Likelihood.UNKNOWN.getNumber()) {
      output.writeEnum(10, sorrowLikelihood_);
    }
    if (angerLikelihood_ != com.google.cloud.vision.v1p2beta1.Likelihood.UNKNOWN.getNumber()) {
      output.writeEnum(11, angerLikelihood_);
    }
    if (surpriseLikelihood_ != com.google.cloud.vision.v1p2beta1.Likelihood.UNKNOWN.getNumber()) {
      output.writeEnum(12, surpriseLikelihood_);
    }
    if (underExposedLikelihood_
        != com.google.cloud.vision.v1p2beta1.Likelihood.UNKNOWN.getNumber()) {
      output.writeEnum(13, underExposedLikelihood_);
    }
    if (blurredLikelihood_ != com.google.cloud.vision.v1p2beta1.Likelihood.UNKNOWN.getNumber()) {
      output.writeEnum(14, blurredLikelihood_);
    }
    if (headwearLikelihood_ != com.google.cloud.vision.v1p2beta1.Likelihood.UNKNOWN.getNumber()) {
      output.writeEnum(15, headwearLikelihood_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (boundingPoly_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getBoundingPoly());
    }
    if (fdBoundingPoly_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getFdBoundingPoly());
    }
    for (int i = 0; i < landmarks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, landmarks_.get(i));
    }
    if (java.lang.Float.floatToRawIntBits(rollAngle_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, rollAngle_);
    }
    if (java.lang.Float.floatToRawIntBits(panAngle_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(5, panAngle_);
    }
    if (java.lang.Float.floatToRawIntBits(tiltAngle_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(6, tiltAngle_);
    }
    if (java.lang.Float.floatToRawIntBits(detectionConfidence_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(7, detectionConfidence_);
    }
    if (java.lang.Float.floatToRawIntBits(landmarkingConfidence_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(8, landmarkingConfidence_);
    }
    if (joyLikelihood_ != com.google.cloud.vision.v1p2beta1.Likelihood.UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, joyLikelihood_);
    }
    if (sorrowLikelihood_ != com.google.cloud.vision.v1p2beta1.Likelihood.UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, sorrowLikelihood_);
    }
    if (angerLikelihood_ != com.google.cloud.vision.v1p2beta1.Likelihood.UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(11, angerLikelihood_);
    }
    if (surpriseLikelihood_ != com.google.cloud.vision.v1p2beta1.Likelihood.UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, surpriseLikelihood_);
    }
    if (underExposedLikelihood_
        != com.google.cloud.vision.v1p2beta1.Likelihood.UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(13, underExposedLikelihood_);
    }
    if (blurredLikelihood_ != com.google.cloud.vision.v1p2beta1.Likelihood.UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(14, blurredLikelihood_);
    }
    if (headwearLikelihood_ != com.google.cloud.vision.v1p2beta1.Likelihood.UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, headwearLikelihood_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1p2beta1.FaceAnnotation)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1p2beta1.FaceAnnotation other =
        (com.google.cloud.vision.v1p2beta1.FaceAnnotation) obj;

    if (hasBoundingPoly() != other.hasBoundingPoly()) return false;
    if (hasBoundingPoly()) {
      if (!getBoundingPoly().equals(other.getBoundingPoly())) return false;
    }
    if (hasFdBoundingPoly() != other.hasFdBoundingPoly()) return false;
    if (hasFdBoundingPoly()) {
      if (!getFdBoundingPoly().equals(other.getFdBoundingPoly())) return false;
    }
    if (!getLandmarksList().equals(other.getLandmarksList())) return false;
    if (java.lang.Float.floatToIntBits(getRollAngle())
        != java.lang.Float.floatToIntBits(other.getRollAngle())) return false;
    if (java.lang.Float.floatToIntBits(getPanAngle())
        != java.lang.Float.floatToIntBits(other.getPanAngle())) return false;
    if (java.lang.Float.floatToIntBits(getTiltAngle())
        != java.lang.Float.floatToIntBits(other.getTiltAngle())) return false;
    if (java.lang.Float.floatToIntBits(getDetectionConfidence())
        != java.lang.Float.floatToIntBits(other.getDetectionConfidence())) return false;
    if (java.lang.Float.floatToIntBits(getLandmarkingConfidence())
        != java.lang.Float.floatToIntBits(other.getLandmarkingConfidence())) return false;
    if (joyLikelihood_ != other.joyLikelihood_) return false;
    if (sorrowLikelihood_ != other.sorrowLikelihood_) return false;
    if (angerLikelihood_ != other.angerLikelihood_) return false;
    if (surpriseLikelihood_ != other.surpriseLikelihood_) return false;
    if (underExposedLikelihood_ != other.underExposedLikelihood_) return false;
    if (blurredLikelihood_ != other.blurredLikelihood_) return false;
    if (headwearLikelihood_ != other.headwearLikelihood_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBoundingPoly()) {
      hash = (37 * hash) + BOUNDING_POLY_FIELD_NUMBER;
      hash = (53 * hash) + getBoundingPoly().hashCode();
    }
    if (hasFdBoundingPoly()) {
      hash = (37 * hash) + FD_BOUNDING_POLY_FIELD_NUMBER;
      hash = (53 * hash) + getFdBoundingPoly().hashCode();
    }
    if (getLandmarksCount() > 0) {
      hash = (37 * hash) + LANDMARKS_FIELD_NUMBER;
      hash = (53 * hash) + getLandmarksList().hashCode();
    }
    hash = (37 * hash) + ROLL_ANGLE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getRollAngle());
    hash = (37 * hash) + PAN_ANGLE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getPanAngle());
    hash = (37 * hash) + TILT_ANGLE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getTiltAngle());
    hash = (37 * hash) + DETECTION_CONFIDENCE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getDetectionConfidence());
    hash = (37 * hash) + LANDMARKING_CONFIDENCE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getLandmarkingConfidence());
    hash = (37 * hash) + JOY_LIKELIHOOD_FIELD_NUMBER;
    hash = (53 * hash) + joyLikelihood_;
    hash = (37 * hash) + SORROW_LIKELIHOOD_FIELD_NUMBER;
    hash = (53 * hash) + sorrowLikelihood_;
    hash = (37 * hash) + ANGER_LIKELIHOOD_FIELD_NUMBER;
    hash = (53 * hash) + angerLikelihood_;
    hash = (37 * hash) + SURPRISE_LIKELIHOOD_FIELD_NUMBER;
    hash = (53 * hash) + surpriseLikelihood_;
    hash = (37 * hash) + UNDER_EXPOSED_LIKELIHOOD_FIELD_NUMBER;
    hash = (53 * hash) + underExposedLikelihood_;
    hash = (37 * hash) + BLURRED_LIKELIHOOD_FIELD_NUMBER;
    hash = (53 * hash) + blurredLikelihood_;
    hash = (37 * hash) + HEADWEAR_LIKELIHOOD_FIELD_NUMBER;
    hash = (53 * hash) + headwearLikelihood_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1p2beta1.FaceAnnotation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p2beta1.FaceAnnotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.FaceAnnotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p2beta1.FaceAnnotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.FaceAnnotation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p2beta1.FaceAnnotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.FaceAnnotation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p2beta1.FaceAnnotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.FaceAnnotation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p2beta1.FaceAnnotation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.FaceAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p2beta1.FaceAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vision.v1p2beta1.FaceAnnotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A face annotation object contains the results of face detection.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p2beta1.FaceAnnotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p2beta1.FaceAnnotation)
      com.google.cloud.vision.v1p2beta1.FaceAnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p2beta1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1p2beta1_FaceAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p2beta1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1p2beta1_FaceAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p2beta1.FaceAnnotation.class,
              com.google.cloud.vision.v1p2beta1.FaceAnnotation.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1p2beta1.FaceAnnotation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLandmarksFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (boundingPolyBuilder_ == null) {
        boundingPoly_ = null;
      } else {
        boundingPoly_ = null;
        boundingPolyBuilder_ = null;
      }
      if (fdBoundingPolyBuilder_ == null) {
        fdBoundingPoly_ = null;
      } else {
        fdBoundingPoly_ = null;
        fdBoundingPolyBuilder_ = null;
      }
      if (landmarksBuilder_ == null) {
        landmarks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        landmarksBuilder_.clear();
      }
      rollAngle_ = 0F;

      panAngle_ = 0F;

      tiltAngle_ = 0F;

      detectionConfidence_ = 0F;

      landmarkingConfidence_ = 0F;

      joyLikelihood_ = 0;

      sorrowLikelihood_ = 0;

      angerLikelihood_ = 0;

      surpriseLikelihood_ = 0;

      underExposedLikelihood_ = 0;

      blurredLikelihood_ = 0;

      headwearLikelihood_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1p2beta1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1p2beta1_FaceAnnotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.FaceAnnotation getDefaultInstanceForType() {
      return com.google.cloud.vision.v1p2beta1.FaceAnnotation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.FaceAnnotation build() {
      com.google.cloud.vision.v1p2beta1.FaceAnnotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.FaceAnnotation buildPartial() {
      com.google.cloud.vision.v1p2beta1.FaceAnnotation result =
          new com.google.cloud.vision.v1p2beta1.FaceAnnotation(this);
      int from_bitField0_ = bitField0_;
      if (boundingPolyBuilder_ == null) {
        result.boundingPoly_ = boundingPoly_;
      } else {
        result.boundingPoly_ = boundingPolyBuilder_.build();
      }
      if (fdBoundingPolyBuilder_ == null) {
        result.fdBoundingPoly_ = fdBoundingPoly_;
      } else {
        result.fdBoundingPoly_ = fdBoundingPolyBuilder_.build();
      }
      if (landmarksBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          landmarks_ = java.util.Collections.unmodifiableList(landmarks_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.landmarks_ = landmarks_;
      } else {
        result.landmarks_ = landmarksBuilder_.build();
      }
      result.rollAngle_ = rollAngle_;
      result.panAngle_ = panAngle_;
      result.tiltAngle_ = tiltAngle_;
      result.detectionConfidence_ = detectionConfidence_;
      result.landmarkingConfidence_ = landmarkingConfidence_;
      result.joyLikelihood_ = joyLikelihood_;
      result.sorrowLikelihood_ = sorrowLikelihood_;
      result.angerLikelihood_ = angerLikelihood_;
      result.surpriseLikelihood_ = surpriseLikelihood_;
      result.underExposedLikelihood_ = underExposedLikelihood_;
      result.blurredLikelihood_ = blurredLikelihood_;
      result.headwearLikelihood_ = headwearLikelihood_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1p2beta1.FaceAnnotation) {
        return mergeFrom((com.google.cloud.vision.v1p2beta1.FaceAnnotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1p2beta1.FaceAnnotation other) {
      if (other == com.google.cloud.vision.v1p2beta1.FaceAnnotation.getDefaultInstance())
        return this;
      if (other.hasBoundingPoly()) {
        mergeBoundingPoly(other.getBoundingPoly());
      }
      if (other.hasFdBoundingPoly()) {
        mergeFdBoundingPoly(other.getFdBoundingPoly());
      }
      if (landmarksBuilder_ == null) {
        if (!other.landmarks_.isEmpty()) {
          if (landmarks_.isEmpty()) {
            landmarks_ = other.landmarks_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureLandmarksIsMutable();
            landmarks_.addAll(other.landmarks_);
          }
          onChanged();
        }
      } else {
        if (!other.landmarks_.isEmpty()) {
          if (landmarksBuilder_.isEmpty()) {
            landmarksBuilder_.dispose();
            landmarksBuilder_ = null;
            landmarks_ = other.landmarks_;
            bitField0_ = (bitField0_ & ~0x00000001);
            landmarksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLandmarksFieldBuilder()
                    : null;
          } else {
            landmarksBuilder_.addAllMessages(other.landmarks_);
          }
        }
      }
      if (other.getRollAngle() != 0F) {
        setRollAngle(other.getRollAngle());
      }
      if (other.getPanAngle() != 0F) {
        setPanAngle(other.getPanAngle());
      }
      if (other.getTiltAngle() != 0F) {
        setTiltAngle(other.getTiltAngle());
      }
      if (other.getDetectionConfidence() != 0F) {
        setDetectionConfidence(other.getDetectionConfidence());
      }
      if (other.getLandmarkingConfidence() != 0F) {
        setLandmarkingConfidence(other.getLandmarkingConfidence());
      }
      if (other.joyLikelihood_ != 0) {
        setJoyLikelihoodValue(other.getJoyLikelihoodValue());
      }
      if (other.sorrowLikelihood_ != 0) {
        setSorrowLikelihoodValue(other.getSorrowLikelihoodValue());
      }
      if (other.angerLikelihood_ != 0) {
        setAngerLikelihoodValue(other.getAngerLikelihoodValue());
      }
      if (other.surpriseLikelihood_ != 0) {
        setSurpriseLikelihoodValue(other.getSurpriseLikelihoodValue());
      }
      if (other.underExposedLikelihood_ != 0) {
        setUnderExposedLikelihoodValue(other.getUnderExposedLikelihoodValue());
      }
      if (other.blurredLikelihood_ != 0) {
        setBlurredLikelihoodValue(other.getBlurredLikelihoodValue());
      }
      if (other.headwearLikelihood_ != 0) {
        setHeadwearLikelihoodValue(other.getHeadwearLikelihoodValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.vision.v1p2beta1.FaceAnnotation parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.vision.v1p2beta1.FaceAnnotation) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.cloud.vision.v1p2beta1.BoundingPoly boundingPoly_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.BoundingPoly,
            com.google.cloud.vision.v1p2beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p2beta1.BoundingPolyOrBuilder>
        boundingPolyBuilder_;
    /**
     *
     *
     * <pre>
     * The bounding polygon around the face. The coordinates of the bounding box
     * are in the original image's scale, as returned in `ImageParams`.
     * The bounding box is computed to "frame" the face in accordance with human
     * expectations. It is based on the landmarker results.
     * Note that one or more x and/or y coordinates may not be generated in the
     * `BoundingPoly` (the polygon will be unbounded) if only a partial face
     * appears in the image to be annotated.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly bounding_poly = 1;</code>
     *
     * @return Whether the boundingPoly field is set.
     */
    public boolean hasBoundingPoly() {
      return boundingPolyBuilder_ != null || boundingPoly_ != null;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the face. The coordinates of the bounding box
     * are in the original image's scale, as returned in `ImageParams`.
     * The bounding box is computed to "frame" the face in accordance with human
     * expectations. It is based on the landmarker results.
     * Note that one or more x and/or y coordinates may not be generated in the
     * `BoundingPoly` (the polygon will be unbounded) if only a partial face
     * appears in the image to be annotated.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly bounding_poly = 1;</code>
     *
     * @return The boundingPoly.
     */
    public com.google.cloud.vision.v1p2beta1.BoundingPoly getBoundingPoly() {
      if (boundingPolyBuilder_ == null) {
        return boundingPoly_ == null
            ? com.google.cloud.vision.v1p2beta1.BoundingPoly.getDefaultInstance()
            : boundingPoly_;
      } else {
        return boundingPolyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the face. The coordinates of the bounding box
     * are in the original image's scale, as returned in `ImageParams`.
     * The bounding box is computed to "frame" the face in accordance with human
     * expectations. It is based on the landmarker results.
     * Note that one or more x and/or y coordinates may not be generated in the
     * `BoundingPoly` (the polygon will be unbounded) if only a partial face
     * appears in the image to be annotated.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly bounding_poly = 1;</code>
     */
    public Builder setBoundingPoly(com.google.cloud.vision.v1p2beta1.BoundingPoly value) {
      if (boundingPolyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        boundingPoly_ = value;
        onChanged();
      } else {
        boundingPolyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the face. The coordinates of the bounding box
     * are in the original image's scale, as returned in `ImageParams`.
     * The bounding box is computed to "frame" the face in accordance with human
     * expectations. It is based on the landmarker results.
     * Note that one or more x and/or y coordinates may not be generated in the
     * `BoundingPoly` (the polygon will be unbounded) if only a partial face
     * appears in the image to be annotated.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly bounding_poly = 1;</code>
     */
    public Builder setBoundingPoly(
        com.google.cloud.vision.v1p2beta1.BoundingPoly.Builder builderForValue) {
      if (boundingPolyBuilder_ == null) {
        boundingPoly_ = builderForValue.build();
        onChanged();
      } else {
        boundingPolyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the face. The coordinates of the bounding box
     * are in the original image's scale, as returned in `ImageParams`.
     * The bounding box is computed to "frame" the face in accordance with human
     * expectations. It is based on the landmarker results.
     * Note that one or more x and/or y coordinates may not be generated in the
     * `BoundingPoly` (the polygon will be unbounded) if only a partial face
     * appears in the image to be annotated.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly bounding_poly = 1;</code>
     */
    public Builder mergeBoundingPoly(com.google.cloud.vision.v1p2beta1.BoundingPoly value) {
      if (boundingPolyBuilder_ == null) {
        if (boundingPoly_ != null) {
          boundingPoly_ =
              com.google.cloud.vision.v1p2beta1.BoundingPoly.newBuilder(boundingPoly_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          boundingPoly_ = value;
        }
        onChanged();
      } else {
        boundingPolyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the face. The coordinates of the bounding box
     * are in the original image's scale, as returned in `ImageParams`.
     * The bounding box is computed to "frame" the face in accordance with human
     * expectations. It is based on the landmarker results.
     * Note that one or more x and/or y coordinates may not be generated in the
     * `BoundingPoly` (the polygon will be unbounded) if only a partial face
     * appears in the image to be annotated.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly bounding_poly = 1;</code>
     */
    public Builder clearBoundingPoly() {
      if (boundingPolyBuilder_ == null) {
        boundingPoly_ = null;
        onChanged();
      } else {
        boundingPoly_ = null;
        boundingPolyBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the face. The coordinates of the bounding box
     * are in the original image's scale, as returned in `ImageParams`.
     * The bounding box is computed to "frame" the face in accordance with human
     * expectations. It is based on the landmarker results.
     * Note that one or more x and/or y coordinates may not be generated in the
     * `BoundingPoly` (the polygon will be unbounded) if only a partial face
     * appears in the image to be annotated.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly bounding_poly = 1;</code>
     */
    public com.google.cloud.vision.v1p2beta1.BoundingPoly.Builder getBoundingPolyBuilder() {

      onChanged();
      return getBoundingPolyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the face. The coordinates of the bounding box
     * are in the original image's scale, as returned in `ImageParams`.
     * The bounding box is computed to "frame" the face in accordance with human
     * expectations. It is based on the landmarker results.
     * Note that one or more x and/or y coordinates may not be generated in the
     * `BoundingPoly` (the polygon will be unbounded) if only a partial face
     * appears in the image to be annotated.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly bounding_poly = 1;</code>
     */
    public com.google.cloud.vision.v1p2beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder() {
      if (boundingPolyBuilder_ != null) {
        return boundingPolyBuilder_.getMessageOrBuilder();
      } else {
        return boundingPoly_ == null
            ? com.google.cloud.vision.v1p2beta1.BoundingPoly.getDefaultInstance()
            : boundingPoly_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the face. The coordinates of the bounding box
     * are in the original image's scale, as returned in `ImageParams`.
     * The bounding box is computed to "frame" the face in accordance with human
     * expectations. It is based on the landmarker results.
     * Note that one or more x and/or y coordinates may not be generated in the
     * `BoundingPoly` (the polygon will be unbounded) if only a partial face
     * appears in the image to be annotated.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly bounding_poly = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.BoundingPoly,
            com.google.cloud.vision.v1p2beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p2beta1.BoundingPolyOrBuilder>
        getBoundingPolyFieldBuilder() {
      if (boundingPolyBuilder_ == null) {
        boundingPolyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p2beta1.BoundingPoly,
                com.google.cloud.vision.v1p2beta1.BoundingPoly.Builder,
                com.google.cloud.vision.v1p2beta1.BoundingPolyOrBuilder>(
                getBoundingPoly(), getParentForChildren(), isClean());
        boundingPoly_ = null;
      }
      return boundingPolyBuilder_;
    }

    private com.google.cloud.vision.v1p2beta1.BoundingPoly fdBoundingPoly_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.BoundingPoly,
            com.google.cloud.vision.v1p2beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p2beta1.BoundingPolyOrBuilder>
        fdBoundingPolyBuilder_;
    /**
     *
     *
     * <pre>
     * The `fd_bounding_poly` bounding polygon is tighter than the
     * `boundingPoly`, and encloses only the skin part of the face. Typically, it
     * is used to eliminate the face from any image analysis that detects the
     * "amount of skin" visible in an image. It is not based on the
     * landmarker results, only on the initial face detection, hence
     * the &lt;code&gt;fd&lt;/code&gt; (face detection) prefix.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly fd_bounding_poly = 2;</code>
     *
     * @return Whether the fdBoundingPoly field is set.
     */
    public boolean hasFdBoundingPoly() {
      return fdBoundingPolyBuilder_ != null || fdBoundingPoly_ != null;
    }
    /**
     *
     *
     * <pre>
     * The `fd_bounding_poly` bounding polygon is tighter than the
     * `boundingPoly`, and encloses only the skin part of the face. Typically, it
     * is used to eliminate the face from any image analysis that detects the
     * "amount of skin" visible in an image. It is not based on the
     * landmarker results, only on the initial face detection, hence
     * the &lt;code&gt;fd&lt;/code&gt; (face detection) prefix.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly fd_bounding_poly = 2;</code>
     *
     * @return The fdBoundingPoly.
     */
    public com.google.cloud.vision.v1p2beta1.BoundingPoly getFdBoundingPoly() {
      if (fdBoundingPolyBuilder_ == null) {
        return fdBoundingPoly_ == null
            ? com.google.cloud.vision.v1p2beta1.BoundingPoly.getDefaultInstance()
            : fdBoundingPoly_;
      } else {
        return fdBoundingPolyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The `fd_bounding_poly` bounding polygon is tighter than the
     * `boundingPoly`, and encloses only the skin part of the face. Typically, it
     * is used to eliminate the face from any image analysis that detects the
     * "amount of skin" visible in an image. It is not based on the
     * landmarker results, only on the initial face detection, hence
     * the &lt;code&gt;fd&lt;/code&gt; (face detection) prefix.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly fd_bounding_poly = 2;</code>
     */
    public Builder setFdBoundingPoly(com.google.cloud.vision.v1p2beta1.BoundingPoly value) {
      if (fdBoundingPolyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fdBoundingPoly_ = value;
        onChanged();
      } else {
        fdBoundingPolyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The `fd_bounding_poly` bounding polygon is tighter than the
     * `boundingPoly`, and encloses only the skin part of the face. Typically, it
     * is used to eliminate the face from any image analysis that detects the
     * "amount of skin" visible in an image. It is not based on the
     * landmarker results, only on the initial face detection, hence
     * the &lt;code&gt;fd&lt;/code&gt; (face detection) prefix.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly fd_bounding_poly = 2;</code>
     */
    public Builder setFdBoundingPoly(
        com.google.cloud.vision.v1p2beta1.BoundingPoly.Builder builderForValue) {
      if (fdBoundingPolyBuilder_ == null) {
        fdBoundingPoly_ = builderForValue.build();
        onChanged();
      } else {
        fdBoundingPolyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The `fd_bounding_poly` bounding polygon is tighter than the
     * `boundingPoly`, and encloses only the skin part of the face. Typically, it
     * is used to eliminate the face from any image analysis that detects the
     * "amount of skin" visible in an image. It is not based on the
     * landmarker results, only on the initial face detection, hence
     * the &lt;code&gt;fd&lt;/code&gt; (face detection) prefix.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly fd_bounding_poly = 2;</code>
     */
    public Builder mergeFdBoundingPoly(com.google.cloud.vision.v1p2beta1.BoundingPoly value) {
      if (fdBoundingPolyBuilder_ == null) {
        if (fdBoundingPoly_ != null) {
          fdBoundingPoly_ =
              com.google.cloud.vision.v1p2beta1.BoundingPoly.newBuilder(fdBoundingPoly_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          fdBoundingPoly_ = value;
        }
        onChanged();
      } else {
        fdBoundingPolyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The `fd_bounding_poly` bounding polygon is tighter than the
     * `boundingPoly`, and encloses only the skin part of the face. Typically, it
     * is used to eliminate the face from any image analysis that detects the
     * "amount of skin" visible in an image. It is not based on the
     * landmarker results, only on the initial face detection, hence
     * the &lt;code&gt;fd&lt;/code&gt; (face detection) prefix.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly fd_bounding_poly = 2;</code>
     */
    public Builder clearFdBoundingPoly() {
      if (fdBoundingPolyBuilder_ == null) {
        fdBoundingPoly_ = null;
        onChanged();
      } else {
        fdBoundingPoly_ = null;
        fdBoundingPolyBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The `fd_bounding_poly` bounding polygon is tighter than the
     * `boundingPoly`, and encloses only the skin part of the face. Typically, it
     * is used to eliminate the face from any image analysis that detects the
     * "amount of skin" visible in an image. It is not based on the
     * landmarker results, only on the initial face detection, hence
     * the &lt;code&gt;fd&lt;/code&gt; (face detection) prefix.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly fd_bounding_poly = 2;</code>
     */
    public com.google.cloud.vision.v1p2beta1.BoundingPoly.Builder getFdBoundingPolyBuilder() {

      onChanged();
      return getFdBoundingPolyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The `fd_bounding_poly` bounding polygon is tighter than the
     * `boundingPoly`, and encloses only the skin part of the face. Typically, it
     * is used to eliminate the face from any image analysis that detects the
     * "amount of skin" visible in an image. It is not based on the
     * landmarker results, only on the initial face detection, hence
     * the &lt;code&gt;fd&lt;/code&gt; (face detection) prefix.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly fd_bounding_poly = 2;</code>
     */
    public com.google.cloud.vision.v1p2beta1.BoundingPolyOrBuilder getFdBoundingPolyOrBuilder() {
      if (fdBoundingPolyBuilder_ != null) {
        return fdBoundingPolyBuilder_.getMessageOrBuilder();
      } else {
        return fdBoundingPoly_ == null
            ? com.google.cloud.vision.v1p2beta1.BoundingPoly.getDefaultInstance()
            : fdBoundingPoly_;
      }
    }
    /**
     *
     *
     * <pre>
     * The `fd_bounding_poly` bounding polygon is tighter than the
     * `boundingPoly`, and encloses only the skin part of the face. Typically, it
     * is used to eliminate the face from any image analysis that detects the
     * "amount of skin" visible in an image. It is not based on the
     * landmarker results, only on the initial face detection, hence
     * the &lt;code&gt;fd&lt;/code&gt; (face detection) prefix.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.BoundingPoly fd_bounding_poly = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.BoundingPoly,
            com.google.cloud.vision.v1p2beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p2beta1.BoundingPolyOrBuilder>
        getFdBoundingPolyFieldBuilder() {
      if (fdBoundingPolyBuilder_ == null) {
        fdBoundingPolyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p2beta1.BoundingPoly,
                com.google.cloud.vision.v1p2beta1.BoundingPoly.Builder,
                com.google.cloud.vision.v1p2beta1.BoundingPolyOrBuilder>(
                getFdBoundingPoly(), getParentForChildren(), isClean());
        fdBoundingPoly_ = null;
      }
      return fdBoundingPolyBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark> landmarks_ =
        java.util.Collections.emptyList();

    private void ensureLandmarksIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        landmarks_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark>(
                landmarks_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark,
            com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Builder,
            com.google.cloud.vision.v1p2beta1.FaceAnnotation.LandmarkOrBuilder>
        landmarksBuilder_;

    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark>
        getLandmarksList() {
      if (landmarksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(landmarks_);
      } else {
        return landmarksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public int getLandmarksCount() {
      if (landmarksBuilder_ == null) {
        return landmarks_.size();
      } else {
        return landmarksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark getLandmarks(int index) {
      if (landmarksBuilder_ == null) {
        return landmarks_.get(index);
      } else {
        return landmarksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public Builder setLandmarks(
        int index, com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark value) {
      if (landmarksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLandmarksIsMutable();
        landmarks_.set(index, value);
        onChanged();
      } else {
        landmarksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public Builder setLandmarks(
        int index,
        com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Builder builderForValue) {
      if (landmarksBuilder_ == null) {
        ensureLandmarksIsMutable();
        landmarks_.set(index, builderForValue.build());
        onChanged();
      } else {
        landmarksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public Builder addLandmarks(com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark value) {
      if (landmarksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLandmarksIsMutable();
        landmarks_.add(value);
        onChanged();
      } else {
        landmarksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public Builder addLandmarks(
        int index, com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark value) {
      if (landmarksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLandmarksIsMutable();
        landmarks_.add(index, value);
        onChanged();
      } else {
        landmarksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public Builder addLandmarks(
        com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Builder builderForValue) {
      if (landmarksBuilder_ == null) {
        ensureLandmarksIsMutable();
        landmarks_.add(builderForValue.build());
        onChanged();
      } else {
        landmarksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public Builder addLandmarks(
        int index,
        com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Builder builderForValue) {
      if (landmarksBuilder_ == null) {
        ensureLandmarksIsMutable();
        landmarks_.add(index, builderForValue.build());
        onChanged();
      } else {
        landmarksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public Builder addAllLandmarks(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark>
            values) {
      if (landmarksBuilder_ == null) {
        ensureLandmarksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, landmarks_);
        onChanged();
      } else {
        landmarksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public Builder clearLandmarks() {
      if (landmarksBuilder_ == null) {
        landmarks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        landmarksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public Builder removeLandmarks(int index) {
      if (landmarksBuilder_ == null) {
        ensureLandmarksIsMutable();
        landmarks_.remove(index);
        onChanged();
      } else {
        landmarksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Builder getLandmarksBuilder(
        int index) {
      return getLandmarksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public com.google.cloud.vision.v1p2beta1.FaceAnnotation.LandmarkOrBuilder getLandmarksOrBuilder(
        int index) {
      if (landmarksBuilder_ == null) {
        return landmarks_.get(index);
      } else {
        return landmarksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.vision.v1p2beta1.FaceAnnotation.LandmarkOrBuilder>
        getLandmarksOrBuilderList() {
      if (landmarksBuilder_ != null) {
        return landmarksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(landmarks_);
      }
    }
    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Builder addLandmarksBuilder() {
      return getLandmarksFieldBuilder()
          .addBuilder(
              com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Builder addLandmarksBuilder(
        int index) {
      return getLandmarksFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Detected face landmarks.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark landmarks = 3;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Builder>
        getLandmarksBuilderList() {
      return getLandmarksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark,
            com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Builder,
            com.google.cloud.vision.v1p2beta1.FaceAnnotation.LandmarkOrBuilder>
        getLandmarksFieldBuilder() {
      if (landmarksBuilder_ == null) {
        landmarksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark,
                com.google.cloud.vision.v1p2beta1.FaceAnnotation.Landmark.Builder,
                com.google.cloud.vision.v1p2beta1.FaceAnnotation.LandmarkOrBuilder>(
                landmarks_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        landmarks_ = null;
      }
      return landmarksBuilder_;
    }

    private float rollAngle_;
    /**
     *
     *
     * <pre>
     * Roll angle, which indicates the amount of clockwise/anti-clockwise rotation
     * of the face relative to the image vertical about the axis perpendicular to
     * the face. Range [-180,180].
     * </pre>
     *
     * <code>float roll_angle = 4;</code>
     *
     * @return The rollAngle.
     */
    @java.lang.Override
    public float getRollAngle() {
      return rollAngle_;
    }
    /**
     *
     *
     * <pre>
     * Roll angle, which indicates the amount of clockwise/anti-clockwise rotation
     * of the face relative to the image vertical about the axis perpendicular to
     * the face. Range [-180,180].
     * </pre>
     *
     * <code>float roll_angle = 4;</code>
     *
     * @param value The rollAngle to set.
     * @return This builder for chaining.
     */
    public Builder setRollAngle(float value) {

      rollAngle_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Roll angle, which indicates the amount of clockwise/anti-clockwise rotation
     * of the face relative to the image vertical about the axis perpendicular to
     * the face. Range [-180,180].
     * </pre>
     *
     * <code>float roll_angle = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRollAngle() {

      rollAngle_ = 0F;
      onChanged();
      return this;
    }

    private float panAngle_;
    /**
     *
     *
     * <pre>
     * Yaw angle, which indicates the leftward/rightward angle that the face is
     * pointing relative to the vertical plane perpendicular to the image. Range
     * [-180,180].
     * </pre>
     *
     * <code>float pan_angle = 5;</code>
     *
     * @return The panAngle.
     */
    @java.lang.Override
    public float getPanAngle() {
      return panAngle_;
    }
    /**
     *
     *
     * <pre>
     * Yaw angle, which indicates the leftward/rightward angle that the face is
     * pointing relative to the vertical plane perpendicular to the image. Range
     * [-180,180].
     * </pre>
     *
     * <code>float pan_angle = 5;</code>
     *
     * @param value The panAngle to set.
     * @return This builder for chaining.
     */
    public Builder setPanAngle(float value) {

      panAngle_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Yaw angle, which indicates the leftward/rightward angle that the face is
     * pointing relative to the vertical plane perpendicular to the image. Range
     * [-180,180].
     * </pre>
     *
     * <code>float pan_angle = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPanAngle() {

      panAngle_ = 0F;
      onChanged();
      return this;
    }

    private float tiltAngle_;
    /**
     *
     *
     * <pre>
     * Pitch angle, which indicates the upwards/downwards angle that the face is
     * pointing relative to the image's horizontal plane. Range [-180,180].
     * </pre>
     *
     * <code>float tilt_angle = 6;</code>
     *
     * @return The tiltAngle.
     */
    @java.lang.Override
    public float getTiltAngle() {
      return tiltAngle_;
    }
    /**
     *
     *
     * <pre>
     * Pitch angle, which indicates the upwards/downwards angle that the face is
     * pointing relative to the image's horizontal plane. Range [-180,180].
     * </pre>
     *
     * <code>float tilt_angle = 6;</code>
     *
     * @param value The tiltAngle to set.
     * @return This builder for chaining.
     */
    public Builder setTiltAngle(float value) {

      tiltAngle_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pitch angle, which indicates the upwards/downwards angle that the face is
     * pointing relative to the image's horizontal plane. Range [-180,180].
     * </pre>
     *
     * <code>float tilt_angle = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTiltAngle() {

      tiltAngle_ = 0F;
      onChanged();
      return this;
    }

    private float detectionConfidence_;
    /**
     *
     *
     * <pre>
     * Detection confidence. Range [0, 1].
     * </pre>
     *
     * <code>float detection_confidence = 7;</code>
     *
     * @return The detectionConfidence.
     */
    @java.lang.Override
    public float getDetectionConfidence() {
      return detectionConfidence_;
    }
    /**
     *
     *
     * <pre>
     * Detection confidence. Range [0, 1].
     * </pre>
     *
     * <code>float detection_confidence = 7;</code>
     *
     * @param value The detectionConfidence to set.
     * @return This builder for chaining.
     */
    public Builder setDetectionConfidence(float value) {

      detectionConfidence_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detection confidence. Range [0, 1].
     * </pre>
     *
     * <code>float detection_confidence = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDetectionConfidence() {

      detectionConfidence_ = 0F;
      onChanged();
      return this;
    }

    private float landmarkingConfidence_;
    /**
     *
     *
     * <pre>
     * Face landmarking confidence. Range [0, 1].
     * </pre>
     *
     * <code>float landmarking_confidence = 8;</code>
     *
     * @return The landmarkingConfidence.
     */
    @java.lang.Override
    public float getLandmarkingConfidence() {
      return landmarkingConfidence_;
    }
    /**
     *
     *
     * <pre>
     * Face landmarking confidence. Range [0, 1].
     * </pre>
     *
     * <code>float landmarking_confidence = 8;</code>
     *
     * @param value The landmarkingConfidence to set.
     * @return This builder for chaining.
     */
    public Builder setLandmarkingConfidence(float value) {

      landmarkingConfidence_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face landmarking confidence. Range [0, 1].
     * </pre>
     *
     * <code>float landmarking_confidence = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLandmarkingConfidence() {

      landmarkingConfidence_ = 0F;
      onChanged();
      return this;
    }

    private int joyLikelihood_ = 0;
    /**
     *
     *
     * <pre>
     * Joy likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood joy_likelihood = 9;</code>
     *
     * @return The enum numeric value on the wire for joyLikelihood.
     */
    @java.lang.Override
    public int getJoyLikelihoodValue() {
      return joyLikelihood_;
    }
    /**
     *
     *
     * <pre>
     * Joy likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood joy_likelihood = 9;</code>
     *
     * @param value The enum numeric value on the wire for joyLikelihood to set.
     * @return This builder for chaining.
     */
    public Builder setJoyLikelihoodValue(int value) {

      joyLikelihood_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Joy likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood joy_likelihood = 9;</code>
     *
     * @return The joyLikelihood.
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.Likelihood getJoyLikelihood() {
      @SuppressWarnings("deprecation")
      com.google.cloud.vision.v1p2beta1.Likelihood result =
          com.google.cloud.vision.v1p2beta1.Likelihood.valueOf(joyLikelihood_);
      return result == null ? com.google.cloud.vision.v1p2beta1.Likelihood.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Joy likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood joy_likelihood = 9;</code>
     *
     * @param value The joyLikelihood to set.
     * @return This builder for chaining.
     */
    public Builder setJoyLikelihood(com.google.cloud.vision.v1p2beta1.Likelihood value) {
      if (value == null) {
        throw new NullPointerException();
      }

      joyLikelihood_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Joy likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood joy_likelihood = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJoyLikelihood() {

      joyLikelihood_ = 0;
      onChanged();
      return this;
    }

    private int sorrowLikelihood_ = 0;
    /**
     *
     *
     * <pre>
     * Sorrow likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood sorrow_likelihood = 10;</code>
     *
     * @return The enum numeric value on the wire for sorrowLikelihood.
     */
    @java.lang.Override
    public int getSorrowLikelihoodValue() {
      return sorrowLikelihood_;
    }
    /**
     *
     *
     * <pre>
     * Sorrow likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood sorrow_likelihood = 10;</code>
     *
     * @param value The enum numeric value on the wire for sorrowLikelihood to set.
     * @return This builder for chaining.
     */
    public Builder setSorrowLikelihoodValue(int value) {

      sorrowLikelihood_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sorrow likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood sorrow_likelihood = 10;</code>
     *
     * @return The sorrowLikelihood.
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.Likelihood getSorrowLikelihood() {
      @SuppressWarnings("deprecation")
      com.google.cloud.vision.v1p2beta1.Likelihood result =
          com.google.cloud.vision.v1p2beta1.Likelihood.valueOf(sorrowLikelihood_);
      return result == null ? com.google.cloud.vision.v1p2beta1.Likelihood.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Sorrow likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood sorrow_likelihood = 10;</code>
     *
     * @param value The sorrowLikelihood to set.
     * @return This builder for chaining.
     */
    public Builder setSorrowLikelihood(com.google.cloud.vision.v1p2beta1.Likelihood value) {
      if (value == null) {
        throw new NullPointerException();
      }

      sorrowLikelihood_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sorrow likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood sorrow_likelihood = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSorrowLikelihood() {

      sorrowLikelihood_ = 0;
      onChanged();
      return this;
    }

    private int angerLikelihood_ = 0;
    /**
     *
     *
     * <pre>
     * Anger likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood anger_likelihood = 11;</code>
     *
     * @return The enum numeric value on the wire for angerLikelihood.
     */
    @java.lang.Override
    public int getAngerLikelihoodValue() {
      return angerLikelihood_;
    }
    /**
     *
     *
     * <pre>
     * Anger likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood anger_likelihood = 11;</code>
     *
     * @param value The enum numeric value on the wire for angerLikelihood to set.
     * @return This builder for chaining.
     */
    public Builder setAngerLikelihoodValue(int value) {

      angerLikelihood_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Anger likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood anger_likelihood = 11;</code>
     *
     * @return The angerLikelihood.
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.Likelihood getAngerLikelihood() {
      @SuppressWarnings("deprecation")
      com.google.cloud.vision.v1p2beta1.Likelihood result =
          com.google.cloud.vision.v1p2beta1.Likelihood.valueOf(angerLikelihood_);
      return result == null ? com.google.cloud.vision.v1p2beta1.Likelihood.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Anger likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood anger_likelihood = 11;</code>
     *
     * @param value The angerLikelihood to set.
     * @return This builder for chaining.
     */
    public Builder setAngerLikelihood(com.google.cloud.vision.v1p2beta1.Likelihood value) {
      if (value == null) {
        throw new NullPointerException();
      }

      angerLikelihood_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Anger likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood anger_likelihood = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAngerLikelihood() {

      angerLikelihood_ = 0;
      onChanged();
      return this;
    }

    private int surpriseLikelihood_ = 0;
    /**
     *
     *
     * <pre>
     * Surprise likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood surprise_likelihood = 12;</code>
     *
     * @return The enum numeric value on the wire for surpriseLikelihood.
     */
    @java.lang.Override
    public int getSurpriseLikelihoodValue() {
      return surpriseLikelihood_;
    }
    /**
     *
     *
     * <pre>
     * Surprise likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood surprise_likelihood = 12;</code>
     *
     * @param value The enum numeric value on the wire for surpriseLikelihood to set.
     * @return This builder for chaining.
     */
    public Builder setSurpriseLikelihoodValue(int value) {

      surpriseLikelihood_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Surprise likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood surprise_likelihood = 12;</code>
     *
     * @return The surpriseLikelihood.
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.Likelihood getSurpriseLikelihood() {
      @SuppressWarnings("deprecation")
      com.google.cloud.vision.v1p2beta1.Likelihood result =
          com.google.cloud.vision.v1p2beta1.Likelihood.valueOf(surpriseLikelihood_);
      return result == null ? com.google.cloud.vision.v1p2beta1.Likelihood.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Surprise likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood surprise_likelihood = 12;</code>
     *
     * @param value The surpriseLikelihood to set.
     * @return This builder for chaining.
     */
    public Builder setSurpriseLikelihood(com.google.cloud.vision.v1p2beta1.Likelihood value) {
      if (value == null) {
        throw new NullPointerException();
      }

      surpriseLikelihood_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Surprise likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood surprise_likelihood = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSurpriseLikelihood() {

      surpriseLikelihood_ = 0;
      onChanged();
      return this;
    }

    private int underExposedLikelihood_ = 0;
    /**
     *
     *
     * <pre>
     * Under-exposed likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood under_exposed_likelihood = 13;</code>
     *
     * @return The enum numeric value on the wire for underExposedLikelihood.
     */
    @java.lang.Override
    public int getUnderExposedLikelihoodValue() {
      return underExposedLikelihood_;
    }
    /**
     *
     *
     * <pre>
     * Under-exposed likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood under_exposed_likelihood = 13;</code>
     *
     * @param value The enum numeric value on the wire for underExposedLikelihood to set.
     * @return This builder for chaining.
     */
    public Builder setUnderExposedLikelihoodValue(int value) {

      underExposedLikelihood_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Under-exposed likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood under_exposed_likelihood = 13;</code>
     *
     * @return The underExposedLikelihood.
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.Likelihood getUnderExposedLikelihood() {
      @SuppressWarnings("deprecation")
      com.google.cloud.vision.v1p2beta1.Likelihood result =
          com.google.cloud.vision.v1p2beta1.Likelihood.valueOf(underExposedLikelihood_);
      return result == null ? com.google.cloud.vision.v1p2beta1.Likelihood.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Under-exposed likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood under_exposed_likelihood = 13;</code>
     *
     * @param value The underExposedLikelihood to set.
     * @return This builder for chaining.
     */
    public Builder setUnderExposedLikelihood(com.google.cloud.vision.v1p2beta1.Likelihood value) {
      if (value == null) {
        throw new NullPointerException();
      }

      underExposedLikelihood_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Under-exposed likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood under_exposed_likelihood = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnderExposedLikelihood() {

      underExposedLikelihood_ = 0;
      onChanged();
      return this;
    }

    private int blurredLikelihood_ = 0;
    /**
     *
     *
     * <pre>
     * Blurred likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood blurred_likelihood = 14;</code>
     *
     * @return The enum numeric value on the wire for blurredLikelihood.
     */
    @java.lang.Override
    public int getBlurredLikelihoodValue() {
      return blurredLikelihood_;
    }
    /**
     *
     *
     * <pre>
     * Blurred likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood blurred_likelihood = 14;</code>
     *
     * @param value The enum numeric value on the wire for blurredLikelihood to set.
     * @return This builder for chaining.
     */
    public Builder setBlurredLikelihoodValue(int value) {

      blurredLikelihood_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Blurred likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood blurred_likelihood = 14;</code>
     *
     * @return The blurredLikelihood.
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.Likelihood getBlurredLikelihood() {
      @SuppressWarnings("deprecation")
      com.google.cloud.vision.v1p2beta1.Likelihood result =
          com.google.cloud.vision.v1p2beta1.Likelihood.valueOf(blurredLikelihood_);
      return result == null ? com.google.cloud.vision.v1p2beta1.Likelihood.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Blurred likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood blurred_likelihood = 14;</code>
     *
     * @param value The blurredLikelihood to set.
     * @return This builder for chaining.
     */
    public Builder setBlurredLikelihood(com.google.cloud.vision.v1p2beta1.Likelihood value) {
      if (value == null) {
        throw new NullPointerException();
      }

      blurredLikelihood_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Blurred likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood blurred_likelihood = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBlurredLikelihood() {

      blurredLikelihood_ = 0;
      onChanged();
      return this;
    }

    private int headwearLikelihood_ = 0;
    /**
     *
     *
     * <pre>
     * Headwear likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood headwear_likelihood = 15;</code>
     *
     * @return The enum numeric value on the wire for headwearLikelihood.
     */
    @java.lang.Override
    public int getHeadwearLikelihoodValue() {
      return headwearLikelihood_;
    }
    /**
     *
     *
     * <pre>
     * Headwear likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood headwear_likelihood = 15;</code>
     *
     * @param value The enum numeric value on the wire for headwearLikelihood to set.
     * @return This builder for chaining.
     */
    public Builder setHeadwearLikelihoodValue(int value) {

      headwearLikelihood_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headwear likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood headwear_likelihood = 15;</code>
     *
     * @return The headwearLikelihood.
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.Likelihood getHeadwearLikelihood() {
      @SuppressWarnings("deprecation")
      com.google.cloud.vision.v1p2beta1.Likelihood result =
          com.google.cloud.vision.v1p2beta1.Likelihood.valueOf(headwearLikelihood_);
      return result == null ? com.google.cloud.vision.v1p2beta1.Likelihood.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Headwear likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood headwear_likelihood = 15;</code>
     *
     * @param value The headwearLikelihood to set.
     * @return This builder for chaining.
     */
    public Builder setHeadwearLikelihood(com.google.cloud.vision.v1p2beta1.Likelihood value) {
      if (value == null) {
        throw new NullPointerException();
      }

      headwearLikelihood_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headwear likelihood.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.Likelihood headwear_likelihood = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHeadwearLikelihood() {

      headwearLikelihood_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p2beta1.FaceAnnotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p2beta1.FaceAnnotation)
  private static final com.google.cloud.vision.v1p2beta1.FaceAnnotation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1p2beta1.FaceAnnotation();
  }

  public static com.google.cloud.vision.v1p2beta1.FaceAnnotation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FaceAnnotation> PARSER =
      new com.google.protobuf.AbstractParser<FaceAnnotation>() {
        @java.lang.Override
        public FaceAnnotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new FaceAnnotation(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<FaceAnnotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FaceAnnotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.FaceAnnotation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
