/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1p2beta1/web_detection.proto

package com.google.cloud.vision.v1p2beta1;

/**
 *
 *
 * <pre>
 * Relevant information for the image from the Internet.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1p2beta1.WebDetection}
 */
public final class WebDetection extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p2beta1.WebDetection)
    WebDetectionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WebDetection.newBuilder() to construct.
  private WebDetection(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WebDetection() {
    webEntities_ = java.util.Collections.emptyList();
    fullMatchingImages_ = java.util.Collections.emptyList();
    partialMatchingImages_ = java.util.Collections.emptyList();
    pagesWithMatchingImages_ = java.util.Collections.emptyList();
    visuallySimilarImages_ = java.util.Collections.emptyList();
    bestGuessLabels_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WebDetection();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1p2beta1.WebDetectionProto
        .internal_static_google_cloud_vision_v1p2beta1_WebDetection_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1p2beta1.WebDetectionProto
        .internal_static_google_cloud_vision_v1p2beta1_WebDetection_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1p2beta1.WebDetection.class,
            com.google.cloud.vision.v1p2beta1.WebDetection.Builder.class);
  }

  public interface WebEntityOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.vision.v1p2beta1.WebDetection.WebEntity)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Opaque entity ID.
     * </pre>
     *
     * <code>string entity_id = 1;</code>
     *
     * @return The entityId.
     */
    java.lang.String getEntityId();
    /**
     *
     *
     * <pre>
     * Opaque entity ID.
     * </pre>
     *
     * <code>string entity_id = 1;</code>
     *
     * @return The bytes for entityId.
     */
    com.google.protobuf.ByteString getEntityIdBytes();

    /**
     *
     *
     * <pre>
     * Overall relevancy score for the entity.
     * Not normalized and not comparable across different image queries.
     * </pre>
     *
     * <code>float score = 2;</code>
     *
     * @return The score.
     */
    float getScore();

    /**
     *
     *
     * <pre>
     * Canonical description of the entity, in English.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * Canonical description of the entity, in English.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();
  }
  /**
   *
   *
   * <pre>
   * Entity deduced from similar images on the Internet.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p2beta1.WebDetection.WebEntity}
   */
  public static final class WebEntity extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p2beta1.WebDetection.WebEntity)
      WebEntityOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use WebEntity.newBuilder() to construct.
    private WebEntity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WebEntity() {
      entityId_ = "";
      description_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WebEntity();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p2beta1.WebDetectionProto
          .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebEntity_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p2beta1.WebDetectionProto
          .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebEntity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.class,
              com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.Builder.class);
    }

    public static final int ENTITY_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object entityId_;
    /**
     *
     *
     * <pre>
     * Opaque entity ID.
     * </pre>
     *
     * <code>string entity_id = 1;</code>
     *
     * @return The entityId.
     */
    @java.lang.Override
    public java.lang.String getEntityId() {
      java.lang.Object ref = entityId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entityId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Opaque entity ID.
     * </pre>
     *
     * <code>string entity_id = 1;</code>
     *
     * @return The bytes for entityId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEntityIdBytes() {
      java.lang.Object ref = entityId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entityId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCORE_FIELD_NUMBER = 2;
    private float score_;
    /**
     *
     *
     * <pre>
     * Overall relevancy score for the entity.
     * Not normalized and not comparable across different image queries.
     * </pre>
     *
     * <code>float score = 2;</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public float getScore() {
      return score_;
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 3;
    private volatile java.lang.Object description_;
    /**
     *
     *
     * <pre>
     * Canonical description of the entity, in English.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Canonical description of the entity, in English.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, entityId_);
      }
      if (java.lang.Float.floatToRawIntBits(score_) != 0) {
        output.writeFloat(2, score_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entityId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, entityId_);
      }
      if (java.lang.Float.floatToRawIntBits(score_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, score_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity)) {
        return super.equals(obj);
      }
      com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity other =
          (com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity) obj;

      if (!getEntityId().equals(other.getEntityId())) return false;
      if (java.lang.Float.floatToIntBits(getScore())
          != java.lang.Float.floatToIntBits(other.getScore())) return false;
      if (!getDescription().equals(other.getDescription())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENTITY_ID_FIELD_NUMBER;
      hash = (53 * hash) + getEntityId().hashCode();
      hash = (37 * hash) + SCORE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getScore());
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Entity deduced from similar images on the Internet.
     * </pre>
     *
     * Protobuf type {@code google.cloud.vision.v1p2beta1.WebDetection.WebEntity}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p2beta1.WebDetection.WebEntity)
        com.google.cloud.vision.v1p2beta1.WebDetection.WebEntityOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.vision.v1p2beta1.WebDetectionProto
            .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebEntity_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.vision.v1p2beta1.WebDetectionProto
            .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebEntity_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.class,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.Builder.class);
      }

      // Construct using com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        entityId_ = "";

        score_ = 0F;

        description_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.vision.v1p2beta1.WebDetectionProto
            .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebEntity_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity getDefaultInstanceForType() {
        return com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity build() {
        com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity buildPartial() {
        com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity result =
            new com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity(this);
        result.entityId_ = entityId_;
        result.score_ = score_;
        result.description_ = description_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity) {
          return mergeFrom((com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity other) {
        if (other == com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.getDefaultInstance())
          return this;
        if (!other.getEntityId().isEmpty()) {
          entityId_ = other.entityId_;
          onChanged();
        }
        if (other.getScore() != 0F) {
          setScore(other.getScore());
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  entityId_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 21:
                {
                  score_ = input.readFloat();

                  break;
                } // case 21
              case 26:
                {
                  description_ = input.readStringRequireUtf8();

                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object entityId_ = "";
      /**
       *
       *
       * <pre>
       * Opaque entity ID.
       * </pre>
       *
       * <code>string entity_id = 1;</code>
       *
       * @return The entityId.
       */
      public java.lang.String getEntityId() {
        java.lang.Object ref = entityId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          entityId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Opaque entity ID.
       * </pre>
       *
       * <code>string entity_id = 1;</code>
       *
       * @return The bytes for entityId.
       */
      public com.google.protobuf.ByteString getEntityIdBytes() {
        java.lang.Object ref = entityId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          entityId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Opaque entity ID.
       * </pre>
       *
       * <code>string entity_id = 1;</code>
       *
       * @param value The entityId to set.
       * @return This builder for chaining.
       */
      public Builder setEntityId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        entityId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Opaque entity ID.
       * </pre>
       *
       * <code>string entity_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEntityId() {

        entityId_ = getDefaultInstance().getEntityId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Opaque entity ID.
       * </pre>
       *
       * <code>string entity_id = 1;</code>
       *
       * @param value The bytes for entityId to set.
       * @return This builder for chaining.
       */
      public Builder setEntityIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        entityId_ = value;
        onChanged();
        return this;
      }

      private float score_;
      /**
       *
       *
       * <pre>
       * Overall relevancy score for the entity.
       * Not normalized and not comparable across different image queries.
       * </pre>
       *
       * <code>float score = 2;</code>
       *
       * @return The score.
       */
      @java.lang.Override
      public float getScore() {
        return score_;
      }
      /**
       *
       *
       * <pre>
       * Overall relevancy score for the entity.
       * Not normalized and not comparable across different image queries.
       * </pre>
       *
       * <code>float score = 2;</code>
       *
       * @param value The score to set.
       * @return This builder for chaining.
       */
      public Builder setScore(float value) {

        score_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Overall relevancy score for the entity.
       * Not normalized and not comparable across different image queries.
       * </pre>
       *
       * <code>float score = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearScore() {

        score_ = 0F;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * Canonical description of the entity, in English.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Canonical description of the entity, in English.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Canonical description of the entity, in English.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        description_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Canonical description of the entity, in English.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {

        description_ = getDefaultInstance().getDescription();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Canonical description of the entity, in English.
       * </pre>
       *
       * <code>string description = 3;</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        description_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p2beta1.WebDetection.WebEntity)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p2beta1.WebDetection.WebEntity)
    private static final com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity();
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WebEntity> PARSER =
        new com.google.protobuf.AbstractParser<WebEntity>() {
          @java.lang.Override
          public WebEntity parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<WebEntity> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WebEntity> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface WebImageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.vision.v1p2beta1.WebDetection.WebImage)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The result image URL.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The url.
     */
    java.lang.String getUrl();
    /**
     *
     *
     * <pre>
     * The result image URL.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The bytes for url.
     */
    com.google.protobuf.ByteString getUrlBytes();

    /**
     *
     *
     * <pre>
     * (Deprecated) Overall relevancy score for the image.
     * </pre>
     *
     * <code>float score = 2;</code>
     *
     * @return The score.
     */
    float getScore();
  }
  /**
   *
   *
   * <pre>
   * Metadata for online images.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p2beta1.WebDetection.WebImage}
   */
  public static final class WebImage extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p2beta1.WebDetection.WebImage)
      WebImageOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use WebImage.newBuilder() to construct.
    private WebImage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WebImage() {
      url_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WebImage();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p2beta1.WebDetectionProto
          .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebImage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p2beta1.WebDetectionProto
          .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebImage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.class,
              com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder.class);
    }

    public static final int URL_FIELD_NUMBER = 1;
    private volatile java.lang.Object url_;
    /**
     *
     *
     * <pre>
     * The result image URL.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The url.
     */
    @java.lang.Override
    public java.lang.String getUrl() {
      java.lang.Object ref = url_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        url_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The result image URL.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The bytes for url.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUrlBytes() {
      java.lang.Object ref = url_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        url_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCORE_FIELD_NUMBER = 2;
    private float score_;
    /**
     *
     *
     * <pre>
     * (Deprecated) Overall relevancy score for the image.
     * </pre>
     *
     * <code>float score = 2;</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public float getScore() {
      return score_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, url_);
      }
      if (java.lang.Float.floatToRawIntBits(score_) != 0) {
        output.writeFloat(2, score_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, url_);
      }
      if (java.lang.Float.floatToRawIntBits(score_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, score_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.vision.v1p2beta1.WebDetection.WebImage)) {
        return super.equals(obj);
      }
      com.google.cloud.vision.v1p2beta1.WebDetection.WebImage other =
          (com.google.cloud.vision.v1p2beta1.WebDetection.WebImage) obj;

      if (!getUrl().equals(other.getUrl())) return false;
      if (java.lang.Float.floatToIntBits(getScore())
          != java.lang.Float.floatToIntBits(other.getScore())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + URL_FIELD_NUMBER;
      hash = (53 * hash) + getUrl().hashCode();
      hash = (37 * hash) + SCORE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getScore());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebImage parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebImage parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebImage parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebImage parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebImage parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebImage parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebImage parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebImage parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebImage parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebImage parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebImage parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebImage parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Metadata for online images.
     * </pre>
     *
     * Protobuf type {@code google.cloud.vision.v1p2beta1.WebDetection.WebImage}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p2beta1.WebDetection.WebImage)
        com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.vision.v1p2beta1.WebDetectionProto
            .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebImage_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.vision.v1p2beta1.WebDetectionProto
            .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebImage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.class,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder.class);
      }

      // Construct using com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        url_ = "";

        score_ = 0F;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.vision.v1p2beta1.WebDetectionProto
            .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebImage_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage getDefaultInstanceForType() {
        return com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage build() {
        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage buildPartial() {
        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage result =
            new com.google.cloud.vision.v1p2beta1.WebDetection.WebImage(this);
        result.url_ = url_;
        result.score_ = score_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.vision.v1p2beta1.WebDetection.WebImage) {
          return mergeFrom((com.google.cloud.vision.v1p2beta1.WebDetection.WebImage) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.vision.v1p2beta1.WebDetection.WebImage other) {
        if (other == com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.getDefaultInstance())
          return this;
        if (!other.getUrl().isEmpty()) {
          url_ = other.url_;
          onChanged();
        }
        if (other.getScore() != 0F) {
          setScore(other.getScore());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  url_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 21:
                {
                  score_ = input.readFloat();

                  break;
                } // case 21
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object url_ = "";
      /**
       *
       *
       * <pre>
       * The result image URL.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @return The url.
       */
      public java.lang.String getUrl() {
        java.lang.Object ref = url_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          url_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The result image URL.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @return The bytes for url.
       */
      public com.google.protobuf.ByteString getUrlBytes() {
        java.lang.Object ref = url_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          url_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The result image URL.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @param value The url to set.
       * @return This builder for chaining.
       */
      public Builder setUrl(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        url_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The result image URL.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUrl() {

        url_ = getDefaultInstance().getUrl();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The result image URL.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @param value The bytes for url to set.
       * @return This builder for chaining.
       */
      public Builder setUrlBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        url_ = value;
        onChanged();
        return this;
      }

      private float score_;
      /**
       *
       *
       * <pre>
       * (Deprecated) Overall relevancy score for the image.
       * </pre>
       *
       * <code>float score = 2;</code>
       *
       * @return The score.
       */
      @java.lang.Override
      public float getScore() {
        return score_;
      }
      /**
       *
       *
       * <pre>
       * (Deprecated) Overall relevancy score for the image.
       * </pre>
       *
       * <code>float score = 2;</code>
       *
       * @param value The score to set.
       * @return This builder for chaining.
       */
      public Builder setScore(float value) {

        score_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Deprecated) Overall relevancy score for the image.
       * </pre>
       *
       * <code>float score = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearScore() {

        score_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p2beta1.WebDetection.WebImage)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p2beta1.WebDetection.WebImage)
    private static final com.google.cloud.vision.v1p2beta1.WebDetection.WebImage DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.vision.v1p2beta1.WebDetection.WebImage();
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebImage getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WebImage> PARSER =
        new com.google.protobuf.AbstractParser<WebImage>() {
          @java.lang.Override
          public WebImage parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<WebImage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WebImage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface WebPageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.vision.v1p2beta1.WebDetection.WebPage)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The result web page URL.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The url.
     */
    java.lang.String getUrl();
    /**
     *
     *
     * <pre>
     * The result web page URL.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The bytes for url.
     */
    com.google.protobuf.ByteString getUrlBytes();

    /**
     *
     *
     * <pre>
     * (Deprecated) Overall relevancy score for the web page.
     * </pre>
     *
     * <code>float score = 2;</code>
     *
     * @return The score.
     */
    float getScore();

    /**
     *
     *
     * <pre>
     * Title for the web page, may contain HTML markups.
     * </pre>
     *
     * <code>string page_title = 3;</code>
     *
     * @return The pageTitle.
     */
    java.lang.String getPageTitle();
    /**
     *
     *
     * <pre>
     * Title for the web page, may contain HTML markups.
     * </pre>
     *
     * <code>string page_title = 3;</code>
     *
     * @return The bytes for pageTitle.
     */
    com.google.protobuf.ByteString getPageTitleBytes();

    /**
     *
     *
     * <pre>
     * Fully matching images on the page.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
     * </code>
     */
    java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
        getFullMatchingImagesList();
    /**
     *
     *
     * <pre>
     * Fully matching images on the page.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
     * </code>
     */
    com.google.cloud.vision.v1p2beta1.WebDetection.WebImage getFullMatchingImages(int index);
    /**
     *
     *
     * <pre>
     * Fully matching images on the page.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
     * </code>
     */
    int getFullMatchingImagesCount();
    /**
     *
     *
     * <pre>
     * Fully matching images on the page.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
     * </code>
     */
    java.util.List<? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
        getFullMatchingImagesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Fully matching images on the page.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
     * </code>
     */
    com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder getFullMatchingImagesOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Partial matching images on the page.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its
     * crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
     * </code>
     */
    java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
        getPartialMatchingImagesList();
    /**
     *
     *
     * <pre>
     * Partial matching images on the page.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its
     * crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
     * </code>
     */
    com.google.cloud.vision.v1p2beta1.WebDetection.WebImage getPartialMatchingImages(int index);
    /**
     *
     *
     * <pre>
     * Partial matching images on the page.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its
     * crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
     * </code>
     */
    int getPartialMatchingImagesCount();
    /**
     *
     *
     * <pre>
     * Partial matching images on the page.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its
     * crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
     * </code>
     */
    java.util.List<? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
        getPartialMatchingImagesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Partial matching images on the page.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its
     * crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
     * </code>
     */
    com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder
        getPartialMatchingImagesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Metadata for web pages.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p2beta1.WebDetection.WebPage}
   */
  public static final class WebPage extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p2beta1.WebDetection.WebPage)
      WebPageOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use WebPage.newBuilder() to construct.
    private WebPage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WebPage() {
      url_ = "";
      pageTitle_ = "";
      fullMatchingImages_ = java.util.Collections.emptyList();
      partialMatchingImages_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WebPage();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p2beta1.WebDetectionProto
          .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebPage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p2beta1.WebDetectionProto
          .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebPage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.class,
              com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.Builder.class);
    }

    public static final int URL_FIELD_NUMBER = 1;
    private volatile java.lang.Object url_;
    /**
     *
     *
     * <pre>
     * The result web page URL.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The url.
     */
    @java.lang.Override
    public java.lang.String getUrl() {
      java.lang.Object ref = url_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        url_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The result web page URL.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The bytes for url.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUrlBytes() {
      java.lang.Object ref = url_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        url_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCORE_FIELD_NUMBER = 2;
    private float score_;
    /**
     *
     *
     * <pre>
     * (Deprecated) Overall relevancy score for the web page.
     * </pre>
     *
     * <code>float score = 2;</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public float getScore() {
      return score_;
    }

    public static final int PAGE_TITLE_FIELD_NUMBER = 3;
    private volatile java.lang.Object pageTitle_;
    /**
     *
     *
     * <pre>
     * Title for the web page, may contain HTML markups.
     * </pre>
     *
     * <code>string page_title = 3;</code>
     *
     * @return The pageTitle.
     */
    @java.lang.Override
    public java.lang.String getPageTitle() {
      java.lang.Object ref = pageTitle_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageTitle_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Title for the web page, may contain HTML markups.
     * </pre>
     *
     * <code>string page_title = 3;</code>
     *
     * @return The bytes for pageTitle.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPageTitleBytes() {
      java.lang.Object ref = pageTitle_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageTitle_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FULL_MATCHING_IMAGES_FIELD_NUMBER = 4;
    private java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
        fullMatchingImages_;
    /**
     *
     *
     * <pre>
     * Fully matching images on the page.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
        getFullMatchingImagesList() {
      return fullMatchingImages_;
    }
    /**
     *
     *
     * <pre>
     * Fully matching images on the page.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
        getFullMatchingImagesOrBuilderList() {
      return fullMatchingImages_;
    }
    /**
     *
     *
     * <pre>
     * Fully matching images on the page.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
     * </code>
     */
    @java.lang.Override
    public int getFullMatchingImagesCount() {
      return fullMatchingImages_.size();
    }
    /**
     *
     *
     * <pre>
     * Fully matching images on the page.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage getFullMatchingImages(
        int index) {
      return fullMatchingImages_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Fully matching images on the page.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder
        getFullMatchingImagesOrBuilder(int index) {
      return fullMatchingImages_.get(index);
    }

    public static final int PARTIAL_MATCHING_IMAGES_FIELD_NUMBER = 5;
    private java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
        partialMatchingImages_;
    /**
     *
     *
     * <pre>
     * Partial matching images on the page.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its
     * crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
        getPartialMatchingImagesList() {
      return partialMatchingImages_;
    }
    /**
     *
     *
     * <pre>
     * Partial matching images on the page.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its
     * crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
        getPartialMatchingImagesOrBuilderList() {
      return partialMatchingImages_;
    }
    /**
     *
     *
     * <pre>
     * Partial matching images on the page.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its
     * crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
     * </code>
     */
    @java.lang.Override
    public int getPartialMatchingImagesCount() {
      return partialMatchingImages_.size();
    }
    /**
     *
     *
     * <pre>
     * Partial matching images on the page.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its
     * crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage getPartialMatchingImages(
        int index) {
      return partialMatchingImages_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Partial matching images on the page.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its
     * crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder
        getPartialMatchingImagesOrBuilder(int index) {
      return partialMatchingImages_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, url_);
      }
      if (java.lang.Float.floatToRawIntBits(score_) != 0) {
        output.writeFloat(2, score_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageTitle_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageTitle_);
      }
      for (int i = 0; i < fullMatchingImages_.size(); i++) {
        output.writeMessage(4, fullMatchingImages_.get(i));
      }
      for (int i = 0; i < partialMatchingImages_.size(); i++) {
        output.writeMessage(5, partialMatchingImages_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, url_);
      }
      if (java.lang.Float.floatToRawIntBits(score_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, score_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageTitle_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageTitle_);
      }
      for (int i = 0; i < fullMatchingImages_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(4, fullMatchingImages_.get(i));
      }
      for (int i = 0; i < partialMatchingImages_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, partialMatchingImages_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.vision.v1p2beta1.WebDetection.WebPage)) {
        return super.equals(obj);
      }
      com.google.cloud.vision.v1p2beta1.WebDetection.WebPage other =
          (com.google.cloud.vision.v1p2beta1.WebDetection.WebPage) obj;

      if (!getUrl().equals(other.getUrl())) return false;
      if (java.lang.Float.floatToIntBits(getScore())
          != java.lang.Float.floatToIntBits(other.getScore())) return false;
      if (!getPageTitle().equals(other.getPageTitle())) return false;
      if (!getFullMatchingImagesList().equals(other.getFullMatchingImagesList())) return false;
      if (!getPartialMatchingImagesList().equals(other.getPartialMatchingImagesList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + URL_FIELD_NUMBER;
      hash = (53 * hash) + getUrl().hashCode();
      hash = (37 * hash) + SCORE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getScore());
      hash = (37 * hash) + PAGE_TITLE_FIELD_NUMBER;
      hash = (53 * hash) + getPageTitle().hashCode();
      if (getFullMatchingImagesCount() > 0) {
        hash = (37 * hash) + FULL_MATCHING_IMAGES_FIELD_NUMBER;
        hash = (53 * hash) + getFullMatchingImagesList().hashCode();
      }
      if (getPartialMatchingImagesCount() > 0) {
        hash = (37 * hash) + PARTIAL_MATCHING_IMAGES_FIELD_NUMBER;
        hash = (53 * hash) + getPartialMatchingImagesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebPage parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebPage parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebPage parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebPage parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebPage parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebPage parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebPage parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebPage parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebPage parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebPage parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebPage parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebPage parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.vision.v1p2beta1.WebDetection.WebPage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Metadata for web pages.
     * </pre>
     *
     * Protobuf type {@code google.cloud.vision.v1p2beta1.WebDetection.WebPage}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p2beta1.WebDetection.WebPage)
        com.google.cloud.vision.v1p2beta1.WebDetection.WebPageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.vision.v1p2beta1.WebDetectionProto
            .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebPage_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.vision.v1p2beta1.WebDetectionProto
            .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebPage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.class,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.Builder.class);
      }

      // Construct using com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        url_ = "";

        score_ = 0F;

        pageTitle_ = "";

        if (fullMatchingImagesBuilder_ == null) {
          fullMatchingImages_ = java.util.Collections.emptyList();
        } else {
          fullMatchingImages_ = null;
          fullMatchingImagesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (partialMatchingImagesBuilder_ == null) {
          partialMatchingImages_ = java.util.Collections.emptyList();
        } else {
          partialMatchingImages_ = null;
          partialMatchingImagesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.vision.v1p2beta1.WebDetectionProto
            .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebPage_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebPage getDefaultInstanceForType() {
        return com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebPage build() {
        com.google.cloud.vision.v1p2beta1.WebDetection.WebPage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebPage buildPartial() {
        com.google.cloud.vision.v1p2beta1.WebDetection.WebPage result =
            new com.google.cloud.vision.v1p2beta1.WebDetection.WebPage(this);
        int from_bitField0_ = bitField0_;
        result.url_ = url_;
        result.score_ = score_;
        result.pageTitle_ = pageTitle_;
        if (fullMatchingImagesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            fullMatchingImages_ = java.util.Collections.unmodifiableList(fullMatchingImages_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.fullMatchingImages_ = fullMatchingImages_;
        } else {
          result.fullMatchingImages_ = fullMatchingImagesBuilder_.build();
        }
        if (partialMatchingImagesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            partialMatchingImages_ = java.util.Collections.unmodifiableList(partialMatchingImages_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.partialMatchingImages_ = partialMatchingImages_;
        } else {
          result.partialMatchingImages_ = partialMatchingImagesBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.vision.v1p2beta1.WebDetection.WebPage) {
          return mergeFrom((com.google.cloud.vision.v1p2beta1.WebDetection.WebPage) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.vision.v1p2beta1.WebDetection.WebPage other) {
        if (other == com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.getDefaultInstance())
          return this;
        if (!other.getUrl().isEmpty()) {
          url_ = other.url_;
          onChanged();
        }
        if (other.getScore() != 0F) {
          setScore(other.getScore());
        }
        if (!other.getPageTitle().isEmpty()) {
          pageTitle_ = other.pageTitle_;
          onChanged();
        }
        if (fullMatchingImagesBuilder_ == null) {
          if (!other.fullMatchingImages_.isEmpty()) {
            if (fullMatchingImages_.isEmpty()) {
              fullMatchingImages_ = other.fullMatchingImages_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFullMatchingImagesIsMutable();
              fullMatchingImages_.addAll(other.fullMatchingImages_);
            }
            onChanged();
          }
        } else {
          if (!other.fullMatchingImages_.isEmpty()) {
            if (fullMatchingImagesBuilder_.isEmpty()) {
              fullMatchingImagesBuilder_.dispose();
              fullMatchingImagesBuilder_ = null;
              fullMatchingImages_ = other.fullMatchingImages_;
              bitField0_ = (bitField0_ & ~0x00000001);
              fullMatchingImagesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getFullMatchingImagesFieldBuilder()
                      : null;
            } else {
              fullMatchingImagesBuilder_.addAllMessages(other.fullMatchingImages_);
            }
          }
        }
        if (partialMatchingImagesBuilder_ == null) {
          if (!other.partialMatchingImages_.isEmpty()) {
            if (partialMatchingImages_.isEmpty()) {
              partialMatchingImages_ = other.partialMatchingImages_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensurePartialMatchingImagesIsMutable();
              partialMatchingImages_.addAll(other.partialMatchingImages_);
            }
            onChanged();
          }
        } else {
          if (!other.partialMatchingImages_.isEmpty()) {
            if (partialMatchingImagesBuilder_.isEmpty()) {
              partialMatchingImagesBuilder_.dispose();
              partialMatchingImagesBuilder_ = null;
              partialMatchingImages_ = other.partialMatchingImages_;
              bitField0_ = (bitField0_ & ~0x00000002);
              partialMatchingImagesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPartialMatchingImagesFieldBuilder()
                      : null;
            } else {
              partialMatchingImagesBuilder_.addAllMessages(other.partialMatchingImages_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  url_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 21:
                {
                  score_ = input.readFloat();

                  break;
                } // case 21
              case 26:
                {
                  pageTitle_ = input.readStringRequireUtf8();

                  break;
                } // case 26
              case 34:
                {
                  com.google.cloud.vision.v1p2beta1.WebDetection.WebImage m =
                      input.readMessage(
                          com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.parser(),
                          extensionRegistry);
                  if (fullMatchingImagesBuilder_ == null) {
                    ensureFullMatchingImagesIsMutable();
                    fullMatchingImages_.add(m);
                  } else {
                    fullMatchingImagesBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
              case 42:
                {
                  com.google.cloud.vision.v1p2beta1.WebDetection.WebImage m =
                      input.readMessage(
                          com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.parser(),
                          extensionRegistry);
                  if (partialMatchingImagesBuilder_ == null) {
                    ensurePartialMatchingImagesIsMutable();
                    partialMatchingImages_.add(m);
                  } else {
                    partialMatchingImagesBuilder_.addMessage(m);
                  }
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object url_ = "";
      /**
       *
       *
       * <pre>
       * The result web page URL.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @return The url.
       */
      public java.lang.String getUrl() {
        java.lang.Object ref = url_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          url_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The result web page URL.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @return The bytes for url.
       */
      public com.google.protobuf.ByteString getUrlBytes() {
        java.lang.Object ref = url_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          url_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The result web page URL.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @param value The url to set.
       * @return This builder for chaining.
       */
      public Builder setUrl(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        url_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The result web page URL.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUrl() {

        url_ = getDefaultInstance().getUrl();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The result web page URL.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @param value The bytes for url to set.
       * @return This builder for chaining.
       */
      public Builder setUrlBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        url_ = value;
        onChanged();
        return this;
      }

      private float score_;
      /**
       *
       *
       * <pre>
       * (Deprecated) Overall relevancy score for the web page.
       * </pre>
       *
       * <code>float score = 2;</code>
       *
       * @return The score.
       */
      @java.lang.Override
      public float getScore() {
        return score_;
      }
      /**
       *
       *
       * <pre>
       * (Deprecated) Overall relevancy score for the web page.
       * </pre>
       *
       * <code>float score = 2;</code>
       *
       * @param value The score to set.
       * @return This builder for chaining.
       */
      public Builder setScore(float value) {

        score_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * (Deprecated) Overall relevancy score for the web page.
       * </pre>
       *
       * <code>float score = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearScore() {

        score_ = 0F;
        onChanged();
        return this;
      }

      private java.lang.Object pageTitle_ = "";
      /**
       *
       *
       * <pre>
       * Title for the web page, may contain HTML markups.
       * </pre>
       *
       * <code>string page_title = 3;</code>
       *
       * @return The pageTitle.
       */
      public java.lang.String getPageTitle() {
        java.lang.Object ref = pageTitle_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pageTitle_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Title for the web page, may contain HTML markups.
       * </pre>
       *
       * <code>string page_title = 3;</code>
       *
       * @return The bytes for pageTitle.
       */
      public com.google.protobuf.ByteString getPageTitleBytes() {
        java.lang.Object ref = pageTitle_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pageTitle_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Title for the web page, may contain HTML markups.
       * </pre>
       *
       * <code>string page_title = 3;</code>
       *
       * @param value The pageTitle to set.
       * @return This builder for chaining.
       */
      public Builder setPageTitle(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        pageTitle_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Title for the web page, may contain HTML markups.
       * </pre>
       *
       * <code>string page_title = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageTitle() {

        pageTitle_ = getDefaultInstance().getPageTitle();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Title for the web page, may contain HTML markups.
       * </pre>
       *
       * <code>string page_title = 3;</code>
       *
       * @param value The bytes for pageTitle to set.
       * @return This builder for chaining.
       */
      public Builder setPageTitleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        pageTitle_ = value;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
          fullMatchingImages_ = java.util.Collections.emptyList();

      private void ensureFullMatchingImagesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          fullMatchingImages_ =
              new java.util.ArrayList<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>(
                  fullMatchingImages_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vision.v1p2beta1.WebDetection.WebImage,
              com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder,
              com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
          fullMatchingImagesBuilder_;

      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
          getFullMatchingImagesList() {
        if (fullMatchingImagesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(fullMatchingImages_);
        } else {
          return fullMatchingImagesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public int getFullMatchingImagesCount() {
        if (fullMatchingImagesBuilder_ == null) {
          return fullMatchingImages_.size();
        } else {
          return fullMatchingImagesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage getFullMatchingImages(
          int index) {
        if (fullMatchingImagesBuilder_ == null) {
          return fullMatchingImages_.get(index);
        } else {
          return fullMatchingImagesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public Builder setFullMatchingImages(
          int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebImage value) {
        if (fullMatchingImagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFullMatchingImagesIsMutable();
          fullMatchingImages_.set(index, value);
          onChanged();
        } else {
          fullMatchingImagesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public Builder setFullMatchingImages(
          int index,
          com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder builderForValue) {
        if (fullMatchingImagesBuilder_ == null) {
          ensureFullMatchingImagesIsMutable();
          fullMatchingImages_.set(index, builderForValue.build());
          onChanged();
        } else {
          fullMatchingImagesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public Builder addFullMatchingImages(
          com.google.cloud.vision.v1p2beta1.WebDetection.WebImage value) {
        if (fullMatchingImagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFullMatchingImagesIsMutable();
          fullMatchingImages_.add(value);
          onChanged();
        } else {
          fullMatchingImagesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public Builder addFullMatchingImages(
          int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebImage value) {
        if (fullMatchingImagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFullMatchingImagesIsMutable();
          fullMatchingImages_.add(index, value);
          onChanged();
        } else {
          fullMatchingImagesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public Builder addFullMatchingImages(
          com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder builderForValue) {
        if (fullMatchingImagesBuilder_ == null) {
          ensureFullMatchingImagesIsMutable();
          fullMatchingImages_.add(builderForValue.build());
          onChanged();
        } else {
          fullMatchingImagesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public Builder addFullMatchingImages(
          int index,
          com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder builderForValue) {
        if (fullMatchingImagesBuilder_ == null) {
          ensureFullMatchingImagesIsMutable();
          fullMatchingImages_.add(index, builderForValue.build());
          onChanged();
        } else {
          fullMatchingImagesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public Builder addAllFullMatchingImages(
          java.lang.Iterable<? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
              values) {
        if (fullMatchingImagesBuilder_ == null) {
          ensureFullMatchingImagesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fullMatchingImages_);
          onChanged();
        } else {
          fullMatchingImagesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public Builder clearFullMatchingImages() {
        if (fullMatchingImagesBuilder_ == null) {
          fullMatchingImages_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          fullMatchingImagesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public Builder removeFullMatchingImages(int index) {
        if (fullMatchingImagesBuilder_ == null) {
          ensureFullMatchingImagesIsMutable();
          fullMatchingImages_.remove(index);
          onChanged();
        } else {
          fullMatchingImagesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder
          getFullMatchingImagesBuilder(int index) {
        return getFullMatchingImagesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder
          getFullMatchingImagesOrBuilder(int index) {
        if (fullMatchingImagesBuilder_ == null) {
          return fullMatchingImages_.get(index);
        } else {
          return fullMatchingImagesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
          getFullMatchingImagesOrBuilderList() {
        if (fullMatchingImagesBuilder_ != null) {
          return fullMatchingImagesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(fullMatchingImages_);
        }
      }
      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder
          addFullMatchingImagesBuilder() {
        return getFullMatchingImagesFieldBuilder()
            .addBuilder(
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder
          addFullMatchingImagesBuilder(int index) {
        return getFullMatchingImagesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Fully matching images on the page.
       * Can include resized copies of the query image.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 4;
       * </code>
       */
      public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder>
          getFullMatchingImagesBuilderList() {
        return getFullMatchingImagesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vision.v1p2beta1.WebDetection.WebImage,
              com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder,
              com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
          getFullMatchingImagesFieldBuilder() {
        if (fullMatchingImagesBuilder_ == null) {
          fullMatchingImagesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.vision.v1p2beta1.WebDetection.WebImage,
                  com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder,
                  com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>(
                  fullMatchingImages_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          fullMatchingImages_ = null;
        }
        return fullMatchingImagesBuilder_;
      }

      private java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
          partialMatchingImages_ = java.util.Collections.emptyList();

      private void ensurePartialMatchingImagesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          partialMatchingImages_ =
              new java.util.ArrayList<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>(
                  partialMatchingImages_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vision.v1p2beta1.WebDetection.WebImage,
              com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder,
              com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
          partialMatchingImagesBuilder_;

      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
          getPartialMatchingImagesList() {
        if (partialMatchingImagesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(partialMatchingImages_);
        } else {
          return partialMatchingImagesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public int getPartialMatchingImagesCount() {
        if (partialMatchingImagesBuilder_ == null) {
          return partialMatchingImages_.size();
        } else {
          return partialMatchingImagesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage getPartialMatchingImages(
          int index) {
        if (partialMatchingImagesBuilder_ == null) {
          return partialMatchingImages_.get(index);
        } else {
          return partialMatchingImagesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public Builder setPartialMatchingImages(
          int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebImage value) {
        if (partialMatchingImagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePartialMatchingImagesIsMutable();
          partialMatchingImages_.set(index, value);
          onChanged();
        } else {
          partialMatchingImagesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public Builder setPartialMatchingImages(
          int index,
          com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder builderForValue) {
        if (partialMatchingImagesBuilder_ == null) {
          ensurePartialMatchingImagesIsMutable();
          partialMatchingImages_.set(index, builderForValue.build());
          onChanged();
        } else {
          partialMatchingImagesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public Builder addPartialMatchingImages(
          com.google.cloud.vision.v1p2beta1.WebDetection.WebImage value) {
        if (partialMatchingImagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePartialMatchingImagesIsMutable();
          partialMatchingImages_.add(value);
          onChanged();
        } else {
          partialMatchingImagesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public Builder addPartialMatchingImages(
          int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebImage value) {
        if (partialMatchingImagesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePartialMatchingImagesIsMutable();
          partialMatchingImages_.add(index, value);
          onChanged();
        } else {
          partialMatchingImagesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public Builder addPartialMatchingImages(
          com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder builderForValue) {
        if (partialMatchingImagesBuilder_ == null) {
          ensurePartialMatchingImagesIsMutable();
          partialMatchingImages_.add(builderForValue.build());
          onChanged();
        } else {
          partialMatchingImagesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public Builder addPartialMatchingImages(
          int index,
          com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder builderForValue) {
        if (partialMatchingImagesBuilder_ == null) {
          ensurePartialMatchingImagesIsMutable();
          partialMatchingImages_.add(index, builderForValue.build());
          onChanged();
        } else {
          partialMatchingImagesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public Builder addAllPartialMatchingImages(
          java.lang.Iterable<? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
              values) {
        if (partialMatchingImagesBuilder_ == null) {
          ensurePartialMatchingImagesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partialMatchingImages_);
          onChanged();
        } else {
          partialMatchingImagesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public Builder clearPartialMatchingImages() {
        if (partialMatchingImagesBuilder_ == null) {
          partialMatchingImages_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          partialMatchingImagesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public Builder removePartialMatchingImages(int index) {
        if (partialMatchingImagesBuilder_ == null) {
          ensurePartialMatchingImagesIsMutable();
          partialMatchingImages_.remove(index);
          onChanged();
        } else {
          partialMatchingImagesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder
          getPartialMatchingImagesBuilder(int index) {
        return getPartialMatchingImagesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder
          getPartialMatchingImagesOrBuilder(int index) {
        if (partialMatchingImagesBuilder_ == null) {
          return partialMatchingImages_.get(index);
        } else {
          return partialMatchingImagesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
          getPartialMatchingImagesOrBuilderList() {
        if (partialMatchingImagesBuilder_ != null) {
          return partialMatchingImagesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(partialMatchingImages_);
        }
      }
      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder
          addPartialMatchingImagesBuilder() {
        return getPartialMatchingImagesFieldBuilder()
            .addBuilder(
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder
          addPartialMatchingImagesBuilder(int index) {
        return getPartialMatchingImagesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Partial matching images on the page.
       * Those images are similar enough to share some key-point features. For
       * example an original image will likely have partial matching for its
       * crops.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 5;
       * </code>
       */
      public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder>
          getPartialMatchingImagesBuilderList() {
        return getPartialMatchingImagesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vision.v1p2beta1.WebDetection.WebImage,
              com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder,
              com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
          getPartialMatchingImagesFieldBuilder() {
        if (partialMatchingImagesBuilder_ == null) {
          partialMatchingImagesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.vision.v1p2beta1.WebDetection.WebImage,
                  com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder,
                  com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>(
                  partialMatchingImages_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          partialMatchingImages_ = null;
        }
        return partialMatchingImagesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p2beta1.WebDetection.WebPage)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p2beta1.WebDetection.WebPage)
    private static final com.google.cloud.vision.v1p2beta1.WebDetection.WebPage DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.vision.v1p2beta1.WebDetection.WebPage();
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebPage getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WebPage> PARSER =
        new com.google.protobuf.AbstractParser<WebPage>() {
          @java.lang.Override
          public WebPage parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<WebPage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WebPage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebPage getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface WebLabelOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.vision.v1p2beta1.WebDetection.WebLabel)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Label for extra metadata.
     * </pre>
     *
     * <code>string label = 1;</code>
     *
     * @return The label.
     */
    java.lang.String getLabel();
    /**
     *
     *
     * <pre>
     * Label for extra metadata.
     * </pre>
     *
     * <code>string label = 1;</code>
     *
     * @return The bytes for label.
     */
    com.google.protobuf.ByteString getLabelBytes();

    /**
     *
     *
     * <pre>
     * The BCP-47 language code for `label`, such as "en-US" or "sr-Latn".
     * For more information, see
     * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
     * </pre>
     *
     * <code>string language_code = 2;</code>
     *
     * @return The languageCode.
     */
    java.lang.String getLanguageCode();
    /**
     *
     *
     * <pre>
     * The BCP-47 language code for `label`, such as "en-US" or "sr-Latn".
     * For more information, see
     * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
     * </pre>
     *
     * <code>string language_code = 2;</code>
     *
     * @return The bytes for languageCode.
     */
    com.google.protobuf.ByteString getLanguageCodeBytes();
  }
  /**
   *
   *
   * <pre>
   * Label to provide extra metadata for the web detection.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p2beta1.WebDetection.WebLabel}
   */
  public static final class WebLabel extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p2beta1.WebDetection.WebLabel)
      WebLabelOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use WebLabel.newBuilder() to construct.
    private WebLabel(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WebLabel() {
      label_ = "";
      languageCode_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WebLabel();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p2beta1.WebDetectionProto
          .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebLabel_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p2beta1.WebDetectionProto
          .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebLabel_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.class,
              com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.Builder.class);
    }

    public static final int LABEL_FIELD_NUMBER = 1;
    private volatile java.lang.Object label_;
    /**
     *
     *
     * <pre>
     * Label for extra metadata.
     * </pre>
     *
     * <code>string label = 1;</code>
     *
     * @return The label.
     */
    @java.lang.Override
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Label for extra metadata.
     * </pre>
     *
     * <code>string label = 1;</code>
     *
     * @return The bytes for label.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LANGUAGE_CODE_FIELD_NUMBER = 2;
    private volatile java.lang.Object languageCode_;
    /**
     *
     *
     * <pre>
     * The BCP-47 language code for `label`, such as "en-US" or "sr-Latn".
     * For more information, see
     * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
     * </pre>
     *
     * <code>string language_code = 2;</code>
     *
     * @return The languageCode.
     */
    @java.lang.Override
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The BCP-47 language code for `label`, such as "en-US" or "sr-Latn".
     * For more information, see
     * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
     * </pre>
     *
     * <code>string language_code = 2;</code>
     *
     * @return The bytes for languageCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, label_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, languageCode_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, label_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, languageCode_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel)) {
        return super.equals(obj);
      }
      com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel other =
          (com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel) obj;

      if (!getLabel().equals(other.getLabel())) return false;
      if (!getLanguageCode().equals(other.getLanguageCode())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LABEL_FIELD_NUMBER;
      hash = (53 * hash) + getLabel().hashCode();
      hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getLanguageCode().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Label to provide extra metadata for the web detection.
     * </pre>
     *
     * Protobuf type {@code google.cloud.vision.v1p2beta1.WebDetection.WebLabel}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p2beta1.WebDetection.WebLabel)
        com.google.cloud.vision.v1p2beta1.WebDetection.WebLabelOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.vision.v1p2beta1.WebDetectionProto
            .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebLabel_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.vision.v1p2beta1.WebDetectionProto
            .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebLabel_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.class,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.Builder.class);
      }

      // Construct using com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        label_ = "";

        languageCode_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.vision.v1p2beta1.WebDetectionProto
            .internal_static_google_cloud_vision_v1p2beta1_WebDetection_WebLabel_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel getDefaultInstanceForType() {
        return com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel build() {
        com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel buildPartial() {
        com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel result =
            new com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel(this);
        result.label_ = label_;
        result.languageCode_ = languageCode_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel) {
          return mergeFrom((com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel other) {
        if (other == com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.getDefaultInstance())
          return this;
        if (!other.getLabel().isEmpty()) {
          label_ = other.label_;
          onChanged();
        }
        if (!other.getLanguageCode().isEmpty()) {
          languageCode_ = other.languageCode_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  label_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  languageCode_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object label_ = "";
      /**
       *
       *
       * <pre>
       * Label for extra metadata.
       * </pre>
       *
       * <code>string label = 1;</code>
       *
       * @return The label.
       */
      public java.lang.String getLabel() {
        java.lang.Object ref = label_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          label_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Label for extra metadata.
       * </pre>
       *
       * <code>string label = 1;</code>
       *
       * @return The bytes for label.
       */
      public com.google.protobuf.ByteString getLabelBytes() {
        java.lang.Object ref = label_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          label_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Label for extra metadata.
       * </pre>
       *
       * <code>string label = 1;</code>
       *
       * @param value The label to set.
       * @return This builder for chaining.
       */
      public Builder setLabel(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        label_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Label for extra metadata.
       * </pre>
       *
       * <code>string label = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLabel() {

        label_ = getDefaultInstance().getLabel();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Label for extra metadata.
       * </pre>
       *
       * <code>string label = 1;</code>
       *
       * @param value The bytes for label to set.
       * @return This builder for chaining.
       */
      public Builder setLabelBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        label_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object languageCode_ = "";
      /**
       *
       *
       * <pre>
       * The BCP-47 language code for `label`, such as "en-US" or "sr-Latn".
       * For more information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 2;</code>
       *
       * @return The languageCode.
       */
      public java.lang.String getLanguageCode() {
        java.lang.Object ref = languageCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          languageCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The BCP-47 language code for `label`, such as "en-US" or "sr-Latn".
       * For more information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 2;</code>
       *
       * @return The bytes for languageCode.
       */
      public com.google.protobuf.ByteString getLanguageCodeBytes() {
        java.lang.Object ref = languageCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          languageCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The BCP-47 language code for `label`, such as "en-US" or "sr-Latn".
       * For more information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 2;</code>
       *
       * @param value The languageCode to set.
       * @return This builder for chaining.
       */
      public Builder setLanguageCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        languageCode_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BCP-47 language code for `label`, such as "en-US" or "sr-Latn".
       * For more information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLanguageCode() {

        languageCode_ = getDefaultInstance().getLanguageCode();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BCP-47 language code for `label`, such as "en-US" or "sr-Latn".
       * For more information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 2;</code>
       *
       * @param value The bytes for languageCode to set.
       * @return This builder for chaining.
       */
      public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        languageCode_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p2beta1.WebDetection.WebLabel)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p2beta1.WebDetection.WebLabel)
    private static final com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel();
    }

    public static com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WebLabel> PARSER =
        new com.google.protobuf.AbstractParser<WebLabel>() {
          @java.lang.Override
          public WebLabel parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<WebLabel> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WebLabel> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int WEB_ENTITIES_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity> webEntities_;
  /**
   *
   *
   * <pre>
   * Deduced entities from similar images on the Internet.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity>
      getWebEntitiesList() {
    return webEntities_;
  }
  /**
   *
   *
   * <pre>
   * Deduced entities from similar images on the Internet.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebEntityOrBuilder>
      getWebEntitiesOrBuilderList() {
    return webEntities_;
  }
  /**
   *
   *
   * <pre>
   * Deduced entities from similar images on the Internet.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
   */
  @java.lang.Override
  public int getWebEntitiesCount() {
    return webEntities_.size();
  }
  /**
   *
   *
   * <pre>
   * Deduced entities from similar images on the Internet.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity getWebEntities(int index) {
    return webEntities_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Deduced entities from similar images on the Internet.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.WebDetection.WebEntityOrBuilder getWebEntitiesOrBuilder(
      int index) {
    return webEntities_.get(index);
  }

  public static final int FULL_MATCHING_IMAGES_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
      fullMatchingImages_;
  /**
   *
   *
   * <pre>
   * Fully matching images from the Internet.
   * Can include resized copies of the query image.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
      getFullMatchingImagesList() {
    return fullMatchingImages_;
  }
  /**
   *
   *
   * <pre>
   * Fully matching images from the Internet.
   * Can include resized copies of the query image.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
      getFullMatchingImagesOrBuilderList() {
    return fullMatchingImages_;
  }
  /**
   *
   *
   * <pre>
   * Fully matching images from the Internet.
   * Can include resized copies of the query image.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
   * </code>
   */
  @java.lang.Override
  public int getFullMatchingImagesCount() {
    return fullMatchingImages_.size();
  }
  /**
   *
   *
   * <pre>
   * Fully matching images from the Internet.
   * Can include resized copies of the query image.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage getFullMatchingImages(int index) {
    return fullMatchingImages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Fully matching images from the Internet.
   * Can include resized copies of the query image.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder
      getFullMatchingImagesOrBuilder(int index) {
    return fullMatchingImages_.get(index);
  }

  public static final int PARTIAL_MATCHING_IMAGES_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
      partialMatchingImages_;
  /**
   *
   *
   * <pre>
   * Partial matching images from the Internet.
   * Those images are similar enough to share some key-point features. For
   * example an original image will likely have partial matching for its crops.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
      getPartialMatchingImagesList() {
    return partialMatchingImages_;
  }
  /**
   *
   *
   * <pre>
   * Partial matching images from the Internet.
   * Those images are similar enough to share some key-point features. For
   * example an original image will likely have partial matching for its crops.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
      getPartialMatchingImagesOrBuilderList() {
    return partialMatchingImages_;
  }
  /**
   *
   *
   * <pre>
   * Partial matching images from the Internet.
   * Those images are similar enough to share some key-point features. For
   * example an original image will likely have partial matching for its crops.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
   * </code>
   */
  @java.lang.Override
  public int getPartialMatchingImagesCount() {
    return partialMatchingImages_.size();
  }
  /**
   *
   *
   * <pre>
   * Partial matching images from the Internet.
   * Those images are similar enough to share some key-point features. For
   * example an original image will likely have partial matching for its crops.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage getPartialMatchingImages(
      int index) {
    return partialMatchingImages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Partial matching images from the Internet.
   * Those images are similar enough to share some key-point features. For
   * example an original image will likely have partial matching for its crops.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder
      getPartialMatchingImagesOrBuilder(int index) {
    return partialMatchingImages_.get(index);
  }

  public static final int PAGES_WITH_MATCHING_IMAGES_FIELD_NUMBER = 4;
  private java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebPage>
      pagesWithMatchingImages_;
  /**
   *
   *
   * <pre>
   * Web pages containing the matching images from the Internet.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebPage>
      getPagesWithMatchingImagesList() {
    return pagesWithMatchingImages_;
  }
  /**
   *
   *
   * <pre>
   * Web pages containing the matching images from the Internet.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebPageOrBuilder>
      getPagesWithMatchingImagesOrBuilderList() {
    return pagesWithMatchingImages_;
  }
  /**
   *
   *
   * <pre>
   * Web pages containing the matching images from the Internet.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
   * </code>
   */
  @java.lang.Override
  public int getPagesWithMatchingImagesCount() {
    return pagesWithMatchingImages_.size();
  }
  /**
   *
   *
   * <pre>
   * Web pages containing the matching images from the Internet.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.WebDetection.WebPage getPagesWithMatchingImages(
      int index) {
    return pagesWithMatchingImages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Web pages containing the matching images from the Internet.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.WebDetection.WebPageOrBuilder
      getPagesWithMatchingImagesOrBuilder(int index) {
    return pagesWithMatchingImages_.get(index);
  }

  public static final int VISUALLY_SIMILAR_IMAGES_FIELD_NUMBER = 6;
  private java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
      visuallySimilarImages_;
  /**
   *
   *
   * <pre>
   * The visually similar image results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
      getVisuallySimilarImagesList() {
    return visuallySimilarImages_;
  }
  /**
   *
   *
   * <pre>
   * The visually similar image results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
      getVisuallySimilarImagesOrBuilderList() {
    return visuallySimilarImages_;
  }
  /**
   *
   *
   * <pre>
   * The visually similar image results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
   * </code>
   */
  @java.lang.Override
  public int getVisuallySimilarImagesCount() {
    return visuallySimilarImages_.size();
  }
  /**
   *
   *
   * <pre>
   * The visually similar image results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage getVisuallySimilarImages(
      int index) {
    return visuallySimilarImages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The visually similar image results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder
      getVisuallySimilarImagesOrBuilder(int index) {
    return visuallySimilarImages_.get(index);
  }

  public static final int BEST_GUESS_LABELS_FIELD_NUMBER = 8;
  private java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel> bestGuessLabels_;
  /**
   *
   *
   * <pre>
   * Best guess text labels for the request image.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel>
      getBestGuessLabelsList() {
    return bestGuessLabels_;
  }
  /**
   *
   *
   * <pre>
   * Best guess text labels for the request image.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebLabelOrBuilder>
      getBestGuessLabelsOrBuilderList() {
    return bestGuessLabels_;
  }
  /**
   *
   *
   * <pre>
   * Best guess text labels for the request image.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
   * </code>
   */
  @java.lang.Override
  public int getBestGuessLabelsCount() {
    return bestGuessLabels_.size();
  }
  /**
   *
   *
   * <pre>
   * Best guess text labels for the request image.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel getBestGuessLabels(int index) {
    return bestGuessLabels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Best guess text labels for the request image.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.WebDetection.WebLabelOrBuilder
      getBestGuessLabelsOrBuilder(int index) {
    return bestGuessLabels_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < webEntities_.size(); i++) {
      output.writeMessage(1, webEntities_.get(i));
    }
    for (int i = 0; i < fullMatchingImages_.size(); i++) {
      output.writeMessage(2, fullMatchingImages_.get(i));
    }
    for (int i = 0; i < partialMatchingImages_.size(); i++) {
      output.writeMessage(3, partialMatchingImages_.get(i));
    }
    for (int i = 0; i < pagesWithMatchingImages_.size(); i++) {
      output.writeMessage(4, pagesWithMatchingImages_.get(i));
    }
    for (int i = 0; i < visuallySimilarImages_.size(); i++) {
      output.writeMessage(6, visuallySimilarImages_.get(i));
    }
    for (int i = 0; i < bestGuessLabels_.size(); i++) {
      output.writeMessage(8, bestGuessLabels_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < webEntities_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, webEntities_.get(i));
    }
    for (int i = 0; i < fullMatchingImages_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, fullMatchingImages_.get(i));
    }
    for (int i = 0; i < partialMatchingImages_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, partialMatchingImages_.get(i));
    }
    for (int i = 0; i < pagesWithMatchingImages_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, pagesWithMatchingImages_.get(i));
    }
    for (int i = 0; i < visuallySimilarImages_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, visuallySimilarImages_.get(i));
    }
    for (int i = 0; i < bestGuessLabels_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, bestGuessLabels_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1p2beta1.WebDetection)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1p2beta1.WebDetection other =
        (com.google.cloud.vision.v1p2beta1.WebDetection) obj;

    if (!getWebEntitiesList().equals(other.getWebEntitiesList())) return false;
    if (!getFullMatchingImagesList().equals(other.getFullMatchingImagesList())) return false;
    if (!getPartialMatchingImagesList().equals(other.getPartialMatchingImagesList())) return false;
    if (!getPagesWithMatchingImagesList().equals(other.getPagesWithMatchingImagesList()))
      return false;
    if (!getVisuallySimilarImagesList().equals(other.getVisuallySimilarImagesList())) return false;
    if (!getBestGuessLabelsList().equals(other.getBestGuessLabelsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getWebEntitiesCount() > 0) {
      hash = (37 * hash) + WEB_ENTITIES_FIELD_NUMBER;
      hash = (53 * hash) + getWebEntitiesList().hashCode();
    }
    if (getFullMatchingImagesCount() > 0) {
      hash = (37 * hash) + FULL_MATCHING_IMAGES_FIELD_NUMBER;
      hash = (53 * hash) + getFullMatchingImagesList().hashCode();
    }
    if (getPartialMatchingImagesCount() > 0) {
      hash = (37 * hash) + PARTIAL_MATCHING_IMAGES_FIELD_NUMBER;
      hash = (53 * hash) + getPartialMatchingImagesList().hashCode();
    }
    if (getPagesWithMatchingImagesCount() > 0) {
      hash = (37 * hash) + PAGES_WITH_MATCHING_IMAGES_FIELD_NUMBER;
      hash = (53 * hash) + getPagesWithMatchingImagesList().hashCode();
    }
    if (getVisuallySimilarImagesCount() > 0) {
      hash = (37 * hash) + VISUALLY_SIMILAR_IMAGES_FIELD_NUMBER;
      hash = (53 * hash) + getVisuallySimilarImagesList().hashCode();
    }
    if (getBestGuessLabelsCount() > 0) {
      hash = (37 * hash) + BEST_GUESS_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + getBestGuessLabelsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1p2beta1.WebDetection parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p2beta1.WebDetection parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.WebDetection parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p2beta1.WebDetection parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.WebDetection parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p2beta1.WebDetection parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.WebDetection parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p2beta1.WebDetection parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.WebDetection parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p2beta1.WebDetection parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.WebDetection parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p2beta1.WebDetection parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vision.v1p2beta1.WebDetection prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Relevant information for the image from the Internet.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p2beta1.WebDetection}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p2beta1.WebDetection)
      com.google.cloud.vision.v1p2beta1.WebDetectionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p2beta1.WebDetectionProto
          .internal_static_google_cloud_vision_v1p2beta1_WebDetection_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p2beta1.WebDetectionProto
          .internal_static_google_cloud_vision_v1p2beta1_WebDetection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p2beta1.WebDetection.class,
              com.google.cloud.vision.v1p2beta1.WebDetection.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1p2beta1.WebDetection.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (webEntitiesBuilder_ == null) {
        webEntities_ = java.util.Collections.emptyList();
      } else {
        webEntities_ = null;
        webEntitiesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (fullMatchingImagesBuilder_ == null) {
        fullMatchingImages_ = java.util.Collections.emptyList();
      } else {
        fullMatchingImages_ = null;
        fullMatchingImagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (partialMatchingImagesBuilder_ == null) {
        partialMatchingImages_ = java.util.Collections.emptyList();
      } else {
        partialMatchingImages_ = null;
        partialMatchingImagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (pagesWithMatchingImagesBuilder_ == null) {
        pagesWithMatchingImages_ = java.util.Collections.emptyList();
      } else {
        pagesWithMatchingImages_ = null;
        pagesWithMatchingImagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (visuallySimilarImagesBuilder_ == null) {
        visuallySimilarImages_ = java.util.Collections.emptyList();
      } else {
        visuallySimilarImages_ = null;
        visuallySimilarImagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (bestGuessLabelsBuilder_ == null) {
        bestGuessLabels_ = java.util.Collections.emptyList();
      } else {
        bestGuessLabels_ = null;
        bestGuessLabelsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1p2beta1.WebDetectionProto
          .internal_static_google_cloud_vision_v1p2beta1_WebDetection_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.WebDetection getDefaultInstanceForType() {
      return com.google.cloud.vision.v1p2beta1.WebDetection.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.WebDetection build() {
      com.google.cloud.vision.v1p2beta1.WebDetection result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.WebDetection buildPartial() {
      com.google.cloud.vision.v1p2beta1.WebDetection result =
          new com.google.cloud.vision.v1p2beta1.WebDetection(this);
      int from_bitField0_ = bitField0_;
      if (webEntitiesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          webEntities_ = java.util.Collections.unmodifiableList(webEntities_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.webEntities_ = webEntities_;
      } else {
        result.webEntities_ = webEntitiesBuilder_.build();
      }
      if (fullMatchingImagesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          fullMatchingImages_ = java.util.Collections.unmodifiableList(fullMatchingImages_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.fullMatchingImages_ = fullMatchingImages_;
      } else {
        result.fullMatchingImages_ = fullMatchingImagesBuilder_.build();
      }
      if (partialMatchingImagesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          partialMatchingImages_ = java.util.Collections.unmodifiableList(partialMatchingImages_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.partialMatchingImages_ = partialMatchingImages_;
      } else {
        result.partialMatchingImages_ = partialMatchingImagesBuilder_.build();
      }
      if (pagesWithMatchingImagesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          pagesWithMatchingImages_ =
              java.util.Collections.unmodifiableList(pagesWithMatchingImages_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.pagesWithMatchingImages_ = pagesWithMatchingImages_;
      } else {
        result.pagesWithMatchingImages_ = pagesWithMatchingImagesBuilder_.build();
      }
      if (visuallySimilarImagesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          visuallySimilarImages_ = java.util.Collections.unmodifiableList(visuallySimilarImages_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.visuallySimilarImages_ = visuallySimilarImages_;
      } else {
        result.visuallySimilarImages_ = visuallySimilarImagesBuilder_.build();
      }
      if (bestGuessLabelsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          bestGuessLabels_ = java.util.Collections.unmodifiableList(bestGuessLabels_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.bestGuessLabels_ = bestGuessLabels_;
      } else {
        result.bestGuessLabels_ = bestGuessLabelsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1p2beta1.WebDetection) {
        return mergeFrom((com.google.cloud.vision.v1p2beta1.WebDetection) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1p2beta1.WebDetection other) {
      if (other == com.google.cloud.vision.v1p2beta1.WebDetection.getDefaultInstance()) return this;
      if (webEntitiesBuilder_ == null) {
        if (!other.webEntities_.isEmpty()) {
          if (webEntities_.isEmpty()) {
            webEntities_ = other.webEntities_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureWebEntitiesIsMutable();
            webEntities_.addAll(other.webEntities_);
          }
          onChanged();
        }
      } else {
        if (!other.webEntities_.isEmpty()) {
          if (webEntitiesBuilder_.isEmpty()) {
            webEntitiesBuilder_.dispose();
            webEntitiesBuilder_ = null;
            webEntities_ = other.webEntities_;
            bitField0_ = (bitField0_ & ~0x00000001);
            webEntitiesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWebEntitiesFieldBuilder()
                    : null;
          } else {
            webEntitiesBuilder_.addAllMessages(other.webEntities_);
          }
        }
      }
      if (fullMatchingImagesBuilder_ == null) {
        if (!other.fullMatchingImages_.isEmpty()) {
          if (fullMatchingImages_.isEmpty()) {
            fullMatchingImages_ = other.fullMatchingImages_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureFullMatchingImagesIsMutable();
            fullMatchingImages_.addAll(other.fullMatchingImages_);
          }
          onChanged();
        }
      } else {
        if (!other.fullMatchingImages_.isEmpty()) {
          if (fullMatchingImagesBuilder_.isEmpty()) {
            fullMatchingImagesBuilder_.dispose();
            fullMatchingImagesBuilder_ = null;
            fullMatchingImages_ = other.fullMatchingImages_;
            bitField0_ = (bitField0_ & ~0x00000002);
            fullMatchingImagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFullMatchingImagesFieldBuilder()
                    : null;
          } else {
            fullMatchingImagesBuilder_.addAllMessages(other.fullMatchingImages_);
          }
        }
      }
      if (partialMatchingImagesBuilder_ == null) {
        if (!other.partialMatchingImages_.isEmpty()) {
          if (partialMatchingImages_.isEmpty()) {
            partialMatchingImages_ = other.partialMatchingImages_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensurePartialMatchingImagesIsMutable();
            partialMatchingImages_.addAll(other.partialMatchingImages_);
          }
          onChanged();
        }
      } else {
        if (!other.partialMatchingImages_.isEmpty()) {
          if (partialMatchingImagesBuilder_.isEmpty()) {
            partialMatchingImagesBuilder_.dispose();
            partialMatchingImagesBuilder_ = null;
            partialMatchingImages_ = other.partialMatchingImages_;
            bitField0_ = (bitField0_ & ~0x00000004);
            partialMatchingImagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPartialMatchingImagesFieldBuilder()
                    : null;
          } else {
            partialMatchingImagesBuilder_.addAllMessages(other.partialMatchingImages_);
          }
        }
      }
      if (pagesWithMatchingImagesBuilder_ == null) {
        if (!other.pagesWithMatchingImages_.isEmpty()) {
          if (pagesWithMatchingImages_.isEmpty()) {
            pagesWithMatchingImages_ = other.pagesWithMatchingImages_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensurePagesWithMatchingImagesIsMutable();
            pagesWithMatchingImages_.addAll(other.pagesWithMatchingImages_);
          }
          onChanged();
        }
      } else {
        if (!other.pagesWithMatchingImages_.isEmpty()) {
          if (pagesWithMatchingImagesBuilder_.isEmpty()) {
            pagesWithMatchingImagesBuilder_.dispose();
            pagesWithMatchingImagesBuilder_ = null;
            pagesWithMatchingImages_ = other.pagesWithMatchingImages_;
            bitField0_ = (bitField0_ & ~0x00000008);
            pagesWithMatchingImagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPagesWithMatchingImagesFieldBuilder()
                    : null;
          } else {
            pagesWithMatchingImagesBuilder_.addAllMessages(other.pagesWithMatchingImages_);
          }
        }
      }
      if (visuallySimilarImagesBuilder_ == null) {
        if (!other.visuallySimilarImages_.isEmpty()) {
          if (visuallySimilarImages_.isEmpty()) {
            visuallySimilarImages_ = other.visuallySimilarImages_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureVisuallySimilarImagesIsMutable();
            visuallySimilarImages_.addAll(other.visuallySimilarImages_);
          }
          onChanged();
        }
      } else {
        if (!other.visuallySimilarImages_.isEmpty()) {
          if (visuallySimilarImagesBuilder_.isEmpty()) {
            visuallySimilarImagesBuilder_.dispose();
            visuallySimilarImagesBuilder_ = null;
            visuallySimilarImages_ = other.visuallySimilarImages_;
            bitField0_ = (bitField0_ & ~0x00000010);
            visuallySimilarImagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVisuallySimilarImagesFieldBuilder()
                    : null;
          } else {
            visuallySimilarImagesBuilder_.addAllMessages(other.visuallySimilarImages_);
          }
        }
      }
      if (bestGuessLabelsBuilder_ == null) {
        if (!other.bestGuessLabels_.isEmpty()) {
          if (bestGuessLabels_.isEmpty()) {
            bestGuessLabels_ = other.bestGuessLabels_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureBestGuessLabelsIsMutable();
            bestGuessLabels_.addAll(other.bestGuessLabels_);
          }
          onChanged();
        }
      } else {
        if (!other.bestGuessLabels_.isEmpty()) {
          if (bestGuessLabelsBuilder_.isEmpty()) {
            bestGuessLabelsBuilder_.dispose();
            bestGuessLabelsBuilder_ = null;
            bestGuessLabels_ = other.bestGuessLabels_;
            bitField0_ = (bitField0_ & ~0x00000020);
            bestGuessLabelsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBestGuessLabelsFieldBuilder()
                    : null;
          } else {
            bestGuessLabelsBuilder_.addAllMessages(other.bestGuessLabels_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity m =
                    input.readMessage(
                        com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.parser(),
                        extensionRegistry);
                if (webEntitiesBuilder_ == null) {
                  ensureWebEntitiesIsMutable();
                  webEntities_.add(m);
                } else {
                  webEntitiesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImage m =
                    input.readMessage(
                        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.parser(),
                        extensionRegistry);
                if (fullMatchingImagesBuilder_ == null) {
                  ensureFullMatchingImagesIsMutable();
                  fullMatchingImages_.add(m);
                } else {
                  fullMatchingImagesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImage m =
                    input.readMessage(
                        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.parser(),
                        extensionRegistry);
                if (partialMatchingImagesBuilder_ == null) {
                  ensurePartialMatchingImagesIsMutable();
                  partialMatchingImages_.add(m);
                } else {
                  partialMatchingImagesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.vision.v1p2beta1.WebDetection.WebPage m =
                    input.readMessage(
                        com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.parser(),
                        extensionRegistry);
                if (pagesWithMatchingImagesBuilder_ == null) {
                  ensurePagesWithMatchingImagesIsMutable();
                  pagesWithMatchingImages_.add(m);
                } else {
                  pagesWithMatchingImagesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 50:
              {
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImage m =
                    input.readMessage(
                        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.parser(),
                        extensionRegistry);
                if (visuallySimilarImagesBuilder_ == null) {
                  ensureVisuallySimilarImagesIsMutable();
                  visuallySimilarImages_.add(m);
                } else {
                  visuallySimilarImagesBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 66:
              {
                com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel m =
                    input.readMessage(
                        com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.parser(),
                        extensionRegistry);
                if (bestGuessLabelsBuilder_ == null) {
                  ensureBestGuessLabelsIsMutable();
                  bestGuessLabels_.add(m);
                } else {
                  bestGuessLabelsBuilder_.addMessage(m);
                }
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity> webEntities_ =
        java.util.Collections.emptyList();

    private void ensureWebEntitiesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        webEntities_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity>(
                webEntities_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.Builder,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebEntityOrBuilder>
        webEntitiesBuilder_;

    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity>
        getWebEntitiesList() {
      if (webEntitiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(webEntities_);
      } else {
        return webEntitiesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public int getWebEntitiesCount() {
      if (webEntitiesBuilder_ == null) {
        return webEntities_.size();
      } else {
        return webEntitiesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity getWebEntities(int index) {
      if (webEntitiesBuilder_ == null) {
        return webEntities_.get(index);
      } else {
        return webEntitiesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public Builder setWebEntities(
        int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity value) {
      if (webEntitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWebEntitiesIsMutable();
        webEntities_.set(index, value);
        onChanged();
      } else {
        webEntitiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public Builder setWebEntities(
        int index,
        com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.Builder builderForValue) {
      if (webEntitiesBuilder_ == null) {
        ensureWebEntitiesIsMutable();
        webEntities_.set(index, builderForValue.build());
        onChanged();
      } else {
        webEntitiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public Builder addWebEntities(com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity value) {
      if (webEntitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWebEntitiesIsMutable();
        webEntities_.add(value);
        onChanged();
      } else {
        webEntitiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public Builder addWebEntities(
        int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity value) {
      if (webEntitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWebEntitiesIsMutable();
        webEntities_.add(index, value);
        onChanged();
      } else {
        webEntitiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public Builder addWebEntities(
        com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.Builder builderForValue) {
      if (webEntitiesBuilder_ == null) {
        ensureWebEntitiesIsMutable();
        webEntities_.add(builderForValue.build());
        onChanged();
      } else {
        webEntitiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public Builder addWebEntities(
        int index,
        com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.Builder builderForValue) {
      if (webEntitiesBuilder_ == null) {
        ensureWebEntitiesIsMutable();
        webEntities_.add(index, builderForValue.build());
        onChanged();
      } else {
        webEntitiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public Builder addAllWebEntities(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity>
            values) {
      if (webEntitiesBuilder_ == null) {
        ensureWebEntitiesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, webEntities_);
        onChanged();
      } else {
        webEntitiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public Builder clearWebEntities() {
      if (webEntitiesBuilder_ == null) {
        webEntities_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        webEntitiesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public Builder removeWebEntities(int index) {
      if (webEntitiesBuilder_ == null) {
        ensureWebEntitiesIsMutable();
        webEntities_.remove(index);
        onChanged();
      } else {
        webEntitiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.Builder getWebEntitiesBuilder(
        int index) {
      return getWebEntitiesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebEntityOrBuilder
        getWebEntitiesOrBuilder(int index) {
      if (webEntitiesBuilder_ == null) {
        return webEntities_.get(index);
      } else {
        return webEntitiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebEntityOrBuilder>
        getWebEntitiesOrBuilderList() {
      if (webEntitiesBuilder_ != null) {
        return webEntitiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(webEntities_);
      }
    }
    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.Builder
        addWebEntitiesBuilder() {
      return getWebEntitiesFieldBuilder()
          .addBuilder(
              com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.Builder addWebEntitiesBuilder(
        int index) {
      return getWebEntitiesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deduced entities from similar images on the Internet.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebEntity web_entities = 1;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.Builder>
        getWebEntitiesBuilderList() {
      return getWebEntitiesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.Builder,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebEntityOrBuilder>
        getWebEntitiesFieldBuilder() {
      if (webEntitiesBuilder_ == null) {
        webEntitiesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebEntity.Builder,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebEntityOrBuilder>(
                webEntities_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        webEntities_ = null;
      }
      return webEntitiesBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
        fullMatchingImages_ = java.util.Collections.emptyList();

    private void ensureFullMatchingImagesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        fullMatchingImages_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>(
                fullMatchingImages_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImage,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
        fullMatchingImagesBuilder_;

    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
        getFullMatchingImagesList() {
      if (fullMatchingImagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fullMatchingImages_);
      } else {
        return fullMatchingImagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public int getFullMatchingImagesCount() {
      if (fullMatchingImagesBuilder_ == null) {
        return fullMatchingImages_.size();
      } else {
        return fullMatchingImagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage getFullMatchingImages(
        int index) {
      if (fullMatchingImagesBuilder_ == null) {
        return fullMatchingImages_.get(index);
      } else {
        return fullMatchingImagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public Builder setFullMatchingImages(
        int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebImage value) {
      if (fullMatchingImagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFullMatchingImagesIsMutable();
        fullMatchingImages_.set(index, value);
        onChanged();
      } else {
        fullMatchingImagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public Builder setFullMatchingImages(
        int index,
        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder builderForValue) {
      if (fullMatchingImagesBuilder_ == null) {
        ensureFullMatchingImagesIsMutable();
        fullMatchingImages_.set(index, builderForValue.build());
        onChanged();
      } else {
        fullMatchingImagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public Builder addFullMatchingImages(
        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage value) {
      if (fullMatchingImagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFullMatchingImagesIsMutable();
        fullMatchingImages_.add(value);
        onChanged();
      } else {
        fullMatchingImagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public Builder addFullMatchingImages(
        int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebImage value) {
      if (fullMatchingImagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFullMatchingImagesIsMutable();
        fullMatchingImages_.add(index, value);
        onChanged();
      } else {
        fullMatchingImagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public Builder addFullMatchingImages(
        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder builderForValue) {
      if (fullMatchingImagesBuilder_ == null) {
        ensureFullMatchingImagesIsMutable();
        fullMatchingImages_.add(builderForValue.build());
        onChanged();
      } else {
        fullMatchingImagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public Builder addFullMatchingImages(
        int index,
        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder builderForValue) {
      if (fullMatchingImagesBuilder_ == null) {
        ensureFullMatchingImagesIsMutable();
        fullMatchingImages_.add(index, builderForValue.build());
        onChanged();
      } else {
        fullMatchingImagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public Builder addAllFullMatchingImages(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
            values) {
      if (fullMatchingImagesBuilder_ == null) {
        ensureFullMatchingImagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fullMatchingImages_);
        onChanged();
      } else {
        fullMatchingImagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public Builder clearFullMatchingImages() {
      if (fullMatchingImagesBuilder_ == null) {
        fullMatchingImages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        fullMatchingImagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public Builder removeFullMatchingImages(int index) {
      if (fullMatchingImagesBuilder_ == null) {
        ensureFullMatchingImagesIsMutable();
        fullMatchingImages_.remove(index);
        onChanged();
      } else {
        fullMatchingImagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder
        getFullMatchingImagesBuilder(int index) {
      return getFullMatchingImagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder
        getFullMatchingImagesOrBuilder(int index) {
      if (fullMatchingImagesBuilder_ == null) {
        return fullMatchingImages_.get(index);
      } else {
        return fullMatchingImagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
        getFullMatchingImagesOrBuilderList() {
      if (fullMatchingImagesBuilder_ != null) {
        return fullMatchingImagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fullMatchingImages_);
      }
    }
    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder
        addFullMatchingImagesBuilder() {
      return getFullMatchingImagesFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder
        addFullMatchingImagesBuilder(int index) {
      return getFullMatchingImagesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Fully matching images from the Internet.
     * Can include resized copies of the query image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage full_matching_images = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder>
        getFullMatchingImagesBuilderList() {
      return getFullMatchingImagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImage,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
        getFullMatchingImagesFieldBuilder() {
      if (fullMatchingImagesBuilder_ == null) {
        fullMatchingImagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImage,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>(
                fullMatchingImages_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        fullMatchingImages_ = null;
      }
      return fullMatchingImagesBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
        partialMatchingImages_ = java.util.Collections.emptyList();

    private void ensurePartialMatchingImagesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        partialMatchingImages_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>(
                partialMatchingImages_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImage,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
        partialMatchingImagesBuilder_;

    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
        getPartialMatchingImagesList() {
      if (partialMatchingImagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(partialMatchingImages_);
      } else {
        return partialMatchingImagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public int getPartialMatchingImagesCount() {
      if (partialMatchingImagesBuilder_ == null) {
        return partialMatchingImages_.size();
      } else {
        return partialMatchingImagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage getPartialMatchingImages(
        int index) {
      if (partialMatchingImagesBuilder_ == null) {
        return partialMatchingImages_.get(index);
      } else {
        return partialMatchingImagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public Builder setPartialMatchingImages(
        int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebImage value) {
      if (partialMatchingImagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialMatchingImagesIsMutable();
        partialMatchingImages_.set(index, value);
        onChanged();
      } else {
        partialMatchingImagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public Builder setPartialMatchingImages(
        int index,
        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder builderForValue) {
      if (partialMatchingImagesBuilder_ == null) {
        ensurePartialMatchingImagesIsMutable();
        partialMatchingImages_.set(index, builderForValue.build());
        onChanged();
      } else {
        partialMatchingImagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public Builder addPartialMatchingImages(
        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage value) {
      if (partialMatchingImagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialMatchingImagesIsMutable();
        partialMatchingImages_.add(value);
        onChanged();
      } else {
        partialMatchingImagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public Builder addPartialMatchingImages(
        int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebImage value) {
      if (partialMatchingImagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialMatchingImagesIsMutable();
        partialMatchingImages_.add(index, value);
        onChanged();
      } else {
        partialMatchingImagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public Builder addPartialMatchingImages(
        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder builderForValue) {
      if (partialMatchingImagesBuilder_ == null) {
        ensurePartialMatchingImagesIsMutable();
        partialMatchingImages_.add(builderForValue.build());
        onChanged();
      } else {
        partialMatchingImagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public Builder addPartialMatchingImages(
        int index,
        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder builderForValue) {
      if (partialMatchingImagesBuilder_ == null) {
        ensurePartialMatchingImagesIsMutable();
        partialMatchingImages_.add(index, builderForValue.build());
        onChanged();
      } else {
        partialMatchingImagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public Builder addAllPartialMatchingImages(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
            values) {
      if (partialMatchingImagesBuilder_ == null) {
        ensurePartialMatchingImagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partialMatchingImages_);
        onChanged();
      } else {
        partialMatchingImagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public Builder clearPartialMatchingImages() {
      if (partialMatchingImagesBuilder_ == null) {
        partialMatchingImages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        partialMatchingImagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public Builder removePartialMatchingImages(int index) {
      if (partialMatchingImagesBuilder_ == null) {
        ensurePartialMatchingImagesIsMutable();
        partialMatchingImages_.remove(index);
        onChanged();
      } else {
        partialMatchingImagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder
        getPartialMatchingImagesBuilder(int index) {
      return getPartialMatchingImagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder
        getPartialMatchingImagesOrBuilder(int index) {
      if (partialMatchingImagesBuilder_ == null) {
        return partialMatchingImages_.get(index);
      } else {
        return partialMatchingImagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
        getPartialMatchingImagesOrBuilderList() {
      if (partialMatchingImagesBuilder_ != null) {
        return partialMatchingImagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(partialMatchingImages_);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder
        addPartialMatchingImagesBuilder() {
      return getPartialMatchingImagesFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder
        addPartialMatchingImagesBuilder(int index) {
      return getPartialMatchingImagesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Partial matching images from the Internet.
     * Those images are similar enough to share some key-point features. For
     * example an original image will likely have partial matching for its crops.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage partial_matching_images = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder>
        getPartialMatchingImagesBuilderList() {
      return getPartialMatchingImagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImage,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
        getPartialMatchingImagesFieldBuilder() {
      if (partialMatchingImagesBuilder_ == null) {
        partialMatchingImagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImage,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>(
                partialMatchingImages_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        partialMatchingImages_ = null;
      }
      return partialMatchingImagesBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebPage>
        pagesWithMatchingImages_ = java.util.Collections.emptyList();

    private void ensurePagesWithMatchingImagesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        pagesWithMatchingImages_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p2beta1.WebDetection.WebPage>(
                pagesWithMatchingImages_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.WebDetection.WebPage,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.Builder,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebPageOrBuilder>
        pagesWithMatchingImagesBuilder_;

    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebPage>
        getPagesWithMatchingImagesList() {
      if (pagesWithMatchingImagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pagesWithMatchingImages_);
      } else {
        return pagesWithMatchingImagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public int getPagesWithMatchingImagesCount() {
      if (pagesWithMatchingImagesBuilder_ == null) {
        return pagesWithMatchingImages_.size();
      } else {
        return pagesWithMatchingImagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebPage getPagesWithMatchingImages(
        int index) {
      if (pagesWithMatchingImagesBuilder_ == null) {
        return pagesWithMatchingImages_.get(index);
      } else {
        return pagesWithMatchingImagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public Builder setPagesWithMatchingImages(
        int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebPage value) {
      if (pagesWithMatchingImagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePagesWithMatchingImagesIsMutable();
        pagesWithMatchingImages_.set(index, value);
        onChanged();
      } else {
        pagesWithMatchingImagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public Builder setPagesWithMatchingImages(
        int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.Builder builderForValue) {
      if (pagesWithMatchingImagesBuilder_ == null) {
        ensurePagesWithMatchingImagesIsMutable();
        pagesWithMatchingImages_.set(index, builderForValue.build());
        onChanged();
      } else {
        pagesWithMatchingImagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public Builder addPagesWithMatchingImages(
        com.google.cloud.vision.v1p2beta1.WebDetection.WebPage value) {
      if (pagesWithMatchingImagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePagesWithMatchingImagesIsMutable();
        pagesWithMatchingImages_.add(value);
        onChanged();
      } else {
        pagesWithMatchingImagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public Builder addPagesWithMatchingImages(
        int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebPage value) {
      if (pagesWithMatchingImagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePagesWithMatchingImagesIsMutable();
        pagesWithMatchingImages_.add(index, value);
        onChanged();
      } else {
        pagesWithMatchingImagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public Builder addPagesWithMatchingImages(
        com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.Builder builderForValue) {
      if (pagesWithMatchingImagesBuilder_ == null) {
        ensurePagesWithMatchingImagesIsMutable();
        pagesWithMatchingImages_.add(builderForValue.build());
        onChanged();
      } else {
        pagesWithMatchingImagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public Builder addPagesWithMatchingImages(
        int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.Builder builderForValue) {
      if (pagesWithMatchingImagesBuilder_ == null) {
        ensurePagesWithMatchingImagesIsMutable();
        pagesWithMatchingImages_.add(index, builderForValue.build());
        onChanged();
      } else {
        pagesWithMatchingImagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public Builder addAllPagesWithMatchingImages(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebPage>
            values) {
      if (pagesWithMatchingImagesBuilder_ == null) {
        ensurePagesWithMatchingImagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pagesWithMatchingImages_);
        onChanged();
      } else {
        pagesWithMatchingImagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public Builder clearPagesWithMatchingImages() {
      if (pagesWithMatchingImagesBuilder_ == null) {
        pagesWithMatchingImages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        pagesWithMatchingImagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public Builder removePagesWithMatchingImages(int index) {
      if (pagesWithMatchingImagesBuilder_ == null) {
        ensurePagesWithMatchingImagesIsMutable();
        pagesWithMatchingImages_.remove(index);
        onChanged();
      } else {
        pagesWithMatchingImagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.Builder
        getPagesWithMatchingImagesBuilder(int index) {
      return getPagesWithMatchingImagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebPageOrBuilder
        getPagesWithMatchingImagesOrBuilder(int index) {
      if (pagesWithMatchingImagesBuilder_ == null) {
        return pagesWithMatchingImages_.get(index);
      } else {
        return pagesWithMatchingImagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebPageOrBuilder>
        getPagesWithMatchingImagesOrBuilderList() {
      if (pagesWithMatchingImagesBuilder_ != null) {
        return pagesWithMatchingImagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pagesWithMatchingImages_);
      }
    }
    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.Builder
        addPagesWithMatchingImagesBuilder() {
      return getPagesWithMatchingImagesFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.Builder
        addPagesWithMatchingImagesBuilder(int index) {
      return getPagesWithMatchingImagesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Web pages containing the matching images from the Internet.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebPage pages_with_matching_images = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.Builder>
        getPagesWithMatchingImagesBuilderList() {
      return getPagesWithMatchingImagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.WebDetection.WebPage,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.Builder,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebPageOrBuilder>
        getPagesWithMatchingImagesFieldBuilder() {
      if (pagesWithMatchingImagesBuilder_ == null) {
        pagesWithMatchingImagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p2beta1.WebDetection.WebPage,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebPage.Builder,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebPageOrBuilder>(
                pagesWithMatchingImages_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        pagesWithMatchingImages_ = null;
      }
      return pagesWithMatchingImagesBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
        visuallySimilarImages_ = java.util.Collections.emptyList();

    private void ensureVisuallySimilarImagesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        visuallySimilarImages_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>(
                visuallySimilarImages_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImage,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
        visuallySimilarImagesBuilder_;

    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
        getVisuallySimilarImagesList() {
      if (visuallySimilarImagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(visuallySimilarImages_);
      } else {
        return visuallySimilarImagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public int getVisuallySimilarImagesCount() {
      if (visuallySimilarImagesBuilder_ == null) {
        return visuallySimilarImages_.size();
      } else {
        return visuallySimilarImagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage getVisuallySimilarImages(
        int index) {
      if (visuallySimilarImagesBuilder_ == null) {
        return visuallySimilarImages_.get(index);
      } else {
        return visuallySimilarImagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public Builder setVisuallySimilarImages(
        int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebImage value) {
      if (visuallySimilarImagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVisuallySimilarImagesIsMutable();
        visuallySimilarImages_.set(index, value);
        onChanged();
      } else {
        visuallySimilarImagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public Builder setVisuallySimilarImages(
        int index,
        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder builderForValue) {
      if (visuallySimilarImagesBuilder_ == null) {
        ensureVisuallySimilarImagesIsMutable();
        visuallySimilarImages_.set(index, builderForValue.build());
        onChanged();
      } else {
        visuallySimilarImagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public Builder addVisuallySimilarImages(
        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage value) {
      if (visuallySimilarImagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVisuallySimilarImagesIsMutable();
        visuallySimilarImages_.add(value);
        onChanged();
      } else {
        visuallySimilarImagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public Builder addVisuallySimilarImages(
        int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebImage value) {
      if (visuallySimilarImagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVisuallySimilarImagesIsMutable();
        visuallySimilarImages_.add(index, value);
        onChanged();
      } else {
        visuallySimilarImagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public Builder addVisuallySimilarImages(
        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder builderForValue) {
      if (visuallySimilarImagesBuilder_ == null) {
        ensureVisuallySimilarImagesIsMutable();
        visuallySimilarImages_.add(builderForValue.build());
        onChanged();
      } else {
        visuallySimilarImagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public Builder addVisuallySimilarImages(
        int index,
        com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder builderForValue) {
      if (visuallySimilarImagesBuilder_ == null) {
        ensureVisuallySimilarImagesIsMutable();
        visuallySimilarImages_.add(index, builderForValue.build());
        onChanged();
      } else {
        visuallySimilarImagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public Builder addAllVisuallySimilarImages(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebImage>
            values) {
      if (visuallySimilarImagesBuilder_ == null) {
        ensureVisuallySimilarImagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, visuallySimilarImages_);
        onChanged();
      } else {
        visuallySimilarImagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public Builder clearVisuallySimilarImages() {
      if (visuallySimilarImagesBuilder_ == null) {
        visuallySimilarImages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        visuallySimilarImagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public Builder removeVisuallySimilarImages(int index) {
      if (visuallySimilarImagesBuilder_ == null) {
        ensureVisuallySimilarImagesIsMutable();
        visuallySimilarImages_.remove(index);
        onChanged();
      } else {
        visuallySimilarImagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder
        getVisuallySimilarImagesBuilder(int index) {
      return getVisuallySimilarImagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder
        getVisuallySimilarImagesOrBuilder(int index) {
      if (visuallySimilarImagesBuilder_ == null) {
        return visuallySimilarImages_.get(index);
      } else {
        return visuallySimilarImagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
        getVisuallySimilarImagesOrBuilderList() {
      if (visuallySimilarImagesBuilder_ != null) {
        return visuallySimilarImagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(visuallySimilarImages_);
      }
    }
    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder
        addVisuallySimilarImagesBuilder() {
      return getVisuallySimilarImagesFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder
        addVisuallySimilarImagesBuilder(int index) {
      return getVisuallySimilarImagesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The visually similar image results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p2beta1.WebDetection.WebImage visually_similar_images = 6;
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder>
        getVisuallySimilarImagesBuilderList() {
      return getVisuallySimilarImagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImage,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>
        getVisuallySimilarImagesFieldBuilder() {
      if (visuallySimilarImagesBuilder_ == null) {
        visuallySimilarImagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImage,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImage.Builder,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebImageOrBuilder>(
                visuallySimilarImages_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        visuallySimilarImages_ = null;
      }
      return visuallySimilarImagesBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel>
        bestGuessLabels_ = java.util.Collections.emptyList();

    private void ensureBestGuessLabelsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        bestGuessLabels_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel>(
                bestGuessLabels_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.Builder,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebLabelOrBuilder>
        bestGuessLabelsBuilder_;

    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel>
        getBestGuessLabelsList() {
      if (bestGuessLabelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(bestGuessLabels_);
      } else {
        return bestGuessLabelsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public int getBestGuessLabelsCount() {
      if (bestGuessLabelsBuilder_ == null) {
        return bestGuessLabels_.size();
      } else {
        return bestGuessLabelsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel getBestGuessLabels(int index) {
      if (bestGuessLabelsBuilder_ == null) {
        return bestGuessLabels_.get(index);
      } else {
        return bestGuessLabelsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public Builder setBestGuessLabels(
        int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel value) {
      if (bestGuessLabelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBestGuessLabelsIsMutable();
        bestGuessLabels_.set(index, value);
        onChanged();
      } else {
        bestGuessLabelsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public Builder setBestGuessLabels(
        int index,
        com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.Builder builderForValue) {
      if (bestGuessLabelsBuilder_ == null) {
        ensureBestGuessLabelsIsMutable();
        bestGuessLabels_.set(index, builderForValue.build());
        onChanged();
      } else {
        bestGuessLabelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public Builder addBestGuessLabels(
        com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel value) {
      if (bestGuessLabelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBestGuessLabelsIsMutable();
        bestGuessLabels_.add(value);
        onChanged();
      } else {
        bestGuessLabelsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public Builder addBestGuessLabels(
        int index, com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel value) {
      if (bestGuessLabelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBestGuessLabelsIsMutable();
        bestGuessLabels_.add(index, value);
        onChanged();
      } else {
        bestGuessLabelsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public Builder addBestGuessLabels(
        com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.Builder builderForValue) {
      if (bestGuessLabelsBuilder_ == null) {
        ensureBestGuessLabelsIsMutable();
        bestGuessLabels_.add(builderForValue.build());
        onChanged();
      } else {
        bestGuessLabelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public Builder addBestGuessLabels(
        int index,
        com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.Builder builderForValue) {
      if (bestGuessLabelsBuilder_ == null) {
        ensureBestGuessLabelsIsMutable();
        bestGuessLabels_.add(index, builderForValue.build());
        onChanged();
      } else {
        bestGuessLabelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public Builder addAllBestGuessLabels(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel>
            values) {
      if (bestGuessLabelsBuilder_ == null) {
        ensureBestGuessLabelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bestGuessLabels_);
        onChanged();
      } else {
        bestGuessLabelsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public Builder clearBestGuessLabels() {
      if (bestGuessLabelsBuilder_ == null) {
        bestGuessLabels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        bestGuessLabelsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public Builder removeBestGuessLabels(int index) {
      if (bestGuessLabelsBuilder_ == null) {
        ensureBestGuessLabelsIsMutable();
        bestGuessLabels_.remove(index);
        onChanged();
      } else {
        bestGuessLabelsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.Builder
        getBestGuessLabelsBuilder(int index) {
      return getBestGuessLabelsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebLabelOrBuilder
        getBestGuessLabelsOrBuilder(int index) {
      if (bestGuessLabelsBuilder_ == null) {
        return bestGuessLabels_.get(index);
      } else {
        return bestGuessLabelsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.vision.v1p2beta1.WebDetection.WebLabelOrBuilder>
        getBestGuessLabelsOrBuilderList() {
      if (bestGuessLabelsBuilder_ != null) {
        return bestGuessLabelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(bestGuessLabels_);
      }
    }
    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.Builder
        addBestGuessLabelsBuilder() {
      return getBestGuessLabelsFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.Builder
        addBestGuessLabelsBuilder(int index) {
      return getBestGuessLabelsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Best guess text labels for the request image.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.WebDetection.WebLabel best_guess_labels = 8;
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.Builder>
        getBestGuessLabelsBuilderList() {
      return getBestGuessLabelsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.Builder,
            com.google.cloud.vision.v1p2beta1.WebDetection.WebLabelOrBuilder>
        getBestGuessLabelsFieldBuilder() {
      if (bestGuessLabelsBuilder_ == null) {
        bestGuessLabelsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebLabel.Builder,
                com.google.cloud.vision.v1p2beta1.WebDetection.WebLabelOrBuilder>(
                bestGuessLabels_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        bestGuessLabels_ = null;
      }
      return bestGuessLabelsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p2beta1.WebDetection)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p2beta1.WebDetection)
  private static final com.google.cloud.vision.v1p2beta1.WebDetection DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1p2beta1.WebDetection();
  }

  public static com.google.cloud.vision.v1p2beta1.WebDetection getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WebDetection> PARSER =
      new com.google.protobuf.AbstractParser<WebDetection>() {
        @java.lang.Override
        public WebDetection parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WebDetection> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WebDetection> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.WebDetection getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
