/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1p2beta1/text_annotation.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.vision.v1p2beta1;

/**
 *
 *
 * <pre>
 * Detected page from OCR.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1p2beta1.Page}
 */
public final class Page extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p2beta1.Page)
    PageOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Page.newBuilder() to construct.
  private Page(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Page() {
    blocks_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Page();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
        .internal_static_google_cloud_vision_v1p2beta1_Page_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
        .internal_static_google_cloud_vision_v1p2beta1_Page_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1p2beta1.Page.class,
            com.google.cloud.vision.v1p2beta1.Page.Builder.class);
  }

  private int bitField0_;
  public static final int PROPERTY_FIELD_NUMBER = 1;
  private com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty property_;
  /**
   *
   *
   * <pre>
   * Additional information detected on the page.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty property = 1;</code>
   *
   * @return Whether the property field is set.
   */
  @java.lang.Override
  public boolean hasProperty() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Additional information detected on the page.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty property = 1;</code>
   *
   * @return The property.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty getProperty() {
    return property_ == null
        ? com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty.getDefaultInstance()
        : property_;
  }
  /**
   *
   *
   * <pre>
   * Additional information detected on the page.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty property = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.TextAnnotation.TextPropertyOrBuilder
      getPropertyOrBuilder() {
    return property_ == null
        ? com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty.getDefaultInstance()
        : property_;
  }

  public static final int WIDTH_FIELD_NUMBER = 2;
  private int width_ = 0;
  /**
   *
   *
   * <pre>
   * Page width. For PDFs the unit is points. For images (including
   * TIFFs) the unit is pixels.
   * </pre>
   *
   * <code>int32 width = 2;</code>
   *
   * @return The width.
   */
  @java.lang.Override
  public int getWidth() {
    return width_;
  }

  public static final int HEIGHT_FIELD_NUMBER = 3;
  private int height_ = 0;
  /**
   *
   *
   * <pre>
   * Page height. For PDFs the unit is points. For images (including
   * TIFFs) the unit is pixels.
   * </pre>
   *
   * <code>int32 height = 3;</code>
   *
   * @return The height.
   */
  @java.lang.Override
  public int getHeight() {
    return height_;
  }

  public static final int BLOCKS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vision.v1p2beta1.Block> blocks_;
  /**
   *
   *
   * <pre>
   * List of blocks of text, images etc on this page.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vision.v1p2beta1.Block> getBlocksList() {
    return blocks_;
  }
  /**
   *
   *
   * <pre>
   * List of blocks of text, images etc on this page.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vision.v1p2beta1.BlockOrBuilder>
      getBlocksOrBuilderList() {
    return blocks_;
  }
  /**
   *
   *
   * <pre>
   * List of blocks of text, images etc on this page.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
   */
  @java.lang.Override
  public int getBlocksCount() {
    return blocks_.size();
  }
  /**
   *
   *
   * <pre>
   * List of blocks of text, images etc on this page.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.Block getBlocks(int index) {
    return blocks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of blocks of text, images etc on this page.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.BlockOrBuilder getBlocksOrBuilder(int index) {
    return blocks_.get(index);
  }

  public static final int CONFIDENCE_FIELD_NUMBER = 5;
  private float confidence_ = 0F;
  /**
   *
   *
   * <pre>
   * Confidence of the OCR results on the page. Range [0, 1].
   * </pre>
   *
   * <code>float confidence = 5;</code>
   *
   * @return The confidence.
   */
  @java.lang.Override
  public float getConfidence() {
    return confidence_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getProperty());
    }
    if (width_ != 0) {
      output.writeInt32(2, width_);
    }
    if (height_ != 0) {
      output.writeInt32(3, height_);
    }
    for (int i = 0; i < blocks_.size(); i++) {
      output.writeMessage(4, blocks_.get(i));
    }
    if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
      output.writeFloat(5, confidence_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getProperty());
    }
    if (width_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, width_);
    }
    if (height_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, height_);
    }
    for (int i = 0; i < blocks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, blocks_.get(i));
    }
    if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(5, confidence_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1p2beta1.Page)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1p2beta1.Page other = (com.google.cloud.vision.v1p2beta1.Page) obj;

    if (hasProperty() != other.hasProperty()) return false;
    if (hasProperty()) {
      if (!getProperty().equals(other.getProperty())) return false;
    }
    if (getWidth() != other.getWidth()) return false;
    if (getHeight() != other.getHeight()) return false;
    if (!getBlocksList().equals(other.getBlocksList())) return false;
    if (java.lang.Float.floatToIntBits(getConfidence())
        != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasProperty()) {
      hash = (37 * hash) + PROPERTY_FIELD_NUMBER;
      hash = (53 * hash) + getProperty().hashCode();
    }
    hash = (37 * hash) + WIDTH_FIELD_NUMBER;
    hash = (53 * hash) + getWidth();
    hash = (37 * hash) + HEIGHT_FIELD_NUMBER;
    hash = (53 * hash) + getHeight();
    if (getBlocksCount() > 0) {
      hash = (37 * hash) + BLOCKS_FIELD_NUMBER;
      hash = (53 * hash) + getBlocksList().hashCode();
    }
    hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1p2beta1.Page parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p2beta1.Page parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.Page parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p2beta1.Page parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.Page parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p2beta1.Page parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.Page parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p2beta1.Page parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.Page parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p2beta1.Page parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p2beta1.Page parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p2beta1.Page parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vision.v1p2beta1.Page prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Detected page from OCR.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p2beta1.Page}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p2beta1.Page)
      com.google.cloud.vision.v1p2beta1.PageOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p2beta1_Page_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p2beta1_Page_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p2beta1.Page.class,
              com.google.cloud.vision.v1p2beta1.Page.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1p2beta1.Page.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPropertyFieldBuilder();
        getBlocksFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      property_ = null;
      if (propertyBuilder_ != null) {
        propertyBuilder_.dispose();
        propertyBuilder_ = null;
      }
      width_ = 0;
      height_ = 0;
      if (blocksBuilder_ == null) {
        blocks_ = java.util.Collections.emptyList();
      } else {
        blocks_ = null;
        blocksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      confidence_ = 0F;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1p2beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p2beta1_Page_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.Page getDefaultInstanceForType() {
      return com.google.cloud.vision.v1p2beta1.Page.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.Page build() {
      com.google.cloud.vision.v1p2beta1.Page result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p2beta1.Page buildPartial() {
      com.google.cloud.vision.v1p2beta1.Page result =
          new com.google.cloud.vision.v1p2beta1.Page(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.vision.v1p2beta1.Page result) {
      if (blocksBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          blocks_ = java.util.Collections.unmodifiableList(blocks_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.blocks_ = blocks_;
      } else {
        result.blocks_ = blocksBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.vision.v1p2beta1.Page result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.property_ = propertyBuilder_ == null ? property_ : propertyBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.width_ = width_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.height_ = height_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.confidence_ = confidence_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1p2beta1.Page) {
        return mergeFrom((com.google.cloud.vision.v1p2beta1.Page) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1p2beta1.Page other) {
      if (other == com.google.cloud.vision.v1p2beta1.Page.getDefaultInstance()) return this;
      if (other.hasProperty()) {
        mergeProperty(other.getProperty());
      }
      if (other.getWidth() != 0) {
        setWidth(other.getWidth());
      }
      if (other.getHeight() != 0) {
        setHeight(other.getHeight());
      }
      if (blocksBuilder_ == null) {
        if (!other.blocks_.isEmpty()) {
          if (blocks_.isEmpty()) {
            blocks_ = other.blocks_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureBlocksIsMutable();
            blocks_.addAll(other.blocks_);
          }
          onChanged();
        }
      } else {
        if (!other.blocks_.isEmpty()) {
          if (blocksBuilder_.isEmpty()) {
            blocksBuilder_.dispose();
            blocksBuilder_ = null;
            blocks_ = other.blocks_;
            bitField0_ = (bitField0_ & ~0x00000008);
            blocksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBlocksFieldBuilder()
                    : null;
          } else {
            blocksBuilder_.addAllMessages(other.blocks_);
          }
        }
      }
      if (other.getConfidence() != 0F) {
        setConfidence(other.getConfidence());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getPropertyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                width_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                height_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.cloud.vision.v1p2beta1.Block m =
                    input.readMessage(
                        com.google.cloud.vision.v1p2beta1.Block.parser(), extensionRegistry);
                if (blocksBuilder_ == null) {
                  ensureBlocksIsMutable();
                  blocks_.add(m);
                } else {
                  blocksBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 45:
              {
                confidence_ = input.readFloat();
                bitField0_ |= 0x00000010;
                break;
              } // case 45
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty property_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty,
            com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty.Builder,
            com.google.cloud.vision.v1p2beta1.TextAnnotation.TextPropertyOrBuilder>
        propertyBuilder_;
    /**
     *
     *
     * <pre>
     * Additional information detected on the page.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty property = 1;</code>
     *
     * @return Whether the property field is set.
     */
    public boolean hasProperty() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Additional information detected on the page.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty property = 1;</code>
     *
     * @return The property.
     */
    public com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty getProperty() {
      if (propertyBuilder_ == null) {
        return property_ == null
            ? com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty.getDefaultInstance()
            : property_;
      } else {
        return propertyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information detected on the page.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public Builder setProperty(
        com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty value) {
      if (propertyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        property_ = value;
      } else {
        propertyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information detected on the page.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public Builder setProperty(
        com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty.Builder builderForValue) {
      if (propertyBuilder_ == null) {
        property_ = builderForValue.build();
      } else {
        propertyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information detected on the page.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public Builder mergeProperty(
        com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty value) {
      if (propertyBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && property_ != null
            && property_
                != com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty
                    .getDefaultInstance()) {
          getPropertyBuilder().mergeFrom(value);
        } else {
          property_ = value;
        }
      } else {
        propertyBuilder_.mergeFrom(value);
      }
      if (property_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information detected on the page.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public Builder clearProperty() {
      bitField0_ = (bitField0_ & ~0x00000001);
      property_ = null;
      if (propertyBuilder_ != null) {
        propertyBuilder_.dispose();
        propertyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information detected on the page.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty.Builder
        getPropertyBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getPropertyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional information detected on the page.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public com.google.cloud.vision.v1p2beta1.TextAnnotation.TextPropertyOrBuilder
        getPropertyOrBuilder() {
      if (propertyBuilder_ != null) {
        return propertyBuilder_.getMessageOrBuilder();
      } else {
        return property_ == null
            ? com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty.getDefaultInstance()
            : property_;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information detected on the page.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty,
            com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty.Builder,
            com.google.cloud.vision.v1p2beta1.TextAnnotation.TextPropertyOrBuilder>
        getPropertyFieldBuilder() {
      if (propertyBuilder_ == null) {
        propertyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty,
                com.google.cloud.vision.v1p2beta1.TextAnnotation.TextProperty.Builder,
                com.google.cloud.vision.v1p2beta1.TextAnnotation.TextPropertyOrBuilder>(
                getProperty(), getParentForChildren(), isClean());
        property_ = null;
      }
      return propertyBuilder_;
    }

    private int width_;
    /**
     *
     *
     * <pre>
     * Page width. For PDFs the unit is points. For images (including
     * TIFFs) the unit is pixels.
     * </pre>
     *
     * <code>int32 width = 2;</code>
     *
     * @return The width.
     */
    @java.lang.Override
    public int getWidth() {
      return width_;
    }
    /**
     *
     *
     * <pre>
     * Page width. For PDFs the unit is points. For images (including
     * TIFFs) the unit is pixels.
     * </pre>
     *
     * <code>int32 width = 2;</code>
     *
     * @param value The width to set.
     * @return This builder for chaining.
     */
    public Builder setWidth(int value) {

      width_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Page width. For PDFs the unit is points. For images (including
     * TIFFs) the unit is pixels.
     * </pre>
     *
     * <code>int32 width = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWidth() {
      bitField0_ = (bitField0_ & ~0x00000002);
      width_ = 0;
      onChanged();
      return this;
    }

    private int height_;
    /**
     *
     *
     * <pre>
     * Page height. For PDFs the unit is points. For images (including
     * TIFFs) the unit is pixels.
     * </pre>
     *
     * <code>int32 height = 3;</code>
     *
     * @return The height.
     */
    @java.lang.Override
    public int getHeight() {
      return height_;
    }
    /**
     *
     *
     * <pre>
     * Page height. For PDFs the unit is points. For images (including
     * TIFFs) the unit is pixels.
     * </pre>
     *
     * <code>int32 height = 3;</code>
     *
     * @param value The height to set.
     * @return This builder for chaining.
     */
    public Builder setHeight(int value) {

      height_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Page height. For PDFs the unit is points. For images (including
     * TIFFs) the unit is pixels.
     * </pre>
     *
     * <code>int32 height = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHeight() {
      bitField0_ = (bitField0_ & ~0x00000004);
      height_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.vision.v1p2beta1.Block> blocks_ =
        java.util.Collections.emptyList();

    private void ensureBlocksIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        blocks_ = new java.util.ArrayList<com.google.cloud.vision.v1p2beta1.Block>(blocks_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.Block,
            com.google.cloud.vision.v1p2beta1.Block.Builder,
            com.google.cloud.vision.v1p2beta1.BlockOrBuilder>
        blocksBuilder_;

    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.Block> getBlocksList() {
      if (blocksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(blocks_);
      } else {
        return blocksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public int getBlocksCount() {
      if (blocksBuilder_ == null) {
        return blocks_.size();
      } else {
        return blocksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public com.google.cloud.vision.v1p2beta1.Block getBlocks(int index) {
      if (blocksBuilder_ == null) {
        return blocks_.get(index);
      } else {
        return blocksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public Builder setBlocks(int index, com.google.cloud.vision.v1p2beta1.Block value) {
      if (blocksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBlocksIsMutable();
        blocks_.set(index, value);
        onChanged();
      } else {
        blocksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public Builder setBlocks(
        int index, com.google.cloud.vision.v1p2beta1.Block.Builder builderForValue) {
      if (blocksBuilder_ == null) {
        ensureBlocksIsMutable();
        blocks_.set(index, builderForValue.build());
        onChanged();
      } else {
        blocksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public Builder addBlocks(com.google.cloud.vision.v1p2beta1.Block value) {
      if (blocksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBlocksIsMutable();
        blocks_.add(value);
        onChanged();
      } else {
        blocksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public Builder addBlocks(int index, com.google.cloud.vision.v1p2beta1.Block value) {
      if (blocksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBlocksIsMutable();
        blocks_.add(index, value);
        onChanged();
      } else {
        blocksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public Builder addBlocks(com.google.cloud.vision.v1p2beta1.Block.Builder builderForValue) {
      if (blocksBuilder_ == null) {
        ensureBlocksIsMutable();
        blocks_.add(builderForValue.build());
        onChanged();
      } else {
        blocksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public Builder addBlocks(
        int index, com.google.cloud.vision.v1p2beta1.Block.Builder builderForValue) {
      if (blocksBuilder_ == null) {
        ensureBlocksIsMutable();
        blocks_.add(index, builderForValue.build());
        onChanged();
      } else {
        blocksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public Builder addAllBlocks(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p2beta1.Block> values) {
      if (blocksBuilder_ == null) {
        ensureBlocksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, blocks_);
        onChanged();
      } else {
        blocksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public Builder clearBlocks() {
      if (blocksBuilder_ == null) {
        blocks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        blocksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public Builder removeBlocks(int index) {
      if (blocksBuilder_ == null) {
        ensureBlocksIsMutable();
        blocks_.remove(index);
        onChanged();
      } else {
        blocksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public com.google.cloud.vision.v1p2beta1.Block.Builder getBlocksBuilder(int index) {
      return getBlocksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public com.google.cloud.vision.v1p2beta1.BlockOrBuilder getBlocksOrBuilder(int index) {
      if (blocksBuilder_ == null) {
        return blocks_.get(index);
      } else {
        return blocksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1p2beta1.BlockOrBuilder>
        getBlocksOrBuilderList() {
      if (blocksBuilder_ != null) {
        return blocksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(blocks_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public com.google.cloud.vision.v1p2beta1.Block.Builder addBlocksBuilder() {
      return getBlocksFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p2beta1.Block.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public com.google.cloud.vision.v1p2beta1.Block.Builder addBlocksBuilder(int index) {
      return getBlocksFieldBuilder()
          .addBuilder(index, com.google.cloud.vision.v1p2beta1.Block.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of blocks of text, images etc on this page.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p2beta1.Block blocks = 4;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p2beta1.Block.Builder> getBlocksBuilderList() {
      return getBlocksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p2beta1.Block,
            com.google.cloud.vision.v1p2beta1.Block.Builder,
            com.google.cloud.vision.v1p2beta1.BlockOrBuilder>
        getBlocksFieldBuilder() {
      if (blocksBuilder_ == null) {
        blocksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p2beta1.Block,
                com.google.cloud.vision.v1p2beta1.Block.Builder,
                com.google.cloud.vision.v1p2beta1.BlockOrBuilder>(
                blocks_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        blocks_ = null;
      }
      return blocksBuilder_;
    }

    private float confidence_;
    /**
     *
     *
     * <pre>
     * Confidence of the OCR results on the page. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 5;</code>
     *
     * @return The confidence.
     */
    @java.lang.Override
    public float getConfidence() {
      return confidence_;
    }
    /**
     *
     *
     * <pre>
     * Confidence of the OCR results on the page. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 5;</code>
     *
     * @param value The confidence to set.
     * @return This builder for chaining.
     */
    public Builder setConfidence(float value) {

      confidence_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Confidence of the OCR results on the page. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfidence() {
      bitField0_ = (bitField0_ & ~0x00000010);
      confidence_ = 0F;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p2beta1.Page)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p2beta1.Page)
  private static final com.google.cloud.vision.v1p2beta1.Page DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1p2beta1.Page();
  }

  public static com.google.cloud.vision.v1p2beta1.Page getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Page> PARSER =
      new com.google.protobuf.AbstractParser<Page>() {
        @java.lang.Override
        public Page parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Page> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Page> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1p2beta1.Page getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
