/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1p3beta1/product_search.proto

package com.google.cloud.vision.v1p3beta1;

/**
 *
 *
 * <pre>
 * Parameters for a product search request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1p3beta1.ProductSearchParams}
 */
public final class ProductSearchParams extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p3beta1.ProductSearchParams)
    ProductSearchParamsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ProductSearchParams.newBuilder() to construct.
  private ProductSearchParams(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ProductSearchParams() {
    productSet_ = "";
    productCategories_ = com.google.protobuf.LazyStringArrayList.emptyList();
    filter_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ProductSearchParams();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1p3beta1.ProductSearchProto
        .internal_static_google_cloud_vision_v1p3beta1_ProductSearchParams_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1p3beta1.ProductSearchProto
        .internal_static_google_cloud_vision_v1p3beta1_ProductSearchParams_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1p3beta1.ProductSearchParams.class,
            com.google.cloud.vision.v1p3beta1.ProductSearchParams.Builder.class);
  }

  public static final int BOUNDING_POLY_FIELD_NUMBER = 9;
  private com.google.cloud.vision.v1p3beta1.BoundingPoly boundingPoly_;
  /**
   *
   *
   * <pre>
   * The bounding polygon around the area of interest in the image.
   * If it is not specified, system discretion will be applied.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
   *
   * @return Whether the boundingPoly field is set.
   */
  @java.lang.Override
  public boolean hasBoundingPoly() {
    return boundingPoly_ != null;
  }
  /**
   *
   *
   * <pre>
   * The bounding polygon around the area of interest in the image.
   * If it is not specified, system discretion will be applied.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
   *
   * @return The boundingPoly.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.BoundingPoly getBoundingPoly() {
    return boundingPoly_ == null
        ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
        : boundingPoly_;
  }
  /**
   *
   *
   * <pre>
   * The bounding polygon around the area of interest in the image.
   * If it is not specified, system discretion will be applied.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder() {
    return boundingPoly_ == null
        ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
        : boundingPoly_;
  }

  public static final int PRODUCT_SET_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object productSet_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of a [ProductSet][google.cloud.vision.v1p3beta1.ProductSet] to be searched for similar images.
   *
   * Format is:
   * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
   * </pre>
   *
   * <code>string product_set = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The productSet.
   */
  @java.lang.Override
  public java.lang.String getProductSet() {
    java.lang.Object ref = productSet_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      productSet_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of a [ProductSet][google.cloud.vision.v1p3beta1.ProductSet] to be searched for similar images.
   *
   * Format is:
   * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
   * </pre>
   *
   * <code>string product_set = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for productSet.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProductSetBytes() {
    java.lang.Object ref = productSet_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      productSet_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRODUCT_CATEGORIES_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList productCategories_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The list of product categories to search in. Currently, we only consider
   * the first category, and either "homegoods-v2", "apparel-v2", "toys-v2",
   * "packagedgoods-v1", or "general-v1" should be specified. The legacy
   * categories "homegoods", "apparel", and "toys" are still supported but will
   * be deprecated. For new products, please use "homegoods-v2", "apparel-v2",
   * or "toys-v2" for better product search accuracy. It is recommended to
   * migrate existing products to these categories as well.
   * </pre>
   *
   * <code>repeated string product_categories = 7;</code>
   *
   * @return A list containing the productCategories.
   */
  public com.google.protobuf.ProtocolStringList getProductCategoriesList() {
    return productCategories_;
  }
  /**
   *
   *
   * <pre>
   * The list of product categories to search in. Currently, we only consider
   * the first category, and either "homegoods-v2", "apparel-v2", "toys-v2",
   * "packagedgoods-v1", or "general-v1" should be specified. The legacy
   * categories "homegoods", "apparel", and "toys" are still supported but will
   * be deprecated. For new products, please use "homegoods-v2", "apparel-v2",
   * or "toys-v2" for better product search accuracy. It is recommended to
   * migrate existing products to these categories as well.
   * </pre>
   *
   * <code>repeated string product_categories = 7;</code>
   *
   * @return The count of productCategories.
   */
  public int getProductCategoriesCount() {
    return productCategories_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of product categories to search in. Currently, we only consider
   * the first category, and either "homegoods-v2", "apparel-v2", "toys-v2",
   * "packagedgoods-v1", or "general-v1" should be specified. The legacy
   * categories "homegoods", "apparel", and "toys" are still supported but will
   * be deprecated. For new products, please use "homegoods-v2", "apparel-v2",
   * or "toys-v2" for better product search accuracy. It is recommended to
   * migrate existing products to these categories as well.
   * </pre>
   *
   * <code>repeated string product_categories = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The productCategories at the given index.
   */
  public java.lang.String getProductCategories(int index) {
    return productCategories_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of product categories to search in. Currently, we only consider
   * the first category, and either "homegoods-v2", "apparel-v2", "toys-v2",
   * "packagedgoods-v1", or "general-v1" should be specified. The legacy
   * categories "homegoods", "apparel", and "toys" are still supported but will
   * be deprecated. For new products, please use "homegoods-v2", "apparel-v2",
   * or "toys-v2" for better product search accuracy. It is recommended to
   * migrate existing products to these categories as well.
   * </pre>
   *
   * <code>repeated string product_categories = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the productCategories at the given index.
   */
  public com.google.protobuf.ByteString getProductCategoriesBytes(int index) {
    return productCategories_.getByteString(index);
  }

  public static final int FILTER_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * The filtering expression. This can be used to restrict search results based
   * on Product labels. We currently support an AND of OR of key-value
   * expressions, where each expression within an OR must have the same key. An
   * '=' should be used to connect the key and value.
   *
   * For example, "(color = red OR color = blue) AND brand = Google" is
   * acceptable, but "(color = red OR brand = Google)" is not acceptable.
   * "color: red" is not acceptable because it uses a ':' instead of an '='.
   * </pre>
   *
   * <code>string filter = 8;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The filtering expression. This can be used to restrict search results based
   * on Product labels. We currently support an AND of OR of key-value
   * expressions, where each expression within an OR must have the same key. An
   * '=' should be used to connect the key and value.
   *
   * For example, "(color = red OR color = blue) AND brand = Google" is
   * acceptable, but "(color = red OR brand = Google)" is not acceptable.
   * "color: red" is not acceptable because it uses a ':' instead of an '='.
   * </pre>
   *
   * <code>string filter = 8;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(productSet_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, productSet_);
    }
    for (int i = 0; i < productCategories_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, productCategories_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, filter_);
    }
    if (boundingPoly_ != null) {
      output.writeMessage(9, getBoundingPoly());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(productSet_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, productSet_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < productCategories_.size(); i++) {
        dataSize += computeStringSizeNoTag(productCategories_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getProductCategoriesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, filter_);
    }
    if (boundingPoly_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getBoundingPoly());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1p3beta1.ProductSearchParams)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1p3beta1.ProductSearchParams other =
        (com.google.cloud.vision.v1p3beta1.ProductSearchParams) obj;

    if (hasBoundingPoly() != other.hasBoundingPoly()) return false;
    if (hasBoundingPoly()) {
      if (!getBoundingPoly().equals(other.getBoundingPoly())) return false;
    }
    if (!getProductSet().equals(other.getProductSet())) return false;
    if (!getProductCategoriesList().equals(other.getProductCategoriesList())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBoundingPoly()) {
      hash = (37 * hash) + BOUNDING_POLY_FIELD_NUMBER;
      hash = (53 * hash) + getBoundingPoly().hashCode();
    }
    hash = (37 * hash) + PRODUCT_SET_FIELD_NUMBER;
    hash = (53 * hash) + getProductSet().hashCode();
    if (getProductCategoriesCount() > 0) {
      hash = (37 * hash) + PRODUCT_CATEGORIES_FIELD_NUMBER;
      hash = (53 * hash) + getProductCategoriesList().hashCode();
    }
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.vision.v1p3beta1.ProductSearchParams prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Parameters for a product search request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p3beta1.ProductSearchParams}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p3beta1.ProductSearchParams)
      com.google.cloud.vision.v1p3beta1.ProductSearchParamsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchProto
          .internal_static_google_cloud_vision_v1p3beta1_ProductSearchParams_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchProto
          .internal_static_google_cloud_vision_v1p3beta1_ProductSearchParams_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p3beta1.ProductSearchParams.class,
              com.google.cloud.vision.v1p3beta1.ProductSearchParams.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1p3beta1.ProductSearchParams.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      boundingPoly_ = null;
      if (boundingPolyBuilder_ != null) {
        boundingPolyBuilder_.dispose();
        boundingPolyBuilder_ = null;
      }
      productSet_ = "";
      productCategories_ = com.google.protobuf.LazyStringArrayList.emptyList();
      filter_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchProto
          .internal_static_google_cloud_vision_v1p3beta1_ProductSearchParams_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ProductSearchParams getDefaultInstanceForType() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchParams.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ProductSearchParams build() {
      com.google.cloud.vision.v1p3beta1.ProductSearchParams result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ProductSearchParams buildPartial() {
      com.google.cloud.vision.v1p3beta1.ProductSearchParams result =
          new com.google.cloud.vision.v1p3beta1.ProductSearchParams(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.vision.v1p3beta1.ProductSearchParams result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.boundingPoly_ =
            boundingPolyBuilder_ == null ? boundingPoly_ : boundingPolyBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.productSet_ = productSet_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        productCategories_.makeImmutable();
        result.productCategories_ = productCategories_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.filter_ = filter_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1p3beta1.ProductSearchParams) {
        return mergeFrom((com.google.cloud.vision.v1p3beta1.ProductSearchParams) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1p3beta1.ProductSearchParams other) {
      if (other == com.google.cloud.vision.v1p3beta1.ProductSearchParams.getDefaultInstance())
        return this;
      if (other.hasBoundingPoly()) {
        mergeBoundingPoly(other.getBoundingPoly());
      }
      if (!other.getProductSet().isEmpty()) {
        productSet_ = other.productSet_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.productCategories_.isEmpty()) {
        if (productCategories_.isEmpty()) {
          productCategories_ = other.productCategories_;
          bitField0_ |= 0x00000004;
        } else {
          ensureProductCategoriesIsMutable();
          productCategories_.addAll(other.productCategories_);
        }
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 50:
              {
                productSet_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 50
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureProductCategoriesIsMutable();
                productCategories_.add(s);
                break;
              } // case 58
            case 66:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getBoundingPolyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.vision.v1p3beta1.BoundingPoly boundingPoly_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.BoundingPoly,
            com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>
        boundingPolyBuilder_;
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     *
     * @return Whether the boundingPoly field is set.
     */
    public boolean hasBoundingPoly() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     *
     * @return The boundingPoly.
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPoly getBoundingPoly() {
      if (boundingPolyBuilder_ == null) {
        return boundingPoly_ == null
            ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
            : boundingPoly_;
      } else {
        return boundingPolyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     */
    public Builder setBoundingPoly(com.google.cloud.vision.v1p3beta1.BoundingPoly value) {
      if (boundingPolyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        boundingPoly_ = value;
      } else {
        boundingPolyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     */
    public Builder setBoundingPoly(
        com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder builderForValue) {
      if (boundingPolyBuilder_ == null) {
        boundingPoly_ = builderForValue.build();
      } else {
        boundingPolyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     */
    public Builder mergeBoundingPoly(com.google.cloud.vision.v1p3beta1.BoundingPoly value) {
      if (boundingPolyBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && boundingPoly_ != null
            && boundingPoly_
                != com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()) {
          getBoundingPolyBuilder().mergeFrom(value);
        } else {
          boundingPoly_ = value;
        }
      } else {
        boundingPolyBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     */
    public Builder clearBoundingPoly() {
      bitField0_ = (bitField0_ & ~0x00000001);
      boundingPoly_ = null;
      if (boundingPolyBuilder_ != null) {
        boundingPolyBuilder_.dispose();
        boundingPolyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder getBoundingPolyBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getBoundingPolyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder() {
      if (boundingPolyBuilder_ != null) {
        return boundingPolyBuilder_.getMessageOrBuilder();
      } else {
        return boundingPoly_ == null
            ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
            : boundingPoly_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bounding polygon around the area of interest in the image.
     * If it is not specified, system discretion will be applied.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.BoundingPoly,
            com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>
        getBoundingPolyFieldBuilder() {
      if (boundingPolyBuilder_ == null) {
        boundingPolyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.BoundingPoly,
                com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
                com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>(
                getBoundingPoly(), getParentForChildren(), isClean());
        boundingPoly_ = null;
      }
      return boundingPolyBuilder_;
    }

    private java.lang.Object productSet_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of a [ProductSet][google.cloud.vision.v1p3beta1.ProductSet] to be searched for similar images.
     *
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
     * </pre>
     *
     * <code>string product_set = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The productSet.
     */
    public java.lang.String getProductSet() {
      java.lang.Object ref = productSet_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        productSet_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of a [ProductSet][google.cloud.vision.v1p3beta1.ProductSet] to be searched for similar images.
     *
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
     * </pre>
     *
     * <code>string product_set = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for productSet.
     */
    public com.google.protobuf.ByteString getProductSetBytes() {
      java.lang.Object ref = productSet_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        productSet_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of a [ProductSet][google.cloud.vision.v1p3beta1.ProductSet] to be searched for similar images.
     *
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
     * </pre>
     *
     * <code>string product_set = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The productSet to set.
     * @return This builder for chaining.
     */
    public Builder setProductSet(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      productSet_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of a [ProductSet][google.cloud.vision.v1p3beta1.ProductSet] to be searched for similar images.
     *
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
     * </pre>
     *
     * <code>string product_set = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProductSet() {
      productSet_ = getDefaultInstance().getProductSet();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of a [ProductSet][google.cloud.vision.v1p3beta1.ProductSet] to be searched for similar images.
     *
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/productSets/PRODUCT_SET_ID`.
     * </pre>
     *
     * <code>string product_set = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for productSet to set.
     * @return This builder for chaining.
     */
    public Builder setProductSetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      productSet_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList productCategories_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureProductCategoriesIsMutable() {
      if (!productCategories_.isModifiable()) {
        productCategories_ = new com.google.protobuf.LazyStringArrayList(productCategories_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods-v2", "apparel-v2", "toys-v2",
     * "packagedgoods-v1", or "general-v1" should be specified. The legacy
     * categories "homegoods", "apparel", and "toys" are still supported but will
     * be deprecated. For new products, please use "homegoods-v2", "apparel-v2",
     * or "toys-v2" for better product search accuracy. It is recommended to
     * migrate existing products to these categories as well.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     *
     * @return A list containing the productCategories.
     */
    public com.google.protobuf.ProtocolStringList getProductCategoriesList() {
      productCategories_.makeImmutable();
      return productCategories_;
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods-v2", "apparel-v2", "toys-v2",
     * "packagedgoods-v1", or "general-v1" should be specified. The legacy
     * categories "homegoods", "apparel", and "toys" are still supported but will
     * be deprecated. For new products, please use "homegoods-v2", "apparel-v2",
     * or "toys-v2" for better product search accuracy. It is recommended to
     * migrate existing products to these categories as well.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     *
     * @return The count of productCategories.
     */
    public int getProductCategoriesCount() {
      return productCategories_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods-v2", "apparel-v2", "toys-v2",
     * "packagedgoods-v1", or "general-v1" should be specified. The legacy
     * categories "homegoods", "apparel", and "toys" are still supported but will
     * be deprecated. For new products, please use "homegoods-v2", "apparel-v2",
     * or "toys-v2" for better product search accuracy. It is recommended to
     * migrate existing products to these categories as well.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The productCategories at the given index.
     */
    public java.lang.String getProductCategories(int index) {
      return productCategories_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods-v2", "apparel-v2", "toys-v2",
     * "packagedgoods-v1", or "general-v1" should be specified. The legacy
     * categories "homegoods", "apparel", and "toys" are still supported but will
     * be deprecated. For new products, please use "homegoods-v2", "apparel-v2",
     * or "toys-v2" for better product search accuracy. It is recommended to
     * migrate existing products to these categories as well.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the productCategories at the given index.
     */
    public com.google.protobuf.ByteString getProductCategoriesBytes(int index) {
      return productCategories_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods-v2", "apparel-v2", "toys-v2",
     * "packagedgoods-v1", or "general-v1" should be specified. The legacy
     * categories "homegoods", "apparel", and "toys" are still supported but will
     * be deprecated. For new products, please use "homegoods-v2", "apparel-v2",
     * or "toys-v2" for better product search accuracy. It is recommended to
     * migrate existing products to these categories as well.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The productCategories to set.
     * @return This builder for chaining.
     */
    public Builder setProductCategories(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureProductCategoriesIsMutable();
      productCategories_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods-v2", "apparel-v2", "toys-v2",
     * "packagedgoods-v1", or "general-v1" should be specified. The legacy
     * categories "homegoods", "apparel", and "toys" are still supported but will
     * be deprecated. For new products, please use "homegoods-v2", "apparel-v2",
     * or "toys-v2" for better product search accuracy. It is recommended to
     * migrate existing products to these categories as well.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     *
     * @param value The productCategories to add.
     * @return This builder for chaining.
     */
    public Builder addProductCategories(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureProductCategoriesIsMutable();
      productCategories_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods-v2", "apparel-v2", "toys-v2",
     * "packagedgoods-v1", or "general-v1" should be specified. The legacy
     * categories "homegoods", "apparel", and "toys" are still supported but will
     * be deprecated. For new products, please use "homegoods-v2", "apparel-v2",
     * or "toys-v2" for better product search accuracy. It is recommended to
     * migrate existing products to these categories as well.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     *
     * @param values The productCategories to add.
     * @return This builder for chaining.
     */
    public Builder addAllProductCategories(java.lang.Iterable<java.lang.String> values) {
      ensureProductCategoriesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, productCategories_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods-v2", "apparel-v2", "toys-v2",
     * "packagedgoods-v1", or "general-v1" should be specified. The legacy
     * categories "homegoods", "apparel", and "toys" are still supported but will
     * be deprecated. For new products, please use "homegoods-v2", "apparel-v2",
     * or "toys-v2" for better product search accuracy. It is recommended to
     * migrate existing products to these categories as well.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProductCategories() {
      productCategories_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of product categories to search in. Currently, we only consider
     * the first category, and either "homegoods-v2", "apparel-v2", "toys-v2",
     * "packagedgoods-v1", or "general-v1" should be specified. The legacy
     * categories "homegoods", "apparel", and "toys" are still supported but will
     * be deprecated. For new products, please use "homegoods-v2", "apparel-v2",
     * or "toys-v2" for better product search accuracy. It is recommended to
     * migrate existing products to these categories as well.
     * </pre>
     *
     * <code>repeated string product_categories = 7;</code>
     *
     * @param value The bytes of the productCategories to add.
     * @return This builder for chaining.
     */
    public Builder addProductCategoriesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureProductCategoriesIsMutable();
      productCategories_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * The filtering expression. This can be used to restrict search results based
     * on Product labels. We currently support an AND of OR of key-value
     * expressions, where each expression within an OR must have the same key. An
     * '=' should be used to connect the key and value.
     *
     * For example, "(color = red OR color = blue) AND brand = Google" is
     * acceptable, but "(color = red OR brand = Google)" is not acceptable.
     * "color: red" is not acceptable because it uses a ':' instead of an '='.
     * </pre>
     *
     * <code>string filter = 8;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The filtering expression. This can be used to restrict search results based
     * on Product labels. We currently support an AND of OR of key-value
     * expressions, where each expression within an OR must have the same key. An
     * '=' should be used to connect the key and value.
     *
     * For example, "(color = red OR color = blue) AND brand = Google" is
     * acceptable, but "(color = red OR brand = Google)" is not acceptable.
     * "color: red" is not acceptable because it uses a ':' instead of an '='.
     * </pre>
     *
     * <code>string filter = 8;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The filtering expression. This can be used to restrict search results based
     * on Product labels. We currently support an AND of OR of key-value
     * expressions, where each expression within an OR must have the same key. An
     * '=' should be used to connect the key and value.
     *
     * For example, "(color = red OR color = blue) AND brand = Google" is
     * acceptable, but "(color = red OR brand = Google)" is not acceptable.
     * "color: red" is not acceptable because it uses a ':' instead of an '='.
     * </pre>
     *
     * <code>string filter = 8;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filtering expression. This can be used to restrict search results based
     * on Product labels. We currently support an AND of OR of key-value
     * expressions, where each expression within an OR must have the same key. An
     * '=' should be used to connect the key and value.
     *
     * For example, "(color = red OR color = blue) AND brand = Google" is
     * acceptable, but "(color = red OR brand = Google)" is not acceptable.
     * "color: red" is not acceptable because it uses a ':' instead of an '='.
     * </pre>
     *
     * <code>string filter = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filtering expression. This can be used to restrict search results based
     * on Product labels. We currently support an AND of OR of key-value
     * expressions, where each expression within an OR must have the same key. An
     * '=' should be used to connect the key and value.
     *
     * For example, "(color = red OR color = blue) AND brand = Google" is
     * acceptable, but "(color = red OR brand = Google)" is not acceptable.
     * "color: red" is not acceptable because it uses a ':' instead of an '='.
     * </pre>
     *
     * <code>string filter = 8;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p3beta1.ProductSearchParams)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p3beta1.ProductSearchParams)
  private static final com.google.cloud.vision.v1p3beta1.ProductSearchParams DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1p3beta1.ProductSearchParams();
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchParams getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProductSearchParams> PARSER =
      new com.google.protobuf.AbstractParser<ProductSearchParams>() {
        @java.lang.Override
        public ProductSearchParams parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ProductSearchParams> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProductSearchParams> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.ProductSearchParams getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
