/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1p3beta1/product_search_service.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.vision.v1p3beta1;

/**
 *
 *
 * <pre>
 * A Product contains ReferenceImages.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1p3beta1.Product}
 */
public final class Product extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p3beta1.Product)
    ProductOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Product.newBuilder() to construct.
  private Product(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Product() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    productCategory_ = "";
    productLabels_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Product();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1p3beta1.ProductSearchServiceProto
        .internal_static_google_cloud_vision_v1p3beta1_Product_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1p3beta1.ProductSearchServiceProto
        .internal_static_google_cloud_vision_v1p3beta1_Product_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1p3beta1.Product.class,
            com.google.cloud.vision.v1p3beta1.Product.Builder.class);
  }

  public interface KeyValueOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.vision.v1p3beta1.Product.KeyValue)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The key of the label attached to the product. Cannot be empty and cannot
     * exceed 128 bytes.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    java.lang.String getKey();
    /**
     *
     *
     * <pre>
     * The key of the label attached to the product. Cannot be empty and cannot
     * exceed 128 bytes.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    com.google.protobuf.ByteString getKeyBytes();

    /**
     *
     *
     * <pre>
     * The value of the label attached to the product. Cannot be empty and
     * cannot exceed 128 bytes.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The value.
     */
    java.lang.String getValue();
    /**
     *
     *
     * <pre>
     * The value of the label attached to the product. Cannot be empty and
     * cannot exceed 128 bytes.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString getValueBytes();
  }
  /**
   *
   *
   * <pre>
   * A product label represented as a key-value pair.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p3beta1.Product.KeyValue}
   */
  public static final class KeyValue extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p3beta1.Product.KeyValue)
      KeyValueOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use KeyValue.newBuilder() to construct.
    private KeyValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private KeyValue() {
      key_ = "";
      value_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new KeyValue();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchServiceProto
          .internal_static_google_cloud_vision_v1p3beta1_Product_KeyValue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchServiceProto
          .internal_static_google_cloud_vision_v1p3beta1_Product_KeyValue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p3beta1.Product.KeyValue.class,
              com.google.cloud.vision.v1p3beta1.Product.KeyValue.Builder.class);
    }

    public static final int KEY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object key_ = "";
    /**
     *
     *
     * <pre>
     * The key of the label attached to the product. Cannot be empty and cannot
     * exceed 128 bytes.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    @java.lang.Override
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The key of the label attached to the product. Cannot be empty and cannot
     * exceed 128 bytes.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object value_ = "";
    /**
     *
     *
     * <pre>
     * The value of the label attached to the product. Cannot be empty and
     * cannot exceed 128 bytes.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The value of the label attached to the product. Cannot be empty and
     * cannot exceed 128 bytes.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.vision.v1p3beta1.Product.KeyValue)) {
        return super.equals(obj);
      }
      com.google.cloud.vision.v1p3beta1.Product.KeyValue other =
          (com.google.cloud.vision.v1p3beta1.Product.KeyValue) obj;

      if (!getKey().equals(other.getKey())) return false;
      if (!getValue().equals(other.getValue())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKey().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.vision.v1p3beta1.Product.KeyValue parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p3beta1.Product.KeyValue parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.Product.KeyValue parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p3beta1.Product.KeyValue parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.Product.KeyValue parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p3beta1.Product.KeyValue parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.Product.KeyValue parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p3beta1.Product.KeyValue parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.Product.KeyValue parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p3beta1.Product.KeyValue parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.Product.KeyValue parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p3beta1.Product.KeyValue parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.vision.v1p3beta1.Product.KeyValue prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A product label represented as a key-value pair.
     * </pre>
     *
     * Protobuf type {@code google.cloud.vision.v1p3beta1.Product.KeyValue}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p3beta1.Product.KeyValue)
        com.google.cloud.vision.v1p3beta1.Product.KeyValueOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.vision.v1p3beta1.ProductSearchServiceProto
            .internal_static_google_cloud_vision_v1p3beta1_Product_KeyValue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.vision.v1p3beta1.ProductSearchServiceProto
            .internal_static_google_cloud_vision_v1p3beta1_Product_KeyValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.vision.v1p3beta1.Product.KeyValue.class,
                com.google.cloud.vision.v1p3beta1.Product.KeyValue.Builder.class);
      }

      // Construct using com.google.cloud.vision.v1p3beta1.Product.KeyValue.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        key_ = "";
        value_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.vision.v1p3beta1.ProductSearchServiceProto
            .internal_static_google_cloud_vision_v1p3beta1_Product_KeyValue_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p3beta1.Product.KeyValue getDefaultInstanceForType() {
        return com.google.cloud.vision.v1p3beta1.Product.KeyValue.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p3beta1.Product.KeyValue build() {
        com.google.cloud.vision.v1p3beta1.Product.KeyValue result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p3beta1.Product.KeyValue buildPartial() {
        com.google.cloud.vision.v1p3beta1.Product.KeyValue result =
            new com.google.cloud.vision.v1p3beta1.Product.KeyValue(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.vision.v1p3beta1.Product.KeyValue result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.key_ = key_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.value_ = value_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.vision.v1p3beta1.Product.KeyValue) {
          return mergeFrom((com.google.cloud.vision.v1p3beta1.Product.KeyValue) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.vision.v1p3beta1.Product.KeyValue other) {
        if (other == com.google.cloud.vision.v1p3beta1.Product.KeyValue.getDefaultInstance())
          return this;
        if (!other.getKey().isEmpty()) {
          key_ = other.key_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getValue().isEmpty()) {
          value_ = other.value_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  key_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  value_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object key_ = "";
      /**
       *
       *
       * <pre>
       * The key of the label attached to the product. Cannot be empty and cannot
       * exceed 128 bytes.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The key.
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The key of the label attached to the product. Cannot be empty and cannot
       * exceed 128 bytes.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The bytes for key.
       */
      public com.google.protobuf.ByteString getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The key of the label attached to the product. Cannot be empty and cannot
       * exceed 128 bytes.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The key to set.
       * @return This builder for chaining.
       */
      public Builder setKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        key_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The key of the label attached to the product. Cannot be empty and cannot
       * exceed 128 bytes.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKey() {
        key_ = getDefaultInstance().getKey();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The key of the label attached to the product. Cannot be empty and cannot
       * exceed 128 bytes.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The bytes for key to set.
       * @return This builder for chaining.
       */
      public Builder setKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        key_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object value_ = "";
      /**
       *
       *
       * <pre>
       * The value of the label attached to the product. Cannot be empty and
       * cannot exceed 128 bytes.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The value of the label attached to the product. Cannot be empty and
       * cannot exceed 128 bytes.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The value of the label attached to the product. Cannot be empty and
       * cannot exceed 128 bytes.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value of the label attached to the product. Cannot be empty and
       * cannot exceed 128 bytes.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        value_ = getDefaultInstance().getValue();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value of the label attached to the product. Cannot be empty and
       * cannot exceed 128 bytes.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        value_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p3beta1.Product.KeyValue)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p3beta1.Product.KeyValue)
    private static final com.google.cloud.vision.v1p3beta1.Product.KeyValue DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.vision.v1p3beta1.Product.KeyValue();
    }

    public static com.google.cloud.vision.v1p3beta1.Product.KeyValue getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<KeyValue> PARSER =
        new com.google.protobuf.AbstractParser<KeyValue>() {
          @java.lang.Override
          public KeyValue parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<KeyValue> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<KeyValue> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.Product.KeyValue getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the product.
   *
   * Format is:
   * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
   *
   * This field is ignored when creating a product.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the product.
   *
   * Format is:
   * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
   *
   * This field is ignored when creating a product.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The user-provided name for this Product. Must not be empty. Must be at most
   * 4096 characters long.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The user-provided name for this Product. Must not be empty. Must be at most
   * 4096 characters long.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * User-provided metadata to be stored with this product. Must be at most 4096
   * characters long.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User-provided metadata to be stored with this product. Must be at most 4096
   * characters long.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRODUCT_CATEGORY_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object productCategory_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The category for the product identified by the reference image. This should
   * be either "homegoods-v2", "apparel-v2", or "toys-v2". The legacy categories
   * "homegoods", "apparel", and "toys" are still supported, but these should
   * not be used for new products.
   * </pre>
   *
   * <code>string product_category = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The productCategory.
   */
  @java.lang.Override
  public java.lang.String getProductCategory() {
    java.lang.Object ref = productCategory_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      productCategory_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The category for the product identified by the reference image. This should
   * be either "homegoods-v2", "apparel-v2", or "toys-v2". The legacy categories
   * "homegoods", "apparel", and "toys" are still supported, but these should
   * not be used for new products.
   * </pre>
   *
   * <code>string product_category = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for productCategory.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProductCategoryBytes() {
    java.lang.Object ref = productCategory_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      productCategory_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRODUCT_LABELS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vision.v1p3beta1.Product.KeyValue> productLabels_;
  /**
   *
   *
   * <pre>
   * Key-value pairs that can be attached to a product. At query time,
   * constraints can be specified based on the product_labels.
   *
   * Note that integer values can be provided as strings, e.g. "1199". Only
   * strings with integer values can match a range-based restriction which is
   * to be supported soon.
   *
   * Multiple values can be assigned to the same key. One product may have up to
   * 100 product_labels.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vision.v1p3beta1.Product.KeyValue> getProductLabelsList() {
    return productLabels_;
  }
  /**
   *
   *
   * <pre>
   * Key-value pairs that can be attached to a product. At query time,
   * constraints can be specified based on the product_labels.
   *
   * Note that integer values can be provided as strings, e.g. "1199". Only
   * strings with integer values can match a range-based restriction which is
   * to be supported soon.
   *
   * Multiple values can be assigned to the same key. One product may have up to
   * 100 product_labels.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vision.v1p3beta1.Product.KeyValueOrBuilder>
      getProductLabelsOrBuilderList() {
    return productLabels_;
  }
  /**
   *
   *
   * <pre>
   * Key-value pairs that can be attached to a product. At query time,
   * constraints can be specified based on the product_labels.
   *
   * Note that integer values can be provided as strings, e.g. "1199". Only
   * strings with integer values can match a range-based restriction which is
   * to be supported soon.
   *
   * Multiple values can be assigned to the same key. One product may have up to
   * 100 product_labels.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
   */
  @java.lang.Override
  public int getProductLabelsCount() {
    return productLabels_.size();
  }
  /**
   *
   *
   * <pre>
   * Key-value pairs that can be attached to a product. At query time,
   * constraints can be specified based on the product_labels.
   *
   * Note that integer values can be provided as strings, e.g. "1199". Only
   * strings with integer values can match a range-based restriction which is
   * to be supported soon.
   *
   * Multiple values can be assigned to the same key. One product may have up to
   * 100 product_labels.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.Product.KeyValue getProductLabels(int index) {
    return productLabels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Key-value pairs that can be attached to a product. At query time,
   * constraints can be specified based on the product_labels.
   *
   * Note that integer values can be provided as strings, e.g. "1199". Only
   * strings with integer values can match a range-based restriction which is
   * to be supported soon.
   *
   * Multiple values can be assigned to the same key. One product may have up to
   * 100 product_labels.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.Product.KeyValueOrBuilder getProductLabelsOrBuilder(
      int index) {
    return productLabels_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(productCategory_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, productCategory_);
    }
    for (int i = 0; i < productLabels_.size(); i++) {
      output.writeMessage(5, productLabels_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(productCategory_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, productCategory_);
    }
    for (int i = 0; i < productLabels_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, productLabels_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1p3beta1.Product)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1p3beta1.Product other =
        (com.google.cloud.vision.v1p3beta1.Product) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getProductCategory().equals(other.getProductCategory())) return false;
    if (!getProductLabelsList().equals(other.getProductLabelsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + PRODUCT_CATEGORY_FIELD_NUMBER;
    hash = (53 * hash) + getProductCategory().hashCode();
    if (getProductLabelsCount() > 0) {
      hash = (37 * hash) + PRODUCT_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + getProductLabelsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1p3beta1.Product parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.Product parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.Product parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.Product parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.Product parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.Product parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.Product parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.Product parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.Product parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.Product parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.Product parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.Product parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vision.v1p3beta1.Product prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Product contains ReferenceImages.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p3beta1.Product}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p3beta1.Product)
      com.google.cloud.vision.v1p3beta1.ProductOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchServiceProto
          .internal_static_google_cloud_vision_v1p3beta1_Product_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchServiceProto
          .internal_static_google_cloud_vision_v1p3beta1_Product_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p3beta1.Product.class,
              com.google.cloud.vision.v1p3beta1.Product.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1p3beta1.Product.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      productCategory_ = "";
      if (productLabelsBuilder_ == null) {
        productLabels_ = java.util.Collections.emptyList();
      } else {
        productLabels_ = null;
        productLabelsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchServiceProto
          .internal_static_google_cloud_vision_v1p3beta1_Product_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.Product getDefaultInstanceForType() {
      return com.google.cloud.vision.v1p3beta1.Product.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.Product build() {
      com.google.cloud.vision.v1p3beta1.Product result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.Product buildPartial() {
      com.google.cloud.vision.v1p3beta1.Product result =
          new com.google.cloud.vision.v1p3beta1.Product(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.vision.v1p3beta1.Product result) {
      if (productLabelsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          productLabels_ = java.util.Collections.unmodifiableList(productLabels_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.productLabels_ = productLabels_;
      } else {
        result.productLabels_ = productLabelsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.vision.v1p3beta1.Product result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.productCategory_ = productCategory_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1p3beta1.Product) {
        return mergeFrom((com.google.cloud.vision.v1p3beta1.Product) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1p3beta1.Product other) {
      if (other == com.google.cloud.vision.v1p3beta1.Product.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getProductCategory().isEmpty()) {
        productCategory_ = other.productCategory_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (productLabelsBuilder_ == null) {
        if (!other.productLabels_.isEmpty()) {
          if (productLabels_.isEmpty()) {
            productLabels_ = other.productLabels_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureProductLabelsIsMutable();
            productLabels_.addAll(other.productLabels_);
          }
          onChanged();
        }
      } else {
        if (!other.productLabels_.isEmpty()) {
          if (productLabelsBuilder_.isEmpty()) {
            productLabelsBuilder_.dispose();
            productLabelsBuilder_ = null;
            productLabels_ = other.productLabels_;
            bitField0_ = (bitField0_ & ~0x00000010);
            productLabelsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getProductLabelsFieldBuilder()
                    : null;
          } else {
            productLabelsBuilder_.addAllMessages(other.productLabels_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                productCategory_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.vision.v1p3beta1.Product.KeyValue m =
                    input.readMessage(
                        com.google.cloud.vision.v1p3beta1.Product.KeyValue.parser(),
                        extensionRegistry);
                if (productLabelsBuilder_ == null) {
                  ensureProductLabelsIsMutable();
                  productLabels_.add(m);
                } else {
                  productLabelsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the product.
     *
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
     *
     * This field is ignored when creating a product.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the product.
     *
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
     *
     * This field is ignored when creating a product.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the product.
     *
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
     *
     * This field is ignored when creating a product.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the product.
     *
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
     *
     * This field is ignored when creating a product.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the product.
     *
     * Format is:
     * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID`.
     *
     * This field is ignored when creating a product.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The user-provided name for this Product. Must not be empty. Must be at most
     * 4096 characters long.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The user-provided name for this Product. Must not be empty. Must be at most
     * 4096 characters long.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The user-provided name for this Product. Must not be empty. Must be at most
     * 4096 characters long.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user-provided name for this Product. Must not be empty. Must be at most
     * 4096 characters long.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user-provided name for this Product. Must not be empty. Must be at most
     * 4096 characters long.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * User-provided metadata to be stored with this product. Must be at most 4096
     * characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-provided metadata to be stored with this product. Must be at most 4096
     * characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-provided metadata to be stored with this product. Must be at most 4096
     * characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided metadata to be stored with this product. Must be at most 4096
     * characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided metadata to be stored with this product. Must be at most 4096
     * characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object productCategory_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The category for the product identified by the reference image. This should
     * be either "homegoods-v2", "apparel-v2", or "toys-v2". The legacy categories
     * "homegoods", "apparel", and "toys" are still supported, but these should
     * not be used for new products.
     * </pre>
     *
     * <code>string product_category = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The productCategory.
     */
    public java.lang.String getProductCategory() {
      java.lang.Object ref = productCategory_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        productCategory_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The category for the product identified by the reference image. This should
     * be either "homegoods-v2", "apparel-v2", or "toys-v2". The legacy categories
     * "homegoods", "apparel", and "toys" are still supported, but these should
     * not be used for new products.
     * </pre>
     *
     * <code>string product_category = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for productCategory.
     */
    public com.google.protobuf.ByteString getProductCategoryBytes() {
      java.lang.Object ref = productCategory_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        productCategory_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The category for the product identified by the reference image. This should
     * be either "homegoods-v2", "apparel-v2", or "toys-v2". The legacy categories
     * "homegoods", "apparel", and "toys" are still supported, but these should
     * not be used for new products.
     * </pre>
     *
     * <code>string product_category = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The productCategory to set.
     * @return This builder for chaining.
     */
    public Builder setProductCategory(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      productCategory_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The category for the product identified by the reference image. This should
     * be either "homegoods-v2", "apparel-v2", or "toys-v2". The legacy categories
     * "homegoods", "apparel", and "toys" are still supported, but these should
     * not be used for new products.
     * </pre>
     *
     * <code>string product_category = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProductCategory() {
      productCategory_ = getDefaultInstance().getProductCategory();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The category for the product identified by the reference image. This should
     * be either "homegoods-v2", "apparel-v2", or "toys-v2". The legacy categories
     * "homegoods", "apparel", and "toys" are still supported, but these should
     * not be used for new products.
     * </pre>
     *
     * <code>string product_category = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for productCategory to set.
     * @return This builder for chaining.
     */
    public Builder setProductCategoryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      productCategory_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.vision.v1p3beta1.Product.KeyValue> productLabels_ =
        java.util.Collections.emptyList();

    private void ensureProductLabelsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        productLabels_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.Product.KeyValue>(
                productLabels_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.Product.KeyValue,
            com.google.cloud.vision.v1p3beta1.Product.KeyValue.Builder,
            com.google.cloud.vision.v1p3beta1.Product.KeyValueOrBuilder>
        productLabelsBuilder_;

    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.Product.KeyValue>
        getProductLabelsList() {
      if (productLabelsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(productLabels_);
      } else {
        return productLabelsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public int getProductLabelsCount() {
      if (productLabelsBuilder_ == null) {
        return productLabels_.size();
      } else {
        return productLabelsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public com.google.cloud.vision.v1p3beta1.Product.KeyValue getProductLabels(int index) {
      if (productLabelsBuilder_ == null) {
        return productLabels_.get(index);
      } else {
        return productLabelsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public Builder setProductLabels(
        int index, com.google.cloud.vision.v1p3beta1.Product.KeyValue value) {
      if (productLabelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProductLabelsIsMutable();
        productLabels_.set(index, value);
        onChanged();
      } else {
        productLabelsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public Builder setProductLabels(
        int index, com.google.cloud.vision.v1p3beta1.Product.KeyValue.Builder builderForValue) {
      if (productLabelsBuilder_ == null) {
        ensureProductLabelsIsMutable();
        productLabels_.set(index, builderForValue.build());
        onChanged();
      } else {
        productLabelsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public Builder addProductLabels(com.google.cloud.vision.v1p3beta1.Product.KeyValue value) {
      if (productLabelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProductLabelsIsMutable();
        productLabels_.add(value);
        onChanged();
      } else {
        productLabelsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public Builder addProductLabels(
        int index, com.google.cloud.vision.v1p3beta1.Product.KeyValue value) {
      if (productLabelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProductLabelsIsMutable();
        productLabels_.add(index, value);
        onChanged();
      } else {
        productLabelsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public Builder addProductLabels(
        com.google.cloud.vision.v1p3beta1.Product.KeyValue.Builder builderForValue) {
      if (productLabelsBuilder_ == null) {
        ensureProductLabelsIsMutable();
        productLabels_.add(builderForValue.build());
        onChanged();
      } else {
        productLabelsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public Builder addProductLabels(
        int index, com.google.cloud.vision.v1p3beta1.Product.KeyValue.Builder builderForValue) {
      if (productLabelsBuilder_ == null) {
        ensureProductLabelsIsMutable();
        productLabels_.add(index, builderForValue.build());
        onChanged();
      } else {
        productLabelsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public Builder addAllProductLabels(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p3beta1.Product.KeyValue> values) {
      if (productLabelsBuilder_ == null) {
        ensureProductLabelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, productLabels_);
        onChanged();
      } else {
        productLabelsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public Builder clearProductLabels() {
      if (productLabelsBuilder_ == null) {
        productLabels_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        productLabelsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public Builder removeProductLabels(int index) {
      if (productLabelsBuilder_ == null) {
        ensureProductLabelsIsMutable();
        productLabels_.remove(index);
        onChanged();
      } else {
        productLabelsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public com.google.cloud.vision.v1p3beta1.Product.KeyValue.Builder getProductLabelsBuilder(
        int index) {
      return getProductLabelsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public com.google.cloud.vision.v1p3beta1.Product.KeyValueOrBuilder getProductLabelsOrBuilder(
        int index) {
      if (productLabelsBuilder_ == null) {
        return productLabels_.get(index);
      } else {
        return productLabelsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1p3beta1.Product.KeyValueOrBuilder>
        getProductLabelsOrBuilderList() {
      if (productLabelsBuilder_ != null) {
        return productLabelsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(productLabels_);
      }
    }
    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public com.google.cloud.vision.v1p3beta1.Product.KeyValue.Builder addProductLabelsBuilder() {
      return getProductLabelsFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p3beta1.Product.KeyValue.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public com.google.cloud.vision.v1p3beta1.Product.KeyValue.Builder addProductLabelsBuilder(
        int index) {
      return getProductLabelsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.vision.v1p3beta1.Product.KeyValue.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Key-value pairs that can be attached to a product. At query time,
     * constraints can be specified based on the product_labels.
     *
     * Note that integer values can be provided as strings, e.g. "1199". Only
     * strings with integer values can match a range-based restriction which is
     * to be supported soon.
     *
     * Multiple values can be assigned to the same key. One product may have up to
     * 100 product_labels.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Product.KeyValue product_labels = 5;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.Product.KeyValue.Builder>
        getProductLabelsBuilderList() {
      return getProductLabelsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.Product.KeyValue,
            com.google.cloud.vision.v1p3beta1.Product.KeyValue.Builder,
            com.google.cloud.vision.v1p3beta1.Product.KeyValueOrBuilder>
        getProductLabelsFieldBuilder() {
      if (productLabelsBuilder_ == null) {
        productLabelsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.Product.KeyValue,
                com.google.cloud.vision.v1p3beta1.Product.KeyValue.Builder,
                com.google.cloud.vision.v1p3beta1.Product.KeyValueOrBuilder>(
                productLabels_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        productLabels_ = null;
      }
      return productLabelsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p3beta1.Product)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p3beta1.Product)
  private static final com.google.cloud.vision.v1p3beta1.Product DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1p3beta1.Product();
  }

  public static com.google.cloud.vision.v1p3beta1.Product getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Product> PARSER =
      new com.google.protobuf.AbstractParser<Product>() {
        @java.lang.Override
        public Product parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Product> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Product> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.Product getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
