/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1p3beta1/product_search_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.vision.v1p3beta1;

/**
 *
 *
 * <pre>
 * A `ReferenceImage` represents a product image and its associated metadata,
 * such as bounding boxes.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1p3beta1.ReferenceImage}
 */
public final class ReferenceImage extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p3beta1.ReferenceImage)
    ReferenceImageOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReferenceImage.newBuilder() to construct.
  private ReferenceImage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReferenceImage() {
    name_ = "";
    uri_ = "";
    boundingPolys_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReferenceImage();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1p3beta1.ProductSearchServiceProto
        .internal_static_google_cloud_vision_v1p3beta1_ReferenceImage_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1p3beta1.ProductSearchServiceProto
        .internal_static_google_cloud_vision_v1p3beta1_ReferenceImage_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1p3beta1.ReferenceImage.class,
            com.google.cloud.vision.v1p3beta1.ReferenceImage.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the reference image.
   *
   * Format is:
   *
   * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
   *
   * This field is ignored when creating a reference image.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the reference image.
   *
   * Format is:
   *
   * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
   *
   * This field is ignored when creating a reference image.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";
  /**
   *
   *
   * <pre>
   * Required. The Google Cloud Storage URI of the reference image.
   *
   * The URI must start with `gs://`.
   * </pre>
   *
   * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The Google Cloud Storage URI of the reference image.
   *
   * The URI must start with `gs://`.
   * </pre>
   *
   * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BOUNDING_POLYS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vision.v1p3beta1.BoundingPoly> boundingPolys_;
  /**
   *
   *
   * <pre>
   * Optional. Bounding polygons around the areas of interest in the reference image.
   * If this field is empty, the system will try to detect regions of
   * interest. At most 10 bounding polygons will be used.
   *
   * The provided shape is converted into a non-rotated rectangle. Once
   * converted, the small edge of the rectangle must be greater than or equal
   * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
   * is not).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vision.v1p3beta1.BoundingPoly> getBoundingPolysList() {
    return boundingPolys_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Bounding polygons around the areas of interest in the reference image.
   * If this field is empty, the system will try to detect regions of
   * interest. At most 10 bounding polygons will be used.
   *
   * The provided shape is converted into a non-rotated rectangle. Once
   * converted, the small edge of the rectangle must be greater than or equal
   * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
   * is not).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>
      getBoundingPolysOrBuilderList() {
    return boundingPolys_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Bounding polygons around the areas of interest in the reference image.
   * If this field is empty, the system will try to detect regions of
   * interest. At most 10 bounding polygons will be used.
   *
   * The provided shape is converted into a non-rotated rectangle. Once
   * converted, the small edge of the rectangle must be greater than or equal
   * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
   * is not).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getBoundingPolysCount() {
    return boundingPolys_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Bounding polygons around the areas of interest in the reference image.
   * If this field is empty, the system will try to detect regions of
   * interest. At most 10 bounding polygons will be used.
   *
   * The provided shape is converted into a non-rotated rectangle. Once
   * converted, the small edge of the rectangle must be greater than or equal
   * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
   * is not).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.BoundingPoly getBoundingPolys(int index) {
    return boundingPolys_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Bounding polygons around the areas of interest in the reference image.
   * If this field is empty, the system will try to detect regions of
   * interest. At most 10 bounding polygons will be used.
   *
   * The provided shape is converted into a non-rotated rectangle. Once
   * converted, the small edge of the rectangle must be greater than or equal
   * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
   * is not).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder getBoundingPolysOrBuilder(
      int index) {
    return boundingPolys_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uri_);
    }
    for (int i = 0; i < boundingPolys_.size(); i++) {
      output.writeMessage(3, boundingPolys_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uri_);
    }
    for (int i = 0; i < boundingPolys_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, boundingPolys_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1p3beta1.ReferenceImage)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1p3beta1.ReferenceImage other =
        (com.google.cloud.vision.v1p3beta1.ReferenceImage) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUri().equals(other.getUri())) return false;
    if (!getBoundingPolysList().equals(other.getBoundingPolysList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    if (getBoundingPolysCount() > 0) {
      hash = (37 * hash) + BOUNDING_POLYS_FIELD_NUMBER;
      hash = (53 * hash) + getBoundingPolysList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1p3beta1.ReferenceImage parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.ReferenceImage parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ReferenceImage parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.ReferenceImage parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ReferenceImage parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.ReferenceImage parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ReferenceImage parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.ReferenceImage parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ReferenceImage parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.ReferenceImage parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ReferenceImage parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.ReferenceImage parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vision.v1p3beta1.ReferenceImage prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A `ReferenceImage` represents a product image and its associated metadata,
   * such as bounding boxes.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p3beta1.ReferenceImage}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p3beta1.ReferenceImage)
      com.google.cloud.vision.v1p3beta1.ReferenceImageOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchServiceProto
          .internal_static_google_cloud_vision_v1p3beta1_ReferenceImage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchServiceProto
          .internal_static_google_cloud_vision_v1p3beta1_ReferenceImage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p3beta1.ReferenceImage.class,
              com.google.cloud.vision.v1p3beta1.ReferenceImage.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1p3beta1.ReferenceImage.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uri_ = "";
      if (boundingPolysBuilder_ == null) {
        boundingPolys_ = java.util.Collections.emptyList();
      } else {
        boundingPolys_ = null;
        boundingPolysBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchServiceProto
          .internal_static_google_cloud_vision_v1p3beta1_ReferenceImage_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ReferenceImage getDefaultInstanceForType() {
      return com.google.cloud.vision.v1p3beta1.ReferenceImage.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ReferenceImage build() {
      com.google.cloud.vision.v1p3beta1.ReferenceImage result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ReferenceImage buildPartial() {
      com.google.cloud.vision.v1p3beta1.ReferenceImage result =
          new com.google.cloud.vision.v1p3beta1.ReferenceImage(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.vision.v1p3beta1.ReferenceImage result) {
      if (boundingPolysBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          boundingPolys_ = java.util.Collections.unmodifiableList(boundingPolys_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.boundingPolys_ = boundingPolys_;
      } else {
        result.boundingPolys_ = boundingPolysBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.vision.v1p3beta1.ReferenceImage result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uri_ = uri_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1p3beta1.ReferenceImage) {
        return mergeFrom((com.google.cloud.vision.v1p3beta1.ReferenceImage) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1p3beta1.ReferenceImage other) {
      if (other == com.google.cloud.vision.v1p3beta1.ReferenceImage.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (boundingPolysBuilder_ == null) {
        if (!other.boundingPolys_.isEmpty()) {
          if (boundingPolys_.isEmpty()) {
            boundingPolys_ = other.boundingPolys_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureBoundingPolysIsMutable();
            boundingPolys_.addAll(other.boundingPolys_);
          }
          onChanged();
        }
      } else {
        if (!other.boundingPolys_.isEmpty()) {
          if (boundingPolysBuilder_.isEmpty()) {
            boundingPolysBuilder_.dispose();
            boundingPolysBuilder_ = null;
            boundingPolys_ = other.boundingPolys_;
            bitField0_ = (bitField0_ & ~0x00000004);
            boundingPolysBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBoundingPolysFieldBuilder()
                    : null;
          } else {
            boundingPolysBuilder_.addAllMessages(other.boundingPolys_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.vision.v1p3beta1.BoundingPoly m =
                    input.readMessage(
                        com.google.cloud.vision.v1p3beta1.BoundingPoly.parser(), extensionRegistry);
                if (boundingPolysBuilder_ == null) {
                  ensureBoundingPolysIsMutable();
                  boundingPolys_.add(m);
                } else {
                  boundingPolysBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the reference image.
     *
     * Format is:
     *
     * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
     *
     * This field is ignored when creating a reference image.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the reference image.
     *
     * Format is:
     *
     * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
     *
     * This field is ignored when creating a reference image.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the reference image.
     *
     * Format is:
     *
     * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
     *
     * This field is ignored when creating a reference image.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the reference image.
     *
     * Format is:
     *
     * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
     *
     * This field is ignored when creating a reference image.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the reference image.
     *
     * Format is:
     *
     * `projects/PROJECT_ID/locations/LOC_ID/products/PRODUCT_ID/referenceImages/IMAGE_ID`.
     *
     * This field is ignored when creating a reference image.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage URI of the reference image.
     *
     * The URI must start with `gs://`.
     * </pre>
     *
     * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage URI of the reference image.
     *
     * The URI must start with `gs://`.
     * </pre>
     *
     * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage URI of the reference image.
     *
     * The URI must start with `gs://`.
     * </pre>
     *
     * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage URI of the reference image.
     *
     * The URI must start with `gs://`.
     * </pre>
     *
     * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage URI of the reference image.
     *
     * The URI must start with `gs://`.
     * </pre>
     *
     * <code>string uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.vision.v1p3beta1.BoundingPoly> boundingPolys_ =
        java.util.Collections.emptyList();

    private void ensureBoundingPolysIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        boundingPolys_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.BoundingPoly>(boundingPolys_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.BoundingPoly,
            com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>
        boundingPolysBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.BoundingPoly> getBoundingPolysList() {
      if (boundingPolysBuilder_ == null) {
        return java.util.Collections.unmodifiableList(boundingPolys_);
      } else {
        return boundingPolysBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getBoundingPolysCount() {
      if (boundingPolysBuilder_ == null) {
        return boundingPolys_.size();
      } else {
        return boundingPolysBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPoly getBoundingPolys(int index) {
      if (boundingPolysBuilder_ == null) {
        return boundingPolys_.get(index);
      } else {
        return boundingPolysBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBoundingPolys(
        int index, com.google.cloud.vision.v1p3beta1.BoundingPoly value) {
      if (boundingPolysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBoundingPolysIsMutable();
        boundingPolys_.set(index, value);
        onChanged();
      } else {
        boundingPolysBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBoundingPolys(
        int index, com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder builderForValue) {
      if (boundingPolysBuilder_ == null) {
        ensureBoundingPolysIsMutable();
        boundingPolys_.set(index, builderForValue.build());
        onChanged();
      } else {
        boundingPolysBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addBoundingPolys(com.google.cloud.vision.v1p3beta1.BoundingPoly value) {
      if (boundingPolysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBoundingPolysIsMutable();
        boundingPolys_.add(value);
        onChanged();
      } else {
        boundingPolysBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addBoundingPolys(
        int index, com.google.cloud.vision.v1p3beta1.BoundingPoly value) {
      if (boundingPolysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBoundingPolysIsMutable();
        boundingPolys_.add(index, value);
        onChanged();
      } else {
        boundingPolysBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addBoundingPolys(
        com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder builderForValue) {
      if (boundingPolysBuilder_ == null) {
        ensureBoundingPolysIsMutable();
        boundingPolys_.add(builderForValue.build());
        onChanged();
      } else {
        boundingPolysBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addBoundingPolys(
        int index, com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder builderForValue) {
      if (boundingPolysBuilder_ == null) {
        ensureBoundingPolysIsMutable();
        boundingPolys_.add(index, builderForValue.build());
        onChanged();
      } else {
        boundingPolysBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllBoundingPolys(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p3beta1.BoundingPoly> values) {
      if (boundingPolysBuilder_ == null) {
        ensureBoundingPolysIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, boundingPolys_);
        onChanged();
      } else {
        boundingPolysBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearBoundingPolys() {
      if (boundingPolysBuilder_ == null) {
        boundingPolys_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        boundingPolysBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeBoundingPolys(int index) {
      if (boundingPolysBuilder_ == null) {
        ensureBoundingPolysIsMutable();
        boundingPolys_.remove(index);
        onChanged();
      } else {
        boundingPolysBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder getBoundingPolysBuilder(
        int index) {
      return getBoundingPolysFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder getBoundingPolysOrBuilder(
        int index) {
      if (boundingPolysBuilder_ == null) {
        return boundingPolys_.get(index);
      } else {
        return boundingPolysBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>
        getBoundingPolysOrBuilderList() {
      if (boundingPolysBuilder_ != null) {
        return boundingPolysBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(boundingPolys_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder addBoundingPolysBuilder() {
      return getBoundingPolysFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder addBoundingPolysBuilder(
        int index) {
      return getBoundingPolysFieldBuilder()
          .addBuilder(index, com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Bounding polygons around the areas of interest in the reference image.
     * If this field is empty, the system will try to detect regions of
     * interest. At most 10 bounding polygons will be used.
     *
     * The provided shape is converted into a non-rotated rectangle. Once
     * converted, the small edge of the rectangle must be greater than or equal
     * to 300 pixels. The aspect ratio must be 1:4 or less (i.e. 1:3 is ok; 1:5
     * is not).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.BoundingPoly bounding_polys = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder>
        getBoundingPolysBuilderList() {
      return getBoundingPolysFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.BoundingPoly,
            com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>
        getBoundingPolysFieldBuilder() {
      if (boundingPolysBuilder_ == null) {
        boundingPolysBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.BoundingPoly,
                com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
                com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>(
                boundingPolys_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        boundingPolys_ = null;
      }
      return boundingPolysBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p3beta1.ReferenceImage)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p3beta1.ReferenceImage)
  private static final com.google.cloud.vision.v1p3beta1.ReferenceImage DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1p3beta1.ReferenceImage();
  }

  public static com.google.cloud.vision.v1p3beta1.ReferenceImage getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReferenceImage> PARSER =
      new com.google.protobuf.AbstractParser<ReferenceImage>() {
        @java.lang.Override
        public ReferenceImage parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReferenceImage> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReferenceImage> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.ReferenceImage getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
