/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1p3beta1/text_annotation.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.vision.v1p3beta1;

/**
 *
 *
 * <pre>
 * Structural unit of text representing a number of words in certain order.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1p3beta1.Paragraph}
 */
public final class Paragraph extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p3beta1.Paragraph)
    ParagraphOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Paragraph.newBuilder() to construct.
  private Paragraph(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Paragraph() {
    words_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Paragraph();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1p3beta1.TextAnnotationProto
        .internal_static_google_cloud_vision_v1p3beta1_Paragraph_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1p3beta1.TextAnnotationProto
        .internal_static_google_cloud_vision_v1p3beta1_Paragraph_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1p3beta1.Paragraph.class,
            com.google.cloud.vision.v1p3beta1.Paragraph.Builder.class);
  }

  private int bitField0_;
  public static final int PROPERTY_FIELD_NUMBER = 1;
  private com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property_;
  /**
   *
   *
   * <pre>
   * Additional information detected for the paragraph.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
   *
   * @return Whether the property field is set.
   */
  @java.lang.Override
  public boolean hasProperty() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Additional information detected for the paragraph.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
   *
   * @return The property.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty getProperty() {
    return property_ == null
        ? com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.getDefaultInstance()
        : property_;
  }
  /**
   *
   *
   * <pre>
   * Additional information detected for the paragraph.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.TextAnnotation.TextPropertyOrBuilder
      getPropertyOrBuilder() {
    return property_ == null
        ? com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.getDefaultInstance()
        : property_;
  }

  public static final int BOUNDING_BOX_FIELD_NUMBER = 2;
  private com.google.cloud.vision.v1p3beta1.BoundingPoly boundingBox_;
  /**
   *
   *
   * <pre>
   * The bounding box for the paragraph.
   * The vertices are in the order of top-left, top-right, bottom-right,
   * bottom-left. When a rotation of the bounding box is detected the rotation
   * is represented as around the top-left corner as defined when the text is
   * read in the 'natural' orientation.
   * For example:
   *   * when the text is horizontal it might look like:
   *      0----1
   *      |    |
   *      3----2
   *   * when it's rotated 180 degrees around the top-left corner it becomes:
   *      2----3
   *      |    |
   *      1----0
   *   and the vertice order will still be (0, 1, 2, 3).
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
   *
   * @return Whether the boundingBox field is set.
   */
  @java.lang.Override
  public boolean hasBoundingBox() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The bounding box for the paragraph.
   * The vertices are in the order of top-left, top-right, bottom-right,
   * bottom-left. When a rotation of the bounding box is detected the rotation
   * is represented as around the top-left corner as defined when the text is
   * read in the 'natural' orientation.
   * For example:
   *   * when the text is horizontal it might look like:
   *      0----1
   *      |    |
   *      3----2
   *   * when it's rotated 180 degrees around the top-left corner it becomes:
   *      2----3
   *      |    |
   *      1----0
   *   and the vertice order will still be (0, 1, 2, 3).
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
   *
   * @return The boundingBox.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.BoundingPoly getBoundingBox() {
    return boundingBox_ == null
        ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
        : boundingBox_;
  }
  /**
   *
   *
   * <pre>
   * The bounding box for the paragraph.
   * The vertices are in the order of top-left, top-right, bottom-right,
   * bottom-left. When a rotation of the bounding box is detected the rotation
   * is represented as around the top-left corner as defined when the text is
   * read in the 'natural' orientation.
   * For example:
   *   * when the text is horizontal it might look like:
   *      0----1
   *      |    |
   *      3----2
   *   * when it's rotated 180 degrees around the top-left corner it becomes:
   *      2----3
   *      |    |
   *      1----0
   *   and the vertice order will still be (0, 1, 2, 3).
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder getBoundingBoxOrBuilder() {
    return boundingBox_ == null
        ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
        : boundingBox_;
  }

  public static final int WORDS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vision.v1p3beta1.Word> words_;
  /**
   *
   *
   * <pre>
   * List of words in this paragraph.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vision.v1p3beta1.Word> getWordsList() {
    return words_;
  }
  /**
   *
   *
   * <pre>
   * List of words in this paragraph.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vision.v1p3beta1.WordOrBuilder>
      getWordsOrBuilderList() {
    return words_;
  }
  /**
   *
   *
   * <pre>
   * List of words in this paragraph.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
   */
  @java.lang.Override
  public int getWordsCount() {
    return words_.size();
  }
  /**
   *
   *
   * <pre>
   * List of words in this paragraph.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.Word getWords(int index) {
    return words_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of words in this paragraph.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.WordOrBuilder getWordsOrBuilder(int index) {
    return words_.get(index);
  }

  public static final int CONFIDENCE_FIELD_NUMBER = 4;
  private float confidence_ = 0F;
  /**
   *
   *
   * <pre>
   * Confidence of the OCR results for the paragraph. Range [0, 1].
   * </pre>
   *
   * <code>float confidence = 4;</code>
   *
   * @return The confidence.
   */
  @java.lang.Override
  public float getConfidence() {
    return confidence_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getProperty());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getBoundingBox());
    }
    for (int i = 0; i < words_.size(); i++) {
      output.writeMessage(3, words_.get(i));
    }
    if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
      output.writeFloat(4, confidence_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getProperty());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getBoundingBox());
    }
    for (int i = 0; i < words_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, words_.get(i));
    }
    if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, confidence_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1p3beta1.Paragraph)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1p3beta1.Paragraph other =
        (com.google.cloud.vision.v1p3beta1.Paragraph) obj;

    if (hasProperty() != other.hasProperty()) return false;
    if (hasProperty()) {
      if (!getProperty().equals(other.getProperty())) return false;
    }
    if (hasBoundingBox() != other.hasBoundingBox()) return false;
    if (hasBoundingBox()) {
      if (!getBoundingBox().equals(other.getBoundingBox())) return false;
    }
    if (!getWordsList().equals(other.getWordsList())) return false;
    if (java.lang.Float.floatToIntBits(getConfidence())
        != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasProperty()) {
      hash = (37 * hash) + PROPERTY_FIELD_NUMBER;
      hash = (53 * hash) + getProperty().hashCode();
    }
    if (hasBoundingBox()) {
      hash = (37 * hash) + BOUNDING_BOX_FIELD_NUMBER;
      hash = (53 * hash) + getBoundingBox().hashCode();
    }
    if (getWordsCount() > 0) {
      hash = (37 * hash) + WORDS_FIELD_NUMBER;
      hash = (53 * hash) + getWordsList().hashCode();
    }
    hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1p3beta1.Paragraph parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.Paragraph parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.Paragraph parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.Paragraph parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.Paragraph parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.Paragraph parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.Paragraph parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.Paragraph parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.Paragraph parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.Paragraph parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.Paragraph parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.Paragraph parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vision.v1p3beta1.Paragraph prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Structural unit of text representing a number of words in certain order.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p3beta1.Paragraph}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p3beta1.Paragraph)
      com.google.cloud.vision.v1p3beta1.ParagraphOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p3beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p3beta1_Paragraph_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p3beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p3beta1_Paragraph_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p3beta1.Paragraph.class,
              com.google.cloud.vision.v1p3beta1.Paragraph.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1p3beta1.Paragraph.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPropertyFieldBuilder();
        getBoundingBoxFieldBuilder();
        getWordsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      property_ = null;
      if (propertyBuilder_ != null) {
        propertyBuilder_.dispose();
        propertyBuilder_ = null;
      }
      boundingBox_ = null;
      if (boundingBoxBuilder_ != null) {
        boundingBoxBuilder_.dispose();
        boundingBoxBuilder_ = null;
      }
      if (wordsBuilder_ == null) {
        words_ = java.util.Collections.emptyList();
      } else {
        words_ = null;
        wordsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      confidence_ = 0F;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1p3beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p3beta1_Paragraph_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.Paragraph getDefaultInstanceForType() {
      return com.google.cloud.vision.v1p3beta1.Paragraph.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.Paragraph build() {
      com.google.cloud.vision.v1p3beta1.Paragraph result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.Paragraph buildPartial() {
      com.google.cloud.vision.v1p3beta1.Paragraph result =
          new com.google.cloud.vision.v1p3beta1.Paragraph(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.vision.v1p3beta1.Paragraph result) {
      if (wordsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          words_ = java.util.Collections.unmodifiableList(words_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.words_ = words_;
      } else {
        result.words_ = wordsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.vision.v1p3beta1.Paragraph result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.property_ = propertyBuilder_ == null ? property_ : propertyBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.boundingBox_ =
            boundingBoxBuilder_ == null ? boundingBox_ : boundingBoxBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.confidence_ = confidence_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1p3beta1.Paragraph) {
        return mergeFrom((com.google.cloud.vision.v1p3beta1.Paragraph) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1p3beta1.Paragraph other) {
      if (other == com.google.cloud.vision.v1p3beta1.Paragraph.getDefaultInstance()) return this;
      if (other.hasProperty()) {
        mergeProperty(other.getProperty());
      }
      if (other.hasBoundingBox()) {
        mergeBoundingBox(other.getBoundingBox());
      }
      if (wordsBuilder_ == null) {
        if (!other.words_.isEmpty()) {
          if (words_.isEmpty()) {
            words_ = other.words_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureWordsIsMutable();
            words_.addAll(other.words_);
          }
          onChanged();
        }
      } else {
        if (!other.words_.isEmpty()) {
          if (wordsBuilder_.isEmpty()) {
            wordsBuilder_.dispose();
            wordsBuilder_ = null;
            words_ = other.words_;
            bitField0_ = (bitField0_ & ~0x00000004);
            wordsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWordsFieldBuilder()
                    : null;
          } else {
            wordsBuilder_.addAllMessages(other.words_);
          }
        }
      }
      if (other.getConfidence() != 0F) {
        setConfidence(other.getConfidence());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getPropertyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getBoundingBoxFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.vision.v1p3beta1.Word m =
                    input.readMessage(
                        com.google.cloud.vision.v1p3beta1.Word.parser(), extensionRegistry);
                if (wordsBuilder_ == null) {
                  ensureWordsIsMutable();
                  words_.add(m);
                } else {
                  wordsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 37:
              {
                confidence_ = input.readFloat();
                bitField0_ |= 0x00000008;
                break;
              } // case 37
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty,
            com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.Builder,
            com.google.cloud.vision.v1p3beta1.TextAnnotation.TextPropertyOrBuilder>
        propertyBuilder_;
    /**
     *
     *
     * <pre>
     * Additional information detected for the paragraph.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     *
     * @return Whether the property field is set.
     */
    public boolean hasProperty() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Additional information detected for the paragraph.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     *
     * @return The property.
     */
    public com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty getProperty() {
      if (propertyBuilder_ == null) {
        return property_ == null
            ? com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.getDefaultInstance()
            : property_;
      } else {
        return propertyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information detected for the paragraph.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public Builder setProperty(
        com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty value) {
      if (propertyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        property_ = value;
      } else {
        propertyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information detected for the paragraph.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public Builder setProperty(
        com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.Builder builderForValue) {
      if (propertyBuilder_ == null) {
        property_ = builderForValue.build();
      } else {
        propertyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information detected for the paragraph.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public Builder mergeProperty(
        com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty value) {
      if (propertyBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && property_ != null
            && property_
                != com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty
                    .getDefaultInstance()) {
          getPropertyBuilder().mergeFrom(value);
        } else {
          property_ = value;
        }
      } else {
        propertyBuilder_.mergeFrom(value);
      }
      if (property_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information detected for the paragraph.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public Builder clearProperty() {
      bitField0_ = (bitField0_ & ~0x00000001);
      property_ = null;
      if (propertyBuilder_ != null) {
        propertyBuilder_.dispose();
        propertyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information detected for the paragraph.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.Builder
        getPropertyBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getPropertyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional information detected for the paragraph.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public com.google.cloud.vision.v1p3beta1.TextAnnotation.TextPropertyOrBuilder
        getPropertyOrBuilder() {
      if (propertyBuilder_ != null) {
        return propertyBuilder_.getMessageOrBuilder();
      } else {
        return property_ == null
            ? com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.getDefaultInstance()
            : property_;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information detected for the paragraph.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty,
            com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.Builder,
            com.google.cloud.vision.v1p3beta1.TextAnnotation.TextPropertyOrBuilder>
        getPropertyFieldBuilder() {
      if (propertyBuilder_ == null) {
        propertyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty,
                com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.Builder,
                com.google.cloud.vision.v1p3beta1.TextAnnotation.TextPropertyOrBuilder>(
                getProperty(), getParentForChildren(), isClean());
        property_ = null;
      }
      return propertyBuilder_;
    }

    private com.google.cloud.vision.v1p3beta1.BoundingPoly boundingBox_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.BoundingPoly,
            com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>
        boundingBoxBuilder_;
    /**
     *
     *
     * <pre>
     * The bounding box for the paragraph.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     *
     * @return Whether the boundingBox field is set.
     */
    public boolean hasBoundingBox() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The bounding box for the paragraph.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     *
     * @return The boundingBox.
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPoly getBoundingBox() {
      if (boundingBoxBuilder_ == null) {
        return boundingBox_ == null
            ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
            : boundingBox_;
      } else {
        return boundingBoxBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bounding box for the paragraph.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     */
    public Builder setBoundingBox(com.google.cloud.vision.v1p3beta1.BoundingPoly value) {
      if (boundingBoxBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        boundingBox_ = value;
      } else {
        boundingBoxBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding box for the paragraph.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     */
    public Builder setBoundingBox(
        com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder builderForValue) {
      if (boundingBoxBuilder_ == null) {
        boundingBox_ = builderForValue.build();
      } else {
        boundingBoxBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding box for the paragraph.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     */
    public Builder mergeBoundingBox(com.google.cloud.vision.v1p3beta1.BoundingPoly value) {
      if (boundingBoxBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && boundingBox_ != null
            && boundingBox_
                != com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()) {
          getBoundingBoxBuilder().mergeFrom(value);
        } else {
          boundingBox_ = value;
        }
      } else {
        boundingBoxBuilder_.mergeFrom(value);
      }
      if (boundingBox_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding box for the paragraph.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     */
    public Builder clearBoundingBox() {
      bitField0_ = (bitField0_ & ~0x00000002);
      boundingBox_ = null;
      if (boundingBoxBuilder_ != null) {
        boundingBoxBuilder_.dispose();
        boundingBoxBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bounding box for the paragraph.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder getBoundingBoxBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getBoundingBoxFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bounding box for the paragraph.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder getBoundingBoxOrBuilder() {
      if (boundingBoxBuilder_ != null) {
        return boundingBoxBuilder_.getMessageOrBuilder();
      } else {
        return boundingBox_ == null
            ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
            : boundingBox_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bounding box for the paragraph.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *   * when the text is horizontal it might look like:
     *      0----1
     *      |    |
     *      3----2
     *   * when it's rotated 180 degrees around the top-left corner it becomes:
     *      2----3
     *      |    |
     *      1----0
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.BoundingPoly,
            com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>
        getBoundingBoxFieldBuilder() {
      if (boundingBoxBuilder_ == null) {
        boundingBoxBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.BoundingPoly,
                com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
                com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>(
                getBoundingBox(), getParentForChildren(), isClean());
        boundingBox_ = null;
      }
      return boundingBoxBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p3beta1.Word> words_ =
        java.util.Collections.emptyList();

    private void ensureWordsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        words_ = new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.Word>(words_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.Word,
            com.google.cloud.vision.v1p3beta1.Word.Builder,
            com.google.cloud.vision.v1p3beta1.WordOrBuilder>
        wordsBuilder_;

    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.Word> getWordsList() {
      if (wordsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(words_);
      } else {
        return wordsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public int getWordsCount() {
      if (wordsBuilder_ == null) {
        return words_.size();
      } else {
        return wordsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public com.google.cloud.vision.v1p3beta1.Word getWords(int index) {
      if (wordsBuilder_ == null) {
        return words_.get(index);
      } else {
        return wordsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public Builder setWords(int index, com.google.cloud.vision.v1p3beta1.Word value) {
      if (wordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWordsIsMutable();
        words_.set(index, value);
        onChanged();
      } else {
        wordsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public Builder setWords(
        int index, com.google.cloud.vision.v1p3beta1.Word.Builder builderForValue) {
      if (wordsBuilder_ == null) {
        ensureWordsIsMutable();
        words_.set(index, builderForValue.build());
        onChanged();
      } else {
        wordsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public Builder addWords(com.google.cloud.vision.v1p3beta1.Word value) {
      if (wordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWordsIsMutable();
        words_.add(value);
        onChanged();
      } else {
        wordsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public Builder addWords(int index, com.google.cloud.vision.v1p3beta1.Word value) {
      if (wordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWordsIsMutable();
        words_.add(index, value);
        onChanged();
      } else {
        wordsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public Builder addWords(com.google.cloud.vision.v1p3beta1.Word.Builder builderForValue) {
      if (wordsBuilder_ == null) {
        ensureWordsIsMutable();
        words_.add(builderForValue.build());
        onChanged();
      } else {
        wordsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public Builder addWords(
        int index, com.google.cloud.vision.v1p3beta1.Word.Builder builderForValue) {
      if (wordsBuilder_ == null) {
        ensureWordsIsMutable();
        words_.add(index, builderForValue.build());
        onChanged();
      } else {
        wordsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public Builder addAllWords(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p3beta1.Word> values) {
      if (wordsBuilder_ == null) {
        ensureWordsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, words_);
        onChanged();
      } else {
        wordsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public Builder clearWords() {
      if (wordsBuilder_ == null) {
        words_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        wordsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public Builder removeWords(int index) {
      if (wordsBuilder_ == null) {
        ensureWordsIsMutable();
        words_.remove(index);
        onChanged();
      } else {
        wordsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public com.google.cloud.vision.v1p3beta1.Word.Builder getWordsBuilder(int index) {
      return getWordsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public com.google.cloud.vision.v1p3beta1.WordOrBuilder getWordsOrBuilder(int index) {
      if (wordsBuilder_ == null) {
        return words_.get(index);
      } else {
        return wordsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1p3beta1.WordOrBuilder>
        getWordsOrBuilderList() {
      if (wordsBuilder_ != null) {
        return wordsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(words_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public com.google.cloud.vision.v1p3beta1.Word.Builder addWordsBuilder() {
      return getWordsFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p3beta1.Word.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public com.google.cloud.vision.v1p3beta1.Word.Builder addWordsBuilder(int index) {
      return getWordsFieldBuilder()
          .addBuilder(index, com.google.cloud.vision.v1p3beta1.Word.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of words in this paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Word words = 3;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.Word.Builder> getWordsBuilderList() {
      return getWordsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.Word,
            com.google.cloud.vision.v1p3beta1.Word.Builder,
            com.google.cloud.vision.v1p3beta1.WordOrBuilder>
        getWordsFieldBuilder() {
      if (wordsBuilder_ == null) {
        wordsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.Word,
                com.google.cloud.vision.v1p3beta1.Word.Builder,
                com.google.cloud.vision.v1p3beta1.WordOrBuilder>(
                words_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        words_ = null;
      }
      return wordsBuilder_;
    }

    private float confidence_;
    /**
     *
     *
     * <pre>
     * Confidence of the OCR results for the paragraph. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 4;</code>
     *
     * @return The confidence.
     */
    @java.lang.Override
    public float getConfidence() {
      return confidence_;
    }
    /**
     *
     *
     * <pre>
     * Confidence of the OCR results for the paragraph. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 4;</code>
     *
     * @param value The confidence to set.
     * @return This builder for chaining.
     */
    public Builder setConfidence(float value) {

      confidence_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Confidence of the OCR results for the paragraph. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfidence() {
      bitField0_ = (bitField0_ & ~0x00000008);
      confidence_ = 0F;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p3beta1.Paragraph)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p3beta1.Paragraph)
  private static final com.google.cloud.vision.v1p3beta1.Paragraph DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1p3beta1.Paragraph();
  }

  public static com.google.cloud.vision.v1p3beta1.Paragraph getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Paragraph> PARSER =
      new com.google.protobuf.AbstractParser<Paragraph>() {
        @java.lang.Override
        public Paragraph parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Paragraph> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Paragraph> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.Paragraph getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
