/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1p3beta1/product_search.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.vision.v1p3beta1;

/**
 *
 *
 * <pre>
 * Results for a product search request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1p3beta1.ProductSearchResults}
 */
public final class ProductSearchResults extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p3beta1.ProductSearchResults)
    ProductSearchResultsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ProductSearchResults.newBuilder() to construct.
  private ProductSearchResults(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ProductSearchResults() {
    results_ = java.util.Collections.emptyList();
    productGroupedResults_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ProductSearchResults();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1p3beta1.ProductSearchProto
        .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1p3beta1.ProductSearchProto
        .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1p3beta1.ProductSearchResults.class,
            com.google.cloud.vision.v1p3beta1.ProductSearchResults.Builder.class);
  }

  public interface ResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.vision.v1p3beta1.ProductSearchResults.Result)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The Product.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.Product product = 1;</code>
     *
     * @return Whether the product field is set.
     */
    boolean hasProduct();

    /**
     *
     *
     * <pre>
     * The Product.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.Product product = 1;</code>
     *
     * @return The product.
     */
    com.google.cloud.vision.v1p3beta1.Product getProduct();

    /**
     *
     *
     * <pre>
     * The Product.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.Product product = 1;</code>
     */
    com.google.cloud.vision.v1p3beta1.ProductOrBuilder getProductOrBuilder();

    /**
     *
     *
     * <pre>
     * A confidence level on the match, ranging from 0 (no confidence) to
     * 1 (full confidence).
     * </pre>
     *
     * <code>float score = 2;</code>
     *
     * @return The score.
     */
    float getScore();

    /**
     *
     *
     * <pre>
     * The resource name of the image from the product that is the closest match
     * to the query.
     * </pre>
     *
     * <code>string image = 3;</code>
     *
     * @return The image.
     */
    java.lang.String getImage();

    /**
     *
     *
     * <pre>
     * The resource name of the image from the product that is the closest match
     * to the query.
     * </pre>
     *
     * <code>string image = 3;</code>
     *
     * @return The bytes for image.
     */
    com.google.protobuf.ByteString getImageBytes();
  }

  /**
   *
   *
   * <pre>
   * Information about a product.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p3beta1.ProductSearchResults.Result}
   */
  public static final class Result extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p3beta1.ProductSearchResults.Result)
      ResultOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Result.newBuilder() to construct.
    private Result(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Result() {
      image_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Result();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchProto
          .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_Result_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchProto
          .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_Result_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.class,
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder.class);
    }

    private int bitField0_;
    public static final int PRODUCT_FIELD_NUMBER = 1;
    private com.google.cloud.vision.v1p3beta1.Product product_;

    /**
     *
     *
     * <pre>
     * The Product.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.Product product = 1;</code>
     *
     * @return Whether the product field is set.
     */
    @java.lang.Override
    public boolean hasProduct() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The Product.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.Product product = 1;</code>
     *
     * @return The product.
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.Product getProduct() {
      return product_ == null
          ? com.google.cloud.vision.v1p3beta1.Product.getDefaultInstance()
          : product_;
    }

    /**
     *
     *
     * <pre>
     * The Product.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.Product product = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ProductOrBuilder getProductOrBuilder() {
      return product_ == null
          ? com.google.cloud.vision.v1p3beta1.Product.getDefaultInstance()
          : product_;
    }

    public static final int SCORE_FIELD_NUMBER = 2;
    private float score_ = 0F;

    /**
     *
     *
     * <pre>
     * A confidence level on the match, ranging from 0 (no confidence) to
     * 1 (full confidence).
     * </pre>
     *
     * <code>float score = 2;</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public float getScore() {
      return score_;
    }

    public static final int IMAGE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object image_ = "";

    /**
     *
     *
     * <pre>
     * The resource name of the image from the product that is the closest match
     * to the query.
     * </pre>
     *
     * <code>string image = 3;</code>
     *
     * @return The image.
     */
    @java.lang.Override
    public java.lang.String getImage() {
      java.lang.Object ref = image_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        image_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource name of the image from the product that is the closest match
     * to the query.
     * </pre>
     *
     * <code>string image = 3;</code>
     *
     * @return The bytes for image.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getImageBytes() {
      java.lang.Object ref = image_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        image_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getProduct());
      }
      if (java.lang.Float.floatToRawIntBits(score_) != 0) {
        output.writeFloat(2, score_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(image_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, image_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getProduct());
      }
      if (java.lang.Float.floatToRawIntBits(score_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, score_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(image_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, image_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result)) {
        return super.equals(obj);
      }
      com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result other =
          (com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result) obj;

      if (hasProduct() != other.hasProduct()) return false;
      if (hasProduct()) {
        if (!getProduct().equals(other.getProduct())) return false;
      }
      if (java.lang.Float.floatToIntBits(getScore())
          != java.lang.Float.floatToIntBits(other.getScore())) return false;
      if (!getImage().equals(other.getImage())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasProduct()) {
        hash = (37 * hash) + PRODUCT_FIELD_NUMBER;
        hash = (53 * hash) + getProduct().hashCode();
      }
      hash = (37 * hash) + SCORE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getScore());
      hash = (37 * hash) + IMAGE_FIELD_NUMBER;
      hash = (53 * hash) + getImage().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Information about a product.
     * </pre>
     *
     * Protobuf type {@code google.cloud.vision.v1p3beta1.ProductSearchResults.Result}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p3beta1.ProductSearchResults.Result)
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.ResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.vision.v1p3beta1.ProductSearchProto
            .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_Result_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.vision.v1p3beta1.ProductSearchProto
            .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_Result_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.class,
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder.class);
      }

      // Construct using com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getProductFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        product_ = null;
        if (productBuilder_ != null) {
          productBuilder_.dispose();
          productBuilder_ = null;
        }
        score_ = 0F;
        image_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.vision.v1p3beta1.ProductSearchProto
            .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_Result_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result
          getDefaultInstanceForType() {
        return com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result build() {
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result buildPartial() {
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result result =
            new com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.product_ = productBuilder_ == null ? product_ : productBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.score_ = score_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.image_ = image_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result) {
          return mergeFrom((com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result other) {
        if (other
            == com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.getDefaultInstance())
          return this;
        if (other.hasProduct()) {
          mergeProduct(other.getProduct());
        }
        if (other.getScore() != 0F) {
          setScore(other.getScore());
        }
        if (!other.getImage().isEmpty()) {
          image_ = other.image_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getProductFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 21:
                {
                  score_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              case 26:
                {
                  image_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.vision.v1p3beta1.Product product_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.vision.v1p3beta1.Product,
              com.google.cloud.vision.v1p3beta1.Product.Builder,
              com.google.cloud.vision.v1p3beta1.ProductOrBuilder>
          productBuilder_;

      /**
       *
       *
       * <pre>
       * The Product.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.Product product = 1;</code>
       *
       * @return Whether the product field is set.
       */
      public boolean hasProduct() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The Product.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.Product product = 1;</code>
       *
       * @return The product.
       */
      public com.google.cloud.vision.v1p3beta1.Product getProduct() {
        if (productBuilder_ == null) {
          return product_ == null
              ? com.google.cloud.vision.v1p3beta1.Product.getDefaultInstance()
              : product_;
        } else {
          return productBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The Product.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.Product product = 1;</code>
       */
      public Builder setProduct(com.google.cloud.vision.v1p3beta1.Product value) {
        if (productBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          product_ = value;
        } else {
          productBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The Product.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.Product product = 1;</code>
       */
      public Builder setProduct(com.google.cloud.vision.v1p3beta1.Product.Builder builderForValue) {
        if (productBuilder_ == null) {
          product_ = builderForValue.build();
        } else {
          productBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The Product.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.Product product = 1;</code>
       */
      public Builder mergeProduct(com.google.cloud.vision.v1p3beta1.Product value) {
        if (productBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && product_ != null
              && product_ != com.google.cloud.vision.v1p3beta1.Product.getDefaultInstance()) {
            getProductBuilder().mergeFrom(value);
          } else {
            product_ = value;
          }
        } else {
          productBuilder_.mergeFrom(value);
        }
        if (product_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The Product.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.Product product = 1;</code>
       */
      public Builder clearProduct() {
        bitField0_ = (bitField0_ & ~0x00000001);
        product_ = null;
        if (productBuilder_ != null) {
          productBuilder_.dispose();
          productBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The Product.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.Product product = 1;</code>
       */
      public com.google.cloud.vision.v1p3beta1.Product.Builder getProductBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getProductFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The Product.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.Product product = 1;</code>
       */
      public com.google.cloud.vision.v1p3beta1.ProductOrBuilder getProductOrBuilder() {
        if (productBuilder_ != null) {
          return productBuilder_.getMessageOrBuilder();
        } else {
          return product_ == null
              ? com.google.cloud.vision.v1p3beta1.Product.getDefaultInstance()
              : product_;
        }
      }

      /**
       *
       *
       * <pre>
       * The Product.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.Product product = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.vision.v1p3beta1.Product,
              com.google.cloud.vision.v1p3beta1.Product.Builder,
              com.google.cloud.vision.v1p3beta1.ProductOrBuilder>
          getProductFieldBuilder() {
        if (productBuilder_ == null) {
          productBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.vision.v1p3beta1.Product,
                  com.google.cloud.vision.v1p3beta1.Product.Builder,
                  com.google.cloud.vision.v1p3beta1.ProductOrBuilder>(
                  getProduct(), getParentForChildren(), isClean());
          product_ = null;
        }
        return productBuilder_;
      }

      private float score_;

      /**
       *
       *
       * <pre>
       * A confidence level on the match, ranging from 0 (no confidence) to
       * 1 (full confidence).
       * </pre>
       *
       * <code>float score = 2;</code>
       *
       * @return The score.
       */
      @java.lang.Override
      public float getScore() {
        return score_;
      }

      /**
       *
       *
       * <pre>
       * A confidence level on the match, ranging from 0 (no confidence) to
       * 1 (full confidence).
       * </pre>
       *
       * <code>float score = 2;</code>
       *
       * @param value The score to set.
       * @return This builder for chaining.
       */
      public Builder setScore(float value) {

        score_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A confidence level on the match, ranging from 0 (no confidence) to
       * 1 (full confidence).
       * </pre>
       *
       * <code>float score = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearScore() {
        bitField0_ = (bitField0_ & ~0x00000002);
        score_ = 0F;
        onChanged();
        return this;
      }

      private java.lang.Object image_ = "";

      /**
       *
       *
       * <pre>
       * The resource name of the image from the product that is the closest match
       * to the query.
       * </pre>
       *
       * <code>string image = 3;</code>
       *
       * @return The image.
       */
      public java.lang.String getImage() {
        java.lang.Object ref = image_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          image_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The resource name of the image from the product that is the closest match
       * to the query.
       * </pre>
       *
       * <code>string image = 3;</code>
       *
       * @return The bytes for image.
       */
      public com.google.protobuf.ByteString getImageBytes() {
        java.lang.Object ref = image_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          image_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The resource name of the image from the product that is the closest match
       * to the query.
       * </pre>
       *
       * <code>string image = 3;</code>
       *
       * @param value The image to set.
       * @return This builder for chaining.
       */
      public Builder setImage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        image_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The resource name of the image from the product that is the closest match
       * to the query.
       * </pre>
       *
       * <code>string image = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearImage() {
        image_ = getDefaultInstance().getImage();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The resource name of the image from the product that is the closest match
       * to the query.
       * </pre>
       *
       * <code>string image = 3;</code>
       *
       * @param value The bytes for image to set.
       * @return This builder for chaining.
       */
      public Builder setImageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        image_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p3beta1.ProductSearchResults.Result)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p3beta1.ProductSearchResults.Result)
    private static final com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result();
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Result> PARSER =
        new com.google.protobuf.AbstractParser<Result>() {
          @java.lang.Override
          public Result parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Result> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Result> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ObjectAnnotationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Object ID that should align with EntityAnnotation mid.
     * </pre>
     *
     * <code>string mid = 1;</code>
     *
     * @return The mid.
     */
    java.lang.String getMid();

    /**
     *
     *
     * <pre>
     * Object ID that should align with EntityAnnotation mid.
     * </pre>
     *
     * <code>string mid = 1;</code>
     *
     * @return The bytes for mid.
     */
    com.google.protobuf.ByteString getMidBytes();

    /**
     *
     *
     * <pre>
     * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
     * </pre>
     *
     * <code>string language_code = 2;</code>
     *
     * @return The languageCode.
     */
    java.lang.String getLanguageCode();

    /**
     *
     *
     * <pre>
     * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
     * </pre>
     *
     * <code>string language_code = 2;</code>
     *
     * @return The bytes for languageCode.
     */
    com.google.protobuf.ByteString getLanguageCodeBytes();

    /**
     *
     *
     * <pre>
     * Object name, expressed in its `language_code` language.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The name.
     */
    java.lang.String getName();

    /**
     *
     *
     * <pre>
     * Object name, expressed in its `language_code` language.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Score of the result. Range [0, 1].
     * </pre>
     *
     * <code>float score = 4;</code>
     *
     * @return The score.
     */
    float getScore();
  }

  /**
   *
   *
   * <pre>
   * Prediction for what the object in the bounding box is.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation}
   */
  public static final class ObjectAnnotation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation)
      ObjectAnnotationOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ObjectAnnotation.newBuilder() to construct.
    private ObjectAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ObjectAnnotation() {
      mid_ = "";
      languageCode_ = "";
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ObjectAnnotation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchProto
          .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_ObjectAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchProto
          .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_ObjectAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation.class,
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation.Builder
                  .class);
    }

    public static final int MID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object mid_ = "";

    /**
     *
     *
     * <pre>
     * Object ID that should align with EntityAnnotation mid.
     * </pre>
     *
     * <code>string mid = 1;</code>
     *
     * @return The mid.
     */
    @java.lang.Override
    public java.lang.String getMid() {
      java.lang.Object ref = mid_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mid_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Object ID that should align with EntityAnnotation mid.
     * </pre>
     *
     * <code>string mid = 1;</code>
     *
     * @return The bytes for mid.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMidBytes() {
      java.lang.Object ref = mid_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LANGUAGE_CODE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object languageCode_ = "";

    /**
     *
     *
     * <pre>
     * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
     * </pre>
     *
     * <code>string language_code = 2;</code>
     *
     * @return The languageCode.
     */
    @java.lang.Override
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
     * </pre>
     *
     * <code>string language_code = 2;</code>
     *
     * @return The bytes for languageCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAME_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Object name, expressed in its `language_code` language.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Object name, expressed in its `language_code` language.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCORE_FIELD_NUMBER = 4;
    private float score_ = 0F;

    /**
     *
     *
     * <pre>
     * Score of the result. Range [0, 1].
     * </pre>
     *
     * <code>float score = 4;</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public float getScore() {
      return score_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mid_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, mid_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, languageCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, name_);
      }
      if (java.lang.Float.floatToRawIntBits(score_) != 0) {
        output.writeFloat(4, score_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mid_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, mid_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, languageCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, name_);
      }
      if (java.lang.Float.floatToRawIntBits(score_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, score_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation)) {
        return super.equals(obj);
      }
      com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation other =
          (com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation) obj;

      if (!getMid().equals(other.getMid())) return false;
      if (!getLanguageCode().equals(other.getLanguageCode())) return false;
      if (!getName().equals(other.getName())) return false;
      if (java.lang.Float.floatToIntBits(getScore())
          != java.lang.Float.floatToIntBits(other.getScore())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MID_FIELD_NUMBER;
      hash = (53 * hash) + getMid().hashCode();
      hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getLanguageCode().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + SCORE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getScore());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Prediction for what the object in the bounding box is.
     * </pre>
     *
     * Protobuf type {@code google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation)
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.vision.v1p3beta1.ProductSearchProto
            .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_ObjectAnnotation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.vision.v1p3beta1.ProductSearchProto
            .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_ObjectAnnotation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation.class,
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        mid_ = "";
        languageCode_ = "";
        name_ = "";
        score_ = 0F;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.vision.v1p3beta1.ProductSearchProto
            .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_ObjectAnnotation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation
          getDefaultInstanceForType() {
        return com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation build() {
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation
          buildPartial() {
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation result =
            new com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.mid_ = mid_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.languageCode_ = languageCode_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.score_ = score_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation) {
          return mergeFrom(
              (com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation other) {
        if (other
            == com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation
                .getDefaultInstance()) return this;
        if (!other.getMid().isEmpty()) {
          mid_ = other.mid_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getLanguageCode().isEmpty()) {
          languageCode_ = other.languageCode_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.getScore() != 0F) {
          setScore(other.getScore());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  mid_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  languageCode_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 37:
                {
                  score_ = input.readFloat();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 37
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object mid_ = "";

      /**
       *
       *
       * <pre>
       * Object ID that should align with EntityAnnotation mid.
       * </pre>
       *
       * <code>string mid = 1;</code>
       *
       * @return The mid.
       */
      public java.lang.String getMid() {
        java.lang.Object ref = mid_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          mid_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Object ID that should align with EntityAnnotation mid.
       * </pre>
       *
       * <code>string mid = 1;</code>
       *
       * @return The bytes for mid.
       */
      public com.google.protobuf.ByteString getMidBytes() {
        java.lang.Object ref = mid_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          mid_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Object ID that should align with EntityAnnotation mid.
       * </pre>
       *
       * <code>string mid = 1;</code>
       *
       * @param value The mid to set.
       * @return This builder for chaining.
       */
      public Builder setMid(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        mid_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Object ID that should align with EntityAnnotation mid.
       * </pre>
       *
       * <code>string mid = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMid() {
        mid_ = getDefaultInstance().getMid();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Object ID that should align with EntityAnnotation mid.
       * </pre>
       *
       * <code>string mid = 1;</code>
       *
       * @param value The bytes for mid to set.
       * @return This builder for chaining.
       */
      public Builder setMidBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        mid_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object languageCode_ = "";

      /**
       *
       *
       * <pre>
       * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
       * information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 2;</code>
       *
       * @return The languageCode.
       */
      public java.lang.String getLanguageCode() {
        java.lang.Object ref = languageCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          languageCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
       * information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 2;</code>
       *
       * @return The bytes for languageCode.
       */
      public com.google.protobuf.ByteString getLanguageCodeBytes() {
        java.lang.Object ref = languageCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          languageCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
       * information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 2;</code>
       *
       * @param value The languageCode to set.
       * @return This builder for chaining.
       */
      public Builder setLanguageCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        languageCode_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
       * information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLanguageCode() {
        languageCode_ = getDefaultInstance().getLanguageCode();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The BCP-47 language code, such as "en-US" or "sr-Latn". For more
       * information, see
       * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
       * </pre>
       *
       * <code>string language_code = 2;</code>
       *
       * @param value The bytes for languageCode to set.
       * @return This builder for chaining.
       */
      public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        languageCode_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";

      /**
       *
       *
       * <pre>
       * Object name, expressed in its `language_code` language.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Object name, expressed in its `language_code` language.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Object name, expressed in its `language_code` language.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Object name, expressed in its `language_code` language.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Object name, expressed in its `language_code` language.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private float score_;

      /**
       *
       *
       * <pre>
       * Score of the result. Range [0, 1].
       * </pre>
       *
       * <code>float score = 4;</code>
       *
       * @return The score.
       */
      @java.lang.Override
      public float getScore() {
        return score_;
      }

      /**
       *
       *
       * <pre>
       * Score of the result. Range [0, 1].
       * </pre>
       *
       * <code>float score = 4;</code>
       *
       * @param value The score to set.
       * @return This builder for chaining.
       */
      public Builder setScore(float value) {

        score_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Score of the result. Range [0, 1].
       * </pre>
       *
       * <code>float score = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearScore() {
        bitField0_ = (bitField0_ & ~0x00000008);
        score_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation)
    private static final com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation();
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ObjectAnnotation> PARSER =
        new com.google.protobuf.AbstractParser<ObjectAnnotation>() {
          @java.lang.Override
          public ObjectAnnotation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ObjectAnnotation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ObjectAnnotation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GroupedResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The bounding polygon around the product detected in the query image.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 1;</code>
     *
     * @return Whether the boundingPoly field is set.
     */
    boolean hasBoundingPoly();

    /**
     *
     *
     * <pre>
     * The bounding polygon around the product detected in the query image.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 1;</code>
     *
     * @return The boundingPoly.
     */
    com.google.cloud.vision.v1p3beta1.BoundingPoly getBoundingPoly();

    /**
     *
     *
     * <pre>
     * The bounding polygon around the product detected in the query image.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 1;</code>
     */
    com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder();

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;</code>
     */
    java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result> getResultsList();

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;</code>
     */
    com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result getResults(int index);

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;</code>
     */
    int getResultsCount();

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;</code>
     */
    java.util.List<? extends com.google.cloud.vision.v1p3beta1.ProductSearchResults.ResultOrBuilder>
        getResultsOrBuilderList();

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;</code>
     */
    com.google.cloud.vision.v1p3beta1.ProductSearchResults.ResultOrBuilder getResultsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * List of generic predictions for the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
     * </code>
     */
    java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation>
        getObjectAnnotationsList();

    /**
     *
     *
     * <pre>
     * List of generic predictions for the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
     * </code>
     */
    com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation getObjectAnnotations(
        int index);

    /**
     *
     *
     * <pre>
     * List of generic predictions for the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
     * </code>
     */
    int getObjectAnnotationsCount();

    /**
     *
     *
     * <pre>
     * List of generic predictions for the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotationOrBuilder>
        getObjectAnnotationsOrBuilderList();

    /**
     *
     *
     * <pre>
     * List of generic predictions for the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
     * </code>
     */
    com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotationOrBuilder
        getObjectAnnotationsOrBuilder(int index);
  }

  /**
   *
   *
   * <pre>
   * Information about the products similar to a single product in a query
   * image.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult}
   */
  public static final class GroupedResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult)
      GroupedResultOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use GroupedResult.newBuilder() to construct.
    private GroupedResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GroupedResult() {
      results_ = java.util.Collections.emptyList();
      objectAnnotations_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GroupedResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchProto
          .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_GroupedResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchProto
          .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_GroupedResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult.class,
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult.Builder.class);
    }

    private int bitField0_;
    public static final int BOUNDING_POLY_FIELD_NUMBER = 1;
    private com.google.cloud.vision.v1p3beta1.BoundingPoly boundingPoly_;

    /**
     *
     *
     * <pre>
     * The bounding polygon around the product detected in the query image.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 1;</code>
     *
     * @return Whether the boundingPoly field is set.
     */
    @java.lang.Override
    public boolean hasBoundingPoly() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The bounding polygon around the product detected in the query image.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 1;</code>
     *
     * @return The boundingPoly.
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.BoundingPoly getBoundingPoly() {
      return boundingPoly_ == null
          ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
          : boundingPoly_;
    }

    /**
     *
     *
     * <pre>
     * The bounding polygon around the product detected in the query image.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder() {
      return boundingPoly_ == null
          ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
          : boundingPoly_;
    }

    public static final int RESULTS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result> results_;

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result>
        getResultsList() {
      return results_;
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.vision.v1p3beta1.ProductSearchResults.ResultOrBuilder>
        getResultsOrBuilderList() {
      return results_;
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;</code>
     */
    @java.lang.Override
    public int getResultsCount() {
      return results_.size();
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result getResults(int index) {
      return results_.get(index);
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.ResultOrBuilder
        getResultsOrBuilder(int index) {
      return results_.get(index);
    }

    public static final int OBJECT_ANNOTATIONS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation>
        objectAnnotations_;

    /**
     *
     *
     * <pre>
     * List of generic predictions for the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation>
        getObjectAnnotationsList() {
      return objectAnnotations_;
    }

    /**
     *
     *
     * <pre>
     * List of generic predictions for the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotationOrBuilder>
        getObjectAnnotationsOrBuilderList() {
      return objectAnnotations_;
    }

    /**
     *
     *
     * <pre>
     * List of generic predictions for the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
     * </code>
     */
    @java.lang.Override
    public int getObjectAnnotationsCount() {
      return objectAnnotations_.size();
    }

    /**
     *
     *
     * <pre>
     * List of generic predictions for the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation
        getObjectAnnotations(int index) {
      return objectAnnotations_.get(index);
    }

    /**
     *
     *
     * <pre>
     * List of generic predictions for the object in the bounding box.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotationOrBuilder
        getObjectAnnotationsOrBuilder(int index) {
      return objectAnnotations_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getBoundingPoly());
      }
      for (int i = 0; i < results_.size(); i++) {
        output.writeMessage(2, results_.get(i));
      }
      for (int i = 0; i < objectAnnotations_.size(); i++) {
        output.writeMessage(3, objectAnnotations_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getBoundingPoly());
      }
      for (int i = 0; i < results_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, results_.get(i));
      }
      for (int i = 0; i < objectAnnotations_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, objectAnnotations_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult)) {
        return super.equals(obj);
      }
      com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult other =
          (com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult) obj;

      if (hasBoundingPoly() != other.hasBoundingPoly()) return false;
      if (hasBoundingPoly()) {
        if (!getBoundingPoly().equals(other.getBoundingPoly())) return false;
      }
      if (!getResultsList().equals(other.getResultsList())) return false;
      if (!getObjectAnnotationsList().equals(other.getObjectAnnotationsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasBoundingPoly()) {
        hash = (37 * hash) + BOUNDING_POLY_FIELD_NUMBER;
        hash = (53 * hash) + getBoundingPoly().hashCode();
      }
      if (getResultsCount() > 0) {
        hash = (37 * hash) + RESULTS_FIELD_NUMBER;
        hash = (53 * hash) + getResultsList().hashCode();
      }
      if (getObjectAnnotationsCount() > 0) {
        hash = (37 * hash) + OBJECT_ANNOTATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getObjectAnnotationsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Information about the products similar to a single product in a query
     * image.
     * </pre>
     *
     * Protobuf type {@code google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult)
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.vision.v1p3beta1.ProductSearchProto
            .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_GroupedResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.vision.v1p3beta1.ProductSearchProto
            .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_GroupedResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult.class,
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult.Builder.class);
      }

      // Construct using
      // com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getBoundingPolyFieldBuilder();
          getResultsFieldBuilder();
          getObjectAnnotationsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        boundingPoly_ = null;
        if (boundingPolyBuilder_ != null) {
          boundingPolyBuilder_.dispose();
          boundingPolyBuilder_ = null;
        }
        if (resultsBuilder_ == null) {
          results_ = java.util.Collections.emptyList();
        } else {
          results_ = null;
          resultsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (objectAnnotationsBuilder_ == null) {
          objectAnnotations_ = java.util.Collections.emptyList();
        } else {
          objectAnnotations_ = null;
          objectAnnotationsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.vision.v1p3beta1.ProductSearchProto
            .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_GroupedResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult
          getDefaultInstanceForType() {
        return com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult build() {
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult buildPartial() {
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult result =
            new com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult result) {
        if (resultsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            results_ = java.util.Collections.unmodifiableList(results_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.results_ = results_;
        } else {
          result.results_ = resultsBuilder_.build();
        }
        if (objectAnnotationsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            objectAnnotations_ = java.util.Collections.unmodifiableList(objectAnnotations_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.objectAnnotations_ = objectAnnotations_;
        } else {
          result.objectAnnotations_ = objectAnnotationsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.boundingPoly_ =
              boundingPolyBuilder_ == null ? boundingPoly_ : boundingPolyBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult) {
          return mergeFrom(
              (com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult other) {
        if (other
            == com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult
                .getDefaultInstance()) return this;
        if (other.hasBoundingPoly()) {
          mergeBoundingPoly(other.getBoundingPoly());
        }
        if (resultsBuilder_ == null) {
          if (!other.results_.isEmpty()) {
            if (results_.isEmpty()) {
              results_ = other.results_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureResultsIsMutable();
              results_.addAll(other.results_);
            }
            onChanged();
          }
        } else {
          if (!other.results_.isEmpty()) {
            if (resultsBuilder_.isEmpty()) {
              resultsBuilder_.dispose();
              resultsBuilder_ = null;
              results_ = other.results_;
              bitField0_ = (bitField0_ & ~0x00000002);
              resultsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getResultsFieldBuilder()
                      : null;
            } else {
              resultsBuilder_.addAllMessages(other.results_);
            }
          }
        }
        if (objectAnnotationsBuilder_ == null) {
          if (!other.objectAnnotations_.isEmpty()) {
            if (objectAnnotations_.isEmpty()) {
              objectAnnotations_ = other.objectAnnotations_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureObjectAnnotationsIsMutable();
              objectAnnotations_.addAll(other.objectAnnotations_);
            }
            onChanged();
          }
        } else {
          if (!other.objectAnnotations_.isEmpty()) {
            if (objectAnnotationsBuilder_.isEmpty()) {
              objectAnnotationsBuilder_.dispose();
              objectAnnotationsBuilder_ = null;
              objectAnnotations_ = other.objectAnnotations_;
              bitField0_ = (bitField0_ & ~0x00000004);
              objectAnnotationsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getObjectAnnotationsFieldBuilder()
                      : null;
            } else {
              objectAnnotationsBuilder_.addAllMessages(other.objectAnnotations_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getBoundingPolyFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result m =
                      input.readMessage(
                          com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.parser(),
                          extensionRegistry);
                  if (resultsBuilder_ == null) {
                    ensureResultsIsMutable();
                    results_.add(m);
                  } else {
                    resultsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 26:
                {
                  com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation m =
                      input.readMessage(
                          com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation
                              .parser(),
                          extensionRegistry);
                  if (objectAnnotationsBuilder_ == null) {
                    ensureObjectAnnotationsIsMutable();
                    objectAnnotations_.add(m);
                  } else {
                    objectAnnotationsBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.vision.v1p3beta1.BoundingPoly boundingPoly_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.vision.v1p3beta1.BoundingPoly,
              com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
              com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>
          boundingPolyBuilder_;

      /**
       *
       *
       * <pre>
       * The bounding polygon around the product detected in the query image.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 1;</code>
       *
       * @return Whether the boundingPoly field is set.
       */
      public boolean hasBoundingPoly() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The bounding polygon around the product detected in the query image.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 1;</code>
       *
       * @return The boundingPoly.
       */
      public com.google.cloud.vision.v1p3beta1.BoundingPoly getBoundingPoly() {
        if (boundingPolyBuilder_ == null) {
          return boundingPoly_ == null
              ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
              : boundingPoly_;
        } else {
          return boundingPolyBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The bounding polygon around the product detected in the query image.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 1;</code>
       */
      public Builder setBoundingPoly(com.google.cloud.vision.v1p3beta1.BoundingPoly value) {
        if (boundingPolyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          boundingPoly_ = value;
        } else {
          boundingPolyBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The bounding polygon around the product detected in the query image.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 1;</code>
       */
      public Builder setBoundingPoly(
          com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder builderForValue) {
        if (boundingPolyBuilder_ == null) {
          boundingPoly_ = builderForValue.build();
        } else {
          boundingPolyBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The bounding polygon around the product detected in the query image.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 1;</code>
       */
      public Builder mergeBoundingPoly(com.google.cloud.vision.v1p3beta1.BoundingPoly value) {
        if (boundingPolyBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && boundingPoly_ != null
              && boundingPoly_
                  != com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()) {
            getBoundingPolyBuilder().mergeFrom(value);
          } else {
            boundingPoly_ = value;
          }
        } else {
          boundingPolyBuilder_.mergeFrom(value);
        }
        if (boundingPoly_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The bounding polygon around the product detected in the query image.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 1;</code>
       */
      public Builder clearBoundingPoly() {
        bitField0_ = (bitField0_ & ~0x00000001);
        boundingPoly_ = null;
        if (boundingPolyBuilder_ != null) {
          boundingPolyBuilder_.dispose();
          boundingPolyBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The bounding polygon around the product detected in the query image.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 1;</code>
       */
      public com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder getBoundingPolyBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getBoundingPolyFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The bounding polygon around the product detected in the query image.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 1;</code>
       */
      public com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder() {
        if (boundingPolyBuilder_ != null) {
          return boundingPolyBuilder_.getMessageOrBuilder();
        } else {
          return boundingPoly_ == null
              ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
              : boundingPoly_;
        }
      }

      /**
       *
       *
       * <pre>
       * The bounding polygon around the product detected in the query image.
       * </pre>
       *
       * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_poly = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.vision.v1p3beta1.BoundingPoly,
              com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
              com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>
          getBoundingPolyFieldBuilder() {
        if (boundingPolyBuilder_ == null) {
          boundingPolyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.vision.v1p3beta1.BoundingPoly,
                  com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
                  com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>(
                  getBoundingPoly(), getParentForChildren(), isClean());
          boundingPoly_ = null;
        }
        return boundingPolyBuilder_;
      }

      private java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result>
          results_ = java.util.Collections.emptyList();

      private void ensureResultsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          results_ =
              new java.util.ArrayList<
                  com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result>(results_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result,
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder,
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.ResultOrBuilder>
          resultsBuilder_;

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result>
          getResultsList() {
        if (resultsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(results_);
        } else {
          return resultsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public int getResultsCount() {
        if (resultsBuilder_ == null) {
          return results_.size();
        } else {
          return resultsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result getResults(int index) {
        if (resultsBuilder_ == null) {
          return results_.get(index);
        } else {
          return resultsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public Builder setResults(
          int index, com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result value) {
        if (resultsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResultsIsMutable();
          results_.set(index, value);
          onChanged();
        } else {
          resultsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public Builder setResults(
          int index,
          com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder builderForValue) {
        if (resultsBuilder_ == null) {
          ensureResultsIsMutable();
          results_.set(index, builderForValue.build());
          onChanged();
        } else {
          resultsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public Builder addResults(
          com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result value) {
        if (resultsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResultsIsMutable();
          results_.add(value);
          onChanged();
        } else {
          resultsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public Builder addResults(
          int index, com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result value) {
        if (resultsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResultsIsMutable();
          results_.add(index, value);
          onChanged();
        } else {
          resultsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public Builder addResults(
          com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder builderForValue) {
        if (resultsBuilder_ == null) {
          ensureResultsIsMutable();
          results_.add(builderForValue.build());
          onChanged();
        } else {
          resultsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public Builder addResults(
          int index,
          com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder builderForValue) {
        if (resultsBuilder_ == null) {
          ensureResultsIsMutable();
          results_.add(index, builderForValue.build());
          onChanged();
        } else {
          resultsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public Builder addAllResults(
          java.lang.Iterable<
                  ? extends com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result>
              values) {
        if (resultsBuilder_ == null) {
          ensureResultsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, results_);
          onChanged();
        } else {
          resultsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public Builder clearResults() {
        if (resultsBuilder_ == null) {
          results_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          resultsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public Builder removeResults(int index) {
        if (resultsBuilder_ == null) {
          ensureResultsIsMutable();
          results_.remove(index);
          onChanged();
        } else {
          resultsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder
          getResultsBuilder(int index) {
        return getResultsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.ResultOrBuilder
          getResultsOrBuilder(int index) {
        if (resultsBuilder_ == null) {
          return results_.get(index);
        } else {
          return resultsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.vision.v1p3beta1.ProductSearchResults.ResultOrBuilder>
          getResultsOrBuilderList() {
        if (resultsBuilder_ != null) {
          return resultsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(results_);
        }
      }

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder
          addResultsBuilder() {
        return getResultsFieldBuilder()
            .addBuilder(
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder
          addResultsBuilder(int index) {
        return getResultsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * List of results, one for each product match.
       * </pre>
       *
       * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 2;
       * </code>
       */
      public java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder>
          getResultsBuilderList() {
        return getResultsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result,
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder,
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.ResultOrBuilder>
          getResultsFieldBuilder() {
        if (resultsBuilder_ == null) {
          resultsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result,
                  com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder,
                  com.google.cloud.vision.v1p3beta1.ProductSearchResults.ResultOrBuilder>(
                  results_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          results_ = null;
        }
        return resultsBuilder_;
      }

      private java.util.List<
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation>
          objectAnnotations_ = java.util.Collections.emptyList();

      private void ensureObjectAnnotationsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          objectAnnotations_ =
              new java.util.ArrayList<
                  com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation>(
                  objectAnnotations_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation,
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation.Builder,
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotationOrBuilder>
          objectAnnotationsBuilder_;

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation>
          getObjectAnnotationsList() {
        if (objectAnnotationsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(objectAnnotations_);
        } else {
          return objectAnnotationsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public int getObjectAnnotationsCount() {
        if (objectAnnotationsBuilder_ == null) {
          return objectAnnotations_.size();
        } else {
          return objectAnnotationsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation
          getObjectAnnotations(int index) {
        if (objectAnnotationsBuilder_ == null) {
          return objectAnnotations_.get(index);
        } else {
          return objectAnnotationsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public Builder setObjectAnnotations(
          int index,
          com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation value) {
        if (objectAnnotationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureObjectAnnotationsIsMutable();
          objectAnnotations_.set(index, value);
          onChanged();
        } else {
          objectAnnotationsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public Builder setObjectAnnotations(
          int index,
          com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation.Builder
              builderForValue) {
        if (objectAnnotationsBuilder_ == null) {
          ensureObjectAnnotationsIsMutable();
          objectAnnotations_.set(index, builderForValue.build());
          onChanged();
        } else {
          objectAnnotationsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public Builder addObjectAnnotations(
          com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation value) {
        if (objectAnnotationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureObjectAnnotationsIsMutable();
          objectAnnotations_.add(value);
          onChanged();
        } else {
          objectAnnotationsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public Builder addObjectAnnotations(
          int index,
          com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation value) {
        if (objectAnnotationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureObjectAnnotationsIsMutable();
          objectAnnotations_.add(index, value);
          onChanged();
        } else {
          objectAnnotationsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public Builder addObjectAnnotations(
          com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation.Builder
              builderForValue) {
        if (objectAnnotationsBuilder_ == null) {
          ensureObjectAnnotationsIsMutable();
          objectAnnotations_.add(builderForValue.build());
          onChanged();
        } else {
          objectAnnotationsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public Builder addObjectAnnotations(
          int index,
          com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation.Builder
              builderForValue) {
        if (objectAnnotationsBuilder_ == null) {
          ensureObjectAnnotationsIsMutable();
          objectAnnotations_.add(index, builderForValue.build());
          onChanged();
        } else {
          objectAnnotationsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public Builder addAllObjectAnnotations(
          java.lang.Iterable<
                  ? extends com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation>
              values) {
        if (objectAnnotationsBuilder_ == null) {
          ensureObjectAnnotationsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, objectAnnotations_);
          onChanged();
        } else {
          objectAnnotationsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public Builder clearObjectAnnotations() {
        if (objectAnnotationsBuilder_ == null) {
          objectAnnotations_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          objectAnnotationsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public Builder removeObjectAnnotations(int index) {
        if (objectAnnotationsBuilder_ == null) {
          ensureObjectAnnotationsIsMutable();
          objectAnnotations_.remove(index);
          onChanged();
        } else {
          objectAnnotationsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation.Builder
          getObjectAnnotationsBuilder(int index) {
        return getObjectAnnotationsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotationOrBuilder
          getObjectAnnotationsOrBuilder(int index) {
        if (objectAnnotationsBuilder_ == null) {
          return objectAnnotations_.get(index);
        } else {
          return objectAnnotationsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotationOrBuilder>
          getObjectAnnotationsOrBuilderList() {
        if (objectAnnotationsBuilder_ != null) {
          return objectAnnotationsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(objectAnnotations_);
        }
      }

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation.Builder
          addObjectAnnotationsBuilder() {
        return getObjectAnnotationsFieldBuilder()
            .addBuilder(
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation.Builder
          addObjectAnnotationsBuilder(int index) {
        return getObjectAnnotationsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * List of generic predictions for the object in the bounding box.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation object_annotations = 3;
       * </code>
       */
      public java.util.List<
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation.Builder>
          getObjectAnnotationsBuilderList() {
        return getObjectAnnotationsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation,
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation.Builder,
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotationOrBuilder>
          getObjectAnnotationsFieldBuilder() {
        if (objectAnnotationsBuilder_ == null) {
          objectAnnotationsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation,
                  com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotation.Builder,
                  com.google.cloud.vision.v1p3beta1.ProductSearchResults.ObjectAnnotationOrBuilder>(
                  objectAnnotations_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          objectAnnotations_ = null;
        }
        return objectAnnotationsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult)
    private static final com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult();
    }

    public static com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GroupedResult> PARSER =
        new com.google.protobuf.AbstractParser<GroupedResult>() {
          @java.lang.Override
          public GroupedResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GroupedResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GroupedResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int INDEX_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp indexTime_;

  /**
   *
   *
   * <pre>
   * Timestamp of the index which provided these results. Products added to the
   * product set and products removed from the product set after this time are
   * not reflected in the current results.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp index_time = 2;</code>
   *
   * @return Whether the indexTime field is set.
   */
  @java.lang.Override
  public boolean hasIndexTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Timestamp of the index which provided these results. Products added to the
   * product set and products removed from the product set after this time are
   * not reflected in the current results.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp index_time = 2;</code>
   *
   * @return The indexTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getIndexTime() {
    return indexTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : indexTime_;
  }

  /**
   *
   *
   * <pre>
   * Timestamp of the index which provided these results. Products added to the
   * product set and products removed from the product set after this time are
   * not reflected in the current results.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp index_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getIndexTimeOrBuilder() {
    return indexTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : indexTime_;
  }

  public static final int RESULTS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result> results_;

  /**
   *
   *
   * <pre>
   * List of results, one for each product match.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result>
      getResultsList() {
    return results_;
  }

  /**
   *
   *
   * <pre>
   * List of results, one for each product match.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.vision.v1p3beta1.ProductSearchResults.ResultOrBuilder>
      getResultsOrBuilderList() {
    return results_;
  }

  /**
   *
   *
   * <pre>
   * List of results, one for each product match.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
   */
  @java.lang.Override
  public int getResultsCount() {
    return results_.size();
  }

  /**
   *
   *
   * <pre>
   * List of results, one for each product match.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result getResults(int index) {
    return results_.get(index);
  }

  /**
   *
   *
   * <pre>
   * List of results, one for each product match.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.ProductSearchResults.ResultOrBuilder getResultsOrBuilder(
      int index) {
    return results_.get(index);
  }

  public static final int PRODUCT_GROUPED_RESULTS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult>
      productGroupedResults_;

  /**
   *
   *
   * <pre>
   * List of results grouped by products detected in the query image. Each entry
   * corresponds to one bounding polygon in the query image, and contains the
   * matching products specific to that region. There may be duplicate product
   * matches in the union of all the per-product results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult>
      getProductGroupedResultsList() {
    return productGroupedResults_;
  }

  /**
   *
   *
   * <pre>
   * List of results grouped by products detected in the query image. Each entry
   * corresponds to one bounding polygon in the query image, and contains the
   * matching products specific to that region. There may be duplicate product
   * matches in the union of all the per-product results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResultOrBuilder>
      getProductGroupedResultsOrBuilderList() {
    return productGroupedResults_;
  }

  /**
   *
   *
   * <pre>
   * List of results grouped by products detected in the query image. Each entry
   * corresponds to one bounding polygon in the query image, and contains the
   * matching products specific to that region. There may be duplicate product
   * matches in the union of all the per-product results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
   * </code>
   */
  @java.lang.Override
  public int getProductGroupedResultsCount() {
    return productGroupedResults_.size();
  }

  /**
   *
   *
   * <pre>
   * List of results grouped by products detected in the query image. Each entry
   * corresponds to one bounding polygon in the query image, and contains the
   * matching products specific to that region. There may be duplicate product
   * matches in the union of all the per-product results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult
      getProductGroupedResults(int index) {
    return productGroupedResults_.get(index);
  }

  /**
   *
   *
   * <pre>
   * List of results grouped by products detected in the query image. Each entry
   * corresponds to one bounding polygon in the query image, and contains the
   * matching products specific to that region. There may be duplicate product
   * matches in the union of all the per-product results.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResultOrBuilder
      getProductGroupedResultsOrBuilder(int index) {
    return productGroupedResults_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getIndexTime());
    }
    for (int i = 0; i < results_.size(); i++) {
      output.writeMessage(5, results_.get(i));
    }
    for (int i = 0; i < productGroupedResults_.size(); i++) {
      output.writeMessage(6, productGroupedResults_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getIndexTime());
    }
    for (int i = 0; i < results_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, results_.get(i));
    }
    for (int i = 0; i < productGroupedResults_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, productGroupedResults_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1p3beta1.ProductSearchResults)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1p3beta1.ProductSearchResults other =
        (com.google.cloud.vision.v1p3beta1.ProductSearchResults) obj;

    if (hasIndexTime() != other.hasIndexTime()) return false;
    if (hasIndexTime()) {
      if (!getIndexTime().equals(other.getIndexTime())) return false;
    }
    if (!getResultsList().equals(other.getResultsList())) return false;
    if (!getProductGroupedResultsList().equals(other.getProductGroupedResultsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasIndexTime()) {
      hash = (37 * hash) + INDEX_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getIndexTime().hashCode();
    }
    if (getResultsCount() > 0) {
      hash = (37 * hash) + RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getResultsList().hashCode();
    }
    if (getProductGroupedResultsCount() > 0) {
      hash = (37 * hash) + PRODUCT_GROUPED_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getProductGroupedResultsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchResults parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchResults parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchResults parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchResults parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchResults parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchResults parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchResults parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchResults parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchResults parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchResults parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchResults parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchResults parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.vision.v1p3beta1.ProductSearchResults prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Results for a product search request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p3beta1.ProductSearchResults}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p3beta1.ProductSearchResults)
      com.google.cloud.vision.v1p3beta1.ProductSearchResultsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchProto
          .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchProto
          .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.class,
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1p3beta1.ProductSearchResults.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getIndexTimeFieldBuilder();
        getResultsFieldBuilder();
        getProductGroupedResultsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      indexTime_ = null;
      if (indexTimeBuilder_ != null) {
        indexTimeBuilder_.dispose();
        indexTimeBuilder_ = null;
      }
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
      } else {
        results_ = null;
        resultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (productGroupedResultsBuilder_ == null) {
        productGroupedResults_ = java.util.Collections.emptyList();
      } else {
        productGroupedResults_ = null;
        productGroupedResultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchProto
          .internal_static_google_cloud_vision_v1p3beta1_ProductSearchResults_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults getDefaultInstanceForType() {
      return com.google.cloud.vision.v1p3beta1.ProductSearchResults.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults build() {
      com.google.cloud.vision.v1p3beta1.ProductSearchResults result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults buildPartial() {
      com.google.cloud.vision.v1p3beta1.ProductSearchResults result =
          new com.google.cloud.vision.v1p3beta1.ProductSearchResults(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.vision.v1p3beta1.ProductSearchResults result) {
      if (resultsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          results_ = java.util.Collections.unmodifiableList(results_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.results_ = results_;
      } else {
        result.results_ = resultsBuilder_.build();
      }
      if (productGroupedResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          productGroupedResults_ = java.util.Collections.unmodifiableList(productGroupedResults_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.productGroupedResults_ = productGroupedResults_;
      } else {
        result.productGroupedResults_ = productGroupedResultsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.vision.v1p3beta1.ProductSearchResults result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.indexTime_ = indexTimeBuilder_ == null ? indexTime_ : indexTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1p3beta1.ProductSearchResults) {
        return mergeFrom((com.google.cloud.vision.v1p3beta1.ProductSearchResults) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1p3beta1.ProductSearchResults other) {
      if (other == com.google.cloud.vision.v1p3beta1.ProductSearchResults.getDefaultInstance())
        return this;
      if (other.hasIndexTime()) {
        mergeIndexTime(other.getIndexTime());
      }
      if (resultsBuilder_ == null) {
        if (!other.results_.isEmpty()) {
          if (results_.isEmpty()) {
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureResultsIsMutable();
            results_.addAll(other.results_);
          }
          onChanged();
        }
      } else {
        if (!other.results_.isEmpty()) {
          if (resultsBuilder_.isEmpty()) {
            resultsBuilder_.dispose();
            resultsBuilder_ = null;
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000002);
            resultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResultsFieldBuilder()
                    : null;
          } else {
            resultsBuilder_.addAllMessages(other.results_);
          }
        }
      }
      if (productGroupedResultsBuilder_ == null) {
        if (!other.productGroupedResults_.isEmpty()) {
          if (productGroupedResults_.isEmpty()) {
            productGroupedResults_ = other.productGroupedResults_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureProductGroupedResultsIsMutable();
            productGroupedResults_.addAll(other.productGroupedResults_);
          }
          onChanged();
        }
      } else {
        if (!other.productGroupedResults_.isEmpty()) {
          if (productGroupedResultsBuilder_.isEmpty()) {
            productGroupedResultsBuilder_.dispose();
            productGroupedResultsBuilder_ = null;
            productGroupedResults_ = other.productGroupedResults_;
            bitField0_ = (bitField0_ & ~0x00000004);
            productGroupedResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getProductGroupedResultsFieldBuilder()
                    : null;
          } else {
            productGroupedResultsBuilder_.addAllMessages(other.productGroupedResults_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getIndexTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            case 42:
              {
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result m =
                    input.readMessage(
                        com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.parser(),
                        extensionRegistry);
                if (resultsBuilder_ == null) {
                  ensureResultsIsMutable();
                  results_.add(m);
                } else {
                  resultsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult m =
                    input.readMessage(
                        com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult
                            .parser(),
                        extensionRegistry);
                if (productGroupedResultsBuilder_ == null) {
                  ensureProductGroupedResultsIsMutable();
                  productGroupedResults_.add(m);
                } else {
                  productGroupedResultsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp indexTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        indexTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Timestamp of the index which provided these results. Products added to the
     * product set and products removed from the product set after this time are
     * not reflected in the current results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 2;</code>
     *
     * @return Whether the indexTime field is set.
     */
    public boolean hasIndexTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Timestamp of the index which provided these results. Products added to the
     * product set and products removed from the product set after this time are
     * not reflected in the current results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 2;</code>
     *
     * @return The indexTime.
     */
    public com.google.protobuf.Timestamp getIndexTime() {
      if (indexTimeBuilder_ == null) {
        return indexTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : indexTime_;
      } else {
        return indexTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Timestamp of the index which provided these results. Products added to the
     * product set and products removed from the product set after this time are
     * not reflected in the current results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 2;</code>
     */
    public Builder setIndexTime(com.google.protobuf.Timestamp value) {
      if (indexTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        indexTime_ = value;
      } else {
        indexTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Timestamp of the index which provided these results. Products added to the
     * product set and products removed from the product set after this time are
     * not reflected in the current results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 2;</code>
     */
    public Builder setIndexTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (indexTimeBuilder_ == null) {
        indexTime_ = builderForValue.build();
      } else {
        indexTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Timestamp of the index which provided these results. Products added to the
     * product set and products removed from the product set after this time are
     * not reflected in the current results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 2;</code>
     */
    public Builder mergeIndexTime(com.google.protobuf.Timestamp value) {
      if (indexTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && indexTime_ != null
            && indexTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getIndexTimeBuilder().mergeFrom(value);
        } else {
          indexTime_ = value;
        }
      } else {
        indexTimeBuilder_.mergeFrom(value);
      }
      if (indexTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Timestamp of the index which provided these results. Products added to the
     * product set and products removed from the product set after this time are
     * not reflected in the current results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 2;</code>
     */
    public Builder clearIndexTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      indexTime_ = null;
      if (indexTimeBuilder_ != null) {
        indexTimeBuilder_.dispose();
        indexTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Timestamp of the index which provided these results. Products added to the
     * product set and products removed from the product set after this time are
     * not reflected in the current results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getIndexTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getIndexTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Timestamp of the index which provided these results. Products added to the
     * product set and products removed from the product set after this time are
     * not reflected in the current results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getIndexTimeOrBuilder() {
      if (indexTimeBuilder_ != null) {
        return indexTimeBuilder_.getMessageOrBuilder();
      } else {
        return indexTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : indexTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Timestamp of the index which provided these results. Products added to the
     * product set and products removed from the product set after this time are
     * not reflected in the current results.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp index_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getIndexTimeFieldBuilder() {
      if (indexTimeBuilder_ == null) {
        indexTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getIndexTime(), getParentForChildren(), isClean());
        indexTime_ = null;
      }
      return indexTimeBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result> results_ =
        java.util.Collections.emptyList();

    private void ensureResultsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        results_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result>(
                results_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result,
            com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder,
            com.google.cloud.vision.v1p3beta1.ProductSearchResults.ResultOrBuilder>
        resultsBuilder_;

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result>
        getResultsList() {
      if (resultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(results_);
      } else {
        return resultsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public int getResultsCount() {
      if (resultsBuilder_ == null) {
        return results_.size();
      } else {
        return resultsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result getResults(int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public Builder setResults(
        int index, com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.set(index, value);
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public Builder setResults(
        int index,
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.set(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public Builder addResults(com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public Builder addResults(
        int index, com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(index, value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public Builder addResults(
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public Builder addResults(
        int index,
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public Builder addAllResults(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result>
            values) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, results_);
        onChanged();
      } else {
        resultsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public Builder clearResults() {
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        resultsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public Builder removeResults(int index) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.remove(index);
        onChanged();
      } else {
        resultsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder getResultsBuilder(
        int index) {
      return getResultsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.ResultOrBuilder
        getResultsOrBuilder(int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.vision.v1p3beta1.ProductSearchResults.ResultOrBuilder>
        getResultsOrBuilderList() {
      if (resultsBuilder_ != null) {
        return resultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(results_);
      }
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder
        addResultsBuilder() {
      return getResultsFieldBuilder()
          .addBuilder(
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder addResultsBuilder(
        int index) {
      return getResultsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of results, one for each product match.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.Result results = 5;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder>
        getResultsBuilderList() {
      return getResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result,
            com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder,
            com.google.cloud.vision.v1p3beta1.ProductSearchResults.ResultOrBuilder>
        getResultsFieldBuilder() {
      if (resultsBuilder_ == null) {
        resultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result,
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.Result.Builder,
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.ResultOrBuilder>(
                results_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        results_ = null;
      }
      return resultsBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult>
        productGroupedResults_ = java.util.Collections.emptyList();

    private void ensureProductGroupedResultsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        productGroupedResults_ =
            new java.util.ArrayList<
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult>(
                productGroupedResults_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult,
            com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult.Builder,
            com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResultOrBuilder>
        productGroupedResultsBuilder_;

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult>
        getProductGroupedResultsList() {
      if (productGroupedResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(productGroupedResults_);
      } else {
        return productGroupedResultsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public int getProductGroupedResultsCount() {
      if (productGroupedResultsBuilder_ == null) {
        return productGroupedResults_.size();
      } else {
        return productGroupedResultsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult
        getProductGroupedResults(int index) {
      if (productGroupedResultsBuilder_ == null) {
        return productGroupedResults_.get(index);
      } else {
        return productGroupedResultsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public Builder setProductGroupedResults(
        int index, com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult value) {
      if (productGroupedResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProductGroupedResultsIsMutable();
        productGroupedResults_.set(index, value);
        onChanged();
      } else {
        productGroupedResultsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public Builder setProductGroupedResults(
        int index,
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult.Builder
            builderForValue) {
      if (productGroupedResultsBuilder_ == null) {
        ensureProductGroupedResultsIsMutable();
        productGroupedResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        productGroupedResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public Builder addProductGroupedResults(
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult value) {
      if (productGroupedResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProductGroupedResultsIsMutable();
        productGroupedResults_.add(value);
        onChanged();
      } else {
        productGroupedResultsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public Builder addProductGroupedResults(
        int index, com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult value) {
      if (productGroupedResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProductGroupedResultsIsMutable();
        productGroupedResults_.add(index, value);
        onChanged();
      } else {
        productGroupedResultsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public Builder addProductGroupedResults(
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult.Builder
            builderForValue) {
      if (productGroupedResultsBuilder_ == null) {
        ensureProductGroupedResultsIsMutable();
        productGroupedResults_.add(builderForValue.build());
        onChanged();
      } else {
        productGroupedResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public Builder addProductGroupedResults(
        int index,
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult.Builder
            builderForValue) {
      if (productGroupedResultsBuilder_ == null) {
        ensureProductGroupedResultsIsMutable();
        productGroupedResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        productGroupedResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public Builder addAllProductGroupedResults(
        java.lang.Iterable<
                ? extends com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult>
            values) {
      if (productGroupedResultsBuilder_ == null) {
        ensureProductGroupedResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, productGroupedResults_);
        onChanged();
      } else {
        productGroupedResultsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public Builder clearProductGroupedResults() {
      if (productGroupedResultsBuilder_ == null) {
        productGroupedResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        productGroupedResultsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public Builder removeProductGroupedResults(int index) {
      if (productGroupedResultsBuilder_ == null) {
        ensureProductGroupedResultsIsMutable();
        productGroupedResults_.remove(index);
        onChanged();
      } else {
        productGroupedResultsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult.Builder
        getProductGroupedResultsBuilder(int index) {
      return getProductGroupedResultsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResultOrBuilder
        getProductGroupedResultsOrBuilder(int index) {
      if (productGroupedResultsBuilder_ == null) {
        return productGroupedResults_.get(index);
      } else {
        return productGroupedResultsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResultOrBuilder>
        getProductGroupedResultsOrBuilderList() {
      if (productGroupedResultsBuilder_ != null) {
        return productGroupedResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(productGroupedResults_);
      }
    }

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult.Builder
        addProductGroupedResultsBuilder() {
      return getProductGroupedResultsFieldBuilder()
          .addBuilder(
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult.Builder
        addProductGroupedResultsBuilder(int index) {
      return getProductGroupedResultsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of results grouped by products detected in the query image. Each entry
     * corresponds to one bounding polygon in the query image, and contains the
     * matching products specific to that region. There may be duplicate product
     * matches in the union of all the per-product results.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult product_grouped_results = 6;
     * </code>
     */
    public java.util.List<
            com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult.Builder>
        getProductGroupedResultsBuilderList() {
      return getProductGroupedResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult,
            com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult.Builder,
            com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResultOrBuilder>
        getProductGroupedResultsFieldBuilder() {
      if (productGroupedResultsBuilder_ == null) {
        productGroupedResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult,
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResult.Builder,
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.GroupedResultOrBuilder>(
                productGroupedResults_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        productGroupedResults_ = null;
      }
      return productGroupedResultsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p3beta1.ProductSearchResults)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p3beta1.ProductSearchResults)
  private static final com.google.cloud.vision.v1p3beta1.ProductSearchResults DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1p3beta1.ProductSearchResults();
  }

  public static com.google.cloud.vision.v1p3beta1.ProductSearchResults getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProductSearchResults> PARSER =
      new com.google.protobuf.AbstractParser<ProductSearchResults>() {
        @java.lang.Override
        public ProductSearchResults parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ProductSearchResults> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProductSearchResults> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.ProductSearchResults getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
