/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1p3beta1/text_annotation.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.vision.v1p3beta1;

/**
 *
 *
 * <pre>
 * Logical element on the page.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1p3beta1.Block}
 */
public final class Block extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p3beta1.Block)
    BlockOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Block.newBuilder() to construct.
  private Block(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Block() {
    paragraphs_ = java.util.Collections.emptyList();
    blockType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Block();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1p3beta1.TextAnnotationProto
        .internal_static_google_cloud_vision_v1p3beta1_Block_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1p3beta1.TextAnnotationProto
        .internal_static_google_cloud_vision_v1p3beta1_Block_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1p3beta1.Block.class,
            com.google.cloud.vision.v1p3beta1.Block.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type of a block (text, image etc) as identified by OCR.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.vision.v1p3beta1.Block.BlockType}
   */
  public enum BlockType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unknown block type.
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    UNKNOWN(0),
    /**
     *
     *
     * <pre>
     * Regular text block.
     * </pre>
     *
     * <code>TEXT = 1;</code>
     */
    TEXT(1),
    /**
     *
     *
     * <pre>
     * Table block.
     * </pre>
     *
     * <code>TABLE = 2;</code>
     */
    TABLE(2),
    /**
     *
     *
     * <pre>
     * Image block.
     * </pre>
     *
     * <code>PICTURE = 3;</code>
     */
    PICTURE(3),
    /**
     *
     *
     * <pre>
     * Horizontal/vertical line box.
     * </pre>
     *
     * <code>RULER = 4;</code>
     */
    RULER(4),
    /**
     *
     *
     * <pre>
     * Barcode block.
     * </pre>
     *
     * <code>BARCODE = 5;</code>
     */
    BARCODE(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unknown block type.
     * </pre>
     *
     * <code>UNKNOWN = 0;</code>
     */
    public static final int UNKNOWN_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Regular text block.
     * </pre>
     *
     * <code>TEXT = 1;</code>
     */
    public static final int TEXT_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Table block.
     * </pre>
     *
     * <code>TABLE = 2;</code>
     */
    public static final int TABLE_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Image block.
     * </pre>
     *
     * <code>PICTURE = 3;</code>
     */
    public static final int PICTURE_VALUE = 3;

    /**
     *
     *
     * <pre>
     * Horizontal/vertical line box.
     * </pre>
     *
     * <code>RULER = 4;</code>
     */
    public static final int RULER_VALUE = 4;

    /**
     *
     *
     * <pre>
     * Barcode block.
     * </pre>
     *
     * <code>BARCODE = 5;</code>
     */
    public static final int BARCODE_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BlockType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BlockType forNumber(int value) {
      switch (value) {
        case 0:
          return UNKNOWN;
        case 1:
          return TEXT;
        case 2:
          return TABLE;
        case 3:
          return PICTURE;
        case 4:
          return RULER;
        case 5:
          return BARCODE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BlockType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<BlockType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<BlockType>() {
          public BlockType findValueByNumber(int number) {
            return BlockType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.vision.v1p3beta1.Block.getDescriptor().getEnumTypes().get(0);
    }

    private static final BlockType[] VALUES = values();

    public static BlockType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BlockType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.vision.v1p3beta1.Block.BlockType)
  }

  private int bitField0_;
  public static final int PROPERTY_FIELD_NUMBER = 1;
  private com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property_;

  /**
   *
   *
   * <pre>
   * Additional information detected for the block.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
   *
   * @return Whether the property field is set.
   */
  @java.lang.Override
  public boolean hasProperty() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Additional information detected for the block.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
   *
   * @return The property.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty getProperty() {
    return property_ == null
        ? com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.getDefaultInstance()
        : property_;
  }

  /**
   *
   *
   * <pre>
   * Additional information detected for the block.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.TextAnnotation.TextPropertyOrBuilder
      getPropertyOrBuilder() {
    return property_ == null
        ? com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.getDefaultInstance()
        : property_;
  }

  public static final int BOUNDING_BOX_FIELD_NUMBER = 2;
  private com.google.cloud.vision.v1p3beta1.BoundingPoly boundingBox_;

  /**
   *
   *
   * <pre>
   * The bounding box for the block.
   * The vertices are in the order of top-left, top-right, bottom-right,
   * bottom-left. When a rotation of the bounding box is detected the rotation
   * is represented as around the top-left corner as defined when the text is
   * read in the 'natural' orientation.
   * For example:
   *
   * * when the text is horizontal it might look like:
   *
   *         0----1
   *         |    |
   *         3----2
   *
   * * when it's rotated 180 degrees around the top-left corner it becomes:
   *
   *         2----3
   *         |    |
   *         1----0
   *
   *   and the vertice order will still be (0, 1, 2, 3).
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
   *
   * @return Whether the boundingBox field is set.
   */
  @java.lang.Override
  public boolean hasBoundingBox() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The bounding box for the block.
   * The vertices are in the order of top-left, top-right, bottom-right,
   * bottom-left. When a rotation of the bounding box is detected the rotation
   * is represented as around the top-left corner as defined when the text is
   * read in the 'natural' orientation.
   * For example:
   *
   * * when the text is horizontal it might look like:
   *
   *         0----1
   *         |    |
   *         3----2
   *
   * * when it's rotated 180 degrees around the top-left corner it becomes:
   *
   *         2----3
   *         |    |
   *         1----0
   *
   *   and the vertice order will still be (0, 1, 2, 3).
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
   *
   * @return The boundingBox.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.BoundingPoly getBoundingBox() {
    return boundingBox_ == null
        ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
        : boundingBox_;
  }

  /**
   *
   *
   * <pre>
   * The bounding box for the block.
   * The vertices are in the order of top-left, top-right, bottom-right,
   * bottom-left. When a rotation of the bounding box is detected the rotation
   * is represented as around the top-left corner as defined when the text is
   * read in the 'natural' orientation.
   * For example:
   *
   * * when the text is horizontal it might look like:
   *
   *         0----1
   *         |    |
   *         3----2
   *
   * * when it's rotated 180 degrees around the top-left corner it becomes:
   *
   *         2----3
   *         |    |
   *         1----0
   *
   *   and the vertice order will still be (0, 1, 2, 3).
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder getBoundingBoxOrBuilder() {
    return boundingBox_ == null
        ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
        : boundingBox_;
  }

  public static final int PARAGRAPHS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vision.v1p3beta1.Paragraph> paragraphs_;

  /**
   *
   *
   * <pre>
   * List of paragraphs in this block (if this blocks is of type text).
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vision.v1p3beta1.Paragraph> getParagraphsList() {
    return paragraphs_;
  }

  /**
   *
   *
   * <pre>
   * List of paragraphs in this block (if this blocks is of type text).
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vision.v1p3beta1.ParagraphOrBuilder>
      getParagraphsOrBuilderList() {
    return paragraphs_;
  }

  /**
   *
   *
   * <pre>
   * List of paragraphs in this block (if this blocks is of type text).
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
   */
  @java.lang.Override
  public int getParagraphsCount() {
    return paragraphs_.size();
  }

  /**
   *
   *
   * <pre>
   * List of paragraphs in this block (if this blocks is of type text).
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.Paragraph getParagraphs(int index) {
    return paragraphs_.get(index);
  }

  /**
   *
   *
   * <pre>
   * List of paragraphs in this block (if this blocks is of type text).
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.ParagraphOrBuilder getParagraphsOrBuilder(int index) {
    return paragraphs_.get(index);
  }

  public static final int BLOCK_TYPE_FIELD_NUMBER = 4;
  private int blockType_ = 0;

  /**
   *
   *
   * <pre>
   * Detected block type (text, image etc) for this block.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.Block.BlockType block_type = 4;</code>
   *
   * @return The enum numeric value on the wire for blockType.
   */
  @java.lang.Override
  public int getBlockTypeValue() {
    return blockType_;
  }

  /**
   *
   *
   * <pre>
   * Detected block type (text, image etc) for this block.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.Block.BlockType block_type = 4;</code>
   *
   * @return The blockType.
   */
  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.Block.BlockType getBlockType() {
    com.google.cloud.vision.v1p3beta1.Block.BlockType result =
        com.google.cloud.vision.v1p3beta1.Block.BlockType.forNumber(blockType_);
    return result == null ? com.google.cloud.vision.v1p3beta1.Block.BlockType.UNRECOGNIZED : result;
  }

  public static final int CONFIDENCE_FIELD_NUMBER = 5;
  private float confidence_ = 0F;

  /**
   *
   *
   * <pre>
   * Confidence of the OCR results on the block. Range [0, 1].
   * </pre>
   *
   * <code>float confidence = 5;</code>
   *
   * @return The confidence.
   */
  @java.lang.Override
  public float getConfidence() {
    return confidence_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getProperty());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getBoundingBox());
    }
    for (int i = 0; i < paragraphs_.size(); i++) {
      output.writeMessage(3, paragraphs_.get(i));
    }
    if (blockType_ != com.google.cloud.vision.v1p3beta1.Block.BlockType.UNKNOWN.getNumber()) {
      output.writeEnum(4, blockType_);
    }
    if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
      output.writeFloat(5, confidence_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getProperty());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getBoundingBox());
    }
    for (int i = 0; i < paragraphs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, paragraphs_.get(i));
    }
    if (blockType_ != com.google.cloud.vision.v1p3beta1.Block.BlockType.UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, blockType_);
    }
    if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(5, confidence_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1p3beta1.Block)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1p3beta1.Block other = (com.google.cloud.vision.v1p3beta1.Block) obj;

    if (hasProperty() != other.hasProperty()) return false;
    if (hasProperty()) {
      if (!getProperty().equals(other.getProperty())) return false;
    }
    if (hasBoundingBox() != other.hasBoundingBox()) return false;
    if (hasBoundingBox()) {
      if (!getBoundingBox().equals(other.getBoundingBox())) return false;
    }
    if (!getParagraphsList().equals(other.getParagraphsList())) return false;
    if (blockType_ != other.blockType_) return false;
    if (java.lang.Float.floatToIntBits(getConfidence())
        != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasProperty()) {
      hash = (37 * hash) + PROPERTY_FIELD_NUMBER;
      hash = (53 * hash) + getProperty().hashCode();
    }
    if (hasBoundingBox()) {
      hash = (37 * hash) + BOUNDING_BOX_FIELD_NUMBER;
      hash = (53 * hash) + getBoundingBox().hashCode();
    }
    if (getParagraphsCount() > 0) {
      hash = (37 * hash) + PARAGRAPHS_FIELD_NUMBER;
      hash = (53 * hash) + getParagraphsList().hashCode();
    }
    hash = (37 * hash) + BLOCK_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + blockType_;
    hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1p3beta1.Block parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.Block parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.Block parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.Block parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.Block parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.Block parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.Block parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.Block parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.Block parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.Block parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.Block parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.Block parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vision.v1p3beta1.Block prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Logical element on the page.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p3beta1.Block}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p3beta1.Block)
      com.google.cloud.vision.v1p3beta1.BlockOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p3beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p3beta1_Block_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p3beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p3beta1_Block_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p3beta1.Block.class,
              com.google.cloud.vision.v1p3beta1.Block.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1p3beta1.Block.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPropertyFieldBuilder();
        getBoundingBoxFieldBuilder();
        getParagraphsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      property_ = null;
      if (propertyBuilder_ != null) {
        propertyBuilder_.dispose();
        propertyBuilder_ = null;
      }
      boundingBox_ = null;
      if (boundingBoxBuilder_ != null) {
        boundingBoxBuilder_.dispose();
        boundingBoxBuilder_ = null;
      }
      if (paragraphsBuilder_ == null) {
        paragraphs_ = java.util.Collections.emptyList();
      } else {
        paragraphs_ = null;
        paragraphsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      blockType_ = 0;
      confidence_ = 0F;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1p3beta1.TextAnnotationProto
          .internal_static_google_cloud_vision_v1p3beta1_Block_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.Block getDefaultInstanceForType() {
      return com.google.cloud.vision.v1p3beta1.Block.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.Block build() {
      com.google.cloud.vision.v1p3beta1.Block result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.Block buildPartial() {
      com.google.cloud.vision.v1p3beta1.Block result =
          new com.google.cloud.vision.v1p3beta1.Block(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.vision.v1p3beta1.Block result) {
      if (paragraphsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          paragraphs_ = java.util.Collections.unmodifiableList(paragraphs_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.paragraphs_ = paragraphs_;
      } else {
        result.paragraphs_ = paragraphsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.vision.v1p3beta1.Block result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.property_ = propertyBuilder_ == null ? property_ : propertyBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.boundingBox_ =
            boundingBoxBuilder_ == null ? boundingBox_ : boundingBoxBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.blockType_ = blockType_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.confidence_ = confidence_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1p3beta1.Block) {
        return mergeFrom((com.google.cloud.vision.v1p3beta1.Block) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1p3beta1.Block other) {
      if (other == com.google.cloud.vision.v1p3beta1.Block.getDefaultInstance()) return this;
      if (other.hasProperty()) {
        mergeProperty(other.getProperty());
      }
      if (other.hasBoundingBox()) {
        mergeBoundingBox(other.getBoundingBox());
      }
      if (paragraphsBuilder_ == null) {
        if (!other.paragraphs_.isEmpty()) {
          if (paragraphs_.isEmpty()) {
            paragraphs_ = other.paragraphs_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureParagraphsIsMutable();
            paragraphs_.addAll(other.paragraphs_);
          }
          onChanged();
        }
      } else {
        if (!other.paragraphs_.isEmpty()) {
          if (paragraphsBuilder_.isEmpty()) {
            paragraphsBuilder_.dispose();
            paragraphsBuilder_ = null;
            paragraphs_ = other.paragraphs_;
            bitField0_ = (bitField0_ & ~0x00000004);
            paragraphsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getParagraphsFieldBuilder()
                    : null;
          } else {
            paragraphsBuilder_.addAllMessages(other.paragraphs_);
          }
        }
      }
      if (other.blockType_ != 0) {
        setBlockTypeValue(other.getBlockTypeValue());
      }
      if (other.getConfidence() != 0F) {
        setConfidence(other.getConfidence());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getPropertyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getBoundingBoxFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.vision.v1p3beta1.Paragraph m =
                    input.readMessage(
                        com.google.cloud.vision.v1p3beta1.Paragraph.parser(), extensionRegistry);
                if (paragraphsBuilder_ == null) {
                  ensureParagraphsIsMutable();
                  paragraphs_.add(m);
                } else {
                  paragraphsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 32:
              {
                blockType_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 45:
              {
                confidence_ = input.readFloat();
                bitField0_ |= 0x00000010;
                break;
              } // case 45
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty,
            com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.Builder,
            com.google.cloud.vision.v1p3beta1.TextAnnotation.TextPropertyOrBuilder>
        propertyBuilder_;

    /**
     *
     *
     * <pre>
     * Additional information detected for the block.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     *
     * @return Whether the property field is set.
     */
    public boolean hasProperty() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Additional information detected for the block.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     *
     * @return The property.
     */
    public com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty getProperty() {
      if (propertyBuilder_ == null) {
        return property_ == null
            ? com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.getDefaultInstance()
            : property_;
      } else {
        return propertyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Additional information detected for the block.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public Builder setProperty(
        com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty value) {
      if (propertyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        property_ = value;
      } else {
        propertyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Additional information detected for the block.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public Builder setProperty(
        com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.Builder builderForValue) {
      if (propertyBuilder_ == null) {
        property_ = builderForValue.build();
      } else {
        propertyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Additional information detected for the block.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public Builder mergeProperty(
        com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty value) {
      if (propertyBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && property_ != null
            && property_
                != com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty
                    .getDefaultInstance()) {
          getPropertyBuilder().mergeFrom(value);
        } else {
          property_ = value;
        }
      } else {
        propertyBuilder_.mergeFrom(value);
      }
      if (property_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Additional information detected for the block.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public Builder clearProperty() {
      bitField0_ = (bitField0_ & ~0x00000001);
      property_ = null;
      if (propertyBuilder_ != null) {
        propertyBuilder_.dispose();
        propertyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Additional information detected for the block.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.Builder
        getPropertyBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getPropertyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Additional information detected for the block.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    public com.google.cloud.vision.v1p3beta1.TextAnnotation.TextPropertyOrBuilder
        getPropertyOrBuilder() {
      if (propertyBuilder_ != null) {
        return propertyBuilder_.getMessageOrBuilder();
      } else {
        return property_ == null
            ? com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.getDefaultInstance()
            : property_;
      }
    }

    /**
     *
     *
     * <pre>
     * Additional information detected for the block.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty property = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty,
            com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.Builder,
            com.google.cloud.vision.v1p3beta1.TextAnnotation.TextPropertyOrBuilder>
        getPropertyFieldBuilder() {
      if (propertyBuilder_ == null) {
        propertyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty,
                com.google.cloud.vision.v1p3beta1.TextAnnotation.TextProperty.Builder,
                com.google.cloud.vision.v1p3beta1.TextAnnotation.TextPropertyOrBuilder>(
                getProperty(), getParentForChildren(), isClean());
        property_ = null;
      }
      return propertyBuilder_;
    }

    private com.google.cloud.vision.v1p3beta1.BoundingPoly boundingBox_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.BoundingPoly,
            com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>
        boundingBoxBuilder_;

    /**
     *
     *
     * <pre>
     * The bounding box for the block.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *
     * * when the text is horizontal it might look like:
     *
     *         0----1
     *         |    |
     *         3----2
     *
     * * when it's rotated 180 degrees around the top-left corner it becomes:
     *
     *         2----3
     *         |    |
     *         1----0
     *
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     *
     * @return Whether the boundingBox field is set.
     */
    public boolean hasBoundingBox() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The bounding box for the block.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *
     * * when the text is horizontal it might look like:
     *
     *         0----1
     *         |    |
     *         3----2
     *
     * * when it's rotated 180 degrees around the top-left corner it becomes:
     *
     *         2----3
     *         |    |
     *         1----0
     *
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     *
     * @return The boundingBox.
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPoly getBoundingBox() {
      if (boundingBoxBuilder_ == null) {
        return boundingBox_ == null
            ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
            : boundingBox_;
      } else {
        return boundingBoxBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The bounding box for the block.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *
     * * when the text is horizontal it might look like:
     *
     *         0----1
     *         |    |
     *         3----2
     *
     * * when it's rotated 180 degrees around the top-left corner it becomes:
     *
     *         2----3
     *         |    |
     *         1----0
     *
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     */
    public Builder setBoundingBox(com.google.cloud.vision.v1p3beta1.BoundingPoly value) {
      if (boundingBoxBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        boundingBox_ = value;
      } else {
        boundingBoxBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The bounding box for the block.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *
     * * when the text is horizontal it might look like:
     *
     *         0----1
     *         |    |
     *         3----2
     *
     * * when it's rotated 180 degrees around the top-left corner it becomes:
     *
     *         2----3
     *         |    |
     *         1----0
     *
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     */
    public Builder setBoundingBox(
        com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder builderForValue) {
      if (boundingBoxBuilder_ == null) {
        boundingBox_ = builderForValue.build();
      } else {
        boundingBoxBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The bounding box for the block.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *
     * * when the text is horizontal it might look like:
     *
     *         0----1
     *         |    |
     *         3----2
     *
     * * when it's rotated 180 degrees around the top-left corner it becomes:
     *
     *         2----3
     *         |    |
     *         1----0
     *
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     */
    public Builder mergeBoundingBox(com.google.cloud.vision.v1p3beta1.BoundingPoly value) {
      if (boundingBoxBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && boundingBox_ != null
            && boundingBox_
                != com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()) {
          getBoundingBoxBuilder().mergeFrom(value);
        } else {
          boundingBox_ = value;
        }
      } else {
        boundingBoxBuilder_.mergeFrom(value);
      }
      if (boundingBox_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The bounding box for the block.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *
     * * when the text is horizontal it might look like:
     *
     *         0----1
     *         |    |
     *         3----2
     *
     * * when it's rotated 180 degrees around the top-left corner it becomes:
     *
     *         2----3
     *         |    |
     *         1----0
     *
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     */
    public Builder clearBoundingBox() {
      bitField0_ = (bitField0_ & ~0x00000002);
      boundingBox_ = null;
      if (boundingBoxBuilder_ != null) {
        boundingBoxBuilder_.dispose();
        boundingBoxBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The bounding box for the block.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *
     * * when the text is horizontal it might look like:
     *
     *         0----1
     *         |    |
     *         3----2
     *
     * * when it's rotated 180 degrees around the top-left corner it becomes:
     *
     *         2----3
     *         |    |
     *         1----0
     *
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder getBoundingBoxBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getBoundingBoxFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The bounding box for the block.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *
     * * when the text is horizontal it might look like:
     *
     *         0----1
     *         |    |
     *         3----2
     *
     * * when it's rotated 180 degrees around the top-left corner it becomes:
     *
     *         2----3
     *         |    |
     *         1----0
     *
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     */
    public com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder getBoundingBoxOrBuilder() {
      if (boundingBoxBuilder_ != null) {
        return boundingBoxBuilder_.getMessageOrBuilder();
      } else {
        return boundingBox_ == null
            ? com.google.cloud.vision.v1p3beta1.BoundingPoly.getDefaultInstance()
            : boundingBox_;
      }
    }

    /**
     *
     *
     * <pre>
     * The bounding box for the block.
     * The vertices are in the order of top-left, top-right, bottom-right,
     * bottom-left. When a rotation of the bounding box is detected the rotation
     * is represented as around the top-left corner as defined when the text is
     * read in the 'natural' orientation.
     * For example:
     *
     * * when the text is horizontal it might look like:
     *
     *         0----1
     *         |    |
     *         3----2
     *
     * * when it's rotated 180 degrees around the top-left corner it becomes:
     *
     *         2----3
     *         |    |
     *         1----0
     *
     *   and the vertice order will still be (0, 1, 2, 3).
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.BoundingPoly bounding_box = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.BoundingPoly,
            com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
            com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>
        getBoundingBoxFieldBuilder() {
      if (boundingBoxBuilder_ == null) {
        boundingBoxBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.BoundingPoly,
                com.google.cloud.vision.v1p3beta1.BoundingPoly.Builder,
                com.google.cloud.vision.v1p3beta1.BoundingPolyOrBuilder>(
                getBoundingBox(), getParentForChildren(), isClean());
        boundingBox_ = null;
      }
      return boundingBoxBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p3beta1.Paragraph> paragraphs_ =
        java.util.Collections.emptyList();

    private void ensureParagraphsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        paragraphs_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.Paragraph>(paragraphs_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.Paragraph,
            com.google.cloud.vision.v1p3beta1.Paragraph.Builder,
            com.google.cloud.vision.v1p3beta1.ParagraphOrBuilder>
        paragraphsBuilder_;

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.Paragraph> getParagraphsList() {
      if (paragraphsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(paragraphs_);
      } else {
        return paragraphsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public int getParagraphsCount() {
      if (paragraphsBuilder_ == null) {
        return paragraphs_.size();
      } else {
        return paragraphsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public com.google.cloud.vision.v1p3beta1.Paragraph getParagraphs(int index) {
      if (paragraphsBuilder_ == null) {
        return paragraphs_.get(index);
      } else {
        return paragraphsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public Builder setParagraphs(int index, com.google.cloud.vision.v1p3beta1.Paragraph value) {
      if (paragraphsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParagraphsIsMutable();
        paragraphs_.set(index, value);
        onChanged();
      } else {
        paragraphsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public Builder setParagraphs(
        int index, com.google.cloud.vision.v1p3beta1.Paragraph.Builder builderForValue) {
      if (paragraphsBuilder_ == null) {
        ensureParagraphsIsMutable();
        paragraphs_.set(index, builderForValue.build());
        onChanged();
      } else {
        paragraphsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public Builder addParagraphs(com.google.cloud.vision.v1p3beta1.Paragraph value) {
      if (paragraphsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParagraphsIsMutable();
        paragraphs_.add(value);
        onChanged();
      } else {
        paragraphsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public Builder addParagraphs(int index, com.google.cloud.vision.v1p3beta1.Paragraph value) {
      if (paragraphsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParagraphsIsMutable();
        paragraphs_.add(index, value);
        onChanged();
      } else {
        paragraphsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public Builder addParagraphs(
        com.google.cloud.vision.v1p3beta1.Paragraph.Builder builderForValue) {
      if (paragraphsBuilder_ == null) {
        ensureParagraphsIsMutable();
        paragraphs_.add(builderForValue.build());
        onChanged();
      } else {
        paragraphsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public Builder addParagraphs(
        int index, com.google.cloud.vision.v1p3beta1.Paragraph.Builder builderForValue) {
      if (paragraphsBuilder_ == null) {
        ensureParagraphsIsMutable();
        paragraphs_.add(index, builderForValue.build());
        onChanged();
      } else {
        paragraphsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public Builder addAllParagraphs(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p3beta1.Paragraph> values) {
      if (paragraphsBuilder_ == null) {
        ensureParagraphsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, paragraphs_);
        onChanged();
      } else {
        paragraphsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public Builder clearParagraphs() {
      if (paragraphsBuilder_ == null) {
        paragraphs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        paragraphsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public Builder removeParagraphs(int index) {
      if (paragraphsBuilder_ == null) {
        ensureParagraphsIsMutable();
        paragraphs_.remove(index);
        onChanged();
      } else {
        paragraphsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public com.google.cloud.vision.v1p3beta1.Paragraph.Builder getParagraphsBuilder(int index) {
      return getParagraphsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public com.google.cloud.vision.v1p3beta1.ParagraphOrBuilder getParagraphsOrBuilder(int index) {
      if (paragraphsBuilder_ == null) {
        return paragraphs_.get(index);
      } else {
        return paragraphsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1p3beta1.ParagraphOrBuilder>
        getParagraphsOrBuilderList() {
      if (paragraphsBuilder_ != null) {
        return paragraphsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(paragraphs_);
      }
    }

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public com.google.cloud.vision.v1p3beta1.Paragraph.Builder addParagraphsBuilder() {
      return getParagraphsFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p3beta1.Paragraph.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public com.google.cloud.vision.v1p3beta1.Paragraph.Builder addParagraphsBuilder(int index) {
      return getParagraphsFieldBuilder()
          .addBuilder(index, com.google.cloud.vision.v1p3beta1.Paragraph.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of paragraphs in this block (if this blocks is of type text).
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.Paragraph paragraphs = 3;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.Paragraph.Builder>
        getParagraphsBuilderList() {
      return getParagraphsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.Paragraph,
            com.google.cloud.vision.v1p3beta1.Paragraph.Builder,
            com.google.cloud.vision.v1p3beta1.ParagraphOrBuilder>
        getParagraphsFieldBuilder() {
      if (paragraphsBuilder_ == null) {
        paragraphsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.Paragraph,
                com.google.cloud.vision.v1p3beta1.Paragraph.Builder,
                com.google.cloud.vision.v1p3beta1.ParagraphOrBuilder>(
                paragraphs_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        paragraphs_ = null;
      }
      return paragraphsBuilder_;
    }

    private int blockType_ = 0;

    /**
     *
     *
     * <pre>
     * Detected block type (text, image etc) for this block.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.Block.BlockType block_type = 4;</code>
     *
     * @return The enum numeric value on the wire for blockType.
     */
    @java.lang.Override
    public int getBlockTypeValue() {
      return blockType_;
    }

    /**
     *
     *
     * <pre>
     * Detected block type (text, image etc) for this block.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.Block.BlockType block_type = 4;</code>
     *
     * @param value The enum numeric value on the wire for blockType to set.
     * @return This builder for chaining.
     */
    public Builder setBlockTypeValue(int value) {
      blockType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Detected block type (text, image etc) for this block.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.Block.BlockType block_type = 4;</code>
     *
     * @return The blockType.
     */
    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.Block.BlockType getBlockType() {
      com.google.cloud.vision.v1p3beta1.Block.BlockType result =
          com.google.cloud.vision.v1p3beta1.Block.BlockType.forNumber(blockType_);
      return result == null
          ? com.google.cloud.vision.v1p3beta1.Block.BlockType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Detected block type (text, image etc) for this block.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.Block.BlockType block_type = 4;</code>
     *
     * @param value The blockType to set.
     * @return This builder for chaining.
     */
    public Builder setBlockType(com.google.cloud.vision.v1p3beta1.Block.BlockType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      blockType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Detected block type (text, image etc) for this block.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.Block.BlockType block_type = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBlockType() {
      bitField0_ = (bitField0_ & ~0x00000008);
      blockType_ = 0;
      onChanged();
      return this;
    }

    private float confidence_;

    /**
     *
     *
     * <pre>
     * Confidence of the OCR results on the block. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 5;</code>
     *
     * @return The confidence.
     */
    @java.lang.Override
    public float getConfidence() {
      return confidence_;
    }

    /**
     *
     *
     * <pre>
     * Confidence of the OCR results on the block. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 5;</code>
     *
     * @param value The confidence to set.
     * @return This builder for chaining.
     */
    public Builder setConfidence(float value) {

      confidence_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Confidence of the OCR results on the block. Range [0, 1].
     * </pre>
     *
     * <code>float confidence = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfidence() {
      bitField0_ = (bitField0_ & ~0x00000010);
      confidence_ = 0F;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p3beta1.Block)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p3beta1.Block)
  private static final com.google.cloud.vision.v1p3beta1.Block DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1p3beta1.Block();
  }

  public static com.google.cloud.vision.v1p3beta1.Block getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Block> PARSER =
      new com.google.protobuf.AbstractParser<Block>() {
        @java.lang.Override
        public Block parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Block> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Block> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.Block getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
