/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1p3beta1/image_annotator.proto

package com.google.cloud.vision.v1p3beta1;

/**
 *
 *
 * <pre>
 * Response to an image annotation request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1p3beta1.AnnotateImageResponse}
 */
public final class AnnotateImageResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1p3beta1.AnnotateImageResponse)
    AnnotateImageResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnnotateImageResponse.newBuilder() to construct.
  private AnnotateImageResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnnotateImageResponse() {
    faceAnnotations_ = java.util.Collections.emptyList();
    landmarkAnnotations_ = java.util.Collections.emptyList();
    logoAnnotations_ = java.util.Collections.emptyList();
    labelAnnotations_ = java.util.Collections.emptyList();
    localizedObjectAnnotations_ = java.util.Collections.emptyList();
    textAnnotations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private AnnotateImageResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                faceAnnotations_ =
                    new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.FaceAnnotation>();
                mutable_bitField0_ |= 0x00000001;
              }
              faceAnnotations_.add(
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.FaceAnnotation.parser(),
                      extensionRegistry));
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                landmarkAnnotations_ =
                    new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.EntityAnnotation>();
                mutable_bitField0_ |= 0x00000002;
              }
              landmarkAnnotations_.add(
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.EntityAnnotation.parser(),
                      extensionRegistry));
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                logoAnnotations_ =
                    new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.EntityAnnotation>();
                mutable_bitField0_ |= 0x00000004;
              }
              logoAnnotations_.add(
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.EntityAnnotation.parser(),
                      extensionRegistry));
              break;
            }
          case 34:
            {
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                labelAnnotations_ =
                    new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.EntityAnnotation>();
                mutable_bitField0_ |= 0x00000008;
              }
              labelAnnotations_.add(
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.EntityAnnotation.parser(),
                      extensionRegistry));
              break;
            }
          case 42:
            {
              if (!((mutable_bitField0_ & 0x00000020) != 0)) {
                textAnnotations_ =
                    new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.EntityAnnotation>();
                mutable_bitField0_ |= 0x00000020;
              }
              textAnnotations_.add(
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.EntityAnnotation.parser(),
                      extensionRegistry));
              break;
            }
          case 50:
            {
              com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation.Builder subBuilder = null;
              if (safeSearchAnnotation_ != null) {
                subBuilder = safeSearchAnnotation_.toBuilder();
              }
              safeSearchAnnotation_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(safeSearchAnnotation_);
                safeSearchAnnotation_ = subBuilder.buildPartial();
              }

              break;
            }
          case 66:
            {
              com.google.cloud.vision.v1p3beta1.ImageProperties.Builder subBuilder = null;
              if (imagePropertiesAnnotation_ != null) {
                subBuilder = imagePropertiesAnnotation_.toBuilder();
              }
              imagePropertiesAnnotation_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.ImageProperties.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(imagePropertiesAnnotation_);
                imagePropertiesAnnotation_ = subBuilder.buildPartial();
              }

              break;
            }
          case 74:
            {
              com.google.rpc.Status.Builder subBuilder = null;
              if (error_ != null) {
                subBuilder = error_.toBuilder();
              }
              error_ = input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(error_);
                error_ = subBuilder.buildPartial();
              }

              break;
            }
          case 90:
            {
              com.google.cloud.vision.v1p3beta1.CropHintsAnnotation.Builder subBuilder = null;
              if (cropHintsAnnotation_ != null) {
                subBuilder = cropHintsAnnotation_.toBuilder();
              }
              cropHintsAnnotation_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.CropHintsAnnotation.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(cropHintsAnnotation_);
                cropHintsAnnotation_ = subBuilder.buildPartial();
              }

              break;
            }
          case 98:
            {
              com.google.cloud.vision.v1p3beta1.TextAnnotation.Builder subBuilder = null;
              if (fullTextAnnotation_ != null) {
                subBuilder = fullTextAnnotation_.toBuilder();
              }
              fullTextAnnotation_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.TextAnnotation.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(fullTextAnnotation_);
                fullTextAnnotation_ = subBuilder.buildPartial();
              }

              break;
            }
          case 106:
            {
              com.google.cloud.vision.v1p3beta1.WebDetection.Builder subBuilder = null;
              if (webDetection_ != null) {
                subBuilder = webDetection_.toBuilder();
              }
              webDetection_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.WebDetection.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(webDetection_);
                webDetection_ = subBuilder.buildPartial();
              }

              break;
            }
          case 114:
            {
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.Builder subBuilder = null;
              if (productSearchResults_ != null) {
                subBuilder = productSearchResults_.toBuilder();
              }
              productSearchResults_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.ProductSearchResults.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(productSearchResults_);
                productSearchResults_ = subBuilder.buildPartial();
              }

              break;
            }
          case 170:
            {
              com.google.cloud.vision.v1p3beta1.ImageAnnotationContext.Builder subBuilder = null;
              if (context_ != null) {
                subBuilder = context_.toBuilder();
              }
              context_ =
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.ImageAnnotationContext.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(context_);
                context_ = subBuilder.buildPartial();
              }

              break;
            }
          case 178:
            {
              if (!((mutable_bitField0_ & 0x00000010) != 0)) {
                localizedObjectAnnotations_ =
                    new java.util.ArrayList<
                        com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation>();
                mutable_bitField0_ |= 0x00000010;
              }
              localizedObjectAnnotations_.add(
                  input.readMessage(
                      com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation.parser(),
                      extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        faceAnnotations_ = java.util.Collections.unmodifiableList(faceAnnotations_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        landmarkAnnotations_ = java.util.Collections.unmodifiableList(landmarkAnnotations_);
      }
      if (((mutable_bitField0_ & 0x00000004) != 0)) {
        logoAnnotations_ = java.util.Collections.unmodifiableList(logoAnnotations_);
      }
      if (((mutable_bitField0_ & 0x00000008) != 0)) {
        labelAnnotations_ = java.util.Collections.unmodifiableList(labelAnnotations_);
      }
      if (((mutable_bitField0_ & 0x00000020) != 0)) {
        textAnnotations_ = java.util.Collections.unmodifiableList(textAnnotations_);
      }
      if (((mutable_bitField0_ & 0x00000010) != 0)) {
        localizedObjectAnnotations_ =
            java.util.Collections.unmodifiableList(localizedObjectAnnotations_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1p3beta1.ImageAnnotatorProto
        .internal_static_google_cloud_vision_v1p3beta1_AnnotateImageResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1p3beta1.ImageAnnotatorProto
        .internal_static_google_cloud_vision_v1p3beta1_AnnotateImageResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1p3beta1.AnnotateImageResponse.class,
            com.google.cloud.vision.v1p3beta1.AnnotateImageResponse.Builder.class);
  }

  private int bitField0_;
  public static final int FACE_ANNOTATIONS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.vision.v1p3beta1.FaceAnnotation> faceAnnotations_;
  /**
   *
   *
   * <pre>
   * If present, face detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
   */
  public java.util.List<com.google.cloud.vision.v1p3beta1.FaceAnnotation> getFaceAnnotationsList() {
    return faceAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * If present, face detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
   */
  public java.util.List<? extends com.google.cloud.vision.v1p3beta1.FaceAnnotationOrBuilder>
      getFaceAnnotationsOrBuilderList() {
    return faceAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * If present, face detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
   */
  public int getFaceAnnotationsCount() {
    return faceAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * If present, face detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
   */
  public com.google.cloud.vision.v1p3beta1.FaceAnnotation getFaceAnnotations(int index) {
    return faceAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If present, face detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
   */
  public com.google.cloud.vision.v1p3beta1.FaceAnnotationOrBuilder getFaceAnnotationsOrBuilder(
      int index) {
    return faceAnnotations_.get(index);
  }

  public static final int LANDMARK_ANNOTATIONS_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation> landmarkAnnotations_;
  /**
   *
   *
   * <pre>
   * If present, landmark detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;</code>
   */
  public java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation>
      getLandmarkAnnotationsList() {
    return landmarkAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * If present, landmark detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;</code>
   */
  public java.util.List<? extends com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>
      getLandmarkAnnotationsOrBuilderList() {
    return landmarkAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * If present, landmark detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;</code>
   */
  public int getLandmarkAnnotationsCount() {
    return landmarkAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * If present, landmark detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;</code>
   */
  public com.google.cloud.vision.v1p3beta1.EntityAnnotation getLandmarkAnnotations(int index) {
    return landmarkAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If present, landmark detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;</code>
   */
  public com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder
      getLandmarkAnnotationsOrBuilder(int index) {
    return landmarkAnnotations_.get(index);
  }

  public static final int LOGO_ANNOTATIONS_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation> logoAnnotations_;
  /**
   *
   *
   * <pre>
   * If present, logo detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
   */
  public java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation>
      getLogoAnnotationsList() {
    return logoAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * If present, logo detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
   */
  public java.util.List<? extends com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>
      getLogoAnnotationsOrBuilderList() {
    return logoAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * If present, logo detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
   */
  public int getLogoAnnotationsCount() {
    return logoAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * If present, logo detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
   */
  public com.google.cloud.vision.v1p3beta1.EntityAnnotation getLogoAnnotations(int index) {
    return logoAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If present, logo detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
   */
  public com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder getLogoAnnotationsOrBuilder(
      int index) {
    return logoAnnotations_.get(index);
  }

  public static final int LABEL_ANNOTATIONS_FIELD_NUMBER = 4;
  private java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation> labelAnnotations_;
  /**
   *
   *
   * <pre>
   * If present, label detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
   */
  public java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation>
      getLabelAnnotationsList() {
    return labelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * If present, label detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
   */
  public java.util.List<? extends com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>
      getLabelAnnotationsOrBuilderList() {
    return labelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * If present, label detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
   */
  public int getLabelAnnotationsCount() {
    return labelAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * If present, label detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
   */
  public com.google.cloud.vision.v1p3beta1.EntityAnnotation getLabelAnnotations(int index) {
    return labelAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If present, label detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
   */
  public com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder getLabelAnnotationsOrBuilder(
      int index) {
    return labelAnnotations_.get(index);
  }

  public static final int LOCALIZED_OBJECT_ANNOTATIONS_FIELD_NUMBER = 22;
  private java.util.List<com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation>
      localizedObjectAnnotations_;
  /**
   *
   *
   * <pre>
   * If present, localized object detection has completed successfully.
   * This will be sorted descending by confidence score.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
   * </code>
   */
  public java.util.List<com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation>
      getLocalizedObjectAnnotationsList() {
    return localizedObjectAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * If present, localized object detection has completed successfully.
   * This will be sorted descending by confidence score.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
   * </code>
   */
  public java.util.List<
          ? extends com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotationOrBuilder>
      getLocalizedObjectAnnotationsOrBuilderList() {
    return localizedObjectAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * If present, localized object detection has completed successfully.
   * This will be sorted descending by confidence score.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
   * </code>
   */
  public int getLocalizedObjectAnnotationsCount() {
    return localizedObjectAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * If present, localized object detection has completed successfully.
   * This will be sorted descending by confidence score.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
   * </code>
   */
  public com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation getLocalizedObjectAnnotations(
      int index) {
    return localizedObjectAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If present, localized object detection has completed successfully.
   * This will be sorted descending by confidence score.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
   * </code>
   */
  public com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotationOrBuilder
      getLocalizedObjectAnnotationsOrBuilder(int index) {
    return localizedObjectAnnotations_.get(index);
  }

  public static final int TEXT_ANNOTATIONS_FIELD_NUMBER = 5;
  private java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation> textAnnotations_;
  /**
   *
   *
   * <pre>
   * If present, text (OCR) detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
   */
  public java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation>
      getTextAnnotationsList() {
    return textAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * If present, text (OCR) detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
   */
  public java.util.List<? extends com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>
      getTextAnnotationsOrBuilderList() {
    return textAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * If present, text (OCR) detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
   */
  public int getTextAnnotationsCount() {
    return textAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * If present, text (OCR) detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
   */
  public com.google.cloud.vision.v1p3beta1.EntityAnnotation getTextAnnotations(int index) {
    return textAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If present, text (OCR) detection has completed successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
   */
  public com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder getTextAnnotationsOrBuilder(
      int index) {
    return textAnnotations_.get(index);
  }

  public static final int FULL_TEXT_ANNOTATION_FIELD_NUMBER = 12;
  private com.google.cloud.vision.v1p3beta1.TextAnnotation fullTextAnnotation_;
  /**
   *
   *
   * <pre>
   * If present, text (OCR) detection or document (OCR) text detection has
   * completed successfully.
   * This annotation provides the structural hierarchy for the OCR detected
   * text.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.TextAnnotation full_text_annotation = 12;</code>
   */
  public boolean hasFullTextAnnotation() {
    return fullTextAnnotation_ != null;
  }
  /**
   *
   *
   * <pre>
   * If present, text (OCR) detection or document (OCR) text detection has
   * completed successfully.
   * This annotation provides the structural hierarchy for the OCR detected
   * text.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.TextAnnotation full_text_annotation = 12;</code>
   */
  public com.google.cloud.vision.v1p3beta1.TextAnnotation getFullTextAnnotation() {
    return fullTextAnnotation_ == null
        ? com.google.cloud.vision.v1p3beta1.TextAnnotation.getDefaultInstance()
        : fullTextAnnotation_;
  }
  /**
   *
   *
   * <pre>
   * If present, text (OCR) detection or document (OCR) text detection has
   * completed successfully.
   * This annotation provides the structural hierarchy for the OCR detected
   * text.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.TextAnnotation full_text_annotation = 12;</code>
   */
  public com.google.cloud.vision.v1p3beta1.TextAnnotationOrBuilder
      getFullTextAnnotationOrBuilder() {
    return getFullTextAnnotation();
  }

  public static final int SAFE_SEARCH_ANNOTATION_FIELD_NUMBER = 6;
  private com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation safeSearchAnnotation_;
  /**
   *
   *
   * <pre>
   * If present, safe-search annotation has completed successfully.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.SafeSearchAnnotation safe_search_annotation = 6;</code>
   */
  public boolean hasSafeSearchAnnotation() {
    return safeSearchAnnotation_ != null;
  }
  /**
   *
   *
   * <pre>
   * If present, safe-search annotation has completed successfully.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.SafeSearchAnnotation safe_search_annotation = 6;</code>
   */
  public com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation getSafeSearchAnnotation() {
    return safeSearchAnnotation_ == null
        ? com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation.getDefaultInstance()
        : safeSearchAnnotation_;
  }
  /**
   *
   *
   * <pre>
   * If present, safe-search annotation has completed successfully.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.SafeSearchAnnotation safe_search_annotation = 6;</code>
   */
  public com.google.cloud.vision.v1p3beta1.SafeSearchAnnotationOrBuilder
      getSafeSearchAnnotationOrBuilder() {
    return getSafeSearchAnnotation();
  }

  public static final int IMAGE_PROPERTIES_ANNOTATION_FIELD_NUMBER = 8;
  private com.google.cloud.vision.v1p3beta1.ImageProperties imagePropertiesAnnotation_;
  /**
   *
   *
   * <pre>
   * If present, image properties were extracted successfully.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.ImageProperties image_properties_annotation = 8;</code>
   */
  public boolean hasImagePropertiesAnnotation() {
    return imagePropertiesAnnotation_ != null;
  }
  /**
   *
   *
   * <pre>
   * If present, image properties were extracted successfully.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.ImageProperties image_properties_annotation = 8;</code>
   */
  public com.google.cloud.vision.v1p3beta1.ImageProperties getImagePropertiesAnnotation() {
    return imagePropertiesAnnotation_ == null
        ? com.google.cloud.vision.v1p3beta1.ImageProperties.getDefaultInstance()
        : imagePropertiesAnnotation_;
  }
  /**
   *
   *
   * <pre>
   * If present, image properties were extracted successfully.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.ImageProperties image_properties_annotation = 8;</code>
   */
  public com.google.cloud.vision.v1p3beta1.ImagePropertiesOrBuilder
      getImagePropertiesAnnotationOrBuilder() {
    return getImagePropertiesAnnotation();
  }

  public static final int CROP_HINTS_ANNOTATION_FIELD_NUMBER = 11;
  private com.google.cloud.vision.v1p3beta1.CropHintsAnnotation cropHintsAnnotation_;
  /**
   *
   *
   * <pre>
   * If present, crop hints have completed successfully.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.CropHintsAnnotation crop_hints_annotation = 11;</code>
   */
  public boolean hasCropHintsAnnotation() {
    return cropHintsAnnotation_ != null;
  }
  /**
   *
   *
   * <pre>
   * If present, crop hints have completed successfully.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.CropHintsAnnotation crop_hints_annotation = 11;</code>
   */
  public com.google.cloud.vision.v1p3beta1.CropHintsAnnotation getCropHintsAnnotation() {
    return cropHintsAnnotation_ == null
        ? com.google.cloud.vision.v1p3beta1.CropHintsAnnotation.getDefaultInstance()
        : cropHintsAnnotation_;
  }
  /**
   *
   *
   * <pre>
   * If present, crop hints have completed successfully.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.CropHintsAnnotation crop_hints_annotation = 11;</code>
   */
  public com.google.cloud.vision.v1p3beta1.CropHintsAnnotationOrBuilder
      getCropHintsAnnotationOrBuilder() {
    return getCropHintsAnnotation();
  }

  public static final int WEB_DETECTION_FIELD_NUMBER = 13;
  private com.google.cloud.vision.v1p3beta1.WebDetection webDetection_;
  /**
   *
   *
   * <pre>
   * If present, web detection has completed successfully.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.WebDetection web_detection = 13;</code>
   */
  public boolean hasWebDetection() {
    return webDetection_ != null;
  }
  /**
   *
   *
   * <pre>
   * If present, web detection has completed successfully.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.WebDetection web_detection = 13;</code>
   */
  public com.google.cloud.vision.v1p3beta1.WebDetection getWebDetection() {
    return webDetection_ == null
        ? com.google.cloud.vision.v1p3beta1.WebDetection.getDefaultInstance()
        : webDetection_;
  }
  /**
   *
   *
   * <pre>
   * If present, web detection has completed successfully.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.WebDetection web_detection = 13;</code>
   */
  public com.google.cloud.vision.v1p3beta1.WebDetectionOrBuilder getWebDetectionOrBuilder() {
    return getWebDetection();
  }

  public static final int PRODUCT_SEARCH_RESULTS_FIELD_NUMBER = 14;
  private com.google.cloud.vision.v1p3beta1.ProductSearchResults productSearchResults_;
  /**
   *
   *
   * <pre>
   * If present, product search has completed successfully.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.ProductSearchResults product_search_results = 14;</code>
   */
  public boolean hasProductSearchResults() {
    return productSearchResults_ != null;
  }
  /**
   *
   *
   * <pre>
   * If present, product search has completed successfully.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.ProductSearchResults product_search_results = 14;</code>
   */
  public com.google.cloud.vision.v1p3beta1.ProductSearchResults getProductSearchResults() {
    return productSearchResults_ == null
        ? com.google.cloud.vision.v1p3beta1.ProductSearchResults.getDefaultInstance()
        : productSearchResults_;
  }
  /**
   *
   *
   * <pre>
   * If present, product search has completed successfully.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.ProductSearchResults product_search_results = 14;</code>
   */
  public com.google.cloud.vision.v1p3beta1.ProductSearchResultsOrBuilder
      getProductSearchResultsOrBuilder() {
    return getProductSearchResults();
  }

  public static final int ERROR_FIELD_NUMBER = 9;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * If set, represents the error message for the operation.
   * Note that filled-in image annotations are guaranteed to be
   * correct, even when `error` is set.
   * </pre>
   *
   * <code>.google.rpc.Status error = 9;</code>
   */
  public boolean hasError() {
    return error_ != null;
  }
  /**
   *
   *
   * <pre>
   * If set, represents the error message for the operation.
   * Note that filled-in image annotations are guaranteed to be
   * correct, even when `error` is set.
   * </pre>
   *
   * <code>.google.rpc.Status error = 9;</code>
   */
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * If set, represents the error message for the operation.
   * Note that filled-in image annotations are guaranteed to be
   * correct, even when `error` is set.
   * </pre>
   *
   * <code>.google.rpc.Status error = 9;</code>
   */
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return getError();
  }

  public static final int CONTEXT_FIELD_NUMBER = 21;
  private com.google.cloud.vision.v1p3beta1.ImageAnnotationContext context_;
  /**
   *
   *
   * <pre>
   * If present, contextual information is needed to understand where this image
   * comes from.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.ImageAnnotationContext context = 21;</code>
   */
  public boolean hasContext() {
    return context_ != null;
  }
  /**
   *
   *
   * <pre>
   * If present, contextual information is needed to understand where this image
   * comes from.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.ImageAnnotationContext context = 21;</code>
   */
  public com.google.cloud.vision.v1p3beta1.ImageAnnotationContext getContext() {
    return context_ == null
        ? com.google.cloud.vision.v1p3beta1.ImageAnnotationContext.getDefaultInstance()
        : context_;
  }
  /**
   *
   *
   * <pre>
   * If present, contextual information is needed to understand where this image
   * comes from.
   * </pre>
   *
   * <code>.google.cloud.vision.v1p3beta1.ImageAnnotationContext context = 21;</code>
   */
  public com.google.cloud.vision.v1p3beta1.ImageAnnotationContextOrBuilder getContextOrBuilder() {
    return getContext();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < faceAnnotations_.size(); i++) {
      output.writeMessage(1, faceAnnotations_.get(i));
    }
    for (int i = 0; i < landmarkAnnotations_.size(); i++) {
      output.writeMessage(2, landmarkAnnotations_.get(i));
    }
    for (int i = 0; i < logoAnnotations_.size(); i++) {
      output.writeMessage(3, logoAnnotations_.get(i));
    }
    for (int i = 0; i < labelAnnotations_.size(); i++) {
      output.writeMessage(4, labelAnnotations_.get(i));
    }
    for (int i = 0; i < textAnnotations_.size(); i++) {
      output.writeMessage(5, textAnnotations_.get(i));
    }
    if (safeSearchAnnotation_ != null) {
      output.writeMessage(6, getSafeSearchAnnotation());
    }
    if (imagePropertiesAnnotation_ != null) {
      output.writeMessage(8, getImagePropertiesAnnotation());
    }
    if (error_ != null) {
      output.writeMessage(9, getError());
    }
    if (cropHintsAnnotation_ != null) {
      output.writeMessage(11, getCropHintsAnnotation());
    }
    if (fullTextAnnotation_ != null) {
      output.writeMessage(12, getFullTextAnnotation());
    }
    if (webDetection_ != null) {
      output.writeMessage(13, getWebDetection());
    }
    if (productSearchResults_ != null) {
      output.writeMessage(14, getProductSearchResults());
    }
    if (context_ != null) {
      output.writeMessage(21, getContext());
    }
    for (int i = 0; i < localizedObjectAnnotations_.size(); i++) {
      output.writeMessage(22, localizedObjectAnnotations_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < faceAnnotations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, faceAnnotations_.get(i));
    }
    for (int i = 0; i < landmarkAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, landmarkAnnotations_.get(i));
    }
    for (int i = 0; i < logoAnnotations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, logoAnnotations_.get(i));
    }
    for (int i = 0; i < labelAnnotations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labelAnnotations_.get(i));
    }
    for (int i = 0; i < textAnnotations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, textAnnotations_.get(i));
    }
    if (safeSearchAnnotation_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, getSafeSearchAnnotation());
    }
    if (imagePropertiesAnnotation_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, getImagePropertiesAnnotation());
    }
    if (error_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getError());
    }
    if (cropHintsAnnotation_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(11, getCropHintsAnnotation());
    }
    if (fullTextAnnotation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getFullTextAnnotation());
    }
    if (webDetection_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getWebDetection());
    }
    if (productSearchResults_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(14, getProductSearchResults());
    }
    if (context_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getContext());
    }
    for (int i = 0; i < localizedObjectAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              22, localizedObjectAnnotations_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1p3beta1.AnnotateImageResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1p3beta1.AnnotateImageResponse other =
        (com.google.cloud.vision.v1p3beta1.AnnotateImageResponse) obj;

    if (!getFaceAnnotationsList().equals(other.getFaceAnnotationsList())) return false;
    if (!getLandmarkAnnotationsList().equals(other.getLandmarkAnnotationsList())) return false;
    if (!getLogoAnnotationsList().equals(other.getLogoAnnotationsList())) return false;
    if (!getLabelAnnotationsList().equals(other.getLabelAnnotationsList())) return false;
    if (!getLocalizedObjectAnnotationsList().equals(other.getLocalizedObjectAnnotationsList()))
      return false;
    if (!getTextAnnotationsList().equals(other.getTextAnnotationsList())) return false;
    if (hasFullTextAnnotation() != other.hasFullTextAnnotation()) return false;
    if (hasFullTextAnnotation()) {
      if (!getFullTextAnnotation().equals(other.getFullTextAnnotation())) return false;
    }
    if (hasSafeSearchAnnotation() != other.hasSafeSearchAnnotation()) return false;
    if (hasSafeSearchAnnotation()) {
      if (!getSafeSearchAnnotation().equals(other.getSafeSearchAnnotation())) return false;
    }
    if (hasImagePropertiesAnnotation() != other.hasImagePropertiesAnnotation()) return false;
    if (hasImagePropertiesAnnotation()) {
      if (!getImagePropertiesAnnotation().equals(other.getImagePropertiesAnnotation()))
        return false;
    }
    if (hasCropHintsAnnotation() != other.hasCropHintsAnnotation()) return false;
    if (hasCropHintsAnnotation()) {
      if (!getCropHintsAnnotation().equals(other.getCropHintsAnnotation())) return false;
    }
    if (hasWebDetection() != other.hasWebDetection()) return false;
    if (hasWebDetection()) {
      if (!getWebDetection().equals(other.getWebDetection())) return false;
    }
    if (hasProductSearchResults() != other.hasProductSearchResults()) return false;
    if (hasProductSearchResults()) {
      if (!getProductSearchResults().equals(other.getProductSearchResults())) return false;
    }
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (hasContext() != other.hasContext()) return false;
    if (hasContext()) {
      if (!getContext().equals(other.getContext())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getFaceAnnotationsCount() > 0) {
      hash = (37 * hash) + FACE_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFaceAnnotationsList().hashCode();
    }
    if (getLandmarkAnnotationsCount() > 0) {
      hash = (37 * hash) + LANDMARK_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getLandmarkAnnotationsList().hashCode();
    }
    if (getLogoAnnotationsCount() > 0) {
      hash = (37 * hash) + LOGO_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getLogoAnnotationsList().hashCode();
    }
    if (getLabelAnnotationsCount() > 0) {
      hash = (37 * hash) + LABEL_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getLabelAnnotationsList().hashCode();
    }
    if (getLocalizedObjectAnnotationsCount() > 0) {
      hash = (37 * hash) + LOCALIZED_OBJECT_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getLocalizedObjectAnnotationsList().hashCode();
    }
    if (getTextAnnotationsCount() > 0) {
      hash = (37 * hash) + TEXT_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getTextAnnotationsList().hashCode();
    }
    if (hasFullTextAnnotation()) {
      hash = (37 * hash) + FULL_TEXT_ANNOTATION_FIELD_NUMBER;
      hash = (53 * hash) + getFullTextAnnotation().hashCode();
    }
    if (hasSafeSearchAnnotation()) {
      hash = (37 * hash) + SAFE_SEARCH_ANNOTATION_FIELD_NUMBER;
      hash = (53 * hash) + getSafeSearchAnnotation().hashCode();
    }
    if (hasImagePropertiesAnnotation()) {
      hash = (37 * hash) + IMAGE_PROPERTIES_ANNOTATION_FIELD_NUMBER;
      hash = (53 * hash) + getImagePropertiesAnnotation().hashCode();
    }
    if (hasCropHintsAnnotation()) {
      hash = (37 * hash) + CROP_HINTS_ANNOTATION_FIELD_NUMBER;
      hash = (53 * hash) + getCropHintsAnnotation().hashCode();
    }
    if (hasWebDetection()) {
      hash = (37 * hash) + WEB_DETECTION_FIELD_NUMBER;
      hash = (53 * hash) + getWebDetection().hashCode();
    }
    if (hasProductSearchResults()) {
      hash = (37 * hash) + PRODUCT_SEARCH_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getProductSearchResults().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (hasContext()) {
      hash = (37 * hash) + CONTEXT_FIELD_NUMBER;
      hash = (53 * hash) + getContext().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1p3beta1.AnnotateImageResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.AnnotateImageResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.AnnotateImageResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.AnnotateImageResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.AnnotateImageResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1p3beta1.AnnotateImageResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.AnnotateImageResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.AnnotateImageResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.AnnotateImageResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.AnnotateImageResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1p3beta1.AnnotateImageResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1p3beta1.AnnotateImageResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.vision.v1p3beta1.AnnotateImageResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response to an image annotation request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1p3beta1.AnnotateImageResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1p3beta1.AnnotateImageResponse)
      com.google.cloud.vision.v1p3beta1.AnnotateImageResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1p3beta1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1p3beta1_AnnotateImageResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1p3beta1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1p3beta1_AnnotateImageResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1p3beta1.AnnotateImageResponse.class,
              com.google.cloud.vision.v1p3beta1.AnnotateImageResponse.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1p3beta1.AnnotateImageResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFaceAnnotationsFieldBuilder();
        getLandmarkAnnotationsFieldBuilder();
        getLogoAnnotationsFieldBuilder();
        getLabelAnnotationsFieldBuilder();
        getLocalizedObjectAnnotationsFieldBuilder();
        getTextAnnotationsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (faceAnnotationsBuilder_ == null) {
        faceAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        faceAnnotationsBuilder_.clear();
      }
      if (landmarkAnnotationsBuilder_ == null) {
        landmarkAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        landmarkAnnotationsBuilder_.clear();
      }
      if (logoAnnotationsBuilder_ == null) {
        logoAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
      } else {
        logoAnnotationsBuilder_.clear();
      }
      if (labelAnnotationsBuilder_ == null) {
        labelAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
      } else {
        labelAnnotationsBuilder_.clear();
      }
      if (localizedObjectAnnotationsBuilder_ == null) {
        localizedObjectAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
      } else {
        localizedObjectAnnotationsBuilder_.clear();
      }
      if (textAnnotationsBuilder_ == null) {
        textAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
      } else {
        textAnnotationsBuilder_.clear();
      }
      if (fullTextAnnotationBuilder_ == null) {
        fullTextAnnotation_ = null;
      } else {
        fullTextAnnotation_ = null;
        fullTextAnnotationBuilder_ = null;
      }
      if (safeSearchAnnotationBuilder_ == null) {
        safeSearchAnnotation_ = null;
      } else {
        safeSearchAnnotation_ = null;
        safeSearchAnnotationBuilder_ = null;
      }
      if (imagePropertiesAnnotationBuilder_ == null) {
        imagePropertiesAnnotation_ = null;
      } else {
        imagePropertiesAnnotation_ = null;
        imagePropertiesAnnotationBuilder_ = null;
      }
      if (cropHintsAnnotationBuilder_ == null) {
        cropHintsAnnotation_ = null;
      } else {
        cropHintsAnnotation_ = null;
        cropHintsAnnotationBuilder_ = null;
      }
      if (webDetectionBuilder_ == null) {
        webDetection_ = null;
      } else {
        webDetection_ = null;
        webDetectionBuilder_ = null;
      }
      if (productSearchResultsBuilder_ == null) {
        productSearchResults_ = null;
      } else {
        productSearchResults_ = null;
        productSearchResultsBuilder_ = null;
      }
      if (errorBuilder_ == null) {
        error_ = null;
      } else {
        error_ = null;
        errorBuilder_ = null;
      }
      if (contextBuilder_ == null) {
        context_ = null;
      } else {
        context_ = null;
        contextBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1p3beta1.ImageAnnotatorProto
          .internal_static_google_cloud_vision_v1p3beta1_AnnotateImageResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.AnnotateImageResponse getDefaultInstanceForType() {
      return com.google.cloud.vision.v1p3beta1.AnnotateImageResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.AnnotateImageResponse build() {
      com.google.cloud.vision.v1p3beta1.AnnotateImageResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1p3beta1.AnnotateImageResponse buildPartial() {
      com.google.cloud.vision.v1p3beta1.AnnotateImageResponse result =
          new com.google.cloud.vision.v1p3beta1.AnnotateImageResponse(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (faceAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          faceAnnotations_ = java.util.Collections.unmodifiableList(faceAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.faceAnnotations_ = faceAnnotations_;
      } else {
        result.faceAnnotations_ = faceAnnotationsBuilder_.build();
      }
      if (landmarkAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          landmarkAnnotations_ = java.util.Collections.unmodifiableList(landmarkAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.landmarkAnnotations_ = landmarkAnnotations_;
      } else {
        result.landmarkAnnotations_ = landmarkAnnotationsBuilder_.build();
      }
      if (logoAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          logoAnnotations_ = java.util.Collections.unmodifiableList(logoAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.logoAnnotations_ = logoAnnotations_;
      } else {
        result.logoAnnotations_ = logoAnnotationsBuilder_.build();
      }
      if (labelAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          labelAnnotations_ = java.util.Collections.unmodifiableList(labelAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.labelAnnotations_ = labelAnnotations_;
      } else {
        result.labelAnnotations_ = labelAnnotationsBuilder_.build();
      }
      if (localizedObjectAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          localizedObjectAnnotations_ =
              java.util.Collections.unmodifiableList(localizedObjectAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.localizedObjectAnnotations_ = localizedObjectAnnotations_;
      } else {
        result.localizedObjectAnnotations_ = localizedObjectAnnotationsBuilder_.build();
      }
      if (textAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          textAnnotations_ = java.util.Collections.unmodifiableList(textAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.textAnnotations_ = textAnnotations_;
      } else {
        result.textAnnotations_ = textAnnotationsBuilder_.build();
      }
      if (fullTextAnnotationBuilder_ == null) {
        result.fullTextAnnotation_ = fullTextAnnotation_;
      } else {
        result.fullTextAnnotation_ = fullTextAnnotationBuilder_.build();
      }
      if (safeSearchAnnotationBuilder_ == null) {
        result.safeSearchAnnotation_ = safeSearchAnnotation_;
      } else {
        result.safeSearchAnnotation_ = safeSearchAnnotationBuilder_.build();
      }
      if (imagePropertiesAnnotationBuilder_ == null) {
        result.imagePropertiesAnnotation_ = imagePropertiesAnnotation_;
      } else {
        result.imagePropertiesAnnotation_ = imagePropertiesAnnotationBuilder_.build();
      }
      if (cropHintsAnnotationBuilder_ == null) {
        result.cropHintsAnnotation_ = cropHintsAnnotation_;
      } else {
        result.cropHintsAnnotation_ = cropHintsAnnotationBuilder_.build();
      }
      if (webDetectionBuilder_ == null) {
        result.webDetection_ = webDetection_;
      } else {
        result.webDetection_ = webDetectionBuilder_.build();
      }
      if (productSearchResultsBuilder_ == null) {
        result.productSearchResults_ = productSearchResults_;
      } else {
        result.productSearchResults_ = productSearchResultsBuilder_.build();
      }
      if (errorBuilder_ == null) {
        result.error_ = error_;
      } else {
        result.error_ = errorBuilder_.build();
      }
      if (contextBuilder_ == null) {
        result.context_ = context_;
      } else {
        result.context_ = contextBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1p3beta1.AnnotateImageResponse) {
        return mergeFrom((com.google.cloud.vision.v1p3beta1.AnnotateImageResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1p3beta1.AnnotateImageResponse other) {
      if (other == com.google.cloud.vision.v1p3beta1.AnnotateImageResponse.getDefaultInstance())
        return this;
      if (faceAnnotationsBuilder_ == null) {
        if (!other.faceAnnotations_.isEmpty()) {
          if (faceAnnotations_.isEmpty()) {
            faceAnnotations_ = other.faceAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFaceAnnotationsIsMutable();
            faceAnnotations_.addAll(other.faceAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.faceAnnotations_.isEmpty()) {
          if (faceAnnotationsBuilder_.isEmpty()) {
            faceAnnotationsBuilder_.dispose();
            faceAnnotationsBuilder_ = null;
            faceAnnotations_ = other.faceAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            faceAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFaceAnnotationsFieldBuilder()
                    : null;
          } else {
            faceAnnotationsBuilder_.addAllMessages(other.faceAnnotations_);
          }
        }
      }
      if (landmarkAnnotationsBuilder_ == null) {
        if (!other.landmarkAnnotations_.isEmpty()) {
          if (landmarkAnnotations_.isEmpty()) {
            landmarkAnnotations_ = other.landmarkAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureLandmarkAnnotationsIsMutable();
            landmarkAnnotations_.addAll(other.landmarkAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.landmarkAnnotations_.isEmpty()) {
          if (landmarkAnnotationsBuilder_.isEmpty()) {
            landmarkAnnotationsBuilder_.dispose();
            landmarkAnnotationsBuilder_ = null;
            landmarkAnnotations_ = other.landmarkAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            landmarkAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLandmarkAnnotationsFieldBuilder()
                    : null;
          } else {
            landmarkAnnotationsBuilder_.addAllMessages(other.landmarkAnnotations_);
          }
        }
      }
      if (logoAnnotationsBuilder_ == null) {
        if (!other.logoAnnotations_.isEmpty()) {
          if (logoAnnotations_.isEmpty()) {
            logoAnnotations_ = other.logoAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureLogoAnnotationsIsMutable();
            logoAnnotations_.addAll(other.logoAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.logoAnnotations_.isEmpty()) {
          if (logoAnnotationsBuilder_.isEmpty()) {
            logoAnnotationsBuilder_.dispose();
            logoAnnotationsBuilder_ = null;
            logoAnnotations_ = other.logoAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000004);
            logoAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLogoAnnotationsFieldBuilder()
                    : null;
          } else {
            logoAnnotationsBuilder_.addAllMessages(other.logoAnnotations_);
          }
        }
      }
      if (labelAnnotationsBuilder_ == null) {
        if (!other.labelAnnotations_.isEmpty()) {
          if (labelAnnotations_.isEmpty()) {
            labelAnnotations_ = other.labelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureLabelAnnotationsIsMutable();
            labelAnnotations_.addAll(other.labelAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.labelAnnotations_.isEmpty()) {
          if (labelAnnotationsBuilder_.isEmpty()) {
            labelAnnotationsBuilder_.dispose();
            labelAnnotationsBuilder_ = null;
            labelAnnotations_ = other.labelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000008);
            labelAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLabelAnnotationsFieldBuilder()
                    : null;
          } else {
            labelAnnotationsBuilder_.addAllMessages(other.labelAnnotations_);
          }
        }
      }
      if (localizedObjectAnnotationsBuilder_ == null) {
        if (!other.localizedObjectAnnotations_.isEmpty()) {
          if (localizedObjectAnnotations_.isEmpty()) {
            localizedObjectAnnotations_ = other.localizedObjectAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureLocalizedObjectAnnotationsIsMutable();
            localizedObjectAnnotations_.addAll(other.localizedObjectAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.localizedObjectAnnotations_.isEmpty()) {
          if (localizedObjectAnnotationsBuilder_.isEmpty()) {
            localizedObjectAnnotationsBuilder_.dispose();
            localizedObjectAnnotationsBuilder_ = null;
            localizedObjectAnnotations_ = other.localizedObjectAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000010);
            localizedObjectAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLocalizedObjectAnnotationsFieldBuilder()
                    : null;
          } else {
            localizedObjectAnnotationsBuilder_.addAllMessages(other.localizedObjectAnnotations_);
          }
        }
      }
      if (textAnnotationsBuilder_ == null) {
        if (!other.textAnnotations_.isEmpty()) {
          if (textAnnotations_.isEmpty()) {
            textAnnotations_ = other.textAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureTextAnnotationsIsMutable();
            textAnnotations_.addAll(other.textAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.textAnnotations_.isEmpty()) {
          if (textAnnotationsBuilder_.isEmpty()) {
            textAnnotationsBuilder_.dispose();
            textAnnotationsBuilder_ = null;
            textAnnotations_ = other.textAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000020);
            textAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTextAnnotationsFieldBuilder()
                    : null;
          } else {
            textAnnotationsBuilder_.addAllMessages(other.textAnnotations_);
          }
        }
      }
      if (other.hasFullTextAnnotation()) {
        mergeFullTextAnnotation(other.getFullTextAnnotation());
      }
      if (other.hasSafeSearchAnnotation()) {
        mergeSafeSearchAnnotation(other.getSafeSearchAnnotation());
      }
      if (other.hasImagePropertiesAnnotation()) {
        mergeImagePropertiesAnnotation(other.getImagePropertiesAnnotation());
      }
      if (other.hasCropHintsAnnotation()) {
        mergeCropHintsAnnotation(other.getCropHintsAnnotation());
      }
      if (other.hasWebDetection()) {
        mergeWebDetection(other.getWebDetection());
      }
      if (other.hasProductSearchResults()) {
        mergeProductSearchResults(other.getProductSearchResults());
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (other.hasContext()) {
        mergeContext(other.getContext());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.vision.v1p3beta1.AnnotateImageResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.vision.v1p3beta1.AnnotateImageResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.vision.v1p3beta1.FaceAnnotation> faceAnnotations_ =
        java.util.Collections.emptyList();

    private void ensureFaceAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        faceAnnotations_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.FaceAnnotation>(
                faceAnnotations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.FaceAnnotation,
            com.google.cloud.vision.v1p3beta1.FaceAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.FaceAnnotationOrBuilder>
        faceAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.FaceAnnotation>
        getFaceAnnotationsList() {
      if (faceAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(faceAnnotations_);
      } else {
        return faceAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public int getFaceAnnotationsCount() {
      if (faceAnnotationsBuilder_ == null) {
        return faceAnnotations_.size();
      } else {
        return faceAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public com.google.cloud.vision.v1p3beta1.FaceAnnotation getFaceAnnotations(int index) {
      if (faceAnnotationsBuilder_ == null) {
        return faceAnnotations_.get(index);
      } else {
        return faceAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public Builder setFaceAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.FaceAnnotation value) {
      if (faceAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.set(index, value);
        onChanged();
      } else {
        faceAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public Builder setFaceAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.FaceAnnotation.Builder builderForValue) {
      if (faceAnnotationsBuilder_ == null) {
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        faceAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public Builder addFaceAnnotations(com.google.cloud.vision.v1p3beta1.FaceAnnotation value) {
      if (faceAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.add(value);
        onChanged();
      } else {
        faceAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public Builder addFaceAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.FaceAnnotation value) {
      if (faceAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.add(index, value);
        onChanged();
      } else {
        faceAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public Builder addFaceAnnotations(
        com.google.cloud.vision.v1p3beta1.FaceAnnotation.Builder builderForValue) {
      if (faceAnnotationsBuilder_ == null) {
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        faceAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public Builder addFaceAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.FaceAnnotation.Builder builderForValue) {
      if (faceAnnotationsBuilder_ == null) {
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        faceAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public Builder addAllFaceAnnotations(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p3beta1.FaceAnnotation> values) {
      if (faceAnnotationsBuilder_ == null) {
        ensureFaceAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, faceAnnotations_);
        onChanged();
      } else {
        faceAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public Builder clearFaceAnnotations() {
      if (faceAnnotationsBuilder_ == null) {
        faceAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        faceAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public Builder removeFaceAnnotations(int index) {
      if (faceAnnotationsBuilder_ == null) {
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.remove(index);
        onChanged();
      } else {
        faceAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public com.google.cloud.vision.v1p3beta1.FaceAnnotation.Builder getFaceAnnotationsBuilder(
        int index) {
      return getFaceAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public com.google.cloud.vision.v1p3beta1.FaceAnnotationOrBuilder getFaceAnnotationsOrBuilder(
        int index) {
      if (faceAnnotationsBuilder_ == null) {
        return faceAnnotations_.get(index);
      } else {
        return faceAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1p3beta1.FaceAnnotationOrBuilder>
        getFaceAnnotationsOrBuilderList() {
      if (faceAnnotationsBuilder_ != null) {
        return faceAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(faceAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public com.google.cloud.vision.v1p3beta1.FaceAnnotation.Builder addFaceAnnotationsBuilder() {
      return getFaceAnnotationsFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p3beta1.FaceAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public com.google.cloud.vision.v1p3beta1.FaceAnnotation.Builder addFaceAnnotationsBuilder(
        int index) {
      return getFaceAnnotationsFieldBuilder()
          .addBuilder(index, com.google.cloud.vision.v1p3beta1.FaceAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If present, face detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.FaceAnnotation face_annotations = 1;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.FaceAnnotation.Builder>
        getFaceAnnotationsBuilderList() {
      return getFaceAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.FaceAnnotation,
            com.google.cloud.vision.v1p3beta1.FaceAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.FaceAnnotationOrBuilder>
        getFaceAnnotationsFieldBuilder() {
      if (faceAnnotationsBuilder_ == null) {
        faceAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.FaceAnnotation,
                com.google.cloud.vision.v1p3beta1.FaceAnnotation.Builder,
                com.google.cloud.vision.v1p3beta1.FaceAnnotationOrBuilder>(
                faceAnnotations_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        faceAnnotations_ = null;
      }
      return faceAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation>
        landmarkAnnotations_ = java.util.Collections.emptyList();

    private void ensureLandmarkAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        landmarkAnnotations_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.EntityAnnotation>(
                landmarkAnnotations_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.EntityAnnotation,
            com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>
        landmarkAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation>
        getLandmarkAnnotationsList() {
      if (landmarkAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(landmarkAnnotations_);
      } else {
        return landmarkAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public int getLandmarkAnnotationsCount() {
      if (landmarkAnnotationsBuilder_ == null) {
        return landmarkAnnotations_.size();
      } else {
        return landmarkAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation getLandmarkAnnotations(int index) {
      if (landmarkAnnotationsBuilder_ == null) {
        return landmarkAnnotations_.get(index);
      } else {
        return landmarkAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public Builder setLandmarkAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.EntityAnnotation value) {
      if (landmarkAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLandmarkAnnotationsIsMutable();
        landmarkAnnotations_.set(index, value);
        onChanged();
      } else {
        landmarkAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public Builder setLandmarkAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder builderForValue) {
      if (landmarkAnnotationsBuilder_ == null) {
        ensureLandmarkAnnotationsIsMutable();
        landmarkAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        landmarkAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public Builder addLandmarkAnnotations(
        com.google.cloud.vision.v1p3beta1.EntityAnnotation value) {
      if (landmarkAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLandmarkAnnotationsIsMutable();
        landmarkAnnotations_.add(value);
        onChanged();
      } else {
        landmarkAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public Builder addLandmarkAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.EntityAnnotation value) {
      if (landmarkAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLandmarkAnnotationsIsMutable();
        landmarkAnnotations_.add(index, value);
        onChanged();
      } else {
        landmarkAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public Builder addLandmarkAnnotations(
        com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder builderForValue) {
      if (landmarkAnnotationsBuilder_ == null) {
        ensureLandmarkAnnotationsIsMutable();
        landmarkAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        landmarkAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public Builder addLandmarkAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder builderForValue) {
      if (landmarkAnnotationsBuilder_ == null) {
        ensureLandmarkAnnotationsIsMutable();
        landmarkAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        landmarkAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public Builder addAllLandmarkAnnotations(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p3beta1.EntityAnnotation> values) {
      if (landmarkAnnotationsBuilder_ == null) {
        ensureLandmarkAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, landmarkAnnotations_);
        onChanged();
      } else {
        landmarkAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public Builder clearLandmarkAnnotations() {
      if (landmarkAnnotationsBuilder_ == null) {
        landmarkAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        landmarkAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public Builder removeLandmarkAnnotations(int index) {
      if (landmarkAnnotationsBuilder_ == null) {
        ensureLandmarkAnnotationsIsMutable();
        landmarkAnnotations_.remove(index);
        onChanged();
      } else {
        landmarkAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder getLandmarkAnnotationsBuilder(
        int index) {
      return getLandmarkAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder
        getLandmarkAnnotationsOrBuilder(int index) {
      if (landmarkAnnotationsBuilder_ == null) {
        return landmarkAnnotations_.get(index);
      } else {
        return landmarkAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>
        getLandmarkAnnotationsOrBuilderList() {
      if (landmarkAnnotationsBuilder_ != null) {
        return landmarkAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(landmarkAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder
        addLandmarkAnnotationsBuilder() {
      return getLandmarkAnnotationsFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p3beta1.EntityAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder addLandmarkAnnotationsBuilder(
        int index) {
      return getLandmarkAnnotationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.vision.v1p3beta1.EntityAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If present, landmark detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation landmark_annotations = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder>
        getLandmarkAnnotationsBuilderList() {
      return getLandmarkAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.EntityAnnotation,
            com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>
        getLandmarkAnnotationsFieldBuilder() {
      if (landmarkAnnotationsBuilder_ == null) {
        landmarkAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.EntityAnnotation,
                com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder,
                com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>(
                landmarkAnnotations_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        landmarkAnnotations_ = null;
      }
      return landmarkAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation> logoAnnotations_ =
        java.util.Collections.emptyList();

    private void ensureLogoAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        logoAnnotations_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.EntityAnnotation>(
                logoAnnotations_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.EntityAnnotation,
            com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>
        logoAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation>
        getLogoAnnotationsList() {
      if (logoAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(logoAnnotations_);
      } else {
        return logoAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public int getLogoAnnotationsCount() {
      if (logoAnnotationsBuilder_ == null) {
        return logoAnnotations_.size();
      } else {
        return logoAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation getLogoAnnotations(int index) {
      if (logoAnnotationsBuilder_ == null) {
        return logoAnnotations_.get(index);
      } else {
        return logoAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public Builder setLogoAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.EntityAnnotation value) {
      if (logoAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLogoAnnotationsIsMutable();
        logoAnnotations_.set(index, value);
        onChanged();
      } else {
        logoAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public Builder setLogoAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder builderForValue) {
      if (logoAnnotationsBuilder_ == null) {
        ensureLogoAnnotationsIsMutable();
        logoAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        logoAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public Builder addLogoAnnotations(com.google.cloud.vision.v1p3beta1.EntityAnnotation value) {
      if (logoAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLogoAnnotationsIsMutable();
        logoAnnotations_.add(value);
        onChanged();
      } else {
        logoAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public Builder addLogoAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.EntityAnnotation value) {
      if (logoAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLogoAnnotationsIsMutable();
        logoAnnotations_.add(index, value);
        onChanged();
      } else {
        logoAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public Builder addLogoAnnotations(
        com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder builderForValue) {
      if (logoAnnotationsBuilder_ == null) {
        ensureLogoAnnotationsIsMutable();
        logoAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        logoAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public Builder addLogoAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder builderForValue) {
      if (logoAnnotationsBuilder_ == null) {
        ensureLogoAnnotationsIsMutable();
        logoAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        logoAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public Builder addAllLogoAnnotations(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p3beta1.EntityAnnotation> values) {
      if (logoAnnotationsBuilder_ == null) {
        ensureLogoAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, logoAnnotations_);
        onChanged();
      } else {
        logoAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public Builder clearLogoAnnotations() {
      if (logoAnnotationsBuilder_ == null) {
        logoAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        logoAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public Builder removeLogoAnnotations(int index) {
      if (logoAnnotationsBuilder_ == null) {
        ensureLogoAnnotationsIsMutable();
        logoAnnotations_.remove(index);
        onChanged();
      } else {
        logoAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder getLogoAnnotationsBuilder(
        int index) {
      return getLogoAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder getLogoAnnotationsOrBuilder(
        int index) {
      if (logoAnnotationsBuilder_ == null) {
        return logoAnnotations_.get(index);
      } else {
        return logoAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>
        getLogoAnnotationsOrBuilderList() {
      if (logoAnnotationsBuilder_ != null) {
        return logoAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(logoAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder addLogoAnnotationsBuilder() {
      return getLogoAnnotationsFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p3beta1.EntityAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder addLogoAnnotationsBuilder(
        int index) {
      return getLogoAnnotationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.vision.v1p3beta1.EntityAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If present, logo detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation logo_annotations = 3;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder>
        getLogoAnnotationsBuilderList() {
      return getLogoAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.EntityAnnotation,
            com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>
        getLogoAnnotationsFieldBuilder() {
      if (logoAnnotationsBuilder_ == null) {
        logoAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.EntityAnnotation,
                com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder,
                com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>(
                logoAnnotations_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        logoAnnotations_ = null;
      }
      return logoAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation> labelAnnotations_ =
        java.util.Collections.emptyList();

    private void ensureLabelAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        labelAnnotations_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.EntityAnnotation>(
                labelAnnotations_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.EntityAnnotation,
            com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>
        labelAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation>
        getLabelAnnotationsList() {
      if (labelAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(labelAnnotations_);
      } else {
        return labelAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public int getLabelAnnotationsCount() {
      if (labelAnnotationsBuilder_ == null) {
        return labelAnnotations_.size();
      } else {
        return labelAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation getLabelAnnotations(int index) {
      if (labelAnnotationsBuilder_ == null) {
        return labelAnnotations_.get(index);
      } else {
        return labelAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public Builder setLabelAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.EntityAnnotation value) {
      if (labelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelAnnotationsIsMutable();
        labelAnnotations_.set(index, value);
        onChanged();
      } else {
        labelAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public Builder setLabelAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder builderForValue) {
      if (labelAnnotationsBuilder_ == null) {
        ensureLabelAnnotationsIsMutable();
        labelAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        labelAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public Builder addLabelAnnotations(com.google.cloud.vision.v1p3beta1.EntityAnnotation value) {
      if (labelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelAnnotationsIsMutable();
        labelAnnotations_.add(value);
        onChanged();
      } else {
        labelAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public Builder addLabelAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.EntityAnnotation value) {
      if (labelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelAnnotationsIsMutable();
        labelAnnotations_.add(index, value);
        onChanged();
      } else {
        labelAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public Builder addLabelAnnotations(
        com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder builderForValue) {
      if (labelAnnotationsBuilder_ == null) {
        ensureLabelAnnotationsIsMutable();
        labelAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        labelAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public Builder addLabelAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder builderForValue) {
      if (labelAnnotationsBuilder_ == null) {
        ensureLabelAnnotationsIsMutable();
        labelAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        labelAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public Builder addAllLabelAnnotations(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p3beta1.EntityAnnotation> values) {
      if (labelAnnotationsBuilder_ == null) {
        ensureLabelAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, labelAnnotations_);
        onChanged();
      } else {
        labelAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public Builder clearLabelAnnotations() {
      if (labelAnnotationsBuilder_ == null) {
        labelAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        labelAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public Builder removeLabelAnnotations(int index) {
      if (labelAnnotationsBuilder_ == null) {
        ensureLabelAnnotationsIsMutable();
        labelAnnotations_.remove(index);
        onChanged();
      } else {
        labelAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder getLabelAnnotationsBuilder(
        int index) {
      return getLabelAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder getLabelAnnotationsOrBuilder(
        int index) {
      if (labelAnnotationsBuilder_ == null) {
        return labelAnnotations_.get(index);
      } else {
        return labelAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>
        getLabelAnnotationsOrBuilderList() {
      if (labelAnnotationsBuilder_ != null) {
        return labelAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(labelAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder addLabelAnnotationsBuilder() {
      return getLabelAnnotationsFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p3beta1.EntityAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder addLabelAnnotationsBuilder(
        int index) {
      return getLabelAnnotationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.vision.v1p3beta1.EntityAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If present, label detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation label_annotations = 4;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder>
        getLabelAnnotationsBuilderList() {
      return getLabelAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.EntityAnnotation,
            com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>
        getLabelAnnotationsFieldBuilder() {
      if (labelAnnotationsBuilder_ == null) {
        labelAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.EntityAnnotation,
                com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder,
                com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>(
                labelAnnotations_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        labelAnnotations_ = null;
      }
      return labelAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation>
        localizedObjectAnnotations_ = java.util.Collections.emptyList();

    private void ensureLocalizedObjectAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        localizedObjectAnnotations_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation>(
                localizedObjectAnnotations_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation,
            com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotationOrBuilder>
        localizedObjectAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation>
        getLocalizedObjectAnnotationsList() {
      if (localizedObjectAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(localizedObjectAnnotations_);
      } else {
        return localizedObjectAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public int getLocalizedObjectAnnotationsCount() {
      if (localizedObjectAnnotationsBuilder_ == null) {
        return localizedObjectAnnotations_.size();
      } else {
        return localizedObjectAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation
        getLocalizedObjectAnnotations(int index) {
      if (localizedObjectAnnotationsBuilder_ == null) {
        return localizedObjectAnnotations_.get(index);
      } else {
        return localizedObjectAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public Builder setLocalizedObjectAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation value) {
      if (localizedObjectAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalizedObjectAnnotationsIsMutable();
        localizedObjectAnnotations_.set(index, value);
        onChanged();
      } else {
        localizedObjectAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public Builder setLocalizedObjectAnnotations(
        int index,
        com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation.Builder builderForValue) {
      if (localizedObjectAnnotationsBuilder_ == null) {
        ensureLocalizedObjectAnnotationsIsMutable();
        localizedObjectAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        localizedObjectAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public Builder addLocalizedObjectAnnotations(
        com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation value) {
      if (localizedObjectAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalizedObjectAnnotationsIsMutable();
        localizedObjectAnnotations_.add(value);
        onChanged();
      } else {
        localizedObjectAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public Builder addLocalizedObjectAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation value) {
      if (localizedObjectAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalizedObjectAnnotationsIsMutable();
        localizedObjectAnnotations_.add(index, value);
        onChanged();
      } else {
        localizedObjectAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public Builder addLocalizedObjectAnnotations(
        com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation.Builder builderForValue) {
      if (localizedObjectAnnotationsBuilder_ == null) {
        ensureLocalizedObjectAnnotationsIsMutable();
        localizedObjectAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        localizedObjectAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public Builder addLocalizedObjectAnnotations(
        int index,
        com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation.Builder builderForValue) {
      if (localizedObjectAnnotationsBuilder_ == null) {
        ensureLocalizedObjectAnnotationsIsMutable();
        localizedObjectAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        localizedObjectAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public Builder addAllLocalizedObjectAnnotations(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation>
            values) {
      if (localizedObjectAnnotationsBuilder_ == null) {
        ensureLocalizedObjectAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, localizedObjectAnnotations_);
        onChanged();
      } else {
        localizedObjectAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public Builder clearLocalizedObjectAnnotations() {
      if (localizedObjectAnnotationsBuilder_ == null) {
        localizedObjectAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        localizedObjectAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public Builder removeLocalizedObjectAnnotations(int index) {
      if (localizedObjectAnnotationsBuilder_ == null) {
        ensureLocalizedObjectAnnotationsIsMutable();
        localizedObjectAnnotations_.remove(index);
        onChanged();
      } else {
        localizedObjectAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation.Builder
        getLocalizedObjectAnnotationsBuilder(int index) {
      return getLocalizedObjectAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotationOrBuilder
        getLocalizedObjectAnnotationsOrBuilder(int index) {
      if (localizedObjectAnnotationsBuilder_ == null) {
        return localizedObjectAnnotations_.get(index);
      } else {
        return localizedObjectAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotationOrBuilder>
        getLocalizedObjectAnnotationsOrBuilderList() {
      if (localizedObjectAnnotationsBuilder_ != null) {
        return localizedObjectAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(localizedObjectAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation.Builder
        addLocalizedObjectAnnotationsBuilder() {
      return getLocalizedObjectAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation.Builder
        addLocalizedObjectAnnotationsBuilder(int index) {
      return getLocalizedObjectAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If present, localized object detection has completed successfully.
     * This will be sorted descending by confidence score.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation localized_object_annotations = 22;
     * </code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation.Builder>
        getLocalizedObjectAnnotationsBuilderList() {
      return getLocalizedObjectAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation,
            com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotationOrBuilder>
        getLocalizedObjectAnnotationsFieldBuilder() {
      if (localizedObjectAnnotationsBuilder_ == null) {
        localizedObjectAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation,
                com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotation.Builder,
                com.google.cloud.vision.v1p3beta1.LocalizedObjectAnnotationOrBuilder>(
                localizedObjectAnnotations_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        localizedObjectAnnotations_ = null;
      }
      return localizedObjectAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation> textAnnotations_ =
        java.util.Collections.emptyList();

    private void ensureTextAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        textAnnotations_ =
            new java.util.ArrayList<com.google.cloud.vision.v1p3beta1.EntityAnnotation>(
                textAnnotations_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.EntityAnnotation,
            com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>
        textAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation>
        getTextAnnotationsList() {
      if (textAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(textAnnotations_);
      } else {
        return textAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public int getTextAnnotationsCount() {
      if (textAnnotationsBuilder_ == null) {
        return textAnnotations_.size();
      } else {
        return textAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation getTextAnnotations(int index) {
      if (textAnnotationsBuilder_ == null) {
        return textAnnotations_.get(index);
      } else {
        return textAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public Builder setTextAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.EntityAnnotation value) {
      if (textAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTextAnnotationsIsMutable();
        textAnnotations_.set(index, value);
        onChanged();
      } else {
        textAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public Builder setTextAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder builderForValue) {
      if (textAnnotationsBuilder_ == null) {
        ensureTextAnnotationsIsMutable();
        textAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        textAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public Builder addTextAnnotations(com.google.cloud.vision.v1p3beta1.EntityAnnotation value) {
      if (textAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTextAnnotationsIsMutable();
        textAnnotations_.add(value);
        onChanged();
      } else {
        textAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public Builder addTextAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.EntityAnnotation value) {
      if (textAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTextAnnotationsIsMutable();
        textAnnotations_.add(index, value);
        onChanged();
      } else {
        textAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public Builder addTextAnnotations(
        com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder builderForValue) {
      if (textAnnotationsBuilder_ == null) {
        ensureTextAnnotationsIsMutable();
        textAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        textAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public Builder addTextAnnotations(
        int index, com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder builderForValue) {
      if (textAnnotationsBuilder_ == null) {
        ensureTextAnnotationsIsMutable();
        textAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        textAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public Builder addAllTextAnnotations(
        java.lang.Iterable<? extends com.google.cloud.vision.v1p3beta1.EntityAnnotation> values) {
      if (textAnnotationsBuilder_ == null) {
        ensureTextAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, textAnnotations_);
        onChanged();
      } else {
        textAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public Builder clearTextAnnotations() {
      if (textAnnotationsBuilder_ == null) {
        textAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        textAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public Builder removeTextAnnotations(int index) {
      if (textAnnotationsBuilder_ == null) {
        ensureTextAnnotationsIsMutable();
        textAnnotations_.remove(index);
        onChanged();
      } else {
        textAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder getTextAnnotationsBuilder(
        int index) {
      return getTextAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder getTextAnnotationsOrBuilder(
        int index) {
      if (textAnnotationsBuilder_ == null) {
        return textAnnotations_.get(index);
      } else {
        return textAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>
        getTextAnnotationsOrBuilderList() {
      if (textAnnotationsBuilder_ != null) {
        return textAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(textAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder addTextAnnotationsBuilder() {
      return getTextAnnotationsFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1p3beta1.EntityAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder addTextAnnotationsBuilder(
        int index) {
      return getTextAnnotationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.vision.v1p3beta1.EntityAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection has completed successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1p3beta1.EntityAnnotation text_annotations = 5;</code>
     */
    public java.util.List<com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder>
        getTextAnnotationsBuilderList() {
      return getTextAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.EntityAnnotation,
            com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>
        getTextAnnotationsFieldBuilder() {
      if (textAnnotationsBuilder_ == null) {
        textAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.EntityAnnotation,
                com.google.cloud.vision.v1p3beta1.EntityAnnotation.Builder,
                com.google.cloud.vision.v1p3beta1.EntityAnnotationOrBuilder>(
                textAnnotations_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        textAnnotations_ = null;
      }
      return textAnnotationsBuilder_;
    }

    private com.google.cloud.vision.v1p3beta1.TextAnnotation fullTextAnnotation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.TextAnnotation,
            com.google.cloud.vision.v1p3beta1.TextAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.TextAnnotationOrBuilder>
        fullTextAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection or document (OCR) text detection has
     * completed successfully.
     * This annotation provides the structural hierarchy for the OCR detected
     * text.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation full_text_annotation = 12;</code>
     */
    public boolean hasFullTextAnnotation() {
      return fullTextAnnotationBuilder_ != null || fullTextAnnotation_ != null;
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection or document (OCR) text detection has
     * completed successfully.
     * This annotation provides the structural hierarchy for the OCR detected
     * text.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation full_text_annotation = 12;</code>
     */
    public com.google.cloud.vision.v1p3beta1.TextAnnotation getFullTextAnnotation() {
      if (fullTextAnnotationBuilder_ == null) {
        return fullTextAnnotation_ == null
            ? com.google.cloud.vision.v1p3beta1.TextAnnotation.getDefaultInstance()
            : fullTextAnnotation_;
      } else {
        return fullTextAnnotationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection or document (OCR) text detection has
     * completed successfully.
     * This annotation provides the structural hierarchy for the OCR detected
     * text.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation full_text_annotation = 12;</code>
     */
    public Builder setFullTextAnnotation(com.google.cloud.vision.v1p3beta1.TextAnnotation value) {
      if (fullTextAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fullTextAnnotation_ = value;
        onChanged();
      } else {
        fullTextAnnotationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection or document (OCR) text detection has
     * completed successfully.
     * This annotation provides the structural hierarchy for the OCR detected
     * text.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation full_text_annotation = 12;</code>
     */
    public Builder setFullTextAnnotation(
        com.google.cloud.vision.v1p3beta1.TextAnnotation.Builder builderForValue) {
      if (fullTextAnnotationBuilder_ == null) {
        fullTextAnnotation_ = builderForValue.build();
        onChanged();
      } else {
        fullTextAnnotationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection or document (OCR) text detection has
     * completed successfully.
     * This annotation provides the structural hierarchy for the OCR detected
     * text.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation full_text_annotation = 12;</code>
     */
    public Builder mergeFullTextAnnotation(com.google.cloud.vision.v1p3beta1.TextAnnotation value) {
      if (fullTextAnnotationBuilder_ == null) {
        if (fullTextAnnotation_ != null) {
          fullTextAnnotation_ =
              com.google.cloud.vision.v1p3beta1.TextAnnotation.newBuilder(fullTextAnnotation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          fullTextAnnotation_ = value;
        }
        onChanged();
      } else {
        fullTextAnnotationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection or document (OCR) text detection has
     * completed successfully.
     * This annotation provides the structural hierarchy for the OCR detected
     * text.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation full_text_annotation = 12;</code>
     */
    public Builder clearFullTextAnnotation() {
      if (fullTextAnnotationBuilder_ == null) {
        fullTextAnnotation_ = null;
        onChanged();
      } else {
        fullTextAnnotation_ = null;
        fullTextAnnotationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection or document (OCR) text detection has
     * completed successfully.
     * This annotation provides the structural hierarchy for the OCR detected
     * text.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation full_text_annotation = 12;</code>
     */
    public com.google.cloud.vision.v1p3beta1.TextAnnotation.Builder getFullTextAnnotationBuilder() {

      onChanged();
      return getFullTextAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection or document (OCR) text detection has
     * completed successfully.
     * This annotation provides the structural hierarchy for the OCR detected
     * text.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation full_text_annotation = 12;</code>
     */
    public com.google.cloud.vision.v1p3beta1.TextAnnotationOrBuilder
        getFullTextAnnotationOrBuilder() {
      if (fullTextAnnotationBuilder_ != null) {
        return fullTextAnnotationBuilder_.getMessageOrBuilder();
      } else {
        return fullTextAnnotation_ == null
            ? com.google.cloud.vision.v1p3beta1.TextAnnotation.getDefaultInstance()
            : fullTextAnnotation_;
      }
    }
    /**
     *
     *
     * <pre>
     * If present, text (OCR) detection or document (OCR) text detection has
     * completed successfully.
     * This annotation provides the structural hierarchy for the OCR detected
     * text.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.TextAnnotation full_text_annotation = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.TextAnnotation,
            com.google.cloud.vision.v1p3beta1.TextAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.TextAnnotationOrBuilder>
        getFullTextAnnotationFieldBuilder() {
      if (fullTextAnnotationBuilder_ == null) {
        fullTextAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.TextAnnotation,
                com.google.cloud.vision.v1p3beta1.TextAnnotation.Builder,
                com.google.cloud.vision.v1p3beta1.TextAnnotationOrBuilder>(
                getFullTextAnnotation(), getParentForChildren(), isClean());
        fullTextAnnotation_ = null;
      }
      return fullTextAnnotationBuilder_;
    }

    private com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation safeSearchAnnotation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation,
            com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.SafeSearchAnnotationOrBuilder>
        safeSearchAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * If present, safe-search annotation has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.SafeSearchAnnotation safe_search_annotation = 6;</code>
     */
    public boolean hasSafeSearchAnnotation() {
      return safeSearchAnnotationBuilder_ != null || safeSearchAnnotation_ != null;
    }
    /**
     *
     *
     * <pre>
     * If present, safe-search annotation has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.SafeSearchAnnotation safe_search_annotation = 6;</code>
     */
    public com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation getSafeSearchAnnotation() {
      if (safeSearchAnnotationBuilder_ == null) {
        return safeSearchAnnotation_ == null
            ? com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation.getDefaultInstance()
            : safeSearchAnnotation_;
      } else {
        return safeSearchAnnotationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, safe-search annotation has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.SafeSearchAnnotation safe_search_annotation = 6;</code>
     */
    public Builder setSafeSearchAnnotation(
        com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation value) {
      if (safeSearchAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        safeSearchAnnotation_ = value;
        onChanged();
      } else {
        safeSearchAnnotationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, safe-search annotation has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.SafeSearchAnnotation safe_search_annotation = 6;</code>
     */
    public Builder setSafeSearchAnnotation(
        com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation.Builder builderForValue) {
      if (safeSearchAnnotationBuilder_ == null) {
        safeSearchAnnotation_ = builderForValue.build();
        onChanged();
      } else {
        safeSearchAnnotationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, safe-search annotation has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.SafeSearchAnnotation safe_search_annotation = 6;</code>
     */
    public Builder mergeSafeSearchAnnotation(
        com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation value) {
      if (safeSearchAnnotationBuilder_ == null) {
        if (safeSearchAnnotation_ != null) {
          safeSearchAnnotation_ =
              com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation.newBuilder(
                      safeSearchAnnotation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          safeSearchAnnotation_ = value;
        }
        onChanged();
      } else {
        safeSearchAnnotationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, safe-search annotation has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.SafeSearchAnnotation safe_search_annotation = 6;</code>
     */
    public Builder clearSafeSearchAnnotation() {
      if (safeSearchAnnotationBuilder_ == null) {
        safeSearchAnnotation_ = null;
        onChanged();
      } else {
        safeSearchAnnotation_ = null;
        safeSearchAnnotationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, safe-search annotation has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.SafeSearchAnnotation safe_search_annotation = 6;</code>
     */
    public com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation.Builder
        getSafeSearchAnnotationBuilder() {

      onChanged();
      return getSafeSearchAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If present, safe-search annotation has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.SafeSearchAnnotation safe_search_annotation = 6;</code>
     */
    public com.google.cloud.vision.v1p3beta1.SafeSearchAnnotationOrBuilder
        getSafeSearchAnnotationOrBuilder() {
      if (safeSearchAnnotationBuilder_ != null) {
        return safeSearchAnnotationBuilder_.getMessageOrBuilder();
      } else {
        return safeSearchAnnotation_ == null
            ? com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation.getDefaultInstance()
            : safeSearchAnnotation_;
      }
    }
    /**
     *
     *
     * <pre>
     * If present, safe-search annotation has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.SafeSearchAnnotation safe_search_annotation = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation,
            com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.SafeSearchAnnotationOrBuilder>
        getSafeSearchAnnotationFieldBuilder() {
      if (safeSearchAnnotationBuilder_ == null) {
        safeSearchAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation,
                com.google.cloud.vision.v1p3beta1.SafeSearchAnnotation.Builder,
                com.google.cloud.vision.v1p3beta1.SafeSearchAnnotationOrBuilder>(
                getSafeSearchAnnotation(), getParentForChildren(), isClean());
        safeSearchAnnotation_ = null;
      }
      return safeSearchAnnotationBuilder_;
    }

    private com.google.cloud.vision.v1p3beta1.ImageProperties imagePropertiesAnnotation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.ImageProperties,
            com.google.cloud.vision.v1p3beta1.ImageProperties.Builder,
            com.google.cloud.vision.v1p3beta1.ImagePropertiesOrBuilder>
        imagePropertiesAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * If present, image properties were extracted successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageProperties image_properties_annotation = 8;</code>
     */
    public boolean hasImagePropertiesAnnotation() {
      return imagePropertiesAnnotationBuilder_ != null || imagePropertiesAnnotation_ != null;
    }
    /**
     *
     *
     * <pre>
     * If present, image properties were extracted successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageProperties image_properties_annotation = 8;</code>
     */
    public com.google.cloud.vision.v1p3beta1.ImageProperties getImagePropertiesAnnotation() {
      if (imagePropertiesAnnotationBuilder_ == null) {
        return imagePropertiesAnnotation_ == null
            ? com.google.cloud.vision.v1p3beta1.ImageProperties.getDefaultInstance()
            : imagePropertiesAnnotation_;
      } else {
        return imagePropertiesAnnotationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, image properties were extracted successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageProperties image_properties_annotation = 8;</code>
     */
    public Builder setImagePropertiesAnnotation(
        com.google.cloud.vision.v1p3beta1.ImageProperties value) {
      if (imagePropertiesAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        imagePropertiesAnnotation_ = value;
        onChanged();
      } else {
        imagePropertiesAnnotationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, image properties were extracted successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageProperties image_properties_annotation = 8;</code>
     */
    public Builder setImagePropertiesAnnotation(
        com.google.cloud.vision.v1p3beta1.ImageProperties.Builder builderForValue) {
      if (imagePropertiesAnnotationBuilder_ == null) {
        imagePropertiesAnnotation_ = builderForValue.build();
        onChanged();
      } else {
        imagePropertiesAnnotationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, image properties were extracted successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageProperties image_properties_annotation = 8;</code>
     */
    public Builder mergeImagePropertiesAnnotation(
        com.google.cloud.vision.v1p3beta1.ImageProperties value) {
      if (imagePropertiesAnnotationBuilder_ == null) {
        if (imagePropertiesAnnotation_ != null) {
          imagePropertiesAnnotation_ =
              com.google.cloud.vision.v1p3beta1.ImageProperties.newBuilder(
                      imagePropertiesAnnotation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          imagePropertiesAnnotation_ = value;
        }
        onChanged();
      } else {
        imagePropertiesAnnotationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, image properties were extracted successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageProperties image_properties_annotation = 8;</code>
     */
    public Builder clearImagePropertiesAnnotation() {
      if (imagePropertiesAnnotationBuilder_ == null) {
        imagePropertiesAnnotation_ = null;
        onChanged();
      } else {
        imagePropertiesAnnotation_ = null;
        imagePropertiesAnnotationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, image properties were extracted successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageProperties image_properties_annotation = 8;</code>
     */
    public com.google.cloud.vision.v1p3beta1.ImageProperties.Builder
        getImagePropertiesAnnotationBuilder() {

      onChanged();
      return getImagePropertiesAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If present, image properties were extracted successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageProperties image_properties_annotation = 8;</code>
     */
    public com.google.cloud.vision.v1p3beta1.ImagePropertiesOrBuilder
        getImagePropertiesAnnotationOrBuilder() {
      if (imagePropertiesAnnotationBuilder_ != null) {
        return imagePropertiesAnnotationBuilder_.getMessageOrBuilder();
      } else {
        return imagePropertiesAnnotation_ == null
            ? com.google.cloud.vision.v1p3beta1.ImageProperties.getDefaultInstance()
            : imagePropertiesAnnotation_;
      }
    }
    /**
     *
     *
     * <pre>
     * If present, image properties were extracted successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageProperties image_properties_annotation = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.ImageProperties,
            com.google.cloud.vision.v1p3beta1.ImageProperties.Builder,
            com.google.cloud.vision.v1p3beta1.ImagePropertiesOrBuilder>
        getImagePropertiesAnnotationFieldBuilder() {
      if (imagePropertiesAnnotationBuilder_ == null) {
        imagePropertiesAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.ImageProperties,
                com.google.cloud.vision.v1p3beta1.ImageProperties.Builder,
                com.google.cloud.vision.v1p3beta1.ImagePropertiesOrBuilder>(
                getImagePropertiesAnnotation(), getParentForChildren(), isClean());
        imagePropertiesAnnotation_ = null;
      }
      return imagePropertiesAnnotationBuilder_;
    }

    private com.google.cloud.vision.v1p3beta1.CropHintsAnnotation cropHintsAnnotation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.CropHintsAnnotation,
            com.google.cloud.vision.v1p3beta1.CropHintsAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.CropHintsAnnotationOrBuilder>
        cropHintsAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * If present, crop hints have completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.CropHintsAnnotation crop_hints_annotation = 11;</code>
     */
    public boolean hasCropHintsAnnotation() {
      return cropHintsAnnotationBuilder_ != null || cropHintsAnnotation_ != null;
    }
    /**
     *
     *
     * <pre>
     * If present, crop hints have completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.CropHintsAnnotation crop_hints_annotation = 11;</code>
     */
    public com.google.cloud.vision.v1p3beta1.CropHintsAnnotation getCropHintsAnnotation() {
      if (cropHintsAnnotationBuilder_ == null) {
        return cropHintsAnnotation_ == null
            ? com.google.cloud.vision.v1p3beta1.CropHintsAnnotation.getDefaultInstance()
            : cropHintsAnnotation_;
      } else {
        return cropHintsAnnotationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, crop hints have completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.CropHintsAnnotation crop_hints_annotation = 11;</code>
     */
    public Builder setCropHintsAnnotation(
        com.google.cloud.vision.v1p3beta1.CropHintsAnnotation value) {
      if (cropHintsAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cropHintsAnnotation_ = value;
        onChanged();
      } else {
        cropHintsAnnotationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, crop hints have completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.CropHintsAnnotation crop_hints_annotation = 11;</code>
     */
    public Builder setCropHintsAnnotation(
        com.google.cloud.vision.v1p3beta1.CropHintsAnnotation.Builder builderForValue) {
      if (cropHintsAnnotationBuilder_ == null) {
        cropHintsAnnotation_ = builderForValue.build();
        onChanged();
      } else {
        cropHintsAnnotationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, crop hints have completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.CropHintsAnnotation crop_hints_annotation = 11;</code>
     */
    public Builder mergeCropHintsAnnotation(
        com.google.cloud.vision.v1p3beta1.CropHintsAnnotation value) {
      if (cropHintsAnnotationBuilder_ == null) {
        if (cropHintsAnnotation_ != null) {
          cropHintsAnnotation_ =
              com.google.cloud.vision.v1p3beta1.CropHintsAnnotation.newBuilder(cropHintsAnnotation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          cropHintsAnnotation_ = value;
        }
        onChanged();
      } else {
        cropHintsAnnotationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, crop hints have completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.CropHintsAnnotation crop_hints_annotation = 11;</code>
     */
    public Builder clearCropHintsAnnotation() {
      if (cropHintsAnnotationBuilder_ == null) {
        cropHintsAnnotation_ = null;
        onChanged();
      } else {
        cropHintsAnnotation_ = null;
        cropHintsAnnotationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, crop hints have completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.CropHintsAnnotation crop_hints_annotation = 11;</code>
     */
    public com.google.cloud.vision.v1p3beta1.CropHintsAnnotation.Builder
        getCropHintsAnnotationBuilder() {

      onChanged();
      return getCropHintsAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If present, crop hints have completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.CropHintsAnnotation crop_hints_annotation = 11;</code>
     */
    public com.google.cloud.vision.v1p3beta1.CropHintsAnnotationOrBuilder
        getCropHintsAnnotationOrBuilder() {
      if (cropHintsAnnotationBuilder_ != null) {
        return cropHintsAnnotationBuilder_.getMessageOrBuilder();
      } else {
        return cropHintsAnnotation_ == null
            ? com.google.cloud.vision.v1p3beta1.CropHintsAnnotation.getDefaultInstance()
            : cropHintsAnnotation_;
      }
    }
    /**
     *
     *
     * <pre>
     * If present, crop hints have completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.CropHintsAnnotation crop_hints_annotation = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.CropHintsAnnotation,
            com.google.cloud.vision.v1p3beta1.CropHintsAnnotation.Builder,
            com.google.cloud.vision.v1p3beta1.CropHintsAnnotationOrBuilder>
        getCropHintsAnnotationFieldBuilder() {
      if (cropHintsAnnotationBuilder_ == null) {
        cropHintsAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.CropHintsAnnotation,
                com.google.cloud.vision.v1p3beta1.CropHintsAnnotation.Builder,
                com.google.cloud.vision.v1p3beta1.CropHintsAnnotationOrBuilder>(
                getCropHintsAnnotation(), getParentForChildren(), isClean());
        cropHintsAnnotation_ = null;
      }
      return cropHintsAnnotationBuilder_;
    }

    private com.google.cloud.vision.v1p3beta1.WebDetection webDetection_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.WebDetection,
            com.google.cloud.vision.v1p3beta1.WebDetection.Builder,
            com.google.cloud.vision.v1p3beta1.WebDetectionOrBuilder>
        webDetectionBuilder_;
    /**
     *
     *
     * <pre>
     * If present, web detection has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.WebDetection web_detection = 13;</code>
     */
    public boolean hasWebDetection() {
      return webDetectionBuilder_ != null || webDetection_ != null;
    }
    /**
     *
     *
     * <pre>
     * If present, web detection has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.WebDetection web_detection = 13;</code>
     */
    public com.google.cloud.vision.v1p3beta1.WebDetection getWebDetection() {
      if (webDetectionBuilder_ == null) {
        return webDetection_ == null
            ? com.google.cloud.vision.v1p3beta1.WebDetection.getDefaultInstance()
            : webDetection_;
      } else {
        return webDetectionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, web detection has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.WebDetection web_detection = 13;</code>
     */
    public Builder setWebDetection(com.google.cloud.vision.v1p3beta1.WebDetection value) {
      if (webDetectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        webDetection_ = value;
        onChanged();
      } else {
        webDetectionBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, web detection has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.WebDetection web_detection = 13;</code>
     */
    public Builder setWebDetection(
        com.google.cloud.vision.v1p3beta1.WebDetection.Builder builderForValue) {
      if (webDetectionBuilder_ == null) {
        webDetection_ = builderForValue.build();
        onChanged();
      } else {
        webDetectionBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, web detection has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.WebDetection web_detection = 13;</code>
     */
    public Builder mergeWebDetection(com.google.cloud.vision.v1p3beta1.WebDetection value) {
      if (webDetectionBuilder_ == null) {
        if (webDetection_ != null) {
          webDetection_ =
              com.google.cloud.vision.v1p3beta1.WebDetection.newBuilder(webDetection_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          webDetection_ = value;
        }
        onChanged();
      } else {
        webDetectionBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, web detection has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.WebDetection web_detection = 13;</code>
     */
    public Builder clearWebDetection() {
      if (webDetectionBuilder_ == null) {
        webDetection_ = null;
        onChanged();
      } else {
        webDetection_ = null;
        webDetectionBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, web detection has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.WebDetection web_detection = 13;</code>
     */
    public com.google.cloud.vision.v1p3beta1.WebDetection.Builder getWebDetectionBuilder() {

      onChanged();
      return getWebDetectionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If present, web detection has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.WebDetection web_detection = 13;</code>
     */
    public com.google.cloud.vision.v1p3beta1.WebDetectionOrBuilder getWebDetectionOrBuilder() {
      if (webDetectionBuilder_ != null) {
        return webDetectionBuilder_.getMessageOrBuilder();
      } else {
        return webDetection_ == null
            ? com.google.cloud.vision.v1p3beta1.WebDetection.getDefaultInstance()
            : webDetection_;
      }
    }
    /**
     *
     *
     * <pre>
     * If present, web detection has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.WebDetection web_detection = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.WebDetection,
            com.google.cloud.vision.v1p3beta1.WebDetection.Builder,
            com.google.cloud.vision.v1p3beta1.WebDetectionOrBuilder>
        getWebDetectionFieldBuilder() {
      if (webDetectionBuilder_ == null) {
        webDetectionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.WebDetection,
                com.google.cloud.vision.v1p3beta1.WebDetection.Builder,
                com.google.cloud.vision.v1p3beta1.WebDetectionOrBuilder>(
                getWebDetection(), getParentForChildren(), isClean());
        webDetection_ = null;
      }
      return webDetectionBuilder_;
    }

    private com.google.cloud.vision.v1p3beta1.ProductSearchResults productSearchResults_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.ProductSearchResults,
            com.google.cloud.vision.v1p3beta1.ProductSearchResults.Builder,
            com.google.cloud.vision.v1p3beta1.ProductSearchResultsOrBuilder>
        productSearchResultsBuilder_;
    /**
     *
     *
     * <pre>
     * If present, product search has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchResults product_search_results = 14;</code>
     */
    public boolean hasProductSearchResults() {
      return productSearchResultsBuilder_ != null || productSearchResults_ != null;
    }
    /**
     *
     *
     * <pre>
     * If present, product search has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchResults product_search_results = 14;</code>
     */
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults getProductSearchResults() {
      if (productSearchResultsBuilder_ == null) {
        return productSearchResults_ == null
            ? com.google.cloud.vision.v1p3beta1.ProductSearchResults.getDefaultInstance()
            : productSearchResults_;
      } else {
        return productSearchResultsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, product search has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchResults product_search_results = 14;</code>
     */
    public Builder setProductSearchResults(
        com.google.cloud.vision.v1p3beta1.ProductSearchResults value) {
      if (productSearchResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        productSearchResults_ = value;
        onChanged();
      } else {
        productSearchResultsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, product search has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchResults product_search_results = 14;</code>
     */
    public Builder setProductSearchResults(
        com.google.cloud.vision.v1p3beta1.ProductSearchResults.Builder builderForValue) {
      if (productSearchResultsBuilder_ == null) {
        productSearchResults_ = builderForValue.build();
        onChanged();
      } else {
        productSearchResultsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, product search has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchResults product_search_results = 14;</code>
     */
    public Builder mergeProductSearchResults(
        com.google.cloud.vision.v1p3beta1.ProductSearchResults value) {
      if (productSearchResultsBuilder_ == null) {
        if (productSearchResults_ != null) {
          productSearchResults_ =
              com.google.cloud.vision.v1p3beta1.ProductSearchResults.newBuilder(
                      productSearchResults_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          productSearchResults_ = value;
        }
        onChanged();
      } else {
        productSearchResultsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, product search has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchResults product_search_results = 14;</code>
     */
    public Builder clearProductSearchResults() {
      if (productSearchResultsBuilder_ == null) {
        productSearchResults_ = null;
        onChanged();
      } else {
        productSearchResults_ = null;
        productSearchResultsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, product search has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchResults product_search_results = 14;</code>
     */
    public com.google.cloud.vision.v1p3beta1.ProductSearchResults.Builder
        getProductSearchResultsBuilder() {

      onChanged();
      return getProductSearchResultsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If present, product search has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchResults product_search_results = 14;</code>
     */
    public com.google.cloud.vision.v1p3beta1.ProductSearchResultsOrBuilder
        getProductSearchResultsOrBuilder() {
      if (productSearchResultsBuilder_ != null) {
        return productSearchResultsBuilder_.getMessageOrBuilder();
      } else {
        return productSearchResults_ == null
            ? com.google.cloud.vision.v1p3beta1.ProductSearchResults.getDefaultInstance()
            : productSearchResults_;
      }
    }
    /**
     *
     *
     * <pre>
     * If present, product search has completed successfully.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ProductSearchResults product_search_results = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.ProductSearchResults,
            com.google.cloud.vision.v1p3beta1.ProductSearchResults.Builder,
            com.google.cloud.vision.v1p3beta1.ProductSearchResultsOrBuilder>
        getProductSearchResultsFieldBuilder() {
      if (productSearchResultsBuilder_ == null) {
        productSearchResultsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.ProductSearchResults,
                com.google.cloud.vision.v1p3beta1.ProductSearchResults.Builder,
                com.google.cloud.vision.v1p3beta1.ProductSearchResultsOrBuilder>(
                getProductSearchResults(), getParentForChildren(), isClean());
        productSearchResults_ = null;
      }
      return productSearchResultsBuilder_;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * If set, represents the error message for the operation.
     * Note that filled-in image annotations are guaranteed to be
     * correct, even when `error` is set.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public boolean hasError() {
      return errorBuilder_ != null || error_ != null;
    }
    /**
     *
     *
     * <pre>
     * If set, represents the error message for the operation.
     * Note that filled-in image annotations are guaranteed to be
     * correct, even when `error` is set.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If set, represents the error message for the operation.
     * Note that filled-in image annotations are guaranteed to be
     * correct, even when `error` is set.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
        onChanged();
      } else {
        errorBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, represents the error message for the operation.
     * Note that filled-in image annotations are guaranteed to be
     * correct, even when `error` is set.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
        onChanged();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, represents the error message for the operation.
     * Note that filled-in image annotations are guaranteed to be
     * correct, even when `error` is set.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (error_ != null) {
          error_ = com.google.rpc.Status.newBuilder(error_).mergeFrom(value).buildPartial();
        } else {
          error_ = value;
        }
        onChanged();
      } else {
        errorBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, represents the error message for the operation.
     * Note that filled-in image annotations are guaranteed to be
     * correct, even when `error` is set.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public Builder clearError() {
      if (errorBuilder_ == null) {
        error_ = null;
        onChanged();
      } else {
        error_ = null;
        errorBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, represents the error message for the operation.
     * Note that filled-in image annotations are guaranteed to be
     * correct, even when `error` is set.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {

      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If set, represents the error message for the operation.
     * Note that filled-in image annotations are guaranteed to be
     * correct, even when `error` is set.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * If set, represents the error message for the operation.
     * Note that filled-in image annotations are guaranteed to be
     * correct, even when `error` is set.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private com.google.cloud.vision.v1p3beta1.ImageAnnotationContext context_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.ImageAnnotationContext,
            com.google.cloud.vision.v1p3beta1.ImageAnnotationContext.Builder,
            com.google.cloud.vision.v1p3beta1.ImageAnnotationContextOrBuilder>
        contextBuilder_;
    /**
     *
     *
     * <pre>
     * If present, contextual information is needed to understand where this image
     * comes from.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageAnnotationContext context = 21;</code>
     */
    public boolean hasContext() {
      return contextBuilder_ != null || context_ != null;
    }
    /**
     *
     *
     * <pre>
     * If present, contextual information is needed to understand where this image
     * comes from.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageAnnotationContext context = 21;</code>
     */
    public com.google.cloud.vision.v1p3beta1.ImageAnnotationContext getContext() {
      if (contextBuilder_ == null) {
        return context_ == null
            ? com.google.cloud.vision.v1p3beta1.ImageAnnotationContext.getDefaultInstance()
            : context_;
      } else {
        return contextBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, contextual information is needed to understand where this image
     * comes from.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageAnnotationContext context = 21;</code>
     */
    public Builder setContext(com.google.cloud.vision.v1p3beta1.ImageAnnotationContext value) {
      if (contextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        context_ = value;
        onChanged();
      } else {
        contextBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, contextual information is needed to understand where this image
     * comes from.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageAnnotationContext context = 21;</code>
     */
    public Builder setContext(
        com.google.cloud.vision.v1p3beta1.ImageAnnotationContext.Builder builderForValue) {
      if (contextBuilder_ == null) {
        context_ = builderForValue.build();
        onChanged();
      } else {
        contextBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, contextual information is needed to understand where this image
     * comes from.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageAnnotationContext context = 21;</code>
     */
    public Builder mergeContext(com.google.cloud.vision.v1p3beta1.ImageAnnotationContext value) {
      if (contextBuilder_ == null) {
        if (context_ != null) {
          context_ =
              com.google.cloud.vision.v1p3beta1.ImageAnnotationContext.newBuilder(context_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          context_ = value;
        }
        onChanged();
      } else {
        contextBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, contextual information is needed to understand where this image
     * comes from.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageAnnotationContext context = 21;</code>
     */
    public Builder clearContext() {
      if (contextBuilder_ == null) {
        context_ = null;
        onChanged();
      } else {
        context_ = null;
        contextBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, contextual information is needed to understand where this image
     * comes from.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageAnnotationContext context = 21;</code>
     */
    public com.google.cloud.vision.v1p3beta1.ImageAnnotationContext.Builder getContextBuilder() {

      onChanged();
      return getContextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If present, contextual information is needed to understand where this image
     * comes from.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageAnnotationContext context = 21;</code>
     */
    public com.google.cloud.vision.v1p3beta1.ImageAnnotationContextOrBuilder getContextOrBuilder() {
      if (contextBuilder_ != null) {
        return contextBuilder_.getMessageOrBuilder();
      } else {
        return context_ == null
            ? com.google.cloud.vision.v1p3beta1.ImageAnnotationContext.getDefaultInstance()
            : context_;
      }
    }
    /**
     *
     *
     * <pre>
     * If present, contextual information is needed to understand where this image
     * comes from.
     * </pre>
     *
     * <code>.google.cloud.vision.v1p3beta1.ImageAnnotationContext context = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vision.v1p3beta1.ImageAnnotationContext,
            com.google.cloud.vision.v1p3beta1.ImageAnnotationContext.Builder,
            com.google.cloud.vision.v1p3beta1.ImageAnnotationContextOrBuilder>
        getContextFieldBuilder() {
      if (contextBuilder_ == null) {
        contextBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vision.v1p3beta1.ImageAnnotationContext,
                com.google.cloud.vision.v1p3beta1.ImageAnnotationContext.Builder,
                com.google.cloud.vision.v1p3beta1.ImageAnnotationContextOrBuilder>(
                getContext(), getParentForChildren(), isClean());
        context_ = null;
      }
      return contextBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1p3beta1.AnnotateImageResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1p3beta1.AnnotateImageResponse)
  private static final com.google.cloud.vision.v1p3beta1.AnnotateImageResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1p3beta1.AnnotateImageResponse();
  }

  public static com.google.cloud.vision.v1p3beta1.AnnotateImageResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnnotateImageResponse> PARSER =
      new com.google.protobuf.AbstractParser<AnnotateImageResponse>() {
        @java.lang.Override
        public AnnotateImageResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AnnotateImageResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<AnnotateImageResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnnotateImageResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1p3beta1.AnnotateImageResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
